﻿/**
 * @fileOverview ESTK用　プリファレンスの読み込みと保存
 *<pre>
 * 保存するオブジェクトをそれぞれ１ファイルで設定フォルダへテキストで保存する
 * 拡張子は.pref
 * ファイル名はオブジェクト名をそのまま利用
 * 例: nas.inputMedias.body.pref 等
 * プリファレンスとして保存するオブジェクトはこのファイルの設定として固定
 * 読み込みは記録フォルダの内部を検索してオブジェクトの存在するもの全て
 * 新規のオブジェクトは作成しない
 * 乙女のローカルで作成したファンクションをadobeライブラリ（ESTK）全体へ拡張
 * あとで乙女の部当該分を換装すること
 *
 * ホストアプリケーション別の切り分けを組み込んで、ファイルを共用に変更
 *</pre>
 * @todo ただし、アプリケーションごとのプロパティの切り分けは別ファイルの方が望ましいので、次の機会に各ホストごとの設定ファイルへ移行の予定
 *  2016.05.31
 *photoshopで動作不正を起こしていた部分を修正
 *  2016.06.22
 */
'use strict';
/** Folder　オブジェクトにnasライブラリのパスをアタッチ
 * @constant   {String} nas.baseLocation
 */
Folder.nas = nas.baseLocation;
nas.preferenceFolder=new Folder(Folder.userData.fullName+"/nas/lib/etc");//保存場所固定

/**
 *  設定フォルダから指定のオブジェクトを読み出して設定する<br />
 *  (ESTK)
 * @function
 * @param {String} myPropName
 *  読み出すオブジェクト名
 */

nas.readPreference = function(myPropName){
// 未指定の場合はすべて("*")の記録データを取得
	if(! myPropName) myPropName="*";
	var myPrefFiles=this.preferenceFolder.getFiles(myPropName+".pref");
	if(myPrefFiles.length > 0) myPrefFiles.sort();
	for(var idx=0;idx<myPrefFiles.length;idx++){
		var prpName=myPrefFiles[idx].name.replace(/\.pref$/,"").split('.');
			var prp ;
		for(var i = 0 ; i < prpName.length ; i ++){
			prp = eval(prpName.slice(0,i));
			if(typeof prp == 'undefined') break;
		};
		if(typeof prp == 'undefined') continue;
/*
		try{
			prp = eval(prp);
		}catch(err){
			alert(prp);
			alert(err);
			continue;
		};// */
		
		if(typeof prop != 'undefined'){
			var myOpenFile=new File(myPrefFiles[idx].fsName);
			var canRead=myOpenFile.open("r");
			if(canRead){
				myOpenFile.encoding="UTF-8";
				var myContent=myOpenFile.read();
				myOpenFile.close();
				if(nas.otome) nas.otome.writeConsole(myContent);
				if(myContent.length == 0) continue;
				if(prp instanceof Array){
					eval(prpName.join('.') + "= ("+myContent+");");
				}else if(myPropName[myPropName.length-1] == "selected" ){
					eval(myPropName.slice(0,-1).join('.') + ".select("+myContent+")");
				}else if(prp.parse instanceof Function){
					prp.parse(myContent);
                }else if(prp.setValue instanceof Function){
					prp.setValue(myContent);
				}else if(myContent.match(/^\(new\s.*\(/)){
					eval(prpName.join('.') + "= ( " + myContent + " )");
                }else if(isNaN(myContent)){
//数値以外たぶん文字列
					eval(prpName.join('.') + "= ( " + myContent + " )");
				}else{
					try{
						eval(prpName.join('.') + "= JSON.parse( " + myContent + " )");
					}catch(err){
						eval (prpName.join('.') + "= ( "+ myContent+ " )");
					};
				};
			};
		}else{
			if(nas.otome){nas.otome.writeConsole("cannot Replace prop "+prpName.join('.'));}
		};
	};
};// */
/*
	root.pmdbをファイルから取得 AdobeESTK環境用
*/
/*
nas.readPmdb = function(){
	var myPrefFiles=this.preferenceFolder.getFiles(myPropName+".pref");
	for(var idx=0;idx<myPrefFiles.length;idx++)
	{
		var myPropName=myPrefFiles[idx].name.replace(/\.pref$/,"");
		try{myProp=eval(myPropName);}catch(er){
				alert(myPropName +"if  not Exists. loading aborted");
				continue;
			}
		if(eval(myPropName)){
			var myOpenFile=new File(myPrefFiles[idx].fsName);
			var canRead=myOpenFile.open("r");
			if(canRead){
				myOpenFile.encoding="UTF-8";
				var myContent=myOpenFile.read();
				myOpenFile.close();
				if(nas.otome){nas.otome.writeConsole(myContent);}
				if(myContent.match(/\(new\sNumber\(([0-9\.]+)\)\)/)){
					myContent=myContent.replace(/\(new\sNumber(\([0-9\.]+\))\)/g,RegExp.$1);
					if(
						(myPropName.match(/(.*[^\.])\.selected/))&&
						(eval(RegExp.$1+"  instanceof nTable"))
					){
						eval(RegExp.$1 +".select\("+myContent+"\)");
					}else{
						eval(myPropName +" =("+myContent+")");
					}
				}else{
					if(myContent.match(/\(new\sString\((.+)\)\)/)){
						myContent=myContent.replace(/\(new\sString(\(.+)\)\)/g,RegExp.$1);
						eval(myPropName +" ="+myContent);
					}else{
						if(nas.otome){
							nas.otome.writeConsole(myPropName +" = eval("+myContent+")");
						}
						eval(myPropName +" =eval("+myContent+")");
					}
				}
			}
		}else{
			if(nas.otome){nas.otome.writeConsole("cannot Replace prop "+myPropName);}
		}
	}
};//*

/*

*/
nas.writePreference=function(myPrefs){
	if(typeof myPrefs == "undefined"){myPrefs=[]};
	if(!(myPrefs instanceof Array)){myPrefs=[myPrefs]};//配列に
	if(myPrefs.length==0){
//試験用あとで調整
		myPrefs=[
			"nas.registerMarks.bodys",
					"nas.registerMarks.selected",
			"nas.inputMedias.bodys",
					"nas.inputMedias.selected",
			"nas.outputMedias.bodys",
					"nas.outputMedias.selected",
			"nas.workTitles.bodys",
				"nas.workTitles.selected",
			"nas.CURRENTUSER",
			"nas.RESOLUTION",
			"nas.FRATE",
			"nas.SheetLength",
			"nas.importFilter",
			"nas.cellRegex",
			"nas.bgRegex",
			"nas.mgRegex",
			"nas.loRegex"
		];
		if(typeof isAdobe== "undefined"){var isAdobe=(app)?true:false};
		if(isAdobe){
//AE専用
			if(app.name.indexOf("AfterEffects")>0){
				myPrefs.push("nas.expressions");
//				"nas.ftgFolders"
			}
//PS専用
			if(app.name.indexOf("Photoshop")>0){
				myPrefs.push("nas.axe");
			}
		}
	}
	if(this.preferenceFolder.exists){
		for(var idx=0;idx<myPrefs.length;idx++){
			var myProp = eval(myPrefs[idx]);
			if(typeof myProp == "undefined") continue;
			var myContent = "";
//オブジェクトの存在をチェック
			if(myProp instanceof RegExp){
//正規表現指定をより分けて処理
				myContent=eval(myPrefs[idx]+".toString()");
				if(myContent.match(/\/([ig]+)$/)){
					var myRegOpt=RegExp.$1;
				}else{
					var myRegOpt="";
				}
				var myContentBody=myContent.slice(1,myContent.length-myRegOpt.length-1).replace(/\\/g,"\\\\");
				myContent="\(new RegExp\(\""+myContentBody+"\",\""+myRegOpt+"\"\)\)";
			}else if(myProp instanceof nas.UserInfo){
//UserInfo
				myContent = [myProp.handle,myProp.email].join(':');
			}else if(myPrefs[idx].indexOf("SheetLength") > 0){
//SheetLength
				myContent = nas.SheetLength;// / nas.FRATE;
			}else if(myProp instanceof Array){
//配列
				myContent = JSON.stringify(myProp)
			}else if(
				(myProp.parse    instanceof Function)||
				(myProp.setValue instanceof Function)
			){
				myContent = myProp.toString();
			}else{
				myContent = myProp.toSource();
			}

			var myFileName=myPrefs[idx]+".pref"
			if(nas.otome){nas.otome.writeConsole(myContent);}
			var myOpenFile=new File(this.preferenceFolder.path+"/"+this.preferenceFolder.name+"/"+myFileName);
			var canWrite=myOpenFile.open("w");
			if(canWrite){
				if(nas.otome){nas.otome.writeConsole(myOpenFile.fsName);}
				myOpenFile.encoding="UTF-8";
				myOpenFile.write(myContent);
				myOpenFile.close();
			}else{
				var msg=myOpenFile.fsName+nas.localize({en:": It failed to write",ja:": これなんか書けないカンジ"});
				if(nas.otome){nas.otome.writeConsole(msg)}else{alert(msg)}
			};//ファイルが既存かとか調べない うほほ
;// */
		}
	};//else{alert("QQQQQQ")}
}
//nas.writePreference();
/*
	個人情報をクリアする。最後に再初期化を促すメッセージを出力
*/
nas.cleraPreference=function(){
/*	023
 * var msg="個人領域に記録した情報をすべてクリアします。"+nas.GUI.LineFeed;
 *	msg+="nasライブラリを使用するすべてのアプリケーションの情報をクリアしますので、"+nas.GUI.LineFeed;
 *	msg+="AEとPSでnasライブラリを使用している方は特にご注意ください。"+nas.GUI.LineFeed;
 *	msg+="クリアして良いですか？"+nas.GUI.LineFeed;
 */
 var msg=nas.localize(nas.uiMsg.dm023);

 var doFlag=confirm(msg);
	
  if((doFlag)&&(this.preferenceFolder.exists)&&(! (this.preferenceFolder.readonly)))
  {
	var myPrefFiles=this.preferenceFolder.getFiles("*.pref");
	var clearCount=0;
	if (myPrefFiles.length){
	 for(var idx=0;idx<myPrefFiles.length;idx++)
	 {
		   try{myPrefFiles[idx].remove();clearCount++;}catch(er){continue;}
	 }
//024
/*
個人領域に記録した情報 :%COUNT% 個のデータをクリアしました。
現在の情報は、メモリ上にあります。\nデータはアプリケーション再起動の際に初期化されます。
初期化を希望する場合は、保存せずにアプリケーションを再起動してください。"
*/
	 msg=nas.localize(nas.uiMsg.dm024,clearCount);//
	}else{
//no data
  msg=nas.localize(nas.uiMsg.noRemoveData);//"消去するデータがありませんでした"
	}
	alert(msg);
  };//else{alert("GOGO")}
}
//nas.clearPreference();

/*nas.importPreference(myFolder)
引数:ターゲットフォルダ　指定のない場合はフォルダターゲットを取得
戻値: インポート成功時はtrue失敗時はfalse
外部供給されたプリファレンスを個人領域に取り込むメソッド
*/
nas.importPreference = function(myFolder){
	var goFlag=true;
	if(typeof myFolder !="Folder"){
		var myMsg=nas.localize(nas.uiMsg.dm025);//"インポートする設定のあるフォルダを指定して下さい";
		myFolder=Folder.selectDialog(myMsg);
		if(myFolder){
			myMsg=myFolder.fullName + nas.localize(nas.uiMsg.dm027);//027":\n上のフォルダの設定をインポートします。\n同名の設定は上書きされて取り消しはできません\n実行してよろしいですか？"
			goFlag=confirm(myMsg);
		}
	}
	if(goFlag){
		var currentPrefFolder=nas.preferenceFolder;
		nas.preferenceFolder=myFolder;//設定
		nas.readPreference();//全て読む
		nas.preferenceFolder=currentPrefFolder;//復帰
		nas.writePreference();//書き込む
	}
}
/*nas.exportPreference(myFolder)
引数:ターゲットフォルダ　指定のない場合はフォルダターゲットを取得
戻値: インポート成功時はtrue失敗時はfalse
プリファレンス書き出しメソッド
*/
nas.exportPreference = function(myFolder){
	var goFlag=true;
	if(typeof myFolder !="Folder"){
		var myMsg=nas.localize(nas.uiMsg.dm026);//"設定を書き出すフォルダを指定して下さい";
		myFolder=Folder.selectDialog(myMsg);
		if(myFolder){
			myMsg=myFolder.fullName + nas.localize(nas.uiMsg.dm028);//028":\n上のフォルダに設定をエクスポートします。\n空きフォルダ推奨します\n実行してよろしいですか？"
			goFlag=confirm(myMsg);
		}
	}
	if(goFlag){
		var currentPrefFolder=nas.preferenceFolder;
		nas.preferenceFolder=myFolder;//設定
		nas.writePreference();//書き込む
		nas.preferenceFolder=currentPrefFolder;//復帰
	}
}