﻿/*
	phosothop専用仮設セクションパーサ試験を兼ねて
	TVP書き戻し用仮設スクリプト

	セクションのビルドを行ってレイヤを複製リネームする
	
*/
//*Photoshop用ライブラリ読み込み
if(typeof app.nas =="undefined"){
   var myLibLoader=new File(Folder.userData.fullName+"/nas/lib/Photoshop_Startup.jsx");
   $.evalFile(myLibLoader);
}else{
   nas=app.nas;
}
//+++++++++++++++++++++++++++++++++ここまで共用
if(typeof isWindows =="undefined"){var isWindows=($.os.indexOf("Win")==0)?true:false;};
/*	暫定ローダー
これが必要なのはCSX(CS6)Photoshopのみ
	ライブラリの整理後は調整必要	2015 06-12
*/
//処理条件判定
/*
	ドキュメントが存在する
	対照ドキュメントと同名のXPSデータが存在する
	振分済で少なくともレイヤセットが存在する
	未処理である(レイヤセットの名称が"[\d+]"で開始されている)	
*/
var EXFlag=true;
try{
	var TargetDocument=app.activeDocument;
	var myTargetXPS=new File((app.activeDocument.path.fullName+"/"+ app.activeDocument.name).replace(/psd$/i,"xps"));

	EXFlag=(TargetDocument.layers.length)?false:true;
	EXFlag=myTargetXPS.exists;
	EXFlag=(TargetDocument.layerSets.length)?true:false;
	EXFlag=(TargetDocument.layerSets[0].name.match(/^\[\d+\]/))?false:true;
}catch(er){
	EXFlag=false;
}
		if(! EXFlag){
	alert("処理対象のデータが無いか、または処理済みです");
		}else{
// テキストレイヤに使用するフォント
var dialogFont="UDShinMGoPr6N-Light";
/*
	XPS用簡易ダイアログ他音声トラックパーサ

	音声系トラックのパースを行いセクションコレクションを戻すアルゴリズム
	単純
	データ列を順次チェック
	MAPへの問い合わせは基本的に無し
*/
/*
簡易オブジェクトで実装
エレメントのラップもしない

nas.AnimationSound Object
　同名のオブジェクトとの互換はあまり考えない
　名前が同じだけと思うが吉
　タイムシートサウンドトラックの値となる
　外部ファイルリンクはこの際割愛
bodyStream();	タイムシート内のストリームをテキストで取り出す（メソッド）
contentText;	String	内容テキスト原文
name;	String	ラベルとなる名称
bodyText;	String	
attributes;	Array	オブジェクト属性配列
comments;	Array	ノートコメントコレクション配列


*/
nas.AnimationSound=function(myContent){
//	this.source;
//	this.duration;
//	this.startOffset;
	this.contentText=myContent;
	this.name="";
	this.bodyText="";
	this.attributes=[];
	this.comments=[];
}
//
/*
	初期化時の内容テキスト（シナリオ型式）をパースしてオブジェクト化するメソッド
	本来は自動実行だが、今回は必要に従ってコールする
*/
nas.AnimationSound.prototype.parseContent=function(){
	if(this.contentText.length){
		if(this.contentText.match(/^([^"'「]*)["'「]([^"'」]*)["'」]?$/)){ ;//"
			this.name=RegExp.$1;
			this.bodyText=RegExp.$2;
		}else{
			this.name="";
			this.bodyText=this.contentText;
		}
		var myAttributes=this.name.match(/\([^)]+\)/g)
		if(myAttributes){
			this.attributes=myAttributes;
			this.name=this.name.replace(/\([^)]+\)/g,"");
		}
		var myComments=this.bodyText.match(/(<[^<>]+>|\[[^\[\]]+\]|\([^\(\)]+\))/g);
		if(myComments){
			this.comments=[];//newArray
			var myString=this.bodyText;
			for (var cix=0;cix<myComments.length;cix++){
				if(cix==0){
					var prevIndex=0;
				}else{
					var prevIndex=parseInt(this.comments[this.comments.length-1][0]);					
				}
				this.comments.push([prevIndex+myString.indexOf(myComments[cix]),myComments[cix]]);
				myString=this.bodyText.slice(prevIndex+this.comments[this.comments.length-1][0]+this.comments[this.comments.length-1][1].length);
			}
			this.bodyText=this.bodyText.replace(/(<[^<>]+>|\[[^\[\]]+\]|\([^\(\)]+\))/g,"");
		}
		return this.toString();
	}else{return false;}	
}
/*
プロパティを組み上げてシナリオ型式のテキストを返す
*/
nas.AnimationSound.prototype.toString=function(){
	var myResult=this.name;
	myResult+=this.attributes.join("");
	myResult+="「";
	var startPt=0;
	if(this.comments.length){var endPt=this.comments[0][0]}else{var endPt=0};
for(var cix=0;cix<this.comments.length;cix++){
	myResult+=this.bodyText.slice(startPt,endPt)+this.comments[cix][1];
	startPt=endPt;
	if(cix<this.comments.length-1){endPt=this.comments[cix+1][0]};
}
if(startPt<this.bodyText.length){myResult+=this.bodyText.slice(startPt)};
	myResult+="」";
 return myResult;
}
/*
	本体プロパティからデータ配列を返す　引数でヘッダかボディを選択

	セクションがこの戻り値を受けて整形して出力を行う
	
	ボディストリームは、継続時間内にコンテンツを配置したストリームで返す
	マージンは自動配置で、先頭から（残処理分の）平均マージン（切り捨て）を加えた間隔で１セルあたり１文字配置
	コメント類は１セルに置く
	ボディデータの前後関係は保持
	表示マージンが不足している場合は、とりあえず継続時間を延長 　2016.05.29
*/
nas.AnimationSound.prototype.toStream=function(myType,myDuration){
	if(typeof myType=="undefined"){myType="body"};//body,header,
	var myResult=[];

	if(myType=="header"){
		myResult.push(this.name);
		myResult = myResult.concat(this.attributes);
		myResult.push("----");
	}
	if(myType=="body"){	
		var startPt=0;
		var bodyElements=[];
		//配置フレーム数は引数で与えることが出来る
		//平均マージンは　Math.floor((残フレーム-残文字数)/残文字数)
		if(this.comments.length){var endPt=this.comments[0][0]}else{var endPt=0};
		for(var cix=0;cix<this.comments.length;cix++){
			bodyElements=bodyElements.concat(this.bodyText.slice(startPt,endPt).split(""));
			bodyElements.push(this.comments[cix][1]);
			startPt=endPt;
			if(cix<this.comments.length-1){endPt=this.comments[cix+1][0]};
		}
		if(startPt<this.bodyText.length){bodyElements=bodyElements.concat(this.bodyText.slice(startPt).split(""))};
		//　作成したbody配列をマージン付きに再配置
		if (typeof myDuration == "undefined") myDuration=0;
		myDuration=(myDuration<bodyElements.length)?bodyElements.length:myDuration;
		for (var eix=0;eix<bodyElements.length;eix++){
			var restFrames=myDuration-myResult.length;
			myResult.push(bodyElements[eix]);
			var marginLength=Math.floor((restFrames-(bodyElements.length-eix))/(bodyElements.length-eix));
			if(marginLength>0) myResult=myResult.concat(new Array(marginLength));
		}
	}
//	if(myType=="body") myResult.push("----");
return myResult;
}
//	test
//A=new  nas.AnimationSound("たぬきさん(off)「ぽん！(SE:ポン)ぽこ！<BGM:開始>りん！[光る]」");
//A.parseContent();
//A.toStream("body",24);

//タイムラインをダイアログパースする
/*
	引数は、ストリーム文字列又は配列
	配列は１次のみ
	音響開始マーカーのために、本来XPSのプロパティを確認しないといけないが、
	今回は省略
	開始マーカーは省略不可でフレーム０からしか位置できない（＝音響の開始は第１フレームから）
	後から仕様に合わせて再実装
	判定内容は
	/^[-_]{3,4}$/	開始・終了マーカー
	/^\([^\)]+\)$|^<[^>]+>$|^\[[^\]]+\]$/	インラインコメント
	その他は
	ブランク中ならばラベル
	音響Object区間ならばコンテントテキストに積む　空白は無視する
	⇒セリフ中の空白は消失するので、空白で調整をとっている台詞は不可
	オリジナルとの照合が必要な場合は本文中の空白を削除した状態で評価すること
	
*/
parseSoundTrack =function(myStream){
	if(!(myStream instanceof Array)){myStream=myStream.split(",")};
	var myResultTL=new XpsTimelineTrack("temp","dialog");
	//この実装では開始マーカーが０フレームにしか位置できないので必ずブランクセクションが発生する
	//継続時間０で先に作成 同時にカラのサウンドObjectを生成
	var currentSection=myResultTL.addSection(false);
	var currentSound=new nas.AnimationSound("");//コンテンツはカラで初期化も保留
	for (var fix=0;fix<myStream.length;fix++){
		currentSection.duration ++;//currentセクションの継続長を加算
		//未記入データ　これが一番多いので最初に処理しておく
		if(myStream[fix]==""){
			continue;
		}
		//括弧でエスケープされたコメント又は属性
		if(myStream[fix].match(/^\([^\)]+\)$|^<[^>]+>$|^\[[^\]]+\]$/)){
			if(currentSection.value){
				currentSound.comments.push([currentSound.bodyText.length,RegExp.$1]);
			}else{
				currentSound.attributes.push(RegExp.$1);
			}
			continue;
		}
		//セクションセパレータ　少ない
		if(myStream[fix].match(/^[-_]{3,4}$/)){
			if(currentSection.value){
				currentSection.duration --;//加算した継続長をキャンセル
				currentSection.value.contentText=currentSound.toString();//先の有値セクションをフラッシュして
				currentSection=myResultTL.addSection(false);//新規のカラセクションを作る
				currentSection.duration ++;//キャンセル分を後方区間に加算
				currentSound=new nas.AnimationSound("");//サウンドを新規作成
			}else{
				currentSection=myResultTL.addSection(currentSound);//新規有値セクション作成
			}
			continue;
		}
//判定を全て抜けたデータは本文又はラベル　ラベルは上書きで更新
		if(currentSection.value){
			if(myStream[fix]=="|") myStream[fix]="ー";
			currentSound.bodyText+=myStream[fix];
		}else{
			currentSound.name=myStream[fix];
		}
	}
	return myResultTL;
}

//	 ダイアログタイムラインからから置きかえタイムラインへ変換したストリームを返すメソッド
/*
	 この置換えタイムラインの扱いを簡略化するために、タイムラインの統合は行なわない
	 台詞ボールドは必ず、トラックごとにレイヤセットを設けること
	 
	 Xpsに台詞用置きかえタイムラインを挿入するのは望ましくないので
	 まず行わない
	 望ましくは、psAxeではダイアログタイムラインのまま台詞ボールドを扱う
	 TVPaint用としては"[layerID][frameNo] _dialog#_-#"レイヤ名を与える
	 このルーチンは内部処理用で外部からコールすることはない（使うと弊害ありそう）
*/

XpsTimelineTrack.prototype.convertReplacement=function(){
	var myResult="";var currentIdx=1;
	for(var ix=0;ix<this.sections.length;ix++){
		currentSectionArray= new Array(this.sections[ix].duration);
		if(this.sections[ix].value){
			currentSectionArray[0]=currentIdx;
			currentIdx++;
		}else{
			currentSectionArray[0]="X";
		}
		myResult+=currentSectionArray.join(",");
	}
	return myResult;
}
//*レイヤフィル
layerFill= function(){
//記録してある色と背景色を照合して、異なっていたら背景色を変更
var myColor=new SolidColor();
	myColor.rgb.red  =Math.floor(nas.axe.lyBgColors[nas.axe.lyBgColor][1][0]*255);
	myColor.rgb.green=Math.floor(nas.axe.lyBgColors[nas.axe.lyBgColor][1][1]*255);
	myColor.rgb.blue =Math.floor(nas.axe.lyBgColors[nas.axe.lyBgColor][1][2]*255);
if (app.backgroundColor!=myColor){app.backgroundColor=myColor};//背景色変更はUNDO対象外
	myColor.opacity  =Math.floor(nas.axe.lyBgColors[nas.axe.lyBgColor][1][3]*100);
//alert(myColor)
	app.activeDocument.selection.selectAll();//全選択
	app.activeDocument.selection.fill(app.backgroundColor,ColorBlendMode.NORMAL,100);
	app.activeDocument.selection.deselect();//解除
}
//*レイヤソート
layerSort= function(revFlag){
	if(! revFlag) revFlag=false;//
//	アクティブレイヤのトレーラーをターゲットにセットする
	var myTarget=activeDocument.activeLayer.parent.layers;
//	並び替え対称のレイヤが1つしかない場合は、並び替え不能なのでキャンセル
	if(myTarget.length<=1){return false;}
//	ソート用配列を作る
	var sortOrder=new Array();
	for (idx=0;idx<myTarget.length;idx++){
		if (myTarget[idx].isBackgroundLayer){
			continue;//レイヤが背景だったら無視
		}else{
			sortOrder.push(myTarget[idx].name);
		}
	}
		sortOrder.sort(	function(a,b){
		a=nas.RZf(a);b=nas.RZf(b);
    	if( a < b ) return -1;
        if( a > b ) return 1;
        return 0;
    });//逆順並び替え
	if (revFlag){
		sortOrder.reverse();//正順並び替え
	}
//並び替えた配列から同名レイヤのチェック
	for (idx=1;idx<sortOrder.length;idx++){
		if(sortOrder[idx-1]==sortOrder[idx]){
			alert(nas.localize(nas.uiMsg.dm015));//"同名のレイヤがあります。\n二つ目以降のレイヤは並び替えの対象になりません。"
			break;
		}
	}
	for (idx=0;idx<sortOrder.length;idx++){
		myTarget.getByName(sortOrder[idx]).move(myTarget[0],ElementPlacement.PLACEBEFORE);
	}
	return sortOrder;
}

//          *XPSコンバータ
/*
データが存在したら、種別判定して、コンバート可能なデータはコンバータに送ってXPS互換ストリームに変換する
Xpxデータが与えられた場合は素通し

この分岐処理は、互換性維持のための分岐

バイナリの判定はできないのでSTS等のバイナリフォーマットは事前にXPSデータ化しておくこと
*/
convertXps=function(datastream){
	if(! datastream.toString().length ){
		return false;
	}else{
switch(true)
{
case	(/^nasTIME-SHEET\ 0\.[1-4]/).test(datastream):;//	判定ルーチン内で先にXPSをチェックしておく（先抜け）
break;
case	(/^UTF\-8\,\ TVPaint\,\ \"CSV 1\.[01]\"/).test(datastream):;//  TVPaint csv
			datastream =TVP2XPS(datastream);
break;
case	(/^\"Frame\",/).test(datastream):;//  Stylos csv
			datastream =StylosCSV2XPS(datastream);//ボタン動作を自動判定にする 2015/09/12 引数は使用せず
break;
case	(/^\{[^\}]*\}/).test(datastream):;//  ARDJ
			try{datastream =ARDJ2XPS(datastream);}catch(err){alert(err);return false};
break;

case	(/^#TimeSheetGrid\x20SheetData/).test(datastream):;//  ARD
			try{datastream =ARD2XPS(datastream);}catch(err){return false}
break;
case	(/^\x22([^\x09]*\x09){25}[^\x09]*/).test(datastream):;//  T-Sheet
			try{datastream =TSH2XPS(datastream);}catch(err){return false}
break;
case	(/^Adobe\ After\ Effects\x20([456]\.[05])\ Keyframe\ Data/).test(datastream):;//AE key-Data
			try{datastream=AEK2XDS(datastream)}catch(err){alert(err);return false}
		xUI.put(datastream);return true;
break;
default :
	if(TSXEx){
		try{datastream=TSX2XPS(datastream)}catch(err){alert(err);return false}
	}
/*
判定アルゴリズム自体は　元の判定ルーチンと同じ
データ内容での判別がほぼ不可能なので、TSX拡張オプションがあって かつ他の判定をすべてすり抜けたデータをTSXデータとみなして変換トライ
*/
}
		if(! datastream){return false}
	}
		return datastream;
}
//*==================================================================main
var XPS=new Xps(4,72);
//
//  XPSのreadINをオーバーライド
XPS.readIN=function(datastream){
	xUI.errorCode=0;//読み込みメソッドが呼ばれたので最終のエラーコードを捨てる。
	if(! datastream.toString().length ){
	  xUI.errorCode=1;return false;
//"001:データ長が0です。読み込みに失敗したかもしれません",
	}else{
//データが存在したら、コンバータに送ってコンバート可能なデータをXPS互換ストリームに変換する
		return this.parseXps(convertXps(datastream));
	}
}

//旧形式のエラーに対応させるためプロパティを付加する　2016.04.13
	XPS.errorCode	=	0;
	XPS.errorMsg=[
"000:最終処理にエラーはありません",
"001:データ長が0です。読み込みに失敗したかもしれません",
"002:どうもすみません。このデータは読めないみたいダ",
"003:読み取るデータがないのです。",
"004:変換すべきデータがありません。¥n処理を中断します。",
"005:MAPデータがありません",
"006:ユーザキャンセル",
"007:",
"008:",
"009:想定外エラー"
];
var isAdobe=true;
nas.XPSStore=new XpsStore();
if(app.documents.length){
//          *代用マップ初期化
var MAP=new Map(3);

//          仮モジュール初期化
 

//	alert(MAP.toSource());
//	*りまぴん互換用xUIダミーオブジェクト初期化
var MSIE=false;
var xUI=new Array();
	xUI.blmtd=BlankMethod;
	xUI.blpos=BlankPosition;
	xUI.timeShift=TimeShift;
	xUI.keyMethod=KEYMethod;
	xUI.aeVersion=AEVersion;
	xUI.fpsF=FootageFramerate;
	xUI.Selection=[0,0];
	xUI.spinValue=3;
	xUI.Select=[1,0];
	xUI.spin=function(sv){this.spinValue=(isNaN(sv))?this.spinValue:sv;};
//	xUI.putメソッドを簡易的に再現しておく
	xUI.put=function(stream){
		for(lyrs=0;lyrs<stream.split("\n").length;lyrs++)
		{
			kyLyr=stream.split("\n")[lyrs].split(",");
			for(frms=0;frms<kyLyr.length;frms++)
			{
				if(lyrs<XPS.xpsBody.length && frms < XPS[0].length)
				{
					XPS[lyrs+1][frms]=kyLyr[frms];
				}
			}
		}
	};
//エラーコードとメッセージは、動作エラー回避のためのダミーオブジェクト
//改修が済んだ時点で削除のこと　XPSにも同内容のオブジェクトあり　20160413
	xUI.errorCode	=	0;
	xUI.errorMsg=[
"000:最終処理にエラーはありません",
"001:データ長が0です。読み込みに失敗したかもしれません",
"002:どうもすみません。このデータは読めないみたいダ",
"003:読み取るデータがないのです。",
"004:変換すべきデータがありません。\n処理を中断します。",
"005:MAPデータがありません",
"006:ユーザキャンセル",
"007:範囲外の指定はできません",
"008:",
"009:想定外エラー"
];

//  *プライマリXPS初期化
/*
	立ち上げ時にXPSオブジェクトがすでに存在する場合は、そのデータを引き継ぐのでここでの初期化は不要
	プロジェクトのＸＰＳバッファはnas立ち上げ時に初期化するのが望ましいと思うよ
 */
try{var myXPS=XPS}catch(err){
	XPS=new Xps(SheetLayers,nas.FCT2Frm(Sheet));
}
//=================================
nas.xpsTrack=function(myLayerSet){
	this.workSet=myLayerSet;//トラック（レイヤセットをそのまま代入する）
	this.content="X";//値オブジェクト　本来は種別ごとの値オブジェクトだが、今回は「カラ」を表す文字列"X"
	this.inPoint=0;//開始オフセットフレーム
	this.duration=function(){
		var myDuration=0;
		for (var ix=0;ix<this.length;ix++){myDuration +=parseInt(this[ix].duration);}
		return myDuration;
	};//現在の継続フレーム数を合計して返す
	this.valueOf=function(){return this.workSet.name;}
	this.add=function(myDuration,myContent){
		var newSection= new nas.xpsSection(this,myDuration,myContent);
		return newSection;//新規のセクションを戻す
	};
	this.section=function(idx){return this[idx];}
}
//区間コレクションとして配列機能を与える
nas.xpsTrack.prototype=Array.prototype;
/*
	A=new nas.xpsSection(myParentTrackOrSection,区間継続フレーム数,値)
	直接コンストラクタを呼ばないでトラックのメソッドで追加すること
*/
nas.xpsSection=function(myParent,myDuration,myValue){
	this.parent=myParent;
	this.id=this.parent.length;
	this.inpoint=this.parent.duration();
	myParent.push(this);
	this.content=myValue;//レイヤオブジェクトを直接入れるArtLayer ブランクと補完レイヤは必要時に作成
	this.instanceName;
	this.duration=myDuration;
}
nas.xpsSection.prototype.toString=function(){return nameTrunk(this.content);};
//レイヤ名からラベル部分を削除した値を戻す
nameTrunk=function(myLayer){
	newName=(myLayer.name.split("-")[0]==myLayer.parent.name)? myLayer.name:([myLayer.parent.name,myLayer.name]).join("-");
	return newName;
}
// *実処理
function rebuildLayers(){
	//以下処理ループ
	var myTracks=new Array();
	var currentTrack;var currentEntry;
	
	for (var tix=0;tix<XPS.layers.length;tix++){
		var tlix=tix+1;
		if(XPS.layers[tix].option!="timing"){continue;}
		try{currentTrack=new nas.xpsTrack(app.activeDocument.layers.getByName(XPS.layers[tix].name))
		}catch(er){continue;}
		myTracks.push(currentTrack);
	//	ここで第一エントリを確定しておく
			var myEntry=dataCheck(XPS.xpsBody[tlix][0],XPS.layers[tix].name,true);//
//		if(tix==2){alert(XPS.xpsBody[tlix][0]+"/"+XPS.layers[tix].name+":"+[XPS.layers[tix].name,XPS.xpsBody[tlix][0]].join("-")+":"+_getIdx([XPS.layers[tix].name,XPS.xpsBody[tlix][0]].join("-")))}
			if(myEntry == null) myEntry="blank";
			//第一フレームが未記入の場合はブランクを設定
			//エントリに合わせて開始フレームのセクションを確定して初期化
			switch(myEntry){
				case "interp"	:;//動画記号用のカラレイヤを作成してセクションの値にする
				//ドキュメントに動画記号レイヤがあれば利用　なければ作成してエントリー
				try{
					var interpLayer=currentTrack.workSet.layers.getByName(([currentTrack.workSet.name,"-"]).join("-"))
				}catch(err){
					var interpLayer=currentTrack.workSet.artLayers.add();
					app.activeDocument.activeLayer=interpLayer;layerFill();
					interpLayer.name=([currentTrack.workSet.name,"-"]).join("-");
					interpLayer.opacity=0;
				}
					currentEntry=currentTrack.add(1,interpLayer);
					currentEntry.instanceName=interpLayer.name;
				break;
				case "blank"	:;//カラセルレイヤを作成してセクションの値にする
				//ドキュメントに動画記号レイヤがあれば利用なければ作成してエントリー
				try{
					var blankLayer=currentTrack.workSet.layers.getByName(([currentTrack.workSet.name,"X"]).join("-"));
				}catch(err){
					var blankLayer=currentTrack.workSet.artLayers.add();
						app.activeDocument.activeLayer=blankLayer;layerFill();
					blankLayer.name=([currentTrack.workSet.name,"X"]).join("-");
					blankLayer.opacity=0;
				}
					currentEntry=currentTrack.add(1,blankLayer);
					currentEntry.instanceName=blankLayer.name;
				break;
				default:
					currentEntry=currentTrack.add(1,currentTrack.workSet.layers[currentTrack.workSet.layers.length-myEntry]);
					currentEntry.instanceName=currentEntry.content.name;
					//　データチェックの戻り値は、"blank"/"interp"/null 又は数値 数値はpsの場合はレイヤーインデックス（逆）
			}
	//	第二フレーム以降を処理
		for (var fix=1;fix<XPS.xpsBody[0].length;fix++){
			var myEntry=dataCheck(XPS.xpsBody[tlix][fix],XPS.layers[tix].name,true);//
//			var targetIdx=(isNaN(myEntry))? currentTrack.workSet.layers.length-1:currentTrack.workSet.layers.length-myEntry;
			try{
				var targetLayer=currentTrack.workSet.layers.getByName(([currentTrack.workSet.name,myEntry]).join("-"))
			}catch(err){
				var targetLayer=false;
			}
//	区間のフレーム加算条件　「無効データ」「重複データ」「動画記号でない」こと
//　動画記号はこのプロシジャの場合、無条件で新しい区間を作成する
			if(
				(myEntry != "interp")&&(
					(myEntry == null)||(currentEntry.content===targetLayer)
//					(currentEntry.content===currentTrack.workSet.layers[targetIdx])
				)
			){
//				if(currentTrack.valueOf()=="_dialog_"){if(myEntry=="blank"){alert(fix+":"+currentEntry.content+":"+currentTrack.workSet.layers[0])}}
				currentEntry.duration++;
			}else{
				switch(myEntry){
					case "interp"	:;//動画記号用のカラレイヤを作成してセクションの値にする
					//ドキュメントに動画記号レイヤがあれば利用なければ作成してエントリー
					try{
						var interpLayer=(targetLayer)?targetLayer:currentTrack.workSet.layers.getByName(([currentTrack.workSet.name,"-"]).join("-"))
					}catch(err){
						var interpLayer=currentTrack.workSet.artLayers.add();
						app.activeDocument.activeLayer=interpLayer;layerFill();
						interpLayer.name=([currentTrack.workSet.name,"-"]).join("-");
						interpLayer.opacity=0;
					}
						currentEntry=currentTrack.add(1,interpLayer);
						currentEntry.instanceName=interpLayer.name;
					break;
					case "blank"	:;//カラセルレイヤを作成してセクションの値にする
					//ドキュメントに動画記号レイヤがあれば利用なければ作成してエントリー
					try{
						var blankLayer=(targetLayer)?targetLayer:currentTrack.workSet.layers.getByName(([currentTrack.workSet.name,"X"]).join("-"));
					}catch(err){
						var blankLayer=currentTrack.workSet.artLayers.add();						app.activeDocument.activeLayer=blankLayer;layerFill();
						blankLayer.name=([currentTrack.workSet.name,"X"]).join("-");
						blankLayer.opacity=0;
					}
						currentEntry=currentTrack.add(1,blankLayer);
						currentEntry.instanceName=blankLayer.name;
					break;
					default:
						currentEntry=currentTrack.add(1,currentTrack.workSet.layers[currentTrack.workSet.layers.length-myEntry]);
						currentEntry.instanceName=currentEntry.content.name;
					//　データチェックの戻り値は、"blank"/"interp"/null 又は数値 数値はpsの場合はレイヤーインデックス（逆）
				}
			}
		}
		//
	}
	/*
		ここまでの処理で作業用セクションをビルド　以降ビルドしたセクションに合わせて　レイヤー構成を変更
	*/
	for (var tix=0;tix<myTracks.length;tix++){
		var myTrack=myTracks[tix];
		var TVPgroupId=myTracks.length-tix;
		var currentTrailer=myTrack.workSet.layers;
		myTrack.workSet.name="["+nas.Zf(TVPgroupId,2)+"] "+myTrack.workSet.name;
		for (var eix=0;eix<myTrack.length;eix++){
			var myName="["+nas.Zf(TVPgroupId,2)+"]["+nas.Zf(myTrack[eix].inpoint,3)+"] "+myTrack[eix].instanceName;
			if(myTrack[eix].instanceName==myTrack[eix].content.name){
				//名前が一致している場合はオリジナルなので変名
				myTrack[eix].content.name=myName;
			}else{
				//一致しないケースでは、オリジナルを複製して変名
				newLayer=myTrack[eix].content.duplicate()
				newLayer.name=myName;
			}
		}
	}
	/*
		ドキュメントのレイヤセット内をソート 
	*/
		for (var tix=0;tix<activeDocument.layerSets.length;tix++){
			app.activeDocument.activeLayer=activeDocument.layerSets[tix].layers[0];
			layerSort();
		}
	/*
		最終処理ダイアログレイヤセットを確認してレイヤー名を変更 
	*/
		for (var tix=0;tix<activeDocument.layerSets.length;tix++){
			if(activeDocument.layerSets[tix].name.indexOf("_dialog")>0){
				for (var lx=0;lx<activeDocument.layerSets[tix].layers.length;lx++){
					var myLayer=activeDocument.layerSets[tix].layers[lx];
					try{myLayer.name=myLayer.name.replace(/\d+$/,myLayer.textItem.contents)}catch(err){}
				}
			}else{
				if(activeDocument.layerSets[tix].name.indexOf("_board_")>0){
					var myName=app.activeDocument.name.replace(/\.[^.]+$/,"(")+nas.Frm2FCT(XPS.time(),3,false).replace(/\.$/,")").replace(/\s/g,"")+XPS.duration();
					activeDocument.layerSets[tix].layers[0].name=activeDocument.layerSets[tix].layers[0].name.replace(/_board_-1$/,myName);
				}
			}
		}
	}
}
/*================================================================================================*/
//　*アクティブドキュメントに対応するXPSファイルを読み込んで環境を設定 --main
var sheetFile=new File(app.activeDocument.fullName.fsName.replace(/\.psd$/i,".xps"));
	var myContent="";
		var myOpenfile = new File(sheetFile.fsName);
		myOpenfile.encoding="UTF8";
		myOpenfile.open("r");
		myContent = myOpenfile.read();
//		alert("myContent:\n"+myContent);
		if(myContent.length==0){alert("Zero Length!");}
		myOpenfile.close();

if(XPS.readIN(myContent)){
//ドキュメントにダイアログ変換によるテキストレイヤがあった場合は、テキストレイヤーに適合するタイムラインを挿入する
//番号部は"",2,3,4...
if(app.activeDocument.layerSets[0].name.match(/_dialog(\d*)_/)){
	var dialogTrackCount=(RegExp.$1.length)? RegExp.$1:1;
	var TLNames=new Array();
	for (var dtx=0;dtx<dialogTrackCount;dtx++){
		var dtCount=(dtx)? dtx+1:"";
		TLNames.push("_dialog"+dtCount+"_");
	}
		XPS.insertTL(-1,TLNames);
//ここで挿入されるタイムラインは全て"timing"一時タイムラインなので保存はされない。
		var currentType="dialog";var trackId=0;
	for (var tx=0;tx<(XPS.xpsBody.length-dialogTrackCount);tx++){
		if(tx>0){currentType=XPS.layers[tx-1].option};
		if(currentType=="dialog"){
			var myTrack=parseSoundTrack(XPS.xpsBody[tx]);
			XPS.put([XPS.xpsBody.length-dialogTrackCount-trackId-1,0],myTrack.convertReplacement());
			trackId++;
		}
	}
}
//ドキュメントのボールド情報をテキストレイヤーとして挿入する
//レイヤーセット名は"_board_"
var boardString=app.activeDocument.name.replace(/\.[^.]+$/,"(")+nas.Frm2FCT(XPS.time(),3,false).replace(/\.$/,")").replace(/\s/g,"")+XPS.duration();
function addBoard(myName){
var boardWorkset=app.activeDocument.layerSets.add();

boardWorkset.name="_board_";
var boardLayer=boardWorkset.artLayers.add();
  boardLayer.kind = LayerKind.TEXT;//テキストレイヤに変換
  boardLayer.textItem.contents = myName;
//boardLayer.name="_board_-"+myName;
boardLayer.name="_board_-1";
  boardLayer.textItem.font=dialogFont;
	app.preferences.rulerUnits = Units.POINTS;
  boardLayer.textItem.size = 24;//24ポ
	//バグが発生した場合指定ポイント数と異なるデータが返るのでそれを判定
if (Math.round(boardLayer.textItem.size.as("point"))!=24){
  nas.PSCCFontSizeFix.setFontSizePoints( boardLayer, 24);//24ポ
}
var myTextOffsetX=(((boardLayer.bounds[2]-boardLayer.bounds[0])/2)+boardLayer.bounds[0]).as("mm");
var myTextOffsetY=(((boardLayer.bounds[3]-boardLayer.bounds[1])/2)+boardLayer.bounds[1]).as("mm");

	boardLayer.translate(
		new UnitValue(((app.activeDocument.width.as("mm"))*0.2-myTextOffsetX)+" mm" ),
		new UnitValue(((app.activeDocument.height.as("mm")*0.1)-myTextOffsetY)+" mm" )
	);

}
	XPS.insertTL(-1,["_board_"]);
	XPS.put([XPS.xpsBody.length-2,0],"1");//エントリ数１で仮置き
//	XPS.put([XPS.xpsBody.length-2,0],boardString);//エントリ数１で仮置き
//ここで挿入されるタイムラインは一時タイムラインで保存はされない。
//alert(XPS.toString());



//ドキュメント上に演出／作監扱いの修正レイヤーが存在する場合は、シートの当該トラックを複製して
//該当するトラックの上に配置する。その際のエントリ名は、トラック名とエントリ名の両方にオーバーレイポストフィックスを置く
/*
	修正レイヤーを検出して別のレイヤーセットに移動する
	同時にサブトラック用のシートを複製挿入する
	
*/

//ドキュメント内のレイヤセットを検索して以下の条件のレイヤーを検出する

//直下のレイヤー名にポストフィックス"\++"を加えたものが存在するレイヤーセットを抽出して　処理対象にする
//処理対象のオーバーレイ数を取得してループ
//処理対象レイヤセット内部のレイヤ名を確認してオーバーレイ数をカウントする
//同時に移動キューをビルド

/*
	処理前
A
	A3+
	A3
	A2++
	A2+	
	A2
	A1+
	A1
	処理後
A++
	A2++
A+
	A3+
	A2+
	A1+
A
	A3
	A2
	A1
*/
/*
	エントリのオーバーレイ指定（修正指示）は以下のように行う
	エントリの名称にオーバレイ（修正）ポストフィックスを加える
	修正ポストフィックスは、システムごとに定められた1文字のポストフィックスとする

(総|監|検|作|演|修|\+)がポストフィックスであるとして

"A-1"	の修正は	"A-1修" "A-1+"等となる

	ポストフィックスは、数字であってはならない
	ポストフィックスは、データセパレータと同一文字であってはならない

	修正レベルは、ポストフィックスを重ねて表す
"A-1"	の修正の修正は	"A-1修修" "A-1++"　"A-1演作"　等となる

	修正レベルが3以上の場合は以下の表記が認められる
	この場合の数値は繰り返し数値でありポストフィックスの一部ではない

"A-1"	の修正の修正の更に修正は	"A-1修3" "A-1+3"等となる

	可読性のためポストフィックス部分を標準セパレータ[\ _\-]で区切るか、または丸括弧でセパレーションしても良いこととする

A-1(修)	　B-2a(+3)	D-(24)(演)	たぬき-3 修

これらの実アプリ上の展開は各実装に委ねられる
今回の処理では以下のネーミングに限定

A-1+
A-1++
A-1++++++
A-1+3
これは、今回の実装のみの限定

シート処理の手順を組み込む
このプロシジャは基本的に一次処理なため
Xpsが基本的に保存対象でない
引数としてXpsオブジェクトを与えて、加工済みのオブジェクトを戻す？
今回は、等価のルーチンを起こして組み込むことで処理を行う

*/



function movePlusLayers(){
//XPS上の処理対象トラックを複製してトラックラベルを調整
var targetDocument=app.activeDocument;
	var processQueue=[];//処理キュー
/*	　処理の必要がある（修正レイヤを持った）レイヤーセット（トラック）をプロパティとして持った
処理オブジェクトを積む
以下のプロパティとメソッドを持つ
*/
function ProcessEntry(myTarget){
	this.sourceTrack=myTarget;//	LayerSet ソーストラック
	this.targetLayers=[];//	Array [移動ターゲット(Layer),移動先ID]の要素配列
	this.overlayCount=0;//　number オーバレイの必要数を保持
	
}
//オブジェクト自体の処理メソッドで実行
/*
引数:なし
戻値:XPS.insertTLの引数用の（[挿入トラック名配列])
*/
	ProcessEntry.prototype.doProcess=function(){
		var myResult=[];
		if(this.overlayCount==0) return myResult;//カラ配列を戻す
		
		//移転先の新規レイヤセット作成ループ
		for (var cid=this.overlayCount-1;cid>=0;cid--){
//処理に先行してファルダの名前を取得
            var destinationName=this.sourceTrack.name+(["+","++","+3","+4","+5","+6","+7","+8","+9"])[cid];
//既に同名のレイヤセットがあれば処理をスキップ
            try{
                var myDestination=this.sourceTrack.parent.layerSets.getByName(destinationName);
            }catch(err){
			   var myDestination=this.sourceTrack.parent.layerSets.add();
                myDestination.name=destinationName;
                myDestination.move(this.sourceTrack,ElementPlacement.PLACEBEFORE);
				myResult.push(destinationName);//先にトラックがある場合はシート上にもあると思い「たい」のでココで処理
            }
			//レイヤセットのソートは後で行うのでここでは無視
		}
		//エントリ移動
		for (var lix=0;lix<this.targetLayers.length;lix++){
			var myTarget=this.targetLayers[lix][0];
				var mySourceName=myTarget.parent.name;//
                var myDestName=this.sourceTrack.name+(["+","++","+3","+4","+5","+6","+7","+8","+9"])[(this.targetLayers[lix][1]-1)];
			try{
                var myDestination=this.sourceTrack.parent.layers.getByName(myDestName);
				myTarget.move(myDestination,ElementPlacement.PLACEATEND);
			}catch(err){alert(err)}
			myTarget.name=myTarget.name.replace(new RegExp("^"+mySourceName),myDestName); //リネーム ラベルを変更
			myTarget.name=myTarget.name.replace(/\++[1-9]?$/,""); //リネーム 末尾の修正記号を削除
		}
		return myResult.reverse();//順序反転して戻す
	}


//============
for (var wsix=0;wsix<targetDocument.layerSets.length;wsix++){
	var myTrack=new ProcessEntry(targetDocument.layerSets[wsix]);
	
	if (
			( myTrack.sourceTrack.layers.length<=0 )||
			( myTrack.sourceTrack.name.match(/(.*[^\+])(\++)([1-9]?)$/) )
	){
		continue;//スキップ条件に一致するエントリの場合は処理スキップ
	}else{
		processQueue.push(myTrack);//キューにエントリ
	}
//レイヤセット内をチェック
	for (var lix=0;lix<myTrack.sourceTrack.layers.length;lix++){
				targetName=myTrack.sourceTrack.layers[lix].name;
				if(targetName.match(/(.*[^\+])(\++)([1-9]?)$/)){
//	ただ一つでも該当エントリがあればそのトラックは複製対象で、かつ該当エントリは移動（変名）対象
//	処理を単純化するために全てのトラックに処理キューが存在して居ることにして判定を行い、
//	移動エントリ０の場合のみ処理をスキップする方法で実装する

					var plusCount=((RegExp.$3).length)?　parseInt(RegExp.$3):(RegExp.$2).length;
					//キューのカウントを更新
					if(myTrack.overlayCount<plusCount){myTrack.overlayCount=plusCount;}
					//処理キューにレイヤー（又はレイヤーセット）を積む
					myTrack.targetLayers.push([myTrack.sourceTrack.layers[lix],plusCount]);
/*
	if(myAllLayers.finedName(RegExp.$1)){
	実処理上、必ずしも修正に対応する元絵は必要ない。
	元絵（番号対応するエントリ）が存在しないケースもままある。
	最も重要な所属関係は、その要素がどのトラックに対応するか
	（＝どの時間情報を使ってタイムライン上に占位するか）である
	}				
*/
				}
	};
}
//========処理収集フェーズ終了　実処理
for(var ix=0;ix<processQueue.length;ix++){
		var myTracks=processQueue[ix].doProcess();
		if(myTracks.length && XPS){
			var myTrackName=processQueue[ix].sourceTrack.name;
			var myIndex=-1;
			for (var lix=0;lix<XPS.layers.length;lix++){if (myTrackName==XPS.layers[lix].name){myIndex=(lix+1);break;};};		XPS.insertTL(myIndex+1,myTracks);//空トラック挿入
			var baseStream=XPS.xpsBody[myIndex].join(",");
			for(var tx=0;tx<myTracks.length;tx++){XPS.put([myIndex+tx+1,0],baseStream);};
		}
}
//	alert(XPS.toString())
}
/////////// plusTrack処理暫定版　2016.06.15


//alert(XPS.xpsBody[XPS.layers.length].join());
//undo付きでレイヤを分類
	var myUndo="layerRebuildForTvp";//"TVPaint"
	var myAction="addBoard('"+boardString+"');movePlusLayers();nas.axeAFC.initFrames();rebuildLayers();";
	if(app.activeDocument.suspendHistory){app.activeDocument.suspendHistory(myUndo,myAction)}else{evel(myAction)}
}else{
	//デバッグ
//	alert(dataCheck(XPS.xpsBody[2][4],"A",true))
}
		}
