﻿/**
 *
 *	node.js下で単独で使用可能なユーティリティー集
 *
 *
 */
'use strict';

/**	カット番号記述をリストに展開
 * 引数を解釈してリスト配列に展開して返す
 *	@params	{String}	name_description
 *	@params {String}	name_template
 *
 *
 *	冒頭から順次処理
 *	主引数はコンマ","でセパレートしたカット番号記述
 *	範囲表現のハイフン'-'を含んでいて良い
 *	以下のような表現が可能
 *	ABC#01//s-c123-s-c125
 *	s1-c003-25
 *	1-3	これは範囲指定として認識 s1-c3とは解釈されない
 *	s1-c3 明示的にシーン番号として指定することを推奨
 *
 *	シーン指定は出現のたびに切り替わる
 *	タイトル・エピソード・シーンを保持
 *	指定のないエントリは前出の値をコピーする
 *	s1-1-3,s2-c1-35 
 *	これは、以下のように展開される
 *	s1-c1,s1-c2,s1-c3,s2-c1,s2-c2,s2-c3....
 *	
 */
function expandSCiList(name_description,name_template){
//引数を確認
	if(! name_description) return false;
//カンマ分離
	var dataList = name_description.split(",");
	if(name_template){
		var tempData = nas.Pm.parseIdentifier(name_template);
	}else{
		var tempData = nas.Pm.parseIdentifier(dataList[0]);
	}
	var currentScene = tempData.scene;
	var result = [];
	for (var ix = 0 ; ix < dataList.length ; ix ++){
		if(dataList[ix].match(/^(.*\d)\-(.*)$/i)){
			var range = [RegExp.$1,RegExp.$2];
			var startIdf = nas.Pm.parseIdentifier(range[0]);
			var endIdf   = nas.Pm.parseIdentifier(range[1]);
			if(startIdf.scene) currentScene   = startIdf.scene;
//範囲が逆転していたら逆送りで解決する
			var start = nas.parseNumber(startIdf.cut);
			var end   = nas.parseNumber(endIdf.cut);
			if(start > end){
				start = nas.parseNumber(endIdf.cut);
				end   = nas.parseNumber(startIdf.cut);
			};
//識別子を作成してをリザルトに入れる 既存のカットはスキップ
//シーン+ナンバーを
			for(var num = start ; num <= end ; num ++){
				var cname = String(num);
				if (num == start){
					cname = startIdf.cut;
				} else if (num == end){
					cname = endIdf.cut;
				};
				result.add( nas.Pm.stringifyIdf([
					tempData.product.title,
					tempData.product.opus,
					"",
					currentScene,
					nas.RZf(cname,3)
				]),function(tgt,dst){
					return (nas.Pm.compareCutIdf(tgt,dst) == 0);
				})
			}
		}else{
			var currentIdf = nas.Pm.parseIdentifier(dataList[ix]);
			if(currentIdf.scene) currentScene   = startIdf.scene;
			result.add(	nas.Pm.stringifyIdf([
					tempData.product.title,
					tempData.product.opus,
					"",
					currentScene,
					nas.RZf(currentIdf.cut,3)
				]),function(tgt,dst){
				return (nas.Pm.compareCutIdf(tgt,dst) == 0)
			});
		}
	}
	result.sort(nas.Pm.compareCutIdf);
	return result;
}
/*TEST
	expandSCiList("TEST#12__s-c001-TEST#12__s-c12,15,18,20-32");
*/
/**

 *	@params	{String}	targetFolder
 *	@params	{String}	templatePath | template-keyword
 *  @returns	{String}
 *		作成したカットフォルダのフルパスを返す、作成に失敗した場合はエラーメッセージ、またはnull
 *	node.js　が必要？他のライブラリ用の同機能メソッドを作って互換をとる
 
 *	指定のフォルダをひとつ作成する 引数はパス単独
 *	テンプレートフォルダの指定があればそれをターゲットフォルダ名で複製する
 *	テンプレートキーワードならば、定形処理を行う
 *	指定が存在しなければフォルダのみを作成する
 *	
 *	既存のフォルダ(衝突時)は新たに作らない
 *	エラーを戻す?
 *	フォルダ名のみを与えられた場合は、カレントに作成（ターミナル用）
 *		最終的にはRepository.addEntryメソッドの動作として実装する
 */
var mkFolder = function(targetFolder,templatePath){
//第一引数を確定
	if(!targetFolder) return false;
	if(targetFolder == path.basename(targetFolder)) targetFolder = path.resolve(targetFolder);
//第二引数を確定 _etc/の検索はしない（必要なら指定する）
	switch(templatePath){
	case	"xmap":
	case	"episode":
	case	"title":
	case	"repository":
		templatePath = path.join(
			Folder.current.fsName,"/storage_templates",templatePath
		);
	break;
	default:
		if(!fs.existsSync(templatePath)) templatePath = null;
	}
//既存パスが指定されている
	if(fs.existsSync(targetFolder))	throw targetFolder + ' allready exists !';
	console.log([targetFolder,templatePath]);
//throw 'stop';
	if(templatePath){
		fs.copy(templatePath,targetFolder);
	}else{
		fs.mkdirSync(targetFolder);
		if(! fs.existsSync(targetFolder)) throw '作成失敗';//作成失敗のメッセージ
/*
		var fd = fs.openSync(path.join(targetFolder,"/__"),"a");//作業タグファイル
		fs.closeSync(fd);
		fs.mkdirSync(path.join(targetFolder,"/_etc"));
		fs.mkdirSync(path.join(targetFolder,"/_movie"));
		fs.mkdirSync(path.join(targetFolder,"/0-0(composite)"));//合成ラインフォルダ
		fs.mkdirSync(path.join(targetFolder,"/1(BGArt)"))      ;//背景美術ラインフォルダ
		fs.mkdirSync(path.join(targetFolder,"/2(3D-CGI)"))     ;//３D-CGIラインフォルダ
		fs.mkdirSync(path.join(targetFolder,"/0__0CT"))        ;//第一工程フォルダ
*/
	};
	return targetFolder;
};

/*	TEST
	mkFolder("testFolder",null);

 */
/**
 *	@params	{String}	listString
 *			カット番号リスト コンマ区切り
 *	@params {String}	name_tamplate
 *			オプション プロダクト指定
 *	簡易ツール
 *	リスト指定のカットを作成する
 *	作成場所はカレントディレクトリのみ（あらかじめ移動しておくこと）
 *	リストの第一要素でプロダクト指定可能 オプションの指定が優先
 *	未指定の場合、カレントの取得を試みる
 */
var mkCutFolders = function(listString,name_template){
	if(!listString) return false;
	if(!name_template){
		var currentpath = new nas.File(process.cwd());
		name_template = currentpath.body.reverse().find(function(elm){return (elm.indexOf("#") >= 0) });
console.log(name_template.replace(/[\s\(\[].*$/,''));
		if(name_template) name_template = name_template.replace(/[\s\(\[].*$/,'');
	}
	var list = expandSCiList(listString,name_template);
	for(var lix = 0 ; lix < list.length ; lix ++ ){
		mkFolder(list[lix].replace(/\/\//g,"__"),"xmap");
	}
};
///Users/kiyo/Desktop/納品規則/repository(マスターストレージサンプル)/Nekomataya (サンプルレポジトリ)/kt (タイトルフォルダ例)/kt#00 (エピソードフォルダ例)