﻿/*
	docio.js
	システム全体に係るdocumentsio関連ソースを分離
	nas_common.js
	nas_common_value.js
	mapio.js
	xpsio.js
	以上のライブラリを必要とする
	remaping.jsの基礎ライブラリ
*/
'use strict';
//----------------------------------- UIコントロールオブジェクトを作成、初期化
function new_xUI(){
/**  @class
 *<pre>     UIコントロールオブジェクト
 *  エディタ・アプリケーション本体のクラスオブジェク
 *</pre>
 */
    var xUI = {};
/*
 * xUI のエラーメッセージは旧Xpsオブジェクトから移転されたもの
 * XpsオブジェクトにUIエラーハンドリングは不用
 */
    xUI.errorCode    =    0;
    xUI.errorMsg=[
{en: "000:There is no error in final processing" ,ja: "000:最終処理にエラーはありません"},
{en: "001:Data length is 0. It may have failed to read" ,ja: "001:データ長が0です。読み込みに失敗したかもしれません"},
{en: "002:sorry. I do not seem to be able to read this data" ,ja: "002:どうもすみません。このデータは読めないみたいダ"},
{en: "003:There is no data to read" ,ja: "003:読み取るデータがないのです。"},
{en: "004:There is no data to be converted.\n Processing is interrupted." ,ja: "004:変換すべきデータがありません。\n処理を中断します。"},
{en: "005:MAP data is missing" ,ja: "005:MAPデータがありません"},
{en: "006:User cancellation" ,ja: "006:ユーザキャンセル"},
{en: "007:You can not specify outside the range" ,ja: "007:範囲外の指定はできません"},
{en: "008:You can not update confirmed data" ,ja: "008:確定済データを更新することはできません"},
{en: "009:Unexpected error" ,ja: "009:想定外エラー"}
];//    -localized

//------- UIオブジェクト初期化前の未定義参照エラーを回避するためのダミーメソッド
    xUI.flipContextMenu=function(evt){return true;};
    xUI.Mouse=function(evt){return true;};
    xUI.Touch=function(evt){return true;};
//	初期化前にバックアップデータの処理が発生するので暫定的に初期化しておく
    xUI.backupStore    ="0123456789";    //作業バックアップ

    xUI.activeDocument   = null;
    xUI.activeDocumentId = -1;
    xUI.delayRefreash    = true;
//------------------------ 以下インターフェースカラープロパティ
//カラー・トラック幅等のルック決定要素はundefinedで初期化して  遅延解決に移行する
//xUI
    xUI.pmcuiBGColor          ; //マネジメントメニュー背景色
    xUI.pmBorderColor = {}    ; //マネジメントボタン境界色
    xUI.pmBorderColor.ACTIVE  ; //マネジメントボタン境界色
    xUI.pmBorderColor.DISABLED; //マネジメントボタン境界色
//Xmap
    xUI.baseColor             ; //背景色
//Xpst タイムシートルック
    xUI.sheetbaseColor        ; //タイムシート背景色
    xUI.sheetblankColor       ; //編集不可領域の背景色
    xUI.footstampColor        ; //フットスタンプの色
    xUI.inputModeColor = {}   ; //入力モード色
    xUI.inputModeColor.NORMAL ; //ノーマル色
    xUI.inputModeColor.EXTEND ; //ラピッド入力基本色
    xUI.inputModeColor.FLOAT  ; //ブロック移動基本色
    xUI.inputModeColor.SECTION; //範囲編集中の色
         
    xUI.selectedColor         ; //選択セルの背景色
    xUI.selectionColor        ; //選択領域の背景色
    xUI.editingColor          ; //セル編集中のインジケータ
    xUI.selectingColor        ; //セル選択中のインジケータ

//テキストカラー
    xUI.sheetTextColor        ;//本文標準色
    xUI.annnotationColor        ;//本文注釈色
    xUI.linkColor        ;//リンク色
    xUI.hoverColor       ;//リンクホーバー色
    xUI.activeColor      ;//リンクアクティブ色
//メニュー関連
    xUI.toolView        ;//ツールパネル表示状態(cookieの値)
    xUI.summaryGroup    ;//スタンプエリア状態変数
    ;//
    ;//
//タイムライン・ラベル識別カラ－
    xUI.cameraColor;
    xUI.sfxColor;
    xUI.stillColor;//タイムライン全体に着色
//中間色自動計算
        xUI.inputModeColor.NORMALspin;
        xUI.inputModeColor.EXTENDspin;
        xUI.inputModeColor.FLOATspin;
        xUI.inputModeColor.SECTIONspin;
//スピン選択状態
        xUI.inputModeColor.NORMALspinselected;
        xUI.inputModeColor.EXTENDspinselected;
        xUI.inputModeColor.FLOATspinselected;
        xUI.inputModeColor.SECTIONspinselected;
//選択状態
        xUI.inputModeColor.NORMALselection;
        xUI.inputModeColor.EXTENDselection;
        xUI.inputModeColor.FLOATselection;
        xUI.inputModeColor.SECTIONselection;
//編集中
        xUI.inputModeColor.NORMALeddt;
        xUI.inputModeColor.EXTENDeddt;
        xUI.inputModeColor.FLOATeddt;
        xUI.inputModeColor.SECTIONeddt;
//フロートテキスト色
    xUI.floatTextColor;
//----------------------------------------------------------------------初期状態設定
    xUI.spinAreaColor;
    xUI.spinAreaColorSelect;
    xUI.sectionBodyColor;
// ---------------------- ここまでカラー設定
/**
 *    xUI.importBox
 *    複数データ対応ドキュメントインポーター
 */
    xUI.importBox={};//インポート情報トレーラー初期化
    xUI.importBox.overwriteProps    ={};
    xUI.importBox.importTarget  = false;
    xUI.importBox.maxSize  = 1000000;
    xUI.importBox.maxCount = 10;
//    xUI.importBox.allowExtensions=new RegExp("\.(txt|csv|xps|ard|ardj|tsh|xdts|tdts)$",'i');
    xUI.importBox.allowExtensions=new RegExp("\.(pmdb)|(stbd)|(xmap|map)|(txt|csv|xps|ard|ardj|tsh|xdts|tdts)$",'i');

/**
 *  @function
 *    importBox リセット
 *   インポート操作の直前でリセットを行うこと
 */
xUI.importBox.reset = function(){
    this.targetContents    =[];
    this.selectedContents  =[];
    this.importTarget  = false;
//    if((document.getElementById('loadTarget').value=='ref')){}
    if((document.getElementById('loadTarget'))&&(document.getElementById('loadTarget').value=='ref')){
        this.importTarget=xUI.referenceXPS;
    } else {
        this.importTarget=xUI.XPS;
    }
    this.importCount= 0;
    this.callback = undefined;
//console.log('importBox reset')
}
    xUI.importBox.reset();
/**
 *  @function
 *   変換ターゲットとなるFileオブジェクト配列を引数にして以下の関数を呼び出す
 *   全カット変換終了時のコールバック関数を与えることが可能
 *  @params {Array of File} targetFiles
 *  @params {Function} callback
 */
xUI.importBox.read = function (targetFiles,callback){
    if(appHost.platform == "AIR"){
//***AIR  用の分岐は  単ファイルのままで保留2018 0201
    // File APIを利用できるかをチェック
        if (window.File) {
      // 指定されたファイルを取得
            var input = targetFiles[0];
	        fileBox.currentFile=new air.File(input.name);
	        xUI.data_well.value =fileBox.readContent();
        }else{
            return false;
        }
    } else　if(appHost.platform == "Electron"){
//*** Electron  用の分岐は  分岐のみで保留2019 0902
    // File APIを利用できるかをチェック
        if (window.File) {
      // 指定されたファイルを取得
            var input = targetFiles[0];
	        fileBox.currentFile=(input.name);
	        xUI.data_well.value =fileBox.readContent();
        }else{
            return false;
        }
    } else {
    // File APIを利用できるかをチェック
  if (window.File) {
    if(window.FileReader){
        xUI.importBox.reset();//ここで再初期化する
        xUI.importBox.callback=callback;
//処理に先行して拡張子とファイルサイズでフィルタして処理リストを作成する
//作業リストの進行度合いをチェックして終了判定をかける
        var targetQueue=[];
  for(var ix=0;ix<targetFiles.length;ix++){
    var check = targetFiles[ix];
    var ext = check.name.match(this.allowExtensions);//[0].含むポストフックス全体,[1]pmdb,[2],stbd[3],xmap,[4]xpst
    if((ext[1])||(ext[2])||(ext[3])){
        targetQueue=[check]; this.importCount = 1;
        if(ext[0]=='.xmap'){
            this.importTarget = xUI.XMAP;
        }else {
            this.importTarget = false;
        }
        break;
        //マッチ次第・第一引数に設定してブレイク
    } else if((ext[4]) && (check.size <= this.maxSize) && (ix < this.maxCount)){
        targetQueue.push(check); this.importCount ++;
    }else{
        console.log("skip file "+check.name );
    }
  };
      // 指定されたファイルを取得してインポーターのプロパティとして記録
  for(var ix=0;ix<targetQueue.length;ix++){
    var input = targetQueue[ix];
//最初のファイルをターゲットに読込
    if(this.importTarget instanceof Xps){
      var myEncode=(input.name.match(/\.(ard|csv|tsh)$/))?"Shift-JIS":"UTF-8";
      // ファイルリーダーオブジェクト初期化(Chrome/Firefoxのみ)
      var reader = new FileReader();
      reader.name=input.name;
      // ファイルの読み込みに成功したら、その内容をxUI.data_wellに反映
      reader.addEventListener('load', function(e) {
        var output = reader.result;//
        xUI.data_well.value = reader.result;//最後に読み込んだ内容で上書きされるので注意
//console.log(reader);
//エリアターゲット 
        var areaTarget = (document.getElementById('loadTarget').value == 'ref')? 0:undefined;
        var myXps = xUI.convertXps(
            reader.result,
            divideExtension(reader.name)[1],
            xUI.importBox.overwriteProps,
            false,
            areaTarget
        );// 指定オプション無しで一旦変換する
        if(!myXps){
            alert(reader.name+' is not supported format');
        }
        if((xUI.uiMode == 'production')&&(xUI.importBox.importTarget===xUI.XPS)){
            if( (xUI.XPS.xpsTracks.duration != myXps.xpsTracks.duration)||
                (xUI.XPS.xpsTracks.length != myXps.xpsTracks.length)
            ) xUI.reInitBody(myXps.xpsTracks.length,myXps.xpsTracks.duration);
            xUI.selection();xUI.selectCell([0,0]);
            xUI.sheetPut(myXps.getRange());
        }else{
            if((xUI.uiMode != 'browsing')&&(xUI.importBox.importTarget===xUI.XPS)){
//                xUI.resetSheet(myXps);
                xUI.setUImode('browsing');
                xUI.uiModeMenuUpdate();
            }else{
                xUI.importBox.importTarget.parseXps(myXps.toString());
                xUI.resetSheet();
            }
        }
      }, true);
      // ファイルの内容をテキストとして取得
        reader.readAsText(input, myEncode);
        break;
    }else{
      var myEncode=(input.name.match(/\.(ard|csv|tsh)$/))?"Shift-JIS":"UTF-8";
      // ファイルリーダーオブジェクト初期化(Chrome/Firefoxのみ)
      var reader = new FileReader();
      reader.name=input.name;
      // ファイルの読み込みに成功したら、その内容をxUI.data_wellに反映
      reader.addEventListener('load', function(e) {
        var output = reader.result;//
        xUI.data_well.value = reader.result;//最後に読み込んだ内容で上書きされるので注意
//console.log(reader);
//エリアターゲット 
		var myData = new xMap();
        var dataCheck = myData.parsexMap(reader.result);// 指定オプション無しで一旦変換する
        if(!dataCheck){
            alert(reader.name+' is not supported xMap format');
        } else {
        	xUI.documents.setContent(reader.result);
        }
      }, true);
      // ファイルの内容をテキストとして取得
        reader.readAsText(input, myEncode);
        break;
    }
//非同期で実行
(function(){
	var myEncode=(input.name.match(/\.(ard|csv|tsh)$/))?"Shift-JIS":"UTF-8";
      // ファイルリーダーオブジェクト初期化(Chrome/Firefoxのみ)
      var reader = new FileReader();
      reader.name=input.name;
      // ファイルの読み込みに成功したら、その内容をxUI.data_wellに反映
      reader.addEventListener('load', function(e) {
        var output = reader.result;//
        xUI.data_well.value = reader.result;//最後に読み込んだ内容で上書きされるので注意  20180220
//エリアターゲット 
        var areaTarget = (document.getElementById('loadTarget').value == 'ref')? 0:undefined;
        var myXps = xUI.convertXps(
            reader.result,
            divideExtension(reader.name)[1],
            xUI.importBox.overwriteProps,
            false,
            areaTarget
        );// 指定オプション無しで一旦変換する
        if(!myXps){
            alert(reader.name+' is not supported format');
        }
        xUI.importBox.targetContents.push({
            "name":reader.name,
            "content":reader.result,
            "xps":myXps,
            "checked":true
        });
        if ( xUI.importBox.importCount == xUI.importBox.targetContents.length ){
            console.log(xUI.importBox.targetContents)
            var firstFile=Xps.parseIdentifier(divideExtension(xUI.importBox.targetContents[0].name)[1]);
            xUI.importBox.overwriteProps={
                "title":String(firstFile.title),
                "episode":String(firstFile.opus),
                "description":String(firstFile.subtitle)
            }
    console.log(xUI.importBox.overwriteProps);
            xUI.importBox.resetTarget(xUI.importBox.targetContents,xUI.importBox.overwriteProps);
            var myDialog = $("#optionPanelSCI");
		    myDialog.dialog("open");myDialog.focus();
		    document.getElementById('optionPanelSCI_01_sc').focus();//第一カット(かならずある)にフォーカス
        };
      }, true);
      // ファイルの内容をテキストとして取得
      reader.readAsText(input, myEncode);
})();//キューの各エントリを処理
  }
      }else{
//FileReaderが無いブラウザ(Safari等)では、お詫びしてオシマイ
var msg = "no FileReader! :\n  このブラウザはFileReaderオブジェクトをサポートしていません。\nこの環境ではローカルファイルは読みだし出来ません。\nThis browser does not support the FileReader object. \n you can't read local files now.";
	alert(msg);
      };//if(window.FileReader)
    };//if(window.File)
  };//if(appHost.platform == "AIR")
};//
/**
    xUI.importBox.updateTarget()
    チェックのあるカットのみダイアログの値でターゲットのプロパティを更新して
    新規の配列を作成する
*/
xUI.importBox.updateTarget= function(){
    for(var tix=0;tix<xUI.importBox.targetContents.length;tix++){
        var doAction = document.getElementById('optionPanelSCI_'+nas.Zf(tix+1,2)+'_imptCB').checked;
        xUI.importBox.targetContents[tix].checked = doAction;
        if(! doAction ) continue;
        var modefiedXps = xUI.importBox.targetContents[tix].xps;//直に参照
        modefiedXps.title    = document.getElementById('optionPanelSCI_title').value
        modefiedXps.opus     = document.getElementById('optionPanelSCI_opus').value;
        modefiedXps.subtitle = document.getElementById('optionPanelSCI_subtitle').value;
        modefiedXps.scene    = '';
        modefiedXps.cut      = document.getElementById('optionPanelSCI_'+nas.Zf(tix+1,2)+'_sc').value;
    //  時間変更 短くなった場合は後方からフレームが削除される
        modefiedXps.setDuration(
            nas.FCT2Frm(
                document.getElementById('optionPanelSCI_'+nas.Zf(tix+1,2)+'_time').value)+
                Math.ceil((modefiedXps.trin.frames() + modefiedXps.trout.frames())/2)
            );
//  変更されたXpsのステータスをFloatingに変更（暫定処理）Floating　ステータス廃止
//        modefiedXps.currentStatus.content    = 'Floating';
        xUI.importBox.selectedContents.push(modefiedXps);
    }
    $("#optionPanelSCI").dialog("close");
    if(xUI.importBox.callback instanceof Function){xUI.importBox.callback();};
}
/**
    xUI.importBox.resetTarget(dataTrailer,optionTrailer)
    インポート用のダイアログを初期化する
    引数は初期化用データ
    optionTrailer が与えられない場合は書き直しは行われない
*/
xUI.importBox.resetTarget= function(dataTrailer,optionTrailer){
    if (! dataTrailer) dataTrailer=this.targetContents;
    if (! dataTrailer.length) return false;
    if (optionTrailer){
      document.getElementById('optionPanelSCI_title').value    = optionTrailer.title;
      document.getElementById('optionPanelSCI_opus').value     = optionTrailer.episode;
      document.getElementById('optionPanelSCI_subtitle').value = optionTrailer.description;
    } else {
      document.getElementById('optionPanelSCI_title').value    = dataTrailer[0].xps.title;
      document.getElementById('optionPanelSCI_opus').value     = dataTrailer[0].xps.opus;
      document.getElementById('optionPanelSCI_subtitle').value = dataTrailer[0].xps.subtitle;
    }
//以下マルチファイル対応に変更
    var listHolder=document.getElementById('optionPanelSCIs');
//子ノードをクリア
    while( listHolder.firstChild ){
        listHolder.removeChild( listHolder.firstChild );
    };
//新規の子ノードを作成
    var sciTemplate = document.getElementById('sciTemplate');
    var sciHTML="";
    for(var dix=0;dix<dataTrailer.length;dix++){
        sciHTML += sciTemplate.innerHTML.replace(/%ID%/g,nas.Zf(dix+1,2));
    }
    listHolder.innerHTML=sciHTML;
    if(dataTrailer.length > 1){
        $('.SCiImportCB').css('display','inline');
    }else{
        $('.SCiImportCB').css('display','none');
    };
    for(var dix=0;dix<dataTrailer.length;dix++){
        var IDnumber=nas.Zf(dix+1,2);
        console.log(dix);
        console.log(dataTrailer[dix]);
        document.getElementById('optionPanelSCI_'+IDnumber+'_imptCB').checked    = dataTrailer[dix].checked;
        document.getElementById('optionPanelSCI_'+IDnumber+'_sc').value    = dataTrailer[dix].xps.cut;
        document.getElementById('optionPanelSCI_'+IDnumber+'_time').value  = dataTrailer[dix].xps.getTC(dataTrailer[dix].xps.time());
    };
    if(optionTrailer){
        for(var prp in optionTrailer){
            switch (prp){
                case "title":
    document.getElementById('optionPanelSCI_title').value    = String(optionTrailer[prp]);
                break;
                case "episode":
    document.getElementById('optionPanelSCI_opus').value    = String(optionTrailer[prp]);
                break;
                case "description":
    document.getElementById('optionPanelSCI_subtitle').value    = String(optionTrailer[prp]);
                break;
                case "cut":
     if(dataTrailer.length==1){
        document.getElementById('optionPanelSCI_01_sc').value    = String(optionTrailer[prp]);
    }
                break;
                case "time":
     if(dataTrailer.length==1){
        document.getElementById('optionPanelSCI_01_time').value    = String(optionTrailer[prp]);
        document.getElementById('optionPanelSCI_01_time').onchange();
    }
                break;
            }
        }
    }
    if(xUI.uiMode=='production'){
        var impt = (xUI.uiMode=='production')? true:false;
        document.getElementById('optionPanelSCI_title').disabled    = impt;
        document.getElementById('optionPanelSCI_opus').disabled     = impt;
        document.getElementById('optionPanelSCI_subtitle').disabled = impt;
        document.getElementById('optionPanelSCI_01_sc').disabled    = impt;
        document.getElementById('optionPanelSCI_01_time').disabled  = impt;
        $('.timeInputButtons').css('display','none')
    }else{
        $('.timeInputButtons').css('display','inline')
    }
    document.getElementById('resetSCiTarget').disabled = true ;
    return true;
}
/**
    xUI.importBox.checkValue(ctrlElement)
    ダイアログの変更状況をチェックしてUIの状態を更新する
     パラメータがひとつでも変更された場合はリセットボタンを有効に
    時間パラメータが変更された場合は、表記をTCに統一する
*/
xUI.importBox.checkValue = function(itm){
    var myProps=(String(itm.id).split('_')).reverse();
    switch(myProps[0]){
        case 'time':;
            itm.value = nas.clipTC(itm.value,Infinity,1,3);
        break;
        case 'imptCB':;
                document.getElementById('optionPanelSCI_'+myProps[1]+'_sc').disabled   = (! itm.checked);
                document.getElementById('optionPanelSCI_'+myProps[1]+'_time').disabled = (! itm.checked);
        break;
        case 'title':;
        case 'opus':;
        case 'subtitle':;
        case 'sc':;
        default:
    }
    document.getElementById('resetSCiTarget').disabled = false;
}
 /**
    サポート対象の他フォーマットのデータをXpsデータにコンバートして戻す関数
    xUI.convertXps(datastream,optionString,overiteProps,streamOption,targetOption)
引数:
    @params {Staring}    datestream
        コンバート対象のデータ
        基本的にテキストデータ
        バイナリデータの場合は1bite/8bit単位の数値配列として扱う（現在未実装）
    @params {String}    optionString
        コンバート対象のデータがXPSのプロパティ全てを持たない場合があるので
        最低限のプロパティ不足を補うための指定文字列
        URIencodedIdentifier または TextIdentifierを指定
        通常はこのデータがファイル名の形式で与えられるのでファイル名をセットする
        空白がセットされた場合は、カット番号その他が空白となる
    @params {Object}    overwriteProps
        コンバータ側で上書きするプロパティをプロパティトレーラーオブジェクトで与える
        インポーター側へ移設予定
    @params {boolean}    streamOption
        ストリームスイッチフラグがあればストリームで返す（旧コンバータ互換のため）
    @params {String}    targetOption
        コンバート対象になるデータに複数のタイムシートが含まれている場合にその対象データを指定するオプション
        引数が与えらえない場合は、最後にヒットしたタイムシートを戻す（ステージ指定用）

    複数データ用コンバート関数
    内部でparseXpsメソッドを呼んでリザルトを返す
    以下形式のオブジェクトで  overwriteProps を与えると固定プロパティの指定が可能
    {
        "title":"タイトル文字列",
        "epispde":"エピソード文字列",
        "description":" エピソードサブタイトル文字列",
        "cut":"カット番号文字列",
        "time":"カット尺文字列  フレーム数またはTC"
    }
    いずれのプロパテイも省略可能
    指定されたプロパティは、その値でダイアログを上書きして編集が固定される
    全て指定した場合は、ユーザの編集ができなくなるので注意
    単独ファイルの場合は、固定に問題は無いが
    複数ファイル処理の場合に問題が発生する
    
    固定プロパティ強制のケースでは複数のドキュメントに同一のカット番号をもたせることはできないので
    カット番号のロックは行われない
    不正データ等の入力でコンバートに失敗した場合はfalseを戻す
    旧来の戻り値と同じ形式が必要な場合は  xUI.convertXps(datastream,"",{},true) と指定する事
戻値:  Object Xps or XpsStream or false
    
*/
xUI.convertXps=function(datastream,optionString,overwriteProps,streamOption,targetOption){
//console.log([datastream,optionString,overwriteProps,streamOption,targetOption]);
    if(! String(datastream).length ){
        return false;
    }else{
// streamOption
    if(!streamOption){streamOption=false;}
// オプションで識別子文字列を受け取る  （ファイル名を利用）
// 識別子はXps.parseIdentifierでパースして利用
    if(! optionString){optionString = ''};//'=TITLE=#=EP=[=subtitle=]//s-c=CUTNo.=';}
// optionStringが空文字列の場合は置換処理を行わない
    if(optionString.length){
//ファイル名等でsciセパレータが'__'だった場合'//'に置換
        if(optionString.indexOf('__')>=0){optionString=optionString.replace(/__/g,'//');}
// 文字列がsciセパレータ'//'を含まない場合、冒頭に'//'を補って文字列全体をカット番号にする
        if(optionString.indexOf('//') < 0 ){optionString='//' + optionString;}
        var optionTrailer=Xps.parseIdentifier(optionString);
    }else{
        var optionTrailer=false;
    }
// 上書きプロパティ指定がない場合は空オブジェクトで初期化
    if(! overwriteProps){overwriteProps={};}
// シート指定引数は、存在すればそのままコンバート関数に渡す。存在しない場合はfalse|undefinedを渡す

//データが存在したら、種別判定して、コンバート可能なデータはコンバータに送ってXPS互換ストリームに変換する
//Xpxデータが与えられた場合は素通し
//この分岐処理は、互換性維持のための分岐
        switch (true) {
        case    (/^nasTIME-SHEET\ 0\.[1-9]x?/).test(datastream):
//    判定ルーチン内で先にXPSをチェックしておく（先抜け）
        break;
        case    (/^(exchangeDigitalTimeSheet Save Data\n)/).test(datastream):
            datastream =TDTS2XPS(datastream);
            //ToeiDigitalTimeSheet / eXchangeDigitalTimeSheet
        break;
        case    (/^(toeiDigitalTimeSheet Save Data\n)/).test(datastream):
            datastream =TDTS2XPS(datastream,targetOption);
            //ToeiDigitalTimeSheet / eXchangeDigitalTimeSheet
        break;
        case    (/^UTF\-8\,\ TVPaint\,\ \"CSV 1\.[01]\"/).test(datastream):
            datastream =TVP2XPS(datastream);
            //TVPaint csv
        break;
        case    (/^\"Frame\",/).test(datastream):
            datastream =StylosCSV2XPS(datastream,targetOption);//ボタン動作を自動判定にする 2015/09/12 引数は使用せず
        break;
        case    (/^\{[^\}]*\}/).test(datastream):;
            try{datastream =ARDJ2XPS(datastream);console.log(datastream);}catch(err){console.log(err);return false;};
        break;
        case    (/^#TimeSheetGrid\x20SheetData/).test(datastream):
            try{datastream = ARD2XPS(datastream);console.log(datastream);}catch(err){console.log(err);return false;};
        break;
        case    (/^\x22([^\x09]*\x09){25}[^\x09]*/).test(datastream):
            try{datastream =TSH2XPS(datastream);}catch(err){return false}
        break;
        case    (/^Adobe\ After\ Effects\x20([456]\.[05])\ Keyframe\ Data/).test(datastream):
            try{datastream=AEK2XDS(datastream)}catch(err){alert(err);return false}
            //AEKey のみトラック情報がないので  ダミーXpsを先に作成してそのトラックにデータをputする
            var myXps=new Xps();
console.log(datastream);
            myXps.put(datastream);
            datastream=myXps.toString();
        break;
        default :
/*
    元の判定ルーチンと同じくデータ内容での判別がほぼ不可能なので、
    拡張オプションがあってかつ他の判定をすべてすり抜けたデータを暫定的にTSXデータとみなす
 */
            if(TSXEx){
                try{datastream=TSX2XPS(datastream)}catch(err){alert(err);return false;}
            }
      }
        if(! datastream){return false}
    }
  if(datastream){
    var convertedXps=new Xps();
    convertedXps.parseXps(datastream);
//ここでセリフトラックのチェックを行って、シナリオ形式のエントリを検知したら展開を行う
    for(var tix=0;tix<convertedXps.xpsTracks.length;tix++){
        var targetTrack=convertedXps.xpsTracks[tix]
        if(targetTrack.option=='dialog'){
            var convertQueue=[];//トラックごとにキューを置く
            var currentEnd =false;//探索中の終了フレーム
            
            for(var fix=0;fix<targetTrack.length;fix++){
                var entryText=String(targetTrack[fix]);
//末尾検索中
                if((convertQueue.length>0)&&(currentEnd)){
//キューエントリが存在してかつブランクを検知、次のエントリの開始または、トラック末尾に達した場合はキューの値を更新
//トラック末尾の場合のみ検出ポイントが異なるので注意
                    if((nas.CellDescription.type(entryText)=='blank')||
                       ((entryText.length>1)&&(entryText.indexOf('「')>=0))||
                       (fix==(targetTrack.length-1))){
                        var endOffset = (fix==(targetTrack.length-1))? 2:1;  
                        convertQueue[convertQueue.length-1][2]=currentEnd+endOffset;
                        currentEnd=false;
                    }else{
                        currentEnd=fix;
                    }
                }
//開きカッコを持ったテキスト長１以上のエントリがあったらオブジェクトを作成してキューに入れ
//終了点探索に入る
                if((entryText.length>1)&&
                   (entryText.indexOf('「')>=0)){
                    var dialogValue=new nas.AnimationDialog(targetTrack[fix]);
                    dialogValue.parseContent();//
                    convertQueue.push([dialogValue,fix,0]);// [値,開始フレーム,終了フレーム(未定義)]
                    currentEnd = fix;
                }
            }
//キューにあるダイアログを一括して処理
            for(var qix=0;qix<convertQueue.length;qix++){
                var dialogOffset = (String(convertQueue[qix][0].name).length)? 2:1;
                    dialogOffset += convertQueue[qix][0].attributes.length;
                var dialogDuration = convertQueue[qix][2]-convertQueue[qix][1]; 
                var startAddress =[tix,(convertQueue[qix][1] - dialogOffset)];
                var dialogStream =(convertQueue[qix][0].getStream(dialogDuration)).join(',');
                convertedXps.put(startAddress,dialogStream);
            }
        }
    }
//オプション指定文字列の反映（抽出データを一旦全て反映）
    if(optionTrailer){
        if ((optionTrailer.title).length)    convertedXps.title     = optionTrailer.title;
        if ((optionTrailer.opus).length)     convertedXps.opus      = optionTrailer.opus;
        if ((optionTrailer.subtitle).length) convertedXps.subtitle  = optionTrailer.subtitle;
        if ((optionTrailer.scene).length)    convertedXps.scene     = optionTrailer.scene;
        if ((optionTrailer.cut).length)      convertedXps.cut       = optionTrailer.cut;
    }
//リザルトを返す
    return (streamOption)?convertedXps.toString():convertedXps;
  }else{
    return false;    
  }
}
//そのほか  コレはAE用の旧バージョン変数なので要注意
    xUI.keyMethod        = KEYMethod;    //キー変換方式
    xUI.aeVersion        = AEVersion;    //キーにつけるバージョン番号

/*     xUIオブジェクト初期化メソッド
 *      編集対象となるXpsオブジェクトを与えて初期化する。
 *      初期化時点の参照変数はconfig.js内で設定された値及び
 *      nas_common.jsで処理されたオブジェクト
 *      この手順は、読込の都度実行するのは重すぎるので
 *      アプリケーション初期化時に1回だけ実行するように変更される
 */
/*
 *       新規に動作モードxUI.uiModeを実装 2016 12
 *       ドキュメントステータスと別のアプリケーションステータス（モード）として管理される
 *       モードは以下四態
 *     production|edit    :常に writeable 管理情報をユーザ編集することは無い
 *     management         :ドキュメントに対してはreadonly 管理情報に対して writeable
 *     browsing|browse    :常に readonly
 *
 *         各モード内で作業条件によって readonlyの状態が発生する
 *         セッション溯及ステータスを実装  2017 01
 * 
 *     sessionRetrace
 *         制作管理上の作業セッションはジョブに  １：１で対応する
 *         整数値で作業の状態を表す データを読み取った際にセットされる
 *         その都度のドキュメントの保存状態から計算される値なのでデータ内での保存はされない
 *     -1  :所属セッションなし(初期値)  全てwriteable
 *     0   :最新セッション 編集対象 wtiteable
 *     1~  :数値分だけ遡ったセッション 編集対象外 常にreadonly
 * 
 *         要注意  ドキュメントステータスとアプリケーションステータス(動作モード)の混同は避けること
 */


/* マルチドキュメント拡張    2018 09
 * XPSシングルドキュメントではなくxMapシングルドキュメントに変更
 * xMapに関連つけられる１以上複数のタイムシート（=SCi）
 *
 * 従来の XPS,sessionRetrace,referenceXPS 等のSCiにアタッチされるべきバッファはコレクションに収容される
 * UNDOバッファもドキュメント切り替えのたびにリセットではなく、セッション内ではドキュメントごとに保持
 * XpsはxMapの配下にアタッチする？
 * ドキュメントコレクション
 * xUI.documents = new xUI.documentCollection()
 * 
 * xUI.documents[idx]= new xUI.xMapDocument(xMap);
 * xUI.documents[idx].Xpsts=[];
 * xUI.documents[idx].sessionRetarace
 * xUI.documents[0].referenceContent;
 * xUI.documents[0].yank;
 * xUI.documents[0].yank;
 * 
 * xMap,Xpst(,Xpst,Xpst,Xpst,Xpst,…） タブに対応
 * undo関連
 * sessionRetrace  セッション
 * referenceXPS 一時参照バッファ
 * 
 */
/**
 *	@constractor
 *	ドキュメント管理単位
 *	各ドキュメントごとに編集バッファ等を保持する
 *	@params    { Object xMap|Object Xps }    targetObject
 *	@params    {　Object Xpa }	referenceObject
 *
 *	contentがxMapの場合リファレンスオブジェクトは無視される
 *  contentがxMapの場合、Selectはフォーカスのあるアセットエレメントがアドレス配列でポイントされる
 *  [アセットID(,グループID(,エレメントID))]
 *  指定配列の深度が3の場合個別のエレメント、1の場合はアセット全体、2の場合グループ全体を示す
 *  空配列の場合はフォーカスなし（初期値）
 *  Selection配列は不定長で各要素が「選択されたエレメントを示すアドレス配列」
 *  空配列の場合は選択エレメントなし
 *  contentがXpstの場合、Selectはフォーカスのあるタイムシートセルがアドレス配列でポイントされる
 *  [タイムライントラックID,フレームID]
 *  アドレス配列は必ず二次元 タイムシートの範囲外の指定も可能
 *  初期値は[1,0]
 *  Selection配列は不定長で各要素が「選択されたエレメントを示すアドレス配列」
 *  または「起点セル座標と範囲指定ベクトルのセット」の配列
 *  または旧指定互換の「フォーカスセルからの範囲指定ベクトル」
 *  Selectionプロパティの第一要素が配列の場合は前者、スカラの場合は後者
 */
xUI.Document=function(targetObject,referenceObject){
        this.parent           = xUI.documents;
        this.content          = targetObject;
        this.type             = (targetObject instanceof xMap)? "xmap":"xpst";
        this.Select           = (targetObject instanceof xMap)?[]:[0,0];
        this.Selection        = (targetObject instanceof xMap)?[]:[0,0];
        this.undoBuffer       = new xUI.UndoBuffer();
        this.sessionRetrace   = -1;
        this.referenceContent = (referenceObject instanceof Xps)? referenceObject:null;
        this.id;
        if(this.type == 'xmap'){
            this.content.readIN = xUI._readIN_xmap;
        }else{
            this.content.readIN = xUI._readIN_xps;
        }
}
/*  アクティブドキュメントを切り替える
    ドキュメント自身の切り替えメソッドとして実装する
    deactivate|activate 両方を作成することで分岐をクリアにする
	deactivate は基本的にactivateメソッドから呼び出す機能であり他者から呼ばれることはない
*/
/** ドキュメントをディアクティブする際に各種情報を書き戻す*/
xUI.Document.prototype.deactivate = function(){
    if(this.id != 0){
        this.referenceContent = xUI.referenceXPS;
    }
    this.Select         = xUI.Select;
    this.Selection      = xUI.Selection;
    this.sessionRetrace = xUI.sessionRetrace;// = this.sessionRetrace;
    return;
}
xUI.Document.prototype.activate = function(){
  if(xUI.activeDocument) xUI.activeDocument.deactivate();
    xUI.activeDocument   = this;
    xUI.activeDocumentId = this.id;
    if(this.id > 0){
        if(xUI.XPS !== xUI.activeDocument.content){
             xUI.XPS = xUI.activeDocument.content;
            if((this.referenceContent)&&(xUI.referenceXPS !== this.referenceContent)) xUI.referenceXPS = this.referenceContent;
            xUI.Select      = this.Select;
            xUI.Selection   = this.Selection;
            xUI.delayRefreash   = true;
        }
    }else{
//        xUI.delayRefreash   = true;
    }
//    xUI.undoBuffer      = this.undoBuffer;undoBufferの切り替えは不要
    xUI.sessionRetrace  = this.sessionRetrace;
//    if(this.id > 0) xUI.resetSheet();//?
    xUI.reDrawDocumentTab();
    return this.id;
}
/**/
xUI.Document.prototype.setReference = function(content){
    if (content instanceof Xps){
    	this.referenceContent = content;
    	xUI.referenceXPS = this.referenceContent;
    	if(this.id == xUI.activeDocumentId ) xUI.resetSheet();
    	return this.id;
	}
	return false;
}
/**
    ドキュメントトレーラーコレクション配列
    内容は現在編集中のドキュメントすべて
    ID:0  は必ずxMap
    ID:1~ は必ずXpst
    兼用カットがある場合は、順次IDが増す
    XpstのPmNode(Job)違いは、ドキュメントとして増加するのでなくxMapとは別にNodeControlを行い。一つのドキュメントとして扱う
*/
xUI.documents=[];
    xUI.documents.currentNode;//フォーカスのある管理ノードを保持する一時変数
    xUI.documents.currentCompositeNode;//フォーカスのあるコンポジットノードを保持する一時変数
/**
 *  ドキュメントキャリア初期化メソッド
 *  配下のメソッドが正常に働くように初期化を行う
 *  @params {}引数  なし
 *  戻値  初期化の成功または失敗のフラグ
 */
xUI.documents.init = function(){
console.log('go init documents XPS');
//マスタードキュメントが未設定の場合 カラxMap で設定する
    if(this.length == 0){
console.log('set default xMap')
    	this[0]    = (xUI.XMAP)? new xUI.Document(xUI.XMAP):new xUI.Document(new xMap());
    	this[0].id = 0;
    	xUI.XMAP   = this[0].content;
    }
//マスタードキュメントの兼用カットをセット・アップ
console.log(decodeURIComponent(xUI.XMAP.getIdentifier()));
console.log('setup inherit : '+ xUI.XMAP.pmu.inherit.join(' / '));
	for (var xid = 0 ; xid < xUI.XMAP.pmu.inherit.length ; xid ++){
console.log('setup : inherit : '+ xid +' : '+xUI.XMAP.getIdentifier('xps',xid));
		var idx    = xid + 1;
		var myIdf  = xUI.XMAP.getIdentifier('xps',xid);
		var myShot = serviceAgent.currentRepository.entry(myIdf);
if(myShot){
//エントリの有無に関わらず一旦クラスメソッドでバルクシートを取得・設定
		var myXps  = xMap.getXps(xUI.XMAP,xid);
		xUI.documents[idx] = new xUI.Document(myXps);
		this[idx].id = idx;
		if(xid == 0 ){
			xUI.XPS = this[1].content;
		}else{
			if(
				(! this[0].content.contents)||
				(this[0].content.contents[idx] !== this[xid].content)
			){
				this[0].content.contents[idx] = this[xid].content;
				if(this[xid].content.xMap !== this[0].content)
					this[xid].content.xMap = this[0].content;
			}
		}
console.log(myShot);
		if(myShot.token){
//トークンがあれば、既登録カット
//実際のアクセス先はUATサーバとローカルで異なる。このトークンで呼び出し可能なケースとそうでない場合があるので注意
//localRepository.getEntry側の修正で対応すべし
//リポジトリ呼び出しでバックグラウンド処理
console.log('entry exists --------- getEntry '+myIdf);
			serviceAgent.currentRepository.getEntry(myIdf,false,
			function(result){
console.log(result);
                xUI.documents.setContent(result);
            });
        }
        continue;
}else{
//リポジトリ未登録新規カット または ショット(カット番号)のない特殊エントリ　EXTRA
console.log('no STDBentry EXTRA or new Document !')
    var myXps = xMap.getXps(xUI.XMAP,xid);
    if (xid == 0){
        xUI.XPS = myXps;
        if (!(xUI.XMAP.contents)) xUI.XMAP.contents = [xUI.XPS];
    }
    xUI.documents[idx] = new xUI.Document(myXps);
    this[idx].id = idx;
}
	}
console.log('activate 0')
	xUI.activeDocument = xUI.documents[0];
	xUI.activeDocumentId = xUI.documents[0];
	xUI.documents.targetId = 0;

    xUI.documents[0].activate();
//    xUI.resetSheet();//ここでは不要
    xUI.resetReceipt();
    xUI.reDrawDocumentTab();
//        xUI.setUImode('browsing');
    if($('#optionPanelFile').isVisible()) xUI.sWitchPanel('File');
};//init
/**
    ドキュメントIDを指定してアクティベートする
*/
xUI.documents.activate=function(idx){return this[idx].activate();}
/*
    ドキュメントコレクションをクリアする
    xUI.XMAP xUI.XPSが、直前状態で残ることに注意
*/
xUI.documents.clear=function(){
    this.length=0;
    xUI.activeDocument = null;
    xUI.activeDocumentId = -1;
    this.targetId = 0;
}
/*
    ドキュメントコレクションメンバーのステータスを一括で変更する
*/
xUI.documents.setStatus=function(status){
    for (var ix = 0 ;ix < this.length; ix ++){
        this[ix].content.pmu.nodeManager.setStatus(status);
    }
}
/**<pre>
 *   xUI.documents データ読み込みメソッド
 *   引数で渡されたデータをdocumentsに適用する
 *   適用成功時は引き渡しデータのアクテイベートを行う?
 *  動作を単純化する
 *  xMapが与えられた場合、documents全体をクリアしてid:0にロード
 *  Xpsが与えられた場合、xMapの所属カット以外はリジェクト
 *  Xpsには、同時にリファレンスを与えることが可能
 *  </pre>
 *    
 *  @params     {String|Object initial document}    documentSource
 *      document source string | (xMap|Xps)
 *  @params     {Boolean}   referenceXps
 *      引数データが初期化データであるか否か xMapの場合は必ず初期化データとなる。
 *	@returns	設定成功時は true それ以外は false|undefined
 *		引数データが配置されたドキュメントID 設定が行われなかった場合の戻り値は -1　(存在しないドキュメントID)
 */
xUI.documents.setContent=function(documentSource,referenceXps){
    if((!(documentSource))||(String(documentSource).length == 0)) return -1;
    var isSource = false;
	if(documentSource instanceof xMap){
        var dataType = 'xmap';
	}else if(documentSource instanceof Xps){
        var dataType = 'xpst';
	}else if(documentSource.match(/^nas(TIME-SHEET|MAP-FILE)\s/)){
/*データストリームの冒頭をチェックしてデータタイプを判別*/
        var dataType = {'TIME-SHEET':'xpst','MAP-FILE':'xmap'}[RegExp.$1];
        isSource = true
    }else{
        return -1;
    }
//xMapが与えられた場合　ドキュメント全体の初期化を行う
//console.log([documentSource,dataType,isSource]);
    if(dataType == 'xmap'){
        if(isSource){
        	var startupxMap     = new xMap();
        	startupxMap.readIN  = xUI._readIN_xmap;
        	var iptM = startupxMap.parsexMap(documentSource);
        	if(!(iptM)) return -1;
        }else{
        	var startupxMap     = documentSource;
        	documentSource      = startupxMap.toString();
        }
        if(startupxMap){
//初期化データとしてxmapを設定して環境構築
//console.log('init all DocumentData');console.log(startupxMap);console.log(this);
//初期化データがデータベース内に存在するか否かを判定しない　セットのみ行う
            if((this.length > 1)&&(startupxMap !== this[0].content)){
                xUI.documents.clear();
            }
            if(xUI.XMAP !== startupxMap){
                xUI.documents[0]= new xUI.Document(startupxMap);
                xUI.documents[0].id=0;
                xUI.documents[0].content.contents = [];
                xUI.XMAP = startupxMap;
            }
//この時点ではXpsの設定を行わず documents.initに渡す
//initでは、マスタードキュメントのカット可能であればDBに請求　不成功場合バルクシートを作り初期化を行う
            this.init();
            return 0;
        }else{
            console.log(documentSource);
            return -1;
        }
//================================================ここまでがxmap本処理 それ以外は以下のパスへ
    }else if(dataType == 'xpst'){
console.log([documentSource,dataType,isSource]);
    	if(isSource){
        	var importXps     = new Xps();
        	importXps.readIN  = xUI._readIN_xps;
        	var iptx = importXps.parseXps(documentSource);
        	if(! iptx) return -1;
        }else{
        	var importXps     = documentSource;
            documentSource    = importXps.toString();
        }
console.log('set content Xpst data :');
console.log(importXps.getIdentifier());
//XpsがxMapにマッチしない場合はリジェクト
        if (
            (!(xUI.documents[0].content instanceof xMap))||
            (nas.Pm.compareIdentifier(importXps.getIdentifier(),xUI.documents[0].content.getIdentifier(),false,false)    < 1)
        ){
console.log('Xpst no match current xMap : rejected '+ importXps.getIdentifier());
            return -1;
        }
        if(importXps){
        	var targetId = xUI.XMAP.pmu.inherit.findIndex(function(element){
        		return (nas.Pm.compareCutIdf(element.toString('cut'),importXps.pmu.inherit[0].name) == 0);
        	}) + 1;
console.log('set Xps :'+importXps.pmu.toString() + ' to xUI.documents :' + targetId);
//console.log(this);
            if(targetId > 0 ){
                if(xUI.documents[targetId]){
                    xUI.documents[targetId].content.readIN(documentSource);
            	    if(xUI.documents[targetId].content.xMap !== xUI.documents[0].content) xUI.documents[targetId].content.xMap = xUI.documents[0].content;
                }else{
            	    xUI.documents[targetId] = new xUI.Document(importXps,referenceXps);
            	    xUI.documents[targetId].id = targetId;
            	    xUI.documents[0].content.contents.add(xUI.documents[targetId].content);
            	    if(xUI.documents[targetId].content.xMap !== xUI.documents[0].content) xUI.documents[targetId].content.xMap = xUI.documents[0].content;
                }
                if(xUI.XPS === xUI.documents[targetId].content) xUI.resetSheet()
            	return targetId;
            }else{
                console.log(documentSource);
                return -1;//想定外エラー
            }
        }else{
        	console.log(documentSource);
        	return -1;//カット違い
        };
	}else{
    	console.log(documentSource);
        return -1;//不正データが与えられたので読み込み失敗
    }
}

/**<pre>
 *   xUI.documents データ読み込みメソッド
 *   引数で渡されたデータをdocumentsに適用する
 *   適用成功時は引き渡しデータのアクテイベートを行う?
 *  動作を単純化する
 *  xMapが与えられた場合、同一オブジェクトで無いかぎりdocuments全体をクリアしてid:0にロード
 *  Xpsが与えられた場合、xMapの所属カット以外はリジェクト
 *  Xpsには、同時にリファレンスを与えることが可能
 *  </pre>
 *    
 *  @params     {String|Object initial document}    documentSource
 *      document source string | (xMap|Xps)
 *  @params     {Boolean}   referenceXps
 *      引数データが初期化データであるか否か xMapの場合は必ず初期化データとなる。
 *	@returns	設定成功時は true それ以外は false|undefined
 *		引数データが配置されたドキュメントID 設定が行われなかった場合の戻り値は -1　(存在しないドキュメントID)
 *
xUI.documents.setContent__=function(documentSource,referenceXps){
    if(String(documentSource).length == 0) return false;
    var isSource = false;
	if(documentSource instanceof xMap){
        var dataType = 'xmap';
	}else if(documentSource instanceof Xps){
        var dataType = 'xpst';
	}else if(documentSource.match(/^nas(TIME-SHEET|MAP-FILE)\s/)){
/*データストリームの冒頭をチェックしてデータタイプを判別
        var dataType = {'TIME-SHEET':'xpst','MAP-FILE':'xmap'}[RegExp.$1];
        isSource = true
    }else{
        return false;
    }
//console.log(documentSource,referenceXps);
    if(dataType == 'xmap'){
        if(isSource){
        	var startupxMap     = new xMap();
        	startupxMap.readIN  = xUI._readIN_xmap;
        	if(!(startupxMap.readIN(documentSource))) return false;
        }else{
        	var startupxMap     = documentSource;
        }
        if(startupxMap){
//初期化データとしてxmapを設定して環境構築
console.log('init all DocumentData');console.log(startupxMap);console.log(this);
            xUI.documents.clear();
            xUI.documents[0]= new xUI.Document(startupxMap);
            xUI.documents[0].id=0;
            xUI.documents[0].content.contents = [];
            xUI.XMAP = xUI.documents[0].content;
/*
//開始xMapにinheritがある
            if(startupxMap.pmu.inherit.length){
                for (var xix=0;xix<startupxMap.pmu.inherit.length;xix++){
                    var targetIdf = startupxMap.getIdentifier('xps',xix);//Floatingが戻るのは？
                    xUI.documents[xix+1] = new xUI.Document(new Xps());
                    xUI.documents[xix+1].id = xix+1;
//startupxMap.contents[xix] = xUI.documents[xix+1].content;
console.log(targetIdf);
                    if(serviceAgent.currentRepository.entry(targetIdf)){
                        xUI.documents.targetId = xix+1;
                        serviceAgent.getEntry(targetIdf);
                    }else{
                        xUI.documents[xix+1].content = new Xps(
                            undefined,
                            xUI.XMAP.pmu.inherit[xix].time,
                            xUI.XMAP.framerate,
                            xUI.XMAP,
                            xUI.XMAP.pmu.nodeManager.getNode('*.*.*.').getPath()
                        );
                        //this[xix+1].content.syncIdentifier(targetIdf);
                    }
                    xUI.documents[0].content.contents[xix] = xUI.documents[xix+1].content;
                }
            }else{
//これは異常処理 inherit.length==0　のケースはエラーでも良いかも？ ⇒EXTRAがある
                var blankXps      = new Xps();
                blankXps.xMap = xUI.XMAP;
                xUI.documents[1]= new xUI.Document(blankXps);
                xUI.documents[1].id=1;
                xUI.documents[0].content.contents = [blankXps];
            };// /
            xUI.documents[0].activate();
//            xmapExtension();//仮コード
            xUI.resetReceipt();
            xUI.reDrawDocumentTab();
            return true;
        }else{
            console.log(documentSource);
            return false;
        }
//こちら本処理 それ以外はこの処理へのパス
    }else if(dataType == 'xpst'){
console.log(documentSource);
console.log(isSource);
    	if(isSource){
        	var importXps     = new Xps();
        	importXps.readIN  = xUI._readIN_xps;
        	if(!(importXps.readIN(documentSource))) return false;
        }else{
        	var importXps     = documentSource;
        }
console.log(importXps);
        if (nas.Pm.compareIdentifier(importXps.getIdentifier(),xUI.documents[0].content.getIdentifier())<1) return false
//console.log(xUI.documents.targetId);
//      	if(xUI.documents.targetId>0){
        	if(importXps){
            /*	if(nas.Pm.compareIdentifier(
                    importXps.getIdentifier(),
                    this[0].content.getIdentifier()
            	)>0){
                	var docId = -1;
                	for (var ix=0;ix<this[0].content.pmu.inherit.length;ix++){
                    	if(nas.Pm.compareCutIdf(
                        	[importXps.scene,importXps.cut].join('-'),
                        	this[0].content.pmu.inherit[ix].toString()
                    	) == 0) {docId = ix+1;break;}
                	};// /
                	if(this.targetId > 0 ){
                    	xUI.documents[xUI.documents.targetId]    = new xUI.Document(importXps,referenceXps);
                    	xUI.documents[xUI.documents.targetId].id = xUI.documents.targetId;
                    	xUI.documents[xUI.documents.targetId].activate();
                    	xUI.documents.targetId = 0;

                    	return true;
                	}else{
                    	console.log(documentSource);
                    	return false;//想定外エラー
                	}
            /*	}else{
                	console.log(documentSource);
                	return false;//カット違い
            	};// /
        	}else{
               console.log(documentSource);
               return false;//不正データが与えられたので読み込み失敗
            }
//        }else{
/*  この配下は　xMapなしでXpsを読み込む際の手続き
 *   XpsからxMapを取得して取得して再帰処理
 *   XpsからxMapを得ることが必要　現在のリポジトリに必要な情報を与えてxMapを取得する。
 *   この下側の処理の大半はRepository.getxMmap(idf)の機能へ移動
 /
/*
console.log(importXps);
console.log(decodeURIComponent(nas.Pm.getIdentifier(importXps,'cut')));
            if(importXps){
                serviceAgent.getxMap(nas.Pm.getIdentifier(importXps,'cut'),null,null);
                return true;

                var dtForm = nas.checkDataPath(importXps.mapfile);
                if(dtForm){
                    switch (dtForm){
                    case 'idf':
                        var mapIdentifier = importXps.mapfile;
                        if (! mapIdentifier.match(/\.xmap$/)) mapIdentifier +='.xmap';
                    break;
                    case 'win':
                    case 'unix':
                    case 'URL':
                    default:
//ファイル等リポジトリ外部のストレージへの参照は2019.0607未サポート　不明データと同じ扱いにする
                        var mapIdentifier = nas.Pm.getIdentifier(importXps)+".xmap";
                    }
                }else{
//mapfile プロパティの記載がないのでシート識別子を転用
                    var mapIdentifier = nas.Pm.getIdentifier(importXps)+".xmap";
                }
                var mapEntry = serviceAgent.currentRepository.entry(mapIdentifier);
                if(mapEntry){
//リポジトリ内にある エントリーキーで取得
console.log(mapEntry);//リポジトリ内のxMapを使用
                    return serviceAgent.getEntry(mapEntry);//再起呼び出し（レスポンスは不定）
                }else{
//マップデータから生成したデータを設定 リポジトリ内のデータで、自身を更新
console.log('*=====　マップデータから生成したデータを設定')
console.log(decodeURIComponent(nas.Pm.getIdentifier(importXps)))
                    var newxMap = Xps.getxMap(importXps);
                    var listEntry = serviceAgent.currentRepository.entryList.getByIdf(nas.Pm.getIdentifier(importXps));
console.log(listEntry);
//                    for (var iix = 0 ;iix < listEntry.issues.length ; iix++){
//console.log(listEntry.issues[iix]);
//                    }
					return this.setContent(newxMap);
                };// */
/*            }
//処理可能なXpsがない
			return false;
        };//
    }
 console.log(xUI.documents);
//	xUI.XMAP = this[0].content;
//	xUI.XPS  = ( xUI.activeDocumentId > 0 )? this[xUI.activeDocumentId].content:this[1].content;
	return undefined;
}
*/

/* TEST
xUI.docuemnts.setContent(startupDocument);
*/
/**
 *	読み込みメソッド
 *	xMap.parsexMapのラッパ関数
 *  @params {String}  datastream
 *	@returns {Object xMap|false}
 *       parsexMap の戻り値を返す
 *   コンバータが必要な場合はここに設置する
 *  {Object xMap}.readIn(datastream)　として使用する
 */
xUI._readIN_xmap=function(datastream){return this.parsexMap(datastream)};

/**
        Xpsクラスメソッドを上書きするためのファンクション
        データインポートを自動判定
        xUI.sessionRetrace == -1    通常の読み出し
        xUI.sessionRetrace == 0     内容のみ入れ替え
        xUI.sessionRetrace > 0     読み込んだ後に-1にリセット
        
 *	Xps.parseXpsのラッパ関数
 *  @params {String}  datastream
 *	@returns {Object Xps|false}
 *       parsexMap の戻り値を返す
 *   コンバータが必要な場合はここに設置する
 */
xUI._readIN_xps=function(datastream){
    xUI.errorCode=0;//読み込みメソッドが呼ばれたので最終のエラーコードを捨てる。
    if(! datastream.toString().length ){
      xUI.errorCode=1;return false;//"001:データ長が0です。読み込みに失敗したかもしれません",
    }else{
//データが存在したら、コンバータに送ってコンバート可能なデータをXPS互換ストリームに変換する
/**
        データインポートは自動判定
        xUI.sessionRetrace == -1    通常の読み出し
        xUI.sessionRetrace == 0     内容のみ入れ替え
        xUI.sessionRetrace > 0     読み込んだ後に-1にリセット
    import判定がtrueの場合、現データの以下のプロパティを保護する
    カット尺を保護する場合は、リファレンスに読み込んで部分コピーを行う
*/
        var isImport=((xUI.sessionRetrace==0)&&(xUI.uiMode=='production'))? true:false;
        var newXps = xUI.convertXps(datastream,"",{},false);
/*
読み込まれたデータ内にシナリオ形式のダイアログ記述が存在する可能性があるので、これを探して展開する
現在は処理をハードコーディングしてあるが、この展開処理はトラックを引数にして処理メソッドに渡す形に変更する予定
*/
//ここでセリフトラックのチェックを行って、シナリオ形式のエントリを検知したら展開を行う
console.log(newXps)
    for(var tix=0;tix<newXps.xpsTracks.length;tix++){
        var targetTrack=newXps.xpsTracks[tix]
        if(targetTrack.option=='dialog'){
            var convertQueue=[];//トラックごとにキューを置く
            var currentEnd =false;//探索中の終了フレーム
            
            for(var fix=0;fix<targetTrack.length;fix++){
                var entryText=String(targetTrack[fix]);
//末尾検索中
                if((convertQueue.length>0)&&(currentEnd)){
//キューエントリが存在してかつブランクを検知、次のエントリの開始または、トラック末尾に達した場合はキューの値を更新
//トラック末尾の場合のみ検出ポイントが異なるので注意
                    if((nas.CellDescription.type(entryText)=='blank')||
                       ((entryText.length>1)&&(entryText.indexOf('「')>=0))||
                       (fix==(targetTrack.length-1))){
                        var endOffset = (fix==(targetTrack.length-1))? 2:1;  
                        convertQueue[convertQueue.length-1][2]=currentEnd+endOffset;
                        currentEnd=false;
                    }else{
                        currentEnd=fix;
                    }
                }
//開きカッコを持ったテキスト長１以上のエントリがあったらオブジェクトを作成してキューに入れ
//終了点探索に入る
                if((entryText.length>1)&&
                   (entryText.indexOf('「')>=0)){
                    var dialogValue=new nas.AnimationDialog(targetTrack[fix]);
                    dialogValue.parseContent();//
                    convertQueue.push([dialogValue,fix,0]);// [値,開始フレーム,終了フレーム(未定義)]
                    currentEnd = fix;
                }
            }
//キューにあるダイアログを一括して処理
            for(var qix=0;qix<convertQueue.length;qix++){
                var dialogOffset = (String(convertQueue[qix][0].name).length)? 2:1;
                    dialogOffset += convertQueue[qix][0].attributes.length;
//console.log(dialogOffset);
                var dialogDuration = convertQueue[qix][2]-convertQueue[qix][1]; 
                var startAddress =[tix,(convertQueue[qix][1] - dialogOffset)];
//console.log(startAddress);
                var dialogStream =(convertQueue[qix][0].getStream(dialogDuration)).join(',');
//console.log(dialogStream);
                newXps.put(startAddress,dialogStream);
            }
        }
    }
//インポートが必要な場合は、新規オブジェクトに現行のドキュメントから固定対象のプロパティを転記する
//
        if(isImport){
/*
            "xMap",         ;//Object xMap      ドキュメント側を使用（xMap実装後はマージが必要マージメソッドを作成）
            "line",         ;//Object XpsLine   ドキュメント側を使用   
            "stage",        ;//Object XpsStage  ドキュメント側を使用
            "job",          ;//Object XpsJob    ドキュメント側を使用
            "currentStatus",;//Object JobStatus ドキュメント側を使用
            "mapfile",      ;//String           ドキュメント側を使用
            "opus",         ;//String           ドキュメント側を使用
            "title",        ;//String           ドキュメント側を使用
            "subtitle",     ;//String           ドキュメント側を使用
            "scene",        ;//String           ドキュメント側を使用
            "cut",          ;//String           ドキュメント側を使用
//          "trin",         ;//Array                        インポート側を使用
//          "trout",        ;//Array                        インポート側を使用
//          "rate",         ;//Strting                      インポート側を使用
//          "framerate",    ;//String                       インポート側を使用
            "create_time",  ;//String           ドキュメント側を使用
            "create_user",  ;//Object UserInfo  ドキュメント側を使用
            "update_time",  ;//Stirng           ドキュメント側を使用
            "update_user",  ;//Object UserInfo  ドキュメント側を使用
//          "xpsTracks"     ;//Object XpsTrackCollection    インポート側を使用

  */
            var props = ["xMap","line","stage","job","currentStatus","mapfile","opus","title","subtitle","scene","cut","create_time","create_user","update_time","update_user"];
            for (var ix=0;ix<props.length;ix++){newXps[props[ix]]=xUI.XPS[props[ix]]}
        }else{
            var props = ["xMap","line","stage","job","currentStatus","mapfile","opus","title","subtitle","scene","cut","create_time","create_user","update_time","update_user"];
            if((xUI.importBox.importCount==1)&&(xUI.importBox.selectedContents.length)){
                for (var ix=0;ix<props.length;ix++){
                    if(xUI.importBox.selectedContents[0][props[ix]]) newXps[props[ix]]=xUI.importBox.selectedContents[0][props[ix]];
                }
            };
        }
//        if(xUI.sessionRetrace > 0) xUI.sessionRetrace= -1;
        return this.parseXps(newXps.toString());
    }
};

/*
iconButtonColumnPalette
class ibCP
id = ibCP_00
末尾にユーザパレットを増設可能 任意数

items配列にxUI.CommandItemオブジェクトを置く
数値｜文字列であった場合はparseメソッドでcommandコレクションを検索して置き換える
ヒットしない場合は、NOPコマンドを置く

xUI.ibCP=[
	{
		label:"ラベル（キー兼用）"
		items:[0,1,2,3,4]
	},
	{
		label:"ラベル（キー兼用）"
		items:[5,6,7]
	},
	{
		label:"ラベル（キー兼用）"
		items:[5,6,4,9]
	},
	{
		label:"ラベル（キー兼用）"
		items:[0,1,2,3,4]
	},
]

4つから5つを目安に最大10程度のアイコンボタン
配列の中身はメニューオブジェクトの参照?ID?
書き出しの値はラベル:[ID配列]

切替メソッドはibCPオブジェクトにアタッチする

現在(2020.04.12)メニューアイテムはHTML内のデータを使い切替部分のみが有効
本体の初期化は省略　初期化メソッド内で実行予定
最終ニューはクッキーでの保存対象
*/

xUI.ibCP=[0,1,2,3,4,5,6];//配列仮値
xUI.ibCP.init = function(){
    for (var l = 0 ; l < this.length ; l ++ ){
        for (var m = 0 ; m < this[l].items.length ; m ++ ){
            var cmd = this[l].items[m];
            if(! cmd instanceof xUI.CommandItem){
                cmd = xUI.commands.find(function(elm){return ((elm.id==cmd)||(elm.key==cmd))});
                if(! cmd){
                    cmd = xUI.CommandItem[0];
                }
            }
        }
    }
}
xUI.ibCP.toString=function(){
    var result = '';
    for (var l = 0 ; l < this.length ; l ++ ){
        result += '<span id="ibCP_'+nas.Zf(l,2)+'" class="ibCP">'
        for (var m = 0 ; m < this[l].items.length ; m ++ ){
            var cmd = this[l].items[m];
            result += '<button';
            result += ' id  ="ibC'+cmd.label+'"';
            result += ' data-i18n="[title]'+ cmd.label +'_description"';
            result += ' class = "boxButton iconButton-'+ "cmd.icon" +'"';
            result += ' onclick="'+cmd.function+'";';
//            result += ' onclick="xUI.commands.exec('+cmd.id+');"';
            result += '>';
            result += '</button>';
            result += '';
        }
        result += '</span>\n';
    }
    result += '';
}
/**
	メニューを切替える
	params	{Number}	ix
	    表示するパレットID　0~
	  引数がない場合は現在表示しているひとつ前のパレットを表示
	  -1を指定するとツールバーを非表示にする
*/
xUI.ibCP.switch=function(ix){
	if(typeof ix == 'undefined') ix = this.activePalette + this.length - 1;
	if(ix < 0){xUI.sWitchPanel();return;}
	this.activePalette = ix % this.length;
	var tgtMenu ;
	for (var iy= 0;iy<this.length;iy++){
		tgtMenu = $('#ibCP_'+nas.Zf(iy,2));
		if(iy == this.activePalette){tgtMenu.show();}else{tgtMenu.hide();}
	}
};
xUI.ibCP.switch(0);

/** xUIの初期化メソッド
引数にオブジェクト（Xps/xMap）を渡す
ソース渡しが発生している
    オブジェクトがxMapの場合は、アタッチされたXpsをすべてドキュメントトレーラーにセットして開始
    Xpsが未設定の場合は、Xpsの初期化は保留
    
    オブジェクトがXpsの場合は、Xpsに関連づけられたxMapを呼び出してドキュメントトレーラーを設定
    xMapが存在しない場合は、新しいxMapを初期化してURLのないまま使用する
  
*/
xUI.init    =function(targetObj,referenceObj){
console.log("Init xUI !");
console.log(targetObj);
console.log(referenceObj);

xUI.contextMenu = $('#contextMenu');
xUI.documents.init();
console.log(this.XMAP.toString());
console.log(this.XPS.toString());
/*	documentsにオブジェクト渡し */
//console.log(targetObj)
	var setResult = this.documents.setContent(targetObj,referenceObj);//ターゲットの判定はメソッドに委ねる
//console.log(this.activeDocument);
console.log(this.XMAP.toString());
console.log(this.XPS.toString());
//	if((setResult)&&(referenceObj)&&(referenceObj instanceof Xps)){this.documents[xUI.activeDocumentId].referenceDocument=referenceObj}
/** 以下は  Xmapに対しての拡張
    xMap コントロールは分離可能に？
    acriveDocumentIdは、以下の遷移をする
    0   ドキュメントの代表となるxMap
        xMapは１番以降のドキュメントにはならない
    1~  0番ドキュメントに含まれるCSCiにアタッチされるXpst
        一個以上、複数

以下の拡張分は　xUI.Document.activate メソッドに移行して削除

    this.XMAP = this.documents[0].content;               //編集対象のxMap　バッファの切替はactiveteメソッドに移動
    this.XPS  = this.documents[1].content;               //XPSを参照する編集バッファ　バッファの切替はactiveteメソッドに移動

    this.activeDocumentId = 1;//仮設プロパティ マルチシート拡張を行った後にシートの切り替えを行うようになる

    this.tabCount=this.documents.length;

    this.activeDocument     =  this.documents[this.activeDocumentId];

    this.sessionRetrace = -1;//this.activeDocument.settionRetrace;//                   //管理上の作業セッション状態
    this.referenceXPS=new Xps(5,nas.SheetLength+':00.');           //参照用Xps初期値 */

/**
引数に参照オブジェクトが渡されていたら、優先して解決
    マルチステージ拡張実装後、直接指定された参照ステージは、初期化時のみ優先 
    参照用XPSは初期化の引数で与える（優先）
    初期化時点で参照Xpsが与えられなかった場合は、XPSに含まれる参照ステージの内容
    XPS内のステージストアにある現行ステージの前段のステージを利用する
    セットアップのタイミングはUIの初期化以降に保留される
*/
    if ((typeof referenceObj != "undefined") && (referenceObj instanceof Xps)){
        this.referenceXPS=referenceObj;
    };
/**
    参照Xpsのうち表示させる種別をプロパティ名の配列で与える
    キーワード機能未実装:
        "all"=["replacement","timing","camerawork","effect","still","dialog","sound"],
        "cell(スチル含む)"=["timing","still"]
        "replacement",
        "timing",
        "camerawork",
        "effect",
        "still",
        "dialog",
        "sound"
 */
    this.referenceLabels=new Array();   //表示させるトラックのID配列（後ほど初期化）
    this.referenceView=["timing","cell","replacement"];      
    this.refRegex=new RegExp(xUI.referenceView.join("|"));
/** 
    以下UI動作制御変数
    viewMode    ページ単位表示か又は全体を1ページ1カラムで表示させるかのフラグ
        Compact (by scroll)
        WordProp (by page)
    uiMode      編集/管理/閲覧モードのフラグ
        browsing
            サーバ上のデータを開いて内容をブラウズしている状態
            書込／変更は禁止
        production
            作業中  他ユーザはproductionに移行できない
        management
            管理中  カットのプロパティが変更できるが、内容は編集できない
    viewOnly    編集禁止（データのreadonlyではなくUI上の編集ブロック）
*/
    this.restriction = false;           // 操作制限フラグ boolean
    this.viewMode    = ViewMode;        // 表示モード Compact/WordProp Scroll/Page
    this.uiMode      = 'browsing';      // ui基本動作モード production/management/browsing
    this.viewOnly    = false;           // 編集禁止フラグ
    this.hideSource  = false;           // グラフィック置き換え時にシートテキストを隠す
    this.showGraphic = true;            // 置き換えグラフィックを非表示  ＝  テキスト表示
//if(appHost.platform=="AIR") this.showGraphic    = false;
    this.onSite   = false;           // Railsサーバ上での動作時サーバのurlが値となる
    this.currentUser = new  nas.UserInfo(myName); // 実行ユーザをmyNameから作成
    this.recentUsers = new nas.UserInfoCollection(myNames);//最近のユーザ情報
    sync("recentUsers");
/*
    recentUsers 配列の要素は、UserInfo オブジェクト
    myNamesは、アカウント文字列を要素とする配列
    ユーザインフォコレクションの構造変更で配列ベースでなく  メンバー配列を持ったオブジェクトに更新
*/
    this.spinValue   = SpinValue;       // スピン量
    this.spinSelect  = SpinSelect;      // 選択範囲でスピン指定
    this.sLoop       = SLoop;           // スピンループ
    this.cLoop       = CLoop;           // カーソルループ
//    this.utilBar     = true;            // サブツールバーの初期状態
    this.SheetLength    = SheetLength;  // タイムシート1枚の表示上の秒数 コンパクトモードではシート長が収まる秒数に強制される
//コンパクトモード時はこのプロパティとcolsの値を無視するように変更
    this.SheetWidth= this.XPS.xpsTracks.length; // シートの幅(編集範囲)

//シートのルックを求めるためのプロパティ
    this.dialogCount    = 1;    // セリフトラックの総数
    this.soundCount     = 0;     // 音響トラックの総数
    this.stillCount     = 0;    // 静止画トラックの総数
    this.timingCount    = 4;    // 置換トラックの総数
    this.stageworkCount = 0;    // ステージワークトラックの総数
    this.sfxCount       = 0;    // 効果トラックの総数
    this.cameraCount    = 0;    // カメラトラックの総数
    this.dialogSpan     = 1;    // シート左にあるセリフ・音響トラックの連続数
    this.cameraSpan     = 0;    // シート右の非置き換えトラックの連続数
    this.timingSpan     = this.XPS.xpsTracks.length-(this.cameraSpan+this.dialogSpan+1);//カメラ（非画像トラックの合計）
    this.SheetWidth     = this.XPS.xpsTracks.length;
    this._checkProp();


    this.PageLength         =this.SheetLength*Math.ceil(this.XPS.framerate);  //1ページの表示コマ数を出す
//    1秒のコマ数はドロップを考慮して切り上げ
    this.cPageLength        =Math.ceil(this.XPS.framerate);                  //カラム長だったけど一秒に変更
    this.sheetSubSeparator  =SheetSubSeparator;                         // サブセパレータの間隔
    this.PageCols           =SheetPageCols;                             // シートのカラム段数。
                //    実際問題としては１または２以外は使いづらくてダメ
                //    コンパクトモードでは1段に強制するのでこの値を無視する
    this.fct0               =Counter0;                                  // カウンタのタイプ
    this.fct1               =Counter1;                                  // 二号カウンタはコンパクトモードでは非表示

    this.favoriteWords      =FavoriteWords;                             // お気に入り単語
    this.footMark           =FootMark;                                  // フットマーク機能フラグ
    this.autoScroll         =AutoScroll;                                // 自動スクロールフラグ
    this.scrollStop         =false;                                     // 自動スクロール抑制フラグ
    this.tabSpin            =TabSpin;                                   // TABキーで確定操作

    this.noSync             =NoSync;                                    // 入力同期停止

    this.blmtd              =BlankMethod;                               // カラセル方式デフォルト値
                //["file","opacity","wipe","expression1","expression2"];
    this.blpos              =BlankPosition;                             // カラセル位置デフォルト値
                //["build","first","end","none"]
    this.fpsF               =FootageFramerate;                          // フッテージのフレームレート
                //コンポサイズdefeult
    this.dfX                =defaultSIZE.split(",")[0];                 // コンポサイズが指定されない場合の標準値
    this.dfY                =defaultSIZE.split(",")[1];                 //
    this.dfA                =defaultSIZE.split(",")[2];                 //
    this.timeShift          =TimeShift;                                 // 読み込みタイムシフト
//systemCLipboardに対するイベント設定
// ------------------------------------------------------------
// カット操作が行われると実行されるイベント
// ------------------------------------------------------------
window.addEventListener("cut" , function(evt){
    if(evt.target===document.getElementById('iNputbOx')){
	    evt.preventDefault();	// デフォルトのカット処理をキャンセル
	    var data_transfer = (evt.clipboardData) || (window.clipboardData);// DataTransferオブジェクト取得
	    data_transfer.setData( "text" , xUI.yankBuf.toString() );// 文字列データを格納する
    }
});
window.addEventListener("copy" , function(evt){
    if(evt.target===document.getElementById('iNputbOx')){
    	evt.preventDefault();	// デフォルトの処理をキャンセル
	    var data_transfer = (evt.clipboardData) || (window.clipboardData);// DataTransferオブジェクト取得
	    data_transfer.setData( "text" , xUI.yankBuf.toString() );// 文字列データを格納する
	}
});
window.addEventListener("paste" , function(evt){
    if(evt.target===document.getElementById('iNputbOx')){
	    var data_transfer = (evt.clipboardData) || (window.clipboardData);// DataTransferオブジェクト取得
console.log('event paste');
	    var myContent = data_transfer.getData( "text" );// 文字列データを取得
	    if ((myContent.indexOf('\n')>=0)||(myContent.indexOf('\t')>=0)){
console.log(myContent);
	        evt.preventDefault();	// デフォルトの処理をキャンセル
	        xUI.yank(myContent);
console.log(xUI.yankBuf);
            xUI.paste();	        
	    }
    }
});

//yank関連
    this.yankBuf            ={body:"",direction:""};                    // ヤンクバッファは、comma、改行区切りのデータストリームで
    this.yankBuf.valueOf=function(){return this.body;}
    this.yankBuf.toString=function(){
        var matrixArray=this.body.split('\n');
        for (var rix=0;rix<matrixArray.length;rix++){matrixArray[rix]=matrixArray[rix].split(",");};
        var transArray=[];
        for(var f=0;f<matrixArray[0].length;f++){
            transArray[f]=[];
            for (var r=0;r<matrixArray.length;r++){
            transArray[f].push(matrixArray[r][f]);
            }
            transArray[f]=transArray[f].join('\t');
        }
        return transArray.join('\n');
    }
//undo関連
    this.flushUndoBuf();
//保存ポインタ関連

//ラピッド入力モード関連
    this.eXMode =0;         //ラピッドモード変数(0/1/2/3)
    this.eXCode =0;         //ラピッドモード導入キー変数
//シート入力関連
    this.eddt   ="";        //編集バッファ
    this.edchg  =false;     //編集フラグ
    this.edmode=0;          //編集操作モード  0:通常入力  1:ブロック移動  2:区間編集
    this.floatSourceAddress = [0,0];//選択範囲及び区間移動元アドレス
    this.floatDestAddress   = [0,0];//同移動先アドレス
    this.selectBackup       ;//カーソル位置バックアップ
    this.selectionBackup    ;//選択範囲バックアップ
//    this.spinBackup         ;//スピン量をバックアップ
//区間編集バッファ
    this.floatTrack         ;//区間編集対象トラック
    this.floatSectionId     ;//編集対象セクションのID（オブジェクトそのものだと変動するのでIDのみ）
    this.floatTrackBackup   ;//区間編集トラックバックアップ（加工参照用）
    this.floatSection       ;//編集ターゲット区間
    this.floatUpdateCount   ;//フロート編集中の更新カウント
//セクション操作変数
    this.sectionManipulateOffset = ['tail',0];//区間編集ハンドルオフセット
    
//    アクセス頻度の高いDOMオブジェクトの参照保持用プロパティ
    this["data_well"]       = document.getElementById("data_well");//データウェル
    this["snd_body"]        = document.getElementById("snd_body");//音声編集バッファ


///////////
//データ配列に対してUIオブジェクトにフォーカス関連プロパティ設置

                //[カラム,フレーム]
                //初期値は非選択状態
    this.Select    =[1, 0];
                //シート上のフォーカスセル位置
                //選択位置・常にいずれかをセレクト
    this.Selection    =[0, 0];
                //選択範囲・ベクトル正方向=右・下
/*  extension for xmap　*/
// xmapExtension();
//xUI.reDrawDocumentTab();
};
//    xUIオブジェクト初期化終了 以下メソッド//    xUIオブジェクト初期化終了 以下メソッド
//
/* ============================================================================ */
/**
    現在編集対象のXPS・referenceXPSをチェックしてxUIのシートビュープロパティを更新
    どちらか単独更新の場合でも画面全体を再描画する必要があるので、このルーチンは等しく実行される
*/
xUI._checkProp=function(){
    this.dialogCount=0;this.soundCount=0;this.stillCount=0;this.timingCount=0;this.stageworkCount=0;this.sfxCount=0;this.cameraCount=0;
    this.dialogSpan=0;this.cameraSpan=0;
    for(var idx=0;idx<(this.XPS.xpsTracks.length-1);idx++){
        this.XPS.xpsTracks[idx].sectionTrust=false;
        switch(this.XPS.xpsTracks[idx].option){
            case "comment": break;//末尾はコメント予約なので判定をスキップ
            case "dialog": this.dialogCount++;break;
            case "sound" : this.soundCount++;break;
            case "still" : this.stillCount++ ;break;
            case "effect": ;
            case "sfx"   : this.sfxCount++   ;break;
            case "stage" :
            case "stagework" :
            case "geometry": this.stageworkCount++   ;break;
            case "camerawork":;
            case "camera": this.cameraCount++;break;
            case "cell": ;
            case "replacement": ;
            case "timing": this.timingCount++;break;
            default:       ;// NOP
        };
//表示域左側で連続した音声トラックの数を控える（最初に出てきたsound/dialog以外のトラックの位置で判定 ）
        if((this.XPS.xpsTracks[idx].option!= "dialog")&&(! this.dialogSpan)){this.dialogSpan=this.dialogCount};
//フレームコメントの左側の連続したcamera/sfxトラックの数を控える(最後のcamera/sfx/effect/geometry以外のトラックの位置から計算)
        if((this.XPS.xpsTracks[idx].option != "camera")&&(this.XPS.xpsTracks[idx].option!="geometry")&&(this.XPS.xpsTracks[idx].option!="sfx")&&(this.XPS.xpsTracks[idx].option!="effect")){this.cameraSpan=this.XPS.xpsTracks.length-idx-2};
//カウントする、ただしこのルーチンはこの後プロパティに変換してレイヤ数が変わるたびにプロパティとして変更するように変更されるべき。
    }
//
    this.timingSpan=this.XPS.xpsTracks.length-(this.cameraSpan+this.dialogSpan+1);//カメラ（非画像トラックの合計）
    this.SheetWidth=this.XPS.xpsTracks.length;
/*
参照するトラック数をスイッチをもとに算出
*/
    this.referenceLabels=new Array();//クリア
    this.refRegex=new RegExp(xUI.referenceView.join("|"));//更新
    for(var ix=0;ix<xUI.referenceXPS.xpsTracks.length;ix++){
        var currentTrack=xUI.referenceXPS.xpsTracks[ix].option;
        if(currentTrack.match(this.refRegex)) {
            this.referenceLabels.push(ix);//array of index
        }
    }
}
/**
    setBackgroundColor(bgColor)
    背景色を色コードで指定する
    または 色相,彩度,明度
    または 色コード,彩度,明度
    または 色コード,明度
*/
xUI.setBackgroundColor = function(c,s,v){
    if(arguments.length > 1){
        
    }


var SheetLooks = {
    SheetTextColor  :"#111111",
	SheetBaseColor	:"#ffffef",
	SelectedColor	:"#9999FF",
	RapidModeColor	:"#ffff44",
	FloatModeColor	:"#88eeee",
	SectionModeColor:"#ff44ff",
	SelectionColor	:"#f8f8dd",
	FootStampColor	:"#ffffff",
	EditingColor	:"#eebbbb",
	SelectingColor	:"#ccccaa",
	CellWidthUnit	:"px",
	TimeGuideWidth	    :36,
	ActionWidth         :20,
	DialogWidth	        :36,
	SoundWidth	        :26,
	SheetCellWidth	    :42,
	SheetCellNarrow	    :4,
	StillCellWidth	    :12,
    GeometryCellWidth   :52,
	SfxCellWidth	    :46,
	CameraCellWidth     :52,
	CommentWidth        :120,
	ColumnSeparatorWidth:4
};
SheetLooks.SheetBaseColor=bgColor;
xUI.setSheetLook(SheetLooks);xUI.footstampPaint();

}
/**
    インターフェースルック設定
    カラー・及びシートルックを更新
    分離のみ  暗色のテーマにはまだ対応していないので注意  2017.02.04
    ラップ関数を作成した方が良いかも
*/
xUI.setSheetLook = function(sheetLooks){
    this.sheetLooks=sheetLooks;
/**
    シートのカラーデータを構築
    別の関数に分離予定
        指定引数は  SheetBaseColorのみ？
*/
    if (! String(sheetLooks.SheetBaseColor).match(/^#[0-9a-f]+/i)){sheetLooks.SheetBaseColor = nas.colorAry2Str(nas.colorStr2Ary(sheetLooks.SheetBaseColor));};

//編集不可領域の背景色 背景色を自動設定  やや暗  これは初期状態で対向色を設定してその間で計算を行うように変更

    this.sheetbaseColor     = sheetLooks.SheetBaseColor;                                        //タイムシート背景色
    var baseColor = nas.colorStr2Ary(this.sheetbaseColor);  //基本色をRBGのまま配列化
//    輝度出してフラグ立てる
    this.sheetbaseDark      = (((76*baseColor[0]+150*baseColor[0]+29*baseColor[0])/255) > 0.3)? false:true;//仮のしきい値0.5

    this.sheetTextColor     = sheetLooks.SheetTextColor;//基本テキストカラー
    this.annotationColor    = nas.colorAry2Str(div(add (nas.colorStr2Ary(this.sheetTextColor),nas.colorStr2Ary(this.sheetbaseColor)),2));
    
    this.sheetblankColor    = nas.colorAry2Str(mul(nas.colorStr2Ary(this.sheetbaseColor),.95)); //編集不可領域の背景色
    this.sheetborderColor   = nas.colorAry2Str(mul(nas.colorStr2Ary(this.sheetbaseColor),.75)); //罫線基本色
    this.footstampColor     = nas.colorAry2Str(div( add (nas.colorStr2Ary(sheetLooks.FootStampColor),nas.colorStr2Ary(this.sheetbaseColor)),2));                        //フット/差分  スタンプの色 背景色との中間値
//    this.footstampColor     = sheetLooks.FootStampColor;                                        //フット/差分  スタンプの色 背景色との中間値
//       this.inputModeColor   = new Object();                                      //  入力モード色
        this.inputModeColor.NORMAL  = nas.colorAry2Str(div( add (nas.colorStr2Ary(sheetLooks.SelectedColor),nas.colorStr2Ary(this.sheetbaseColor)),2));                      //  ノーマル色
        this.inputModeColor.EXTEND  = nas.colorAry2Str(div( add (nas.colorStr2Ary(sheetLooks.RapidModeColor),nas.colorStr2Ary(this.sheetbaseColor)),2));                    //  ラピッド入力基本色
        this.inputModeColor.FLOAT   = nas.colorAry2Str(div( add (nas.colorStr2Ary(sheetLooks.FloatModeColor),nas.colorStr2Ary(this.sheetbaseColor)),2));                    //  ブロック移動基本色
        this.inputModeColor.SECTION = nas.colorAry2Str(mul( add (nas.colorStr2Ary(sheetLooks.SectionModeColor),nas.colorStr2Ary(this.sheetbaseColor)),.5));                  //  範囲編集中の色
        this.inputModeColor.SECTIONtail = nas.colorAry2Str(mul( add (nas.colorStr2Ary(sheetLooks.SectionModeColor),nas.colorStr2Ary(this.sheetbaseColor)),.45));                  //  範囲編集中の色
//        this.inputModeColor.SECTIONselection = nas.colorAry2Str( mul( add (nas.colorStr2Ary(sheetLooks.SectionModeColor),nas.colorStr2Ary(this.sheetbaseColor)),1));                  //  範囲編集中の色

    this.selectedColor    = this.inputModeColor.NORMAL;                                     //選択セルの背景色
    this.selectionColor    = sheetLooks.SelectionColor;                                     //選択領域の背景色
    this.selectionColorTail    = sheetLooks.SelectionColor;                                     //選択領域末尾背景色(sectionTail)デフォルトは同色
    this.editingColor       = sheetLooks.EditingColor;                                      //セル編集中のインジケータ
    this.selectingColor      = sheetLooks.SelectingColor;                                   //セル選択中のインジケータ
//タイムライン・ラベル識別カラ－
    this.cameraColor    = nas.colorAry2Str(div(add([0,1,0],mul(nas.colorStr2Ary(this.sheetbaseColor),6)),7));
    this.sfxColor       = nas.colorAry2Str(div(add([0,0,1],mul(nas.colorStr2Ary(this.sheetbaseColor),5)),6));
    this.stillColor     = nas.colorAry2Str(div(add([1,0,0],mul(nas.colorStr2Ary(this.sheetbaseColor),6)),7));  //タイムライン全体に着色

//中間色自動計算
        this.inputModeColor.NORMALspin=
    nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.NORMAL),mul(nas.colorStr2Ary(this.sheetbaseColor),3)),4));
        this.inputModeColor.EXTENDspin=
    nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.EXTEND),mul(nas.colorStr2Ary(this.sheetbaseColor),3)),4));
        this.inputModeColor.FLOATspin=
    nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.FLOAT),mul(nas.colorStr2Ary(this.sheetbaseColor),3)),4));
        this.inputModeColor.SECTIONspin=
    nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.SECTION),mul(nas.colorStr2Ary(this.sheetbaseColor),3)),4));
//スピン選択状態
        this.inputModeColor.NORMALspinselected=
    nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.NORMAL),mul(nas.colorStr2Ary(this.selectionColor),8)),10));
        this.inputModeColor.EXTENDspinselected=
    nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.EXTEND),mul(nas.colorStr2Ary(this.selectionColor),8)),10));
        this.inputModeColor.FLOATspinselected=
    nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.FLOAT),mul(nas.colorStr2Ary(this.selectionColor),8)),10));
        this.inputModeColor.SECTIONspinselected=
    nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.SECTION),mul(nas.colorStr2Ary(this.selectionColor),8)),10));
//選択状態
        this.inputModeColor.NORMALselection=
    nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.NORMAL),mul(nas.colorStr2Ary(this.selectionColor),5)),6));
        this.inputModeColor.EXTENDselection=
    nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.EXTEND),mul(nas.colorStr2Ary(this.selectionColor),5)),6));
        this.inputModeColor.FLOATselection=
    nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.FLOAT),mul(nas.colorStr2Ary(this.sheetbaseColor),5)),6));
        this.inputModeColor.SECTIONselection=
    nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.SECTION),mul(nas.colorStr2Ary(this.sheetbaseColor),5)),6));
//編集中
        this.inputModeColor.NORMALeddt=
    nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.NORMAL),mul([1,1,1],8)),9));
        this.inputModeColor.EXTENDeddt=
    nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.EXTEND),mul([1,1,1],8)),9));
        this.inputModeColor.FLOATeddt=
    nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.FLOAT),mul([1,1,1],8)),9));
        this.inputModeColor.SECTIONeddt=
    nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.SECTION),mul([1,1,1],8)),9));

//フロートテキスト色
    this.floatTextColor =
    nas.colorAry2Str(div(add([0,0,0],mul(nas.colorStr2Ary(this.sheetbaseColor),3)),4));


//----------------------------------------------------------------------初期状態設定
    this.spinAreaColor          = this.inputModeColor.NORMALspin;
    this.spinAreaColorSelect    = this.inputModeColor.NORMALselection;
    this.sectionBodyColor       = nas.colorAry2Str(div(add(nas.colorStr2Ary(this.inputModeColor.SECTION),mul(nas.colorStr2Ary(this.sheetbaseColor),3)),4));//?使わんかも
// ---------------------- ここまでカラー設定(再計算)
if(this.sheetbaseDark){
    this.sheetTextColor     = nas.colorAry2Str( div(sub([1,1,1],nas.colorStr2Ary(this.sheetTextColor)),2));
    this.annotationColor    = nas.colorAry2Str( div(sub([1,1,1],nas.colorStr2Ary(this.annotationColor)),2));

    this.sheetblankColor    = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.sheetblankColor)));
    this.sheetborderColor   = nas.colorAry2Str(div(sub([1,1,1],nas.colorStr2Ary(xUI.sheetborderColor)),2));
//    this.footstampColor     = nas.colorAry2Str(div(nas.colorStr2Ary(this.footstampColor),2));
    this.footstampColor     = nas.colorAry2Str(div(add (sub([1,1,1],nas.colorStr2Ary(sheetLooks.FootStampColor)),nas.colorStr2Ary(this.sheetbaseColor)),2));
        this.inputModeColor.NORMAL  = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.NORMAL)));
        this.inputModeColor.EXTEND  = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.EXTEND)));
        this.inputModeColor.FLOAT   = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.FLOAT)));
        this.inputModeColor.SECTION = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.SECTION)));
        this.inputModeColor.SECTIONtail = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.SECTIONtail)));

    this.selectedColor    = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.selectedColor)));
    this.selectionColor   = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.selectionColor)));
    this.selectionColorTail   = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.selectionColorTail)));
    this.editingColor      = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.editingColor)));
    this.selectingColor     = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.selectingColor)));
//タイムライン・ラベル識別カラ－
    this.cameraColor    = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.cameraColor)));
    this.sfxColor       = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.sfxColor)));
    this.stillColor     = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.stillColor)));

//中間色自動計算
        this.inputModeColor.NORMALspin  = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.NORMALspin)));
        this.inputModeColor.EXTENDspin = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.EXTENDspin)));
        this.inputModeColor.FLOATspin = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.FLOATspin)));
        this.inputModeColor.SECTIONspin = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.SECTIONspin)));
//スピン選択状態
        this.inputModeColor.NORMALspinselected = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.NORMALspinselected)));
        this.inputModeColor.EXTENDspinselected = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.EXTENDspinselected)));
        this.inputModeColor.FLOATspinselected = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.FLOATspinselected)));
        this.inputModeColor.SECTIONspinselected = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.SECTIONspinselected)));
//選択状態
        this.inputModeColor.NORMALselection = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.NORMALselection)));
        this.inputModeColor.EXTENDselection = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.EXTENDselection)));
        this.inputModeColor.FLOATselection = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.FLOATselection)));
        this.inputModeColor.SECTIONselection = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.SECTIONselection)));
//編集中
        this.inputModeColor.NORMALeddt = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.NORMALeddt)));
        this.inputModeColor.EXTENDeddt = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.EXTENDeddt)));
        this.inputModeColor.FLOATeddt = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.FLOATeddt)));
        this.inputModeColor.SECTIONeddt = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.inputModeColor.SECTIONeddt)));

//フロートテキスト色
    this.floatTextColor = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.floatTextColor)));


//----------------------------------------------------------------------初期状態設定
    this.spinAreaColor          = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.spinAreaColor)));
    this.spinAreaColorSelect    = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.spinAreaColorSelect)));
    this.sectionBodyColor       = nas.colorAry2Str(sub([1,1,1],nas.colorStr2Ary(this.sectionBodyColor)));
}
//================================================================================================================================ルックの適用
//タイムシート背景色をsheetbaseColorに設定
    document.body.style.backgroundColor     = this.sheetbaseColor;
    document.body.style.color               = this.sheetTextColor;
// サブテキストカラーを設定
    nas.addCssRule("th.annotationText","color:"+this.annotationColor,"screen");
    nas.addCssRule('td.Sep','color:'+this.annotationColor,"screen");
    nas.addCssRule('td.ref','color:'+this.annotationColor,"screen");
    
//ヘッダとフッタの背景色をシート背景色で塗りつぶし
    document.getElementById("fixedHeader").style.backgroundColor = this.sheetbaseColor;

    nas.addCssRule("table.sheet","background-color:"+this.sheetbaseColor,"screen");
    nas.addCssRule("table","border-color:"+this.sheetbaseColor,"screen");
    nas.addCssRule("th","border-color:"+this.sheetborderColor,"screen");
    nas.addCssRule("td","border-color:"+this.sheetborderColor,"screen");

var mySections=[
    ["th.tcSpan"        ,"width" ,(sheetLooks.TimeGuideWidth        + sheetLooks.CellWidthUnit)],
    ["th.dialogSpan"    ,"width" ,(sheetLooks.DialogWidth           + sheetLooks.CellWidthUnit)],
    ["th.soundSpan"     ,"width" ,(sheetLooks.SoundWidth            + sheetLooks.CellWidthUnit)],
    ["td.colSep"        ,"width" ,(sheetLooks.ColumnSeparatorWidth  + sheetLooks.CellWidthUnit)],
    ["th.referenceSpan" ,"width" ,(sheetLooks.ActionWidth           + sheetLooks.CellWidthUnit)],
    ["th.editSpan"      ,"width" ,(sheetLooks.SheetCellWidth        + sheetLooks.CellWidthUnit)],
    ["th.timingSpan"    ,"width" ,(sheetLooks.SheetCellWidth        + sheetLooks.CellWidthUnit)],
    ["th.stillSpan"     ,"width" ,(sheetLooks.StillCellWidth        + sheetLooks.CellWidthUnit)],
    ["th.geometrySpan"   ,"width" ,(sheetLooks.GeometryCellWidth     + sheetLooks.CellWidthUnit)],
    ["th.sfxSpan"       ,"width" ,(sheetLooks.SfxCellWidth          + sheetLooks.CellWidthUnit)],
    ["th.cameraSpan"    ,"width" ,(sheetLooks.CameraCellWidth       + sheetLooks.CellWidthUnit)]
]

/*    cssにルールセットを追加する関数
    nas.addCssRule( セレクタ, プロパティ, 適用範囲 )
        セレクタ    cssのセレクタを指定
        プロパティ    プロパティを置く
        適用範囲    "screen""print"または"both"
        
        注意してJqueryに置き換える
 */
//トラックの幅を設定
/*    リスト
class=timelabel annotationText
class=timeguide? 
class=dtSep
class=ntSep
class=colSep
class=layerlabelR annotationText
class=layerlabel annotationText
 */

for(var idx=0;idx<mySections.length;idx++){
    nas.addCssRule( mySections[idx][0],mySections[idx][1]+":"+mySections[idx][2],"both");
//    $(mySections[idx][0]).css(mySections[idx][1],mySections[idx][2])
};

//    シートブランクの色設定
var mySeps=[
    "ltSep","dtSep","ntSep","ntSep",
    "lsSep","dsSep","nsSep","nsSep",
    "lnSep","dnSep","nnSep","nnSep"
];

for(var idx=0;idx<mySeps.length;idx++){
    nas.addCssRule("."+mySeps[idx]+"_Blank","background-color:"+xUI.sheetblankColor)
};
//================================================================================================================================ シートカラーcss設定
//  タブUIに  背景色を設定
    $('.tabControll').css('background-color',this.sheetbaseColor);
    $('#tabSelector').css('background-color',this.sheetbaseColor);

//================================================================================================================================ シートカラーcss設定2
//    シート境界色設定
    $('table').css('border-color',xUI.sheetbaseColor);
    $('th').css('border-color',xUI.sheetborderColor);
    $('td').css('border-color',xUI.sheetborderColor);
    $("th.stilllabel").css("background-color",xUI.stillColor);// ,"screen");
    $("th.sfxlabel").css("background-color",xUI.sfxColor);//   ,"screen");
    $("th.cameralabel").css("background-color",xUI.cameraColor);//,"screen");

//================================================================================================================================ シートカラーcss設定2
//    if(this.footstampPaint) this.footstampPaint();
    return true;
}
//初期化の一環で一度実行？

// xUI.setSheetLook(SheetLooks);

/**
    setToolView
    ツール群の一括ループ切り替え
    クッキーと同じ形式またはキーワード full,minimum,default,compact,current
     引数がない場合以下をループ
    (ユーザ設定(current))＞全表示(full)＞最少表示(minimum)＞推奨表示(defeult)＞推奨コンパクト(compact)＞(ユーザ設定(current))
    各ツールの個別切り替えを行うとその時点の表示がユーザ設定と置き換わるので注意
    "pMenu"             ドロップダウンメニュー <2020改修で削除予定 非表示>
    "account_box"       ユーザアカウント切り替え
    "optionPanelLogin"  認証パネル
    "toolbarHeader"     ツールバー <2020改修で削除予定 非表示>
    "optionPanelUtl"　  コマンドバー <2020改修で削除予定 非表示>
    "pmcui"             作業メニュー <2020改修で削除予定 非表示>
    "headerTool"        ヘッダー入力コントロールバー
    "inputControl"     入力コントロール
    "sheetHeaderTable"  タイムシートヘッダ
    "optionPanelTbx"    ソフトウェアキーボード
    "optionPanelDbg"    デバッグコンソール
    "memoArea"          メモ表示域
*/
xUI.setToolView = function(toolView){
	var currentView = [];
	for (var ix=0;ix<UIViewIdList.length;ix++){
		currentView.push(($('#'+UIViewIdList[ix]).css('display')=='none')? 0:1);				
	};
	currentView=currentView.join("");
    if(typeof this.toolView =='undefined') this.toolView = currentView;
    switch (toolView) {
    case 'full'   :toolView = '010001111001';break;
    case 'minimum':toolView = '000000100000';break;
    case 'default':toolView = '010001110001';break;
    case 'compact':toolView = '010000110000';break;
    default:   
        if(String(toolView).match(/^[01]+$/)){
            this.toolView = toolView;
        }else{
            var viewSet = (xUI.restriction)?[
                '010001101001',
                '010000001000',
                '010001100001',
                '000000100000',
                this.toolView
                ]:[
                '010001111001',
                '010000011000',
                '010001110001',
                '000000110000',
                this.toolView
                ];
            toolView = viewSet[(viewSet.indexOf(currentView)+1)%viewSet.length];
        }
    }
    if(toolView != currentView){
//UI表示状態設定
    if(xUI.restriction){
         toolView = ("000000000000"+((parseInt(toolView,2) & parseInt("011001101111",2)).toString(2))).slice(-UIViewIdList.length);
      }
    for (var ix=0;ix<UIViewIdList.length;ix++){
        var myTgt=$("#"+UIViewIdList[ix]);
        if(String(toolView).charAt(ix)=="0"){myTgt.hide()}else{myTgt.show()} 
    }
    }
    xUI.adjustSpacer();
console.log([toolView,xUI.toolView]);
    return toolView;
}
/* TEST
xUI.setToolView()
*/
/**
    制限モードへ移行
    
*/
xUI.setRestriction = function(mode){
    if(typeof mode == 'undefined') mode=true;
    if(mode){
        xUI.restriction = true;
        xUI.viewMode    = "Compact";//?
        xUI.resetSheet();
        xUI.setToolView('minimum');
        xUI.flipRefColumns('hide');
    }else{
        xUI.restriction = false;
        xUI.viewMode    = "wordProp";//?
        xUI.resetSheet();
        xUI.setToolView('current');
        xUI.flipRefColumns('show');
    }
    return xUI.restriction;
}
/**
    xUI.manipulateDocument(command,callback)
    ドキュメント(xUI.documents)のステータスを操作する関数
    DocumentオブジェクトにアタッチされたxMap|Xpsのみを扱う
    
トランザクションはdocuments[0]を初期化の際残りの必要なサブトランザクションが初期化される

    代表xMapのみを操作対象とする　xpx/pmdb/stbd等は扱わない
    このメソッドが必要に従って「UIを提示して」コマンドを実行する
    トランザクション制御の一部として動作するので　引数としてトランザクションオブジェクトのみを受け付ける
    操作に失敗した場合トランザクション全体が破棄される
    
    @params {Object nas.Transaction}    transaction

    @params {String|Function}    command
    引数：操作後にコールバックされる関数または、コールバック処理キーワード
    
    activate/deactivate/checkin/checkout/destroy/abort/receipt/branch // push|pull //sink/float
    
    操作成功時は、モードにあわせてアプリケーションのモードを設定
    引数がカラの場合は、現在のステータスを返す
    非同期のサービスレスポンス待ちなのでコールバック渡し
    activate        from Fixed/Hold     to Active
        Hold中または一旦Fixedにしたドキュメントを再度Activeにする
    deactivate      from Active         to Hold
        ActiveなドキュメントをHoldに

    checkin         from Startup/Fixed  to Active
        チェックイン可能な状態のドキュメントにチェックインしてActiveに
        ｘUI.currentUserが有効であること
    checkout        from Active         to Fixed
        ActiveドキュメントをチェックアウトしてFixedに
        アサイン・メッセージを要求
        
    abort           from Fixed          to Aborted
        ドキュメントを中断（欠番処理）要マネジメントモード
    receipt         from Fixed          to Startup
        ドキュメントを受領してCompleatedに　新ステージを設定してStartupを設定
        同時にブランチも可能
    branch          (status no change)（xMapのみ）
        任意のステージ後端からブランチを作成　ブランチに新ステージを設定してStartupを設定

floatingの切り替えメソッドを独立させる
    flaot                                copy to Floating（xMapのみ）
      if(unactive)  from Startup/Fixed/Hold     No Change
      if(active)    from Active                 to Hold
        現行のドキュメントをフロート化
        ドキュメントがアクティブであった場合のみホールドに切り替えて
        xMap.dataNodeの内容を削除する
        保存、エクスポート等は行わない
    sink            from any            copy to any（xMapのみ）
        フローティング状態のドキュメントをすべてリポジトリに登録する
        すでに登録されている同名データの上書きは禁止する
        xMap|所属Xpsすべて|設定により　アセットすべてをアップロード　成功したら
        現pmdb|stbdを更新して　これをpush

    push            (status no change)
        xMap|所属Xpsすべて|設定によりアセットすべて をpush
    pull            (status no change)
        xMap|所属Xpsすべて|設定によりアセットすべて をpull

    @params {Function|String callbackMethod}    callback
        コールバック処理メソッド　または定形コールバックのためのキーワード
    @returns {Object nas.ManagementNode} カレントドキュメントステータスを戻すが基本的に戻り値は利用されない（消すか？）


＊＊このメソッドがUIを出してパラメータを揃える**
指定メソッドに沿ってコマンドを書きだすハブマニピュレーター
xUI.docuemntsに対する処理のみを扱う
単独データに関してはmanupulateDataで扱う
*/
xUI.manipulateDocument = function(transaction){
//console.log('break xUI.manipulateDocument !!!!!!');return false;
console.log('xUI.manipulateDocument !!!!!!'+transaction.command);
    if(!(transaction instanceof nas.Transaction)) return false;
    if ((transaction.target instanceof xUI.Document)&&(this.documents.length == 0)){
        transatction.fail();
        return false;
    }
    var targetData = (transaction.target instanceof xUI.Document)?transaction.target.content:transaction.target;
    var command = transaction.command;
    switch (command){
        case 'float':;//ｘMap|Xps only(has .pmu)
            if(targetData.pmu){
                if(targetData.dataNode){
// float  現在のドキュメントを複製して自由編集状態にする
alert('set float : '+targetData.getIdentifier());
                    targetData.dataNode = undefined;//クリア
                }else{
alert(targetData.getIdentifier() + 'is allready float')
                }
                transaction.callback = function(){
                    xUI.setUImode('browsing');
                }
                transaction.success();
            }
        break;
        case 'sink':;//ｘMap|Xps only(has .pmu)
//sink /現在のドキュメントをリポジトリにプッシュする 成功時はドキュメントのステータスを更新
/*sink floatingデータの登録は要注意
現在データが既存である場合は処理を行っていないが、既存データの書き戻しもこのメニューの範疇
既存データと構成が一致した場合はマージを行うように　要調整
*/
//処理パスをこのルーチンにしないで別に仕立てる
            if(targetData.pmu){
//ダイアログ出画前に不能判定を行う
                var contentConfrict = 0;
                var targetEpisode      ;
                var targetTitle     = nas.pmdb.workTitles.entry(targetData.pmu.title.name);
                if(targetTitle){
                    targetEpisode = targetTitle.opuses.entry(targetData.pmu.opus.name);
                    if(targetEpisode){
                        for (var ex = 0 ; ex < targetData.pmu.inherit.length;ex++){
                            if(targetEpisode.stbd.entry(targetData.pmu.inherit[ex].name)) contentConfrict ++;
                        }
                    }
                }
              if((targetTitle)&&(targetEpisode)&&(contentConfrict == 0)){
//タイトルありエピソードありショット重複なし
//モーダルパネル表示（操作ロック）ドキュメントの状態を提示してユーザの確認を促す
//メッセージ設定
                var msg = "SINK-TEST";var ui_description='<strong>SINK-UI</strong>'
                nas.showModalDialog('confirm',[msg,ui_description],"SINK",transaction,function(){
                    var transaction = this.startValue;
                    if(this.status == 0){
                        var targetData = (transaction.target instanceof xUI.Document)?transaction.target.content:transaction.target;
                        var command = transaction.command;
                        if(!(targetData.dataNode)){
                            targetData.dataNode = serviceAgent.currentRepository.toString();//設定する
                        }
                        transaction.callback = function(){
                            xUI.setUImode('browsing');
                        };
                        serviceAgent.currentRepository.pushContent(transaction);
                    }else{
                        transaction.fail();
                    }
                },true);
              }else{
/*
    ショットが完全に重複していたら放流データの帰還なのでマージを行う
    他に　タイトル新規作成・エピソード新規作成も考えられるが　ここでは扱わない
    ショット内容が不完全に一致しているケースも考えられるので注意
*/
                  var msg = 'このショットは登録できません。'
                  alert(msg);
                  transaction.fail();
              }
            }
        break;
        case 'activate':;//ｘMap|Xps only(has .pmu)
            if(targetData.pmu){
        //activate / 停止中の作業を再開する
                if(
                    (targetData.pmu.currentNode.jobStatus.content.match(/^Fixed|^Hold/i))&&
                    (xUI.currentUser.sameAs(targetData.pmu.currentNode.updateUser))
                ){
                    var activation = targetData.pmu.activate(xUI.currentUser);
                    if(activation) {
                        transaction.callback = function(){
                            xUI.setUImode('production');
                        };
                        serviceAgent.pushContent(transaction);
                    }else{
console.log("activation failed");console.log(this.XMAP);
                        transaction.fail();
                    }
                }else{
console.log('cannot activate:');
                        transaction.fail();
                }
            }
        break;
        case 'deactivate':;//ｘMap|Xps only(has .pmu)
console.log('de-activation !')
            if(targetData.pmu){
            //deactivate / 保留
                var deactivation = targetData.pmu.deactivate();
                if(deactivation){
console.log(deactivation);
                    transaction.callback = function(){
                        //成功時はドキュメントのステータスを更新してアプリモードをbrowsingへ変更
                        xUI.setUImode('browsing');
                    };
                    serviceAgent.pushContent(transaction);
                }else{
                    transaction.fail();
                }
            }
        break;
        case 'checkin':;//ｘMap|Xps only(has .pmu)
console.log('transaction checkin data manipulate');
            if(targetData.pmu){
              if((targetData.xMap)&&(targetData.xMap.pmu.checkinNode)){

/*  Xps(カット)に対するチェックイン操作は自動で行なわれる
    基本的にxMapへのチェックインが成功した場合Xpに対するユーザのチェックイン操作は不要とする
    メモリ上のデータへのチェックインはその場で行なわれる（この操作は通常は成功するはずだが、失敗の場合はエラー処理に入る）
    sessionRetraceが０にセットされる　
    常に入力可能 ただし、サーバへの保存は遅延解決 
    自動保存のタイミングで((undoPt == 0)&&(storePt == undoPt)である限り、実際のpushは行なわれないように調整する
*/
//checkin引数 (checkinTarget,nodeDescription,activeUser)
console.log(targetData.xMap === xUI.XMAP)
console.log([
                        targetData.xMap.pmu.currentNode.getPath(),
                        xUI.currentUser.toString()
]);

                    var checkin = targetData.pmu.checkin(
                        targetData.xMap.pmu.currentNode,
                        targetData.xMap.pmu.checkinNode.name,
                        xUI.currentUser
                    );
                    if(checkin){;   //console.log('checkin success. ');
                        transaction.callback = function(){
                            sync('productStatus');
                        };
                        if(targetData.documentRepository){;// console.log('put content to repository');
                            serviceAgent.pushContent(transaction);
                        }else{
                            transaction.success();
                        }
                    }else{
console.log('manipulate checkin fail');
console.log(checkin);
                        transaction.fail();
                    }
              }else{
//check-in / 開く    モーダルパネル表示（操作ロック）ドキュメントの状態を提示してユーザの確認を促す
                var msg = localize('checkin-test');
                var ui_description = "<div>UI-content UID:"+ xUI.currentUser.toString() +": newJobName </div>";
                nas.showModalDialog(
                    'confirm',
                    [msg,ui_description],
                    'check-in',
                    transaction,
                    function(result){
                    var transaction = this.startValue;
                        if(this.status == 0){
                            var targetData = (transaction.target instanceof xUI.Document)?transaction.target.content:transaction.target;
                            var command = transaction.command;
                            var nodeDescription = 'newJobName';//new job name
                            var checkin = targetData.pmu.checkin(
                                targetData.pmu.currentNode,
                                nodeDescription,
                                xUI.currentUser
                            );
                            if(checkin){
                                transaction.callback = function(){
                                    if (xUI.uiMode != 'production'){
                                        xUI.viewOnly = false;
                                        xUI.setUImode('production');
                                    }else{
                                        sync('productStatus');
                                    }
                                };
                                if(targetData.documentRepository){
                                    serviceAgent.pushContent(transaction);
                                }else{
                                    transaction.success();
                                }
                            }else{
                                transaction.fail();
                            }
                        }else{
                            transaction.fail();
                        }
                    },
                    true
                );
              }
            }
        break;
        case 'checkout':;//ｘMap|Xps only(has .pmu)
            if(targetData.pmu){
//check-out / 閉じる
              if(
                (transaction.target instanceof xUI.Document )&&
                (targetData.xMap)&&
                (! targetData.xMap.pmu.checkinNode)&&
                (nas.Pm.compareManagementNode(targetData.xMap.pmu.currentNode,targetData.pmu.checkinNode) == 0)
              ){
//checkin引数 (assignUser,message)なし　ダイアログなしのチェックアウト
//xUI.Document が直接の引数で、かつトレーラーのxMapがチェックアウト済みであること　それ以外はダイアログあり
                    var checkout = targetData.pmu.checkout();
                    if(checkout){
                        transaction.callback = function(){
                                sync('productStatus');
                        };
                        serviceAgent.pushContent(transaction);
                    }else{
                        transaction.fail();
                    }
              }else{
//モーダルパネル表示（操作ロック）ドキュメントの状態を提示してユーザの確認を促す
//メッセージ設定
                var msg = 'checkout-test';var ui_description = "UI-TEST-CHECKOUT";
                nas.showModalDialog('confirm',[msg,ui_description],'checkout',null,function(result){
                  if(this.status == 0){
                    var assignUser = "ASSIGN-USER";
                    var message    = "MESSAGE";
//checkin引数 (assignUser,message)
                    var checkout = targetData.pmu.checkout(
                        assignUser,
                        message
                    );
                    if(checkout){
                        transaction.callback = function(){
                            if(!(xUI.XMAP.pmu.checkinNode)){
console.log('setBROWSING');
                                xUI.setUImode('browsing');
                            }else{
console.log('refreshSTATUS');
                                sync('productStatus');
                            }
                        };
                        serviceAgent.pushContent(transaction);
                    }else{
console.log('checkout failed');
                        transaction.fail();
                    }
console.log(result);
                  }else{
console.log('cancel');
                         transaction.fail();
                  }
                });
              }
            }
        break;
        case 'destroy'://ｘMap|Xps only(has .pmu)
            if(targetData.pmu){
                if(targetData.pmu.destroy()){
//ターゲットがXpsの場合のみデータロールバックをトライ
                    if(targetData instanceof Xps){
                        
                    }
console.log(transaction);
                    transaction.success();
                }else{
                    transaction.fail();
                }
            }
        break;
        case 'abort':
           if((xUI.uiMode=='management')&&(targetData.pmu)){
               
           }
        break;
        case 'receipt':;//ｘMap|Xps only(has .pmu)
            if((xUI.uiMode=='management')&&(targetData.pmu)){
//receipt / 検収
//モーダルパネル表示（操作ロック）ドキュメントの状態を提示してユーザの確認を促す
//メッセージ設定
                var msg = 'receipt-test';
                nas.showModalDialog('confirm',msg,'receipt',null,function(result){
                        console.log(result);
                });
                var targetNode = "newNode";
                var stageName  = "newStage";
                var jobName    = "newJob";
//receipt引数 (user,targetNode,stageName,jobName,slipNumber)
                var receipt = targetData.pmu.receipt(
                    xUI.currentUser,
                    targetNode,
                    stageName,
                    jobName,
                    slipNumber
                );
                if(receipt){
                    transaction.callback = function(){
                        xUI.setUImode('management');
                    };
                    serviceAgent.pushContent(transaction);
                }else{
                    transaction.fail();
                }
            }else{
                    transaction.fail();
            }
        break;
        case 'salvage':
           if((xUI.uiMode=='management')&&(targetData.pmu)){
               
           }
        break;
        case 'pull':;
            transaction.callback = function(transaction){xUI.resetScreen();};
            serviceAgent.pullContent(transaction);
            return true;
        break;
        case 'push':;
            transaction.callback = function(transaction){
console.log(transaction);
                if(transaction.target instanceof xUI.Document)
                    serviceAgent.currentRepository.updatePMDB();
                if(xUI.activeDocument)
                    xUI.resetScreen();
            };
            serviceAgent.pushContent(transaction);
            return true;
        break;
    }    
}
/*TEST
    console.log(xUI.manipulateDocument(transaction));
*/
/**
 *    uiMode変更  引数がなければ変更なし
 *    引数がモードキーワード以外ならば、モードを順次切り替えて
 *    現在のモード値を返す
 *  floatingモード消失 2020.01
 *    @params  {String}    newMode
 *    current     モード変更なし
 *    production  作業モード
 *    management  管理モード
 *    browsing    閲覧モード
 *　モード変更に伴うUIの書き換えを別メソッドに分離 20200118
 *      xUI.uiModeプロパティははxUI.XMAPの状態をベースに管理を行う
 *      各ドキュメントごとのチェックイン状態は別の管理となるので要注意
 */
xUI.setUImode = function (myMode){
    if(typeof myMode == 'undefined') myMode = 'current';
//アプリケーションのuiModeは、xUI.XMAP のステータスに基づくものとする
    switch (myMode){
        case 'current':;//NOP return
            return xUI.uiMode;
        break;
        case 'production':
            if(xUI.XMAP.pmu.currentNode.jobStatus.content != 'Active'){return xUI.uiMode;}
        break;
        case 'management':
// マネジメントモードに入るには条件あり
// スタッフリストで制作管理者であるか、またはリポジトリオーナーユーザであること
            if(false){return xUI.uiMode;}
        break;
        case 'browsing':
        break;
        default:;
            var nextMode = ['production','browsing','management'].indexOf(xUI.uiMode);
            switch(xUI.uiMode){
            case "management":
                nextMode = 'production';
            break;
            case "browsing":
                nextMode = 'management';
            break;
            case "production":
                nextMode = 'browsing';
            break;
            }
                return xUI.uiMode;
                //return this.setUImode(nextMode);
    }
    xUI.uiMode=myMode;
    xUI.setRetrace();
    sync('productStatus');
    return xUI.uiMode;
}
/**
 *    xUI.uiMode モード別メニュー更新
 *    標準では sync('productStatus')から呼び出される 単独実行可能
 *    引数なし
 *    戻値なし
 */
xUI.uiModeMenuUpdate = function(){
    var documentsCheckin = (xUI.XMAP.pmu.checkinNode)? true:false;
    var activeDocumentCheckin = false; var sessionRetrace = -1;
/*動作仕様変更で
    常時xUI.activeDocumentが存在する
    documentsCheckin一つで、タイムシートドキュメントにもチェックイン状態になった
    以上の点を踏まえて状態コントロールをリライト
 */
    if(xUI.activeDocument){
        activeDocumentCheckin = (xUI.activeDocument.content.pmu.checkinNode)? true:false;
        sessionRetrace = (xUI.activeDocument.content.pmu.currentNode)?
            xUI.activeDocument.content.pmu.currentNode.getDistance():-1;
        if((xUI.activeDocument.sessionRetrace)&&(xUI.activeDocument.sessionRetrace > 0)) sessionRetrace = xUI.activeDocument.sessionRetrace;//上書きする
        if (xUI.activeDocument.content.dataNode){
//リポジトリ所属データ
            $('#pmfui').hide();
            $("li.fuiMenu").each(function(){$(this).hide()});
            //css切り替えはここに
        }else{
//フローティングデータ
            $('#pmfui').show();
            $("li.fuiMenu").each(function(){$(this).show()});
            //css切り替えはここに
        }
    }
//チェックインボタンの表示切り替え
//    if(activeDocumentCheckin){
//        $('#pmcui-checkin').hide();
//      }else{
//        $('#pmcui-checkin').show();
//    }
    var setting = xUI.uiMode;
    if((xUI.uiMode != 'management')&&(xUI.activeDocumentId)){
    	setting = (activeDocumentCheckin)? 'production':'browsing';
    }
    if(! xUI.XMAP.dataNode){
//フロートエントリ
//インジケータカラー変更
//            $('#pmcui').css('background-color','#dddddd');
            $('.jobControl').css('border-color','#ff8888');
}else{
//リポジトリ所属エントリ サーバ種別ごとの色変えがあったほうが良い
/*  サーバまたはリポジトリごとのカラー設定を考慮　イメージカラー　またはテーマカラーとして設定してもらう
*/
            $('.jobControl').css('border-color','#ff22ff');
    switch (xUI.uiMode){
    case 'production':
            //インジケータカラー変更
//            $('#pmcui').css('background-color','#bbbbdd');
            $('#pmcui').css('color','#666688');
            break;
    case 'management':
            //インジケータカラー変更
//            $('#pmcui').css('background-color','#ddbbbb');
            $('#pmcui').css('color','#886666');
            break;
    case 'browsing':;
    default:
            //インジケータカラー変更
//            $('#pmcui').css('background-color','#bbddbb');
            $('#pmcui').css('color','#668866');
    }
}
//状況を判定してスイッチの表示|非表示 有効|無効を切り替え
    switch (setting){
        case 'production':;
    $('#ddp-man').hide();
    $('#pmaui').hide();
    if(activeDocumentCheckin){
        $('#pmbui').hide();
        $('#pmeui').show();
    }else{
        $('#pmbui').show();
        $('#pmeui').hide();
    }
    $('span.subControl_TC').each(function(){$(this).hide()})
    $("li.auiMenu").each(function(){$(this).hide()});
    $("li.cuiMenu").each(function(){$(this).show()});

    document.getElementById('cutList').multiple = false;

//mode production (= トレーラードキュメントがActive)
            document.getElementById('pmcui-checkin').disabled    = true ;//すでにproductionなので常にdisabled(消すか？)
            document.getElementById('pmcui-update').disabled     = true ;//初期値 diabled　状況で変わる
//フォーカスドキュメントのステータスで分岐
        if(xUI.activeDocument.content.pmu.currentNode.jobStatus.content == 'Active'){
            document.getElementById('pmcui-checkout').disabled   = false;//カレントがアクティブならばenable
        }else{
            document.getElementById('pmcui-checkout').disabled   = true;//チェックアウト不能(チェックインしていない)
        }
        if((xUI.XMAP.pmu.checkinNode)&&(xUI.XMAP.pmu.checkinNode.getPath('id') == xUI.activeDocument.content.pmu.currentNode.getPath('id'))){
            document.getElementById('pmcui-activate').disabled   = false;//チェックイン可能
        }else{
            document.getElementById('pmcui-activate').disabled   = true;//チェックイン不可
        }
        break;
        case 'management':;
    $('#ddp-man').show();
    $('#pmaui').show();
    $('#pmbui').hide();
    $('#pmeui').hide();
    $('span.subControl_TC').each(function(){$(this).show()})
    $("li.auiMenu").each(function(){$(this).show()});
    $("li.cuiMenu").each(function(){$(this).hide()});
    document.getElementById('cutList').multiple = true;
            document.getElementById('pmcui-checkin').disabled    =true;//すべてのボタンを無効
            document.getElementById('pmcui-update').disabled     =true;
            document.getElementById('pmcui-checkout').disabled   =true;
            document.getElementById('pmcui-activate').disabled   =true;
            break;
        case 'browsing':;
    $('#ddp-man').hide();
    $('#pmaui').hide();
    $('#pmbui').show();
    $('#pmeui').hide();
    $('span.subControl_TC').each(function(){$(this).hide()})
    $("li.auiMenu").each(function(){$(this).hide()});
    $("li.cuiMenu").each(function(){$(this).hide()});
    document.getElementById('cutList').multiple = false;
//チェックイン可能条件
/*
    共通  現在未チェックイン
    xMap    ドキュメントステータスがStartup|Fixed

    Xpst    xMapがチェックイン済み
*/
            document.getElementById('pmcui-checkin').disabled    = (
                ((xUI.activeDocumentId==0)&&(! documentsCheckin)&&(
                    (xUI.activeDocument.content.pmu.currentNode.jobStatus.content =='Startup')||(xUI.activeDocument.content.pmu.currentNode.jobStatus.content =='Fixed')
                ))||((xUI.activeDocumentId)&&(documentsCheckin)&&(!activeDocumentCheckin))
            )? false:true;
            document.getElementById('pmcui-update').disabled     =true;
            document.getElementById('pmcui-checkout').disabled   = true;
console.log(xUI.currentUser.sameAs(xUI.XMAP.pmu.currentNode.updateUser))
//アクティベート(作業再開判定)
                if (xUI.currentUser.sameAs(xUI.XMAP.pmu.currentNode.updateUser)) {
//ドキュメントオーナー(最終更新ユーザ)
console.log(sessionRetrace+':'+xUI.activeDocument.content.pmu.currentNode.jobStatus.content);
                    document.getElementById('pmcui-activate').disabled   =(
                        (sessionRetrace == 0)&&(
                            (xUI.activeDocument.content.pmu.currentNode.jobStatus.content =='Hold')||(xUI.activeDocument.content.pmu.currentNode.jobStatus.content =='Fixed')||(xUI.activeDocument.content.pmu.currentNode.jobStatus.content =='Active')
                        )
                )? false:true;
            }else{
//オーナー外
                document.getElementById('pmcui-activate').disabled   = true;

//                document.getElementById('pmcui-activate').disabled   = (xUI.XMAP.pmu.currentNode.jobStatus.content =='Fixed')?false:true;
            }
            break;
    }
//ノードステータス表示を更新
    xUI.updateStatus();
//プルダウンメニューの表示をステータスに合わせる
            this.pMenu('pMcheckin'      ,(document.getElementById('pmcui-checkin').disabled)? 'disable':'enable');
            this.pMenu('pMsave'         ,(document.getElementById('pmcui-update').disabled)?  'disable':'enable');
            this.pMenu('pMcheckout'     ,(document.getElementById('pmcui-checkout').disabled)?'disable':'enable');
            this.pMenu('pMactivate'     ,(document.getElementById('pmcui-activate').disabled)?'disable':'enable');
            this.pMenu('pMdiscard'      ,(xUI.XMAP.pmu.currentNode.jobStatus.content =='Active')?'enable':'disable');
            this.pMenu('pMreceipt'      ,(document.getElementById('pmaui-receipt').disabled)?  'disable':'enable');
            this.pMenu('pMcheckoutF'    ,(document.getElementById('pmaui-checkout').disabled)? 'disable':'enable');
            this.pMenu('pMabort'        ,(document.getElementById('pmaui-abort').disabled)?    'disable':'enable');
            this.pMenu('pMbranch'       ,(document.getElementById('pmaui-branch').disabled)?   'disable':'enable');
            this.pMenu('pMmerge'        ,(document.getElementById('pmaui-merge').disabled)?    'disable':'enable');
}
/*    xUI.edChg(status boolean)
    セル編集フラグ 切り替えと同時に表示を調整
*/
xUI.edChg=function(status,opt){
    if(this.viewOnly) return xUI.headerFlash('#bb8080');
    this.edchg=status;
    document.getElementById("edchg").style.backgroundColor=
    (this.edchg)?
    this.editingColor:"";//表示
};
//
/*xUI.mdChg(myModes,opt)
引数:
    myModes    モードを数値または文字列で指定  数値で格納
    opt    オプション引数
    編集モードを変更してカラーをアップデートする
    リフレッシュつき
*/
xUI.mdChg=function(myModes,opt){
            //編集操作モード  0:通常入力  1:ブロック移動  2:区間編集  3:領域フロート状態
    if(typeof myModes == "undefined") myModes="normal";
//モード遷移にあわせてUIカラーの変更
    switch(myModes){
    case "float":
    case "section-float":
    case 3:
//セクション編集時のフローティングモード
// emode==2以外ではこの状態に入れない
    if((this.edmode==2)&&(! this.viewOnly)){
       this.edmode=3;
        this.floatSourceAddress     = this.Select.slice();    //移動ソースアドレスを退避
        this.selectedColor          = this.inputModeColor.FLOAT;    //選択セルの背景色
//        this.spinAreaColor          = this.inputModeColor.FLOATspin;    //非選択スピン背景色
//        this.spinAreaColorSelect    = this.inputModeColor.FLOATspinselected;    //選択スピン背景色
        this.spinAreaColor          = this.inputModeColor.FLOATselection;    //非選択スピン背景色
        this.spinAreaColorSelect    = this.inputModeColor.FLOATselection;    //選択スピン背景色
        this.selectionColor         = this.inputModeColor.FLOATselection;    //選択領域の背景色
        this.selectionColorTail     = this.inputModeColor.FLOAT;    //
    };
    break;
    case "section":
    case 2:
/*
 *  モード'normal'かつトラックのダブルクリックでセクション編集モードに入る  抜けるには明示的にmdChg('normal')をコールする必要がある
 *  現行でタイムライン種別トラップあり  ダイアログトラックのみ遷移可能
  さらにダイアログトラックでは値のない区間は選択を抑制中
*/
//sectionManipulateOffsetは、ここでは初期化されない
//if((this.XPS.xpsTracks[this.Select[0]].option.match(/dialog|effect|camera/))){}
//if((this.XPS.xpsTracks[this.Select[0]].option=='dialog')){}
if(true){
  if(this.edmode<2){
//      if(this.spin() > 1){this.spinBackup=this.spin();this.spin(1);};//スピン量をバックアップしてクリア ? これ実はいらない？
      this.selectBackup         = this.Select.concat()      ;       //カーソル位置バックアップ
      this.selectionBackup      = this.Selection.concat()   ;       //選択範囲バックアップ
      this.floatSourceAddress   = this.Select.concat()      ;       //移動元ソースアドレスを退避
      this.floatTrack           = this.XPS.xpsTracks[this.Select[0]];//編集破棄の際に復帰するためモード変更時のトラック全体を記録
      this.floatTrackBackup     = this.floatTrack.duplicate()       ;//編集確定時のためトラック全体をバッファにとる

      this.floatSection         = this.floatTrackBackup.getSectionByFrame(this.Select[1]);

      if((this.floatTrack.option =='dialog')&&(! this.floatSection.value)){
    //操作対象セクションを選択状態にする
      this.selectCell([
	    this.Select[0],
	    this.floatSection.startOffset()
      ]);
      this.selection([
	    this.Select[0],
	    this.floatSection.startOffset()+this.floatSection.duration-1
      ]);

        this.floatTrack         = null;
        this.floatTrackBackup   = null;
        this.floatSection       = null;
        return false;
      }
      this.floatSectionId   = this.floatSection.id();
      this.floatUpdateCount = 0;//フロート編集中の更新カウントをリセット

    //操作対象セクションを選択状態にする
      this.selectCell([
	    this.Select[0],
	    this.floatSection.startOffset()
      ]);
      this.selection([
	    this.Select[0],
	    this.floatSection.startOffset()+this.floatSection.duration-1
      ]);
  }
      this.edmode=2;
     
      //未確定編集はxUI.put でなくxUI.XPS.putで更新する。
      //範囲確定はここで行う？
        this.selectedColor          = this.inputModeColor.SECTION           ;    //選択セルの背景色
        this.spinAreaColor          = this.inputModeColor.SECTIONselection  ;    //非選択スピン背景色
        this.spinAreaColorSelect    = this.inputModeColor.SECTIONselection  ;    //選択スピン背景色
        this.selectionColor         = this.inputModeColor.SECTIONselection  ;    //選択領域の背景色
        this.selectionColorTail     = this.inputModeColor.SECTIONtail       ;    //選択領域の末尾
        this.Mouse.action=false;
};//セクション編集モード遷移
    break;
    case "block":    //ブロックフロートモードに遷移
    case 1:        //前モードがノーマルだった場合のみ遷移可能
    if(this.edmode==0){
      this.edmode=1;
//      if(this.spin()){this.spinBackup=this.spin();this.spin(1);};//スピン量をバックアップしてクリア
        this.floatSourceAddress  = this.Select.concat();    //移動ソースアドレスを退避
        this.selectedColor       = this.inputModeColor.FLOAT;    //選択セルの背景色
        this.spinAreaColor       = this.inputModeColor.FLOATspin;    //非選択スピン背景色
        this.spinAreaColorSelect = this.inputModeColor.FLOATspinselected;    //選択スピン背景色
        this.selectionColor      = this.inputModeColor.FLOATselection;    //選択領域の背景色
        this.selectionColorTail  = this.inputModeColor.FLOATselection;    //選択領域の背景色
    }
    break;
    case "normal":    //ノーマルモードに復帰
    case 0:        //前モードに従って終了処理をここで行う
    default :    //
    if(this.edmode>=2){
        //区間編集モード確定または編集破棄処理
/*
//console.log(this.floatSourceAddress);
//console.log(this.floatDestAddress);
//console.log(this.floatSectionId);
//console.log(this.floatSection);
*/
    this.sectionManipulateOffset = ['tail',0];//区間編集ハンドルオフセット
        if(true){
        this.floatTrack         = null;
        this.floatTrackBackup   = null;
        this.floatSection       = null;
        this.floatSectionId     = null;
        this.floatUpdateCount   = 0;
        //  編集破棄はカウントした変更回数分のundoで行う
        }
        this.edmode=0;
        this.selectedColor    =this.inputModeColor.NORMAL;        //選択セルの背景色
        this.spinAreaColor    =this.inputModeColor.NORMALspin;    //非選択スピン背景色
        this.spinAreaColorSelect=this.inputModeColor.NORMALspinselected;//選択スピン背景色
        this.selectionColor    =this.sheetLooks.SelectionColor;            //選択領域の背景色
        this.selectionColorTail    =this.sheetLooks.SelectionColor;            //選択領域の背景色
    }else if(this.edmode==1){
        this.edmode=0;
        this.selectedColor    =this.inputModeColor.NORMAL;        //選択セルの背景色
        this.spinAreaColor    =this.inputModeColor.NORMALspin;    //非選択スピン背景色
        this.spinAreaColorSelect=this.inputModeColor.NORMALspinselected;//選択スピン背景色
        this.selectionColor    =this.sheetLooks.SelectionColor;            //選択領域の背景色
        this.selectionColorTail    =this.sheetLooks.SelectionColor;            //選択領域の背景色
        this.selectCell(this.floatSourceAddress);//ソース位置復帰
        this.move(sub(this.floatDestAddress,this.floatSourceAddress),opt);//ムーブコマンド発行
    }
    }
    //var bkRange=this.Selection.slice();
    this.selection(add(this.Select,this.Selection));
    
//    if(xUI.XPS.xpsTracks[xUI.Select[0]].option.match( /dialog|sound/ ))    SoundEdit.init();
    switch(xUI.XPS.xpsTracks[xUI.Select[0]].option){
    case 'dialog':
        SoundEdit.init();
    break;
    case 'sound' :
    default:
        //NOP
    }
    return this.edmode;
}
/**
    移動先セルを指定して区間選択範囲を更新する
    セクションの内容を自動編集してUndoバッファを更新せずに画面を書き換える処理はここで行う
    ここでの選択範囲はすべて編集中の仮範囲
    確定後にバックアップの選択範囲と置き換えまたは編集破棄の際はバックアップに復帰
    自動編集は常にバックアップ内容をベースに行う
引数:
    destination 移動先フレーム
参照プロパティ:    
    xUI.sectionManipulateOffset は[編集サブモード,選択中のセル（ヘッド）に対するオフセット]  ターゲットから計算する
    
 */
xUI.sectionPreview=function(destination){
    if((xUI.edmode<2)||(xUI.viewOnly)) return xUI.headerFlash('#ff8080');
//    if((xUI.edmode<2)||(xUI.viewOnly)) return false;
    if(typeof destination == 'undefined')   destination = this.Select[1];
    var hotpoint    = xUI.Select[1]+xUI.sectionManipulateOffset[1];
 //   this.sectionManipulateOffset[1]=hotpoint-this.Select[1];//オフセットがでる
//    if(        Math.abs(xUI.sectionManipulateOffset[1]-((xUI.Selection[1]+xUI.Select[1])/2)) >        Math.abs(xUI.Selection[1]/2)    ) return 'overRange';//有効範囲外指定
    switch(xUI.sectionManipulateOffset[0]){
    case    0   :
    case 'head' :
//先頭指定  末尾固定で伸縮
        var tail=xUI.getid('Selection');
        xUI.selectCell([xUI.Select[0],destination-xUI.sectionManipulateOffset[1]]);
        xUI.selection(tail);
        break;
    case    1   :
    case 'body' :
//移動 
        xUI.selectCell([xUI.Select[0],destination-xUI.sectionManipulateOffset[1]]);
        break;
    case    2   :
    case 'tail' :
    default     :
//末尾指定  先頭固定で伸縮 sectionManipulateOffsetを更新
        var duration=xUI.Selection[1]+(destination-hotpoint);
        xUI.selection(add(xUI.Select,[0,duration]));
        xUI.sectionManipulateOffset[1]=xUI.Selection[1];
    }
    return true;
}

//test
//xUI.mdChg(2);
//xUI.sectionPreview(3,4);
// 
/*
引数：  action
    タイムシートセクション操作の結果を実際の画面に反映させるメソッド
    Xps.xpsTracks.menber.manipulateSection()に対応するxUI側の処理
    データ配置の際にトラック全体を書き直すので、カーソル位置を復帰させるためにundoStackに第４要素を積む
    xUI.putメソッドを経由せずにこのルーチン内で完結させる.
*/
xUI.sectionUpdate=function(){
     if(this.viewOnly) return xUI.headerFlash('#ff8080');
    var trackContents = xUI.floatTrack.sections.manipulateSection(xUI.floatSectionId,xUI.Select[1],xUI.Selection[1]);
//undo   保留の場合は以下のルーチンを使用
/* undo保留ではなくユーザが各工程を辿れるように１操作毎に書換を行い、一括undoのために操作回数を記録する。*/
//    xUI.XPS.put([xUI.Select[0],0],trackContents[0]);
//    xUI.syncSheetCell([xUI.Select[0],0],[xUI.Select[0],xUI.XPS.xpsTracks[0].duration]);

    var currentFrame     = xUI.Select[1];
    var currentSelection = xUI.Selection[1];
    xUI.scrollStop = true;
      xUI.selectCell([xUI.Select[0],0]);
        xUI.selection();
          xUI.sheetPut(trackContents[0]);
//対象トラックのセクションが（ダイアログ等）すべての要素を内包しない場合セレクション位置を更新する必要がある
//セクションの先頭を取得するためにパースするか
        xUI.floatUpdateCount ++;//increment
    xUI.floatSectionId = xUI.XPS.xpsTracks[xUI.Select[0]].getSectionByFrame(trackContents[1]).id();
         xUI.selectCell([xUI.Select[0],trackContents[1]]);
//      xUI.selection([xUI.Select[0],xUI.Select[1]+Math.abs(currentSelection)]);
//        this.selection([
//	        this.Select[0],
//	        trackContents[1]+this.floatSection.duration-1
//        ]);
      xUI.selection([xUI.Select[0],trackContents[1]+trackContents[2]]);
    xUI.scrollStop = false;

    if(xUI.XPS.xpsTracks[xUI.Select[0]].option=="dialog" ) SoundEdit.getProp();
    xUI.mdChg(0);xUI.mdChg(2);
}
/*    xUI.floatTextHi()
引数:なし  モード変数を確認して動作
モードチェンジの際に編集（保留）中のテキストを薄く表示する/もどす
*/
xUI.floatTextHi=function(){
    if(this.edmode>1) return false;
    var paintColor=(this.edmode==0)?"black":this.floatTextColor;
var range=[this.floatSourceAddress,add(this.floatSourceAddress,this.Selection)];
//    dbgPut("selectionHi :\n"+range.join("\n"));
//指定範囲をハイライト
    for (var C=range[0][0];C<=range[1][0];C++){
        for (var L=range[0][1];L<=range[1][1];L++){
            if((C<0) || (L<0)||(C>=this.XPS.xpsTracks.length)||(L>=this.XPS.xpsTracks[C].length)){
//    当座のバグ回避とデバッグ C.Lが操作範囲外だったときの処置 値を表示
//                dbgPut(range.toString());
            }else{
  if(document.getElementById(C+"_"+L).style.color!=paintColor) document.getElementById(C+"_"+L).style.color=paintColor;
//文字色変更
            };
        };
    };
}
/*
    現在のファイルからファイル名を作成
    引数でマクロを受け付ける
    引数が空の場合は標準識別子で返す $TITLE$#$OPUS$[$SUBTITLE$]__s$SCENE$-c$CUT$($TC$)
    このメソッドは役割を終えているので削除予定
    保存ファイル名は getIdentifier出取得
    
*/
xUI.getFileName=function(myFileName){
return (nas.Pm.getIdentifier(xUI.XMAP,'full')).replace(/\//g,"_");

//    myResult=(typeof myFileName=="undefined")?"$TITLE$OPUSs$SCENEc$CUT($TC)":myFileName;
//    myResult=(typeof myFileName=="undefined")?"$TITLE$#$OPUS$[$SUBTITLE$]__s$SCENE$-c$CUT$($TC$)":myFileName;
    var myResult=(typeof myFileName=="undefined")?"$TITLE$#$OPUS$__s$SCENE$-c$CUT$":myFileName;
    myResult=myResult.replace(/\$TITLE\$/g,this.XPS.title);
    myResult=myResult.replace(/\$SUBTITLE\$/g,this.XPS.subtitle);
    myResult=myResult.replace(/\$OPUS\$/g,this.XPS.opus);
    myResult=myResult.replace(/\$SCENE\$/g,this.XPS.scene);
    myResult=myResult.replace(/\$CUT\$/g,this.XPS.cut);
    myResult=myResult.replace(/\$TIME\$/g,this.XPS.time());
    myResult=myResult.replace(/\$TC\$/g,this.XPS.getTC(this.XPS.time()));
    myResult=myResult.replace(/[\s\.]/g,"");
    myResult=myResult.replace(/:;\/\\|\,\*\?"＜＞/g,"_");//"
    
    return myResult;
}
/*    シートボディフラッシュ
        xUI.flush(content)
        現在のシートの入力領域をすべてcontentで埋める
        戻り値は常にtrue
        これは試験用関数：実用性は無い  確かもう使ってない  20161106
*/
//
xUI.flush=function(content){
    if(! content){content=""};
//強制的にnullデータで全レイヤ・全フレームを書き換え
    var myDuration = this.XPS.duration();
//    タイムラインループ
    for (var T=0;T< this.XPS.xpsTracks.length;T++){
        this.XPS.xpsTracks[T].sectionTrust=false;
        this.XPS.xpsTracks[T].length= 0;
        this.XPS.xpsTracks[T].length= myDuration;
//        フレームループ
        for(var F=0;F < myDuration;F++){this.XPS.xpsTracks[T][F]=content;};
    };
    this.syncSheetCell();
    return true;
};
/** xUI.UndoBuffer オブジェクト
 * @constractor
 *
 */
xUI.UndoBuffer=function(){
    this.undoStack= []       ;//アンドウスタック配列
    this.undoPt  = 0         ;//アンドウポインタ初期化
    this.skipCt  = 0         ;//再描画抑制カウンタ初期化
    this.storePt = 0         ;//保存ポインタ初期化
}

xUI.UndoBuffer.prototype.flush = function(type){
    this.undoStack= [] ;//アンドウスタッククリア
    if(type=='xpst'){
        this.undoStack.push([new xUI.InputUnit([0,1],'')]);
    }else{
        this.undoStack.push([new xUI.InputUnit('','')]);
    }
    this.undoPt  =0 ;      //アンドウポインタ初期化
    this.skipCt  =0 ;      //再描画抑制カウンタ初期化
    this.storePt =0 ;      //保存ポインタ初期化
};

/*
新モデル
    undoバッファ初期化
        undoバッファをクリアして初期化

            undoStackのデータ構造 undoUnitCollectionArray
    [
        inputUnit:{
            target    :{Object} <xUI.Document 参照 追加プロパティ>,
            address   :{String|Array} <操作対象キーワード|アドレス(セレクト座標+セレクション)>,
            value     :{String} <処理データ(入力ストリーム)>,
            backup  :{String} <応答データ(入力ストリーム)>
            <他にも追加プロパティを設定可能>
        }.....
    ]
undoUnitは、inputUnitを拡張したものを使用する


//旧モデル
Xpst　操作記録第一形式
        [セレクト座標,セレクション,入力データストリーム,[セレクト座標,セレクション]]
    または第二形式（第二形式は廃止の予定）
        [セレクト座標,セレクション,Xpsオブジェクト]

    座標と選択範囲(セレクション)は配列、入力データはcomma,改行区切りの2次元のstream
    第４要素が存在する場合は、その位置にカーソル移動を行う

    第３要素がXpsオブジェクトであった場合は、ドキュメント全体の更新が行われた場合である
    その際は、処理系を切り替えて以下の操作を行う
    従来、UNDOバッファをフラッシュしていた操作が行われた場合
    現状のXPSデータを、オブジェクト化してUndoバッファに積みundoポインタを加算する。
    オブジェクト化の際は参照が発生しないように新規のXpsオブジェクトを作成のこと

    セッション内で明示的にundoバッファをクリアする際はこのメソッドをコールする

clear    :    セッション開始/ユーザ指定時
NOP    :    新規作成/保存/ダウンロード

    undoに画面描画保留機能を追加
    undoカウンタが立っている限り画面の再描画を行わない

xUI.activeDocument.undoBuffer.

undoBufferのフラッシング（初期化）はオブジェクトメソッドに変更して、ドキュメントの全てのundoBufferをクリアする
 */
 
xUI.flushUndoBuf=function(){
    this.inputFlag= "nomal";//入力フラグ "nomal"|"undo"|"redo"|"cut"|"paste"|"move"
    for(var i = 0; i< this.documents.length ; i ++)
    this.documents[i].undoBuffer.flush(this.documents[i].type);//アンドウスタッククリア
}
/*
    保存ポインタを参照してドキュメントが保存されているか否かを返す関数
    保存状態の変更とリセットも可能

 */
xUI.isStored=function(){
    return (this.activeDocument.undoBuffer.undoPt==this.activeDocument.undoBuffer.storePt)
};//このリザルトが保存状態を表す
xUI.setStored=function(myPt){
    switch(myPt){
    case "current":this.activeDocument.undoBuffer.storePt=this.activeDocument.undoBuffer.undoPt;
    break;
    case "zero":this.activeDocument.undoBuffer.storePt=0;
    break;
    case "force":this.activeDocument.undoBuffer.storePt=-1;//常にfalseになる値
    break;
    default:
        if(myPt>=0){
            this.activeDocument.undoBuffer.storePt=Math.floor(myPt);//正の数値ならその数値を整数でセット
        }
    }
    return (this.activeDocument.undoBuffer.undoPt==this.activeDocument.undoBuffer.storePt);//セット後の状態を戻す
};
/*
    作業用バックアップオブジェクト
    ユーザによる保存指定可能
    明示的に破棄することが可能
    実行環境の違いによる動作の違いはメソッド内で吸収する。

    xUI.buildBackup();現在の作業バックアップをビルドして返す
    バックアップは無名オブジェクトで
        {
            documents:[ドキュメント配列],
            references:[リファレンスデータ配列],
            activeDocumentId:<Number.ID>,
            sessionId:[セッション追跡ID配列],
            undoBuffers:[配列]
        }
    xUI.setBackup();現在の作業バックアップをストアする
    xUI.getBackup();現状のバックアップデータを返す  バックアップデータがない場合はfalse
    xUI.clearBackup();現在のバックアップデータを廃棄する。
*/
xUI.buildBackup=function(){
    var backupClast={
            documents:[this.documents[0].content.toString()],
            references:[],
            activeDocumentId:parseInt(this.activeDocumentId),
            sessionId:[String(this.documents[0].sessionRetrace)]
    };
//    ,undoBuffers:[JSON.stringify(this.documents[0].undoBuffer)]        

    for (var bix=1;bix<this.documents.length;bix++){
        backupClast.documents.push(this.documents[bix].content.toString());
        backupClast.references.push((this.documents[bix].referenceContent)? this.documents[bix].referenceContent.toString():null );
        backupClast.sessionId.push(String(this.documents[bix].sessionRetrace));
//        backupClast.undoBuffers.push(JSON.stringify(this.documents[bix].undoBuffer));
    }
console.log(backupClast);
console.log(JSON.stringify(backupClast));
    return JSON.stringify(backupClast);
}

xUI.restoreBackup=function(BackupStream){
console.log(BackupStream)
    var backupClast= JSON.parse(BackupStream);
console.log(backupClast);
    if(backupClast.documents.length){
        this.documents.clear();//アプリケーションドキュメントバッファクリア
        this.documents.push(
            new xUI.Document(
                new xMap().parsexMap(backupClast.documents[0]),
                null
            )
        );
        this.XMAP = this.documents[0].content;
        this.documents[0].id = 0;
        this.documents[0].undoBuffer=new xUI.UndoBuffer();
//        Object.assign(this.documents[0].undoBuffer,JSON.parse(backupClast.undoBuffers[0]));
        this.documents[0].sessionRetrace=backupClast.sessionId[0];

        for (var bix=1;bix<backupClast.documents.length;bix++){
//console.log(backupClast.documents[bix]);
//console.log(new Xps().parseXps(backupClast.documents[bix]));
            this.documents.push(
                new xUI.Document(
                    new Xps().parseXps(backupClast.documents[bix]),
                    new Xps().parseXps(backupClast.references[bix-1])
                )
            );
            this.documents[bix].id = bix;
            this.documents[bix].undoBuffer=new xUI.UndoBuffer();
//            Object.assign(this.documents[bix].undoBuffer,JSON.parse(backupClast.undoBuffers[bix]));
            this.documents[bix].sessionRetrace=backupClast.sessionId[bix];
        }
        
console.log('restored backupuData refreash');
        this.activeDocument = this.documents[0];//[backupClast.activeDocumentId];
        this.activeDocumentId = 0;//backupClast.activeDocumentId;
        this.documents.activate(backupClast.activeDocumentId);
console.log(this.documents)
        this.resetReceipt();

        this.resetSheet();
    }
}

xUI.setBackup=function(){
/*
    保存・レストア・削除を一つのメソッドに統一して処理する。
    プラットフォーム別の処理分岐はメソッド側で処置

    xMap拡張に伴って仕様を変更　2019
バックアップの内容は 編集中の　xMap/XPS/refereneXPS
*/

/*
    html5対応 localStorageに対して保存する。AIRはWebStorageが無い
    AIR他のlocalStorageのない環境に対して操作互換のlocalStorageオブジェクトを作成 2016.06.17
*/
    if(typeof localStorage=="undefined"){
//localStorageのないブラウザならサーバストア・CGIダウンロード  どちらもダメなら別ウインドウに書き出し
//CGIダウンロード時にはリスタートが実行されるのでその部分の排除コードが必要
//↑==callEcho時点で先行で保存フラグを立てれば自動的に回避可能
//AIRならsaveAs tempSave モーダル保存があった方がよいかも
if(fileBox.saveFile){fileBox.saveFile();}else{writeXPS(this.XPS);}

    }else{
        localStorage.setItem("info.nekomataya.remaping.backupData",this.buildBackup());
/*リファレンスデータ込みでまるごとバックアップクラスタにまとめたので、このエリアは不要
        if(this.referenceXPS){
//            alert(this.referenceXPS.toString());
          localStorage.setItem("info.nekomataya.remaping.referenceData",this.referenceXPS.toString());
//            alert(this.referenceXPS.toString());
        }*/
        if(false){
            var msg = localize(nas.uiMsg.dmBackupDone);//バックアップ終了
            alert(msg);
            };//表示は設定で抑制可能にする
        xUI.setStored("current");sync();
    }
//==================================== ここまでをシステムバックアップメソッドに移行
};

xUI.getBackup =function(){
//
    var myBackup=localStorage.getItem("info.nekomataya.remaping.backupData");
    if(myBackup!==null){
      if(confirm(localize(nas.uiMsg.dmBackupConfirm))) xUI.restoreBackup(myBackup);
    }else{
      alert(localize(nas.uiMsg.dmBackupNodata));//バックアップにデータなし
    }
}
xUI.clearBackup =function(){
    var myBackup=localStorage.removeItem("info.nekomataya.remaping.backupData");
    //var myReference=localStorage.removeItem("info.nekomataya.remaping.backupReference");
    alert(localize(nas.uiMsg.dmBackupClear));//バックアップクリア
}
/*    未保存時の処理をまとめるメソッド
未保存か否かを判別してケースごとのメッセージを出す
ユーザ判断を促して処理続行か否かをリザルトする
*/
xUI.checkStored=function(mode){
if(!mode){mode=null;}
    if(xUI.isStored()){return (true)};//保存済みなら即 true
if(fileBox.saveFile){
var    msg = localize(nas.uiMsg.dmDocumentNosave);
//ドキュメントの保存・保存しないで更新・処理をキャンセルの３分岐に変更 2013.03.18
    msg+="\n"+localize(nas.uiMsg.documentConfirmOkCancel)+"\n";
//    nas.showModalDialog("confirm2",msg,"ドキュメント更新",0,
/*
    function(){
    switch (this.status){
case 0:;//yes 保存処理  後でテンポラリファイルを実装しておくこと        
            fileBox.openMode=mode;//ファイル保存に続行処理モードが必要  デフォルトは保存のみ
            fileBox.saveFile();
break;
case 1:;
break;
case 2:;
break;
    }
);
*/
    var myAction=confirm(msg);
    if(myAction){
        //保存処理  後でテンポラリファイルを実装しておくこと        
            fileBox.openMode=mode;//ファイル保存に続行処理モードが必要  デフォルトは保存のみ
            fileBox.saveFile();
            return false;
    }else{
        xUI.setStored("current");sync();return true;// キャンセルの場合は保存しないで続行
    }
}else{
    var msg  = localize(nas.uiMsg.dmDocumentNosaveExport);//エクスポートしますか？
        msg += "\n"+localize(nas.uiMsg.dmDocumentConfirmOkCancel)+"\n";//
    var myAction=confirm(msg);
    if(myAction){
        //保存処理  後でテンポラリファイルを実装しておくこと        
            writeXPS(xUI.XPS);xUI.setStored("current");sync();
            return true
//HTMLモードの保存は頻繁だと作業性が低下するので一考
            if(ServiceUrl){callEcho()};//CGIエコー

    }else{
        //破棄して続行
        xUI.setStored("current");sync();return true
    }
}
}

/** アプリ画面全体をシフトさせる(オフセットを設定)
    @params {number}    x
    @params {number}    y

右揃えのアイテムをシフトした分だけ左に寄せて画面内に収める処理つき
現在の値に引数を加える。戻りは想定されないので注意

*/
xUI.screenShift = [0,0];
xUI.shiftScreen = function(x,y){
//　body '(top),right,bottom,(left)'
    var currentBox = [parseInt($('body').css('padding-top')),parseInt($('body').css('padding-left'))];
//console.log(currentBox);
    currentBox.forEach(function(itm,idx,itself){itself[idx]=parseInt(itm);});
    var currentFr = parseInt($('.floating-right').css('padding-right'));
    var currentAb = parseInt($('#account_box').css('padding-right'));
    var currentSh = parseInt($('#sheetHeaderTable').css('padding-right'));
    var currentLp = parseInt($('#optionPanelLogin').css('padding-right'));
//left,raightをリセット
//console.log([currentBox[1],currentFr,currentAb,currentLp])
    if(currentBox[1]!=0){
       currentFr -= currentBox[1];
       currentAb -= currentBox[1];
       currentLp -= currentBox[1];
       currentSh -= currentBox[1];
    }
//console.log([currentBox[1],currentFr,currentAb,currentLp])
    $('body').css('padding-left',x+'px');
    $('body').css('padding-top' ,y+'px');
    $('.floating-right').css('padding-right',(currentFr+x)+'px');
    $('#account_box').css('padding-right'   ,(currentAb+x)+'px');
//    $('#optionPanelLogin').css('padding-right'    ,(currentLp+x)+'px');
    $('#sheetHeaderTable').css('padding-right'    ,(currentSh+x)+'px');
//メニューバーをシフト
    document.getElementById('applicationHeadbar').style.marginLeft= (x*-1)+"px";
    document.getElementById('toolbarPost').style.marginLeft= (x*-1)+"px";
    xUI.screenShift = [x,y];
    xUI.adjustSpacer();
}
/*  TEST
xUI.shiftScreen(50,50);
*/
/*  JqueryUIのダイアログウインドウを再設定する
 *
 */
xUI.setDialog = function(dlg,opt){
    if(! dlg) dlg = $("#nas_modalDialog");
    if(! opt) opt = {};
    if(! opt.width)  opt.width = document.body.clientWidth;
    if(! opt.height) opt.height = window.innerHeight;
    if(! opt.position) opt.position = {};
    if(! opt.position.my) opt.position.my = "left top";
    if(! opt.position.at) opt.position.at = "center-"+Math.floor(opt.width/2)+" center+"+Math.floor(opt.height/2);
    dlg.dialog(opt);
}
/*    画面サイズの変更時等にシートボディのスクロールスペーサーを調整する
    固定ヘッダとフッタの高さをスクロールスペーサーと一致させる
    2010.08.28
    引数なし
 */
xUI.adjustSpacer=function(){
    var headHeight=(this.viewMode=="Compact")? $("#app_status").offset().top-$("#pMenu").offset().top:document.getElementById("fixedHeader").clientHeight;
//    var myOffset=(this.viewMode=="Compact")? $("#app_status").offset().top-headHeight:0;
    var myOffset=0;
//一時コード  あとで調整  20180916
    if(document.getElementById("scrollSpaceHd"))
        document.getElementById("scrollSpaceHd").style.height=(headHeight-myOffset)+"px";
    if(document.getElementById("xpstScrollSpaceHd"))
        document.getElementById("xpstScrollSpaceHd").style.height=(headHeight-myOffset)+"px";
    if(document.getElementById("xmapScrollSpaceHd"))
        document.getElementById("xmapScrollSpaceHd").style.height=(headHeight-myOffset)+"px";
    document.getElementById("UIheaderScrollH").style.top=(headHeight+$("#app_status").height())+"px";
    document.getElementById("UIheaderFix").style.top=(headHeight+$("#app_status").height())+"px";
    document.getElementById("UIheaderScrollV").style.top=(headHeight+$("#app_status").height())+"px";
    document.getElementById("scrollSpaceFt").style.height="1 px";
}
/**    xUI.adjustScale=function(myScale);
引数:
    myScale    Number又は配列 数値一つの場合はY方向のスケールとして扱う
    引数なしはスケール[1,1]にリセットする
戻値:
    なし
ターゲットエレメントは以下
"UIheaderFix"
"UIheaderScrollH"
"UIheaderScrollV"
"sheet_body"
ドキュメント内に存在しないエレメントは無視（印字用）
スケーリングするターゲットを別に指定する場合は  idまたはid の配列で
*/
xUI.adjustScale=function(myScale,scaleTargetID){
    if(typeof myScale == "undefined"){myScale=[1,1]}
    else if(! (myScale instanceof Array)){myScale=[1,(myScale)?myScale:1]};
    var myId=(scaleTargetID)?scaleTargetID:
    ["UIheaderFix","UIheaderScrollH","UIheaderScrollV","sheet_body"];
    if(! (myId instanceof Array )) myID=[myID];
    for (var ix=0;ix<myId.length;ix++){
        var scaleTarget=document.getElementById(myId[ix]);
        if(! scaleTarget) continue;
        if(appHost.platform.match(/CSX|CEP|AIR/)){
          scaleTarget.style.WebkitTransformOrigin="0px 0px";
          scaleTarget.style.WebkitTransform='scale('+myScale.join(",")+')';
        }else{
          scaleTarget.style.transformOrigin="0px 0px";
          scaleTarget.style.transform='scale('+myScale.join(",")+')';
        }
    }
}
//xUI.adjustScale(1,0.65);
xUI.zoomSwitch =function(){
    var scalePresets=[
        [1,1],
        [1,0.75],
        [0.75,0.66666],
        [0.5,0.5],
        [0.3333,0.3333],
        [0.25,0.25]
    ];
    this.zoomSwitch.currentPreset=(this.zoomSwitch.currentPreset+1)%scalePresets.length;
    this.adjustScale(scalePresets[this.zoomSwitch.currentPreset]);
}
xUI.zoomSwitch.currentPreset=0;
/*        xUI.reInitBody(newTimelines,newDuration);
引数:
    newTimelines    Number 新規トラック数
    newDuration    Number 新規継続時間  フレーム数
戻値:
    指定された大きさにシートを書き直す。
    元データは可能な限り維持

    undoの構造上サイズが変わると弊害が大きいので
    undoバッファは初期化する。undoを改装するまでは必須
    undoバッファ改変中  0923

    データ構造上Xpsのメソッドの方が良いので、
    データ改変部分をXPSlibに移動して
    ここではXPSのメソッドを呼び出す形式に変更  2013.02.23
    タイムシートの拡縮をundo対象に拡張    2015.09.14
    新規に現在のXPSの複製をとって、それを拡縮した後putメソッドに渡す
    putメソッド内部でUNDO処理を行う

xUI.putメソッドがobject Xpsに対応したのでこのメソッド自体が意味を失ったので使用されない
 このメソッドは基本廃止

 */
xUI.reInitBody=function(newTimelines,newDuration){
    var newXPS=new Xps(newTimelines,newDuration);
    newXPS.parseXps(this.XPS.toString());//別オブジェクトとして複製を作る
    //変更してputメソッドに渡す
    newXPS.reInitBody(newTimelines,newDuration);
if(dbg) console.log(newXPS.toString());
    this.sheetPut(newXPS);
};
/*
*/
xUI.switchStage=function(){
    alert(localize(nas.uiMsg.dmUnimplemented));//未実装
};
/**
    リファレンスエリアにデータをセットする
    引数がない場合は、現在のXPSデータをそのままセットする
    引数はオブジェクトまたはソースストリーム
    @params {Object Xps| Xps sourceString} xpsContent

*/
xUI.setReferenceXPS = function (xpsContent){
    if(typeof xpsContent == 'undefined'){
        if (! documentDepot.currentReference ) documentDepot.currentReference=new Xps();
        documentDepot.currentReference.parseXps(xUI.XPS.toString());
    }else if(! xpsContent instanceof Xps){
    	var newData = new Xps();
    	newData.readIN = xUI._readIN_xps;
        newData.readIN(xpsContent);
        if(newData){
        	documentDepot.currentReference = newData;
        }else{
        	return false;
        }
    } else if (xpsContent instanceof Xps) {
        documentDepot.currentReference = xpsContent;
    } else {
        return false;
    }
        xUI.resetSheet(undefined,documentDepot.currentReference);
        return true;
};
//////
/**
        xUI.drawSheetCell(HTMLTableCellElement)
    テーブルセルを引数で与えてグラフィック置換及びテキスト置換を行う
    trTdから分離して機能調整
    判定されたグラフィック状態はクラスとしてセルに追加される
    描画は遅延処理
*/
xUI.drawSheetCell = function (myElement){
    if(typeof myElement =="undefined"){return false;}
    var target=myElement;
    var targetJQ=$("#"+target.id);
    var formPostfix='';

    if(this.showGraphic){
        var tgtID=target.id.split("_").reverse();
        var myXps=(tgtID.length==2)? this.XPS:this.referenceXPS;
        formPostfix += (tgtID.length==2)? '':'-ref';
        if (myXps.xpsTracks[tgtID[1]].option.match(/^(efect|sfx|composite)$/)) formPostfix +='-sfx';
        var myStr = myXps.xpsTracks[tgtID[1]][tgtID[0]];
        var drawForm = false;
        var sectionDraw = false;
        var mySection = myXps.xpsTracks[tgtID[1]].getSectionByFrame(tgtID[0]);
//シートセルに  graph_*クラスがあれば削除
        var myClasses=targetJQ.attr('class').split(' ');
        for (var cix=0;cix<myClasses.length;cix++){
            if(myClasses[cix].indexOf('graph_')==0) targetJQ.removeClass(myClasses[cix]);
        }
//セクションキャッシュが信頼できる限りはセクションパースが保留されるように調整済み
/**
    判定時にトラック種別を考慮する
    ダイアログ、サウンド
    リプレースメント
    カメラ
    エフェクト
    それぞれに置き換え対象シンボルが異なるので注意
*/
        var currentTrackOption  = myXps.xpsTracks[tgtID[1]].option;
        switch(currentTrackOption){
          case "sound":;
          case "dialog":;
            if (myStr.match(/<([^>]+)>/)){
                myStr=xUI.trTd(myStr);
            };//trTdにセルIDを渡す
            if (myStr.match(/[-_─━~＿￣〜]{2,}?/)){
//セクション開始判定
              myStr=(this.showGraphic)?"<br>":"<hr>";//
//              if((mySection.startOffset()+mySection.duration-1) != tgtID[0]){}
              if(mySection.startOffset() == tgtID[0]){
                drawForm =(myStr.match(/[_＿]/))? "line":"dialogClose";
              }else{
                drawForm =(myStr.match(/[_＿]/))? "line":"dialogOpen";
              }
            };//セクションパース情報を参照
	        myStr=myStr.replace(/[-−ー─━]/g,"｜");//音引き縦棒
	        myStr=myStr.replace(/[~〜]/g,"<p class=rotate>〜</p>");//音引き縦〜
	        myStr=myStr.replace(/[…]/g,"︙");//三点リーダー
	        myStr=myStr.replace(/[‥]/g,"︰");//二点リーダー
/* 台詞中の文字置換のうち音引き、句読点は画面置き換えで処理
    ListStr=ListStr.replace(/\」/g,"---");//閉じ括弧は横棒
	ListStr=ListStr.replace(/\、/g,"・");//読点中黒
	ListStr=ListStr.replace(/\。/g,"");//句点空白(null)
*/
          break;
          case "still":;
          case "timing":;
          case "replacement":;
            if (myStr.match(/[\|｜]/)){
                myStr=(this.showGraphic)?"<br>":"｜";                
                drawForm = "line";
            }
            else if (myStr.match(nas.CellDescription.blankRegex)){
                myStr=(this.showGraphic)?"<br>":"×";                
                drawForm = "blankCloss";
            }
            else if (myStr.match(/[:：]/)){
                myStr=(this.showGraphic)?"<br>":":";                
                drawForm = "wave";
                formPostfix += (tgtID[0] % 2)? '-odd':'-evn';
            }
            else if (myStr.match(/\(([^\)]+)\)/)){
                myStr=(this.showGraphic)?RegExp.$1:xUI.trTd(myStr);
                drawForm = "circle";
           }
           else if (myStr.match(/<([^>]+)>/)){
                myStr=(this.showGraphic)?RegExp.$1:xUI.trTd(myStr);
                drawForm = "triangle";
            }
	        myStr=myStr.replace(/^([~〜])$/g,"<p class=rotate>$1</p>");//音引き縦棒
          break;
          case "camera":;
          case "camerawork":;
        if(! mySection.value) break;
        if(mySection.value.type[0]=='geometry'){
            if (myStr.match(/^[\|｜]$/)){
                myStr=(this.showGraphic)?"<br>":"｜";                
                drawForm = "line";
                formPostfix +='-gom';
            } else if (myStr.match(/^([!|！|\/|／|\\|＼]+)$/)){
                myStr=(this.showGraphic)?"<br>":xUI.trTd(myStr);                
                drawForm = "shake";
                formPostfix +='-gom';
                formPostfix += (tgtID[0] % 2)? '-odd':'-evn';
                if (RegExp.$1.length > 2){
                    formPostfix +='_l';
                }else if(RegExp.$1.length == 2){
                    formPostfix +='_m';
                }else{
                    formPostfix +='_s';
                }
            } else if (myStr.match(/^([:：]+)$/)){
                myStr=(this.showGraphic)?"<br>":xUI.trTd(myStr);                
                drawForm = "wave";
                formPostfix +='-gom';
                formPostfix += (tgtID[0] % 2)? '-odd':'-evn';
                if (RegExp.$1.length > 2){
                    formPostfix +='_l';
                }else if(RegExp.$1.length == 2){
                    formPostfix +='_m';
                }else{
                    formPostfix +='_s';
                }
            } else if (myStr.match(/^[▼▽]$/)){
                myStr=(this.showGraphic)?"<br>":xUI.trTd(myStr);                
                drawForm = "sectionOpen";
            } else if (myStr.match(/^[▲△]$/)){
                myStr=(this.showGraphic)?"<br>":xUI.trTd(myStr);                
                drawForm = "sectionClose";
            } else {
                myStr = xUI.trTd(myStr);
            }
        }else if(mySection.value.type[0]=='composite'){
//            var drawForms ={"▲":"fi","▼":"fo","△":"fi","▽":"fo"};//この配分は仮ルーチン  良くない
//if(myStr.match(/^</)) console.log(myStr);
            var drawForms ={"▲":"fi","▼":"fo","△":"fi","▽":"fo","]><[":"transition"};//この配分は仮ルーチン  良くない
            if (myStr.match(/^[\|｜↑↓\*＊]$/)){
                if(this.hideSource) myStr="<br>";                
            } else if (myStr.match(/^[▼▽]$/)){
                if(this.hideSource) myStr="<br>";                
            } else if (myStr.match(/^[▲△]$/)){
                if(this.hideSource) myStr="<br>";                
            } else if (myStr.match(/^\]([^\]]+)\[$/)){
                if(this.hideSource) myStr="<br>";
            } else {
                myStr = xUI.trTd(myStr);
            }
if(! mySection) console.log(myElement);
            if((mySection.startOffset()+mySection.duration-1) == tgtID[0]){
                var formStr = myXps.xpsTracks[tgtID[1]][mySection.startOffset()];
                drawForm = drawForms[formStr];
                sectionDraw = true;
            }
        }else if(mySection.value.type[0]=='transition'){
            if((mySection.startOffset()+mySection.duration-1) == tgtID[0]){
                var formStr = myXps.xpsTracks[tgtID[1]][mySection.startOffset()];
                drawForm = 'transition';
                sectionDraw = true;
            }
            myStr = xUI.trTd(myStr);
        } else {
                myStr = xUI.trTd(myStr);
            }

          break;
          case "geometry":;
          case "stage":;
          case "stagework":;
myStr = xUI.trTd(myStr); break;
            if (myStr.match(/^[\|｜]$/)){
                myStr=(this.showGraphic)?"<br>":"｜";                
                drawForm = "line";
                formPostfix +='-gom';
            } else if (myStr.match(/^([!|！|\/|／|\\|＼]+)$/)){
                myStr=(this.showGraphic)?"<br>":xUI.trTd(myStr);                
                drawForm = "shake";
                formPostfix +='-gom';
                formPostfix += (tgtID[0] % 2)? '-odd':'-evn';
                if (RegExp.$1.length > 2){
                    formPostfix +='_l';
                }else if(RegExp.$1.length == 2){
                    formPostfix +='_m';
                }else{
                    formPostfix +='_s';
                }
            } else if (myStr.match(/^[▼▽]$/)){
                myStr=(this.showGraphic)?"<br>":xUI.trTd(myStr);                
                drawForm = "sectionOpen";
            } else if (myStr.match(/^[▲△]$/)){
                myStr=(this.showGraphic)?"<br>":xUI.trTd(myStr);                
                drawForm = "sectionClose";
            } else {
                myStr = xUI.trTd(myStr);
            }
          break;
          case "composite":;
          case "effect":;
          case "sfx":;
            if(! mySection.value) break;
if(myStr.match(/^</)) console.log(myStr);
            var drawForms ={"▲":"fi","▼":"fo","]><[":"transition"};//この配分は仮ルーチン  良くない
            if (myStr.match(/^[\|｜↑↓\*＊]$/)){
                if(this.hideSource) myStr="<br>";                
            } else if (myStr.match(/^▼$/)){
                if(this.hideSource) myStr="<br>";                
            } else if (myStr.match(/^▲$/)){
                if(this.hideSource) myStr="<br>";                
            } else if (myStr.match(/^\]([^\]]+)\[$/)){
                if(this.hideSource) myStr="<br>";
            } else {
                myStr = xUI.trTd(myStr);
            }
if(! mySection) console.log(myElement);
            if((mySection.startOffset()+mySection.duration-1) == tgtID[0]){
                var formStr = myXps.xpsTracks[tgtID[1]][mySection.startOffset()];
                drawForm = drawForms[formStr];
                sectionDraw = true;
            }
          break;
    }
    target.innerHTML=myStr;
if(this.showGraphic){    
    if((sectionDraw)&&(drawForm)){        
        xUI.Cgl.sectionDraw([tgtID[1],mySection.startOffset()].join("_"),drawForm,mySection.duration);
    }else{
        if(drawForm) targetJQ.addClass('graph_'+drawForm+formPostfix);
    }
}
    return myStr;
}
}
/**
    テーブル表示用文字列置換
        xUI.trTd(Str);
引数:テーブルセルID配列または単独文字列
    テーブルセルのID からターゲット求め
    タグ等htmlで表示不能な文字を置き換える
    戻り値は変換後の文字列
    画面（テーブル）表示のみに使用する
    ＝XPSのデータは保全される
    要素が配列でない場合は直接ターゲットにする
*/
xUI.trTd=function(myID){
if(typeof myID == "undefined"){return false;}
//if(typeof arguments[0] =="undefined"){return false;}
    if(! (myID instanceof Array)){
        var target = myID;
        //var target=arguments[0];
    }else{
        var target = (myID[0]=='r') ?
            xUI.referenceXPS.xpsTracks[myID[1]][myID[2]]:
            xUI.XPS.xpsTracks[myID[0]][myID[1]];
    }
/** HTML表示用に実体参照に置換
*/
  var str = String(target);//明示的に文字列化
  var result = "";
  for(var i = 0 ; i < str.length ; i++) {
    var c = str.charAt(i);var cstr = '';
    if((' ' <= c && c <= '~') || (c == '\r') || (c == '\n')) {
      if(c == '&') {
        cstr = "&amp;";
      } else if(c == '<') {
        cstr = "&lt;";
      } else if(c == '>') {
        cstr = "&gt;";
      } else {
        cstr = c.toString();
      }
    } else {
      cstr = "&#" + c.charCodeAt().toString() + ";";
    }
      result += cstr;
  }
    return result;

};
//
/*    XPSのプロパティの配列要素を"_"でつないで返す(シート上のidに対応)
        getId(要素名)
    現在は"Select"のみが有効値
    "Selection"ではIDを計算する
*/

xUI.getid=function(name){

    if ((this[name].length==0)||(this[name][0]==null))  return '';
  switch(name){
    case "Selection":
        return add(this.Select,this[name]).join("_");
    case "Select":
        return this[name].join("_");
  }
};
/*    指定のシートセルを選択状態にしてカレントのカーソル位置を返す
        xUI.selectCell(HTMLElementID)
        xUI.selectCell([myTrack,myFrame]);
引数が配列の場合も受け付ける
フレームオフセットが加算される
*/
xUI.selectCell=function(ID,frameOffset){
//    if (typeof ID == "undefined") ID = '';//
    if (typeof ID == "undefined") ID = this.selectBackup;//バックアップ位置と換装
    if (typeof frameOffset == "undefined") frameOffset = 0;
if(dbg) document.getElementById("app_status").innerHTML=ID;//デバッグ用
//      現在のセレクトをフォーカスアウト 引数が偽ならば フォーカスアウトのみ(ここでリターン)
    if(! ID){return;};
//      選択セルの内容をXPSの当該の値で置換 新アドレスにフォーカス処理開始 = IDをセレクト
//      指定IDが稼働範囲外だったら丸め込む
if(! (ID instanceof Array)) ID = ID.split('_') ;
    var tRack = Number(ID[0]);
    var fRame = Number(ID[1])+frameOffset;

    if (tRack<0 || tRack>=this.SheetWidth){    tRack=(tRack<0)?0:this.XPS.xpsTracks.length-1;};
    if (fRame<0 || fRame>=this.XPS.duration()) {    fRame=(fRame<0)?0:this.XPS.duration()-1;};
    ID = tRack+'_'+fRame;
//    JQオブジェクトを取得
    var currentJQItem=$("#"+ID);
//    セレクションクリア
        this.selectionHi("clear");
//    フットマーク機能がオンならば選択範囲とそしてホットポイントをフミツケ
    var myTgtId = this.getid('Select');var paintColor;
    if(this.footMark && this.diff(myTgtId)){
        paintColor=this.footstampColor;//                    == footmark ==
    }else{
        paintColor=this.sheetbaseColor;//                    == clear ==
    };
    if(document.getElementById(myTgtId))
    document.getElementById(myTgtId).style.backgroundColor=paintColor;

//フレームの移動があったらカウンタ更新フラグ立てる
        var fctrefresh = (fRame==this.Select[1])? false : true ;
//レイヤの移動があったらボタンラベル更新フラグ立てる
        var lvlrefresh = (tRack==this.Select[0])? false : true ;
//セレクト更新
    this.Select=[tRack, fRame];
        if(fctrefresh) sync("fct");//
        if(lvlrefresh) sync("lvl");//カウンタ同期
//入力同期
    this.selectionHi("hilite");    //選択範囲とホットポイントをハイライト
    this.bkup([this.XPS.xpsTracks[tRack][fRame]]);    //編集前にバックアップする
    var eddt=this.XPS.xpsTracks[tRack][fRame];    //編集済データ取得
//    ヘッドライン
    if(document.getElementById("iNputbOx").value!=eddt)
    {    document.getElementById("iNputbOx").value=eddt;};//編集ラインに送る
/*    オートスクロールフラグが立っていたらスクロールを制御
    現在、オートスクロールで移動時にマウスによる選択処理をキャンセルしている
    オートスクロールのアルゴリズムが改善されたら処理を検討のこと
    コンパクトモードと通常モードで動作切り替え

    全体の位置に加えて、現在のスクーンサイズを条件に追加して使用感を改善すること
    2015-0331
    
    区間選択状態または選択状態のドラグ時に選択セルに対するフォーカスオフセットが働くように改装
    2017-0324

オートスクロール起動条件
縦方向    セルフォーカスが表示範囲上下一定（６または８？）フレーム以内であること(上下別の条件に)
横方向  セルフォーカスが表示範囲左右一定（２～４？）カラム以内であること（左右別条件に）
かつ移動余裕があること=各条件がシート端からの距離以上であること
スクロール停止フラグが立っていないこと

*/
    if ((this.autoScroll)&&(! this.scrollStop)){
        var targetID=add(xUI.Select,[0,xUI.sectionManipulateOffset[1]]).join('_');
        this.scrollTo(targetID); 
    };
    document.getElementById("iNputbOx").select();
    return this.Select;
};
/*    カラム移動
        xUI.changeColumn(カラムID,カラムブロック番号)
        カラムブロック番号は、タイムシートのひとかたまりのブロック番号
        2段シートならば第一ページにはブロック0および1がある
*/
xUI.changeColumn =function(ID,cols){
if(this.viewMode=="Compact"){
    var fr=this.Select[1];
}else{
//レイヤIDとカラムIDから移動位置を算出して実行。移動不能の場合は何もせずに復帰
    if(ID=="memo"){ID=this.XPS.xpsTracks.length -1};

    var lineOffset=this.Select[1]-Math.floor(this.Select[1]/(this.PageLength/this.PageCols))*(this.PageLength/this.PageCols);//ラインオフセット
    var fr=cols*(this.PageLength/this.PageCols)+lineOffset;
    if(fr>=this.XPS.duration()){return};
}
    this.selectCell(([ID,fr]).join("_"));
};
//
//
/*    マルチセレクト
        xUI.selection(ID)
        xUI.selection([myTrack,myFrame]);
        現在のカーソル位置からIDまでの範囲を選択状態にする
        引数が空なら選択解除
        引数が配列の場合も受け付ける 負の数もOK
*/
xUI.selection =function(ID){

//現行のセレクションハイライトクリア
//選択範囲とホットポイントをフミツケ
    this.selectionHi("clear");
//引数未指定ならクリアのみでリターン
    if((typeof ID=="undefined")||(ID==null)){
        this.Selection=[0 ,0];
        document.getElementById("edchg").style.backgroundColor="";//ここでUI表示をクリアする
        this.selectionHi("hilite");
        return;
    };
//ID値から、セレクションの値を導く
if(!(ID instanceof Array))ID=ID.split("_");
    this.Selection=[parseInt(ID[0])-this.Select[0],parseInt(ID[1])-this.Select[1]];

    document.getElementById("edchg").style.backgroundColor=this.selectingColor;//ここでUIインジケータ表示
    this.selectionHi("hilite");
};

/*    選択範囲のハイライト
        xUI.selectionHi(メソッド)
        範囲が許容外だった場合は範囲を維持して操作無し
        メソッドは["hilite","footmark","clear"]
        モード遷移毎にカラーを変更するのはモードチェンジメソッドで集中処理
        
*/
xUI.selectionHi    =function(Method){
switch (Method) {
case    "hilite"    :
                var paintColor=this.selectionColor;break;
case    "footmark"    :
                this.spinHi("clear");
                var paintColor=this.footstampColor;break;
case    "clear"        :
                this.spinHi("clear");
default            :
    var paintColor=this.sheetbaseColor;break;
};
var range=this.actionRange();
//    dbgPut("selectionHi :\n"+range.join("\n"));
//新選択範囲をハイライト スタートアドレスに負数を許容  150919
//セクション編集のために選択範囲の末尾を色変え可能に拡張
    for (var C=range[0][0];C<=range[1][0];C++){
        for (var L=range[0][1];L<=range[1][1];L++){
try{
            if((C<0) || (L<0)||(C>=this.XPS.xpsTracks.length)||(L>=this.XPS.xpsTracks[C].length)){
//    当座のバグ回避とデバッグ C.Lが操作範囲外だったときの処置 値を表示
//                dbgPut(range.toString());
            }else{
                if (!(this.Select[0] == C && ( ((this.edmode>0)? 1:this.spinValue)+this.Select[1] > L && this.Select[1] <= L)))
                {
                    if(Method=="hilite")
                    {
                        if(((L==range[1][1])||(L==range[0][1]))&&(xUI.edmode>1)){
                            paintColor=xUI.selectionColorTail;
                        }else{
                            paintColor=xUI.selectionColor;
                        }
                    }else{
                        if(this.footMark && this.diff([C,L]))
                        {
                            paintColor=xUI.footstampColor;
                        }else{
                            paintColor=xUI.sheetbaseColor;
                        };
                    };
                    if(nas.colorAry2Str(nas.colorStr2Ary(document.getElementById(C+"_"+L).style.backgroundColor))!=paintColor)
                    {
                        document.getElementById(C+"_"+L).style.backgroundColor=paintColor;//セレクションのリペイント
                    };
                };
            };
}catch(err){dbgPut("range err :C="+C+"  :L= "+L)};
        };
        if(Method=="hilite"){this.spinHi("put")};
    };
};

/*    スピン範囲のハイライト処理
        xUI.spinHi(メソッド)
        メソッドは["clear"]またはそれ以外
*/
xUI.spinHi = function(Method){
//選択ポイントのハイライトおよびスピン範囲のハイライト
    if(! document.getElementById(this.getid("Select"))){if(dbg) dbgPut(this.getid("Select")) ;return;};
    if(Method == "clear") {
        document.getElementById(this.getid("Select")).style.backgroundColor=this.footstampColor;
    }else{
        document.getElementById(this.getid("Select")).style.backgroundColor=this.selectedColor;
    };

//    スピン 1 以上を処理 選択範囲内外で色分け

    for(var L=this.Select[1]+1;L<((this.edmode > 0)? 1:this.spinValue)+this.Select[1];L++){
        if(L > 0 && L < this.XPS.xpsTracks[0].length){
            if((Method=="clear")){
                if(this.diff([this.Select[0],L]) && this.footMark){
                    document.getElementById(this.Select[0]+"_"+L).style.backgroundColor=this.footstampColor;//スピンエリア表示解除
                }else{
                    if(document.getElementById(this.Select[0]+"_"+L).style.backgroundColor)
                        document.getElementById(this.Select[0]+"_"+L).style.backgroundColor=this.sheetbaseColor;//スピンエリア表示解除
                };
            }else{
                if(L>(this.Selection[1]+this.Select[1])){
                    if(nas.colorAry2Str(nas.colorStr2Ary(document.getElementById(this.Select[0]+"_"+L).style.backgroundColor))!=this.spinAreaColor)
                        document.getElementById(this.Select[0]+"_"+L).style.backgroundColor=this.spinAreaColor;//スピンエリア表示
                }else{
                    if(nas.colorAry2Str(nas.colorStr2Ary(document.getElementById(this.Select[0]+"_"+L).style.backgroundColor))!=this.spinAreaColorSelect)
                        document.getElementById(this.Select[0]+"_"+L).style.backgroundColor=this.spinAreaColorSelect;//スピンエリア表示
                };
            };
        };
    };

//スピン表示が現状と異なっていた場合更新
    if ( document.getElementById("spin_V").value != xUI.spinValue){
         document.getElementById("spin_V").value  = xUI.spinValue;
    }
};
//spinHi
/*  足跡（差分表示）をリセット
引数があれば状況をセット
         有効状態ならば、Paint
         無効状態ならば、Clear
         
*/
xUI.footstampReset    =function(opt){
    if(xUI.activeDocumentId == 0) return ;
    if(typeof opt != 'undefined'){this.footMark=(opt)?true:false;};
    if(this.footMark){this.footstampPaint()}else{this.footstampClear()};
    if(document.getElementById("ibMfootStamp")){
        document.getElementById("ibMfootStamp").innerHTML=(xUI.footMark)?"✓":"";
    }
}
/*    足跡をクリア
        xUI.footstampClear();
 */
xUI.footstampClear    =function(){
    if(xUI.activeDocumentId == 0) return ;
//    var flipStatus=false
//    if(! this.footMark){flipStatus=true;this.footMark=true;}
    if (this.footstampColor){
        var BGr=parseInt("0x"+this.footstampColor.substr(1,2),16);
        var BGg=parseInt("0x"+this.footstampColor.substr(3,2),16);
        var BGb=parseInt("0x"+this.footstampColor.substr(5,2),16);
    } else {BGr=0;BGg=0;BGb=0;};
    var BGColor="rgb("+BGr+", "+BGg+", "+BGb+")";
//    if (! this.footMark) {return;};
//足跡のお掃除
    for (var c=0;c<(this.SheetWidth);c++){
            for(var f=0;f<(this.XPS.duration());f++){
        if (this.getid("Select")!=(c+"_"+f)){
    if (
        document.getElementById(c+"_"+f).style.backgroundColor==BGColor ||
        document.getElementById(c+"_"+f).style.backgroundColor==this.footstampColor
    ){
        document.getElementById(c+"_"+f).style.backgroundColor=this.sheetbaseColor;
    };
        };
            };
    };
//    if(flipStatus){this.footMark=false;}
};
/*    足跡をチェック
        xUI.footstampPaint();
        現在のカーソル位置を控えて全選択して解除
        カーソル位置を戻す
 */
xUI.footstampPaint    =function(){
    if(xUI.activeDocumentId == 0) return ;
    var flipStatus=false
    if(! this.footMark){flipStatus=true;this.footMark=true;}
    var restoreValue=this.getid("Select");
        this.selectCell("0_0");
        this.selection((this.SheetWidth-1)+"_"+this.XPS.duration());
        this.selection();
        this.selectCell(restoreValue);
    if(flipStatus){this.footMark=false;}
};
/**
    ヘッダ部分の背景色を点滅させる
引数:点滅色 未指定の際は'#808080'<> 背景色

*/
xUI.headerFlash = function(hilightColor){
var originalColor=xUI.sheetLooks.SheetBaseColor;
if(!hilightColor) hilightColor='#808080';

    $("#fixedHeader").css("background-color",hilightColor);
    setTimeout(function(){
        $("#fixedHeader").css("background-color",originalColor);
        if(! document.getElementById("forgetInputWarning").checked) document.getElementById("iNputbOx").blur();
/*        setTimeout(function(){
            $("#fixedHeader").css("background-color",hilightColor);
            setTimeout(function(){
                $("#fixedHeader").css("background-color",originalColor);
            },75);
        },120);*/
        if(! document.getElementById("forgetInputWarning").checked) {xUI.sWitchPanel("Rol");}
    },150);
    return false;
};

//test xUI.headerFlash();

/*    タイムシート本体のヘッダを返すメソッド(ページ単位)
        xUI.headerView(pageNumber)
        引数はページ番号を整数で
        第一ページ以外は省略形を返す
        戻り値はページヘッダのHTMLテキスト
 */
xUI.headerView = function(pageNumber){

var Pages=(this.viewMode=="Compact")? 1:Math.ceil(this.XPS.duration()/this.PageLength);//ページ長で割って切り上げ
var    _BODY ='';
//----印字用ページヘッダ・第一ページのみシートヘッダ---//
if(pageNumber>1){
//    _BODY+='<div class="pageBreak"> </div>';
    _BODY+='<div class="printPageStatus">';
    _BODY+=decodeURIComponent(Xps.getIdentifier(xUI.XPS,'job')) +' : '+new Date().toNASString();
    _BODY+='</div><table class=pageHeader>';
}else{
    _BODY+='<div class="printPageStatus">';
    _BODY+=decodeURIComponent(Xps.getIdentifier(xUI.XPS,'job')) +' : '+new Date().toNASString();
    _BODY+='</div><table class=sheetHeader>';
};
//  ページヘッダとシートヘッダの共通表示

    _BODY+='<tr>';
    _BODY+='<td class="pgHeader opusHeader" id="opus'+pageNumber+'">'+this.XPS.opus+'</td>';
    _BODY+='<td class="pgHeader titleHeader" id="title'+pageNumber+'">'+this.XPS.title+this.XPS.subtitle+'</td>';
    _BODY+='<td class="pgHeader scenecutHeader" id="scene_cut'+pageNumber+'">'+this.XPS.scene+this.XPS.cut+'</td>';
    _BODY+='<td class="pgHeader timeHeader" id="time'+pageNumber+'">'+nas.Frm2FCT(this.XPS.time(),3,0,this.XPS.framerate)+'</td>';
    _BODY+='<td class="pgHeader nameHeader" id="update_user'+pageNumber+'">'+(this.XPS.update_user.toString()).split(":")[0]+'</td>';
//    _BODY+='<td class=pgHeader id="update_user'+pageNumber+'">'+this.XPS.update_user.handle+'</td>';
//シート番号終了表示
if(pageNumber==Pages){
    _BODY+='<td class="pgHeader pageHeader" >'+'end / '+Pages+'</td>';
}else{
    _BODY+='<td class="pgHeader opusHeader">'+pageNumber+' / '+Pages+'</td>';
};
    _BODY+='</tr>';

    _BODY+='<tr><th class="headerLabel opusHeader">No.</th><th class="headerLabel titleHeader">TITLE</th><th class="headerLabel scenecutHeader">S-C</th><th class="headerLabel timeHeader">TIME</th><th class="headerLabel nameHeader">name</th><th class="headerLabel pageHeader">page</th></tr>';
//ページヘッダを閉じる
    _BODY+='</table>';

    _BODY+='<table  class=sheetHeaderMargin ><tr><td class=memoSpace>';
//第一ページのみシート全体のコメントを書き込む（印刷用）  表示用には別のエレメントを使用
if(pageNumber==1){
//シート書き出し部分からコメントを外す 印刷時は必要なので注意 2010/08/21
    _BODY+='<span class=top_comment ><u>memo:</u>';  
    _BODY+='<span id="transit_dataXXX">';
    _BODY+= this.XPS.getNoteText();
/*
    if(this.XPS.trin.frames() > 0){
        _BODY+="△ "+this.XPS.trin[1]+'('+nas.Frm2FCT(this.XPS.trin[0],3,0,this.XPS.framerate)+')';
    };
    if((this.XPS.trin[0]>0)&&(this.XPS.trout[0]>0)){    _BODY+=' / ';};
    if(this.XPS.trout[0]>0){
    _BODY+="▼ "+this.XPS.trout[1]+'('+nas.Frm2FCT(this.XPS.trout[0],3,0,this.XPS.framerate)+')';
    };// */
    _BODY+='</span>';

        _BODY+='<div id="memo_prt" class=printSpace >';
        if(this.XPS.xpsTracks.noteText.toString().length){
            _BODY+=this.XPS.xpsTracks.noteText.toString().replace(/(\r)?\n/g,"<br>");
        }else{
            _BODY+="<br><br><br><br><br><br>";
        };
        _BODY+='</div>';

    _BODY+='</span>';
}else{
    _BODY+='<div class=printSpace ><br><br><br><br><br><br></div>';
};
    _BODY+='</td></tr></table>';


if(pageNumber==1){
//    document.getElementById("UIheaderScrollH").innerHTML=this.pageView(0);
//    document.getElementById("UIheaderScrollV").innerHTML=this.pageView(-2);
}

    return _BODY;
};
//end headerView()
/*    タイムシート本体のHTMLを返すメソッド(ページ単位)
 *        xUI.pageView(pageNumber)
 *        引数はページ番号を整数で
 *        戻り値はページ内容のHTMLテキスト
 *ページヘッダであった場合のみ固定のタイムラインヘッダーを出力する（画面表示専用）
 * 固定ヘッダの  第一第二第三  象限を出力する
 *   2  |  1 (横スクロール)
 *  ----+-----
 *  3   |   4
 *
 *引数:
 *0    第一象限(-1)
 *-1    第二象限(-2)
 *-2    第三象限(-3)
 *    内部パラメータでは各値ともに減算して使用  --
 *    0以上は通常ページの出力（0 org）
 *
 *
 */
xUI.pageView =function(pageNumber)
{
    var restoreValue=this.Select;
    var BODY_ = '';
    var headlineHeight=36;
//ページ数//プロパティに変更せよ
if(this.viewMode=="Compact"){
var Pages=1;//コンパクトモードでは固定
var SheetRows=Math.ceil(this.XPS.duration()/this.XPS.framerate)*Math.ceil(this.XPS.framerate);
var hasEndMarker=true;// 継続時間終了時のエンドマーカー配置判定(必ず描画)
}else{
var Pages=Math.ceil((this.XPS.duration()/this.XPS.framerate)/this.SheetLength);//総尺をページ秒数で割って切り上げ
var SheetRows=Math.ceil(this.SheetLength/this.PageCols)*Math.ceil(this.XPS.framerate);
var hasEndMarker=false;// 継続時間終了時のエンドマーカー配置判定(初期値)
//コンパクトモード用の固定表示が残っている場合消去する
if((document.getElementById('qdr3'))&&(document.getElementById('qdr3').innerHTML)){
    document.getElementById('qdr1').innerHTML='';
    document.getElementById('qdr2').innerHTML='';
    document.getElementById('qdr3').innerHTML='';
}
}
/*
(2010/11/06)
    現在  PageLengthは冗長フレームを含む <秒数×フレーム母数>
    シート秒数が指定カラムで割り切れない場合は最後のカラムの秒数を1秒短縮して対応する仕様にする
    5秒シート  2段組みの場合  2.5秒2段でなく  3秒と2秒の段を作る
    従って1段のフレーム数は  切り上げ（指定秒数/指定段数）×フレーム母数

(2014/11/17)
    簡易表示のためのタイムラインヘッダを戻す機能を追加
    引数が0以下の場合はヘッダのみを返す
(2015/04/17)
    さらに拡張
引数    0でヘッドライン全体を第一象限用に
    -1で固定部第二象限に
    -2で第三象限に
    それぞれ出力する

簡易UIのために
タイムラインラベルを タイミング適用スイッチに兼用する拡張…可能？12/17

(2015/01/07)
    アクション欄をたたむ（非表示）
    アクション欄のタイムライン  表示プロパティの増設
(2016/07/16)
    アクション（リファレンス）欄の表示オプションを増設
    xUI.referenveView に  種別キーワードを配列で格納
    初期状態ではセル（置きかえ＋スチル）のみを表示する
(2016/08/19)
    xpsTracksとlayersの統合に伴うチューニング
(2017/07/20)
    リファレンスエリアのシート内容表示の際トラック抽出のバグがあったのを修正
(2017/07/21)
 ページ内に最終フレームが含まれるか否かを判定してカット記述終了マーカーを配置する拡張
(2018/03/10)
 トラック注釈を引き出し線付きで表示する機能増設
(2019/01/20)
 固定オーバーレイが参照非表示の際に表示乱れするのを抑制（高さ）
*/
//ページ番号が現存のページ外だった場合丸める
    if (pageNumber >=Pages){
        pageNumber=Pages;
    } else {
        if(pageNumber<=-3) pageNumber=0;
    };
    pageNumber--;

//タイムシートテーブル

//タイムシートテーブルボディ幅の算出
/*
タイムシートのルック調整の為のおぼえがき
画面上は、規定幅のエレメントをすべて設定した状態で配置(cssに設定)
全体幅は自動計算
印字上は全体幅の規定が存在するので、規定幅をテーブル全体幅に設定して
フレームコメント以外の各エレメントの設定をcssで行い
誤差をフレームコメントで吸収する。（epsと同じアルゴリズム）
そのために必要な表示クラスを設定
    TimeGuideWidth    th.timeguidelabel
    ActionWidth    th.layerlabelR
    DialogWidth    th.dialoglabel
    SheetCellWidth    th.layerlabel
*new    cameraWidth    th.cameraLabel
    CommentWidth    th.framenotelabel
    ColumnSeparatorWidth colSep
印字に適さない設定(幅/高さオーバー)の場合は、一応警告を表示する。
印字用cssは、固定で作成する。A4,A3,B4,レターサイズくらいのところで作る

*/
/**/
if(this.viewMode=="Compact"){
var tableFixWidth=(
    this.sheetLooks.TimeGuideWidth +
    this.sheetLooks.ActionWidth*this.referenceLabels.length 
    );
var tableColumnWidth=(
    tableFixWidth+
    this.sheetLooks.DialogWidth*xUI.dialogCount +
    this.sheetLooks.SoundWidth*xUI.soundCount +
    this.sheetLooks.StillCellWidth*xUI.stillCount +
    this.sheetLooks.GeometryCellWidth*xUI.stageworkCount +
    this.sheetLooks.SfxCellWidth*xUI.sfxCount +
    this.sheetLooks.CameraCellWidth*xUI.cameraCount +
    this.sheetLooks.SheetCellWidth*xUI.timingCount +
    this.sheetLooks.CommentWidth );//

/*+
    DialogWidth*(xUI.dialogSpan-1)
        (第二・第三象限固定幅)
    (
    参照レイヤ数*参照セル幅+
    タイムヘッダ幅+
    ダイアログ幅
    )
    TimeGuideWidth +
    ActionWidth*xUI.referenceLabels.length +
    DialogWidth*(xUI.dialogCount-xUI.dialogSpan)+
*/
//alert(    DialogWidth*(xUI.dialogCount-xUI.dialogSpan) );
    var tableBodyWidth=tableColumnWidth;
/*
コンパクトモードで１段固定(第一象限スクロールデータ)
    (
    参照レイヤ数*参照セル幅+
    タイムヘッダ幅+
    ダイアログ幅+
    stillレイヤ数*stillセル幅+
    timingレイヤ数*timingセル幅+
    sfxレイヤ数*sfxセル幅+
    cameraレイヤ数*cameraセル幅+
    コメント欄幅
    )
*/
    var PageCols=1;
    var SheetLength=Math.ceil(this.XPS.duration()/this.XPS.framerate);
}else{
//シートワープロモード
/*    第二象限固定ヘッダは、タイムガイド幅
    第一象限ヘッダーはカラム数分繰り返し
    第三象限ヘッダーはシート枚数分繰り返し
UI設定に基づいて段組
*/
    var tableFixWidth=this.sheetLooks.TimeGuideWidth;

    var tableColumnWidth=(
    this.sheetLooks.TimeGuideWidth +
    this.sheetLooks.ActionWidth*this.referenceLabels.length +
    this.sheetLooks.DialogWidth*xUI.dialogCount +
    this.sheetLooks.SoundWidth*xUI.soundCount +
    this.sheetLooks.StillCellWidth*xUI.stillCount +
    this.sheetLooks.GeometryCellWidth*xUI.stageworkCount +
    this.sheetLooks.SfxCellWidth*xUI.sfxCount +
    this.sheetLooks.CameraCellWidth*xUI.cameraCount +
    this.sheetLooks.SheetCellWidth*xUI.timingCount +
    this.sheetLooks.CommentWidth );
/*
    以前はテーブル内のタイムラン種別をここで判定していたが
    xUIのプロパティに変換してこちらでは計算のみを行う仕様に変更済み 2015/04.25
*/
    var tableBodyWidth=tableColumnWidth * this.PageCols +
        (this.sheetLooks.ColumnSeparatorWidth*(this.PageCols-1));//
/*
    (
    参照レイヤ数*参照セル幅+
    タイムヘッダ幅+
    ダイアログ幅+
    stillレイヤ数*stillセル幅+
    timingレイヤ数*timingセル幅+
    stageworkレイヤ数*geometryセル幅+
    sfxレイヤ数*sfxセル幅+
    cameraレイヤ数*cameraセル幅+
    コメント欄幅
    )×ページカラム数＋カラムセパレータ幅×(ページカラム数?1)
*/

    var PageCols=this.PageCols;
    var SheetLength=this.SheetLength

    if(pageNumber==(Pages-1)){hasEndMarker=true;};
}

/*
BODY_ += 'onMouseDown =" return xUI.Mouse(event)"';
BODY_ += 'onMouseUp =" return xUI.Mouse(event)"';
BODY_ += 'onMouseOver =" xUI.Mouse(event)"';
*/
//alert(tableFixWidth+":"+tableBodyWidth);
//============= テーブル出力開始
BODY_ +='<table class=sheet cellspacing=0 ';
    if(pageNumber<=-2){
//第2,3象限用
BODY_ +='style="width:'+(tableFixWidth)+this.sheetLooks.CellWidthUnit+'"';
    }else{
//第1,4象限用
BODY_ +='style="width:'+tableBodyWidth+this.sheetLooks.CellWidthUnit+'"';
    }
    if(pageNumber<0){
BODY_ +='id="qdr'+(-1*pageNumber)+'" ';
    }else{
BODY_ +='id="qdr4" ';
//BODY_ +='id="qdr4_'+String(pageNumber)+'" ';
    }
BODY_ +=' >';
BODY_ +='<tbody>';
    if(true){
//========================================シートヘッダ
/*    テーブルルックを決め込む為の幅配置及び将来的にリンクペアレントを表示する領域(かも)
    第一行目
    UI上は、イベント受信を担当するのは最も上に表示されるエレメント
*/
BODY_ +='<tr class=tlhead ';
    if(this.viewMode=="Compact") BODY_ +='id=tlhead';
    if(pageNumber==0) BODY_ +='Parent';
BODY_ +='>';
//*==============================ページカラムループ処理
    for (var cols=0;cols < PageCols;cols ++){
/*********** timeguide ********************/
BODY_ +='<th class="tcSpan tlhead"';
BODY_ +=' ></th>';

if((this.viewMode!="Compact")&&(pageNumber<=-2)){break;
//第二第三象限でかつコンパクトモードでない場合はここでブレイクしてヘッダーを縮小
}
/*********** Action Ref *************/
//=====================参照エリア
        for (var r=0;r<this.referenceLabels.length;r++){
BODY_ +='<th class="referenceSpan tlhead ref" ';
BODY_ +='> </th>';
        };

/*********** Dialog Area*************/
//予約タイムラインの為一回分 別に出力
//BODY_ +='<th class=dialogSpan ';
//BODY_ +='> </th>';
/************左見出し固定時の処理*****************/
    if(pageNumber<=-2){
/*********** Edit Area *************/
//=====================編集セル本体の固定部分のみをタイムライン種別に合わせて配置(ラベル部分)
if(true){
        for (var r=0;r<(xUI.dialogSpan);r++){
    BODY_ +='<th class="dialogSpan tlhead"  id="TL'+(r+1)+'" ></th>';
        }
}else{
        for (var r=0;r<this.XPS.xpsTracks.length;r++){
//BODY_ +='<th class="editSpan" ';//editSpanは後で消しておくこと
 switch (this.XPS.xpsTracks[r].option)
 {
case "dialog":
case "sound":
    BODY_ +='<th class="dialogSpan tlhead" ';
    BODY_ +=' id="TL'+ r +'"';
    BODY_ +=' >';
    BODY_ +='</th>';
break;
case "still":
case "sfx":
case "camera":
case "timing":
default:
 }
        };
//BODY_ +='</tr><tr>';//改段
}

    }else{
/*第一、第四象限用処理*/
/*********** Edit Area *************/
//=====================編集セル本体をタイムライン種別に合わせて配置(ラベル部分)
        var noteStep = 1;  
        for (var r=0;r<this.XPS.xpsTracks.length-1;r++){
            //末尾レコードはコメント固定なので判定せず（レコード長から1減算）
 switch (this.XPS.xpsTracks[r].option)
 {
case "dialog":  BODY_ +='<th class="dialogSpan tlhead" ';break;
case "sound" :  BODY_ +='<th class="soundSpan tlhead" ';break;
case "still" :  BODY_ +='<th class="stillSpan tlhead" ';break;
case "sfx"   :  BODY_ +='<th class="sfxSpan tlhead" ';break;
case "geometry":BODY_ +='<th class="geometrySpan tlhead" ';break;
case "camera":  BODY_ +='<th class="cameraSpan tlhead" ';break;
case "timing":
default:        BODY_ +='<th class="timingSpan tlhead" ';
 }
BODY_ +=' id="TL'+(r+1)+'"';
BODY_ +=' > ';
    if(r > 0) noteStep = (this.XPS.xpsTracks[r-1].tag)? (noteStep % 5)+1 : 1 ;
if(this.XPS.xpsTracks[r].tag){
    var  trackId = ['p',pageNumber,'c',cols,'t',r].join('');
    BODY_ += '<span id="';
    BODY_ += trackId;
    BODY_ += '" class="noteOverlay'
    BODY_ += ' note'+noteStep;
    BODY_ += '"><span id="'
    BODY_ += trackId;
    BODY_ += '_L" class=overlayLabel>'+this.XPS.xpsTracks[r].tag+'</span></span>'
}
BODY_ +='</th>';
        };
/*********** FrameNote Area *************/
BODY_ +='<th class="framenoteSpan tlhead"';
BODY_ +=' ></th>';
//カラムセパレータの空セル挿入
if (cols < PageCols-1) BODY_ +=('<td class="colSep tlhead" ></td>');
    };

    }
/************************************************/


BODY_ +='</tr>';//改段
    }
//第二行目========================================シート記入分ヘッダ
    
BODY_ +='<tr>';
    for (var cols=0;cols < PageCols;cols ++){
/*********** timeguide ********************/
BODY_ +='<th rowspan=2 class="tclabel annotationText" ';
BODY_ +='style="height:'+headlineHeight+'px" ';
//BODY_ +='style=" width:'+this.sheetLooks.TimeGuideWidth+CellWidthUnit+'"';
BODY_ +=' ><span class=timeguide> TIME </span></th>';
/*********** Action Ref *************/
BODY_ +='<th colspan="'+this.referenceLabels.length+ '" id="rnArea" class="rnArea annotationText ref" ondblclick=sync("referenceLabel") title=""';
//  ここは参照シートの識別名に置き換え 
BODY_ +=' >Reference</th>';
/*********** Dialog Area*************/
BODY_ +='<th rowspan=2 class="dialoglabel annotationText" ';
//ダイアログの幅は可変
if(xUI.dialogSpan>1){
BODY_ +='colspan ="'+xUI.dialogSpan+'" ';
}
/***
BODY_ +=' onMouseDown=\'xUI.changeColumn(0 ,'+ (2 * pageNumber+cols) +');\'';
***/
BODY_ +='>台<BR>詞</th>';
    if(pageNumber>=-1){
/*********** Edit Area 1 (timing) *************/
BODY_ +='<th colspan='+xUI.timingSpan+' id=editArea class="editArea annotationText" ondblclick=sync("editLabel") title=""';
//ここは編集中のステージ名に置き換え予定
BODY_ +='>Animation</th>';

/*********** Edit Area 2 (camera+sfx) *************/
if(xUI.cameraSpan>0){
BODY_ +='<th colspan='+xUI.cameraSpan+' id=camArea class="camArea annotationText" ';
//
BODY_ +='>camera</th>';
}
/*********** FrameNote Area *************/
BODY_ +='<th rowspan=2 class="framenotelabel annotationText"';
/***
BODY_ +=' onMouseDown=\'xUI.changeColumn("memo" ,'+ (2 * pageNumber+cols) +');\'';
***/
BODY_ +=' >MEMO.</th>';
//カラムセパレータの空セル挿入
if (cols < PageCols-1) BODY_ +=('<td rowspan='+(2+SheetRows)+' id=colSep class=colSep ></td>');
    };

    }
BODY_ +='</tr>';//改段

//ヘッダ2行目
BODY_ +='<tr>';//改段

    for (var cols=0;cols < PageCols;cols ++){

//=====================参照エリア
        for (var r=0;r<this.referenceLabels.length;r++){
BODY_ +='<th id="rL';
BODY_ += r.toString();
BODY_ += '_';
BODY_ += pageNumber;
BODY_ += '_';
BODY_ += cols.toString();

BODY_ +='" class="layerlabelR annotationText ref"';
BODY_ +=' >';

var currentRefLabel=this.referenceXPS.xpsTracks[this.referenceLabels[r]].id;
var lbString=(currentRefLabel.length<3)?
    currentRefLabel:
    '<a onclick="return false;" title="'+currentRefLabel+'">'+currentRefLabel.slice(0,2)+'</a>';

 if (currentRefLabel.match(/^\s*$/)){
    BODY_ +='<span style="color:'+this.sheetborderColor+'";>'+nas.Zf(r,2)+'</span>';
 }else{
    BODY_ +=lbString;
 };

        };
    if(pageNumber>=-1){
//=====================編集セル本体(ラベル部分)

        for (var r=(xUI.dialogSpan);r<(this.XPS.xpsTracks.length-1);r++){
    if(this.XPS.xpsTracks[r].option=="comment"){break;}
    var currentLabel=this.XPS.xpsTracks[r].id;
    var currentElementId= 'L' + String(r) + '_' + pageNumber + '_' + String(cols);

BODY_ +='<th id="' + currentElementId ;
 switch (this.XPS.xpsTracks[r].option){
case "still" :BODY_ +='" class="stilllabel annotationText" ' ;break;
case "stagework":
case "geometry":BODY_ +='" class="geometrylabel annotationText" ';break;
case "effect":
case "sfx"   :BODY_ +='" class="sfxlabel annotationText" '   ;break;
case "camerawork":
case "camera":BODY_ +='" class="cameralabel annotationText" ';break;
case "replacement":
case "timing":
case "dialog":
case "sound":
default:BODY_ +='" class="layerlabel annotationText" ';
}

BODY_ +=' >';
if(this.XPS.xpsTracks[r].option=="still"){
 if (currentLabel.match(/^\s*$/)){
    BODY_ +='<span id ="'+currentElementId+'" style="color:'+xUI.sheetborderColor+'";>'+nas.Zf(r,2)+'</span>';
 }else{
    BODY_ +='<span id ="'+currentElementId+'" title="'+currentLabel+'">▼</span>';
 };
}else{
 if (this.XPS.xpsTracks[r].id.match(/^\s*$/)){
    BODY_ +='<span id ="'+currentElementId+'" style="color:'+xUI.sheetborderColor+'";>'+nas.Zf(r,2)+'</span>';
 }else{
    
    BODY_ +=(currentLabel.length<5)?
        currentLabel:
        '<span id ="'+currentElementId+'" title="'+currentLabel+'">'+currentLabel.slice(0,4)+'</span>';
 };
}
BODY_ +='</th>';
        };

    };
    };
BODY_ +='</tr>';

//以下  シートデータ本体  pageNumberが-3以下の場合は固定(冒頭ダイアログ)部分まで出力
if((pageNumber>=0)||(pageNumber<-2)){
/*=========================シートデータエリア==========================*/
//alert("SheetRows : "+ SheetRows +"\nthis.PageCols : "+this.PageCols);
var currentPageNumber=(pageNumber<-2)?0:pageNumber;
for (var n=0;n<SheetRows;n++){
BODY_ += '<tr>';
        for (var cols=0;cols<PageCols;cols ++){
//フレーム毎のプロパティを設定
    var myFrameCount=cols*SheetRows+n;
    var currentSec=(currentPageNumber*SheetLength)+Math.floor(myFrameCount/Math.ceil(this.XPS.framerate));//処理中の秒
    var restFrm= myFrameCount % Math.ceil(this.XPS.framerate);//処理中の  ライン/秒
//    var mySpt=(this.XPS.rate.match(/df/i))?";":":";
    var mySpt=(this.XPS.framerate.opt=='smpte')?";":":";

    var myTC=[Math.floor(currentSec/3600)%24,Math.floor(currentSec/60),currentSec%60].join(":")+mySpt+restFrm
    var current_frame= nas.FCT2Frm(myTC,this.XPS.framerate);//FCTからフレームインデックスを導くドロップ時はnull

//alert([myFrameCount,currentSec,restFrm].join("\n"));break;
// var current_frame=(this.PageLength*currentPageNumber)+cols*SheetRows+n;//カレントフレームの計算がTCベースになる必要あり
//現在処理中のフレームは有効か否かをフラグ  フレームがドロップまたは継続時間外の場合は無効フレーム
    var isBlankLine =((current_frame != null)&&(current_frame < this.XPS.duration()))? false:true;
// alert(isBlankLine+" : "+current_frame)

//セパレータ(境界線)設定
if(restFrm==(Math.ceil(this.XPS.framerate)-1)){
//秒セパレータ
    var tH_border= 'ltSep';
    var dL_border= 'dtSep';
    var sC_border= 'ntSep';
    var mO_border= 'ntSep';
}else{
    if (n%this.sheetSubSeparator==(this.sheetSubSeparator-1)){
//    サブセパレータ
        var tH_border= 'lsSep';
        var dL_border= 'dsSep';
        var sC_border= 'nsSep';
        var mO_border= 'nsSep';
    }else{
//    ノーマル(通常)指定なし
        var tH_border= 'lnSep';
        var dL_border= 'dnSep';
        var sC_border= 'nnSep';
        var mO_border= 'nnSep';
    };
};
//背景色設定
/*    判定基準を継続時間内外のみでなくドロップフレームに拡張
*/
//    if ((current_frame != null)&&(current_frame < this.XPS.duration())){}
    if (! isBlankLine){
//有効フレーム
        var bgStyle='';
        var bgProp='';
        var cellClassExtention=''
    }else{
//無効フレーム
        var bgStyle='background-color:'+this.sheetblankColor+';';
        var bgProp='bgcolor='+this.sheetblankColor+' ';
        var cellClassExtention='_Blank'
    };

//タイムヘッダ
    var tcStyle='<td nowrap ';

BODY_ +=tcStyle ;
BODY_ +='class="Sep ';
BODY_ +=tH_border+cellClassExtention;
BODY_ +='"';
BODY_ +=' id=tcg_';
BODY_ +=String(current_frame);
BODY_ +=' >';
    if (restFrm==0) {BODY_ += "<span class=timeguide>[ "+ currentSec.toString()+"' ]</span>"};
    if  (((n+1)%2 ==0)&&(! isBlankLine))
    {BODY_ += (current_frame+1).toString();}else{BODY_+='<br>';};
//    {BODY_ += ((n+1)+cols*SheetRows).toString();}else{BODY_+='<br>';};
BODY_ +='</td>';

//参照シートセル
    var refLabelID = 0; //for (var refLabelID=0;refLabelID< this.referenceLabels.length;refLabelID++)
    for (var r=0;r< this.referenceXPS.xpsTracks.length;r++){
        if(this.referenceLabels[refLabelID] != r){continue;}

//参照ラベル抽出と同アルゴリズムで抽出を行うかまたはキャッシュをとる
BODY_ +='<td ';
    if (! isBlankLine){}
    if (current_frame<this.referenceXPS.xpsTracks[r].length){
BODY_ += 'id=\"r_';
BODY_ += r.toString()+'_'+ current_frame.toString();
// BODY_ +=refLabelID.toString()+'_'+ current_frame.toString();
BODY_ +='" ';
BODY_ +='class="';
BODY_ +=sC_border+cellClassExtention + ' ref';
BODY_ +='"';
    }else{
BODY_ +='class="';
BODY_ +=sC_border+'_Blank';
BODY_ +='"';
    };
BODY_ +='>';
        if (current_frame>=this.referenceXPS.xpsTracks[r].length){
    BODY_+="<br>";
        }else{
    this.Select=[r,current_frame];
    if (this.referenceXPS.xpsTracks[r][current_frame]!=""){
        BODY_ += this.trTd(['r',r,current_frame]);
//        BODY_ += this.trTd(this.referenceXPS.xpsTracks[r][current_frame]);
//        BODY_ += this.trTd(document.getElementById(["r",[r],[current_frame]].join("_")));
    }else{
        BODY_+='<br>';
    };
        };
BODY_ +='</td>';
        refLabelID ++;
    };
/*
    ダイアログタイムラインとその他のタイムラインの混在を許容することになるので
    位置による決め打ちでなく、タイムライン種別の判定を行う。
    固定ヘッダ出力の場合は、ループ上限を冒頭ダイアログまでに限定
*/
    var outputColumus=(pageNumber<-2)?xUI.dialogSpan-1:this.XPS.xpsTracks.length-2;
for (var r=0;r<=outputColumus;r++){
    if((r==0)||(this.XPS.xpsTracks[r].option.match(/dialog|sound/))){
//ダイアログセル
        BODY_ +='<td ';
//    if ((current_frame != null)&&(current_frame < this.XPS.duration())){}
        if (! isBlankLine){
            BODY_ += 'id="';
            BODY_ +=r.toString()+'_'+ current_frame.toString();
            BODY_ +='" ';
//BODY_ +='onclick="return xUI.Mouse(event)" ';
        };
            BODY_ +='class="';
            BODY_ += dL_border+cellClassExtention;
            BODY_ +=' soundbody';
            BODY_ +='"';
            BODY_ +='>';
//        if((current_frame==null)||(current_frame>=this.XPS.duration()))
        if (isBlankLine){
            BODY_+="<br>";
        }else{
            this.Select=[0,current_frame];


            if (this.XPS.xpsTracks[r][current_frame]!=""){
                BODY_+=this.trTd([r,current_frame]);
//        BODY_+=this.trTd(this.XPS.xpsTracks[r][current_frame]);
            }else{
        BODY_ += '<BR>';
            }
        };
        BODY_ +='</td>';
    }else{
//シートセル
//極力インラインスタイルシートを書かないように心がける 05'2/25
    BODY_ +='<td ';
//    if ((current_frame != null)&&(current_frame < this.XPS.duration())){}
    if (! isBlankLine){
        BODY_ += 'id="';
        BODY_ +=r.toString()+'_'+ current_frame.toString();
        BODY_ +='" ';
//BODY_ +='onclick="xUI.Mouse(event)" ';
    };
    BODY_ +='class="';
    BODY_ +=sC_border+cellClassExtention;
    BODY_ +='"';
    BODY_ +='>';
//        if((current_frame==null)||(current_frame>=this.XPS.duration())){}
    if (isBlankLine){
        BODY_+="<br>";
    }else{
        this.Select=[r,current_frame];
        if ( this.XPS.xpsTracks[r][current_frame]!=""){
            BODY_+=this.trTd([r,current_frame]);
//        BODY_ += this.trTd(this.XPS.xpsTracks[r][current_frame]);
        }else{
            BODY_+='<br>';
        };
    };
    BODY_ +='</td>';

    };
}

/*    メモエリア
 * 固定ヘッダー出力時はスキップ
 *
 */
 if(pageNumber>=0){
BODY_ +='<td ';
//    if (current_frame < this.XPS.duration()){}
    if (! isBlankLine){
BODY_ += 'id="';
BODY_ += (this.XPS.xpsTracks.length-1).toString()+'_'+ current_frame.toString();
BODY_ +='" ';
//BODY_ +='onclick="xUI.Mouse(event)" ';
    };
BODY_ +='class="';
BODY_ +=mO_border+cellClassExtention;
BODY_ +='"';
BODY_ +='>';
//        if(current_frame>=this.XPS.duration()){}
        if (isBlankLine){
    BODY_+="<br>";
        }else{
    this.Select=[this.XPS.xpsTracks.length-1,current_frame];
    if ( this.XPS.xpsTracks[this.XPS.xpsTracks.length-1][current_frame]!=""){
        BODY_ += this.trTd([this.XPS.xpsTracks.length-1,current_frame]);
//        BODY_ += this.trTd(this.XPS.xpsTracks[this.XPS.xpsTracks.length-1][current_frame]);
    }else{
        BODY_+='<br>';
    };
        };
BODY_+='</td>';
 }
        };
BODY_ +='</tr>';

};
    };

BODY_ +='</tbody></table>';
BODY_ +='\n';
/*タイムシート記述終了マーカーを配置*/
if((hasEndMarker)&&(pageNumber==currentPageNumber)){    
BODY_ +='<div id=endMarker class=endMarker>';
BODY_ += JSON.stringify([xUI.XPS.xpsTracks.length, xUI.XPS.xpsTracks.duration]);
BODY_ +='</div>';
//BODY_ +='<div id=endMarker-print class=endMarker-print>::print-end::';
//BODY_ +='<br></div>';
 };// */
BODY_ +='';
    this.Select=restoreValue;
    return BODY_;
};
/**
 エンドマーカー位置調整メソッド  endMarker
    @params {array} endPoint
        end point [track,frame]
    @returns {undefined}
*/
/*    上記で配置したendMarkerの位置を実際の終了フレームの真下に再配置するメソッド
    '#0_'+String(this.XPS.xpsTracks.duration-1);
    '#'+String(this.XPS.xpsTracks.length-1)+'_'+String(this.XPS.xpsTracks.duration-1);
    自動化のため参照エレメントの情報をendMakerのinnerHTML内に埋め込む
    [this.XPS.xpsTracks.length-1,this.XPS.xpsTracks.duration-1]
    以下のメソッドは  単独の関数としても利用可能
 */
xUI.replaceEndMarker = function(endPoint){
    if(! document.getElementById('endMarker')) return;
    if (typeof endPoint == 'undefined'){
   try{
    var endPoint = [xUI.XPS.xpsTracks.length, xUI.XPS.xpsTracks.duration];
   }catch(er){return;}
    }
    if(!(endPoint instanceof Array)) {endPoint=[xUI.XPS.xpsTracks.length,endPoint]};
    var endCellLeft  = $('#'+[0,endPoint[1]-1].join('_'));
    var endCellRight = $('#'+[endPoint[0]-1,endPoint[1]-1].join('_'));
    var parentSheet  = $(document.getElementById('endMarker').parentNode);
    var topMargin  = $(document.getElementById('fixedHeader')).height();//+$(document.getElementById('xmap')).height();
//console.log(topMargin);//$(document.getElementById('fixedHeader')).height()+$(document.getElementById('xmap')).height();
    if(xUI.viewMode=='Compact') topMargin -= document.getElementById("app_status").clientHeight;
    var endCellLeftOffset  = endCellLeft.offset();
    var endCellRightOffset = endCellRight.offset();
    var parentOffset   = parentSheet.position();
    var markerTop    = endCellRightOffset.top + endCellRight.height() - topMargin;
    var markerLeft   = endCellLeftOffset.left - parentOffset.left;
    var markerWidth  = endCellRightOffset.left + endCellRight.width() - endCellLeftOffset.left;
    $("#endMarker").css({'top':markerTop,'left':markerLeft,'width':markerWidth });
    document.getElementById("endMarker").innerHTML = ':: end ::';
}
//
//本体シートの表示を折り畳む（トグル）
xUI.packColumn=function(ID){
var Target=ID;
var PageCols=(this.viewMode=="Compact")?1:this.PageCols;
var PageCount=(this.viewMode=="Compact")?1:Math.ceil(this.XPS.duration()/this.PageLength);
    for (var Page=0 ;Page < PageCount;Page++)
    {
//レイヤラベルのID "L[レイヤID]_[ページID]_[カラムID]"
        for (var cols=0;cols < PageCols;cols ++){
            alert("L"+Target+"_"+Page+"_"+cols+" : "+document.getElementById("L"+Target+"_"+Page+"_"+cols).style.width);
            var isNarrow=(document.getElementById("L"+Target+"_"+Page+"_"+cols).style.width=="4px")?true:false;
            document.getElementById("L"+Target+"_"+Page+"_"+cols).style.width=(isNarrow)? this.sheetLooks.SheetCellWidth:this.sheetLooks.SheetCellNarrow;
            alert(document.getElementById("L"+Target+"_"+Page+"_"+cols).style.width+" : "+isNarrow);

        };
    };
};

//参照シートの表示を折り畳む(トグル)
xUI.packRefColumns=function()
{
var PageCols=(this.viewMode=="Compact")?1:this.PageCols;
var PageCount=(this.viewMode=="Compact")?1:Math.ceil(this.XPS.duration()/this.PageLength);
   for (var Target=1;Target<=this.referenceLabels.length;Target++){
    for (var Page=0 ;Page < PageCount ;Page++){
//レイヤラベルのID "L[レイヤID]_[ページID]_[カラムID]"
        for (var cols=0;cols < PageCols;cols ++){
            alert("rL"+Target+"_"+Page+"_"+cols+" : "+document.getElementById("rL"+Target+"_"+Page+"_"+cols).style.width);

            var isNarrow=(document.getElementById("rL"+Target+"_"+Page+"_"+cols).style.width=="4px")?true:false;
            document.getElementById("rL"+Target+"_"+Page+"_"+cols).style.width=(isNarrow)? this.sheetLooks.SheetCellWidth:this.sheetLooks.SheetCellNarrow;
//            alert(document.getElementById("rL"+Target+"_"+Page+"_"+cols).style.width+" : "+isNarrow);

        };
    };
   }
};
//参照シートの非表示/表示
/*
tableColumnWidth
$('.ref').each(function(index,elem){$(elem).show/hide()});組み合わせ処理が必要
表示状態を他のメソッドから参照する必要あり（重要）
*/
xUI.flipRefColumns=function(action){
        var status=$('#rnArea').isVisible();
    if(action){
        action = (action == 'hide')? false:true;
        if(action ==  status) return;
    }else{
        action = !(status);
    }
    var flipSpan = (this.sheetLooks.ActionWidth*this.referenceLabels.length)*((this.viewMode=="Compact")?1:this.PageCols);
    if(action){
        $('.ref').show();
        $('#qdr4.sheet').width($('#qdr4.sheet').width()+flipSpan);
        if(this.viewMode=="Compact"){
            $('#qdr3.sheet').width($('#qdr3.sheet').width()-flipSpan);
            $('#qdr2.sheet').width($('#qdr2.sheet').width()-flipSpan);
            $('#qdr1.sheet').width($('#qdr1.sheet').width()+flipSpan);
        }
    }else{
        $('.ref').hide();
        $('#qdr4.sheet').width($('#qdr4.sheet').width()-flipSpan);
        if(this.viewMode=="Compact"){
            $('#qdr3.sheet').width($('#qdr3.sheet').width()-flipSpan);
            $('#qdr2.sheet').width($('#qdr2.sheet').width()-flipSpan);
            $('#qdr1.sheet').width($('#qdr1.sheet').width()-flipSpan);
        }
    }
    xUI.replaceEndMarker(xUI.XPS.xpsTracks.duration);
};

/**  UI関連メソッド

ユーザインターフェースコントロール

*/
/*
    スピンアクション
xUI.spin(vAlue)
引数:
設定するスピン量  数値
または
キーワード right/left/up/doun/fwd/back
引数無しで現在のスピン量を返す
戻値:更新あとのスピン量
*/
xUI.spin    =function(vAlue){
    if(typeof vAlue =="undefined"){return this.spinValue;}
    var NxsV  = this.spinValue;    //spin値を取得
    var tRack = this.Select[0];//IDからカラムとラインを取得
    var fRame = this.Select[1];//
    var NxrA  = tRack*1;
    var NxFr  = fRame*1;//暫定的に次のフレームをもとのフレームで初期化

//スピンオプションにしたがって次の位置を計算する
switch (vAlue) {
case 'fwd' :    ;//スピン前方*
    NxFr =((NxFr + NxsV) % this.XPS.duration() );
    if (!this.sLoop) {if (fRame > NxFr) {NxFr = fRame}};
    break ;
case 'back' :    ;//スピン後方*
    NxFr =((NxFr + this.XPS.duration() - NxsV ) % this.XPS.duration() ) ;
    if (!this.sLoop) {if (fRame < NxFr) {NxFr = fRame }};
    break ;
case 'down' :    ;//\[down\]*
    NxFr = (NxFr + 1 )% this.XPS.duration() ;
    if ((!this.cLoop) && (fRame > NxFr)) {NxFr = fRame};
    break ;
case 'up' :    ;//\[up\]*
    NxFr = ((NxFr + this.XPS.duration() -1) % this.XPS.duration() );
    if ((!this.cLoop) && (fRame < NxFr)) {NxFr = fRame * 1};
    break ;
case 'right' :    ;//\[right\]データが未編集の場合のみ左右スピン
    if (! this.edchg)
    {
        NxrA =(NxrA < this.XPS.xpsTracks.length) ?
        (NxrA + 1 ) : (this.XPS.xpsTracks.length) ;
    };
    break ;
case 'left' :    ;//\[left\]編集中の場合は、システムに戻す*
    if (! this.edchg)
    {NxrA = (NxrA>0) ? (NxrA -1) : 0 ;};
    break ;
case 'pgup' :    ;//ページアップ*
    if (NxFr-this.cPageLength >= 0){
    NxFr=NxFr-this.cPageLength};
    break;
case 'pgdn' :    ;//ページダウン*
    if(NxFr+this.cPageLength < this.XPS.duration()){
    NxFr=NxFr+this.cPageLength};
    break;
case 'v_up' :    ;//spin値ひとつあげ
    NxsV++;if(NxsV > this.XPS.framerate) NxsV=1;
//return NxsV;
    break;
case 'v_dn' :    ;//spin値ひとつさげ
    NxsV--;if(NxsV <= 0) NxsV=this.XPS.framerate;
//return this.spinValue;
    break;
case 'v_loop' :    ;
    NxsV++;NxsV=[2,3][NxsV%2];//spin値を2,3 交互切り換え
//    NxsV--;NxsV=[2,3,4][NxsV%3];//spin値を2,3,4 交互切り換え
//return this.spinValue;
    break;

case 'update'    :    ;//セレクションの値からスピンの更新
//    if(this.Selection[0]==0 && this.Selection[1]>=0 &&this.spinSelect)
    if(this.Selection[0]==0 && this.Selection[1]>=0){
        NxsV=(Math.abs(this.Selection[1])+1);
    };
    break;
default :    ;//数値の場合は、spin値の更新 数値以外はNOP
    if (isNaN(vAlue)){return;false}else{NxsV=vAlue*1};
};

//スピン値の変更があった場合は、スピン表示の更新
    if(NxsV != this.spinValue)
    {
        this.spinHi("clear");
        this.spinValue=NxsV;
        document.getElementById("spin_V").value=this.spinValue;
        this.spinHi();
    };
    var newID=NxrA+"_"+NxFr;//新しいフォーカス位置を導く
//位置の更新があった場合のみフォーカスを更新
    if((newID != this.getid("Select")) || this.edchg){
         this.selectCell(newID);
    };
    return this.spinValue;
};
//
/*    ダイアログ（くちぱく）指定タイムライン用のSpin動作
    現在値のinc/decをコマンドで行う
*/

xUI.dialogSpin=function(param)
{
    var doSpin=true;
    var entry=(this.eddt)?this.eddt:this.getCurrent();//

    if (! entry || entry=="blank"){syncInput("");return;};

    switch(param)
    {
    case "incr":    doSpin=false;entry++;break;
    case "decr":    doSpin=false;if(entry>1){entry--;break}else{return;break;};
    case "incrS":    entry++;break;
    case "decrS":    if(entry>1){entry--;break}else{return;break;};
    };

    if(doSpin) 
    {
        this.sheetPut(entry);//更新
        this.spin("fwd");
    }else{
        this.eddt=entry;
        syncInput(entry);
    if(!this.edchg)this.edChg(true);
    };

    return false;
};

/*xUI.getCurrent()
引数:なし
戻値:現在フォーカスのあるシートセルの持つ値

現行の関数は、timingタイムラインのみで意味を持つので、改修が必要2015.09.18

*/
xUI.getCurrent=function(){

    var currentValue=null;
    for(var id=this.Select[1];id>=0;id--)
    {
        currentValue=dataCheck(this.XPS.xpsTracks[xUI.Select[0]][id]);
        if(currentValue && currentValue!="blank") break;
     };
    return currentValue;
};
//
//xUI.getCurrent=getCurrent_ ;
//


/*    ラピッドモードのコマンドを実行    */
xUI.doRapid=function(param){rapidMode.command[param]();};

/*    複写
引数:なし
戻値:なし
現在の操作対象範囲をヤンクバッファに退避
 */
xUI.copy    =function(){
    this.yank();
    if(ClipboardEvent){
        
    }
};

/*    切り取り
引数:なし
戻値:なし
現在の操作対象範囲をヤンクバッファに退避して、範囲内を空データで埋める
選択範囲があれば解除してフォーカスを左上にセット

セクション選択の場合(xUI.emode==2)　ヤンクバッファにはセクションオブジェクトが入る
 */
xUI.cut    =function(){
    this.yank();
//選択範囲を取得して全部空のストリームに作って流し込む。
    var actionRange=this.actionRange();
    var Columns=actionRange[1][0]-actionRange[0][0];//幅
    var Frames=actionRange[1][1]-actionRange[0][1];//継続時間
    var bulk_c='';
    var bulk= '';
    for (var f=0;f<=Frames;f++) {bulk_c+=(f!=Frames)? ","    :"";};
    for (var c=0;c<=Columns;c++) {bulk+=(c!=Columns)? bulk_c+"\n":bulk_c;};
    this.inputFlag="cut";
    this.sheetPut(bulk);
    this.selectCell(actionRange[0]);//
    this.selection();
};

/*    貼り付け
引数:なし
戻値:なし
現在の操作対象範囲左上を基点にヤンクバッファ内容をペースト
操作対象範囲左上をフォーカスして書き換え範囲を選択範囲にする

 */
xUI.paste    =function(){
    var bkPos=this.Select.slice();
    this.inputFlag="paste";
    this.sheetPut(this.yankBuf.body);
    this.selectCell(bkPos);
};
/**    タイムシート上の選択範囲を移動
xUI.move(dest,dup);
    @params {Array}    dest
        移動量ベクトル[deltaColumn,deltaLine]
    @params {Boolean}   dup
        複製フラグ trueで移動先に複製を配置

    @returns    {Boolean}
        移動成功時 true 失敗時は false

カットとペーストに相当する入力を自動で行う


移動先が編集範囲外のデータは消去
移動が発生しなかった場合は移動失敗
移動指定時に、フォーカスが範囲外に出るケースは、失敗とする
このルーチン内で計算値を得てxUI.putメソッドに送る（undoバッファの更新はxUI.putが行う）

移動メソッドのケースは、UNDOデータの構造が以下のように拡張される
[書換基点,(ダミーの選択範囲),書換データ,[復帰用のフォーカス,選択範囲]]
UNDOデータが第４要素を保つ場合のみ、そのデータをもとにカーソル位置の復帰が行われる
*/
xUI.move    =function(dest,dup){
    if(xUI.viewOnly) return xUI.headerFlash('#ff8080');//入力禁止
    if(typeof dest =="undefined")     return false    ;//移動指定なし
    if((dest[0]==0) && (dest[1]==0))  return false    ;//指定は存在するが移動はなし
    if(typeof dup =="undefined")      dup = false     ;//複製指定なし

    var bkPos   = this.Select.slice()    ;//現在のフォーカス位置を控える
    var bkRange = this.Selection.slice() ;//現在のセレクト範囲
    
    var myRange   = this.actionRange()     ;//移動対象範囲
    var destRange = [add(myRange[0],dest),add(myRange[1],dest)];//移動先範囲

    var fkPos     =  add(bkPos,dest)       ;//移動終了後のフォーカス
    if ((fkPos[0]<0)||(fkPos[1]<0)||(fkPos[0]>this.XPS.xpsTracks.length)||(fkPos[1]>this.XPS.xpsTracks[0].length)) return false ;
//いずれもシート外にフォーカスが出るので禁止  これを排除するので変更範囲は処理可能となる
    var sourceValue = xUI.XPS.getRange(myRange);
    var ipts = [];
    if(! dup){
//選択範囲の空ストリームを作成
        ipts.push(new xUI.InputUnit(
            bkPos,
            sourceValue.replace(/[^,\n]/g,''),
            {target:xUI.activeDocument.content}
        ));
    }
    ipts.push(new xUI.InputUnit(fkPos,sourceValue,{target:xUI.activeDocument.content}));
console.log(ipts);
    xUI.inputFlag = "move";
    return xUI.put(ipts);

//変更範囲を算出(この計算では範囲外の値が出るが、フォーカスがシートを外れないのでこのまま)
    var left  =(dest[0]<0)? dest[0]+myRange[0][0]:myRange[0][0];
    var top   =(dest[1]<0)? dest[1]+myRange[0][1]:myRange[0][1];
    var right =(dest[0]>0)? myRange[1][0]+dest[0]:myRange[1][0];
    var bottom=(dest[1]>0)? myRange[1][1]+dest[1]:myRange[1][1];

//移動範囲を取得して配列に
    var moveBlockData = xUI.getRange();
        moveBlockData = moveBlockData.split("\n");
    for( var i=0;i<moveBlockData.length;i++) moveBlockData[i] = moveBlockData[i].split(",");
//変更範囲内のデータをオブジェクトメソッドで取得(範囲外は空要素で戻る)
    var bulk = this.XPS.getRange([[left,top],[right,bottom]]);
        bulk = bulk.split("\n");
    for(var i=0;i<bulk.length;i++) bulk[i] = bulk[i].split(",");
//変更配列の内容を入れ替え
    var leftOffset = (dest[0]>=0)?
        [bulk.length-moveBlockData.length,0]:[0,bulk.length-moveBlockData.length];
    var topOffset =(dest[1]>=0)?
        [bulk[0].length-moveBlockData[0].length,0]:[0,bulk[0].length-moveBlockData[0].length];
    for(var c=left;c<=right;c++){
        var cidx=c-left;
        for(var f=top;f<=bottom;f++){
            var fidx=f-top;
            if(! dup){
                if((fidx>=topOffset[1])&&(fidx<(topOffset[1]+moveBlockData[0].length))){
                    if((cidx>=leftOffset[1])&&(cidx<(leftOffset[1]+moveBlockData.length))){
                        bulk[cidx][fidx]="";
                    }
                }
            }
            if((fidx>=topOffset[0])&&(fidx<(topOffset[0]+moveBlockData[0].length))){
                if((cidx>=leftOffset[0])&&(cidx<(leftOffset[0]+moveBlockData.length))){
                    bulk[cidx][fidx]=moveBlockData[cidx-leftOffset[0]][fidx-topOffset[0]];
                }
            }
        }
    }
//
        for(var ix=0;ix<bulk.length;ix++) bulk[ix] = bulk[ix].join(",");
        bulk = bulk.join("\n");
    fkPos = add(fkPos,[0,1]);
//組み上げたデータをxUI.putメソッドにわたす
    putResult = this.put([
        new xUI.InputUnit(
            [left,top],
            bulk,
            {
                target:xUI.activeDocument.content,
                selection:[fkPos,add(fkPos,dest)]
            }
            )
    ]);
    return putResult;
}

/**
 *    やり直し
 *    @params {Number}  undoOffset
 *        操作を遡るundo回数 undoポインタを超えることはできない  省略時は 1
 */
xUI.undo = function(undoOffset){
    if(this.activeDocument.undoBuffer.undoPt==0) {
//UNDOバッファが空なので失敗
if(dbg) {dbgPut("UNDOバッファが空")};
        return;
    };
    if(typeof undoOffset == 'undefined') undoOffset = 1;
    this.activeDocument.undoBuffer.skipCt=(undoOffset-1);
    while(undoOffset > 0){
if(dbg) {
    dbgPut(
        "undoPt:"+
        this.activeDocument.undoBuffer.undoPt+
        ":\n"+
        this.activeDocument.undoBuffer.undoStack[this.activeDocument.undoBuffer.undoPt].address
    )
};
        this.inputFlag="undo";
        var putResult=this.put();
        if((putResult)&&(dbg)) dbgPut("putResult:\n"+putResult);
        undoOffset --;
  }
};

/*    やり直しのやり直し    
 *    @params {Number}  redoOffset
 *        再操作回数 可能回数を超えることはできない  省略時は 1
 */
xUI.redo    =function(redoOffset){
    if(
        (this.activeDocument.undoBuffer.undoPt+1)>=this.activeDocument.undoBuffer.undoStack.length
    ){
//REDOバッファが空
if(dbg){dbgPut("REDOバッファが空")};
        return;
    };
    if(typeof redoOffset == 'undefined') redoOffset = 1;
    while(redoOffset>0){
if(dbg) {
    dbgPut(
        "undoPt:"+
        this.activeDocument.undoBuffer.undoPt+
        "\n:"+
        this.activeDocument.undoBuffer.undoStack[this.activeDocument.undoBuffer.undoPt].address
    )
};
        this.inputFlag="redo";
        var putResult=this.put();
if((putResult)&&(dbg)) dbgPut("putResult:\n"+putResult);
        redoOffset --;
    }
};

/**    ヤンクバッファに選択範囲の方向と値を格納
 *  xUIのヤンクバッファを利用したコピー・ペースト・ムーブ・デュプリケート等の編集操作は、
 *  Xps.timelineTrackのみが対象となる
 *  それ以外のデータはシステムクリップボードを利用するので注意
 *
 *  引数としてタブ区切りテキストが与えられた場合は、行列置換してヤンクバッファの値を更新する
 *  @params {String}    tabText
 */
xUI.yank=function(tabText){
if(tabText){
    tabText = String(tabText);
    var dataArray = tabText.split('\n');
    var fieldCount = 0;
    for (var r=0;r<dataArray.length;r++){
        dataArray[r]=dataArray[r].split('\t');
        if(dataArray[r].length >= fieldCount) fieldCount=dataArray[r].length;
    }
    var myBody=[];
    for (var f = 0; f < fieldCount;f++){
        var frameData=[];
        for (var r=0;r<dataArray.length;r++){
            frameData.push((dataArray[r][f])?dataArray[r][f]:"");
        }
        myBody.push(frameData.join(','));
    }
    this.yankBuf.direction = [fieldCount-1,dataArray.length-1];
    this.yankBuf.body = myBody.join('\n');
}else{
    this.yankBuf.direction=xUI.Selection.slice();
    this.yankBuf.body=this.getRange();
}
};

/**    xUI.actionRange(limit)
 *  <pre>
 *    現在のUI上の操作範囲の抽出
 *     引数は、制限範囲を絶対量で与える。通常は入力データサイズ
 *    省略可能  省略時は選択範囲と同一
 *    指定時は、UNDOバッファ消費を押さえるために制限範囲と選択範囲の重なる部分を返す
 *    [0,0]が指定された場合は、該当セルのみを返すので開始終了アドレスが同一
 *    戻値は絶対座標で[左上座標、右下座標]の形式
 *</pre>
 *    @params {Array}  limit
 *        制限配列 [columns,frames]
 *
 *    @returns    {Array}
 *        レンジ配列
 *        [[TrackStartAddress,FrameStartAddress],[TrackEndAddress,FrameEndAddress]]
 *
*/
xUI.actionRange    =function(limit){
    if (! limit) limit=this.Selection.slice();
//レイヤ操作範囲
    var TrackStartAddress    =(this.Selection[0]<0)? this.Selection[0] + this.Select[0]:this.Select[0];//左側の座標をとる
    var RangeWidth    =(Math.abs(limit[0])<Math.abs(this.Selection[0]))? Math.abs(limit[0]):Math.abs(this.Selection[0]);
//            引数と比較して小さいほう
    var TrackEndAddress    = TrackStartAddress+RangeWidth;
    if(TrackStartAddress<0) TrackStartAddress=0;//スタートアドレスが負数になったらクリップ（移動処理のため可能性がある）
    if (TrackEndAddress>this.SheetWidth) TrackEndAddress=this.SheetWidth;//トラック数以内にクリップ
//フレーム操作範囲
    var FrameStartAddress    =(this.Selection[1]<0)? this.Select[1] + this.Selection[1]: this.Select[1];
    var RangeHeight    =(Math.abs(limit[1])<Math.abs(this.Selection[1]))? Math.abs(limit[1]):Math.abs(this.Selection[1]);
//            引数と比較して小さいほう
    var FrameEndAddress    = FrameStartAddress+RangeHeight;
    if(FrameStartAddress<0) FrameStartAddress=0;//スタートアドレスに負数ならばクリップ
    if (FrameEndAddress>=this.XPS.duration()) FrameEndAddress=this.XPS.duration()-1;//継続時間内にクリップ
    return [[TrackStartAddress,FrameStartAddress],[TrackEndAddress,FrameEndAddress]];
};

/*
 *    指定範囲内のデータをストリームで返す
 *    指定がない場合は、現在の選択範囲
 *  UNDOデータ拾いだしのために作成されたが編集全般に便利
 *  ストリームで返す
 *
 *  ホットポイントの取得ルーチン
 *
 *  focus  [C,F] : selection  [c,f]
 *
 *  hotPoint    [(c>0)?C:C+c,(f>0)?F:F+f]
 *  dataRange   [Math.abs(c),Math.abs(f)]
 *
 *    @params {Array} Range
 *        指定範囲　Range:[[startColumn,startFrame],[endColumn,endFrame]]
*/
xUI.getRange    =function(Range){
    if (! Range) Range=this.actionRange();//指定がなければ現在の操作範囲を設定
    return this.XPS.getRange(Range);
};
/*    xUI.putReference(dataStream[,direction])
引数
    :dataStream    シートに設定するデータ  単一の文字列  またはXpsオブジェクト または  配列  省略可
    :direction    データ開始位置ベクトル  配列  省略可  省略時は[0,0]
      参照シートに外部から値を流し込むメソッド
        xUI.putReference(データストリーム)
        読み込み時も使用
    xUI.put オブジェクトの機能サブセット
    undo/redo処理を行わない
    xUI.putのラッパ関数
*/
xUI.putReference    =function(datastream,direction){
//    xUI.put(datastream,direction,true);
    xUI.sheetPut(datastream,direction,true);
}
/**
 *  入力ユニットオブジェクト
 *  @params {Array|String}  address
 *  @params {String}        content
 *  @parmas {Object}        props
 *      additional property career　{prop:value...}
 *      追加プロパティはプロパティを載せたオブジェクトを与えて初期化する
 *  eg.       
    new nas.InputUnit(
        [[1,0],[1,11]],
        "X,,,1,,,2,,,3,,",
        {
            target:xUI.documents[0],
            selection:[[1,12],[1,12]]
        }
    )
        target    : {Object:<入力ターゲット>}
        addrress  : {String:<入力開始位置>}
        value     : {String:<入力値ストリーム>}
        backup    : {String:<入力先の書き換え前の値ストリーム>}**
        selection : {Array :[[<入力範囲左上セル座標>],[<入力範囲右下セル座標>]]}*
                  : {:<>}
                  *     タイムライントラック入力時のみ
                  **    UNDOバッファで使用
 */
xUI.InputUnit = function(address,content,props){
    this.address      = address;
    this.value        = content;
    if((props)&&(Object.keys(props).length)){
        for (var prop in props) this[prop]=props[prop];
    }
}

/**
 *  ドキュメントデータの入力を行う UNDO処理つき
 *
 *    <pre>
 *    シートに外部から値を流し込むメソッド
 *      putされたデータはアドレスに従って適切なオブジェクトごとのputメソッド振り分け、
 *      返り値をつかってundo処理と画面の更新をこのメソッドが行う
 *      input引数はinputオブジェクトの配列で複数の入力を一括で処理する
 *      一括処理された入力は一回分のundoユニットとして同じく複数の逆入力操作を記録する
 *
 *    xUI.put(input,toReference])
 *      リファレンス領域のデータ読み込み（流し込み）の際はリファレンスフラグを立てる
 *      現在リファレンスの変更にはundo|redoが適用されない
 *
 *    undo処理は戻り値から書き換えに成功した範囲と書き換え前後のデータが取得できるのでその戻値を利用して処理を行う
 *      入力操作は必ずしも成功するとは限らない
 *      書き換え後の値は入力値と一致する保証はない
 *      入力値、書き換え前の値、書き換え後の値　が混同されないよう注意
 *
 *    このメソッド内では、選択範囲方向の評価を行わないためフォーカス／セレクションは事前・事後に調整を要する場合がある
 *      選択範囲によるクリップはオブジェクトメソッドに渡す前に行う必要あり
 *    
 *    グラフィックレイヤー拡張によりシート上の画像パーツを更新する操作を追加
 *    Xps更新後に、xUI.syncSheetCell()メソッドで必要範囲を更新
 *
 *    グラフィック描画queueを設置してキューに操作を追加してから更新メソッドをコールする形に変更する
 *    更新メソッドはキューを処理して不用な描画をスキップするようにする（未実装20170330）
 *
 *    マクロ展開後には同様に必要範囲内のフットマーク再表示を行う
 *    
 *    参照エリアに対する描画高速化のために、このメソッドでリファレンスの書換をサポートする
 *    引数に変更がなければ従来動作  フラグが立っていればリファレンスを書換
 *    リファレンス操作時はundo/redoは働かない
 *
 *    再描画抑制undoカウンタを設置
 *    カウンタの残値がある限り再描画をスキップしてカウンタを減算する
 *  @params {Arrray of xUI.InputUnit}    input
 *      汎用入出力オブジェクト
 *  @params {Boolean}   toReference
 *      リファレンス入力フラグ リファレンス操作時はundo|redoは働かない
 *    </pre>
 */

xUI.put = function(input,toReference){
    if((xUI.viewOnly)&&(! toReference)) return xUI.headerFlash('#ff8080');//入力規制時の処理
//console.log(arguments);
//undo|redoのための事前処理 リファレンス入力時はUNDO操作対象外
    if(! toReference){
//UNDO準備・操作記録配列初期化
        var output = [];
//xUI.inputFlagを参照して 予備処理
        if((this.inputFlag == 'redo')||(this.inputFlag == 'undo')){
            if(this.inputFlag == 'redo') this.activeDocument.undoBuffer.undoPt++;
//スタック内のundo|redo処理データを取得してinputを上書きする(undo|redoはカラ入力で実行される　入力引数は無視)
            input = this.activeDocument.undoBuffer.undoStack[this.activeDocument.undoBuffer.undoPt].slice();
//undo時は逆順施工のため入力反転
            if(this.inputFlag == 'undo') input.reverse();
        }
    };//undo|redoのための事前処理---------------------------------------------
//カーソル配置をバックアップ
    var selectBackup =[this.Select.concat(),this.Selection.concat()];
//入力を配列に正規化
    if(! input instanceof Array) input = [input];
    if((input.length)&&(! input[0] instanceof xUI.InputUnit)) return false;//入力引数をxUI.InputUnitのみに制限
//---------------------------------------------入力事前処理
    if(xUI.activeDocumentId){
//---------------------------------------------タイムシート入力事前処理
//選択範囲のハイライトを払う
        this.selectionHi("clear");
//編集範囲を記録する一時変数
        if(toReference){
            var TrackStartAddress = xUI.referenceXPS.xpsTracks.length;
            var FrameStartAddress = xUI.referenceXPS.xpsTracks.duration;
        }else{
            var TrackStartAddress = xUI.XPS.xpsTracks.length;
            var FrameStartAddress = xUI.XPS.xpsTracks.duration;
        }
        var TrackEndAddress = 0 ;var FrameEndAddress = 0;
//---------------------------------------------タイムシート入力事前処理
    }else{
//---------------------------------------------XMAP(アセットストア)入力事前処理
        //ここに記述
//---------------------------------------------XMAP(アセットストア)入力事前処理
    };
//---------------------------------------------入力事前処理
console.log(input);
//---------------------------------------------データ入力操作
    var ipt;var putResult;var addressStore = [];
    for(var ix = 0; ix < input.length ; ix ++){
//入力逐次処理
        ipt = input[ix];
//対象オブジェクトを直指定 xMap|Xpst
        if(! ipt.target) ipt.target = xUI.documents[xUI.activeDocumentId].content;
console.log(ipt.target);
        if(ipt.target instanceof xUI.Document) ipt.target = ipt.target.content;
        if((toReference)&&(ipt.target instanceof Xps)) ipt.target = xUI.referenceXPS;//参照設定
//アドレスによる入力対象オブジェクトの振り分けはpm.valuePutが自動で行うので不要
//入力対象がxpsTracksに振り分けられるケースのみ現在の選択状態が影響するのでその事前処理が必要(戻値に処理成功領域が含まれる)
//undo 処理時のみバックアップと入力を入れ替え
        putResult = (xUI.inputFlag == 'undo')?
            ipt.target.put(ipt.address,ipt.backup):ipt.target.put(ipt.address,ipt.value);
        if(putResult){
//リザルトの形式{Array}    [{Array|String:address},{String:書き換え後の値},{String:書き換え前の値},{Array:書き換え範囲}]
            var current = output[output.push(
                new xUI.InputUnit(
                    putResult[0],
                    putResult[1],
                    {
                        target:ipt.target,
                        backup:putResult[2]
                    }
                )
            )-1];
            if(putResult[3]){
//ターゲットがリファレンスを含むXpsタイムラインテーブルであった場合編集範囲を記録して累積する
                current.selection = putResult[3];
                if(TrackStartAddress > putResult[3][0][0]) TrackStartAddress = putResult[3][0][0];
                if(FrameStartAddress > putResult[3][0][1]) FrameStartAddress = putResult[3][0][1];
                if(TrackEndAddress   < putResult[3][1][0]) TrackEndAddress   = putResult[3][1][0];
                if(FrameEndAddress   < putResult[3][1][1]) FrameEndAddress   = putResult[3][1][1];
                if(true){
//タイムライントラックが対象であった場合表示を同期
                    xUI.syncSheetCell(putResult[3]);
//                    xUI.selectCell(nas.add(putResult[0],putResult[3][1]));
                }
            }else{
                if(input.selection) current.selection = input.selection;
            }
//入力成功時にアドレスを保存する
            addressStore.add(ipt.address);
        }else{
//入力操作エラーケース
console.log('error');console.log(ipt);
        }
//条件的に必要なケースでは追加プロパティを乗せる？
//---------------------------------------------データ入力操作
    };//input loop
console.log([xUI.activeDocumentId,putResult]);
//---------------------------------------------フォーカス再配置
    if((xUI.activeDocumentId)&&(putResult[3])){
//Xpst.xpsTracks
        switch (this.inputFlag){
        case "undo" :
        case "move" :
        case "paste":
//入力開始セルに移動
console.log('movehead  : '+putResult[3][0].join('_'))
            this.selectCell(putResult[3][0]);
        break;
        case "redo" :;//副列と単列で切り分け
            if(putResult[3][1][0]==putResult[3][0][0]){
                this.selectCell([TrackEndAddress,FrameEndAddress+1]);//単列(次入力セル)
            }else{
                this.selectCell(putResult[3][0]);//副列(入力開始セル)
            }
        break;
        case "cut":
        case "copy":
        case "normal":
        default:
//標準位置入力最終セル
            this.selectCell([TrackStartAddress,FrameEndAddress]);
        }
    }
//操作別に終了処理
    if(! toReference){
//        if(current.selection) output[output.length-1].selection = [[],[]];
        switch (this.inputFlag){
        case "redo":
        case "undo":
            if(this.inputFlag=="undo") this.activeDocument.undoBuffer.undoPt--;
        break;//undo|redoはスタックの更新を行なわない
//move|pasteの場合のみ最終入力の選択状態を作成する
        case "move":    ;//moveは実質上cut+pasteに相当する
        case "paste":   ;//
                if((putResult.length == 4)&&(! toReference)){
console.log(xUI.Select)
                    xUI.selection(putResult[3][1]);
                }
        case "cut":     ;//通常のデータ入力に準ずる
//一行入力の際のみ処理後のスピン操作で次の入力位置へ移動できるポジションへ
//( = マクロ展開時に画面処理を行う)　putResultは最終入力のリザルトに置き換え
console.log(putResult)
/*                if(putResult.length == 4){
//リザルトの要素数が4になるケースのみで実行(xps)
                    if(xUI.footMark){ this.selection(putResult[3][1]) };
                    this.selection();
                    if (selectBackup[1][1]>0){
                        this.selectCell(([selectBackup[0][0],selectBackup[0][1]+selectBackup[1][1]]).join("_"));
                    }else{
                        this.selectCell(putResult[3][1].join("_"));//操作なしに最終アドレスへ
                    }
                };// */
        case "nomal":   ;//通常のデータ入力
        default:       ;//カット・コピー・ペースト操作の際はカーソル移動無し
            this.activeDocument.undoBuffer.undoPt++;
            this.undoGc=0;
            this.activeDocument.undoBuffer.undoStack[this.activeDocument.undoBuffer.undoPt]=output;
        };
        this.inputFlag="nomal";
// undoバッファの状態を表示
        sync("undo");sync("redo");
//addressStoreを走査して画面を更新
        for(var a = 0;a <addressStore.length; a ++){
            if(addressStore[a] instanceof Array) continue;//assetStore|xpsTracksは処理済み(としておく)
            var address = addressStore[a].split(".").reverse();//アドレス分解/反転
            if(addressStore[a].indexOf("pmu") == 0){
                
            }else{
/*
                "xpsTarcks.noteText":
                "":
                "":
                "":
                "":
                "":
                "":
                "":
                "":
                */
            }
            
        }
//編集バッファをクリア・編集フラグを下げる(バッファ変数をモジュールスコープに変更したので副作用発生)
        if(this.edchg) this.edChg(false);
        if(this.eXMode==1){this.eXMode=0;this.eXCode=0;};//予備モード解除
    };//リファレンス入力時は特に処理なし
// 処理終了のリザルトを返す(デバッグ用)
return putResult;
//処理終了時に記述修飾の同期を行う場合は、リターンの前に処理を行う
//終了処理
}
/*TEST
    xUI._put(new xUI.InputUnit([1,12],"1,2,3,4,5,6",{target:xUI.XPS}));
    xUI.syncSheetCell();

*/
/**    タイムシート入力前段処理
 *    シート選択状態で入力値をクリップ・正規化してxUI.InputUnitの配列へ変換する
 *    調整済みの入力値をxUI.putメソッドへわたす 開始アドレス、選択範囲などの調整はこちらで済ませる 
 *  @params {String|Array|Object Xps|Object xMap}  dataStream
 *     シートに設定するデータ シートデータ文字列 または シートデータ配列 またはXpsオブジェクト 省略可<br />
 *  
 *  @params {Array} direction
 *     データ入力ベクトル  配列  省略可  省略時は[0,0]
 *  @params {boolean} toReference
 *    ターゲットオブジェクト切り替えフラグ
 *  @returns {Array} 入力開始アドレス、終了アドレス
 *      [[TrackStartAddress,FrameStartAddress],lastAddress];
 */
xUI.sheetPut = function(datastream,direction,toReference){
    if(! toReference) toReference = false;
    var targetXps= (toReference)? xUI.referenceXPS:xUI.XPS;
  
//  var selectBackup = [this.Select.concat(),this.Selection.concat()];//カーソル配置をバックアップ>>勘案しない

    if(typeof datastream == "undefined") datastream="";
    if(typeof direction  == "undefined") direction=[0,0];
/*
    datastream の形式

やりとりするデータの基本形式は、コンマ区切り文字列
フレーム方向のストリームで、改行で次のレイヤに移動
制御トークン等は無し  データのみ
    '1,,,2,,\n1,,,,,\n"x",,,,,\n'

Xpsオブジェクトの際は、シートトラック全体を入れ替える
以前のコードでは構造変更や大規模な変更をまとめる際はこの方法を推奨されいてたが
今時のコードではシートトラックのみを差し替えるので注意


全体構造の変更時及びタイムライントラック以外の各プロパティは、新規のputメソッドで指定
xUI.put([new xUI.InputUnit("*",<String:tartgetXpsSource>)]);//全体を更新
xUI.put([new xUI.InputUnit(<String:プロパティ名>,<String:propertySource>)]);//プロパティを更新

2020.06.02  修正

undoスタックに格納する値は {Object xUI.InputUnit}
初期化は
    new xUI.InputUnit(
        <data-address>,
        <data-content>,
        {Object additional-property}
 *    )
 *  eg.       
 *    new nas.InputUnit(
 *        [[1,0],[1,11]],
 *        "X,,,1,,,2,,,3,,",
 *        {
 *            target:xUI.documents[0],
 *            selection:[[1,12],[0,0]]
 *        }
 *    )
 */
/*    入力データを判定    */
    if(datastream instanceof Array){
/*    引数が配列の場合は、Xps のプロパティを編集する（旧形式）
古い形式の場合ここで新形式にコンバートされる
可能な限りこのメソッドを通さずに新形式へ移行のこと（UNDOの回数が減る）

形式:    [kEyword,vAlue]
    キーワード列とプロパティの対応リストは以下を参照
    キーワードは基本的にプロパティ文字列  "parent""stage"等
    タイムラインコレクションの個別プロパティは  "id.1.xpsTracks"等の"."接続した倒置アドレスで指定
//        Xps標準のプロパティ設定
    parent      ;//親Xps参照用プロパティ  初期値はnull（参照無し）編集可
    stage       ;//初期化の際に設定する  編集不可
    mapfile     ;//初期化の際に設定する  編集不可
    opus        ;//編集対象
    title       ;//編集対象
    subtitle    ;//編集対象
    scene       ;//編集対象
    cut         ;//編集対象
    trin        ;//編集対象(ドキュメント構成変更)
    trout       ;//編集対象(ドキュメント構成変更)
    rate        ;//編集対象(ドキュメント構成変更)
    framerate   ;//編集対象(ドキュメント構成変更)
    create_time ;//システムハンドリング  編集不可
    create_user ;//システムハンドリング  編集不可
    update_time ;//システムハンドリング  編集不可
    update_user ;//システムハンドリング  編集不可

    xpsTracks   ;タイムラインコレクション  構成変更のケースと内容変更の両ケースあり
                ;コレクションのエントリ数が変更になる場合は全て構成変更  それ以外は内容編集

xpsTimelineTrackオブジェクトのプロパティ
    noteText    ;//編集対象
    
    id      ;//識別用タイムラインラベル  編集対象
    tag;//トラック補助情報　編集対象
    sizeX   ;//デフォルト幅 point    編集対象（編集価値低）
    sizeY   ;//デフォルト高 point    編集対象（編集価値低）
    aspect  ;//デフォルトのpixelAspect  編集対象（編集価値低）
    lot     ;//map接続データ  編集禁止（編集価値低）
    blmtd   ;//セレクター利用  
    blpos   ;//セレクター利用  
    option  ;//セレクター利用 トラック種別変更時はセクションキャッシュをクリア
    link    ;//セレクター利用  
    parent  ;//セレクター利用  


*/
        var myTarget= datastream[0].split(".");
        var myValue = dataStream[1];
//新形式アドレスへ変換
        this.put([new xUI.InputUnit(
            myTarget.reverse().join('.'),
            myValue,
            {
                target:targetXps
            }
        )],toReference);
    }else if(datastream instanceof Xps){
// Xpsならばシートの入れ替えを行うためデータストリームを取得
//(現在の選択範囲を見るか？-見ない　リセットする)
        datastream = dataStream.getRange();
        this.put([new xUI.InputUnit(
            [0,0],
            datastream,
            {
                target:targetXps
            }
        )],toReference);
    }else{
//データストリームを配列に変換
        var srcData=String(datastream).split("\n");
        for (var n=0;n<srcData.length;n++){
            srcData[n]=srcData[n].split(",");
        }
//配列に変換したソースからデータのサイズと方向を出す。
        var sdWidth    =Math.abs(srcData.length-1);
        var sdHeight   =Math.abs(srcData[0].length-1);
//データ処理範囲調整
        if (this.Selection.join() != "0,0"){
//セレクションあり(操作範囲を取得)
            var actionRange=this.actionRange([sdWidth,sdHeight]);
//カレントセレクションの左上端から現在の配列にデータを流し込む。
            var TrackStartAddress=actionRange[0][0];//    左端
            var FrameStartAddress=actionRange[0][1];//    上端
//セレクションとソースのデータ幅の小さいほうをとる
            var TrackEndAddress=actionRange[1][0];//    右端
            var FrameEndAddress=actionRange[1][1];//    下端
        } else {
//セレクション無し(開放操作)
            var TrackStartAddress= this.Select[0];//    左端
            var FrameStartAddress= this.Select[1];//    上端
//シート第2象限とソースデータの幅 の小さいほうをとる
            var TrackEndAddress=((xUI.SheetWidth-this.Select[0])<sdWidth)?
            (this.SheetWidth-1):(TrackStartAddress+sdWidth)    ;//    右端
            var FrameEndAddress=((targetXps.duration()-this.Select[1])<sdHeight)?
            (targetXps.duration()-1):(FrameStartAddress+sdHeight)    ;//    下端
        };
//バックアップは遅延処理・入力クリップをここで行う
        var Tracklimit=TrackEndAddress-TrackStartAddress+1;
        var Framelimit=FrameEndAddress-FrameStartAddress+1;
        if(srcData.length>Tracklimit){srcData.length=Tracklimit};
        if(srcData[0].length>Framelimit){for (var ix=0;ix<srcData.length;ix++){srcData[ix].length=Framelimit}};

//入力値をオブジェクトメソッドで設定
        return this.put([new xUI.InputUnit(
            [TrackStartAddress,FrameStartAddress],
            srcData.join("\n"),
            {
                target:targetXps,
                selection:[
                    [TrackStartAddress,FrameStartAddress],
                    [TrackEndAddress,FrameEndAddress]
                ]
            }
        )],toReference);
    }
};//sheetPut */

/*xUI.syncSheetCell(startAddress,endAddress,isReference)
    指定されたレンジのシートセルの内容を更新
    指定がない場合は、シート全て
    アドレス一致の場合は、一コマのみ
*/
xUI.syncSheetCell=function(startAddress,endAddress,isReference){
    if(this.activeDocument.type != 'xpst') return;//NOP
    if(this.activeDocument.undoBuffer.skipCt > 0) {this.activeDocument.undoBuffer.skipCt --;return;};//?
    var targetXps=(isReference)? this.referenceXPS:this.XPS;
    if((! startAddress)||(! endAddress)){
        startAddress=[0,0];
        endAddress  =[targetXps.xpsTracks.length-1,targetXps.xpsTracks.duration-1];
    }
    var TrackStartAddress =startAddress[0];
    var TrackEndAddress   =  endAddress[0];
    var FrameStartAddress =startAddress[1];
    var FrameEndAddress   =  endAddress[1];
//設定値に従って、表示を更新（別メソッドにしたい）
    for (var r=TrackStartAddress;r<=TrackEndAddress;r++){
        for (var f=FrameStartAddress;f<=FrameEndAddress;f++){
if((r>=0)&&(r<targetXps.xpsTracks.length)&&(f>=0)&&(f<targetXps.xpsTracks.duration)){

//シートデータを判別してGraphicシンボル置き換えを判定（単純置き換え）
//        配置データが未設定ならば<br>に置き換え
            var sheetCell=(isReference)? document.getElementById(["r",r,f].join("_")):document.getElementById([r,f].join("_"));
            if(sheetCell instanceof HTMLTableCellElement){
                if(document.getElementById(sheetCell.id)){xUI.Cgl.remove(sheetCell.id);}
                this.drawSheetCell(sheetCell);//関数内でシートセルを書き換える（同期処理）
//                var td=(targetXps.xpsTracks[r][f]=='')? "<br>" : this.trTd(targetXps.xpsTracks[r][f]) ;
//        シートテーブルは必要があれば書き換え
//                if (sheetCell.innerHTML!= td){ if(dbg) console.log(sheetCell.innerHTML);sheetCell.innerHTML=td;}
            }
//本体シート処理の際のみフットスタンプ更新
  var targetElement=document.getElementById(r+"_"+f);
  if((targetElement)&&(! isReference)){
//変更されたデータならフットスタンプ処理
    if (this.diff[r,f]){
            lastAddress=[r,f] ;        //最終入力操作アドレス控え
            var footstamp =(this.footMark)? 
            this.footstampColor:this.sheetbaseColor;//踏むぞー
            this.Select=([r,f]);
        //各ブラウザで試験して判定文字列を変更(未処置)
            if (targetElement.style.backgroundColor!=footstamp)
            targetElement.style.backgroundColor=footstamp; //セレクト位置を踏む！
    }else{
    //否変更なので、背景色がフットスタンプならフットスタンプを消す。
        //各ブラウザで試験して判定文字列を変更(未処置)
        if (targetElement.style.backgroundColor!=this.sheetbaseColor && this.footMark)
        targetElement.style.backgroundColor=this.sheetbaseColor; //踏み消す
    };
  }
}
        };
    };
    setTimeout(function(){xUI.Cgl.refresh([startAddress,endAddress],isReference)},0);//非同期処理
}
//syncSheetCell シートセルの表示を編集内容に同期させる  
/**
    リファレンス領域と編集領域のデータが異なっているか否かを返す関数
    標準で[トラックid,フレーム]を配列で、又は ID文字列"trc_frm"
    それ以外はXPSのプロパティ名
    (id)とみなす オブジェクト渡しは禁止
    指定IDの比較データが存在しない場合は、常にfalseを返す
*/
xUI.diff=function(target){
    if(String(target).match(/^\d+_\d+$/)){target = target.split('_');}
    if(target instanceof Array){
         if (
            (typeof this.XPS.xpsTracks[target[0]]                       == 'undefined')||
            (typeof this.referenceXPS.xpsTracks[target[0]]              == 'undefined')||
            (typeof this.XPS.xpsTracks[target[0]][target[1]]            == 'undefined')||
            (typeof this.referenceXPS.xpsTracks[target[0]][target[1]]   == 'undefined')
        ) return false;
        return (this.XPS.xpsTracks[target[0]][target[1]] != this.referenceXPS.xpsTracks[target[0]][target[1]]);
    }else{
        return (this.XPS[target] != this.referenceXPS[target]);
    }
}
/**
 *  シートセル入力バックアップ
 *      キー入力等で編集前のセル内容のバッファを送受するメソッド
 *  @params {Array} Datas
 *       セルの内容データ　省略時は現在の値を戻す。
 *  @returns {String} バックアップ内容　または　受領フラグ
 *
 */
xUI.bkup    =function(Datas){
    if ((! Datas)||(Datas.length==0)){
        return this.cellBackup[0];
    }else{
        this.cellBackup=Datas;return true;
    };
};
/*
UI関数群
    これも、xUIのメソッドに

*/
/*=====================================*/

/**
 *   メッセージをアプリケーションステータスに出力する。
 *   引数なしでクリア
 *  @params {String}    msg
 *      メッセージ本体
 *  @params {String}    prompt
 *      プロンプトサイン
 */
xUI.printStatus    =function(msg,prompt){
    if(! msg){msg="<br />"};
    if(! prompt){prompt=""};
    var bodyText=(prompt+msg);
//    document.getElementById("app_status").innerHTML=bodyText.replace(/\n/g,"<br>");
    $("#app_status").text(bodyText);
}
/**    キーダウンでキー入力をサバく

IEがプレスだとカーソルが拾えないようなのでキーダウン
iNputbOx以外の入力もこのメソッドで受ける
フォーカスがiNputbOx以外にある場合は、トラップする特定キー以外はNOPで戻す
*/
xUI.keyDown = function(e){
//stopwatch処理
//ストップウオッチ処理中は有効キー検知で入力キャンセル
if((xUI.player)&&(xUI.player.keyboard)){
	if(e.keyCode == 32) {
//[Space]　計測停止中は計測開始　計測中は　ストップ|マーク|ラップ
		if(xUI.player.status != 'run'){
				xUI.player.start();
		} else {
			if(xUI.player.markSwap){
				xUI.player.getCount=true;
			}else{
				xUI.player.stop();
			}
		}
		return false;
	} else if(e.keyCode == 13){
//[Enert] 計測中は　停止|マーク|ラップ　停止中はリセット
		if(xUI.player.status!='stop'){
			if(xUI.player.runMode > 0){
				if(xUI.player.markSwap){
					xUI.player.stop()
				}else{
					xUI.player.getCount=true
				}
			}else{
				xUI.player.lap();
			}
			return false;
		}else{
			if(xUI.player.runMode > 0){
				if(xUI.player.countStack.length){xUI.player.clearMark();return false;}
			}else{
				xUI.player.reset(); return false;
			}
		}
	} else if (e.keyCode == 77) {
//[M]
	    if(xUI.player.status=='run'){
	        xUI.player.getCount=true;
	    }else{
	        xUI.player.start('mark');
	    }
	    return false;
	}else if((e.keyCode == 35)||(e.keyCode == 36)){
//[End]|[Home]
		if(xUI.player.status=='run') return false;
	}
}
//ブラウザ全体のキーダウンを検出
	var key = e.keyCode;//キーコードを取得
//入力中以外のショートカット処理
	switch(key) {
case	66 :		;	//[ctrl]+[B]/ パネルセット切り替え
	if ((e.ctrlKey)||(e.metaKey))	{
		this.setToolView();
		return false;}else{return true}
	break;
case	68 :		;	//[ctrl]+[D]/　スクロール・ページ表示モード切り替え
	if ((e.ctrlKey)||(e.metaKey))	{
		xUI.viewMode=(xUI.viewMode=="Compact")?"WordProp":"Compact";xUI.resetSheet();
		return false;}else{return true}
	break;
case	79 :		;	//[ctrl]+[O]/ Open Document
	if ((e.ctrlKey)||(e.metaKey)) {
		 if(e.shiftKey){
		    this.openDocument("localFile");
		}else{
		    this.openDocument();
		}
		return false;
	}
	return true;
	break;
case	83 :    ;	//[ctrl]+[S]/ Save or Store document
	if ((e.ctrlKey)||(e.metaKey)) {
		 if(e.shiftKey){
		    this.storeDocument("as");
		}else{
		    this.storeDocument();
		}
		return false;
	}
		return true;
	break;
    }
//フォーカスエレメントがiNputbOx以外なら入力を戻す
    if(document.activeElement!==document.getElementById("iNputbOx")){
        if(((key==79)||(key==83))&&((e.ctrlKey)||(e.metaKey))){
        console.log("capt")
            return false;
        }else{
            return true;
        }
    }
	this.eddt = document.getElementById("iNputbOx").value;
	var interpKey=110;
//      console.log(key+':down:');
	switch(key) {
case	25	:if(! Safari) break;
case	9	:	//tab
if (! this.tabSpin) {
	if(!this.edchg) return;
	this.sheetPut(this.eddt);
	return false;break;
}
case	13	:		//Enter 標準/次スピン・シフト/前スピン・コントロール/interpSpin
	if(xUI.edmode>=2){
// 区間編集中
	    if(e.shiftKey){
	      if((e.ctrlKey)||(e.metaKey)){
	        if(xUI.edmode==3) this.sectionUpdate();
	        this.mdChg('normal');                           //[ctrl]+[shift]+[ENTER]:モード解除
	      }else{
	        this.mdChg('float');	                        //[shift]+[ENTER]:float遷移
	      }
	    }else if((e.ctrlKey)||(e.metaKey)){
            if(xUI.edmode==3) this.sectionUpdate();                           //[ctrl]+[ENTER]:確定のみ
	    }else{
	        if(xUI.edmode==3) this.sectionUpdate();
	        this.mdChg((xUI.edmode==3)?'section':'normal'); //[ENTER]:確定してモード遷移
	    }
	    return false;//スピン動作キャンセルのためここでリターン
    } else {
	    if((e.shiftKey)&&((e.ctrlKey)||(e.metaKey))){
	        xUI.mdChg('section');	               //[ctrl]+[shift]+[ENTER]:カーソル位置でモード遷移
	        return false;//スピン動作キャンセルのためここでリターン
	    }
/*   
     if(e.shiftKey){
	    }else{
	        interpSign();                           //[shift]+[ENTER]:中間値サイン
	    }
	}
*/	
	  if (this.edchg){
		this.sheetPut(nas_expdList(this.eddt));//更新
		this.selectCell(add(this.Select,[0,1]));//入力あり
	  }else{
	    if(e.shiftKey){
		if(expd_repFlag){
			this.spin("up");expd_repFlag=false;     //<マクロ展開中>[shift]+[ENTER]:スピンアップ
		}else{
			this.spin("back");                      //[shift]+[ENTER]:スピンバック
		}
	    }else{
		  if(expd_repFlag){
		    this.spin("down");expd_repFlag=false;   //<マクロ展開中>[ENTER]:スピンダウン
		  }else{
            if((xUI.Selection[0]==0)&&(xUI.Selection[1]>0)){
                this.selectCell([xUI.Select[0],xUI.Select[1]+xUI.Selection[1]+1]);
                //選択範囲有りのカラ[ENTER] 自動的にカラ移動
            }else{
			    this.spin("fwd");                       //[ENTER]:スピンフォワード
			}
		  }
	    };
//処理終了時にコントロール（メタ）キーの同時押しがない場合は選択範囲を解除
	    if((! e.ctrlKey)&&(! e.metaKey)){
		if(this.getid("Selection")!="0_0")
			{this.selection();this.spinHi();};//選択範囲解除
	    }
	  }
	}
	return false;
	break;
case	27	:	//esc 選択範囲解除
//ラピッドモード解除
	if(xUI.eXMode){
		return rapidMode.command.exit();
	}
//		編集中
	if (this.edchg){return false;}//バックアップ復帰のためスキップ(実処理はUP)
//      区間操作中
    if(this.edmode == 3 ){
//        this.selection(add(this.Select,this.selection));
        this.selectCell(this.floatSourceAddress);
        this.mdChg('section');
       break;
    } else if(this.edmode == 2 ){
	    if((e.ctrlKey)||(e.metaKey)){
            this.undo(this.floatUpdateCount);//まとめて開始点までUNDO
            this.mdChg('normal');
            this.selectCell();//編集を解除してバックアップ状態へ復帰
            this.selection(add(this.selectBackup,this.selectionBackup));
        }else{
            this.mdChg('normal');
            this.selection();
        }
        break;
    }
//		複数セレクト状態 
	if(this.getid("Selection")!="0_0")
		{this.selection();this.spinHi();break;};//選択範囲解除
		return false;break;//標準処理(NOP)

//case 32	:		//space 値を確定してフォーカスアウト
//	this.edchg=false;
//	this.focusCell();	break;
case	38	:		//カーソル上・下
case	40	:		//
/*
    通常編集時
        [shift]+[↑]/[↓] セレクションの調整
        [ctrl]+[shift]+[↑]/[↓]  セレクションの調整にスピン量の調整も兼ねる
    区間編集時
        [↑]/[↓] 全体移動に遷移
        [ctrl] +[↑]/[↓] 先頭移動に遷移
        [shift]+[↑]/[↓] 末尾移動に遷移
        [ctrl]+[shift]+[↑]/[↓]  現在の編集を確定して選択している区間を前後の区間に変更？
    区間フロート時
        [↑]/[↓] モードに従って移動
 */
		    var kOffset=(key==38)? -1:1;
//    if ( this.edmode == 3){		    this.sectionPreview(this.Select[1]+kOffset);}else
    if ( this.edmode == 3){
 	   if (	e.shiftKey &&
		    this.Select[1]+this.Selection[1]>=0 &&
		    this.Select[1]+this.Selection[1]<(this.XPS.duration()-1)
	    ){
	        this.sectionManipulateOffset=['tail',0];
//		    this.sectionPreview((this.Select[1]+this.Selection[1]+kOffset));
//		    if((e.ctrlKey)||(e.metaKey)) ;
		}else if(((e.ctrlKey)||(e.metaKey)) &&
		    this.Select[1]+this.Selection[1]>=0 &&
		    this.Select[1]+this.Selection[1]<(this.XPS.duration()-1)
		){
	        this.sectionManipulateOffset=['head',0];
	    }else{
		//通常移動処理
	        this.sectionManipulateOffset=['body',0];
	    };        
		    this.sectionPreview(this.Select[1]+kOffset);
    }else if(this.edmode == 2){
 	   if (	e.shiftKey &&
		    this.Select[1]+this.Selection[1]>=0 &&
		    this.Select[1]+this.Selection[1]<(this.XPS.duration()-1)
	    ){
	        this.sectionManipulateOffset=['tail',0];
		}else if(((e.ctrlKey)||(e.metaKey)) &&
		    this.Select[1]+this.Selection[1]>=0 &&
		    this.Select[1]+this.Selection[1]<(this.XPS.duration()-1)
		){
	        this.sectionManipulateOffset=['head',0];
	    }else{
		//通常移動処理
	    };
	    this.mdChg('float');         
    }else{
 	   if (	e.shiftKey &&
		    this.Select[1]+this.Selection[1]>=0 &&
		    this.Select[1]+this.Selection[1]<(this.XPS.duration()-1)
	    ){
		    var kOffset=(key==38)? -1:1;
		    this.selection(this.Select[0]+"_"+
		    (this.Select[1]+this.Selection[1]+kOffset));
		    if((e.ctrlKey)||(e.metaKey)||(this.spinSelect)) this.spin("update");
	    }else{
		//通常入力処理
	    if((! e.ctrlKey)&&(! e.metaKey)){
		    if(this.getid("Selection")!="0_0"){this.selection();this.spinHi();};//選択範囲解除
	    }
		    if (this.edchg){this.sheetPut(this.eddt);}//更新
		    if(key==38){this.spin("up")}else{this.spin("down")};
	    };
	};
	return false;	break;
case	39	:		//右[→]
case	37	:		//左[←]
	if ((this.edmode < 2)&&((! this.edchg)||(this.viewOnly))) {
	    if(key==37) {this.spin("left")} else {this.spin("right")};
	    return false;
	}else{
	    return true;
	};	break;
case 	33:		//ページアップ
	if (this.edchg){this.sheetPut(this.eddt);}//更新
	this.spin("pgup");return false;	break;
case 	34:		//ページダウン
	if (this.edchg){this.sheetPut(this.eddt);}//更新
	this.spin("pgdn");return false;	break;
case	35 :;//[END]
	this.selectCell(this.Select[0]+"_"+this.XPS.duration());
	break;
case	36 :;//[HOME]
	this.selectCell(this.Select[0]+"_0");
	break;
case	65 :		;	//[ctrl]+[A]/selectAll
 	if ((e.ctrlKey)||(e.metaKey))	{
		this.selectCell(this.Select[0]+"_0");
		this.selection(
			this.Select[0]+"_"+this.XPS.duration()
		);
		return false;}else{return true}
	break;
case	67 :		;	//[ctrl]+[C]/copy
	if ((e.ctrlKey)||(e.metaKey))	{
		this.yank();
		return true;}else{return true}
	break;
case	69 :		;	//[ctrl]+[E]/export AE Key
	if ((e.ctrlKey)||(e.metaKey))	{
		console.log('writeAEKey');
        writeAEKey();
		return true;}else{return true}
	break;
case	73 :		;	//[ctrl]+[I]/information 
	if ((e.ctrlKey)||(e.metaKey))	{
	    myScenePref.open("edit");
		return false;}else{return true}
	break;
case	86 :		;	//[ctrl]+[V]/paste
	if ((e.ctrlKey)||(e.metaKey))	{
//		this.paste();
		return true;
		return false;}else{return true}
	break;
case	88 :		;	//[ctrl]+[X]/cut
	if ((e.ctrlKey)||(e.metaKey))	{
		this.cut();
		return true;}else{return true}
	break;
case	89 :		;	//[ctrl]+[Y]/redo
	if ((e.ctrlKey)||(e.metaKey))	{
		this.redo();
		return false;}else{return true}
	break;
case	90 :		;	//[ctrl]+[Z]/undo
	if ((e.ctrlKey)||(e.metaKey))	{
		if(e.shiftKey){
		    this.redo();
		}else{
		    this.undo();
		}
		return false;}else{return true}
	break;
//case	61 :		;
//case	107 :		;
//case	221 :		;	//[+]/plus
//	alert("PLUS :"+key);
//return dialogSpin("incr");
//return true;
//	break;
//case	108 :		;
//case	109 :		;
case	interpKey :		;//[.]/dot-Tenkey これは問題あるキーの交換が出来ない
	if(! this.edchg) {
		interpSign();return false;
	}else{
		return true;
	}
break;
//case	219 :		;	//[-]/minus
//	alert("MINUS :"+key);
//return dialogSpin("decr");
//return true;
//	break;
/* 保留
case 8	:	this.spin("bs");	break;	//bs NOP
case 46	:	this.spin("del");	break;	//del 
case  :	window.status="[]";	break;	//
*/
default :	return true;
	}
//return false;
}
/*
if(false){    if(this.Mouse.action){return false};//マウス動作優先中
//フォーカスされたテーブル上の入力ボックスのキーダウンを検出
//window.status = e.keyCode+'/'+String.fromCharCode(e.keyCode)
//    alert(e.KeyCode)
    var key = e.keyCode;//キーコードを取得
    this.eddt = document.getElementById("iNputbOx").value;
alert(this.eddt);
//    var eddt = document.getElementById("iNputbOx").value;
    switch(key) {
case    25    :if(! Safari) break;
case    9    :    ;//tab
if(! this.tabSpin){
    if(!this.edchg) return;
    this.sheetPut(this.eddt);
    return false;break;
};
case    13    :    ;//Enter 標準/次スピン・シフト/前スピン
alert("xUI.keyDown=ENTER");
    if (this.edchg){this.sheetPut(this.eddt);}//更新
    if(e.shiftKey) {this.spin("back")}else{this.spin("fwd")};
//    if(! e.ctrlKey){}
    if(! e.metaKey){
        if (this.Selection.join() != "0,0"){this.selection();this.spinHi();};//選択範囲解除
    };
    return false;
    break;
case    27    :    ;//esc
    if (this.edchg){this.sheetPut(this.eddt);}//更新
    if (this.Selection.join() != "0,0"){this.selection();this.spinHi();break;};
        //選択範囲解除
    break;
case    32    :    ;//space 値を確定してフォーカスアウト
    if (this.edchg){this.sheetPut(this.eddt);}//更新
//    this.focusCell();
    break;
case    38    :    ;//カーソル上・下
case    40    :    ;//シフト時はセレクション(+スピン)の調整
     if (    e.shiftKey &&
        this.Select[1]+this.Selection[1]>=0 &&
        this.Select[1]+this.Selection[1]<(this.XPS.duration()-1)
    )
    {    var kOffset=(key==38)? -1:1;
        this.selection(this.Select[0]+"_"+
        (this.Select[1]+this.Selection[1]+kOffset));
        this.spin("update");
    }else if(    e.ctrlKey){
        //選択範囲を維持したまま移動
    }else{
//        this.selection();this.spinHi();
if (this.Selection.join() != "0,0"){this.selection();this.spinHi();alert(123)};
    //あれば選択範囲クリアして
        if (this.edchg){this.sheetPut(this.eddt);}//更新
        if(key==38){this.spin("up")}else{this.spin("down")};
    }    ;return false;    break;
case    39    :        ;//右
    if (this.edchg){this.sheetPut(this.eddt);}//更新
    if (! this.edchg) {this.spin("right")    ;return false;
    }else{
    return true;
    };    break;
case    37    :        ;//左?
    if (this.edchg){this.sheetPut(this.eddt);}//更新
     if (! this.edchg) {this.spin("left")    ;return false;
    }else{
    return true;
    };    break;
case    33:        ;//ページアップ
    if (this.edchg){this.sheetPut(this.eddt);}//更新
    this.spin("pgup");    break;
case    34:    ;//ページダウン
    if (this.edchg){this.sheetPut(this.eddt);}//更新
    this.spin("pgdn");    break;
case    35 :;//[END]
    xUI.selectCell(xUI.Select[0]+"_"+this.XPS.duration());
//    xUI.selectCell(xUI.Select[0]+"_"+this.XPS.duration(),"end");
    break;
case    36 :;//[HOME]
//    xUI.selectCell(xUI.Select[0]+"_0","home");
    xUI.selectCell(xUI.Select[0]+"_0");
    break;
case    65 :        ;    //[ctrl]+[A]/selectAll
     if (e.ctrlKey)    {
    if (this.edchg){this.sheetPut(this.eddt);}//更新
        this.selectCell(this.Select[0]+"_0");//selall
        this.selection(this.Select[0]+"_"+this.XPS.duration());
        return false;}else{return true};
    break;
//case    :;//    break;
case    67 :        ;    //[ctrl]+[C]/copy
    if (e.ctrlKey)    {
    if (this.edchg){this.sheetPut(this.eddt);}//更新
        this.yank();
        return false;}else{return true};
    break;
case    79 :        ;    //[ctrl]+[O]/ Open Document
    if ((e.ctrlKey)&&(! e.shiftKey))    {
        this.openDocument();
        return false;}else{return true}
    break;
case    83 :    alert("SSS");    //[ctrl]+[S]/ Save or Store document
    if (e.ctrlKey) {
         if(e.shiftKey){this.storeDocument("as");}else{this.storeDocument();}
        return false;
    }else{
        return true
    }
    break;
case    86 :        ;    //[ctrl]+[V]/paste
    if (e.ctrlKey)    {
    if (this.edchg){this.sheetPut(this.eddt);}//更新
        this.paste();
        return false;}else{return true};
    break;
case    88 :        ;    //[ctrl]+[X]/cut
    if (e.ctrlKey)    {
    if (this.edchg){this.sheetPut(this.eddt);}//更新
        this.cut();
        return false;}else{return true};
    break;
case    89 :        ;    //[ctrl]+[Y]/redo
    if (e.ctrlKey)    {
    if (this.edchg){this.sheetPut(this.eddt);}//更新
        this.redo();
        return false;}else{return true};
    break;
case    90 :        ;    //[ctrl]+[Z]/undo
    if (e.ctrlKey)    {
    if (this.edchg){this.sheetPut(this.eddt);}//更新
        this.undo();
        return false;}else{return true};
    break;
*/
/* 保留
case     :        ;    //[ctrl]+[]/
case    8    :    this.spin("bs");    break;    //bs NOP
case    46    :    this.spin("del");    break;    //del 
case  :    window.status="[]";    break;    //
*/
/*
default :    return true;
    };
return false;
//return true;
};
*/
/**
//	フォーカスされたテーブル上の入力ボックスのキープレスを検出して
//	動作コントロールのために戻り値を調整

	    フロートモード判定
	フロート（ブロック移動/セクション編集）モードでは、キー動作の入力が制限される。
	最初にモード内動作を判定して処理
	モードを抜けるまでは他の機能に移行できない
	モードイン判定はノーマル入力モードアウト判定はこのルーチン内
-------------------------------------------------ブロック移動：
[↑][↓][→][←][h][j][k][l][8][2][4][6]	移動
[enter][5]			確定>モードアウト
[esc][0]			モードアウト
-------------------------------------------------セクション編集：
[↑]/[↓]             区間移動
[ctrl] +[↑]/[↓]     前端点移動
[shift]+[↑]/[↓]     後端点移動
[enter][5]          確定>モードアウト
[esc][0]            モードアウト

*/
xUI.keyPress = function(e){
	var key = e.keyCode;//キーコードを取得
//      console.log(key+':press:');
	if(xUI.edmode>0){
if(xUI.edmode==1){
//ブロック移動モード
}else{
//セクション編集モード
}
	  return true;
	}
/*
	ラピッドモード!=0 分岐処理
	ラピッドキーモードでは、マウスの入力は受け入れない
	0:解除
	1:スタンバイ（導入キーが一度押しされた状態）
	2:ラピッドモード
	
 */
if((key < 48)||(key > 57)){
  if(xUI.eXMode){
//ラピッドモード前駆状態フラグONなのでラピッドモード判定
	if(xUI.eXMode==1 && document.getElementById("iNputbOx").value.length==1){
//	入力が前キーと同一ならばモードアクティブ
		if(xUI.eXCode==key && document.getElementById("iNputbOx").value.charCodeAt(0)==key){
			xUI.eXMode++;//モード遷移
			var eddt="";
			xUI.eddt="";
			xUI.selectedColor=xUI.inputModeColor.EXTEND;
			xUI.spinAreaColor=xUI.inputModeColor.EXTENDspin;
			xUI.spinAreaColorSelect=xUI.inputModeColor.EXTENDselection;
			xUI.spinHi();
		}else{
			xUI.eXMode=0;xUI.eXCode=0;return true;//遷移失敗 このセッションでは入れない
		};
	}
//モード変更直後でも1回はラピッド動作する
	if(xUI.eXMode>=2){
		if(xUI.eXMode==2){
//	モード遷移直後なので、現在の入力コントロールとバッファをクリアしてモードを確定する
			xUI.eXMode++;
			if(xUI.eddt==xUI.bkup())xUI.edChg(false);
			syncInput(xUI.bkup());
		};
	for (var idx=0;idx<(rapidMode.length-1)/2;idx++){if(key==rapidMode[idx*2].charCodeAt(0))break;};
		if(idx<(rapidMode.length-1)/2){
			xUI.doRapid([rapidMode[idx*2+1]]);
			return false;
		}else{
			if (key!=13 && key!=8 && key!=9){
		//モード解除
				if(xUI.eXMode){
		return xUI.rapidMode.command.exit();
				}
			}
		}
	}
}else{
//		通常状態なので予備モード遷移判定
	for (var idx=0;idx<(rapidMode.length-1)/2;idx++)
	{
//		if(key==rapidMode[idx*2].charCodeAt(0) && document.getElementById("iNputbOx").value.length==0)
		if(key==rapidMode[idx*2].charCodeAt(0) && xUI.edChg)
		{
//dbgPut("exMode-ready: "+ key);
			xUI.eXMode=1;xUI.eXCode=key;return true;//予備モードに入る
		}
	}
  }
}
//		通常判定
	switch(key) {
case	27	: 			;//esc
	return false;
case	25	:if(! Safari) break;
case	0	:if(Firefox){return true;};//キーコード0を返すコントロールキー群
//  fierfox  が keypress で全てキーコード0:を返す状態になっている  2017.12
case	9	:			;//またはTAB および ctr-I
//	return false;

if (! xUI.tabSpin) {
	if(!xUI.edchg) return true;
	return false;break;
}else{
	if (xUI.edchg)
	{return true} else {return false};break;
}
case	13	:			;//Enter
		return false;break;
case	65	:			;//a
case	67	:			;//c
//case	79	:			;//o
//case	83	:			;//s
case	86	:			;//v
case	88	:			;//x
case	89	:			;//y
case	90	:			;//z
case	97	:			;//A
case	99	:			;//C
case	118	:			;//V
case	120	:			;//X
case	121	:			;//Y
case	122	:			;//Z
	if ((e.ctrlKey)||(e.metaKey))	{return false;}else{return true;};
		break;
//case		: ;	//
default :;
	return true;
	}
//return true;
}
//
//xUI.keyPress    =keyPress_ ;
/**
    キーアップをキャプチャ。UI制御に必要 今のところは使ってない?
*/
xUI.keyUp = function (e){
	if(xUI.player.keyboard){
		if(xUI.player.markSwap){
			if((e.keyCode == 32)&&(xUI.player.status=='run')) xUI.player.getCount=false;
		}else{
			if((e.keyCode == 13)&&(xUI.player.status=='run')) xUI.player.getCount=false;
		}
        if (e.keyCode == 77) {
	    if(xUI.player.status=='run') xUI.player.getCount=false;
	    }
	}
	var key = e.keyCode;//キーコードを取得
//フォーカスエレメントがiNputbOx以外なら入力を戻す
    if(document.activeElement!==document.getElementById("iNputbOx")){
        if(((key==79)||(key==83))&&((e.ctrlKey)||(e.metaKey))){
        console.log("capt")
            return false;
        }else{
            return true;
        }
    }
    if((this.eXMode>=2)&&((key < 48)||(key > 57))){
		document.getElementById("iNputbOx").select();
		return false;
	}
	if(false){
//		通常状態なので予備モード遷移判定
	for (var idx=0;idx<(rapidMode.length-1)/2;idx++)
	{
		
		if(key==rapidMode[idx*2].charCodeAt(0) && document.getElementById("iNputbOx").value.length==1)
		{
			this.eXMode=1;this.eXCode=key;break;//予備モードに入る
		}
	}
}
;
//	通常処理 入力コントロールとバックアップが食い違っているので編集中フラグON
	if(this.bkup()!=document.getElementById("iNputbOx").value){
if(dbg)document.getElementById("app_status").innerHTML=this.bkup()+" <> "+document.getElementById("iNputbOx").value;
	if(! this.edchg) this.edChg(true);//変更されていたらフラグ立て
	};
	switch(key) {
case  27:	;	//esc

	if(this.edchg){this.edChg(false);}
//		document.getElementById("iNputbOx").value=this.bkup();
		syncInput(this.bkup());
		return false;
break;
case  9	:	;	//tab はシステムで使うのでUPは注意
case  13:	;	//Enter
case  32:	;	//space
case  38:	;	//上カーソル
case  40:	;	//下
case  39:	;	//右
case  37:	;	//左
case  33:	;	//ページアップ
case  34:	;	//ページダウン
case  16:	;	//シフト
case  17:	;	//コントロール
case  18:	;	//ALT
case  45:	;	//ins
case  46:	;	//del
case  144:	;	//clear(NumLock)
//case  :	;	//
	if(this.viewOnly) return false;
	if(!this.edchg) document.getElementById("iNputbOx").select();
//	if(!this.edchg) document.getElementById("iNputbOx").focus();
//	syncInput(document.getElementById("iNputbOx").value);
	return true;
//case  :	window.status="[]";	break;	//
case	65	:	;//[a]
case	67	:	;//[c]
//case	79	:	;//[o]
//case	83	:	;//[s]
case	86	:	;//[v]
case	88	:	;//[x]
case	89	:	;//[y]
case	90	:	;//[z]
	if ((e.ctrlKey)||(e.metaKey))	{
		return true;
	}
		break;
//case 110:;//.テンキー
//case 190:;//.>
//	if(!this.edchg) document.getElementById("iNputbOx").select();

//break;
//case 99 :	;	//[C]copy	このあたりは横取り
//case 118 :	;	//[V]paste
//case 120 :	;	//[X]cut	しないほうが良い?
case 8	:	;	//bs NOP
default :
//if(! this.edchg) this.edChg(true);
if(this.Select[0]>0){syncInput(document.getElementById("iNputbOx").value);};
	return true;
	}
return true;
}
//
//xUI.keyUp    =    keyUp_    ;
//
/**
 * コンテキストメニュー表示切り替え
 *  @params {Object Event}  e
 */
xUI.flipContextMenu=function(e){
    if((xUI.contextMenu.isVisible())&&(e.type == 'mousedown')){
console.log(e.srcElement);
        if(e.srcElement.onclick){
//クリックされたコマンドを実行
//console.log(e.srcElement.onclick);
            e.srcElement.onclick();
        }
//メニューを隠す
        xUI.contextMenu.hide();
        return false;
    }else if((e.button == 2 )&&(e.type == 'mousedown')){
//初期位置設定
        xUI.contextMenu.css('top',e.clientY-xUI.screenShift[1]);
        xUI.contextMenu.css('left',e.clientX-xUI.screenShift[0]);
        var onHeadline=false;
        var onTrackLabel=false;
        var onTimelineTrack=false;
        var onReference=false;
        var onTimeguide=false;
        var onReferenceHeader=false;
        var onTimelineTrackHeader=false;
        var outer = true;
    if(e.clientY<=document.getElementById('fixedHeader').clientHeight){
        onHeadline=true;outer = false;
    }else{
        if(e.srcElement.id.match(/^\d+_\d+$/)){
            onTimelineTrack = true;outer = false;
        }else if(e.srcElement.id.match(/^r_\d+_\d+$/)){
            onReference  = true;outer = false;
        }else if(e.srcElement.id.match(/^tc.+$/)){
            onTimeguide  = true;outer = false;
        }else if(e.srcElement.className.match(/^.+ref$/)){
            onReferenceHeader  = true;outer = false;
        }else if(e.srcElement.className.match(/^camArea|editArea|^framenotelabel|^dialoglabel/)){
            onTimelineTrackHeader  = true;outer = false;
        }else if(e.srcElement.id.match(/^L\d+_\-?\d+_\d+$/)){
            onTrackLabel  = true;outer = false;
        }
    }
    if(onHeadline){
        $('ul.cMonHeadline').each(function(){$(this).show();});
        if($('#pMenu').isVisible()){
            $('.noDm').each(function(){$(this).hide();});
        }else{
            $('.noDm').each(function(){$(this).show();});
        }
/*        if($('#pmui').isVisible()){
            $('.noPm').each(function(){$(this).hide();});
        }else{
            $('.noPm').each(function(){$(this).show();});
        };// */
    }else{
        $('ul.cMonHeadline').each(function(){$(this).hide();});    
    }
    if(onTrackLabel){
        $('.cMonTrackLabel').each(function(){$(this).show();});
    }else{
        $('.cMonTrackLabel').each(function(){$(this).hide();});    
    }
    if(onTimelineTrack){
console.log('onTrack')
        $('.cMonTrack').each(function(){$(this).show();});
        switch(xUI.XPS.xpsTracks[xUI.Select[0]].option){
        case 'dialog':
            $('.onDialog').each(function(){$(this).show();});
            $('.onTiming').each(function(){$(this).hide();});
            $('.onCamera').each(function(){$(this).hide();});
        break;
        case 'timing':
            $('.onDialog').each(function(){$(this).hide();});
            $('.onTiming').each(function(){$(this).show();});
            $('.onCamera').each(function(){$(this).hide();});
        break;
        case 'camera':
            $('.onDialog').each(function(){$(this).hide();});
            $('.onTiming').each(function(){$(this).hide();});
            $('.onCamera').each(function(){$(this).show();});
        break;
        default:
        }
    }else{
        $('.cMonTrack').each(function(){$(this).hide();});    
    }
    if(onTimelineTrackHeader){
        $('.cMonTrackHeader').each(function(){$(this).show();});
    }else{
        $('.cMonTrackHeader').each(function(){$(this).hide();});    
    }
    if(onReference){
        $('.cMonReference').each(function(){$(this).show();});
    }else{
        $('.cMonReference').each(function(){$(this).hide();});    
    }
    if(onReferenceHeader){
        $('.cMonReferenceHeader').each(function(){$(this).show();});
    }else{
        $('.cMonReferenceHeader').each(function(){$(this).hide();});    
    }
    if(outer){
        $('.cMouter').each(function(){$(this).show();});
    }else{
        $('.cMouter').each(function(){$(this).hide();});
    }
/*    
    if(xUI.edmode==0){
        $('.emode0').each(function(){$(this).show();});
    }else{
        $('.emode0').each(function(){$(this).hide();});
    }
    if(xUI.uiMode=='management'){
        $('.pmad').each(function(){$(this).show();});
    }else{
        $('.pmad').each(function(){$(this).hide();});
    }
*/

/*
xUI.contextMenu.html([
('#'+e.srcElement.id+':'+e.srcElement.className)+'<hr>',
'onHeadline           :'+onHeadline,
'onTimelineTrack      :'+onTimelineTrack,
'onReference         :'+onReference,
'onTimeguide          :'+onTimeguide,
'onReferenceHeader     :'+onReferenceHeader,
'onTimelineTrackHeader:'+onTimelineTrackHeader,
'Select     :'+xUI.Select,
'Selection  :'+xUI.Selection,
'edmode     :'+xUI.edmode,
'viewOnly   :'+xUI.viewOnly,
'viewMode   :'+xUI.viewMode
].join('<br>\n'));
*/
        xUI.contextMenu.show();
//表示前に確定したサイズから画面外に隠れるケースで位置を調整
//上下
        if((window.innerHeight - (xUI.contextMenu.position().top+xUI.contextMenu.height())) < 0){
            xUI.contextMenu.css('top',e.clientY-xUI.screenShift[1]-xUI.contextMenu.height())
        }
//左右 タイムシートセルとそれ以外で切り分け
        if(e.srcElement instanceof HTMLTableCellElement){
            if((window.innerWidth - (xUI.contextMenu.position().left+xUI.contextMenu.width())) < 0){
                xUI.contextMenu.css('left',e.clientX-xUI.screenShift[0]-xUI.contextMenu.width()-e.srcElement.clientWidth);
            }
        }else{
            if((window.innerWidth - (xUI.contextMenu.position().left+xUI.contextMenu.width())) < 0){
                xUI.contextMenu.css('left',e.clientX-xUI.screenShift[0]-xUI.contextMenu.width()-32);
            }
        }
console.log(e);
        return false;
    }
    return true;
}
/*  cUI.onTouch

*/
xUI.Touch = function(e){
    console.log(e);
    return true;
}

/*    xUI.Mouse(e)
引数:    e    マウスイベント
戻値:        UI制御用
    マウス動作
マウス処理を集中的にコントロールするファンクション

関連プロパティ
    xUI.edmode
0 : 通常編集
1 : ブロック編集
2 : セクション編集
3 : セクション編集フローティング
モード変更はxUI.mdChg関数を介してい行う

モード別テーブルセル編集操作一覧



 */
xUI.Mouse=function(e){
//    console.log(e.target.id);
//    if(e.target.id=='dialogEdit'){return false};
    if((this.edmode==3)&&(e.target.id=='sheet_body')&&(e.type=='mouseout')){
        xUI.sectionUpdate();
        this.mdChg(2);
        this.Mouse.action=false;
        return false;
    };
// if(dbg) dbgPut(e.target.id+":"+e.type.toString());
//document.getElementById("iNputbOx").focus();

if(this.edchg){ this.eddt= document.getElementById("iNputbOx").value };
//IEのとき event.button event.srcElement
//    if(MSIE){TargeT = event.srcElement ;Bt = event.button ;}else{};

        var TargeT=e.target;var Bt=e.which;//ターゲットオブジェクト取得
// dbgPut(TargeT.id);
//IDの無いエレメントは処理スキップ
    if(! TargeT.id){
        xUI.Mouse.action = false;
//         if (this.edmode==3){this.Mouse()}
        return false;
    }
//カラム移動処理の前にヘッダ処理を追加 2010/08
    if(TargeT.id.match(/^L([0-9]+)_(-?[0-9]+)_([0-9]+)$/)) {
        var tln=1*RegExp.$1;var pgn=1*RegExp.$2;var cbn=1*RegExp.$3;//timeline(column)ID/pageID/columnBlockID
switch(e.type){
case    "dblclick":
        reNameLabel((tln).toString());
break;
case    "mousedown":
    if(this.edmode==0)xUI.changeColumn(tln,2*pgn+cbn);
break;
}
    xUI.Mouse.action = false;
    return ;
    }
//-------------------ヘッダ処理解決

//    if(TargeT.id.split("_").length>2){return false};//判定を変更
//ページヘッダ処理終了
//=============================================モード別処理
if(this.edmode==3){
/*
    セクション編集フローティング

    フローティング移動中

*/

    var hottrack=TargeT.id.split('_')[0];
    var hotpoint=TargeT.id.split('_')[1];
switch (e.type){
case    "dblclick"    :
case    "mousedown"    :    
	document.getElementById("iNputbOx").focus();
break;
case    "click"    :
case    "mouseup"    ://終了位置で解決
//[ctrl][shift]同時押しでオプション動作
    xUI.sectionUpdate();
    this.mdChg(2);
    this.Mouse.action=false;

//    this.floatTextHi();
break;
case    "mouseover"    :
    if((hottrack!=xUI.Select[0])||(! xUI.Mouse.action)) {
        if(TargeT.id && TargeT.id.match(/r?L\d/)){
            xUI.sectionUpdate();
            this.mdChg(2);
            this.Mouse.action=false;
        }
        return false
    };
if(! this.Mouse.action){
    return false;

    if(this.Mouse.action){
        if (TargeT.id && xUI.Mouse.rID!=TargeT.id ){
            this.selection(TargeT.id);
            if(((e.ctrlKey)||(e.metaKey))||(this.spinSelect)) this.spin("update");
            return false;
        }else{
            return true;
        };
    };
}else{
        this.sectionPreview(hotpoint);
}
    break;
default    :    return true;
};
    return false;

}else if(this.edmode==2){
	document.getElementById("iNputbOx").focus();
    var hottrack=TargeT.id.split('_')[0];
    var hotpoint=TargeT.id.split('_')[1];
/*
    モード遷移は他の状態からコール
    セクション編集モード
    トラック内限定で区間編集を行う。
    モード変更コマンドの発行はemode==0の際のみ有効
    モード変更のトリガは、ダブルクリック
基本操作
３種のターゲットがある
        body
セクション全体がトラック内を前後に移動する
フローティングムーブに準ずる処理  ホットポイントオフセットが存在する
        head
        tail
トラック内でセクションが伸縮
他のノードを固定してヘッドまたはテールノードが移動することでセクションを伸縮する  

edmode==3  中は、マウスオーバーでセクション body||head||tail 移動
リリースで移動（＝編集）を解決  1回毎に更新回数を記録
ダブルクリックまたは対象トラック外をクリックで解決してモード解除
エスケープまたは対象トラック外右クリックで変更を廃棄して編集前に戻す

キーボード操作(1フレームづつ移動なので要注意)
    モード遷移・確定 [ctrl]+[shift]+[ENTER]
    ボディ移動       [↑]/[↓]
    ヘッド移動       [ctrl]+[↑]/[↓]
    テール移動       [shift]+[↑]/[↓]
                     [shift]+[ctrl]+[↑]/[↓]
     編集破棄＋モード解除
                     [esc]
                     
    セクション操作オフセットをxUIのプロパティで設定する
    値が０なら前方伸長  値が末尾なら後方伸長それ以外は移動
    継続時間が1の場合は末尾として扱う
    解決順が  末尾＞先頭＞以外になれば操作種別を１種にできる
    すべてsectionMove(start,duration)に集約できそう
    
*/
switch (e.type){
case    "dblclick"    :
//セクション操作モードを抜けて確定処理を行う
//確定処理はmdChg メソッド内で実行
              this.mdChg("normal");
break;            
case    "mousedown"    :
    //サブモードを設定
    if((
        Math.abs(hotpoint -(xUI.Select[1]+(xUI.Selection[1]/2))) >
        Math.abs(xUI.Selection[1]/2)
        )&&(hottrack == xUI.Select[0])
    ){
//レンジ外
        if (e.shiftKey){
//近接端で移動
            xUI.sectionManipulateOffset[1] = (hotpoint<xUI.Select[1])? 0:this.Selection[1];
            xUI.sectionManipulateOffset[0] = 'body';
        }else if((e.ctrlKey)||(e.metaKey)){
//近接端で延伸
            xUI.sectionManipulateOffset[1] = (hotpoint<xUI.Select[1])? 0:this.Selection[1];
            xUI.sectionManipulateOffset[0] = (hotpoint<xUI.Select[1])? 'head':'tail'; 
        }else{
            return xUI.mdChg(0);//モード解除
        }
        this.sectionPreview(hotpoint);
        this.sectionUpdate();
    }else{
//フロートモードへ遷移
        xUI.sectionManipulateOffset[1] = hotpoint-this.Select[1];
        xUI.sectionManipulateOffset[0] = 'body';
        if(xUI.sectionManipulateOffset[1]==xUI.Selection[1]){
            xUI.sectionManipulateOffset[0] = 'tail';
        } else if(xUI.sectionManipulateOffset[1]==0){
            xUI.sectionManipulateOffset[0] = 'head';
        }
    }
    xUI.mdChg(3);    
    xUI.Mouse.action=true;
//    console.log([xUI.edmode,hotpoint,xUI.sectionManipulateOffset,xUI.Mouse.action]);
break;
case    "click"    :;//クリックしたセルで解決  (any):body/+[ctrl]:head/+[shift]:tail 
    if(hottrack!=xUI.Select[0]) {
        //対象トラック外なら確定して解除
        this.mdChg("normal");        
    }
break;

case    "mouseup"    ://終了位置で解決
//[ctrl]同時押しで複製処理
    //  this.mdChg(0,(e.ctrlKey));
    this.Mouse.action=false;
    this.floatTextHi();
break;
case    "mouseover"    :
    
//トラックが異なる場合 NOP return
//    var sectionRegex=new RegExp('^'+String(xUI.Select[0])+'_([0-9]+)$');
//    if((!(TargeT.id.match(sectionRegex)))||(! xUI.Mouse.action)){return false};//ターゲットトラック以外を排除
    if((hottrack!=xUI.Select[0])||(! xUI.Mouse.action)) {return false};
if(! this.Mouse.action){
    return false;

    if(this.Mouse.action){
        if (TargeT.id && xUI.Mouse.rID!=TargeT.id ){
            this.selection(TargeT.id);
            if(((e.ctrlKey)||(e.metaKey))||(this.spinSelect)) this.spin("update");
            return false;
        }else{
            return true;
        };
    };
}else{
            this.sectionPreview(hotpoint);
}
    break;
default    :    return true;
};
    return false;

}else if(this.edmode==1){
//return false;
//ブロックムーブ（フローティングモード）
/*
    基本動作:
マウスオーバーでセクションを移動
リリースで移動を解決してモード解除
ダブルクリック・クリック等は基本的に発生しないので無視
*/
switch (e.type){
case    "dblclick"    :
//              this.mdChg("section");
//              this.floatTextHi();//導入処理
//            this.selectCell(TargeT.id);
//    this.floatDestAddress=this.Select.slice();
            
case    "mousedown"    :
case    "click"    :
case    "mouseup"    ://終了位置で解決
//    console.log("<<<<<<")
//[ctrl]同時押しで複製処理
      this.mdChg(0,((e.ctrlKey)||(e.metaKey)));
      this.floatTextHi();
break;
case    "mouseover"    ://可能な限り現在位置で変数を更新
    if(!(TargeT.id.match(/^([0-9]+)_([0-9]+)$/))){return false};//シートセル以外を排除
//オフセットを参照して  .Select .Selection を操作する
/*
    
*/
if(false){
    if(this.Mouse.action){
        if (TargeT.id && xUI.Mouse.rID!=TargeT.id ){
            this.selection(TargeT.id);
            if(((e.ctrlKey)||(e.metaKey))||(this.spinSelect)) this.spin("update");
            return false;
        }else{
            return true;
        };
    };
}else{
            this.selectCell(TargeT.id);
    this.floatDestAddress=this.Select.slice();
}
    break;
default    :    return true;
};
    return false;
}
//=============================================カラム移動処理
    if(!(TargeT.id.match(/^([0-9]+)_([0-9]+)$/))){return false};//シートセル以外を排除

switch (e.type){
case    "dblclick"    :
            //ダブルクリック時はモード保留して（解除か？）タイムラインセクション編集モードに入る
            this.mdChg("section",TargeT.id);
            this.Mouse.action=false;
            return false;
break;
case    "mousedown"    :
//document.getElementById("iNputbOx").value=("mouseDown")
    if (this.edchg){this.sheetPut(this.eddt);}//更新

    this.Mouse.rID=this.getid("Select");//
    this.Mouse.sID=TargeT.id;
    this.Mouse.action=true;

//    if(TargeT.id==this.getid("Select"))
//    {    }else{    };

        if(this.Selection[0]!=0||this.Selection[1]!=0){
//選択範囲が存在した場合
//if(dbg) dbgPut(this.edmode+":"+this.getid("Select")+"=="+TargeT.id);
//        var CurrentSelect=TargeT.id.split("_");
/*
        var CurrentAction=this.actionRange();
        if(
        (CurrentAction[0][0]<=CurrentSelect[0] && CurrentAction[1][0]>=CurrentSelect[0])&&
        (CurrentAction[0][1]<=CurrentSelect[1] && CurrentAction[1][1]>=CurrentSelect[1])
        ){}
*/
        if(TargeT.id==this.getid("Select")){
              //フォーカスセルにマウスダウンしてブロック移動へモード遷移
            //クリック時とダブルクリック時の判定をしてスキップしたほうが良い
//            if(TargeT.id!=this.floatDestAddress.join("_")){}
            this.mdChg('block');
            this.floatTextHi();
            this.selectCell(TargeT.id);
            this.floatDestAddress=this.Select.slice();

            this.Mouse.action=false;
            return false;
          }else{
        if(e.shiftKey){
            this.selection(TargeT.id);
            if(((e.ctrlKey)||(e.metaKey))||(this.spinSelect)) this.spin("update");
            return false;//マルチセレクト
        }else{
            this.selection();//セレクション解除
            this.Mouse.action=false;
            this.selectCell(TargeT.id);//セレクト移動
        }
            return false;
          }
        }else{
//選択範囲が存在しない場合
            this.selection();//セレクション解除
        };

        if(e.shiftKey){
            this.selection(TargeT.id);
            if(((e.ctrlKey)||(e.metaKey))||(this.spinSelect)) this.spin("update");
            return false;//マルチセレクト
        }else{
            if ((! e.ctrlKey)&&(! e.metaKey)){this.selection()};//コントロールなければ選択範囲の解除

            //this.Mouse.action=false;
            this.selectCell(TargeT.id);
        };
    break;
case    "mouseup"    :
//document.getElementById("iNputbOx").value=("mouseUp")
        this.Mouse.action=false;
    if( this.Mouse.sID!=TargeT.id){
        if(e.shiftKey){
            this.selection(TargeT.id);
            if(((e.ctrlKey)||(e.metaKey))||(this.spinSelect)) this.spin("update");
            return false;//マルチセレクト
        }else{
            return false;//セレクトしたまま移動
        };
    };
    break;
case    "click"    :

    break;
case    "mouseover"    :
    if(this.Mouse.action){
        if (TargeT.id && xUI.Mouse.rID!=TargeT.id ){
            this.selection(TargeT.id);
            if(((e.ctrlKey)||(e.metaKey))||(this.spinSelect)) this.spin("update");
            return false;
        }else{
            return true;
        };
    };
default    :    return true;
};
    return false;
};
//
//    xUI.Mouse.action    =false    ;//マウスアクション保留フラグ
//    xUI.Mouse.rID=false    ;//マウスカーソルID
/** ドキュメントを開く
    引数'localFile'の場合は、サーバリポジトリでなくローカルファイルインポートを優先する。
    fileBox.openFileDBが関数として存在する場合は、  AIR準拠環境でローカルファイルの操作が可能なので実行
    それ以外は、インポート手順に従ってローカルファイルチューザーを提示
    失敗時はNOP
    引数なしのケースでは、リポジトリの操作を行う。（リポジトリドキュメントチューザーを提示）
    ドキュメント編集中はリポジトリの操作がブロックされるので、強制的にローカルインポートモードに遷移
    
*/
xUI.openDocument=function(mode){
    if(xUI.uiMode=='production') {mode='localFile';}
    document.getElementById('loadShortcut').value='true';
    document.getElementById('loadTarget').value  ='body';
    if(mode=='localFile'){
        if(fileBox.openFileDB){
            fileBox.openFileDB();
        }else{
//        this.sWitchPanel("Data");//インポート・エクスポートパネルを呼び出す必要はなくなったので削除
//            if(document.getElementById('optionPanelData').style.display!='inline'){xUI.sWitchPanel('Data')};
            document.getElementById('myCurrentFile').value = '';
            document.getElementById('myCurrentFile').click();
        }
    }else{
        xUI.sWitchPanel("File");   
    }
}
/**
りまぴん-WEB-用　ローカルファイルインポートコマンド
loadTarget 変数の設定とファイルセレクタのクリアを同時に行い
クリックイベントを送出する
*/
xUI.importDocument =function(targetArea){
    if(! targetArea) targetArea = '';
    document.getElementById('loadTarget').value = targetArea;
    if(fileBox.openFileDB){
        fileBox.openFileDB();
    }else{
        document.getElementById('myCurrentFile').value = '';//これをカラにしないとchangeイベントが発火しないケースがある。
        document.getElementById('myCurrentFile').click();
    }
}

/** ドキュメントを保存
 *
 *    現在のドキュメントをしかるべきロケーションに上書き保存する。
 *    保存ロケーションの判定はxUI.uiModeによって判別
 *    case "floating":  //ローカルファイルを扱える唯一のモード
 *         AIRローカルファイル:fileBox.saveFile/fileBox.saveAs
 *         その他:serviceAgent.addEntry/callEcho;
 *    case "production": // ネットワークドキュメント編集中
 *     ネットワークリポジトリドキュメント:serviceAgent.putEntry(xUI.XPS,function(){xUI.setStored("current");sync();})/
 *     
 *    default:
 *
 *    trueに判定される引数が与えられた場合、可能な限りローカルファイルシステムヘの別名保存を行う。
 *    AIR環境の場合は、fileBox.saveAs()  それ以外の場合はエコーサーバ経由のダウンロード
*/
xUI.storeDocument=function(mode){
//        this.sWitchPanel("Data");//インポート・エクスポートパネルを呼び出す必要はなくなったので削除
    if(xUI.XMAP.dataNode){
            if((mode)||(xUI.uiMode!='production')){
                callEcho();//ダウンロード保存
            }else{
    	        if(! (this.setStored())){

	                serviceAgent.putEntry(
	                    xUI.XPS,
	                    function(){xUI.setStored("current");sync();}

                    );
                };//現行ドキュメントの上書き、最終保存から変更なければ処理スキップ
            }
    }else{
            if(fileBox.saveFile){
                if(mode){
                    fileBox.saveAs();
                }else{
                    fileBox.saveFile();//setStoredeの判定はsaveFileメソッド内で行うのでここでは不要
                }
            }else{
                if(mode){
                    callEcho();//ダウンロード保存
                }else{
                    serviceAgent.addEntry(xUI.XPS,function(){
                        var myIdentifier = Xps.getIdentifier(xUI.XPS,'job');
                        console.log(myIdentifier);
                        serviceAgent.currentRepository.getSCi(function(){
                            serviceAgent.currentRepository.getEntry(myIdentifier,false,function(){alert(myIdentifier)});
                            
                        },false,myIdentifier);
                    },function(){
                    alert("データ登録失敗");
                    });
                }
            }
    }
}

/*xUI.scrollTo(ID)
    特定のIDのセルが画面内に収まるようにスクロールする
    ずれ込みの象限によって移動位置は変わる
    IDを持ったエレメントならば汎用的に使用可能
    CSX環境でscrollTo()メソッドの際にスクロールイベントが発生しないケースあり
*/
xUI.scrollTo=function(ID){
//要素が存在しない場合はNOP
    if(document.getElementById(ID) == null){return};
//ドキュメント系の座標に変換するメソッド要る？

    var elementOffset=$("#"+ID).offset();
//ドキュメントオフセット（スクロール）
    var currentOffset={};
      currentOffset.left=$(document).scrollLeft();
      currentOffset.top=$(document).scrollTop();

//表示ウインドウを算出（Window系座標値)この基準位置はCompactモードの基準値なので注意
if(this.viewMode=="Compact"){
    var clipBounds={};
      clipBounds.left=($("#qdr2").offset().left+$("#qdr2").width())-currentOffset.left;
      clipBounds.top=$("#qdr2").offset().top+$("#qdr2").height()-currentOffset.top;
      clipBounds.right=$(window).width();
      clipBounds.bottom=$(window).height();
}else{
    var clipBounds={};
      clipBounds.left=120;
      clipBounds.top=$("#fixedHeader").height()+$("#app_status").height();
      clipBounds.right=$(window).width();
      clipBounds.bottom=$(window).height();
}
//フレーム高さ
    var frameHeight=$("#0_0").height();
if(this.viewMode=="Compact"){
//境界オフセット変数
    var borderOffset={};
//左マージン    ２カラム
      borderOffset.left=this.sheetLooks.SheetCellWidth;
//上マージン    ４フレーム
      borderOffset.top=frameHeight*4;
//右マージン    レコード末コメント除き１カラム
      borderOffset.right=this.sheetLooks.CommentWidth;
//下マージン    ４フレーム内寄り
      borderOffset.bottom=frameHeight*6
}else{
//境界オフセット変数
    var borderOffset={};
//左マージン    ３カラム
      borderOffset.left=this.sheetLooks.SheetCellWidth*4;
//上マージン    ６フレーム
      borderOffset.top= frameHeight*4;
//右マージン    レコード末コメント除き２カラム
      borderOffset.right= this.sheetLooks.CommentWidth;
//下マージン    ６フレーム
      borderOffset.bottom= frameHeight*6;
}
//オフセット計算
var offsetV=0;var offsetH=0;
    if((elementOffset.top-currentOffset.top)<(clipBounds.top+borderOffset.top)){
        offsetV=clipBounds.top+borderOffset.top-elementOffset.top+currentOffset.top;
    }else{
        if((elementOffset.top-currentOffset.top)>(clipBounds.bottom-borderOffset.bottom)){
        offsetV=clipBounds.bottom+currentOffset.top-borderOffset.bottom-elementOffset.top;
        }
    }

    if((elementOffset.left-currentOffset.left)<(clipBounds.left+borderOffset.left)){
        offsetH=(clipBounds.left+borderOffset.left)-elementOffset.left+currentOffset.left;
    }else{
        if((elementOffset.left-currentOffset.left)>(clipBounds.right-borderOffset.right)){
        offsetH=(clipBounds.right+currentOffset.left-borderOffset.right)-elementOffset.left;
        }
    }
//オフセットがHVともに0の場合は処理をスキップ(移動条件外)
    if((offsetV==0)&&(offsetH==0)){return;}else{
//移動量を計算してスクロール(可動範囲外の値が出るのでクランプする)
//    var myLeft=clamp([currentOffset.left-offsetH],0,document.body.clientWidth-(clipBounds.right -clipBounds.left))[1];
//    var myTop =clamp([currentOffset.top-offsetV] ,0,document.body.clientHeight-(clipBounds.bottom-clipBounds.top))[1];
    var myLeft=(currentOffset.left-offsetH);
    var myTop =(currentOffset.top-offsetV );
//    dbgPut(myLeft+":"+myTop);

//    var moved=(myLeft+myTop)?true:false;
//    if(moved){this.Mouse.action=false;};//マウス選択キャンセル
        scrollTo(myLeft,myTop);
      if(appHost.platform=="CSX"){
        this.onScroll();
      }
    }
}

/* xUI.onScroll
    SheetBody(document.body)のスクロールイベントに合わせ相当量の移動をヘッダに与える
３秒目からセルの高さが減少するのは、出力ルーチン側のカラム処理の問題だと思われる
スクロールが外れるのは、Rmp_initを通過しない書き換え部分で  body の初期化が発生するためと推測
onscrollの設定位置を一考
マージン部分のカバーをするか、または全体paddingが必要
キーボードによるスクロールが発生した場合、ケースを見て対応が必要

2015.04.22
*/
   xUI.onScroll=function() {
if(this.activeDocument.id==0) return;
     $('#UIheaderScrollV').offset( { top : $('#qdr4').offset().top} );
     $('#UIheaderScrollH').offset( { left : $('#qdr4').offset().left} );
   };
//===========================================
/**
    xUI.pMenu(target,mode)
    プルダウンメニューの有効／無効を切り替える
    引数:
        target  stging:メニューid
        mode    string:"disable","enable"
*/
    xUI.pMenu = function(target,mode){
        if (mode == 'enable'){
            $('#'+target+'-d').hide();
            $('#'+target).show();
        }else{
            $('#'+target).hide();
            $('#'+target+'-d').show();            
        }
    }
/*
	xUI.sWitchPanel(引数)
パネル類の表示をコントローする
引数="clear"または  なしの場合は、排他表示のパネル類を表示クリア（hide）して表示を初期化する

引数	JQobject	備考

//排他表示
login   #optionPanelLogin   //ログインUI（  排他）
memo    #optionPanelMemo    //メモ編集（  排他）
Data    #optionPanelData    //Import/Export（  排他）
AEKey   #optionPanelAEK     //キー変換（  排他）
Scn     #optionPanelScn     //シーン設定(モーダル)
SCIs    #optionPanelSCI    //複数対応簡易シーン設定(モーダル)
Pref    #optionPanelPref    //環境設定（モーダル）
Ver     #optionPanelVer     //about(モーダル)
File    #optionPanelFile    //ファイルブラウザ（モーダル）
Timer       #optionPanelTimer       //ストップウオッチ(共)
NodeChart   #optionPanelNOdeChart   //ノードチャート（モーダル）

Rol     #optionPanelFile    //入力ロック警告（モーダル）
Snd     #optionPnaleSnd     //音響パネル(共)
Img     #optionPnaleImg     //画像パネル(共)

Dbg     #optionPanelDbg	//デバッグコンソール（排他）
Prog	#optionPanelProg	//プログレス表示（排他モーダル）
//フローティングツール
Tbx     #optionPanelTbx	//ソフトウェアキーボード
//常時パネル（ユーザ指定）
menu    #pMenu	//ドロップダウンメニュー(共)
ToolBr      div#toolbarHeader	//ツールバー(共)
SheetHdr    div#sheetHeaderTable	//シートヘッダー(共)
memoArea		//ヘッダメモ欄複合オブジェクト
Utl	#optionPanelUtl	//ユーティリティーコマンドバー(共)排他から除外
//新UIツールポスト
*/
xUI.sWitchPanel = function sWitchPanel(status){
//新規UIを最優先にする 引数なし
    if(! status){
        if($('#toolbarPost').isVisible()){
            $('#toolbarPost').hide();
            xUI.shiftScreen(0,0);
        }else{
            $('#toolbarPost').show();
            xUI.shiftScreen(50,0);
        }
        return;
    }
//一括クリアするパネルのリスト
//	"#optionPanelProg",
var myPanelsDialog=[
	"#optionPanelVer",
	"#optionPanelNodeChart",
	"#optionPanelPref",
	"#optionPanelScn",
	"#optionPanelFile",
	"#optionPanelRol",
	"#optionPanelLogin",
	"#optionPanelSCI"
];
var myPanelsExclusive=[
	"#optionPanelMemo",
	"#optionPanelData",
	"#optionPanelAEK",
	"#optionPanelSnd",
	"#optionPanelRef",
	"#optionPanelCam",
	"#optionPanelStg",
	"#optionPanelSfx",
	"#optionPanelDraw",
	"#optionPanelTimer"
];/*
オールクリアは可能だが、ウインドウがフロートに移行するので使用範囲は限定される。
一部のフロートパネルは一括消去対象外にする
	"#optionPanelUtl",
	"#optionPanelTbx",
	"#optionPanelDbg",
*/

   if(( status == "clear" )){
       var clearTarget;
	for(var idx=0;idx<myPanelsExclusive.length;idx++){
//		if(document.getElementById("tbLock").checked && myPanels[idx]=="#optionPanelUtl"){continue;};
        clearTarget = $(myPanelsExclusive[idx]);
		if(myPanelsExclusive[idx]=="#optionPanelMemo"){
			if($("#optionPanelMemo").is(':visible')){this.sWitchPanel('memo');}
		}else{
			clearTarget.hide();
		}
	}
	for(var dx=0;dx<myPanelsDialog.length;dx++){
        clearTarget = $(myPanelsDialog[dx]);
		if (clearTarget.is(':visible')) clearTarget.dialog('close');
	}
	xUI.adjustSpacer();
	document.getElementById("iNputbOx").focus();
	return;
   }

//アニメーション効果フラグAE
    var AEF=(window.innerWidth < 900 )? 0:1;
//jQueryオブジェクトを取得してターゲットにする
	var myTarget=$("#optionPanel"+status);//jQ object
//if(! myTarget[0]){alert("noObject : #optionPanel"+status);return flase;};
//ターゲットが存在しないことがあるがそれはヨシ？
switch(status){
//ダイアログ
case	"File":	;//ファイルブラウザ
    if(documentDepot) documentDepot.updateTitleSelector();
case	"Ver":	;//バージョンパネル
case	"Pref":	;//環境設定
case	"Scn":	;//ドキュメント設定
case	"Login":;//ログインパネル
case	"SCI":	;//複数対応簡易ドキュメント設定
case	"Prog":	;//プログレスパネル
case	"Rol":	;//書き込み警告パネル
//case	"Snd":	;//音声編集パネル(スクロール追従)
	var myStatus=(myTarget.is(':visible'))? true:false;
//		this.sWitchPanel("clear");
		if(myStatus){myTarget.dialog("close")}else{myTarget.dialog("open");xUI.setDialog(myTarget);myTarget.focus();};
		
	break;
//割り込みパネル
case	"Timer":;//タイマーパネル
	var myStatus=(myTarget.is(':visible'))? true:false;
	xUI.player.keyboard=(myStatus)?false:true;
	this.sWitchPanel("clear");
	if(myStatus){myTarget.hide()}else{myTarget.show()};
break;
case	"Data":	;//データパネル
case	"Dbg":	;//デバッグパネル
//case	"Snd":	;//音声編集パネル(固定時)
	var myStatus=(myTarget.is(':visible'))? true:false;
		this.sWitchPanel("clear");
		if(myStatus){myTarget.hide()}else{myTarget.show()};
	break;
case	"NodeChart":	;//ノードチャート
	var myStatus=(myTarget.is(':visible'))? true:false;
		this.sWitchPanel("clear");
		if(myStatus){myTarget.dialog('close')}else{
		    //ここに初期化プロシジャを呼ぶ？
		    myTarget.width('100%');
		    myTarget.dialog('open');
		};
	break;
case	"Cam":	    ;//カメラワークパネル
case	"Ref":	    ;//情報参照パネル(fixed)
case	"Sfx":	    ;//コンポジットパネル
case	"Snd":	    ;//音声編集パネル(fixed)
case	"Stg":	    ;//ステージワークパネル
case	"Tbx":	    ;//ツールボックス
case	"Draw":     ;//手描き編集パネル
case	"TimeUI":	;//ツールボックス
		if(myTarget.is(':visible')){myTarget.hide()}else{myTarget.show()};
	break;

case	"memo":	;//memo edit start
	myTarget=$("#optionPanelMemo");//置き換え
	var hideTarget = $("#memo");
	if(! myTarget.is(':visible')){
		this.sWitchPanel("clear");
		if((document.getElementById("myWords").innerHTML=="word table")&&(myWords)){
			document.getElementById("myWords").innerHTML=putMyWords();
		}
		hideTarget.hide();
		myTarget.show();
		document.getElementById("rEsult").value=this.XPS.xpsTracks.noteText;
	}else{
		hideTarget.show();
		this.XPS.xpsTracks.noteText=document.getElementById("rEsult").value;
		sync("memo");
		myTarget.hide();
	};
	break;
case	"memoArea": ;//メモエリア切り替え
	if($("#memoArea").is(":visible")){
		$("#memoArea").hide()
	}else{
		$("#memoArea").show()
	};
//		xUI.adjustSpacer();
break;
case	"AEKey":	;//キー表示
	myTarget=$("#optionPanelAEK");//置き換え
	if(! myTarget.is(':visible')){
		this.sWitchPanel("clear");
			//パネル初期化が必要
			//var myIdx=["blmtd","blpos","aeVersion"]//キーメッソド固定に変更されるので不要  ,"keyMethod"
			//for (var idx=0;idx<myIdx.length;idx++){document.getElementById(myIdx[idx]).value=xUI[myIdx[idx]];}
		myTarget.show();
	}else{
		myTarget.hide();
	};
	break;
case	"menu":	;//ドロップダウンメニューバー  消す時に操作性が阻害されるケースがあるので警告を入れる
	if($("#pMenu").is(":visible")){
		if(appHost.platform!="AIR"){
		    var msg=localize(nas.uiMsg.dmConfirmClosepMenu);//
			if(confirm(msg)){$("#pMenu").hide();}else{break;};
		}else{
			$("#pMenu").hide();
		}
	}else{
		$("#pMenu").show()
	};
//	xUI.adjustSpacer();
break;
case	"ToolBr":	;//固定ツールバー
	myTarget=$("#toolbarHeader");
case	"Utl":	;//ユーティリテーメニューパネル
	if(myTarget.is(':visible')){
		myTarget.hide(["slide","blined"][AEF]);
	}else{
		myTarget.show(["slide","blined"][AEF]);
	};
break;	
case	"SheetHdr": ;//固定UIシートヘッダ
	if($("#sheetHeaderTable").is(":visible")){$("#sheetHeaderTable").hide()}else{$("#sheetHeaderTable").show()};
//	xUI.adjustSpacer();
break;

case	"headerTool":	;//ヘッダツール
case	"inputControl":	;//入力Control
case	"account_box":	;//アカウント表示ボックス
case	"pmui":	;//固定ツールバー
	if($("#"+status).is(":visible")){$("#"+status).hide()}else{$("#"+status).show()};
break;
default:	;//	NOP
}
	xUI.adjustSpacer();
	document.getElementById("iNputbOx").focus();
}

/**
 *  @class
 *   画像パーツを描画するローレベルファンクション
 *   bodyコレクションは、描画したテーブルセル内の画像エレメントへの参照が格納される
*/
xUI.Cgl = new Object();
/** セル画像部品描画色*/
xUI.Cgl.baseColorArray = (xUI.sheetTextColor)? nas.colorStr2Ary(xUI.sheetTextColor):[0,1,0,1,0,1];
/** セル画像部品トレーラー*/
xUI.Cgl.body={};
/** セル画像部品キャッシュ */
xUI.Cgl.formCashe = {};     

/** セル画像部品表示
 *     @params {String} myId
 *         描画ターゲットセルID
*/
xUI.Cgl.show=function(myId){
	if(! this.body[myId]){	this.body[myId] = document.getElementById("cgl"+myId)	;}
	if(this.body[myId]){$("#cgl"+myId).show();}else{delete this.body[myId];}
}
/** セル画像部品非表示
 *     @params {String} myId
 *         描画ターゲットセルID
*/
xUI.Cgl.hide=function(myId){
	if(! this.body[myId]){	this.body[myId] = document.getElementById("cgl"+myId)	;}
	if(this.body[myId]){$("#cgl"+myId).hide();}else{delete this.body[myId];}
}
/** セル画像部品削除
 *     @params {String} myId
 *         ターゲットセルID
 *         コレクションから削除する
*/
xUI.Cgl.remove=function(myId){
	if(! this.body[myId]){	this.body[myId] = document.getElementById("cgl"+myId)	;}
	if(this.body[myId]){$("#cgl"+myId).remove();delete this.body[myId];}
}
/** セル画像部品クラス全体を初期化　*/
xUI.Cgl.init=function(){
    for (var prp in this.body){
        $("#cgl"+prp).remove();
        delete this.body[prp];
    }
}
/**
 *   範囲を指定してグラフィック部品を再描画するラッパ関数
 *  @params {Array of Array} myRange
 *     レンジの書式はXpsの戻すレンジに準ずる
 *     [[開始トラック,開始フレーム],[終了トラック,終了フレーム]]
 *  @params {boolean}　isReference
 *     再描画範囲をリファレンスエリアとするフラグ
 *     リファレンスフラグが無い場合は編集対象のXPSを処理する
 */
xUI.Cgl.refresh=function(myRange,isReference){
    if (typeof myRange == "undefined") {
        myRange = [[0, 0], [xUI.XPS.xpsTracks.length - 1, xUI.XPS.xpsTracks[0].length - 1]]
    }//指定がなければ全体を更新 印刷時は明確に範囲を指定する必要あり？
    var StartAddress = myRange[0];
    var EndAddress   = myRange[1];
    var idPrefix     =(isReference)?"r_":"";
    /**
     * ループして更新
     */
    for (var t = StartAddress[0]; t <= EndAddress[0]; t++) {
        for (var f = StartAddress[1]; f <= EndAddress[1]; f++){
            this.draw(idPrefix+[t,f].join('_'));
        }
    }
}
/**
 *	セル画像部品描画コマンド
 * 位置計算をブラウザに任せるため  絶対座標でなく相対座標で各テーブルセル自体にCANVASをアタッチする
 * 
 * 基本部品はすべてキャッシュを行い  image Objectを作成する。
 * 
 * 印字の際に描画の動作独立性を高める必要があるので、セルに埋め込んだ画像クラスを判定してその描画を行う仕様に変更
 * 具体的には、myFormに優先してターゲットセルの"graph_"で開始されるクラス名からFormを取得するように変更
 *   170815
 * シートカラーを  ユーザ変更可能にしたので  暗色テーマへの対応が必要
 * 描画カラーをオブジェクトプロパティ設ける事
 *  @params {String} myId
 *       ターゲットセルID
 *  @params {String} myForm
 *      描画図形キーワード
 * 引数myFormの書式は以下
 *     Shape[[-Track]-Cycle]_Start-End
 *     後ほどShapeごとにプラグイン処理が可能なように変更を行う予定
 * 
 *   引数として以下の形式も受け入れる
 * addGraphElement(myId,myForm,start,end)
 * 
 * myForm を事前処理してtargetShapeを事前抽出するように変更20180513
 */
xUI.Cgl.draw=function addGraphElement(myId,myForm) {
	    var objTarget  = document.getElementById(myId);//ターゲットシートセルを取得
	    if(! objTarget){return false;};//シートセルが存在しない場合は操作失敗
        var jqTarget = $('#'+myId);
    var classes=jqTarget.attr('class').split(' ');
    for (var cix=0;cix<classes.length;cix++){if (classes[cix].indexOf('graph_')==0){myForm=classes[cix].replace(/^graph_/,'');break;}}
    if(typeof myForm == 'undefined') {return false};//指定無しでかつ取得に失敗した場合はリターン(印刷時に有効)

/*
    区間描画時に形成されたIDの場合はパーセンテージを分解して描画する  開始・終了率を先行して分離
    終了率が省略された場合は、開始率で補う
    キーワードとして m,l,s が 100,50,25 を表す。
*/
    if(myForm.match(/(.*)_(\d+)(\-(\d+))?$/)){
            myForm=RegExp.$1; arguments[2]=(RegExp.$2/100);
        if(RegExp.$4){
            arguments[3]=(RegExp.$4/100);
        }
    }else if(myForm.match(/(.*)_([mls])$/)){
        switch(RegExp.$2){
            case 'l':
                arguments[2]=(100/100);
            break;
            case 'm':
                arguments[2]=(50/100);
            break;
            case 's':
                arguments[2]=(25/100);
            break;
        }
    }
/*
    myForm を分解して目標形状、目標トラック、Cycle値を取得
*/
    var targetShape = (myForm.split('_')[0]).split('-')[0];//ターゲット形状
    var targetTrack = (myForm.match(/-(ref|stl|rmt|cam|sfx)/i))? RegExp.$1:"";//トラック指定  ヒットがない場合は全トラック適用
/*
    サイクルターゲットパラメータは配列で持つ  [参照値,母数]
*/
    var cycleTarget=[0,1];
    if (myForm.indexOf('evn')>=0){
        cycleTarget = [0,2];//evnを数値化
    } else if(myForm.indexOf('odd')>=0){
        cycleTarget = [1,2];//oddを数値化
    } else if(myForm.match(/\-(\d+)/)){
        cycleTarget = RegExp.$1;
        var myLength=Math.floor(cycleTarget.length/2);
        cycleTarget=[cycleTarget.slice(0,myLength),cycleTarget.slice(cycleTarget.length-myLength)];
    }

		if(! this.body[myId]){	this.body[myId] = document.getElementById("cgl"+myId)	;}
		if( this.body[myId] ){
			$("#cgl"+myId).remove();delete this.body[myId];
		//二重描画防止の為すでにエレメントがあればクリアして描画
		}
/*
    以下の場合分けは、ノーマル時の処理とAIR環境のバグ回避コード
    先の処理のほうがオーバヘッドが小さいので推奨だが、AIRで正常に処理されない
- td配下に置いたcanvasエレメントが、position=absoluteを指定するとページ全体又はテーブルを包括するdivの原点をベースに描画される。
- element.top/.left で指定した座標が反映されないことがある  element.style.top/.left は正常
 動作異状の検出ルーチンはまだ組んでいない。ビルド毎にAIRに当該のバグがあるか否か確認が必要
 2016.11.12
*/
if(appHost.platform != "AIR"){
        var objParent = objTarget;
        var myTop     = "0px";
        var myLeft    = "0px";
}else{
        var objParent  = ((xUI.viewMode=="Compact")&&(myId.indexOf("r")==0))?
                    document.getElementById("UIheaderScrollV"):
                    document.getElementById("qdr4");
//        var targetRect = objTarget.getBoundingClientRect();
//        var parentRect = document.getElementById("sheet_body").getBoundingClientRect();
        var myTop     = objTarget.offsetTop  + "px";
        var myLeft      = objTarget.offsetLeft + "px";
}
/*
    formCache  を作成する
    単一セルに対するformは初回描画時にpngにレンダリングCacheに格納される
    ２度め以降はその都度利用される。
    トランジション系は形状が安定しないため都度描画
*/
    if(xUI.Cgl.formCashe[myForm]){
	    var element = new Image(objTarget.clientWidth,objTarget.clientHeight); 
	    element.id      = 'cgl' + myId; 
	    element.className   = 'cgl';
        element.style.top  = myTop
        element.style.left = myLeft;
        element.src = xUI.Cgl.formCashe[myForm];
    }else{
	    var element = document.createElement('canvas'); 
	    element.id      = 'cgl' + myId; 
	    element.className   = 'cgl';
	    
//        element.style.position="absolute";
        element.style.top  = myTop
        element.style.left = myLeft;
	    element.width  = objTarget.clientWidth;
	    element.height = objTarget.clientHeight;
	    var ctx = element.getContext("2d");

switch(targetShape){
case "blankCloss":;		//transition
/*
    ブランク用ばつ印
    セルいっぱいに描く
*/		var lineWidth  =4;
		ctx.strokeStyle='rgb('+xUI.Cgl.baseColorArray.join(',')+')';
		ctx.strokeWidth=lineWidth;
		ctx.moveTo(element.width, 0);//
		ctx.lineTo(0,element.height);
		ctx.moveTo(0, 0);//
		ctx.lineTo(element.width,element.height);
		ctx.stroke();
break;case "line":	    //vertical-line
/*
case "line-ref":	    //vertical-line
case "line-cam":	    //vertical-line
case "line-sfx":	    //vertical-line
*/
    if(typeof xUI.Cgl.formCashe[myForm] == 'undefined'){
		var lineWidth  =3;
		ctx.strokeStyle='rgb('+xUI.Cgl.baseColorArray.join(',')+')';
		ctx.strokeWidth=lineWidth;
		ctx.moveTo(element.width*0.5, 0);
		ctx.lineTo(element.width*0.5, element.height);
	    ctx.stroke();
	    xUI.Cgl.formCashe[myForm] = element.toDataURL("image/png");
	}
break;
case "wave":;			//wave-line
/*
奇遇フレームのみでなくサイクル動作するフォームを全てサポートする
Waveは奇遇サイクル
case "wave-odd":;		//wave-line 偶数フレーム
case "wave-evn":;		//wave-line 奇数フレーム
case "wave-ref-odd":;		//wave-line 偶数フレーム
case "wave-ref-evn":;		//wave-line 奇数フレーム
*/
    if(typeof xUI.Cgl.formCashe[myForm] == 'undefined'){
		var waveSpan  =(arguments[2])? element.width*arguments[2]/2:element.width/4;
		//var waveSpan  =7.5;
		var lineWidth  =3;
		ctx.strokeStyle='rgb('+xUI.Cgl.baseColorArray.join(',')+')';
		ctx.strokeWidth=lineWidth;
		ctx.moveTo(element.width*0.5, 0);
		if(cycleTarget[0]%cycleTarget[1]){
	ctx.bezierCurveTo(element.width*0.5-waveSpan, element.height*0.5,element.width*0.5-waveSpan, element.height*0.5,  element.width*0.5, element.height);
		}else{
	ctx.bezierCurveTo(element.width*0.5+waveSpan, element.height*0.5,element.width*0.5+waveSpan, element.height*0.5,  element.width*0.5, element.height);
		}
	    ctx.stroke();
	    xUI.Cgl.formCashe[myForm] = element.toDataURL("image/png");
	}
break;
case "shake":;			//shake-line
/*
シェイク形状は、大中小の副形状をサポートする  ウェーブと初期位相を反転させる
case "shake-odd":;		//shake-line 偶数フレーム
case "shake-evn":;		//shake-line 奇数フレーム
case "shake-cam-odd":;		//shake-line 偶数フレーム
case "shake-cam-evn":;		//shake-line 奇数フレーム
*/
    if(typeof xUI.Cgl.formCashe[myForm] == 'undefined'){
		var shakeSpan  =(arguments[2])? element.width*arguments[2]/2:element.width/4;
		var lineWidth  =2;
		ctx.strokeStyle='rgb('+xUI.Cgl.baseColorArray.join(',')+')';
		ctx.strokeWidth=lineWidth;
		ctx.moveTo(element.width*0.5, 0);
		if(cycleTarget[0]%cycleTarget[1]){
	ctx.lineTo(element.width*0.5+shakeSpan, element.height*0.5);
	ctx.lineTo(element.width*0.5, element.height);
		}else{
	ctx.lineTo(element.width*0.5-shakeSpan, element.height*0.5);
	ctx.lineTo(element.width*0.5, element.height);
		}
	    ctx.stroke();
	    xUI.Cgl.formCashe[myForm] = element.toDataURL("image/png");
	}
break;
case "fi":;		//fade-in
	var startValue = arguments[2]; var endValue= arguments[3];
	    ctx.fillStyle="rgba("+xUI.Cgl.baseColorArray.join(',')+",1)";
		ctx.moveTo((1-startValue)*element.width*0.5, 0);
		ctx.lineTo(element.width-(1-startValue)*element.width*0.5,0);
		ctx.lineTo(element.width-(1-endValue)*element.width*0.5,element.height);
		ctx.lineTo((1-endValue)*element.width*0.5,element.height);
		ctx.fill();
break;
case "fo":;		//fade-out
	var startValue = arguments[2]; var endValue= arguments[3];
	    ctx.fillStyle="rgba("+xUI.Cgl.baseColorArray.join(',')+",1)";
		ctx.moveTo(startValue*element.width*0.5, 0);
		ctx.lineTo(element.width-startValue*element.width*0.5,0);
		ctx.lineTo(element.width-endValue*element.width*0.5,element.height);
		ctx.lineTo(endValue*element.width*0.5,element.height);
		ctx.fill();
break;
case "transition":;		//transition
	var startValue = arguments[2]; var endValue= arguments[3];
	    ctx.fillStyle="rgba("+xUI.Cgl.baseColorArray.join(',')+",1)";
		ctx.moveTo(startValue*element.width, 0);//
		ctx.lineTo(element.width-startValue*element.width,0);
		ctx.lineTo(element.width-endValue*element.width,element.height);
		ctx.lineTo(endValue*element.width,element.height);
		ctx.fill();
break;
case "circle":;		 //circle
/*
case "circle-ref":;	 //circle-reference
*/
    if(typeof xUI.Cgl.formCashe[myForm] == 'undefined'){
		var phi  = .9;		var lineWidth  =3;
		ctx.strokeStyle='rgb('+xUI.Cgl.baseColorArray.join(',')+')';
		ctx.strokeWidth=lineWidth;
		ctx.arc(element.width * 0.5, element.height * 0.5, element.height*phi*0.5, 0, Math.PI*2, true);
	    ctx.stroke();
	    xUI.Cgl.formCashe[myForm] = element.toDataURL("image/png");
	}
break;
case "triangle":;		//triangle
/*
case "triangle-ref":;	//triangle
*/
    if(typeof xUI.Cgl.formCashe[myForm] == 'undefined'){
		var lineWidth  =4;
		ctx.strokeStyle='rgb('+xUI.Cgl.baseColorArray.join(',')+')';
		ctx.strokeWidth=lineWidth;
		ctx.moveTo(element.width*0.5, -1);
		ctx.lineTo(element.width*0.5 + (element.height-2)/Math.sqrt(3), element.height-2);
		ctx.lineTo(element.width*0.5 - (element.height-2)/Math.sqrt(3), element.height-2);
		ctx.closePath();
	    ctx.stroke();
	    xUI.Cgl.formCashe[myForm] = element.toDataURL("image/png");
	}
break;
case "sectionOpen":;		//sectionOpen
    if(typeof xUI.Cgl.formCashe[myForm] == 'undefined'){
	var formFill = arguments[2];
	    ctx.fillStyle="rgba("+xUI.Cgl.baseColorArray.join(',')+",1)";
		ctx.moveTo(element.width * 0.5 - element.height/Math.sqrt(3), 0);
		ctx.lineTo(element.width * 0.5 + element.height/Math.sqrt(3), 0);
		ctx.lineTo(element.width * 0.5 , element.height);
		ctx.closePath();
		if(formFill) {ctx.fill();}else{ctx.stroke();}
	    xUI.Cgl.formCashe[myForm] = element.toDataURL("image/png");
	}
break;
case "sectionClose":;		//sectionClose
    if(typeof xUI.Cgl.formCashe[myForm] == 'undefined'){
	var formFill = arguments[2];
	    ctx.fillStyle="rgba("+xUI.Cgl.baseColorArray.join(',')+",1)";
		ctx.moveTo(element.width * 0.5, 0);
		ctx.lineTo(element.width * 0.5 + element.height/Math.sqrt(3), element.height);
		ctx.lineTo(element.width * 0.5 - element.height/Math.sqrt(3), element.height);
		ctx.closePath();
		if(formFill) {ctx.fill();}else{ctx.stroke();}
	    xUI.Cgl.formCashe[myForm] = element.toDataURL("image/png");
	}
break;
case "dialogOpen":;		//dialogsectionOpen
    if(typeof xUI.Cgl.formCashe[myForm] == 'undefined'){
	var lineWidth = 3;
	    ctx.fillStyle="rgba("+xUI.Cgl.baseColorArray.join(',')+",1)";
		ctx.moveTo(0, element.height-lineWidth);
		ctx.lineTo(element.width, element.height-lineWidth);
		ctx.stroke();
	    xUI.Cgl.formCashe[myForm] = element.toDataURL("image/png");
	}
break;
case "dialogClose":;		//dialogsectionClose
    if(typeof xUI.Cgl.formCashe[myForm] == 'undefined'){
	var lineWidth = 3;
	    ctx.fillStyle="rgba("+xUI.Cgl.baseColorArray.join(',')+",1)";
		ctx.moveTo(0, lineWidth);
		ctx.lineTo(element.width, lineWidth);
		ctx.stroke();
	    xUI.Cgl.formCashe[myForm] = element.toDataURL("image/png");
	}
break;
case "areaFill":;	//fill sheet cell
    if(typeof xUI.Cgl.formCashe[myForm] == 'undefined'){
		ctx.moveTo(0, 0);
	    ctx.fillStyle="rgba("+xUI.Cgl.baseColorArray.join(',')+",1)";
	    ctx.fillRect(0, 0, targetRect.width, targetRect.height);
	    xUI.Cgl.formCashe[myForm] = element.toDataURL("image/png");
	}
break;
}
    }
	    element=objParent.appendChild(element); 
//	    element=objTarget.appendChild(objParent);
//	    element.top = myTop;
//	    element.left= myLeft;
//	    element.style.zIndex=1;//シートに合わせて設定
//		element.style.pointerEvents='none';//イベントは全キャンセル
//		element.style.brendMode="multiply";//乗算
//		element.style.opacity="0.2";//30%
this.body[myId]=element;
this.body[myId].formProp=myForm;

return element;
}
/**
 *     トランジション系セクションを一括描画するラッパー関数
 *     この関数を使用する場合は直接Gcl.drawを呼ばないようにすること。
 *  @params {String} myId
 *       ターゲットセルID
 *  @params {String} myForm
 *      描画図形キーワード
 *  @params {Number} myDuration
 *      描画区間長(フレーム数)
 */
xUI.Cgl.sectionDraw = function(myId,myForm,myDuration){
    var Idx=myId.split("_").reverse();
    for (var offset = 0;offset< myDuration;offset ++){
//編集エリアとリファレンスエリアで分岐
        if(Idx.length==2){
          //this.draw(       [Idx[1],parseInt(Idx[0])+offset].join("_"),myForm,offset / myDuration, (offset+1) / myDuration);
          $('#'+[Idx[1],parseInt(Idx[0])+offset].join('_')).addClass('graph_'+myForm+'_'+String(parseInt(100 * offset / myDuration))+'-'+String(parseInt(100 *((offset+1) / myDuration))));
        }else{
          //this.draw([Idx[2],Idx[1],parseInt(Idx[0])+offset].join("_"),myForm,offset / myDuration, (offset+1) / myDuration);
          $('#'+[Idx[2],Idx[1],parseInt(Idx[0])+offset].join('_')).addClass('graph_'+myForm+'_'+String(parseInt(100 * offset / myDuration))+'-'+String(parseInt(100 *((offset+1) / myDuration))));
        }
    }
}
/**
 *     sessionRetrace 値の更新
 *     サーバ上での更新状態を示す
 *  @returns {Number}
 *      更新後の　xUI.sessionRetrace　値
 *     -1  エントリがリポジトリ上にない
 *     0   最新のデータ = 作業続行可能
 *     1~  番号が増えるに従って1世代づつ古いデータとなる
 */
xUI.setRetrace = function(){
    var myIdentifier = nas.Pm.getIdentifier(xUI.XMAP);
    var currentEntry = serviceAgent.currentRepository.entry(myIdentifier);
    if (xUI.XMAP.dataNode){
//エントリリストのデータから求めるのでなく nodeChartから求める
/*        for (var ix=0;ix<currentEntry.issues.length;ix++){
            if(Xps.compareIdentifier(currentEntry.toString(ix),myIdentifier)>4){
                xUI.sessionRetrace = ix;
                break;
            }
        };//*/
//
                xUI.sessionRetrace = 0;
    }else{
        xUI.sessionRetrace = -1;    
    }
    return xUI.sessionRetrace;
}
/*

*/
/**
 *  xUIにターゲットオブジェクトを与えてシートをリセットする関数
 *  <pre>
 *  初期化手順を用いていた部分の置換え用途で作成
 *  初期化手順内でもこの手続を呼び出すように変更
 *  この手続内では基本的にundo処理は行わない
 *  したがって必要に従ってこの手続を呼ぶ前にundoの初期化を行うか、またはundo操作を行う必要がある。
 *  引数省略時は画面のリフレッシュのみを行う。
 *  Xps編集画面が非表示の場合、リフレッシュを保留する。
 *  Xps編集画面表示時に保留フラグがある場合リフレッシュを強制的に行う。</pre>
 *  @params {Object Xps} editXps
 *      主ターゲットXps　省略可
 *  @params {Object Xps} referenceXps
 *      参照ターゲットXpa  省略可
 */
xUI.resetSheet=function(editXps,referenceXps){
console.log('xps reset : activeDocument id : '+ xUI.activeDocumentId);

    if(
        (xUI.activeDocumentId <= 0)||
        (xUI.XPS !== xUI.documents[xUI.activeDocumentId].content)
    ){
console.log('skip data refresh');
        xUI.delayRefreash = true;
        return ;
    }
//  現在のカーソル配置をバックアップ
    var restorePoint = this.Select.concat();
    var restoreSelection=this.Selection.concat();
    this.selection();//選択解除
    var reWriteXPS = false;
    var reWriteREF = false;
    var Refstatus = (document.getElementById('rnArea'))? $('#rnArea').isVisible():true;
    if(! Refstatus) xUI.flipRefColumns('show');
/*
    引数にeditXPSが与えられなかった場合は、現在のXPSのまま処理を続行（画面のrefreshのみを行う）
 */
    if ((typeof editXps != "undefined") && (editXps instanceof Xps)){
//編集エリアに対するreadINの条件判定
//      xUI.uiMode=='production' のケースではSCi情報を保持する
//      それ以外のケースでは引数側の情報で上書きされる
        var propertyBackup=Xps.parseIdentifier(Xps.getIdentifier(xUI.XPS));
        this.XPS.parseXps(editXps.toString());    //XPSをバッファ更新
        // 書換え範囲にXPS全体を追加
        reWriteXPS = true;
    }
/*
        引数に参照シートが渡されていたら、優先して解決
        指定のない場合は現在の参照シートを保持して使用
 */
    if ((typeof referenceXps != "undefined") && (referenceXps instanceof Xps)){
        this.referenceXPS=referenceXps;
        // 書換え範囲に 参照XPS全体を追加
        reWriteREF=true;
    };
//  バックアップしたカーソル位置が新しいシートで範囲外になる場合は範囲内にまるめる
    if(restorePoint[0] >= xUI.XPS.xpsTracks.length)   restorePoint[0] = xUI.XPS.xpsTracks.length -1;
    if(restorePoint[1] >= xUI.XPS.xpsTracks.duration) restorePoint[1] = xUI.XPS.xpsTracks.duration -1;
//表示プロパティのリフレッシュを行う  シートが変更されていなければ不用
    this._checkProp();
//セルグラフィック初期化( = 画面クリア)
//    this.Cgl.init();
//タイムシートテーブルボディ幅の再計算
    var tableReferenceWidth =  this.sheetLooks.ActionWidth * this.referenceLabels.length;
    var tableEditWidth = (
        this.sheetLooks.DialogWidth * this.dialogCount + 
        this.sheetLooks.SoundWidth * this.soundCount + 
        this.sheetLooks.SheetCellWidth * this.timingCount +
        this.sheetLooks.StillCellWidth * this.stillCount +
        this.sheetLooks.SfxCellWidth * this.sfxCount +
        this.sheetLooks.GeometryCellWidth*this.stageworkCount +
        this.sheetLooks.CameraCellWidth * this.cameraCount +
        this.sheetLooks.CommentWidth
    );//タイムシートの基礎トラック専有幅を算出
    var tableColumnWidth=this.sheetLooks.TimeGuideWidth + tableReferenceWidth + tableEditWidth;
//if(this.viewMode != "Compact"){    };//マルチカラムの場合、マージン付きでカラム数複製する
    var tableBodyWidth = tableColumnWidth * this.PageCols +  (this.sheetLooks.ColumnSeparatorWidth * (this.PageCols-1) );
//  UI上メモとトランジション表示をシート表示と切り分けること 関連処理注意
    sync("memo");
//  シートボディの表示
    if(this.viewMode=="Compact"){
//コンパクトモード  コンパクトUI用のラベルヘッダーを作成
        document.getElementById("UIheaderFix").innerHTML=this.pageView(-1);
        document.getElementById("UIheaderScrollH").innerHTML=this.pageView(0);
        document.getElementById("UIheaderScrollV").innerHTML=this.pageView(-2);
        document.getElementById("UIheader").style.display="inline";
//コンパクトUI時は1ページ限定なのでボディ出力を１回だけ行う
        var SheetBody = '<div id=printPg1 class=printPage>';
        SheetBody += this.headerView(1);
        SheetBody += '<br>';//UI調整用に１行（ステータス行の分）
        SheetBody += this.pageView(1);
        SheetBody += '</div>';
    }else{
//ノーマルモード  コンパクトUI用のラベルヘッダーを隠す
        document.getElementById("UIheader").style.display="none";
        var SheetBody='';
        for (var Page=1 ;Page <=Math.ceil(xUI.XPS.duration()/this.PageLength);Page++){
            SheetBody += '<div id=printPg'+String(Page) +' class=printPage>';
            SheetBody += this.headerView(Page);
            SheetBody += ' <span class=pgNm>( p '+nas.Zf(Page,3)+' )</span><br>';
            SheetBody += this.pageView(Page);
            SheetBody += '</div>';
        };
    }
//  シートボディを締める
    document.getElementById("sheet_body").innerHTML=SheetBody+"<div class=\"screenSpace\"></div>";

// グラフィックパーツを配置(setTimeoutで無名関数として非同期実行)
    window.setTimeout(function(){
            xUI.syncSheetCell(0,0,false);//シートグラフィック置換
            xUI.syncSheetCell(0,0,true);//referenceシートグラフィック置換
//フットスタンプの再表示
        if(xUI.footMark){xUI.footstampPaint()};
//  カーソル位置復帰（範囲外は自動でまるめる）
        xUI.selectCell(restorePoint);
        xUI.selection(add(restorePoint,restoreSelection));
    },0);
//    this.bkup([xUI.XPS.xpsTracks[1][0]]);
//画像部品の表示前のカーソル位置描画,'width':markerWidth
//    this.selectCell(restorePoint);
//    this.selection(restoreSelection);
//    this.selection(add(restorePoint,restoreSelection));
//セクション編集状態であれば解除
    if(this.edmode>0){this.mdChg('normal');}
//表示内容の同期
    sync("tool_");
    sync("info_");
/*
    viewMode設定
*/
//コンパクトモードが有効
    if(xUI.viewMode=="Compact"){
//ロゴ
    $("#logoTable").hide();
//第二カウンタ
    $("#fct1").hide();
//ツールバーボタン
    $("#ok").hide();
    $("#ng").hide();
//シートヘッダ
//    $("#opusL").hide();
//    $("#titleL").hide();
//    $("#subtitleL").hide();
    $("#nameL").hide();
//    $("#opus").hide();
//    $("#title").hide();
//    $("#subtitle").hide();
    $("#update_user").hide();
//メモエリア
    $("#memoArea").hide();
//タイムラインヘッダ
    $("#UIheader").show();
    if(document.getElementById("UIheaderScrollV").innerHTML==""){document.getElementById("UIheaderScrollV").innerHTML=xUI.pageView(-2);};
//    $("#UIheaderFix").show();
//    $("#UIheaderScroll").show();
/*　タグ表示域高さ調整*/
    $('.tlhead').each(function(){$(this).height($('#tlheadParent').height())});
    }else{
//ロゴ
    $("#logoTable").show();
//    $("#headerLogo").show();
//第二カウンタ
    $("#fct1").show();
//ツールバーボタン
    $("#ok").show();
    $("#ng").show();

//シートヘッダ
//    $("#opusL").show();
//    $("#titleL").show();
//    $("#subtitleL").show();
    $("#nameL").show();
//    $("#opus").show();
//    $("#title").show();
//    $("#subtitle").show();
    $("#update_user").show();
//メモエリア
    $("#memoArea").show();
//タイムラインヘッダ
    $("#UIheader").hide();
    $("#UIheaderScrollV").html("");
    
//    $("#UIheaderFix").hide();
//    $("#UIheaderScroll").hide();
    }

/* ヘッダ高さの初期調整*/
    this.adjustSpacer();

/* エンドマーカー位置調整 はadjustSpacerに内包
//印字用endマーカーは  印刷cssを参照して誤差を反映させること  フレームのピッチを計算すること
印刷画面は印刷画面出力時に再度同メソッドで調整  トラック間の
xUI.replaceEndMarker([トラック数,フレーム数],上下オフセットpx);
 */
    xUI.replaceEndMarker(xUI.XPS.xpsTracks.duration);
if(! Refstatus) xUI.flipRefColumns('hide');

    return ;
};

//test-    xUI.reset(new Xps(3,24),new Xps(5,72));

/**
 *     tcサブコントロールに設定してターゲット要素の値を編集する関数.
 * 
 *     関数の最期にonChangeがあれば実行
 * 
 * 
 *     @params {Stirng}    targetId   ターゲット要素のIDまたはターゲット要素
 *     @params {Number}    tcForm     使用するTC型式
 *     @params {Numder}    myStep     クリック毎に加算するフレーム数
 */
xUI.tcControl = function(targetId,tcForm,myStep){
    var myTarget = document.getElementById(targetId);
    myTarget.value=nas.Frm2FCT(nas.FCT2Frm(myTarget.value)+myStep,tcForm,0,this.XPS.framerate);
    if(document.getElementById(targetId).onchange) document.getElementById(targetId).onchange();
    return false;
}
/*
    xUI.XPS < 編集対象のXpstが参照される
    xUIに編集対象Xpsトレーラを増設
    各Xpsごとにテータスを持つのでそれを参照して切り替えを行うようにする
*/
/** タブコントロール
引数 tabID 0:project 1~ :Xpst 1~

0
    xmap    if(xpst1)? left-active-overlay:left-active;
    xpst    if(xpst[ix+1])? right-dectivate:mid-deactivate-overlay;   
1~
    xmap    if(xpst[1] == active)? left-dective:left-deactive-overlay;
    xpst    if(xpst[ix+1])? mid: right;
            if(idx==ix)? active:(midd) ? dective-overlay : deactive;
*/
xUI.tabSelect =function(tabId){
    return this.activateDocument(tabId);
}
xUI.reDrawDocumentTab = function(){
    var uiContent='';
    uiContent += '\n<!-- タブコントロール -->\n'
    uiContent += '<button id ="tab_0" class ="tabControll tabControll-xmap" onClick = xUI.tabSelect(0);>'
    uiContent += this.documents[0].content.pmu.opus.toString();
    uiContent += '</button>';
    for (var dix = 1 ; dix < this.documents.length ; dix++){
        uiContent += '<button id="tab_'+dix
        uiContent += '" class="tabControll tabControll-xpst" '
        uiContent += 'onClick ="xUI.tabSelect('+dix+');" >';
        uiContent += this.documents[0].content.pmu.inherit[dix-1].toString('full');
        uiContent += '</button>'
    }
    uiContent += '<button id="tab_end" class="tabControll tabControll-end" disabled=true></button>';
    uiContent += '\n<!-- タブコントロール -->\n'
    document.getElementById('tabSelector-doc').innerHTML=uiContent;
//ここにカラーのリセットが必要
//  タブUIに  背景色を設定
    $('.tabControll').css('background-color',this.sheetbaseColor);
//    $('#tabSelector').css('background-color',this.sheetbaseColor);

    this.activateDocument();
}

xUI.activateDocument  = function(documentId){
    if(typeof documentId == 'undefined') documentId = this.activeDocumentId;
//タブループ
    for (var tix=0;tix<this.documents.length; tix++){
//console.log('#tab_'+tix)
        var targetTab = $('#tab_'+tix);//タブ位置
        var prefix=(tix==0)?'left':'midd';//左タブ
        var currentStatus=(tix==this.activeDocumentId)?'active':'deactive';//処理中のタブの現ステータス
        var status=(tix==documentId)?'active':'deactive';//処理中のタブの新ステータス
        var currentPostfix=((prefix=='mid')&&(currentStatus=='deactive')&&(tix-1!=this.activeDocumentId))?'overlay':false;
        var postfix=((prefix=='midd')&&(status=='deactive')&&(tix-1!=documentId))?'overlay':false;
        var currentClass=(currentPostfix)?['tabControll',prefix,currentStatus,currentPostfix].join('-'):['tabControll',prefix,currentStatus].join('-');
        var newClass=(postfix)?['tabControll',prefix,status,postfix].join('-'):['tabControll',prefix,status].join('-');
//console.log([currentClass,newClass]);

        if(targetTab.hasClass(currentClass)){
//console.log("removeClass "+currentClass);
            targetTab.removeClass(currentClass);
        }
        if(!(targetTab.hasClass(newClass))){
//console.log("addClass "+newClass);
            targetTab.addClass(newClass);
        }
//console.log(document.getElementById('tab_'+tix));
        targetTab.prop("disabled", (documentId == tix));
        if(tix==(this.documents.length-1)){
            var endTab = $('#tab_end');
            var curreentEndClass = (currentStatus=='active')? 'tabControll-end-active':'tabControll-end-deactive';
            var newEndTabClass   = (status=='active')?     'tabControll-end-active':'tabControll-end-deactive';
            if(endTab.hasClass(curreentEndClass)){
                endTab.removeClass(curreentEndClass);
                endTab.addClass(newEndTabClass);
            }else{
                endTab.addClass(newEndTabClass);            
            }
        }
    }
    if(this.activeDocumentId != documentId) {
        this.documents[documentId].activate()
    }
    if(xUI.activeDocumentId > 0){
        if ($('#xmap').isVisible()){$('.xpst').show();$('.xmap').hide();}
    }else{
        if (!($('#xmap').isVisible())){$('.xpst').hide();$('.xmap').show();}
    }
    if((xUI.activeDocumentId > 0)&&(xUI.delayRefreash)){
        xUI.delayRefreash = false;
        xUI.resetSheet();
    }else{
        xUI.adjustSpacer();
    }
    sync('productStatus');
    return this.activeDocumentId;
}



//ステージチャート表示UI
xUI.stageChart = {};
//xUI.stageChart.
/**
    xUI.parsePathString
    URL文字列をチェックして、相対パスの解決をする
    /^[a-zA-Z]+:\/\/.+$/  URI書式のデータ　→　処理不要・そのまま返す
    /^(\/[^\/]+|\\[^\\]+|[a-zA-Z]:\\)/ ローカルファイルでかつフルパス(ルートからのパス)で記載されている　→　処理不要・そのまま返す
    /^\\\\.+/ windows UNCパス
*/
xUI.parsePath = function(pathString,baseURL){
//console.log(baseURL);
    if (! baseURL) baseURL = document.location.toString();
    if ((URL)&&(! (baseURL.match(/^[a-zA-Z]+:\/\/.+$/)))) baseURL = new URL(baseURL,document.location);
    if (URL) return new URL(pathString,baseURL);
    return new nas.File(pathString,baseURL);
}
/**
 *   カット番号ルーラーに値をセットする
 *  @params {number} value
 *       設定する値（配列可）
 *  @params {number} max
 *      最大値
 * maxの数が少ないとき10分割では目盛りの不整合が発生するので、しきい値以下の際に目盛りの数値を調整
 * 値が範囲外のときはマーカーを非表示
 */
xUI.setRuler = function setRuler(value,max){
if(!(document.getElementById('sliderCount'))) return;
    var currentValue = $('#sliderCount').text().split('/');
    if(!value) value = currentValue[0];
    if(!max)   max   = currentValue[1];
    var newValue = [value,max].join('/');
    if($('#sliderCount').text() != newValue){
        $('#sliderCount').text(newValue);
        if(currentValue[1]!= max){
            $('#sliderRuler-MAX').html($('#sliderRuler-MAX').html().replace(/^\s*\d+/,' '+max));
            for (var sid = 1 ; sid < 10 ; sid++){
//しきい値を設定
                var thl = 50;
                var rulerNum = max * (sid/10);
                if(max > thl){
                    rulerNum = Math.round(rulerNum);
                }else{
                    rulerNum =(rulerNum % 1 > 0)? "":rulerNum;
                }
                
                $('#sliderRuler-'+sid).text(rulerNum);
            }
        }
        if((currentValue[0]/currentValue[1]) != (value/max)){
            if((value <= 0)||(value > max)){
                $('#sliderRunner').hide();
            }else{
                var startOffset  = $('#sliderRuler-0').offset();
                var right = $('#sliderRuler-MAX').offset().left;
                if(!$('#sliderRunner').is(':visible'))$('#sliderRunner').show();
                $('#sliderRunner').css('left',((100*value)/max)+'%');
            }
        }
    }
}
/**
    カレントノード表示・セレクタ出力
    2020.06.11現在出力のみ
    ＊閲覧編集操作のためのポインタとしての役割を持つので
    カレントノード変数をドキュメントのカレントノード以外に
    アプリケーションレベルの操作一時変数として置いたほうが良い
    タイムシートドキュメントのカーソルと同様
    xUI.Document.
*/
xUI.setNodeSelector = function(){
//ライン
    var lineListContent = '';
    for(var lix = 0; lix < xUI.XMAP.pmu.nodeManager.lines.length ; lix ++){
        var currentLine = xUI.XMAP.pmu.nodeManager.lines[lix];
        lineListContent += '<span id = "boxLine_';
        lineListContent += currentLine.id.join('_');
        lineListContent += '" class = "nodeBox nodeBox-line ';
        if(currentLine===xUI.XMAP.pmu.currentNode.stage.parentLine){
            lineListContent += 'nodeBox-line_active';
        }else{
            lineListContent += 'nodeBox-line_compleated';//inactive?
        }
        lineListContent += '">';
        lineListContent += currentLine.toString(true)+'//';
        lineListContent += '</span>';
    }
    document.getElementById('lineList').innerHTML = lineListContent;
//ステージ
    var stageListContent = '';
    for(var six = 0; six < xUI.XMAP.pmu.currentNode.stage.parentLine.stages.length ; six ++){
        var currentStage = xUI.XMAP.pmu.currentNode.stage.parentLine.stages[six];
        stageListContent += '<span id = "boxStage_';
        stageListContent += currentStage.id;
        stageListContent += '" class = "nodeBox nodeBox-stage ';
        if(currentStage===xUI.XMAP.pmu.currentNode.stage){
            stageListContent += 'nodeBox-stage_active';
        }
        stageListContent += '">';
        stageListContent += currentStage.toString(true)+'//'+xUI.XMAP.pmu.currentNode.toString(true);
        stageListContent += '</span>';
    }
    document.getElementById('stageList').innerHTML = stageListContent;
//コンポジットライン
    var compLineContent = '';
    var compStageListContent = '';
    var compLine = xUI.XMAP.pmu.nodeManager.lines.composite;
    if(compLine){
        lineListContent += '<span id = "boxLine_';
        lineListContent += compLine.id.join('_');
        lineListContent += '" class = "nodeBox nodeBox-line ';
        lineListContent += 'nodeBox-line_active';
        lineListContent += '">';
        lineListContent += compLine.toString(true)+'//';
        lineListContent += '</span>';
//コンポジットステージ
        for(var six = 0; six < xUI.XMAP.pmu.nodeManager.lines.composite.stages.length ; six ++){
            var currentCompStage = xUI.XMAP.pmu.nodeManager.lines.composite.stages[six];
            compStageListContent += '<span id = "boxstage_comp_';
            compStageListContent += currentCompStage.id;
            compStageListContent += '" class = "nodeBox nodeBox-stage ';
            if(six == (xUI.XMAP.pmu.nodeManager.lines.composite.stages.length - 1)){
                compStageListContent += 'nodeBox-stage_active';
            }
            compStageListContent += '">';
            compStageListContent += six + ':TAKE-'+ (six+1);
            compStageListContent += '</span>';
        }
    }
    document.getElementById('compLine').innerHTML = compLineContent;
    document.getElementById('compStageList').innerHTML = compStageListContent;
}
/**
    UI上のxMapプロパティ表示部分
    @params {String|Array}  target
指定可能プロパティリストは以下

product
cutNo
inherit
stamp
stageSummary
posterPicture
assignment
assets
*/
xUI.setPropView = function(target){
    if (arguments.length <= 0) {
        target = ['all'];
    }
    if(! target instanceof Array) target = [target];
    for (var ix = 0 ;ix < target.length ; ix ++){
        switch(target[ix]){
        case 'product':
            this.updateProduct();
        break;
        case 'cutNo':
            this.updateCutBox();
        break;
        case 'inherit':
            this.updateInherit();
        break;
        case 'stamp':
            this.drawManagementSummary();
            this.updateManagementSummary();
        break;
        case 'managementStatus':
            this.drawManagementSummary();
            this.updateManagementSummary();
        break;
        case 'posterPicture':
            this.updateupdatePosterPicture();
        break;
        case 'assignment':
            this.updateAssignment();
        break;
        case 'assets':
            this.viewAssetBrowser();
        break;
        default:
        }
    }
}
/**
    画面上のプロダクト情報を更新 title|product
    @params {Object xMap}   targetXMAP
    @returns    {Object}
        プロダクト情報オブジェクト
*/
xUI.updateProduct=function(targetXMAP){
    if (! targetXMAP) targetXMAP = this.XMAP;
    document.getElementById('productBox_title').innerHTML    = (targetXMAP.pmu.title instanceof nas.Pm.WorkTitle)?targetXMAP.pmu.title.fullName :String(targetXMAP.pmu.title);
    document.getElementById('productBox_epNo').innerHTML     = (targetXMAP.pmu.opus instanceof nas.Pm.Opus)? targetXMAP.pmu.opus.name:String(targetXMAP.pmu.opus);
    document.getElementById('productBox_subtitle').innerHTML = targetXMAP.pmu.subtitle;
    return targetXMAP.pmu.product;
}
/**
    画面上のカット番号情報を更新 inherit|cut
    @params {Object xMap}   targetXMAP
    @returns    {Object}
        プロダクト情報オブジェクト
*/
xUI.updateCutBox=function(targetXMAP){
    if (! targetXMAP) targetXMAP = this.XMAP;
    document.getElementById('cutBox_epNo').innerHTML      = '<span class=xmap_productNumberSign># </span>' + ((targetXMAP.pmu.opus instanceof nas.Pm.Opus)? targetXMAP.pmu.opus.name:String(targetXMAP.pmu.opus));
    document.getElementById('cutBox_cutNumber').innerHTML = targetXMAP.pmu.inherit[0].toString();
    return targetXMAP.pmu.inherit[0];
}
/**
    画面上の兼用情報を更新 inherit|cut
    @params {Object xMap}   targetXMAP
    @returns    {Object}
        兼用情報オブジェクト
*/
xUI.updateInherit=function(targetXMAP){
    if (! targetXMAP) targetXMAP = this.XMAP;
    var inheritContent = "";
    for (var ix = 0 ; ix < targetXMAP.pmu.inherit.length; ix ++){
        inheritContent += '<div id = "sciBox_' + String(ix);
        inheritContent += '" class = "productInherit">';
        inheritContent += targetXMAP.pmu.inherit[ix].toString();
//        if(targetXMAP.pmu.inherit[ix].time) inheritContent += '( '+ targetXMAP.pmu.inherit[ix].time +' )';
        inheritContent += '<button class ="xmap_property_edit iconButton-editItem"></button>';
        inheritContent += '</div>';
    }
    if(targetXMAP.pmu.inherit.length < 3){
        for (var ix = targetXMAP.pmu.inherit.length ; ix < 3; ix ++){
            inheritContent += '<div id = "sciBox_' + String(ix);
            inheritContent += '" class = "productInherit">';
        inheritContent += '<button class ="xmap_property_edit iconButton-addItem"></button>';
            inheritContent += '</div>'
        }
    }
    document.getElementById('inheritBox').innerHTML      =   inheritContent;
    return targetXMAP.inherit;
}
/**
    画面上の指定情報を更新 memo|
    @params {Object xMap}   targetXMAP
    @returns    {String}
        処理指定テキスト
*/
xUI.updateNoteArea=function(targetXMAP){
    if (! targetXMAP) targetXMAP = this.XMAP;
    var noteAreaContent = document.getElementById('noteArea_content').innerHTML;
//    var noteAreaContent = "";
        noteAreaContent += '<p>';
        noteAreaContent += targetXMAP.memo;
        noteAreaContent += '</p>';
        
//包括するXPSの現ステータスのnoteTextをすべて取得して合成する
    document.getElementById('noteArea_content').innerHTML      =   noteAreaContent;
    return $('#noteArea_content').text();
}
/**
    画面のサムネイル（posterPicture）を更新
    @params {Object xMap}   targetXMAP
    @returns    {String}
        URLテキスト
*/
xUI.updatePosterPicture=function(targetXMAP){
    if (! targetXMAP) targetXMAP = this.XMAP;
    var picGroup = targetXMAP.getElementGroupByName('posterPicture');//グループ取得に要置換
//console.log(picGroup instanceof nas.xMapGroup);
    if((picGroup instanceof nas.xMapGroup)&&(picGroup.elements.length)){
        var thumbnails = [];
        for (var eix = 0 ; eix < picGroup.elements.length ; eix ++){
            if(picGroup.elements[eix].content.source.file)
            thumbnails.push(xUI.parsePath(picGroup.elements[eix].content.source.file,xUI.XMAP.baseURL));//テスト用暫定コード
            /*本番用にはデータのベースロケーションとしてxMap.baseURLプロパティを置く*/
        }
        if(thumbnails.length){
            var htmlContent = "";
            for (var tix = 0;tix < thumbnails.length ; tix ++){
                htmlContent += '<img width=100% src="';
                htmlContent += thumbnails[tix];
                htmlContent += '">';
            };
console.log(thumbnails);
            document.getElementById("posterPicuture_content").innerHTML=htmlContent;
            return thumbnails.join();
        }
    }
    document.getElementById("posterPicuture_content").innerHTML="";
    return "<no picture>";
}
/**
 *	ステータス表示UIを更新
 *	（ノードチャート呼び出し|ジョブセレクタ|アサインメッセージ呼び出しUIを兼ねる）
 *    引数ナシ
 *    戻値ナシ
 */
xUI.updateStatus = function(){
	var currentNode  = xUI.XMAP.pmu.nodeManager.getNode();
	var currentStage = currentNode.stage;
	var currentLine  = currentStage.parentLine;

	var selectorContent = '<a class="dark" href="javascript:void(0);" onclick="xUI.sWitchPanel(\'NodeChart\')">';
	selectorContent += currentLine.toString(true);
	selectorContent += ' // ';
	selectorContent += currentStage.toString(true);
	selectorContent += '</a>';
	selectorContent += ' // ';
	selectorContent += '<select>';

	for (var j =0 ; j < currentStage.jobs.length ; j ++){
		selectorContent += '<option value="';
		selectorContent += currentStage.jobs[j].toString(true);
		selectorContent += '"';
		if(currentNode === currentStage.jobs[j]){
			selectorContent += 'selected >';
		}else{
			selectorContent += ' >';
		}
		selectorContent += currentStage.jobs[j].toString(true);
		selectorContent += '</option>';
	}
	selectorContent += '</select>';
	selectorContent += ' // ';
	selectorContent += (currentNode.jobStatus.content)? currentNode.jobStatus.content:'no-status';
	selectorContent += ' : ';
//ユーザがメッセージ閲覧可能な場合を後で判定
	if(
		(true)&&
		((currentNode.jobStatus.assign)||(currentNode.jobStatus.message))
	){
		selectorContent += '<button class="boxButton iconButton-message" onclick="alert(\'has message\')"></button>'
	}
		selectorContent += " ";

	document.getElementById("pmsui").innerHTML = selectorContent;
}
/**
    進行状況概要を描画
    @params {Object xMap}   targetXMAP
    @returns    {String}
        HTMLElementId-List
*/
/*
    [{label:{name},checkPoint:[targetList]},{label:{name},checkPoint:[targetList]}...]
*/
xUI.drawManagementSummary = function(targetXMAP){
    if (! targetXMAP) targetXMAP = this.XMAP;
    this.summaryGroup = [];
    for (var bix = 0; bix < nas.pmdb.pmTemplates.summary.length ; bix ++){
        var summaryLabel = nas.pmdb.pmTemplates.summary[bix].split('.');
        
        var eidx = this.summaryGroup.add(
            {name:summaryLabel[0],checkPoint:[]},
            function(a,b){return (a.name == b.name)}
        );
        this.summaryGroup[eidx].checkPoint.add(nas.pmdb.pmTemplates.summary[bix]);
    }
//<div id=stamp01_label class = stamp_label>演出</div>
//<div id=stamp02_label class = stamp_label>作画監督</div>
/*
<div class=stampBox>
<div id=stamp01_label class = stampBox_label>演出</div>
<div id=stamp01 class = stamp>{演出} </div>
</div>
*/
    var htmlContent = "";
    var boxCount = (this.summaryGroup.length < 6)? 6 : this.summaryGroup.length;
    for (var six = 0;six < boxCount ; six ++){
        htmlContent += '<div class="stampBox"><div id="stamp_'+six+'_label" class="stampBox_label">';
        htmlContent += (six < this.summaryGroup.length)? this.summaryGroup[six].name:"";
        htmlContent += '</div>';
        htmlContent += '<div id="stamp_'+six+'" class="stamp">';
        htmlContent += '</div></div>';
    }
    document.getElementById("stamp_container").innerHTML=htmlContent;
    return this.summaryGroup;
}

/**
 *  ステージ進行状況を描画
 *
 */
/*  ステージの進行状況は、ノードの状態を先に構築してから作成する
 *  マネジメントノードオブジェクトのツリー状態は、
 *  1.表示用のライン配列コレクションを作成
 *  2.各ラインごとにテンプレートから表示用配列を作成
 *  3.実際のステージ進捗をトレースして表示配列の置換、または挿入をおこなう
 *  表示配列は、ノードツリーの表示にも利用されるので、xUIのプロパティとして管理する
 */
xUI.nodeChart = {
    selectedLine:"",
    selectedNode:"",
    setChart:null
};
/*
	ノードチャート出力
	(ノードセレクターを兼ねる)
	@params	{Array}	chart
	チャート配列を与える
	チャート配列の要素はラインチャートオブジェクト
	{
		name:<ライン識別名>,
		manager: [<UserInfo>,<Date>],
		staff: [<UserInfo>,<Date>],
		user: [<UserInfo>,<Date>],
		stages: [
			{
				name:<ステージ識別名>,
				nodes:[
					{
						name:<ジョブ識別名>,
						token:<アクセストークン>
					}...
				]
			}...
		],
		stageOffset;0,
		status: JobStatus {content: "Fixed", assign: "", message: "", stageCompleted: false}
	} 
*/
xUI.nodeChart.setChart = function(compChart){
	if(! compChart) compChart = xUI.XMAP.pmu.nodeManager.getChart();
//第一レコード以降を分離
    var chart = compChart.slice(1);
//最小テーブル幅を６フィールド分確保
	var chartWidth  = (chart.length < 5) ? 6 : (chart.length + 1);
	var chartHeight = 0;//0で初期化する
//最小テーブル高をラインテンプレートの工程数+
/*
	高さは、(ラインラベル+最多工程ラインの工程数)× 2 + 1
	各ラインの工程数は、テンプレートの工程と実施済み工程を比較して表示用のテーブルをビルドして導く
	「テンプレート工程数-(テンプレート内実施工程数)+(実施工程数)」であるが、単純な計算はできない

	高さ検出の際にノード(ステージ)ラベルを記録
	同時に以下を判別して記録 
	エントリ種別	既設|予定|ブランク　{String} completed|active|hold|aborted|no_started|blank
	後続罫線種 はエントリ種別よって変化する blank|conect|branch|down|through|through_down|head
	等を先行して判定する
*/
	var tableStages = new Array(chart.length);//バッファ配列
/* 配列メンバー 無名オブジェクト
	{
		id:{String:<lindex>_<sindex>},
		name:{String},
		stage:{null | object Stage | object},
		status:{String:completed|active|hold|aborted|no_started|blank},
		flow:{String:blank|conect|branch|down|through|through_down|head}
	}
	
*/
//console.log(chart);
	for (var l = 0 ; l < chart.length ; l ++ ){
		tableStages[l] = [];//空配列
		var stageOffset = parseInt(chart[l].stages[0].name.split(':')[0]);//chart[l].stageOffset;
		chart[l].stageOffset = stageOffset;
//チャート出力からステージ配列を作成
		for (var s =0 ;s < chart[l].stages.length ; s ++ ){
			var stageStatus = 'completed';
			if(( s == (chart[l].stages.length-1))&&( chart[l].status.content != 'Completed')) stageStatus = 'active';
			var flowLine = 'conect';
			if(stageStatus == 'active') flowLine = 'head';
			tableStages[l][s+chart[l].stageOffset] = {
				id:[l,s+chart[l].stageOffset].join('_'),
//ステージ識別名のみのコピー
				name:(chart[l].stages[s].name),
				stage:chart[l].stages[s],
				status:stageStatus,
				flow:flowLine
			}
//分岐後の第一ステージだった場合、先行するノードを登録して親ラインまでの罫線ステータスを変更する
			if((s==0)&&(chart[l].stageOffset > 0)){
				var prevStg = chart[l].stageOffset-1;
//先行ノードを登録(先行ノードが存在する場合もあるのでベタ書きは不可)
				if(tableStages[l][prevStg]){
					if(tableStages[l][prevStg].flow == 'through')
					tableStages[l][prevStg].flow = 'through_down';
				}else{
//先行ノードが存在しない場合は、先行ノードを作成して分岐に衝突するまでプロパティの更新を行う
					tableStages[l][prevStg] = {
						id:[l,prevStg].join('_'),
						name:'<change>',
						stage:null,
						status:'blank',
						flow:'down'
					};
					for (var rv = l-1 ; rv >= 0 ; rv --){
						if(tableStages[rv][prevStg]){
//分岐点ヒット
							if(tableStages[rv][prevStg].flow == 'down'){
								tableStages[rv][prevStg].flow = 'through_down';
							}else{
								tableStages[rv][prevStg].flow = 'branch';
							}
							break;
						}else{
//空白エントリなのでブランクエントリを投入
							tableStages[rv][prevStg] = {
								id    : [rv,prevStg].join('_'),
								name  : '',
								stage : null,
								status: 'blank',
								flow  : 'through'
							};
						}
					}
				}
			}
		}
		var lastStageName = chart[l].stages[chart[l].stages.length -1].name.split(':')[1].replace(/^\(|\)$/g,'');
		var lastStage     = nas.pmdb.stages.entry(lastStageName);
		var lineName      = chart[l].name.split(':')[1].replace(/^\(|\)$/g,'');//ライン名抽出
		var lineTempalte  = nas.pmdb.pmTemplates.entry(lineName);
		if((lineTempalte)&&(lastStage)){
			var templateStages = lineTempalte.stages.dump().split(',');//該当ラインテンプレートのデフォルトステージ配列で初期化する
			var ix = templateStages.findIndex(function(element){
				return (lastStage.output == nas.pmdb.stages.entry(element).output)
			});
			if(ix >= 0){
				var newNodes = [];
				var templates = templateStages.slice(ix+1);
				for (var tx = 0 ; tx < templates.length ; tx ++){
					newNodes.push({
						id:[l,ix+tx].join('_'),
						name:templates[tx],
						stage:null,
						status:'no_started',
						flow:'blank'
					});
				}
				tableStages[l] = tableStages[l].concat(newNodes);
			}
		}
		if(tableStages[l].length > chartHeight) chartHeight = tableStages[l].length;//最大数をチャートハイトに
	};
//ループ終了時にチャート高さを補正(基本的にはこの判定はfalse)
	if(chartHeight < compChart[0].stages.length) chartHeight = compChart[0].stages.length;
//チャート配列
	var tableContent = "";
// ======ノードセレクタテーブルを出力======
	tableContent += "<table id='nodeFlow-chart' class='nodeFlow-chart'>";
//ラインセレクタ兼用　ラインラベルレコード
    tableContent += "<tr>";
	for (var f = 0 ; f < chartWidth ; f++){
		if(f < chart.length){
			tableContent += "<td ";
			tableContent += "id = 'nodeFlow_line_"+f+"_' ";
			tableContent += "onclick='alert(this.id)' ";
			tableContent += "class='nodeFlow nodeFlow-line";
			tableContent += (f==0)? " nodeFlow-line-selected' >":"' >";
			tableContent += chart[f].name
			tableContent += "</td>";
		}else{
			tableContent += "<td  class='nodeFlow' ></td> ";//blank
		}
	}
    tableContent += "<td  class='nodeFlow' ></td>";//blankfield
    tableContent += "<td  class='nodeFlow nodeFlow-composite' >"+compChart[0].name+"</td>";//
    tableContent += "</tr>";

//スタートアップ　ルートレコード
    tableContent += "<tr>";
	for (var f = 0 ; f < chartWidth ; f++){
		if(f==0){
			tableContent += "<td  class='nodeFlow nodeFlow-startup' ></td>";
		}else{
			tableContent += "<td  class='nodeFlow nodeFlow-blank' ></td>";
		}
	}
    tableContent += "<td  class='nodeFlow' ></td>";//blankfield
    tableContent += "<td  class='nodeFlow' ></td>";//ライン先頭のノード表示は削除
    tableContent += "</tr>";
//フローチャートテーブル配置

//ラインループ
	for (var l = 0 ; l < chartHeight ; l ++){
		tableContent += "<tr>";
//フィールドループ
		for (var f = 0 ; f < chartWidth ; f++){
			var nodeId     = 'node_'+f+'_'+l+'_';
//			if((chart[f])&&(chart[f].stages[l-chart[f].stageOffset])&&(tableStages[f][l].status!='blank')){}
			if((tableStages[f])&&(tableStages[f][l])&&(tableStages[f][l].status!='blank')){
//処理済エントリ
				var satusClass = 'node-stage-'+tableStages[f][l].status;
				tableContent += "<td id='"+nodeId+"' class='nodeFlow nodeFlow-stage' ><button id='btn-";
				tableContent += nodeId;
				tableContent += "' class='node-stage " +satusClass+ "' onclick = 'alert(this.id)' >";
				tableContent += tableStages[f][l].name;
				tableContent += "</button></td>";
			}else{
				var conectForm = 'nodeFlow-blank';
				if((tableStages[f])&&(l == tableStages[f].length)){
					if (tableStages[f][l-1].flow != 'head'){
						conectForm = 'nodeFlow-'+tableStages[f][l-1].flow;
						tableStages[f][l] = {flow:tableStages[f][l-1].flow};
					}
				}
				tableContent += "<td  class='nodeFlow "+conectForm+"' ></td> ";//blank
			}
		}
//後方
		tableContent += "<td  class='nodeFlow' ></td>";//blankfield
		var cmpStg = (compChart[0].stages[l])?compChart[0].stages[l].name:'';
		var cmpStatus = (cmpStg.length)? 'reference':'';
		tableContent += "<td  class='nodeFlow nodeFlow-blank' ><button class='node-composite"+((cmpStatus.length)?(" node-composite-"+cmpStatus):"")+"'>"+cmpStg+"</button></td>";//
		tableContent += "</tr>";
//サブレコード（罫線）
		tableContent += "<tr>";
//フィールドループ
		for (var f = 0 ; f < chartWidth ; f++){
			var nodeId     = 'xnode_'+f+'_'+l+'_';
			var conectForm = '';
			if((tableStages[f])&&tableStages[f][l]) conectForm = 'nodeFlow-'+tableStages[f][l].flow;
			tableContent += "<td id ='"+nodeId+"' class='nodeFlow "+conectForm+"' ></td>";//ひとまず罫線ナシ
		}
//後方
		tableContent += "<td  class='nodeFlow' ></td>";//blankfield
		tableContent += "<td  class='nodeFlow nodeFlow-blank' ></td>";//ひとまず罫線ナシ
		tableContent += "</tr>";
	}

//素材プール分
	tableContent += "<tr>";
	tableContent += "<td  class='nodeFlow nodeFlow-store' colspan=";
	tableContent += chartWidth;
	tableContent += "><button id=elementStore class='node-stage node-stage-elementStore'>素材プール</button></td>";
	tableContent += "<td  class='nodeFlow' ></td>";
	tableContent += "<td  class='nodeFlow nodeFlow-blank' ><button id=node_0_ class='node-composite'></button></td>";
	tableContent += "</tr>";

	tableContent += "</table>";
	document.getElementById('nodeSelector').innerHTML = tableContent;
}
/*TEST
xUI.nodeChart.setChart(xUI.XMAP.pmu.nodeManager.getChart());
// */

/*ノードリストを更新*/
xUI.updateNodeList = function(pmUnit){
    if(!pmUnit) pmUnit = xUI.XMAP.pmu;
    if(!(pmUnit instanceof nas.Pm.PmUnit)) return false;
    var result = '';
//lineloop
    for (var l = 0; l < pmUnit.nodeManager.lines.length ; l++){
        var targetLine = pmUnit.nodeManager.lines[l];
        var lastNode = targetLine.getLastNode();
    if (l < 2) result += '<div class="nodeList_line">';
//LINE TABLE
    result += '<table class="nodeListTable">';
    result += '<tr class="flatTable flatTable-header" width=35%>';
    result += '<th class=flatTable>LINE</th>';
    result += '<td class=flatTable>'+targetLine.toString(true)+'</td>';
    result += '</tr><tr>';
    result += '<th class=flatTable>作業開始</th>';
    result += '<td class=flatTable>'+targetLine.stages[0].jobs[0].createDate.toLocaleDateString()+'</td>';
    result += '</tr><tr>';
    result += '<th class=flatTable>作業更新</th>';
    result += '<td class=flatTable>'+lastNode.updateDate.toLocaleDateString()+'</td>';
    result += '</tr>';
    result += '</table>';

    result += '<table class="nodeListTable">';
//stageloop
  for (var s = 0; s <pmUnit.nodeManager.lines[l].stages.length ; s++){
      var targetStage = pmUnit.nodeManager.lines[l].stages[s];
//JOB LIST by STAGE
    result += '<tr class="flatTable flatTable-header">';
    result += '<th class="flatTable flatTable-stageName" colspan=2>'+targetStage.toString(true)+'</th>';
    result += '</tr>'
//nodeloop
  for (var n = 0; n < pmUnit.nodeManager.lines[l].stages[s].jobs.length ; n++){
      var targetNode = pmUnit.nodeManager.lines[l].stages[s].jobs[n];
      var dt;var nm;
    result += '<tr class="nodeList">';
//状態は2値tail|body
      if( targetNode === lastNode){
          dt = targetNode.createDate.toLocaleDateString();
          nm = (targetNode.createUser instanceof nas.UserInfo)? targetNode.createUser.toString('handle'):targetNode.createUser;
    result += '<th class="flatTable flatTable-jobName">'+targetNode.toString(true)+'</th>';
    result += '<td class="flatTable flatTable-checkin">'+[dt,nm].join(' / ')+'</td>';
      }else{
          dt = targetNode.updateDate.toLocaleDateString();
          nm = (targetNode.updateUser instanceof nas.UserInfo)? targetNode.updateUser.toString('handle'):targetNode.updateUser;
    result += '<th class="flatTable flatTable-jobName" width=35%>'+targetNode.toString(true)+'</th>';
    result += '<td class="flatTable flatTable-checkout">'+[dt,nm].join(' / ')+'</td>';
          
      }

//    result += '</tr><tr>';
//    result += '<th class="flatTable flatTable-jobName">[演出検査]</th>';
//    result += '<td class="flatTable flatTable-checkin">2020.04.11 / {スタッフ名}</td>';
//    result += '</tr><tr class="nodeList">';
//    result += '<th class="flatTable flatTable-jobName-hns">[作監]</th>';
//    result += '<td class="flatTable flatTable"></td>';
//    result += '</tr><tr class="nodeList">';
//    result += '<th class="flatTable flatTable-jobName-hns">[総作監]</th>';
//    result += '<td class="flatTable flatTable"></td>';
    result += '</tr>';
  };//loop-jobs

  };//loop-stages
    result += '</table>';
//    result += '<br>';
    if((l==0)||(l==(pmUnit.nodeManager.lines.length-1))) result += '</div> ';//nodeList_line
    };//loop-lines
    $('#nodeList').html(result);
    return result;
}
/*TEST
    
*/
/**
 *   アセットブラウザ代表オブジェクト
 looksは、表情状態を記録する配列
    [elementThumbnail,assetURL,assetProperties]
 */
xUI.assetBrowser = {
    tabCount : 0,
    selected : 0,
    looks:[true,false,false]
}
/*  アセットブラウザのタブを書き直す
    @params {Array of Asset}    assets
*/
xUI.assetBrowser.reset = function(assets){
    if(typeof assets == 'undefined') assets = xUI.XMAP.assetStore;
    var content = '';
    for (var aix=0;aix<assets.length;aix++){
        content += '<button id ="asset_'+aix+'"';
        content += ' class ="tabControll tabControll-xmap '
        content += (aix==0)? 'tabControll-left-deactive"':'tabControll-mid-deactive"';
	    content += ' onClick = "xUI.assetBrowser.select(this.id);" >';
        content += assets[aix].name;
        content += '</button>';
    }
    content += '<button id="asset_end" class="tabControll tabControll-end tabControll-end-deactive" ></button>';
    
    $('#tabSelector-asset').html(content);
    this.select(assets.length-1);
}
/*  アセットブラウザのアセットリストを選択する
    @params {String assetKey}    asset
    アセットキーは　整数　または　asset_<No.>
*/
xUI.assetBrowser.select = function(asset){
    if(typeof asset == 'undefined'){
        asset = xUI.XMAP.assetStore.length-1;
    }
    if(String(asset).indexOf('asset_') == 0) {
        asset = asset.replace(/^asset_/,'');
    }
    asset = parseInt(asset);
//タブループ
    for (var tix=0;tix<xUI.XMAP.assetStore.length; tix++){
        var targetTab = $('#asset_'+tix);
        var prefix=(tix==0)?'left':'midd';
        var currentStatus=(tix==this.selected)?'active':'deactive';
        var status=(tix==asset)?'active':'deactive';
        var currentPostfix=((prefix=='mid')&&(currentStatus=='deactive')&&(tix-1!=this.selected))?'overlay':false;
        var postfix=((prefix=='midd')&&(status=='deactive')&&(tix-1!=asset))?'overlay':false;
        var currentClass=(currentPostfix)?['tabControll',prefix,currentStatus,currentPostfix].join('-'):['tabControll',prefix,currentStatus].join('-');
        var newClass=(postfix)?['tabControll',prefix,status,postfix].join('-'):['tabControll',prefix,status].join('-');
        if(tix==(xUI.XMAP.assetStore.length-1)){
            var endTab = $('#asset_end');
            var curreentEndClass = (currentStatus=='active')? 'tabControll-end-active':'tabControll-end-deactive';
            var newEndTabClass   = (status=='active')?     'tabControll-end-active':'tabControll-end-deactive';
            if(endTab.hasClass(curreentEndClass)){
                endTab.removeClass(curreentEndClass).addClass(newEndTabClass);
            }else{
                endTab.addClass(newEndTabClass);            
            }
        }
        if(targetTab.hasClass(currentClass)){
            targetTab.removeClass(currentClass).addClass(newClass);
        }else{
            targetTab.addClass(newClass);            
        }
    }
    if(this.selected != asset) {
        this.selected = asset;
        $("#assetList").html(xUI.assetView(xUI.XMAP.assetStore[asset]));//画面書き直し
        this.setLook();
    }
}
/**
    ルックを調整
*/
xUI.assetBrowser.setLook = function(looks){
    if(typeof looks == 'undefined') looks=this.looks;
    if(!(looks instanceof Array)){
        switch(looks){
        case "elementThumbnail":    this.looks.splice(0,1,(arguments[1]));break;
        case "assetURL":            this.looks.splice(1,1,(arguments[1]));break;
        case "assetProperties":     this.looks.splice(2,1,(arguments[1]));break;
        }
        looks = this.looks;
    }
        for(var lkix = 0;lkix < looks.length;lkix++){
            switch (lkix){
            case 0:$('.elementThumbnail').css('display',((looks[lkix])?'block':'none')) ;break;
            case 1:$('.assetURL').css(        'display',((looks[lkix])?'inline':'none')) ;break;
            case 2:$('.assetProperties').css( 'display',((looks[lkix])?'block':'none')) ;break;
            }
        }
        if((looks[1])||(looks[2])){
            $('.groupColumn').css('width','460px');
        }else{
            $('.groupColumn').css('width','160px');
        }
        this.looks = looks;
        return looks;
}
/**
 *   アセットブラウザの表示１単位（１ページ）分のhtmlを出力する
 *  
 *  @params {Object nas.xMapAsset} asset
 *  @params {String | Object nas.Pm.ManagementJob}  job
 *  @returns    {String}    htmlテキスト
 */
xUI.assetView = function(asset,job){
    if(! asset) return '<!-- no asset　-->';
    if(! job)job = asset.groups
//表示用配列を設定（同名グループはひとつのカラムで合成表示する）
    var assetGroups=[];
    for (var gix=0;gix<asset.groups.length;gix ++){
        var px = assetGroups.length;
        var ax = assetGroups.add({
            name:asset.groups[gix].name,
            contents:[asset.groups[gix]]
        },function (tgt,dst){return (tgt.name == dst.name)});
//        if(ax < px){assetGroups[ax].contents.push(asset.groups[gix])};
        if(px == assetGroups.length){
console.log(asset.groups[gix].name + ': 衝突検出');
            assetGroups[ax].contents.push(asset.groups[gix]);
        };
    }
console.log(assetGroups)
    var result = '';//<!-- asset　container -->
        result += '<div id ="asset_' + 0 +'" class ="assetTab">';
//        result += '<!-- group container -->';

//    for (var gix=0;gix<asset.groups.length;gix ++){}
    for (var gix=0;gix<assetGroups.length;gix ++){
    for (var ggx=0;ggx<assetGroups[gix].contents.length;ggx ++){
        var group = assetGroups[gix].contents[ggx];
        result += '<div id ="group_'+ group.id +'" class ="groupColumn">';

        result += '<div id ="group_'+ group.id +'_label" class ="groupLabel">';
        result += '<label for ="select_g_'+ group.id +'">';
        result += '<input type ="checkbox" id ="select_g_'+ group.id +'">';
        result += '<span id="group_'+ group.id +'_name" class="groupName" >'
        result += group.name;//group label
        result += '</span></label><hr></div>';

        result += '<div id = "group_'+ group.id +'_content">';
//        result += '<!-- assetElement container -->';
        for (var eix = 0;eix < group.elements.length;eix ++){
            var element = group.elements[eix];
            var elementIdf = [group.id,element.id].join('_');
console.log(element);
            var elementPicture = (element.content.source)?
xUI.parsePath(element.content.source.file,xUI.XMAP.baseURL):
                false;//暫定置き換えパス
            result += '<div class ="elementContainer noFileAssign" >';
            if(elementPicture){
                result += '<img class ="elementThumbnail" id ="thumbnail_elm_'+elementIdf+'" src="';
                result += elementPicture;//asset picuture url
                result += '" alt ="';
                result += element.name ;//asset picture alt text
                result += '" title ="';
                result += 'title text';//asset picture title text
                result += '">';
            }else{
                result += '<div class="elementThumbnail"> no picture </div>';
            }
            result += '<img class=assetAssign src=/images/ui/file.png >';
            result += '<label for="select_elm_'+elementIdf+'">';
            result += '<input type = checkbox id="select_elm_'+elementIdf+'">';
            result += '<span class=assetName id="elm_'+elementIdf+'" >'+ element.name +'</span>';
            result += '</label>';

            result += '<span class=assetURL>';
            result += '<button ><img src="/images/ui/triangle.png"></button>';
            
            result += (elementPicture)?
                ('<a href="'+elementPicture+'" target="_new">'+elementPicture+'</a>'):
                 'no picture';
            result += '</span><br>';

            result += '<span class="assetProperties">';
            result +=  element.toString();//*---- asset properties <br><br><br>
            result += '</span><hr>';
            result += '</div>';

//        result += '<!-- group container end-->';
        };// asset group container
//        result += '<!-- assetElement container end-->';
        result += '<div class = endSign> end </div>';
        result += '</div>';
        result += '</div>';
    }
    };//グループコンテナ
    return result;
}
//TEST
 /*
xUI.XMAP.parsexMap(startupDocument);
xUI.setRuler(24,48);
xUI.updateProduct();
xUI.updateCutBox();
xUI.updateInherit();
xUI.updateNoteArea();
xUI.updatePosterPicture();
xUI.drawManagementSummary();
xUI.assetBrowser.reset();
xUI.updateNodeList();
//xUI.();
//xUI.documents[0].activate();
// */

/*
    仮設（デバッグ用）xMapLook
*/
xUI.resetReceipt = function(){
/*    if(documentDepot.currentProduct){
        xUI.setRuler(
            documentDepot.currentProduct.stbd.contents.findIndex(function(element){
                return(nas.Pm.compareCutIdf(element.sci.name,xUI.documents[0].content.pmu.inherit[0].name)==0)
            })+1,
            documentDepot.currentProduct.stbd.contents.length
        );
        
    }else{
        xUI.setRuler(-1,1);
    };// */
    xUI.nodeChart.setChart()   ;
    xUI.updateProduct()        ;
    xUI.updateCutBox()         ;
    xUI.updateInherit()        ;
    xUI.updateNoteArea()       ;
    xUI.updatePosterPicture()  ;
    xUI.drawManagementSummary();
    xUI.updateNodeList()       ;
    xUI.assetBrowser.reset()   ;
// タブを
    xUI.updateStatus()    ;//ステータス表示を更新
    xUI.setNodeSelector() ;//ノードセレクタを更新
}
/*
    仮設（デバッグ用）画面更新
*/
xUI.resetScreen = function(){
    if(xUI.activeDocument)
        if(xUI.activeDocument.id == 0){
            xUI.resetReceipt();
        }else{
            xUI.resetSheet();
        }
    xUI.sWitchPanel('clear');
    if (xUI.XMAP.pmu.checkinNode){
        xUI.setUImode('production');
    }else{
        
    }
}

//オブジェクト戻す
	return xUI;
};

