/**
 * @fileOverview
 *  <pre>P-man本体スクリプト
 * </pre>
 */
// http://d.hatena.ne.jp/amachang/20071010/1192012056 //
/*@cc_on _d=document;eval('var document=_d')@*/
'use strict';
/*================================================================================================ 
 *  アプリケーションスタートアップ
 *
 *   スタートアップを他の位置へまとめる必要があるかも
 *   リロードの際に一度だけ自校される部分
 */
//始動オブジェクトとして空オブジェクトで初期化する スタートアップ終了までのフラグとして使用
var xUI         =new Object();
    xUI.Mouse   =function(){return};
    xUI.onScroll=function(){return};

//    オブジェクト初期化用ダミーマップ
//    var MAP=new xMap(MaxLayers);
//    新規XPSオブジェクト作成・初期化
//    var XPS          = {} ;//ダミーオブジェクトとしてグローバル変数を初期化
//    var XMAP         = {} ;//ダミーオブジェクトとしてグローバル変数を初期化
    xUI.activeNode   = null ;//表示・編集対象のノードオブジェクト .pmdbを持つ者はすべてノードたりえる
    xUI.XMAP         = {} ;//ダミーオブジェクトとしてXMAPバッファを初期化
    xUI.XPS          = {} ;//ダミーオブジェクトとしてXPSバッファを初期化
    xUI.PMDBroot     ;//編集中のストレージルート(String ローカルパス) eg: /Users/Shared/workStorage
    xUI.PMDBcurrent  ;//編集中のPMDB(String ストレージルートから先のパス)eg: /Nekomataya/momotaro/mom#02
/*
    編集対象のPMDBは、nas.pmdbを直叩きする？
編集アドレスパスが発生する
:server:repository:title:episode
アドレス保持用配列を持たせる
targetMap = [
    servers:[
        server:{
            name:<name>,
            serviceurl:<url>,
            repositories:[
                {
                    name:<name>,
                    token:<token>,
                    titles:[
                        {
                            name:<name>,
                            token:<token>,
                            episodes:[
                            ]
                        }
                    ]
                }....
            ]
        }...
    ]
]
*/

//コード読込のタイミングで行う初期化
/*
    debud output
 */
function dbgPut(aRg){
//    document.getElementById('msg_well').value += (aRg+"\n");
    if(console){if(dbg) console.log(aRg);}
}
function show_all_props(Obj){
    var Xalert="\n\tprops\n\n";
    for(var prop in Obj) Xalert+=(prop+"\t:\t"+Obj[prop]+"\n\n\n");
    dbgPut(Xalert);
}

function dbg_action(cmd){
    if(appHost.platform=="AIR"){
        document.getElementById('msg_well').value += (":"+aRg+"\n");
        return;
    }
//エラー発生時はキャプチャしてそちらを表示する
    var body="";
    try{body=eval(cmd);}catch(er){body=er;};
    document.getElementById('msg_well').value += (body+'\n');
//    if(console){if(dbg) console.log(body);}

}
/*
	アプリケーション開始時にjQuery-uiのtooltipを初期化するプロシジャ
	titleアトリビュートをツールチップ化する
	起動時に一回だけ実行 xUIの初期化前に実行されること
*/

var startupTooltip=function(){
    jQuery( function() {
        var myToolTips=["#"];
            for (var tid=0;tid<myToolTips.length;tid++){
                jQuery(myToolTips[tid]).tooltip( {
                    position: {
                        my: "center top",
                        at: "center bottom",
                        track:true,
                    }
                } );
            }
    } );
}
/** Startup手続き
 *    nas_pman_Startup
 *  プログラム及び全リソースをロード後に１回だけ実行される手続
 *  引数なし
 *
 *    nas_pman_reStart
 *  ページリロード等の際に実行される手続
 */
function nas_pman_Startup(){
console.log('application init : nas_pman_Startup !!');
//バージョンナンバーセット
    sync("about_");
//クッキーよりも優先でpmdb含むServiceの初期化を行う localRepositoryを含むリポジトリCollectionも初期化
//    localFilesystemService.init()
    localRepository.init();
    serviceAgent.init();
//クッキー指定があれば読み込む
//    if(useCookie[0]) ldCk();
//アプリケーションIdf設定（クッキーに存在しなければローカルストレージから読み出す）
    if(! ApplicationIdf){
      var ApplicationIdf = localStorage.getItem("info.nekomataya.pman.applicationIdf");
    }
console.log('application idf :' + ApplicationIdf);
    serviceAgent.applicationIdf = ApplicationIdf;
//ライブラリフレームレートの設定
    nas.FRATE=nas.newFramerate(myFrameRate);
//背景カラーを置換
    SheetLooks.SheetBaseColor="#eeffee";
//シートロゴをアップデート
/*
    応急処置
    ロケーションを確認して  開発／試験サーバ  であった場合はヘッダロゴ画像を差し替える -- 不要

if(location.hostname.indexOf("scivone-dev")>=0){
    headerLogo="<img src='/images/logo/UATimesheet_dev.png' alt='Nekomataya' width=141 height=24 border=0 />"
};
if(location.hostname.indexOf("remaping-stg")>=0){
    headerLogo="<img src='/images/logo/UATimesheet_staging.png' alt='Nekomataya' width=141 height=24 border=0 />"
};

    document.getElementById("headerLogo").innerHTML=
    "<a href='"+ headerLogo_url +
    "' title='"+ headerLogo_urlComment +
    "' target='_new'>"+ headerLogo +"</a>";
*/

//サービスCGIのアドレスを調整 Electron版では基本的に不要
//    if(String(location).indexOf('https')==0) {ServiceUrl=HttpsServiceUrl};

//    起動時に AIR環境で引数があれば引数を解釈実行する。
//同様のルーチンで  invorkイベントがあれば引数を解釈して実行するルーチンが必要
//実体はair_UI.jsxに
    
//    UI生成
    xUI=new_xUI();

//test タスクコントローラ起動
    startupTaskController();

};
//
/** アプリケーションUIをリセットする手続き
*/
function nas_pman_Init(){
    var startupWait=false;
    console.log(nas.pmdb)

};

/*
    ページ再ロード前に必要な手続群
*/
function nas_pman_reStart(evt){
//applicationIdfをローカルストレージに保存
    if(serviceAgent.applicationIdf) localStorage.setItem("info.nekomataya.pman.applicationIdf",serviceAgent.applicationIdf);
//    クッキーを使用する設定なら、現在のデータをビルドしてクッキーかき出し
    if (useCookie[0]) {
        writeCk(buildCk());
    };
};

/*
    sync UI表示同期プロシジャ
オンメモリの編集バッファとHTML上の表示を同期させる。キーワードは以下の通り
*/
function sync(prop){
if (typeof prop == 'undefined') prop = 'NOP_';
    switch (prop){

case    "NOP_":    ;
    break;
default    :    if(dbg){dbgPut(": "+prop+" :ソレは知らないプロパティなのです。");}
    }
//windowTitle及び保存処理系は無条件で変更
    if(xUI.activeDocument){
    }else{
console.log('xUI は初期化前: yet init xUI');
    }
//
}

/*                        ----- io.js
*/
/**
    テキストエリアに値を挿入する編集メソッド
    クリックの発生したエレメントの値 をinsertTargetのinsertメソッドに渡しフォーカスを移す
*/
var editMemo=function(e,insertTarget){
    var myTarget=e.target;
    if(
    (myTarget instanceof HTMLInputElement)||
    (myTarget instanceof HTMLButtonElement)
    ){
        var myValue=(myTarget.value)?myTarget.value:myTarget.innerHTML;
        insertTarget.insert(myValue);
        insertTarget.focus();
    }
}
/*          ---------- cookie.js
    汎用的なクッキー関連メソッド??

    nasオブジェクトのメソッドとして実装する。
    nas.cookie.toString()//クッキー文字列
    nas.cookie.write()
    nas.cookie.read()
*/
//クッキー文字列を作って書き込み

function buildCk(){
var myCookie = new Array();
///////    クッキー配列用のデータを取得。
//    クッキーID:0をシートカラー及び印刷用紙サイズに設定
//    [0] applicationAttributes
    if (useCookie.SheetProp){
        SheetBaseColor    = xUI.sheetLooks.SheetBaseColor;
        ApplicationIdf    = serviceAgent.applicationIdf;
        var        appAttributes=[SheetBaseColor,ApplicationIdf];
    }else{
        var        appAttributes=[false,false];
    }
myCookie[0]=appAttributes;

//    [1] XPSAttrib 音響カラムを追加予定(20190310)
    myTitle        = (useCookie.XPSAttrib)? xUI.XPS.title:null;
    mySubTitle    = (useCookie.XPSAttrib)? xUI.XPS.subtitle:null;
    myOpus        = (useCookie.XPSAttrib)? xUI.XPS.opus:null;
    myFrameRate    = (useCookie.XPSAttrib)? xUI.XPS.framerate.toString():null;
    Sheet        = (useCookie.XPSAttrib)?nas.Frm2FCT(xUI.XPS.xpsTracks[0].length,3,0,xUI.XPS.framerate):null;//
    DialogColumns = (useCookie.XPSAttrib)?xUI.dialogCount:null;
    SoundColumns = (useCookie.XPSAttrib)?xUI.soundCount:null;
    SheetLayers    = (useCookie.XPSAttrib)?xUI.timingCount:null;
    CameraworkColumns = (useCookie.XPSAttrib)?xUI.cameraCount:null;
    StageworkColumns = (useCookie.XPSAttrib)?xUI.stageworkCount:null;
    SfxColumns = (useCookie.XPSAttrib)?xUI.sfxCount:null;

myCookie[1]=[myTitle,mySubTitle,myOpus,myFrameRate,Sheet,DialogColumns,SoundColumns,SheetLayers,CameraworkColumns,StageworkColumns,SfxColumns];

//    [2] UserName
    if(useCookie.UserName)    {
        myName  = xUI.currentUser.toString();
        myNames = xUI.recentUsers.convertStringArray();
    }else{
        myName    = false;
        myNames = [];
    }
myCookie[2]=[myName,myNames];

//    [3] KeyOptions
    BlankMethod         = (useCookie.KeyOptions)?xUI.blmtd:null;
    BlankPosition    = (useCookie.KeyOptions)?xUI.blpos:null;
    AEVersion         = (useCookie.KeyOptions)?xUI.aeVersion:null;
    KEYMethod         = (useCookie.KeyOptions)?xUI.keyMethod:null;
    TimeShift         = (useCookie.KeyOptions)?xUI.timeShift:null;
    FootageFramerate = (useCookie.KeyOptions)?xUI.fpsF:null;
    defaultSIZE         = (useCookie.KeyOptions)?[xUI.dfX,xUI.dfY,xUI.dfA].toString():"auto";

myCookie[3]=[BlankMethod,BlankPosition,AEVersion,KEYMethod,TimeShift,FootageFramerate,defaultSIZE];

//    [4] SheetOptions
    SpinValue       = (useCookie.SheetOptions)?xUI.spinValue:null;
    SpinSelect      = (useCookie.SheetOptions)?xUI.spinSelect:null;
    SheetLength      = (useCookie.SheetOptions)?xUI.SheetLength:null;
    SheetPageCols = (useCookie.SheetOptions)?xUI.PageCols:null;
    FootMark      = (useCookie.SheetOptions)?xUI.footMark:null;
    
myCookie[4]=[SpinValue,SpinSelect,SheetLength,SheetPageCols,FootMark];

//    [5] CounterType
    Counter0    =(useCookie.CounterType)?xUI.fct0:null;
    Counter1    =(useCookie.CounterType)?xUI.fct1:null;

myCookie[5]=[Counter0,Counter1];

//    [6] UIOptions
    SLoop        =(useCookie.UIOptions)?xUI.sLoop:null;
    CLoop        =(useCookie.UIOptions)?xUI.cLoop:null;
    AutoScroll    =(useCookie.UIOptions)?xUI.autoScroll:null;
    TabSpin        =(useCookie.UIOptions)?xUI.tabSpin:null;
    ViewMode    =(useCookie.UIOptions)?xUI.viewMode:null;
myCookie[6]=[SLoop,CLoop,AutoScroll,TabSpin,ViewMode];

//    [7] UIView
if(useCookie.UIView){
    ToolView=[];
    for (var ix=0;ix<UIViewIdList.length;ix++){
        ToolView.push(($('#'+UIViewIdList[ix]).css('display')=='none')? 0:1);                
    };
    ToolView=ToolView.join("");
//    alert(ToolView);//  beforunloadで呼び出すのでその際のアラート、コンソールは読めない
};//記録チェックがない場合は元のデータを変更しない
myCookie[7]=ToolView;
if(dbg) console.log(ToolView);
//    alert(myCookie);

return myCookie;
}

function writeCk(myCookie){
    if (!navigator.cookieEnabled){
        if (dbg){alert("クッキーが有効でないカンジ?")};
        return false;
    }
if(typeof myCookie == "undefined") myCookie=buildCk();
//console.log(myCookie);
var myCookieExpiers="";

if(useCookie.expiers) {
    var Xnow = new Date();

var completeYear=Xnow.getFullYear();//    年
var completeMonth=Xnow.getMonth()+1;//    月
var completeDate=Xnow.getDate();//    日
var completeHour=Xnow.getHours();//    時刻

var completeMin=Xnow.getMinutes();//    分
var completeSec=Xnow.getSeconds();//    秒

var eXpSpan=(isNaN(useCookie.expier))? 1:useCookie.expier[1];
//クッキーの期限 デフォルト期限 1日

var expDate=new Date(
    completeYear, completeMonth-1, completeDate + eXpSpan,
    completeHour , completeMin, completeSec 
);//    満了期日をセットした日付オブジェクトを作成

myCookieExpiers=';expires='+ expDate.toGMTString();
}

var myCookieSource=tosRcs(myCookie);
document.cookie= 'rEmaping=' +escape(myCookieSource) + myCookieExpiers;//書き込む
    return myCookie;
}
//
//    文字列をname=value;のセットに分解して与えられたckNameの値を返す。
//    フラグが立っていればエスケープする。
function breakValue(ckString,ckName,flag) {
    ckString += ';' ;
    var ckStringS = ckString.split(';');
        for(var n=0;n<ckStringS.length;n ++){
if (ckName == ckStringS[n].split('=')[0]){
    if (flag) {
        return ckStringS[n].split('=')[1];
    }else{
        return unescape(ckStringS[n].split('=')[1]);
    }
}
        }
return null;//判定できなかった場合は空文字列を返す。
}
/**    クッキー文字列を配列に戻し、グローバル変数に展開する
    グローバル変数は、設定ファイルの値を持っているので関数の呼び出し後に必用な参照を行う
    関数内では、ケース毎特定の処理は行わない。
*/
function ldCk(ckStrings){
if (!navigator.cookieEnabled){return false;}

    if(breakValue(document.cookie,"rEmaping")){
        var rEmaping = JSON.parse(breakValue(document.cookie,"rEmaping"));
    }else{
        return false;
    }
//    [0] SheetPropsApplicationAttributes
    if (useCookie.SheetProp){
    if(rEmaping[0][0]) SheetBaseColor    = unescape(rEmaping[0][0]);
    if(rEmaping[0][1]) ApplicationIdf    = unescape(rEmaping[0][1]);
    }

//    [1] XPSAttrib
    if (useCookie.XPSAttrib){
    if(rEmaping[1][0]) myTitle      = unescape(rEmaping[1][0]);
    if(rEmaping[1][1]) mySubTitle   = unescape(rEmaping[1][1]);
    if(rEmaping[1][2]) myOpus       = unescape(rEmaping[1][2]);
    if(rEmaping[1][3]) myFrameRate  = unescape(rEmaping[1][3]);
    if(rEmaping[1][4]) Sheet        = unescape(rEmaping[1][4]);
    if(rEmaping[1][5]) DialogColumns      = unescape(rEmaping[1][5]);
    if(rEmaping[1][6]) SoundColumns      = unescape(rEmaping[1][6]);
    if(rEmaping[1][7]) SheetLayers       = unescape(rEmaping[1][7]);
    if(rEmaping[1][8]) CameraworkColumns = unescape(rEmaping[1][8]);
    if(rEmaping[1][9]) StageworkColumns  = unescape(rEmaping[1][9]);
    if(rEmaping[1][10]) SfxColumns        = unescape(rEmaping[1][10]);
    }

//    [2] UserName
    if(useCookie.UserName){
        if(rEmaping[2]) {
            myName  = unescape(rEmaping[2][0]);
            myNames = [];
            for(var ix=0;ix<rEmaping[2][1].length;ix++){
            myNames.push(unescape(rEmaping[2][1][ix]));
            }
        }else{
            myName = "";
            myNames = [myName];
        }
    }
    if(! nas.CURRENTUSER) nas.CURRENTUSER = myName;

//    [3] KeyOptions
    if(useCookie.KeyOptions){
    if(rEmaping[3][0]) BlankMethod      = unescape(rEmaping[3][0]);
    if(rEmaping[3][1]) BlankPosition    = unescape(rEmaping[3][1]);
    if(rEmaping[3][2]) AEVersion        = unescape(rEmaping[3][2]);
    if(rEmaping[3][3]) KEYMethod        = unescape(rEmaping[3][3]);
    if(rEmaping[3][4]) TimeShift        = (rEmaping[3][4]=="true")?true:false;
    if(rEmaping[3][5]) FootageFramerate = unescape(rEmaping[3][5]);
    if(rEmaping[3][6]) defaultSIZE        = unescape(rEmaping[3][6].toString());
    }

//    [4] SheetOptions
    if(useCookie.SheetOptions){
    if(rEmaping[4][0]) SpinValue        =parseInt(rEmaping[4][0],10);
    if(rEmaping[4][1]) SpinSelect       =(rEmaping[4][1]=="true")?true:false;
    if(rEmaping[4][2]) SheetLength      =parseInt(rEmaping[4][2],10);
    if(rEmaping[4][3]) SheetPageCols    =parseInt(rEmaping[4][3],10);
    if(rEmaping[4][4]) FootMark         =(rEmaping[4][4]=="true")?true:false;
    }

//    [5] CounterType
    if(useCookie.CounterType){
    
    if(rEmaping[5][0] instanceof Array) Counter0 =    [parseInt(rEmaping[5][0][0],10),parseInt(rEmaping[5][0][1],10)];
    if(rEmaping[5][1] instanceof Array) Counter1 =    [parseInt(rEmaping[5][1][0],10),parseInt(rEmaping[5][1][1],10)];
    }

//    [6] UIOptions
    if(useCookie.UIOptions){
    if(rEmaping[6][0]) SLoop        = (rEmaping[6][0]=="true")?true:false;
    if(rEmaping[6][1]) CLoop        = (rEmaping[6][1]=="true")?true:false;
    if(rEmaping[6][2]) AutoScroll   = (rEmaping[6][2]=="true")?true:false;
    if(rEmaping[6][3]) TabSpin      = (rEmaping[6][3]=="true")?true:false;
    if(rEmaping[6][4]) ViewMode     = rEmaping[6][4];
    }
//    [7] UIView
    if(useCookie.UIView){
    if(rEmaping[7]) ToolView    =rEmaping[7];
    }
//console.log(rEmaping)
}
//    クッキー削除
function dlCk(){
    const ckName = 'rEmaping'; document.cookie = ckName + '=;expires=Thu,01-Jan-70 00:00:01 GMT';
    useCookie = false;
    var reloadNow=confirm(localize(nas.uiMsg.dmCookieRemoved));
    if(reloadNow){document.location.reload()}
}

function resetCk(){
    dlCk();
    writeCk();
    ldCk();
//アプリケーションIdf設定（クッキーから 存在しなければローカルストレージから）
    if(! ApplicationIdf){
        ApplicationIdf = localStorage.getItem("info.nekomataya.pman.applicationIdf");
    }
    serviceAgent.applicationIdf = ApplicationIdf;
}
//
function tosRcs(obj){
//    alert(obj);
    var sRcs="[";
    for(var idx=0; idx <obj.length;idx ++){
        var eLm=obj[idx];
        if(eLm instanceof Array){
            sRcs +=tosRcs(eLm);
        }else{
            sRcs +='"'+escape(eLm)+'"';
        }
        sRcs +=(idx < (obj.length-1))?",":"";
    }
    return sRcs+"]";
}

//
/*
    pmanオブジェクトをファンクショントレーラーとして作成
*/
    var pman = {};
/**
 *    パスを指定して、そのパスが含まれる管理ノードパスを返す
 *    ルートパス指定があれば管理ノードのルートパスを返す
 *    ヌルが返る場合はいずれの管理エントリにも含まれない
 *  @params {String}    path
 *  @params {Boolean}   rootpath
 *  @returns    {String|null}
 *      パスが位置する管理ノードパスは以下
 *  .<server-url>.<reposiotry-name>.<repository-idf>//
 *  .<サーバ-url(unique)>.<リポジトリ名>.<リポジトリ識別ID(unique)>.//
 *  .<サーバ-url(unique)>...//
 *  
 *   組織(チーム)情報は通常リポジトリの詳細情報内にある
 *  ローカルファイルシステム上のマスターストレージの場合は、これをフォルダで管理する
 * Nekomataya/kachi/kt#00/
 */
pman.getNodeByPath = function(path,rootpath){
    if((!path)||(! fs.existsSync(path))) return false;
    var nodepath ;
    var fullpath = fs.realpathSync(path).split('/');
    var currentpath;
    for(var dpt = fullpath.length ; dpt > 0 ; dpt --){
        currentpath = fullpath.slice(0,dpt).join('/')+'/';
        var dirent = fs.readdirSync(currentpath,{withFileTypes:true});
        var etcdir = dirent.find(function(elm){return (elm.name.indexOf("_etc") == 0)});
        if(etcdir){
            var etcdirent = fs.readdirSync(currentpath+etcdir.name,{withFileTypes:true});
            var currentpmdb = etcdirent.find(function(elm){return (elm.name.indexOf(".pmdb") >= 0)});
            if(currentpmdb){
                var p = new nas.Pm.PmDomain(nas.Pm);
                var pmdbContent = fs.readFileSync(currentpath + etcdir.name + '/' +currentpmdb.name,{encoding:"utf8"});
                p.parseConfig(pmdbContent.trim().replace(/\r\n?/g,"\n"));
                if((p.dataNode)&&(! rootpath)){
                    return decodeURIComponent(p.dataNode) ;
                }else{
                    nodepath = currentpath;
                }
            }else{
                    nodepath = currentpath;
            }
        }else{
            continue;
        }
    }
    if(nodepath){
        return nodepath;
    }
    return null;
}
/*test
    pman.getNodeByPath('/Users/kiyo/Desktop/納品規則/repository\(マスターストレージサンプル\)/Nekomataya\ \(サンプル\)/かちかちやま\ \(NG配置例\)')

var p =new nas.Pm.PmDomain();
var content = fs.readFileSync('/Users/kiyo/Desktop/納品規則/repository(マスターストレージサンプル)/_etc (基礎情報フォルダ)/repository.pmdb',{encoding:"utf8"})
console.log(content)
console.log(content.replace(/\r\n?/g,"\n"))
p.parseConfig(content.trim().replace(/\r\n?/g,"\n"));
console.log(p);
*/
/*
パスを指定してローカルファイルシステムにマスターストレージを作成する
パス指定がない場合は、ファイルダイアログを開いてパスを指定
指定されたパスがすでに設定済みのストレージ内だった場合はストレージを開く
マスターストレージか否かの判定は、指定パスからルートまでのパスをさかのぼって"_etc/nas_master_storage"ファイルの存在を検出する

*/
pman.setupMasterStorage = function(path){
    if (! path){
        path = dialog.showOpenDialogSync({
            title:"setup masterStorage",
            properties: ['openDirectory','createDirectory'],
            message:"新規のマスターストレージを作成します\n既存のディレクトリを指定する場合は、空のディレクトリを指定してください\nすでにファイルのあるディレクトリをマスターストレージにすることはできません\n指定のディレクトリが存在しない場合は、新たに作成します"
        });
    }
    if(! path) return false;//指定されなかったので処理終了
console.log(path);
console.log(path instanceof Array);
console.log(path.length);
    if(path instanceof Array) path = path[0];
    var storagePath = pman.getNodeByPath(path,true);
    if(storagePath) return storagePath;//pman.openStorage(storagePath) ;//指定パスがすでに管理下にあればサーバを開く

    if(fs.existsSync(path)){
//既存パスが指定されている
        var existsEntries = fs.readdirSync(path);
        if(existsEntries.length > 0){
//            (existsEntries.length == 1)&&(existsEntries[0]=='.DS_Store')||(existsEntries[0]=='Thumbs.db')
//既存パスにファイルがある=空ディレクトリのみをセットアップできるので失敗
//console.log(fs.readdirSync(path));
            alert("すでにデータのあるディレクトリをセットアップすることはできません。\n空ディレクトリを指定してください");
            return false;
        }else{
            storagePath = path;
        }
    }else{
//引数で新規パスが指定されている(作成可能か否か不明)
        try{
            console.log(fs.mkdirSync(path));//ここで作成失敗の可能性がある
        }catch(e){
            console.log(e);
            console.log("新規ディレクトリの作成に失敗しました。\nパスを確認してください");
            return false;
        }
        storagePath = path;
    }
    var cfm = confirm(storagePath + "を新たなマスターストレージとして設定します。\nよろしいですか？");
    if(cfm){
//<ストレージパス>/_etc/を作成
//.pmdbを作成
        try{
//root-pmdbを作成し .users .oragnizations tableを作成
//.usersにマスターユーザを加える（必要）仮設
//.oraganizationにイニシャルエントリを加える（必要）仮設
            var rootPmdb = new nas.Pm.PmDomain(nas.Pm,"file://"+storagePath);
            rootPmdb.users = new nas.UserInfoCollection();
            rootPmdb.organizations = new nas.Pm.OrganizationCollection();
            var adminUser = new nas.UserInfo("handle:e-mail");


            var initOrganization = new nas.Pm.Organization()

rootPmdb.organizations.timestamp = new Date('2019.10.01 00:00:00').getTime();
rootPmdb.organizations.parseConfig(`
nekomataya
	fullName:ねこまたや
	code:nkm
	id:0001
	serviceUrl:localRepository:info.nekomataya.pmdb
	shortName:(ね)
	contact:ねこまたや:kiyo@nekomataya.info
	description:ねこまたや:kiyo@nekomataya.info
`);

console.log(rootPmdb.dump('text'));
            var etcPath = storagePath.replace(/\/$/,'')+"/_etc";
console.log(etcPath);
            fs.mkdirSync(etcPath);
            var pmdbFile = etcPath+'/managemant_root.pmdb';
            var fd = fs.openSync(pmdbFile,'w');
            fs.writeSync(fd,rootPmdb.dump('text'));
            fs.closeSync(fd);
//ここで作成失敗の可能性がある
        }catch(e){
            console.log(e);
            console.log("セットアップに失敗しました。\n操作の権限を確認してください");
            return false;
        }
    }
}
/*
 *    マスターストレージをビルドする
 *  手順:
 *      引数はファイルパス
 *  マスターストレージを作成するディレクトはあらかじめ存在してかつ空であることが条件
 *  _etcフォルダを作成 fs.mkdirSynk(path)
 *  基準ファイル群を作成（最低限）
    _etc/organizations.json
	[configurations]    マスターパスワードのハッシュを登録するか？
	[organizations]     空テーブルを初期化
	[users] マスター管理者を１名のみ登録　初回手続き　引数渡し
_etc/users
_etc/password
    一応この形式を考慮しておく
    @params {String}    path
    @params {String}    user
    @params {String}    password
 */
/*  マスターストレージを選択して開く
 *  
 * xUI.
 *
 *
 *
 *
 *
 */
pman.openStorage =function(targetdir){
    if(!targetdir){
        targetdir = dialog.showOpenDialogSync({
            title:"setup masterStorage",
            properties: ['openDirectory'],
            message:"管理するマスターストレージを指定してください。"
        });
    }
    if(!targetdir) return false;
    console.log(targetdir);
    
}

/*  サーバセレクタを選択
 *
 *  サーバセレクタを操作して選択を切り替える
 *  フォーカスレベルがサーバへ移行
 *      リポジトリ/タイトル・エピソードの選択がすべて解除されて編集対象がサービスノードになる
 *      xUI.activeNode = ServiceNode
 *
 */
pman.updateServerSelector =function(targetId){
    console.log(parseInt(targetId)+1);
    console.log(serviceAgent.servers[parseInt(targetId)]);
    xUI.activeNode
}