﻿/*
ew.jsx
元スクリプトから以下の部分を変更
関数化してUNDO可能に
白レイヤーの作成を省略
オリジナルのソースレイヤを削除してリザルトを
オリジナルと同名のレイヤーに変更
透明度とブレンドモードを復帰
RGBモードに動作範囲を限定
ターゲットレイヤーがピクセルを持たない場合にNOP
*/
function eliminateWhite(targetLayer){
    if (typeof targetLayer == 'undefined') targetLayer = app.activeDocument.activeLayer;
    if ((targetLayer.kind != LayerKind.NORMAL)||(targetLayer.isBackgroundLayer)||(app.activeDocument.mode != DocumentMode.RGB)) return false;
    var bacupProps={blendMode:targetLayer.blendMode,opacity:targetLayer.opacity,maskOpt:targetLayer.layerMaskDensity};

    app.activeDocument.quickMaskMode=false;


//    sourceLayer.blendMode = BlendMode.NORMAL;
//    sourceLayer.opacity   = 100;
//    sourceLayer.layerMaskDensity = 0;
    
    app.activeDocument.activeLayer = targetLayer;
    app.activeDocument.selection.selectAll();
    app.activeDocument.selection.copy();
    app.activeDocument.selection.deselect();
    app.activeDocument.paste();
    var sourceLayer = app.activeDocument.activeLayer;
    
//アクティブレイヤー全体を一度白でペイントしておく    
    app.activeDocument.selection.selectAll();
    RGBColor = new SolidColor();
    RGBColor.red = 255;
    RGBColor.green = 255;
    RGBColor.blue = 255;
    app.activeDocument.selection.fill(RGBColor,ColorBlendMode.DARKEN, 100, false);

var rLayer=app.activeDocument.activeLayer.duplicate();

app.activeDocument.activeLayer=rLayer;

var idChnM = charIDToTypeID( "ChnM" );
    var desc3 = new ActionDescriptor();
    var idpresetKind = stringIDToTypeID( "presetKind" );
    var idpresetKindType = stringIDToTypeID( "presetKindType" );
    var idpresetKindCustom = stringIDToTypeID( "presetKindCustom" );
    desc3.putEnumerated( idpresetKind, idpresetKindType, idpresetKindCustom );
    var idMnch = charIDToTypeID( "Mnch" );
    desc3.putBoolean( idMnch, true );
    var idGry = charIDToTypeID( "Gry " );
        var desc4 = new ActionDescriptor();
        var idRd = charIDToTypeID( "Rd  " );
        var idPrc = charIDToTypeID( "#Prc" );
        desc4.putUnitDouble( idRd, idPrc, 100.000000 );
    var idChMx = charIDToTypeID( "ChMx" );
    desc3.putObject( idGry, idChMx, desc4 );
executeAction( idChnM, desc3, DialogModes.NO );


app.activeDocument.activeLayer=sourceLayer;
var gLayer=app.activeDocument.activeLayer.duplicate();
app.activeDocument.activeLayer=gLayer;

var idChnM = charIDToTypeID( "ChnM" );
    var desc29 = new ActionDescriptor();
    var idpresetKind = stringIDToTypeID( "presetKind" );
    var idpresetKindType = stringIDToTypeID( "presetKindType" );
    var idpresetKindCustom = stringIDToTypeID( "presetKindCustom" );
    desc29.putEnumerated( idpresetKind, idpresetKindType, idpresetKindCustom );
    var idMnch = charIDToTypeID( "Mnch" );
    desc29.putBoolean( idMnch, true );
    var idGry = charIDToTypeID( "Gry " );
        var desc30 = new ActionDescriptor();
        var idGrn = charIDToTypeID( "Grn " );
        var idPrc = charIDToTypeID( "#Prc" );
        desc30.putUnitDouble( idGrn, idPrc, 100.000000 );
    var idChMx = charIDToTypeID( "ChMx" );
    desc29.putObject( idGry, idChMx, desc30 );
executeAction( idChnM, desc29, DialogModes.NO );


app.activeDocument.activeLayer=sourceLayer;
var bLayer=app.activeDocument.activeLayer.duplicate();
app.activeDocument.activeLayer=bLayer;


var idChnM = charIDToTypeID( "ChnM" );
    var desc33 = new ActionDescriptor();
    var idpresetKind = stringIDToTypeID( "presetKind" );
    var idpresetKindType = stringIDToTypeID( "presetKindType" );
    var idpresetKindCustom = stringIDToTypeID( "presetKindCustom" );
    desc33.putEnumerated( idpresetKind, idpresetKindType, idpresetKindCustom );
    var idMnch = charIDToTypeID( "Mnch" );
    desc33.putBoolean( idMnch, true );
    var idGry = charIDToTypeID( "Gry " );
        var desc34 = new ActionDescriptor();
        var idBl = charIDToTypeID( "Bl  " );
        var idPrc = charIDToTypeID( "#Prc" );
        desc34.putUnitDouble( idBl, idPrc, 100.000000 );
    var idChMx = charIDToTypeID( "ChMx" );
    desc33.putObject( idGry, idChMx, desc34 );
executeAction( idChnM, desc33, DialogModes.NO );


rLayer.blendMode = BlendMode.DARKEN;
gLayer.blendMode = BlendMode.DARKEN;
app.activeDocument.activeLayer=rLayer;
app.activeDocument.activeLayer=app.activeDocument.activeLayer.merge();
maskLayer=app.activeDocument.activeLayer.merge();



app.activeDocument.activeLayer=maskLayer;

app.activeDocument.selection.selectAll();
app.activeDocument.selection.copy();

maskLayer.remove();


app.activeDocument.activeLayer=sourceLayer;
var resultLayer=app.activeDocument.activeLayer.duplicate();
app.activeDocument.activeLayer=resultLayer;

app.activeDocument.quickMaskMode=true;
app.activeDocument.selection.selectAll();
app.activeDocument.paste(true);
app.activeDocument.quickMaskMode=false;
app.activeDocument.selection.clear();
app.activeDocument.selection.deselect();
// =======================================================
var idRmvW = charIDToTypeID( "RmvW" );
executeAction( idRmvW, undefined, DialogModes.NO );
//実行直後にマージしてソースレイヤーにまとめる
sourceLayer.opacity=0;
targetLayer.opacity=0;
app.activeDocument.activeLayer=app.activeDocument.activeLayer.merge();
app.activeDocument.activeLayer=app.activeDocument.activeLayer.merge();
/*白レイヤーは不要
var whiteLayer=app.activeDocument.activeLayer.duplicate();
app.activeDocument.activeLayer=whiteLayer;


app.activeDocument.selection.selectAll();
RGBColor = new SolidColor();
RGBColor.red = 255;
RGBColor.green = 255;
RGBColor.blue = 255;
app.activeDocument.selection.fill(RGBColor,ColorBlendMode.NORMAL, 100, false);
*/

app.activeDocument.selection.deselect();

targetLayer.blendMode = bacupProps.blendMode;//ブレンドモード復帰
targetLayer.opacity   = bacupProps.opacity;//不透明度復帰
//sourceLayer.layerMaskDensity   = bacupProps.maskOpt;//レイヤマスク濃度復帰
//他のプロパティ（レイヤー効果・レイヤーマスク等）も復帰させるか？
//いっそ元レイヤーのピクセルを入れ替えたほうが良いかも？
//ソースのピクセルをすべて不透明度0にした後にマージでいける

//app.activeDocument.activeLayer=resultLayer;
}
eliminateWhite();