/*
 *	StylosCSV2XPS(CSVStream,stageOffset)

 *		stylos CSVファイルをXPS互換テキストにコンバートする
 *		引き数は、CSVデータのテキストストリーム,
 *		stageOffsetは原画シートを転記するか動画シートを転記するかのフラグ 0:原画シート/1:動画シート
 */

function StylosCSV2XPS(CSVStream,stageOffset)
{
//データ冒頭のみチェックして明確に違うストリームの場合はエラーを返す
if (! CSVStream.match(/^\"Frame",/)){ return false;};

//CSVデータをオブジェクト化する
	myStylosCSV=new Object();
//ラインで分割して配列に取り込み
	myStylosCSV.SrcData=new Array();
	if(CSVStream.match(/\r/)){CSVStream=CSVStream.replace(/\r\n?/g,("\n"));};
	myStylosCSV.SrcData=CSVStream.split("\n");
//各ラインを更にテキストの配列に分解(ココでchompしてdurationとったほうが良いかも)
	for(var idx=0;idx<myStylosCSV.SrcData.length;idx++){myStylosCSV.SrcData[idx]=myStylosCSV.SrcData[idx].split(",");}

	if(!stageOffset){myStylosCSV.stageOffset=0;}else{myStylosCSV.stageOffset=stageOffset;};
	myStylosCSV.frameDuration	=myStylosCSV.SrcData.length-3;
					//フレーム継続数 全ライン数-(ヘッダ行,ラベル行)
	myStylosCSV.layerCount	=(myStylosCSV.SrcData[0].length-2)/2;
					//レイヤ数
	myStylosCSV.body=function(layerID,frameID,layerOffset)
	{
		if(! layerOffset){layerOffset=this.stageOffset;};//0:原画シート/1:動画シート　
		return (eval(this.SrcData[frameID+2][layerID+(layerOffset*this.layerCount)+1]));
	}
//ラベル取得
	myStylosCSV.layerLabel	=new Array(myStylosCSV.layerCount);//ラベル配列
	for(var idx=0;idx<myStylosCSV.layerCount;idx++){myStylosCSV.layerLabel[idx]=eval(myStylosCSV.SrcData[1][idx+1]);};//原画シートからラベル取得


//XPS互換ストリームに変換
myStylosCSV.toSrcString = function()
{
//	var myLineFeed=nas.GUI.LineFeed;
	var myLineFeed="\n";
	var resultStream="nasTIME-SHEET 0.4";
	resultStream	+=myLineFeed;
	resultStream	+="#RETAS!StylosCSV";
	resultStream	+=myLineFeed;
	resultStream	+="##TIME="+nas.Frm2FCT(this.frameDuration,3,0);
	resultStream	+=myLineFeed;
	resultStream	+="##TRIN=0+00.,\x22\x22";
	resultStream	+=myLineFeed;
	resultStream	+="##TROUT=0+00.,\x22\x22";
	resultStream	+=myLineFeed;
//	ラベル配置
	resultStream	+="[CELL\tN\t";
	for(idx=0;idx<this.layerCount;idx++)
	{	resultStream	+=this.layerLabel[idx]+"\t";};
	resultStream	+="]";
	resultStream	+=myLineFeed;
	
	for(frm=0;frm<this.frameDuration;frm++)
	{
		resultStream	+="\t";
		//ダイアログデータを転記
		resultStream	+=eval(this.SrcData[frm+2][this.layerCount+1]);
		resultStream	+="\t";
		for(idx=0;idx<this.layerCount;idx++)
		{
			if(frm==0)
			{
				var currentValue=this.body(idx,frm);
			}else{
				var currentValue=(this.body(idx,frm)==this.body(idx,(frm-1)))?"":this.body(idx,frm);
			}
			resultStream	+=(currentValue===0)?"X\t":currentValue+"\t";
		}
		resultStream	+=myLineFeed;
	}
	resultStream	+="[END]";
	resultStream	+=myLineFeed;
	resultStream	+="Convert from RETAS!StylosCSV"
	return resultStream;
}
alert( myStylosCSV.toSrcString());
return myStylosCSV.toSrcString();
}


//end converter

