/**
 * math.js
 * https://github.com/josdejong/mathjs
 *
 * Math.js is an extensive math library for JavaScript and Node.js,
 * It features real and complex numbers, units, matrices, a large set of
 * mathematical functions, and a flexible expression parser.
 *
 * @version 1.4.0
 * @date    2015-02-28
 *
 * @license
 * Copyright (C) 2013-2015 Jos de Jong <wjosdejong@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
!function(e,r){"object"==typeof exports&&"object"==typeof module?module.exports=r():"function"==typeof define&&define.amd?define(r):"object"==typeof exports?exports.math=r():e.math=r()}(this,function(){return function(e){function r(n){if(t[n])return t[n].exports;var i=t[n]={exports:{},id:n,loaded:!1};return e[n].call(i.exports,i,i.exports,r),i.loaded=!0,i.exports}var t={};return r.m=e,r.c=t,r.p="",r(0)}([function(e,r,t){e.exports=t(1)},function(e,r,t){"use strict";function n(e){if("function"!=typeof Object.create)throw new Error("ES5 not supported by this JavaScript engine. Please load the es5-shim and es5-sham library for compatibility.");var r={},a={matrix:"matrix",number:"number",precision:64,epsilon:1e-14};r.config=function(e){if(e){if(i.deepExtend(a,e),e.precision&&r.type.BigNumber.config({precision:e.precision}),t(4)(r,a),e.number&&e.number.defaultType)throw new Error("setting `number.defaultType` is deprecated. Use `number` instead.");if(e.number&&e.number.precision)throw new Error("setting `number.precision` is deprecated. Use `precision` instead.");if(e.matrix&&e.matrix.defaultType)throw new Error("setting `matrix.defaultType` is deprecated. Use `matrix` instead.");if(e.matrix&&e.matrix["default"])throw new Error("setting `matrix.default` is deprecated. Use `matrix` instead.");if(e.decimals)throw new Error("setting `decimals` is deprecated. Use `precision` instead.")}return i.clone(a)},r.create=n;var s=t(5).constructor();if("function"!=typeof s.prototype.clone&&(s.prototype.clone=function(){return this}),"function"==typeof s.convert)throw new Error("Cannot add function convert to BigNumber: function already exists");return s.convert=function(e){return o(e)>15?e:new s(e)},r.error=t(6),r.type={},r.type.Complex=t(7),r.type.Range=t(8),r.type.Index=t(9),r.type.Matrix=t(10),r.type.Unit=t(11),r.type.Help=t(12),r.type.ResultSet=t(13),r.type.BigNumber=s,r.collection=t(14),r.expression={},r.expression.node=t(15),r.expression.parse=t(16),r.expression.Parser=t(17),r.expression.docs=t(18),r.json={reviver:t(19)},t(31)(r,a),t(32)(r,a),t(33)(r,a),t(34)(r,a),t(35)(r,a),t(36)(r,a),t(37)(r,a),t(38)(r,a),t(39)(r,a),t(40)(r,a),t(41)(r,a),t(42)(r,a),t(43)(r,a),t(44)(r,a),t(45)(r,a),t(46)(r,a),t(47)(r,a),t(48)(r,a),t(49)(r,a),t(50)(r,a),t(51)(r,a),t(52)(r,a),t(53)(r,a),t(54)(r,a),t(55)(r,a),t(56)(r,a),t(57)(r,a),t(58)(r,a),t(59)(r,a),t(60)(r,a),t(61)(r,a),t(62)(r,a),t(63)(r,a),t(64)(r,a),t(65)(r,a),t(66)(r,a),t(67)(r,a),t(68)(r,a),t(69)(r,a),t(70)(r,a),t(71)(r,a),t(72)(r,a),t(73)(r,a),t(74)(r,a),t(75)(r,a),t(76)(r,a),t(77)(r,a),t(78)(r,a),t(79)(r,a),t(80)(r,a),t(81)(r,a),t(82)(r,a),t(83)(r,a),t(84)(r,a),t(85)(r,a),t(86)(r,a),t(87)(r,a),t(88)(r,a),t(89)(r,a),t(90)(r,a),t(91)(r,a),t(92)(r,a),t(93)(r,a),t(94)(r,a),t(95)(r,a),t(96)(r,a),t(97)(r,a),t(98)(r,a),t(99)(r,a),t(100)(r,a),t(101)(r,a),t(102)(r,a),t(103)(r,a),t(104)(r,a),t(105)(r,a),t(106)(r,a),t(107)(r,a),t(108)(r,a),t(109)(r,a),t(110)(r,a),t(111)(r,a),t(112)(r,a),t(113)(r,a),t(114)(r,a),t(115)(r,a),t(116)(r,a),t(117)(r,a),t(118)(r,a),t(119)(r,a),t(120)(r,a),t(121)(r,a),t(122)(r,a),t(123)(r,a),t(124)(r,a),t(125)(r,a),t(126)(r,a),t(127)(r,a),t(128)(r,a),t(129)(r,a),t(130)(r,a),t(131)(r,a),t(132)(r,a),t(133)(r,a),t(134)(r,a),t(135)(r,a),t(136)(r,a),t(137)(r,a),t(138)(r,a),t(139)(r,a),t(140)(r,a),t(141)(r,a),t(142)(r,a),t(143)(r,a),t(144)(r,a),t(145)(r,a),t(146)(r,a),t(147)(r,a),t(148)(r,a),t(149)(r,a),t(150)(r,a),t(151)(r,a),t(152)(r,a),t(153)(r,a),t(154)(r,a),t(155)(r,a),t(156)(r,a),t(157)(r,a),t(158)(r,a),t(159)(r,a),t(160)(r,a),t(161)(r,a),t(162)(r,a),t(163)(r,a),r.ifElse=function(){throw new Error("Function ifElse is deprecated. Use the conditional operator instead.")},t(4)(r,a),r.expression.transform={concat:t(20)(r,a),filter:t(21)(r,a),forEach:t(22)(r,a),index:t(23)(r,a),map:t(24)(r,a),max:t(25)(r,a),mean:t(26)(r,a),min:t(27)(r,a),range:t(28)(r,a),subset:t(29)(r,a)},r.chaining={},r.chaining.Chain=t(30)(r,a),r.chaining.Selector=r.chaining.Chain,r.config(a),r.config(e),r}var i=t(2),o=t(3).digits,a=n();"undefined"!=typeof window&&(window.mathjs=a),e.exports=a},function(e,r){"use strict";r.clone=function t(e){var r=typeof e;if("number"===r||"string"===r||"boolean"===r||null===e||void 0===e)return e;if("function"==typeof e.clone)return e.clone();if(Array.isArray(e))return e.map(function(e){return t(e)});if(e instanceof Number)return new Number(e.valueOf());if(e instanceof String)return new String(e.valueOf());if(e instanceof Boolean)return new Boolean(e.valueOf());if(e instanceof Date)return new Date(e.valueOf());if(e instanceof RegExp)throw new TypeError("Cannot clone "+e);var n={};for(var i in e)e.hasOwnProperty(i)&&(n[i]=t(e[i]));return n},r.extend=function(e,r){for(var t in r)r.hasOwnProperty(t)&&(e[t]=r[t]);return e},r.deepExtend=function n(e,r){if(Array.isArray(r))throw new TypeError("Arrays are not supported by deepExtend");for(var t in r)if(r.hasOwnProperty(t))if(r[t]&&r[t].constructor===Object)void 0===e[t]&&(e[t]={}),e[t].constructor===Object?n(e[t],r[t]):e[t]=r[t];else{if(Array.isArray(r[t]))throw new TypeError("Arrays are not supported by deepExtend");e[t]=r[t]}return e},r.deepEqual=function(e,t){var n,i,o;if(Array.isArray(e)){if(!Array.isArray(t))return!1;if(e.length!=t.length)return!1;for(i=0,o=e.length;o>i;i++)if(!r.deepEqual(e[i],t[i]))return!1;return!0}if(e instanceof Object){if(Array.isArray(t)||!(t instanceof Object))return!1;for(n in e)if(!r.deepEqual(e[n],t[n]))return!1;for(n in t)if(!r.deepEqual(e[n],t[n]))return!1;return!0}return typeof e==typeof t&&e==t},r.canDefineProperty=function(){try{if(Object.defineProperty)return Object.defineProperty({},"x",{}),!0}catch(e){}return!1},r.lazy=function(e,t,n){if(r.canDefineProperty()){var i,o=!0;Object.defineProperty(e,t,{get:function(){return o&&(i=n(),o=!1),i},set:function(e){i=e,o=!1}})}else e[t]=n()}},function(e,r){"use strict";r.isNumber=function(e){return e instanceof Number||"number"==typeof e},r.isInteger=function(e){return e==Math.round(e)},r.sign=function(e){return e>0?1:0>e?-1:0},r.format=function(e,t){if("function"==typeof t)return t(e);if(1/0===e)return"Infinity";if(e===-1/0)return"-Infinity";if(isNaN(e))return"NaN";var n="auto",i=void 0;switch(t&&(t.notation&&(n=t.notation),r.isNumber(t)?i=t:t.precision&&(i=t.precision)),n){case"fixed":return r.toFixed(e,i);case"exponential":return r.toExponential(e,i);case"auto":var o=.001,a=1e5;if(t&&t.exponential&&(void 0!==t.exponential.lower&&(o=t.exponential.lower),void 0!==t.exponential.upper&&(a=t.exponential.upper)),0===e)return"0";var s,u=Math.abs(e);if(u>=o&&a>u){var c=i?e.toPrecision(Math.min(i,21)):e.toPrecision();s=parseFloat(c)+""}else s=r.toExponential(e,i);return s.replace(/((\.\d*?)(0+))($|e)/,function(){var e=arguments[2],r=arguments[4];return"."!==e?e+r:r});default:throw new Error('Unknown notation "'+n+'". Choose "auto", "exponential", or "fixed".')}},r.toExponential=function(e,r){return void 0!==r?e.toExponential(Math.min(r-1,20)):e.toExponential()},r.toFixed=function(e,r){return e.toFixed(Math.min(r,20))},r.digits=function(e){return e.toExponential().replace(/e.*$/,"").replace(/^0\.?0*|\./,"").length},r.DBL_EPSILON=Number.EPSILON||2.220446049250313e-16,r.nearlyEqual=function(e,t,n){if(null==n)return e==t;if(e==t)return!0;if(isNaN(e)||isNaN(t))return!1;if(isFinite(e)&&isFinite(t)){var i=Math.abs(e-t);return i<r.DBL_EPSILON?!0:i<=Math.max(Math.abs(e),Math.abs(t))*n}return!1}},function(e,r,t){"use strict";e.exports=function(e,r){var n=t(2),i=t(164),o=t(7),a=e.type.BigNumber;e["true"]=!0,e["false"]=!1,e["null"]=null,e.uninitialized=t(165).UNINITIALIZED,"bignumber"===r.number?(e.Infinity=new a(1/0),e.NaN=new a(0/0),n.lazy(e,"pi",function(){return i.pi(r.precision)}),n.lazy(e,"tau",function(){return i.tau(r.precision)}),n.lazy(e,"e",function(){return i.e(r.precision)}),n.lazy(e,"phi",function(){return i.phi(r.precision)}),n.lazy(e,"E",function(){return e.e}),n.lazy(e,"LN2",function(){return new a(2).ln()}),n.lazy(e,"LN10",function(){return new a(10).ln()}),n.lazy(e,"LOG2E",function(){return new a(1).div(new a(2).ln())}),n.lazy(e,"LOG10E",function(){return new a(1).div(new a(10).ln())}),n.lazy(e,"PI",function(){return e.pi}),n.lazy(e,"SQRT1_2",function(){return new a("0.5").sqrt()}),n.lazy(e,"SQRT2",function(){return new a(2).sqrt()})):(e.Infinity=1/0,e.NaN=0/0,e.pi=Math.PI,e.tau=2*Math.PI,e.e=Math.E,e.phi=1.618033988749895,e.E=e.e,e.LN2=Math.LN2,e.LN10=Math.LN10,e.LOG2E=Math.LOG2E,e.LOG10E=Math.LOG10E,e.PI=e.pi,e.SQRT1_2=Math.SQRT1_2,e.SQRT2=Math.SQRT2),e.i=new o(0,1),e.version=t(166)}},function(e,r,t){var n=t(336);n.prototype.toJSON=function(){return{mathjs:"BigNumber",value:this.toString()}},n.fromJSON=function(e){return new n(e.value)},e.exports=n},function(e,r,t){"use strict";r.ArgumentsError=t(167),r.DimensionError=t(168),r.IndexError=t(169),r.UnsupportedTypeError=t(170)},function(e,r,t){"use strict";function n(e,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");switch(arguments.length){case 0:this.re=0,this.im=0;break;case 1:var t=arguments[0];if("object"==typeof t){if("re"in t&&"im"in t){var i=new n(t.re,t.im);this.re=i.re,this.im=i.im;break}if("r"in t&&"phi"in t){var i=n.fromPolar(t.r,t.phi);this.re=i.re,this.im=i.im;break}}throw new SyntaxError("Object with the re and im or r and phi properties expected.");case 2:if(!h(e)||!h(r))throw new TypeError("Two numbers expected in Complex constructor");this.re=e,this.im=r;break;default:throw new SyntaxError("One, two or three arguments expected in Complex constructor")}}function i(){for(;" "==v||"	"==v;)s()}function o(e){return e>="0"&&"9">=e||"."==e}function a(e){return e>="0"&&"9">=e}function s(){x++,v=w.charAt(x)}function u(e){x=e,v=w.charAt(x)}function c(){var e,r="";if(e=x,"+"==v?s():"-"==v&&(r+=v,s()),!o(v))return u(e),null;if("."==v){if(r+=v,s(),!a(v))return u(e),null}else{for(;a(v);)r+=v,s();"."==v&&(r+=v,s())}for(;a(v);)r+=v,s();if("E"==v||"e"==v){if(r+=v,s(),("+"==v||"-"==v)&&(r+=v,s()),!a(v))return u(e),null;for(;a(v);)r+=v,s()}return r}function f(){var e=w.charAt(x+1);if("I"==v||"i"==v)return s(),"1";if(!("+"!=v&&"-"!=v||"I"!=e&&"i"!=e)){var r="+"==v?"1":"-1";return s(),s(),r}return null}var l=t(171),p=t(11),m=l.number,h=l.number.isNumber,g=p.isUnit,d=l.string.isString;n.isComplex=function(e){return e instanceof n};var w,x,v;n.parse=function(e){if(w=e,x=-1,v="",!d(w))return null;s(),i();var r=c();if(r){if("I"==v||"i"==v)return s(),i(),v?null:new n(0,Number(r));i();var t=v;if("+"!=t&&"-"!=t)return i(),v?null:new n(Number(r),0);s(),i();var o=c();if(o){if("I"!=v&&"i"!=v)return null;s()}else if(o=f(),!o)return null;return"-"==t&&(o="-"==o[0]?"+"+o.substring(1):"-"+o),s(),i(),v?null:new n(Number(r),Number(o))}return(r=f())?(i(),v?null:new n(0,Number(r))):null},n.fromPolar=function(){switch(arguments.length){case 1:var e=arguments[0];if("object"==typeof e)return n.fromPolar(e.r,e.phi);throw new TypeError("Input has to be an object with r and phi keys.");case 2:var r=arguments[0],t=arguments[1];if(h(r)){if(g(t)&&t.hasBase(p.BASE_UNITS.ANGLE)&&(t=t.toNumber("rad")),h(t))return new n(r*Math.cos(t),r*Math.sin(t));throw new TypeError("Phi is not a number nor an angle unit.")}throw new TypeError("Radius r is not a number.");default:throw new SyntaxError("Wrong number of arguments in function fromPolar")}},n.prototype.toPolar=function(){return{r:Math.sqrt(this.re*this.re+this.im*this.im),phi:Math.atan2(this.im,this.re)}},n.prototype.clone=function(){return new n(this.re,this.im)},n.prototype.equals=function(e){return this.re===e.re&&this.im===e.im},n.prototype.format=function(e){var r="",t=this.im,n=this.re,i=m.format(this.re,e),o=m.format(this.im,e),a=h(e)?e:e?e.precision:null;if(null!==a){var s=Math.pow(10,-a);Math.abs(n/t)<s&&(n=0),Math.abs(t/n)<s&&(t=0)}return r=0==t?i:0==n?1==t?"i":-1==t?"-i":o+"i":t>0?1==t?i+" + i":i+" + "+o+"i":-1==t?i+" - i":i+" - "+o.substring(1)+"i"},n.prototype.toString=function(){return this.format()},n.prototype.toJSON=function(){return{mathjs:"Complex",re:this.re,im:this.im}},n.fromJSON=function(e){return new n(e)},n.prototype.valueOf=n.prototype.toString,e.exports=n},function(e,r,t){"use strict";function n(e,r,t){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(null!=e&&!o.isNumber(e))throw new TypeError("Parameter start must be a number");if(null!=r&&!o.isNumber(r))throw new TypeError("Parameter end must be a number");if(null!=t&&!o.isNumber(t))throw new TypeError("Parameter step must be a number");this.start=null!=e?parseFloat(e):0,this.end=null!=r?parseFloat(r):0,this.step=null!=t?parseFloat(t):1}{var i=t(171),o=i.number,a=i.string;i.array}n.parse=function(e){if(!a.isString(e))return null;var r=e.split(":"),t=r.map(function(e){return parseFloat(e)}),i=t.some(function(e){return isNaN(e)});if(i)return null;switch(t.length){case 2:return new n(t[0],t[1]);case 3:return new n(t[0],t[2],t[1]);default:return null}},n.prototype.clone=function(){return new n(this.start,this.end,this.step)},n.isRange=function(e){return e instanceof n},n.prototype.size=function(){var e=0,r=this.start,t=this.step,n=this.end,i=n-r;return o.sign(t)==o.sign(i)?e=Math.ceil(i/t):0==i&&(e=0),isNaN(e)&&(e=0),[e]},n.prototype.min=function(){var e=this.size()[0];return e>0?this.step>0?this.start:this.start+(e-1)*this.step:void 0},n.prototype.max=function(){var e=this.size()[0];return e>0?this.step>0?this.start+(e-1)*this.step:this.start:void 0},n.prototype.forEach=function(e){var r=this.start,t=this.step,n=this.end,i=0;if(t>0)for(;n>r;)e(r,i,this),r+=t,i++;else if(0>t)for(;r>n;)e(r,i,this),r+=t,i++},n.prototype.map=function(e){var r=[];return this.forEach(function(t,n,i){r[n]=e(t,n,i)}),r},n.prototype.toArray=function(){var e=[];return this.forEach(function(r,t){e[t]=r}),e},n.prototype.valueOf=function(){return this.toArray()},n.prototype.format=function(e){var r=o.format(this.start,e);return 1!=this.step&&(r+=":"+o.format(this.step,e)),r+=":"+o.format(this.end,e)},n.prototype.toString=function(){return this.format()},n.prototype.toJSON=function(){return{mathjs:"Range",start:this.start,end:this.end,step:this.step}},n.fromJSON=function(e){return new n(e.start,e.end,e.step)},e.exports=n},function(e,r,t){"use strict";function n(){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");this._ranges=[],this._isScalar=!0;for(var e=0,r=arguments.length;r>e;e++){var t=arguments[e];if(t instanceof a)this._ranges.push(t),this._isScalar=!1;else if(f(t))this._ranges.push(i(t)),this._isScalar=!1;else if(u(t))this._ranges.push(i([t,t+1]));else{var o=t.valueOf();if(!f(o))throw new TypeError("Ranges must be an Array, Number, or Range");this._ranges.push(i(o)),this._isScalar=!1}}}function i(e){for(var r=e.length,t=0;r>t;t++)if(!u(e[t])||!c(e[t]))throw new TypeError("Index parameters must be integer numbers");switch(e.length){case 2:return new a(e[0],e[1]);case 3:return new a(e[0],e[1],e[2]);default:throw new SyntaxError("Wrong number of arguments in Index (2 or 3 expected)")}}var o=t(171),a=t(8),s=o.number,u=s.isNumber,c=s.isInteger,f=Array.isArray;n.prototype.clone=function(){var e=new n;return e._ranges=o.object.clone(this._ranges),e._isScalar=this._isScalar,e},n.isIndex=function(e){return e instanceof n},n.create=function(e){var r=new n;return n.apply(r,e),r},n.prototype.size=function(){for(var e=[],r=0,t=this._ranges.length;t>r;r++){var n=this._ranges[r];e[r]=n.size()[0]}return e},n.prototype.max=function(){for(var e=[],r=0,t=this._ranges.length;t>r;r++){var n=this._ranges[r];e[r]=n.max()}return e},n.prototype.min=function(){for(var e=[],r=0,t=this._ranges.length;t>r;r++){var n=this._ranges[r];e[r]=n.min()}return e},n.prototype.forEach=function(e){for(var r=0,t=this._ranges.length;t>r;r++)e(this._ranges[r],r,this)},n.prototype.range=function(e){return this._ranges[e]||null},n.prototype.isScalar=function(){return this._isScalar},n.prototype.toArray=function(){for(var e=[],r=0,t=this._ranges.length;t>r;r++){var n=this._ranges[r],i=[],o=n.start,a=n.end,s=n.step;if(s>0)for(;a>o;)i.push(o),o+=s;else if(0>s)for(;o>a;)i.push(o),o+=s;e.push(i)}return e},n.prototype.valueOf=n.prototype.toArray,n.prototype.toString=function(){for(var e=[],r=0,t=this._ranges.length;t>r;r++){var n=this._ranges[r],i=s.format(n.start);1!=n.step&&(i+=":"+s.format(n.step)),i+=":"+s.format(n.end),e.push(i)}return"["+e.join(", ")+"]"},n.prototype.toJSON=function(){return{mathjs:"Index",ranges:this._ranges}},n.fromJSON=function(e){return n.create(e.ranges)},e.exports=n},function(e,r,t){"use strict";function n(e){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(e instanceof n)this._data=e.clone()._data;else if(d(e))this._data=c(e);else{if(null!=e)throw new TypeError("Unsupported type of data ("+f.types.type(e)+")");this._data=[]}this._size=h.size(this._data)}function i(e,r){if(!(r instanceof p))throw new TypeError("Invalid index");var t=r.isScalar();if(t)return e.get(r.min());var i=r.size();if(i.length!=e._size.length)throw new l(i.length,e._size.length);for(var a=r.min(),s=r.max(),u=0,c=e._size.length;c>u;u++)w(a[u],e._size[u]),w(s[u],e._size[u]);return new n(o(e._data,r,i.length,0))}function o(e,r,t,n){var i=n==t-1,a=r.range(n);return a.map(i?function(r){return e[r]}:function(i){var a=e[i];return o(a,r,t,n+1)})}function a(e,r,t,i){if(!(r instanceof p))throw new TypeError("Invalid index");var o,a=r.size(),c=r.isScalar();if(t instanceof n?(o=t.size(),t=t.valueOf()):o=h.size(t),c){if(0!=o.length)throw new TypeError("Scalar expected");e.set(r.min(),t,i)}else{if(a.length<e._size.length)throw new l(a.length,e._size.length,"<");if(o.length<a.length){for(var f=0,m=0;1===a[f]&&1===o[f];)f++;for(;1===a[f];)m++,f++;t=h.unsqueeze(t,a.length,m,o)}if(!g.deepEqual(a,o))throw new l(a,o,">");var d=r.max().map(function(e){return e+1});u(e,d,i);var w=a.length,x=0;s(e._data,r,t,w,x)}return e}function s(e,r,t,n,i){var o=i==n-1,a=r.range(i);a.forEach(o?function(r,n){w(r),e[r]=t[n]}:function(o,a){w(o),s(e[o],r,t[a],n,i+1)})}function u(e,r,t){for(var n=g.clone(e._size),i=!1;n.length<r.length;)n.push(0),i=!0;for(var o=0,a=r.length;a>o;o++)r[o]>n[o]&&(n[o]=r[o],i=!0);i&&e.resize(n,t)}function c(e){for(var r=0,t=e.length;t>r;r++){var i=e[r];d(i)?e[r]=c(i):i instanceof n&&(e[r]=c(i._data))}return e}var f=t(171),l=t(168),p=t(9),m=(f.number,f.string),h=f.array,g=f.object,d=Array.isArray,w=h.validateIndex;n.isMatrix=function(e){return e instanceof n},n.prototype.subset=function(e,r,t){switch(arguments.length){case 1:return i(this,e);case 2:case 3:return a(this,e,r,t);default:throw new SyntaxError("Wrong number of arguments")}},n.prototype.get=function(e){if(!d(e))throw new TypeError("Array expected");if(e.length!=this._size.length)throw new l(e.length,this._size.length);for(var r=this._data,t=0,n=e.length;n>t;t++){var i=e[t];w(i,r.length),r=r[i]}return g.clone(r)},n.prototype.set=function(e,r,t){var n,i;if(!d(e))throw new Error("Array expected");if(e.length<this._size.length)throw new l(e.length,this._size.length,"<");var o=e.map(function(e){return e+1});u(this,o,t);var a=this._data;for(n=0,i=e.length-1;i>n;n++){var s=e[n];w(s,a.length),a=a[s]}return s=e[e.length-1],w(s,a.length),a[s]=r,this},n.prototype.resize=function(e,r){return this._size=g.clone(e),this._data=h.resize(this._data,this._size,r),this},n.prototype.clone=function(){var e=new n;return e._data=g.clone(this._data),e._size=g.clone(this._size),e},n.prototype.size=function(){return this._size},n.prototype.map=function(e){var r=this,t=new n,i=function(t,n){return d(t)?t.map(function(e,r){return i(e,n.concat(r))}):e(t,n,r)};return t._data=i(this._data,[]),t._size=g.clone(this._size),t},n.prototype.forEach=function(e){var r=this,t=function(n,i){d(n)?n.forEach(function(e,r){t(e,i.concat(r))}):e(n,i,r)};t(this._data,[])},n.prototype.toArray=function(){return g.clone(this._data)},n.prototype.valueOf=function(){return this._data},n.prototype.format=function(e){return m.format(this._data,e)},n.prototype.toString=function(){return m.format(this._data)},n.prototype.toJSON=function(){return{mathjs:"Matrix",data:this._data}},n.fromJSON=function(e){return new n(e.data)},e.exports=n},function(e,r,t){"use strict";function n(e,r){if(!(this instanceof n))throw new Error("Constructor must be called with the new operator");if(void 0!=e&&!x(e))throw new TypeError("First parameter in Unit constructor must be a number");if(void 0!=r&&(!v(r)||""==r))throw new TypeError("Second parameter in Unit constructor must be a string");if(void 0!=r){var t=l(r);if(!t)throw new SyntaxError('Unknown unit "'+r+'"');this.unit=t.unit,this.prefix=t.prefix}else this.unit=M,this.prefix=b;this.value=void 0!=e?this._normalize(e):null,this.fixPrefix=!1}function i(){for(;" "==h||"	"==h;)s()}function o(e){return e>="0"&&"9">=e||"."==e}function a(e){return e>="0"&&"9">=e}function s(){m++,h=p.charAt(m)}function u(e){m=e,h=p.charAt(m)}function c(){var e,r="";if(e=m,"+"==h?s():"-"==h&&(r+=h,s()),!o(h))return u(e),null;if("."==h){if(r+=h,s(),!a(h))return u(e),null}else{for(;a(h);)r+=h,s();"."==h&&(r+=h,s())}for(;a(h);)r+=h,s();if("E"==h||"e"==h){if(r+=h,s(),("+"==h||"-"==h)&&(r+=h,s()),!a(h))return u(e),null;for(;a(h);)r+=h,s()}return r}function f(){var e="";for(i();h&&" "!=h&&"	"!=h;)e+=h,s();return e||null}function l(e){for(var r in A)if(A.hasOwnProperty(r)&&w.endsWith(e,r)){var t=A[r],n=e.length-r.length,i=e.substring(0,n),o=t.prefixes[i];if(void 0!==o)return{unit:t,prefix:o}}return null}var p,m,h,g=t(171),d=g.number,w=g.string,x=g.number.isNumber,v=g.string.isString;n.parse=function(e){if(p=e,m=-1,h="",!v(p))return null;s(),i();var r,t=c();if(t){if(r=f(),s(),i(),h)return null;if(t&&r)try{return new n(Number(t),r)}catch(o){}}else{if(r=f(),s(),i(),h)return null;if(r)try{return new n(null,r)}catch(o){}}return null},n.isUnit=function(e){return e instanceof n},n.prototype.clone=function(){var e=new n;for(var r in this)this.hasOwnProperty(r)&&(e[r]=this[r]);return e},n.prototype._normalize=function(e){return(e+this.unit.offset)*this.unit.value*this.prefix.value},n.prototype._denormalize=function(e,r){return void 0==r?e/this.unit.value/this.prefix.value-this.unit.offset:e/this.unit.value/r-this.unit.offset},n.isValuelessUnit=function(e){return null!=l(e)},n.prototype.hasBase=function(e){return this.unit.base===e},n.prototype.equalBase=function(e){return this.unit.base===e.unit.base},n.prototype.equals=function(e){return this.equalBase(e)&&this.value==e.value},n.prototype.to=function(e){var r,t=null==this.value?this._normalize(1):this.value;if(v(e)){if(r=new n(null,e),!this.equalBase(r))throw new Error("Units do not match");return r.value=t,r.fixPrefix=!0,r}if(e instanceof n){if(!this.equalBase(e))throw new Error("Units do not match");if(null!==e.value)throw new Error("Cannot convert to a unit with a value");return r=e.clone(),r.value=t,r.fixPrefix=!0,r}throw new Error("String or Unit expected as parameter")},n.prototype.toNumber=function(e){var r=this.to(e);return r._denormalize(r.value,r.prefix.value)},n.prototype.toString=function(){return this.format()},n.prototype.toJSON=function(){return{mathjs:"Unit",value:this._denormalize(this.value),unit:this.prefix.name+this.unit.name,fixPrefix:this.fixPrefix}},n.fromJSON=function(e){var r=new n(e.value,e.unit);return r.fixPrefix=e.fixPrefix||!1,r},n.prototype.valueOf=n.prototype.toString,n.prototype.format=function(e){var r,t;if(null===this.value||this.fixPrefix)r=this._denormalize(this.value),t=null!==this.value?d.format(r,e)+" ":"",t+=this.prefix.name+this.unit.name;else{var n=this._bestPrefix();r=this._denormalize(this.value,n.value),t=d.format(r,e)+" ",t+=n.name+this.unit.name}return t},n.prototype._bestPrefix=function(){var e=Math.abs(this.value/this.unit.value),r=b,t=Math.abs(Math.log(e/r.value)/Math.LN10-1.2),n=this.unit.prefixes;for(var i in n)if(n.hasOwnProperty(i)){var o=n[i];if(o.scientific){var a=Math.abs(Math.log(e/o.value)/Math.LN10-1.2);t>a&&(r=o,t=a)}}return r};var y={NONE:{"":{name:"",value:1,scientific:!0}},SHORT:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:10,scientific:!1},h:{name:"h",value:100,scientific:!1},k:{name:"k",value:1e3,scientific:!0},M:{name:"M",value:1e6,scientific:!0},G:{name:"G",value:1e9,scientific:!0},T:{name:"T",value:1e12,scientific:!0},P:{name:"P",value:1e15,scientific:!0},E:{name:"E",value:1e18,scientific:!0},Z:{name:"Z",value:1e21,scientific:!0},Y:{name:"Y",value:1e24,scientific:!0},d:{name:"d",value:.1,scientific:!1},c:{name:"c",value:.01,scientific:!1},m:{name:"m",value:.001,scientific:!0},u:{name:"u",value:1e-6,scientific:!0},n:{name:"n",value:1e-9,scientific:!0},p:{name:"p",value:1e-12,scientific:!0},f:{name:"f",value:1e-15,scientific:!0},a:{name:"a",value:1e-18,scientific:!0},z:{name:"z",value:1e-21,scientific:!0},y:{name:"y",value:1e-24,scientific:!0}},LONG:{"":{name:"",value:1,scientific:!0},deca:{name:"deca",value:10,scientific:!1},hecto:{name:"hecto",value:100,scientific:!1},kilo:{name:"kilo",value:1e3,scientific:!0},mega:{name:"mega",value:1e6,scientific:!0},giga:{name:"giga",value:1e9,scientific:!0},tera:{name:"tera",value:1e12,scientific:!0},peta:{name:"peta",value:1e15,scientific:!0},exa:{name:"exa",value:1e18,scientific:!0},zetta:{name:"zetta",value:1e21,scientific:!0},yotta:{name:"yotta",value:1e24,scientific:!0},deci:{name:"deci",value:.1,scientific:!1},centi:{name:"centi",value:.01,scientific:!1},milli:{name:"milli",value:.001,scientific:!0},micro:{name:"micro",value:1e-6,scientific:!0},nano:{name:"nano",value:1e-9,scientific:!0},pico:{name:"pico",value:1e-12,scientific:!0},femto:{name:"femto",value:1e-15,scientific:!0},atto:{name:"atto",value:1e-18,scientific:!0},zepto:{name:"zepto",value:1e-21,scientific:!0},yocto:{name:"yocto",value:1e-24,scientific:!0}},SQUARED:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:100,scientific:!1},h:{name:"h",value:1e4,scientific:!1},k:{name:"k",value:1e6,scientific:!0},M:{name:"M",value:1e12,scientific:!0},G:{name:"G",value:1e18,scientific:!0},T:{name:"T",value:1e24,scientific:!0},P:{name:"P",value:1e30,scientific:!0},E:{name:"E",value:1e36,scientific:!0},Z:{name:"Z",value:1e42,scientific:!0},Y:{name:"Y",value:1e48,scientific:!0},d:{name:"d",value:.01,scientific:!1},c:{name:"c",value:1e-4,scientific:!1},m:{name:"m",value:1e-6,scientific:!0},u:{name:"u",value:1e-12,scientific:!0},n:{name:"n",value:1e-18,scientific:!0},p:{name:"p",value:1e-24,scientific:!0},f:{name:"f",value:1e-30,scientific:!0},a:{name:"a",value:1e-36,scientific:!0},z:{name:"z",value:1e-42,scientific:!0},y:{name:"y",value:1e-42,scientific:!0}},CUBIC:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:1e3,scientific:!1},h:{name:"h",value:1e6,scientific:!1},k:{name:"k",value:1e9,scientific:!0},M:{name:"M",value:1e18,scientific:!0},G:{name:"G",value:1e27,scientific:!0},T:{name:"T",value:1e36,scientific:!0},P:{name:"P",value:1e45,scientific:!0},E:{name:"E",value:1e54,scientific:!0},Z:{name:"Z",value:1e63,scientific:!0},Y:{name:"Y",value:1e72,scientific:!0},d:{name:"d",value:.001,scientific:!1},c:{name:"c",value:1e-6,scientific:!1},m:{name:"m",value:1e-9,scientific:!0},u:{name:"u",value:1e-18,scientific:!0},n:{name:"n",value:1e-27,scientific:!0},p:{name:"p",value:1e-36,scientific:!0},f:{name:"f",value:1e-45,scientific:!0},a:{name:"a",value:1e-54,scientific:!0},z:{name:"z",value:1e-63,scientific:!0},y:{name:"y",value:1e-72,scientific:!0}},BINARY_SHORT:{"":{name:"",value:1,scientific:!0},k:{name:"k",value:1024,scientific:!0},M:{name:"M",value:Math.pow(1024,2),scientific:!0},G:{name:"G",value:Math.pow(1024,3),scientific:!0},T:{name:"T",value:Math.pow(1024,4),scientific:!0},P:{name:"P",value:Math.pow(1024,5),scientific:!0},E:{name:"E",value:Math.pow(1024,6),scientific:!0},Z:{name:"Z",value:Math.pow(1024,7),scientific:!0},Y:{name:"Y",value:Math.pow(1024,8),scientific:!0},Ki:{name:"Ki",value:1024,scientific:!0},Mi:{name:"Mi",value:Math.pow(1024,2),scientific:!0},Gi:{name:"Gi",value:Math.pow(1024,3),scientific:!0},Ti:{name:"Ti",value:Math.pow(1024,4),scientific:!0},Pi:{name:"Pi",value:Math.pow(1024,5),scientific:!0},Ei:{name:"Ei",value:Math.pow(1024,6),scientific:!0},Zi:{name:"Zi",value:Math.pow(1024,7),scientific:!0},Yi:{name:"Yi",value:Math.pow(1024,8),scientific:!0}},BINARY_LONG:{"":{name:"",value:1,scientific:!0},kilo:{name:"kilo",value:1024,scientific:!0},mega:{name:"mega",value:Math.pow(1024,2),scientific:!0},giga:{name:"giga",value:Math.pow(1024,3),scientific:!0},tera:{name:"tera",value:Math.pow(1024,4),scientific:!0},peta:{name:"peta",value:Math.pow(1024,5),scientific:!0},exa:{name:"exa",value:Math.pow(1024,6),scientific:!0},zetta:{name:"zetta",value:Math.pow(1024,7),scientific:!0},yotta:{name:"yotta",value:Math.pow(1024,8),scientific:!0},kibi:{name:"kibi",value:1024,scientific:!0},mebi:{name:"mebi",value:Math.pow(1024,2),scientific:!0},gibi:{name:"gibi",value:Math.pow(1024,3),scientific:!0},tebi:{name:"tebi",value:Math.pow(1024,4),scientific:!0},pebi:{name:"pebi",value:Math.pow(1024,5),scientific:!0},exi:{name:"exi",value:Math.pow(1024,6),scientific:!0},zebi:{name:"zebi",value:Math.pow(1024,7),scientific:!0},yobi:{name:"yobi",value:Math.pow(1024,8),scientific:!0}}},b={name:"",value:1,scientific:!0},E={NONE:{},LENGTH:{},MASS:{},TIME:{},CURRENT:{},TEMPERATURE:{},LUMINOUS_INTENSITY:{},AMOUNT_OF_SUBSTANCE:{},FORCE:{},SURFACE:{},VOLUME:{},ANGLE:{},BIT:{}},N={},M={name:"",base:N,value:1,offset:0},A={meter:{name:"meter",base:E.LENGTH,prefixes:y.LONG,value:1,offset:0},inch:{name:"inch",base:E.LENGTH,prefixes:y.NONE,value:.0254,offset:0},foot:{name:"foot",base:E.LENGTH,prefixes:y.NONE,value:.3048,offset:0},yard:{name:"yard",base:E.LENGTH,prefixes:y.NONE,value:.9144,offset:0},mile:{name:"mile",base:E.LENGTH,prefixes:y.NONE,value:1609.344,offset:0},link:{name:"link",base:E.LENGTH,prefixes:y.NONE,value:.201168,offset:0},rod:{name:"rod",base:E.LENGTH,prefixes:y.NONE,value:5.02921,offset:0},chain:{name:"chain",base:E.LENGTH,prefixes:y.NONE,value:20.1168,offset:0},angstrom:{name:"angstrom",base:E.LENGTH,prefixes:y.NONE,value:1e-10,offset:0},m:{name:"m",base:E.LENGTH,prefixes:y.SHORT,value:1,offset:0},"in":{name:"in",base:E.LENGTH,prefixes:y.NONE,value:.0254,offset:0},ft:{name:"ft",base:E.LENGTH,prefixes:y.NONE,value:.3048,offset:0},yd:{name:"yd",base:E.LENGTH,prefixes:y.NONE,value:.9144,offset:0},mi:{name:"mi",base:E.LENGTH,prefixes:y.NONE,value:1609.344,offset:0},li:{name:"li",base:E.LENGTH,prefixes:y.NONE,value:.201168,offset:0},rd:{name:"rd",base:E.LENGTH,prefixes:y.NONE,value:5.02921,offset:0},ch:{name:"ch",base:E.LENGTH,prefixes:y.NONE,value:20.1168,offset:0},mil:{name:"mil",base:E.LENGTH,prefixes:y.NONE,value:254e-7,offset:0},m2:{name:"m2",base:E.SURFACE,prefixes:y.SQUARED,value:1,offset:0},sqin:{name:"sqin",base:E.SURFACE,prefixes:y.NONE,value:64516e-8,offset:0},sqft:{name:"sqft",base:E.SURFACE,prefixes:y.NONE,value:.09290304,offset:0},sqyd:{name:"sqyd",base:E.SURFACE,prefixes:y.NONE,value:.83612736,offset:0},sqmi:{name:"sqmi",base:E.SURFACE,prefixes:y.NONE,value:2589988.110336,offset:0},sqrd:{name:"sqrd",base:E.SURFACE,prefixes:y.NONE,value:25.29295,offset:0},sqch:{name:"sqch",base:E.SURFACE,prefixes:y.NONE,value:404.6873,offset:0},sqmil:{name:"sqmil",base:E.SURFACE,prefixes:y.NONE,value:6.4516e-10,offset:0},m3:{name:"m3",base:E.VOLUME,prefixes:y.CUBIC,value:1,offset:0},L:{name:"L",base:E.VOLUME,prefixes:y.SHORT,value:.001,offset:0},l:{name:"l",base:E.VOLUME,prefixes:y.SHORT,value:.001,offset:0},litre:{name:"litre",base:E.VOLUME,prefixes:y.LONG,value:.001,offset:0},cuin:{name:"cuin",base:E.VOLUME,prefixes:y.NONE,value:16387064e-12,offset:0},cuft:{name:"cuft",base:E.VOLUME,prefixes:y.NONE,value:.028316846592,offset:0},cuyd:{name:"cuyd",base:E.VOLUME,prefixes:y.NONE,value:.764554857984,offset:0},teaspoon:{name:"teaspoon",base:E.VOLUME,prefixes:y.NONE,value:5e-6,offset:0},tablespoon:{name:"tablespoon",base:E.VOLUME,prefixes:y.NONE,value:15e-6,offset:0},drop:{name:"drop",base:E.VOLUME,prefixes:y.NONE,value:5e-8,offset:0},gtt:{name:"gtt",base:E.VOLUME,prefixes:y.NONE,value:5e-8,offset:0},minim:{name:"minim",base:E.VOLUME,prefixes:y.NONE,value:6.161152e-8,offset:0},fluiddram:{name:"fluiddram",base:E.VOLUME,prefixes:y.NONE,value:36966911e-13,offset:0},fluidounce:{name:"fluidounce",base:E.VOLUME,prefixes:y.NONE,value:2957353e-11,offset:0},gill:{name:"gill",base:E.VOLUME,prefixes:y.NONE,value:.0001182941,offset:0},cc:{name:"cc",base:E.VOLUME,prefixes:y.NONE,value:1e-6,offset:0},cup:{name:"cup",base:E.VOLUME,prefixes:y.NONE,value:.0002365882,offset:0},pint:{name:"pint",base:E.VOLUME,prefixes:y.NONE,value:.0004731765,offset:0},quart:{name:"quart",base:E.VOLUME,prefixes:y.NONE,value:.0009463529,offset:0},gallon:{name:"gallon",base:E.VOLUME,prefixes:y.NONE,value:.003785412,offset:0},beerbarrel:{name:"beerbarrel",base:E.VOLUME,prefixes:y.NONE,value:.1173478,offset:0},oilbarrel:{name:"oilbarrel",base:E.VOLUME,prefixes:y.NONE,value:.1589873,offset:0},hogshead:{name:"hogshead",base:E.VOLUME,prefixes:y.NONE,value:.238481,offset:0},fldr:{name:"fldr",base:E.VOLUME,prefixes:y.NONE,value:36966911e-13,offset:0},floz:{name:"floz",base:E.VOLUME,prefixes:y.NONE,value:2957353e-11,offset:0},gi:{name:"gi",base:E.VOLUME,prefixes:y.NONE,value:.0001182941,offset:0},cp:{name:"cp",base:E.VOLUME,prefixes:y.NONE,value:.0002365882,offset:0},pt:{name:"pt",base:E.VOLUME,prefixes:y.NONE,value:.0004731765,offset:0},qt:{name:"qt",base:E.VOLUME,prefixes:y.NONE,value:.0009463529,offset:0},gal:{name:"gal",base:E.VOLUME,prefixes:y.NONE,value:.003785412,offset:0},bbl:{name:"bbl",base:E.VOLUME,prefixes:y.NONE,value:.1173478,offset:0},obl:{name:"obl",base:E.VOLUME,prefixes:y.NONE,value:.1589873,offset:0},g:{name:"g",base:E.MASS,prefixes:y.SHORT,value:.001,offset:0},gram:{name:"gram",base:E.MASS,prefixes:y.LONG,value:.001,offset:0},ton:{name:"ton",base:E.MASS,prefixes:y.SHORT,value:907.18474,offset:0},tonne:{name:"tonne",base:E.MASS,prefixes:y.SHORT,value:1e3,offset:0},grain:{name:"grain",base:E.MASS,prefixes:y.NONE,value:6479891e-11,offset:0},dram:{name:"dram",base:E.MASS,prefixes:y.NONE,value:.0017718451953125,offset:0},ounce:{name:"ounce",base:E.MASS,prefixes:y.NONE,value:.028349523125,offset:0},poundmass:{name:"poundmass",base:E.MASS,prefixes:y.NONE,value:.45359237,offset:0},hundredweight:{name:"hundredweight",base:E.MASS,prefixes:y.NONE,value:45.359237,offset:0},stick:{name:"stick",base:E.MASS,prefixes:y.NONE,value:.115,offset:0},gr:{name:"gr",base:E.MASS,prefixes:y.NONE,value:6479891e-11,offset:0},dr:{name:"dr",base:E.MASS,prefixes:y.NONE,value:.0017718451953125,offset:0},oz:{name:"oz",base:E.MASS,prefixes:y.NONE,value:.028349523125,offset:0},lbm:{name:"lbm",base:E.MASS,prefixes:y.NONE,value:.45359237,offset:0},cwt:{name:"cwt",base:E.MASS,prefixes:y.NONE,value:45.359237,offset:0},s:{name:"s",base:E.TIME,prefixes:y.SHORT,value:1,offset:0},min:{name:"min",base:E.TIME,prefixes:y.NONE,value:60,offset:0},h:{name:"h",base:E.TIME,prefixes:y.NONE,value:3600,offset:0},second:{name:"second",base:E.TIME,prefixes:y.LONG,value:1,offset:0},sec:{name:"sec",base:E.TIME,prefixes:y.LONG,value:1,offset:0},minute:{name:"minute",base:E.TIME,prefixes:y.NONE,value:60,offset:0},hour:{name:"hour",base:E.TIME,prefixes:y.NONE,value:3600,offset:0},day:{name:"day",base:E.TIME,prefixes:y.NONE,value:86400,offset:0},rad:{name:"rad",base:E.ANGLE,prefixes:y.NONE,value:1,offset:0},deg:{name:"deg",base:E.ANGLE,prefixes:y.NONE,value:.017453292519943295,offset:0},grad:{name:"grad",base:E.ANGLE,prefixes:y.NONE,value:.015707963267948967,offset:0},cycle:{name:"cycle",base:E.ANGLE,prefixes:y.NONE,value:6.283185307179586,offset:0},A:{name:"A",base:E.CURRENT,prefixes:y.SHORT,value:1,offset:0},ampere:{name:"ampere",base:E.CURRENT,prefixes:y.LONG,value:1,offset:0},K:{name:"K",base:E.TEMPERATURE,prefixes:y.NONE,value:1,offset:0},degC:{name:"degC",base:E.TEMPERATURE,prefixes:y.NONE,value:1,offset:273.15},degF:{name:"degF",base:E.TEMPERATURE,prefixes:y.NONE,value:1/1.8,offset:459.67},degR:{name:"degR",base:E.TEMPERATURE,prefixes:y.NONE,value:1/1.8,offset:0},kelvin:{name:"kelvin",base:E.TEMPERATURE,prefixes:y.NONE,value:1,offset:0},celsius:{name:"celsius",base:E.TEMPERATURE,prefixes:y.NONE,value:1,offset:273.15},fahrenheit:{name:"fahrenheit",base:E.TEMPERATURE,prefixes:y.NONE,value:1/1.8,offset:459.67},rankine:{name:"rankine",base:E.TEMPERATURE,prefixes:y.NONE,value:1/1.8,offset:0},mol:{name:"mol",base:E.AMOUNT_OF_SUBSTANCE,prefixes:y.NONE,value:1,offset:0},mole:{name:"mole",base:E.AMOUNT_OF_SUBSTANCE,prefixes:y.NONE,value:1,offset:0},cd:{name:"cd",base:E.LUMINOUS_INTENSITY,prefixes:y.NONE,value:1,offset:0},candela:{name:"candela",base:E.LUMINOUS_INTENSITY,prefixes:y.NONE,value:1,offset:0},N:{name:"N",base:E.FORCE,prefixes:y.SHORT,value:1,offset:0},newton:{name:"newton",base:E.FORCE,prefixes:y.LONG,value:1,offset:0},lbf:{name:"lbf",base:E.FORCE,prefixes:y.NONE,value:4.4482216152605,offset:0},poundforce:{name:"poundforce",base:E.FORCE,prefixes:y.NONE,value:4.4482216152605,offset:0},b:{name:"b",base:E.BIT,prefixes:y.BINARY_SHORT,value:1,offset:0},bits:{name:"bits",base:E.BIT,prefixes:y.BINARY_LONG,value:1,offset:0},B:{name:"B",base:E.BIT,prefixes:y.BINARY_SHORT,value:8,offset:0},bytes:{name:"bytes",base:E.BIT,prefixes:y.BINARY_LONG,value:8,offset:0}},T={meters:"meter",inches:"inch",feet:"foot",yards:"yard",miles:"mile",links:"link",rods:"rod",chains:"chain",angstroms:"angstrom",litres:"litre",teaspoons:"teaspoon",tablespoons:"tablespoon",minims:"minim",fluiddrams:"fluiddram",fluidounces:"fluidounce",gills:"gill",cups:"cup",pints:"pint",quarts:"quart",gallons:"gallon",beerbarrels:"beerbarrel",oilbarrels:"oilbarrel",hogsheads:"hogshead",gtts:"gtt",grams:"gram",tons:"ton",tonnes:"tonne",grains:"grain",drams:"dram",ounces:"ounce",poundmasses:"poundmass",hundredweights:"hundredweight",sticks:"stick",seconds:"second",minutes:"minute",hours:"hour",days:"day",radians:"rad",degrees:"deg",gradients:"grad",cycles:"cycle",amperes:"ampere",moles:"mole"};
for(var S in T)if(T.hasOwnProperty(S)){var O=A[T[S]],C=Object.create(O);C.name=S,A[S]=C}A.lt=A.l,A.liter=A.litre,A.liters=A.litres,A.lb=A.lbm,A.lbs=A.lbm,n.PREFIXES=y,n.BASE_UNITS=E,n.UNITS=A,e.exports=n},function(e,r,t){"use strict";function n(e){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(!e)throw new Error('Argument "doc" missing');this.doc=e}var i=t(171),o=i.object,a=i.string;n.isHelp=function(e){return e instanceof n},n.prototype.toText=function(e){var r=this.doc||{},t="\n";if(r.name&&(t+="Name: "+r.name+"\n\n"),r.category&&(t+="Category: "+r.category+"\n\n"),r.description&&(t+="Description:\n    "+r.description+"\n\n"),r.syntax&&(t+="Syntax:\n    "+r.syntax.join("\n    ")+"\n\n"),r.examples){var i=e&&e.parser();t+="Examples:\n";for(var o=0;o<r.examples.length;o++){var s=r.examples[o];if(t+="    "+s+"\n",i){var u;try{u=i.eval(s)}catch(c){u=c}void 0===u||u instanceof n||(t+="        "+a.format(u,{precision:14})+"\n")}}t+="\n"}return r.seealso&&(t+="See also: "+r.seealso.join(", ")+"\n"),t},n.prototype.toString=function(){return this.toText()},n.prototype.toJSON=function(){var e=o.clone(this.doc);return e.mathjs="Help",e},n.fromJSON=function(e){var r={};for(var t in e)"mathjs"!==t&&(r[t]=e[t]);return new n(r)},n.prototype.valueOf=n.prototype.toString,e.exports=n},function(e){"use strict";function r(e){if(!(this instanceof r))throw new SyntaxError("Constructor must be called with the new operator");this.entries=e||[]}r.prototype.valueOf=function(){return this.entries},r.prototype.toString=function(){return"["+this.entries.join(", ")+"]"},r.prototype.toJSON=function(){return{mathjs:"ResultSet",entries:this.entries}},r.fromJSON=function(e){return new r(e.entries)},e.exports=r},function(e,r,t){"use strict";function n(e,r,t){var o,a,s,u;if(0>=r){if(f(e[0])){for(u=i(e),a=[],o=0;o<u.length;o++)a[o]=n(u[o],r-1,t);return a}for(s=e[0],o=1;o<e.length;o++)s=t(s,e[o]);return s}for(a=[],o=0;o<e.length;o++)a[o]=n(e[o],r-1,t);return a}function i(e){var r,t,n=e.length,i=e[0].length,o=[];for(t=0;i>t;t++){var a=[];for(r=0;n>r;r++)a.push(e[r][t]);o.push(a)}return o}{var o=t(171),a=t(169),s=t(168),u=t(10),c=o.array,f=o.array.isArray;o.string.isString}r.argsToArray=function(e){if(0==e.length)return[];if(1==e.length){var r=e[0];return r instanceof u&&(r=r.valueOf()),f(r)||(r=[r]),r}return o.array.argsToArray(e)},r.isCollection=function(e){return f(e)||e instanceof u},r.deepMap=function l(e,r){return e&&"function"==typeof e.map?e.map(function(e){return l(e,r)}):r(e)},r.deepMap2=function p(e,r,t){var n,i,o;if(f(e))if(f(r)){if(e.length!=r.length)throw new s(e.length,r.length);for(n=[],i=e.length,o=0;i>o;o++)n[o]=p(e[o],r[o],t)}else{if(r instanceof u)return n=p(e,r.valueOf(),t),new u(n);for(n=[],i=e.length,o=0;i>o;o++)n[o]=p(e[o],r,t)}else{if(e instanceof u)return r instanceof u?(n=p(e.valueOf(),r.valueOf(),t),new u(n)):(n=p(e.valueOf(),r,t),new u(n));if(f(r))for(n=[],i=r.length,o=0;i>o;o++)n[o]=p(e,r[o],t);else{if(r instanceof u)return n=p(e,r.valueOf(),t),new u(n);n=t(e,r)}}return n},r.reduce=function(e,r,t){var i=f(e)?c.size(e):e.size();if(0>r)throw new a(r);if(r>=i.length)throw new a(r,i.length);return e instanceof u?new u(n(e.valueOf(),r,t)):n(e,r,t)},r.deepForEach=function m(e,r){e instanceof u&&(e=e.valueOf());for(var t=0,n=e.length;n>t;t++){var i=e[t];f(i)?m(i,r):r(i)}}},function(e,r,t){"use strict";r.ArrayNode=t(172),r.AssignmentNode=t(173),r.BlockNode=t(174),r.ConditionalNode=t(175),r.ConstantNode=t(176),r.IndexNode=t(177),r.FunctionAssignmentNode=t(178),r.FunctionNode=t(179),r.Node=t(180),r.OperatorNode=t(181),r.RangeNode=t(182),r.SymbolNode=t(183),r.UpdateNode=t(184)},function(e,r,t){"use strict";function n(e,r){if(1!=arguments.length&&2!=arguments.length)throw new J("parse",arguments.length,1,2);if(gr=r&&r.nodes?r.nodes:{},X(e))return dr=e,g();if(Q(e)||e instanceof K)return $.deepMap(e,function(e){if(!X(e))throw new TypeError("String expected");return dr=e,g()});throw new TypeError("String or matrix expected")}function i(){wr=0,xr=dr.charAt(0),br=0,Er=null}function o(){wr++,xr=dr.charAt(wr)}function a(){return dr.charAt(wr+1)}function s(){return dr.charAt(wr+2)}function u(){for(yr=pr.NULL,vr="";" "==xr||"	"==xr||"\n"==xr&&br;)o();if("#"==xr)for(;"\n"!=xr&&""!=xr;)o();if(""==xr)return void(yr=pr.DELIMITER);if("\n"==xr&&!br)return yr=pr.DELIMITER,vr=xr,void o();var e=xr+a(),r=e+s();if(3==r.length&&mr[r])return yr=pr.DELIMITER,vr=r,o(),o(),void o();if(2==e.length&&mr[e])return yr=pr.DELIMITER,vr=e,o(),void o();if(mr[xr])return yr=pr.DELIMITER,vr=xr,void o();if(!m(xr)){if(p(xr)){for(;p(xr)||h(xr);)vr+=xr,o();return void(yr=hr[vr]?pr.DELIMITER:pr.SYMBOL)}for(yr=pr.UNKNOWN;""!=xr;)vr+=xr,o();throw H('Syntax error in part "'+vr+'"')}if(yr=pr.NUMBER,"."==xr)vr+=xr,o(),h(xr)||(yr=pr.UNKNOWN);else{for(;h(xr);)vr+=xr,o();"."==xr&&(vr+=xr,o())}for(;h(xr);)vr+=xr,o();if(e=a(),("E"==xr||"e"==xr)&&(h(e)||"-"==e||"+"==e))for(vr+=xr,o(),("+"==xr||"-"==xr)&&(vr+=xr,o()),h(xr)||(yr=pr.UNKNOWN);h(xr);)vr+=xr,o()}function c(){do u();while("\n"==vr)}function f(){br++}function l(){br--}function p(e){return e>="a"&&"z">=e||e>="A"&&"Z">=e||"_"==e}function m(e){return e>="0"&&"9">=e||"."==e}function h(e){return e>="0"&&"9">=e}function g(){i(),u();var e=d();if(""!=vr)throw yr==pr.DELIMITER?Y("Unexpected operator "+vr):H('Unexpected part "'+vr+'"');return e}function d(){var e,r,t=[];if(""==vr)return new ir("undefined","undefined");for("\n"!=vr&&";"!=vr&&(e=w());"\n"==vr||";"==vr;)0==t.length&&e&&(r=";"!=vr,t.push({node:e,visible:r})),u(),"\n"!=vr&&";"!=vr&&""!=vr&&(e=w(),r=";"!=vr,t.push({node:e,visible:r}));return t.length>0?new tr(t):e}function w(){if(yr==pr.SYMBOL&&"function"==vr)throw H('Deprecated keyword "function". Functions can now be assigned without it, like "f(x) = x^2".');return x()}function x(){var e,r,t,n,i=v();if("="==vr){if(i instanceof fr)return e=i.name,c(),t=x(),new rr(e,t);if(i instanceof ar)return c(),t=x(),new lr(i,t);if(i instanceof ur&&(n=!0,r=[],e=i.name,i.args.forEach(function(e,t){e instanceof fr?r[t]=e.name:n=!1}),n))return c(),t=x(),new or(e,r,t);throw H("Invalid left hand side of assignment operator =")}return i}function v(){for(var e=y();"?"==vr;){var r=Er;Er=br,c();var t=e,n=y();if(":"!=vr)throw H("False part of conditional expression expected");Er=null,c();var i=v();e=new nr(t,n,i),Er=r}return e}function y(){for(var e=b();"or"==vr;)c(),e=new sr("or","or",[e,b()]);return e}function b(){for(var e=E();"xor"==vr;)c(),e=new sr("xor","xor",[e,E()]);return e}function E(){for(var e=N();"and"==vr;)c(),e=new sr("and","and",[e,N()]);return e}function N(){for(var e=M();"|"==vr;)c(),e=new sr("|","bitOr",[e,M()]);return e}function M(){for(var e=A();"^|"==vr;)c(),e=new sr("^|","bitXor",[e,A()]);return e}function A(){for(var e=T();"&"==vr;)c(),e=new sr("&","bitAnd",[e,T()]);return e}function T(){var e,r,t,n,i;for(e=S(),r={"==":"equal","!=":"unequal","<":"smaller",">":"larger","<=":"smallerEq",">=":"largerEq"};vr in r;)t=vr,n=r[t],c(),i=[e,S()],e=new sr(t,n,i);return e}function S(){var e,r,t,n,i;for(e=O(),r={"<<":"leftShift",">>":"rightArithShift",">>>":"rightLogShift"};vr in r;)t=vr,n=r[t],c(),i=[e,O()],e=new sr(t,n,i);return e}function O(){var e,r,t,n,i;for(e=C(),r={to:"to","in":"to"};vr in r;)t=vr,n=r[t],c(),i=[e,C()],e=new sr(t,n,i);return e}function C(){var e,r=[];if(e=":"==vr?new ir("1","number"):B(),":"==vr&&Er!==br){for(r.push(e);":"==vr&&r.length<3;)c(),r.push(")"==vr||"]"==vr||","==vr||""==vr?new fr("end"):B());e=3==r.length?new cr(r[0],r[2],r[1]):new cr(r[0],r[1])}return e}function B(){var e,r,t,n,i;for(e=U(),r={"+":"add","-":"subtract"};vr in r;)t=vr,n=r[t],c(),i=[e,U()],e=new sr(t,n,i);return e}function U(){var e,r,t,n,i;if(e=q(),r={"*":"multiply",".*":"dotMultiply","/":"divide","./":"dotDivide","%":"mod",mod:"mod"},vr in r)for(;vr in r;)t=vr,n=r[t],c(),i=[e,q()],e=new sr(t,n,i);return(yr==pr.SYMBOL||"in"==vr&&e instanceof ir||yr==pr.NUMBER&&!(e instanceof ir)||"("==vr||"["==vr)&&(e=new sr("*","multiply",[e,U()])),e}function q(){var e,r,t={"-":"unaryMinus","+":"unaryPlus","~":"bitNot",not:"not"}[vr];return t?(e=vr,c(),r=[q()],new sr(e,t,r)):_()}function _(){var e,r,t,n;return e=z(),("^"==vr||".^"==vr)&&(r=vr,t="^"==r?"pow":"dotPow",c(),n=[e,q()],e=new sr(r,t,n)),e}function z(){var e,r,t,n,i;for(e=I(),r={"!":"factorial","'":"transpose"};vr in r;)t=vr,n=r[t],u(),i=[e],e=new sr(t,n,i);return e}function I(){var e,r=[];if(yr==pr.SYMBOL&&gr[vr]){if(e=gr[vr],u(),"("==vr){if(r=[],f(),u(),")"!=vr)for(r.push(v());","==vr;)u(),r.push(v());if(")"!=vr)throw H("Parenthesis ) expected");l(),u()}return new e(r)}return P()}function P(){var e,r;return yr==pr.SYMBOL||yr==pr.DELIMITER&&vr in hr?(r=vr,u(),e=R(r),e=L(e)):F()}function R(e){var r;if("("==vr){if(r=[],f(),u(),")"!=vr)for(r.push(v());","==vr;)u(),r.push(v());if(")"!=vr)throw H("Parenthesis ) expected");return l(),u(),new ur(e,r)}return new fr(e)}function L(e){for(var r;"["==vr;){if(r=[],f(),u(),"]"!=vr)for(r.push(v());","==vr;)u(),r.push(v());if("]"!=vr)throw H("Parenthesis ] expected");l(),u(),e=new ar(e,r)}return e}function F(){var e,r,t;if('"'==vr){for(r="",t="";""!=xr&&('"'!=xr||"\\"==t);)r+=xr,t=xr,o();if(u(),'"'!=vr)throw H('End of string " expected');return u(),e=new ir(r,"string"),e=L(e)}return k()}function k(){var e,r,t,n;if("["==vr){if(f(),u(),"]"!=vr){var i=j();if(";"==vr){for(t=1,r=[i];";"==vr;)u(),r[t]=j(),t++;if("]"!=vr)throw H("End of matrix ] expected");l(),u(),n=r[0].nodes.length;for(var o=1;t>o;o++)if(r[o].nodes.length!=n)throw Y("Column dimensions mismatch ("+r[o].nodes.length+" != "+n+")");e=new er(r)}else{if("]"!=vr)throw H("End of matrix ] expected");l(),u(),e=i}}else l(),u(),e=new er([]);return e}return D()}function j(){for(var e=[x()],r=1;","==vr;)u(),e[r]=x(),r++;return new er(e)}function D(){var e;return yr==pr.NUMBER?(e=vr,u(),new ir(e,"number")):G()}function G(){var e;if("("==vr){if(f(),u(),e=x(),")"!=vr)throw H("Parenthesis ) expected");return l(),u(),e}return Z()}function Z(){throw H(""==vr?"Unexpected end of expression":"Value expected")}function V(){return wr-vr.length+1}function H(e){var r=V(),t=new SyntaxError(e+" (char "+r+")");return t["char"]=r,t}function Y(e){var r=V(),t=new Error(e+" (char "+r+")");return t["char"]=r,t}var W=t(171),J=t(167),X=W.string.isString,Q=Array.isArray,K=(W.types.type,t(7),t(10)),$=(t(11),t(14)),er=t(172),rr=t(173),tr=t(174),nr=t(175),ir=t(176),or=t(178),ar=t(177),sr=t(181),ur=t(179),cr=t(182),fr=t(183),lr=t(184),pr={NULL:0,DELIMITER:1,NUMBER:2,SYMBOL:3,UNKNOWN:4},mr={",":!0,"(":!0,")":!0,"[":!0,"]":!0,'"':!0,";":!0,"+":!0,"-":!0,"*":!0,".*":!0,"/":!0,"./":!0,"%":!0,"^":!0,".^":!0,"~":!0,"!":!0,"&":!0,"|":!0,"^|":!0,"'":!0,"=":!0,":":!0,"?":!0,"==":!0,"!=":!0,"<":!0,">":!0,"<=":!0,">=":!0,"<<":!0,">>":!0,">>>":!0},hr={mod:!0,to:!0,"in":!0,and:!0,xor:!0,or:!0,not:!0},gr={},dr="",wr=0,xr="",vr="",yr=pr.NULL,br=0,Er=null;e.exports=n},function(e,r,t){"use strict";function n(e){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(!(e instanceof Object))throw new TypeError("Object expected as parameter math");this.math=e,this.scope={}}var i=t(16);n.prototype.parse=function(){throw new Error("Parser.parse is deprecated. Use math.parse instead.")},n.prototype.compile=function(){throw new Error("Parser.compile is deprecated. Use math.compile instead.")},n.prototype.eval=function(e){return i(e).compile(this.math).eval(this.scope)},n.prototype.get=function(e){return this.scope[e]},n.prototype.set=function(e,r){return this.scope[e]=r},n.prototype.remove=function(e){delete this.scope[e]},n.prototype.clear=function(){for(var e in this.scope)this.scope.hasOwnProperty(e)&&delete this.scope[e]},e.exports=n},function(e,r,t){r.e=t(185),r.E=t(185),r["false"]=t(186),r.i=t(187),r.Infinity=t(188),r.LN2=t(189),r.LN10=t(190),r.LOG2E=t(191),r.LOG10E=t(192),r.NaN=t(193),r["null"]=t(194),r.pi=t(195),r.PI=t(195),r.phi=t(196),r.SQRT1_2=t(197),r.SQRT2=t(198),r.tau=t(199),r["true"]=t(200),r.version=t(201),r.abs=t(206),r.add=t(207),r.ceil=t(208),r.cube=t(209),r.divide=t(210),r.dotDivide=t(211),r.dotMultiply=t(212),r.dotPow=t(213),r.exp=t(214),r.fix=t(215),r.floor=t(216),r.gcd=t(217),r.lcm=t(218),r.log=t(219),r.log10=t(220),r.mod=t(221),r.multiply=t(222),r.norm=t(223),r.nthRoot=t(224),r.pow=t(225),r.round=t(226),r.sign=t(227),r.sqrt=t(228),r.square=t(229),r.subtract=t(230),r.unaryMinus=t(231),r.unaryPlus=t(232),r.xgcd=t(233),r.bitAnd=t(234),r.bitNot=t(235),r.bitOr=t(236),r.bitXor=t(237),r.leftShift=t(238),r.rightArithShift=t(239),r.rightLogShift=t(240),r.arg=t(241),r.conj=t(242),r.re=t(243),r.im=t(244),r.bignumber=t(245),r["boolean"]=t(246),r.complex=t(247),r.index=t(248),r.matrix=t(249),r.number=t(250),r.string=t(251),r.unit=t(252),r.eval=t(253),r.help=t(254),r.and=t(255),r.not=t(256),r.or=t(257),r.xor=t(258),r.concat=t(259),r.cross=t(260),r.det=t(261),r.diag=t(262),r.dot=t(263),r.eye=t(264),r.flatten=t(265),r.inv=t(266),r.ones=t(267),r.range=t(268),r.resize=t(269),r.size=t(270),r.squeeze=t(271),r.subset=t(272),r.trace=t(273),r.transpose=t(274),r.zeros=t(275),r.combinations=t(276),r.factorial=t(277),r.gamma=t(278),r.permutations=t(279),r.pickRandom=t(280),r.random=t(281),r.randomInt=t(282),r.compare=t(283),r.deepEqual=t(284),r.equal=t(285),r.larger=t(286),r.largerEq=t(287),r.smaller=t(288),r.smallerEq=t(289),r.unequal=t(290),r.max=t(291),r.mean=t(292),r.median=t(293),r.min=t(294),r.prod=t(295),r.std=t(296),r.sum=t(297),r["var"]=t(298),r.acos=t(299),r.acosh=t(300),r.acot=t(301),r.acoth=t(302),r.acsc=t(303),r.acsch=t(304),r.asec=t(305),r.asech=t(306),r.asin=t(307),r.asinh=t(308),r.atan=t(309),r.atanh=t(310),r.atan2=t(311),r.cos=t(312),r.cosh=t(313),r.cot=t(314),r.coth=t(315),r.csc=t(316),r.csch=t(317),r.sec=t(318),r.sech=t(319),r.sin=t(320),r.sinh=t(321),r.tan=t(322),r.tanh=t(323),r.to=t(324),r.clone=t(325),r.map=t(326),r.filter=t(327),r.forEach=t(328),r.format=t(329),r["import"]=t(330),r.sort=t(331),r["typeof"]=t(332)},function(e,r,t){"use strict";function n(e,r){var t=r&&r.mathjs;switch(t){case"BigNumber":return i.fromJSON(r);case"Complex":return o.fromJSON(r);case"Help":return a.fromJSON(r);case"Index":return s.fromJSON(r);case"Matrix":return u.fromJSON(r);case"Range":return c.fromJSON(r);case"ResultSet":return f.fromJSON(r);case"Unit":return l.fromJSON(r)}return r}var i=t(5),o=t(7),a=t(12),s=t(9),u=t(10),c=t(8),f=t(13),l=t(11);e.exports=n},function(e,r,t){"use strict";var n=t(5),i=t(203).transform,o=t(3).isNumber,a=t(165).argsToArray;e.exports=function(e){var r=function(){var r=a(arguments),t=r.length-1,s=r[t];o(s)?r[t]=s-1:s instanceof n&&(r[t]=s.minus(1));try{return e.concat.apply(e,r)}catch(u){throw i(u)}};return e.concat.transform=r,r}},function(e,r,t){"use strict";var n=t(183),i=(t(204).isBoolean,t(165).argsToArray,t(167));e.exports=function(e){var r=e.filter,t=function(e,t,o){if(2!==e.length)throw new i("filter",arguments.length,2);var a,s=e[0].compile(t).eval(o);if(e[1]instanceof n)a=e[1].compile(t).eval(o);else{var u=o||{},c=e[1].filter(function(e){return e instanceof n&&!(e.name in t)&&!(e.name in u)})[0],f=Object.create(u),l=e[1].compile(t);if(!c)throw new Error("No undefined variable found in filter equation");var p=c.name;a=function(e){return f[p]=e,l.eval(f)}}return r(s,a)};return t.rawArgs=!0,e.filter.transform=t,t}},function(e,r,t){"use strict";var n=t(10);e.exports=function(e){function r(e,r,t){var n=function(e,i){Array.isArray(e)?e.forEach(function(e,r){n(e,i.concat(r+1))}):r(e,i,t)};n(e,[])}var t=function(t,i){if(2!=arguments.length)throw new e.error.ArgumentsError("forEach",arguments.length,2);if(Array.isArray(t))r(t,i,t);else{if(!(t instanceof n))throw new e.error.UnsupportedTypeError("forEach",e["typeof"](t));r(t.valueOf(),i,t)}};return e.forEach.transform=t,t}},function(e,r,t){"use strict";{var n=t(5),i=t(8),o=t(9),a=(t(10),t(3).isNumber);Array.isArray}e.exports=function(e){var r=function(){for(var e=[],r=0,t=arguments.length;t>r;r++){var s=arguments[r];if(s instanceof i)s.start--,s.end-=s.step>0?0:2;else if(a(s))s--;else{if(!(s instanceof n))throw new TypeError("Ranges must be a Number or Range");s=s.toNumber()-1}e[r]=s}var u=new o;return o.apply(u,e),u};return e.index.transform=r,r}},function(e,r,t){"use strict";{var n=t(10);t(5),t(8),t(9),t(3).isNumber,Array.isArray}e.exports=function(e){function r(e,r,t){var n=function(e,i){return Array.isArray(e)?e.map(function(e,r){return n(e,i.concat(r+1))}):r(e,i,t)};return n(e,[])}var t=function(t,i){if(2!=arguments.length)throw new e.error.ArgumentsError("map",arguments.length,2);if(Array.isArray(t))return r(t,i,t);if(t instanceof n)return new n(r(t.valueOf(),i,t));throw new e.error.UnsupportedTypeError("map",e["typeof"](t))};return e.map.transform=t,t}},function(e,r,t){"use strict";var n=t(5),i=t(203).transform,o=t(3).isNumber,a=t(14).isCollection,s=t(165).argsToArray;e.exports=function(e){var r=function(){var r=s(arguments);if(2==r.length&&a(r[0])){var t=r[1];o(t)?r[1]=t-1:t instanceof n&&(r[1]=t.minus(1))}try{return e.max.apply(e,r)}catch(u){throw i(u)}};return e.max.transform=r,r}},function(e,r,t){"use strict";var n=t(5),i=t(203).transform,o=t(3).isNumber,a=t(14).isCollection,s=t(165).argsToArray;e.exports=function(e){var r=function(){var r=s(arguments);if(2==r.length&&a(r[0])){var t=r[1];o(t)?r[1]=t-1:t instanceof n&&(r[1]=t.minus(1))}try{return e.mean.apply(e,r)}catch(u){throw i(u)}};return e.mean.transform=r,r}},function(e,r,t){"use strict";var n=t(5),i=t(203).transform,o=t(3).isNumber,a=t(14).isCollection,s=t(165).argsToArray;e.exports=function(e){var r=function(){var r=s(arguments);if(2==r.length&&a(r[0])){var t=r[1];o(t)?r[1]=t-1:t instanceof n&&(r[1]=t.minus(1))}try{return e.min.apply(e,r)}catch(u){throw i(u)}};return e.min.transform=r,r}},function(e,r,t){"use strict";var n=t(204).isBoolean,i=t(165).argsToArray;e.exports=function(e){var r=function(){var r=i(arguments),t=r.length-1,o=r[t];return n(o)||r.push(!0),e.range.apply(e,r)};return e.range.transform=r,r}},function(e,r,t){"use strict";var n=t(203).transform,i=(t(204).isBoolean,t(165).argsToArray);e.exports=function(e){var r=function(){try{return e.subset.apply(e,i(arguments))}catch(r){throw n(r)}};return e.subset.transform=r,r}},function(e,r,t){"use strict";e.exports=function(e){function r(e){if(!(this instanceof r))throw new SyntaxError("Constructor must be called with the new operator");this.value=e instanceof r?e.value:e}function n(e,t){var n=Array.prototype.slice;r.prototype[e]="function"==typeof t?function(){var e=[this.value].concat(n.call(arguments,0));return new r(t.apply(this,e))}:new r(t)}var i=t(205);r.prototype.done=function(){return this.value},r.prototype.valueOf=function(){return this.value},r.prototype.toString=function(){return i.format(this.value)},r.createProxy=n;for(var o in e)e.hasOwnProperty(o)&&n(o,e[o]);return r}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=t(16),i=t(14),o=r.string.isString,a=i.isCollection;e.compile=function(r){if(1!=arguments.length)throw new e.error.ArgumentsError("compile",arguments.length,1);if(o(r))return n(r).compile(e);if(a(r))return i.deepMap(r,function(r){return n(r).compile(e)});throw new TypeError("String, array, or matrix expected")}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=t(16),i=t(14),o=r.string.isString,a=i.isCollection;e.eval=function(r,t){if(1!=arguments.length&&2!=arguments.length)throw new e.error.ArgumentsError("eval",arguments.length,1,2);if(t=t||{},o(r))return n(r).compile(e).eval(t);if(a(r))return i.deepMap(r,function(r){return n(r).compile(e).eval(t)});throw new TypeError("String, array, or matrix expected")}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(12);e.help=function(t){if(1!=arguments.length)throw new SyntaxError("Wrong number of arguments in function help ("+arguments.length+" provided, 1 expected)");var n=null;if(t instanceof String||"string"==typeof t)n=t;else{var i;for(i in e)if(e.hasOwnProperty(i)&&t===e[i]){n=i;break}}var o=e.expression.docs[n];if(!n)throw new Error('Cannot find "'+t+'" in math.js');if(!o)throw new Error('No documentation found on "'+n+'"');return new r(o)}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(16);e.parse=function(){return r.apply(r,arguments)}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=(t(10),t(14)),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;e.abs=function f(r){if(1!=arguments.length)throw new e.error.ArgumentsError("abs",arguments.length,1);if(a(r))return Math.abs(r);if(u(r)){var t=Math.abs(r.re),i=Math.abs(r.im);if(t>=i){var r=i/t;return t*Math.sqrt(1+r*r)}var l=t/i;return i*Math.sqrt(1+l*l)}if(r instanceof n)return r.abs();if(c(r))return o.deepMap(r,f);if(s(r)||null===r)return Math.abs(r);throw new e.error.UnsupportedTypeError("abs",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=(t(10),t(11)),a=t(14),s=r["boolean"].isBoolean,u=r.number.isNumber,c=r.string.isString,f=i.isComplex,l=o.isUnit,p=a.isCollection;e.add=function m(r,t){if(2!=arguments.length)throw new e.error.ArgumentsError("add",arguments.length,2);if(u(r)){if(u(t))return r+t;if(f(t))return new i(r+t.re,t.im)}if(f(r)){if(f(t))return new i(r.re+t.re,r.im+t.im);if(u(t))return new i(r.re+t,r.im)}if(l(r)&&l(t)){if(null==r.value)throw new Error("Parameter x contains a unit with undefined value");if(null==t.value)throw new Error("Parameter y contains a unit with undefined value");if(!r.equalBase(t))throw new Error("Units do not match");var o=r.clone();return o.value+=t.value,o.fixPrefix=!1,o}if(r instanceof n)return u(t)?t=n.convert(t):(s(t)||null===t)&&(t=new n(t?1:0)),t instanceof n?r.plus(t):m(r.toNumber(),t);if(t instanceof n)return u(r)?r=n.convert(r):(s(r)||null===r)&&(r=new n(r?1:0)),r instanceof n?r.plus(t):m(r,t.toNumber());if(p(r)||p(t))return a.deepMap2(r,t,m);if(c(r)||c(t))return r+t;if(s(r)||null===r)return m(+r,t);if(s(t)||null===t)return m(r,+t);throw new e.error.UnsupportedTypeError("add",e["typeof"](r),e["typeof"](t))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=o.isCollection,c=i.isComplex;e.ceil=function f(r){if(1!=arguments.length)throw new e.error.ArgumentsError("ceil",arguments.length,1);if(a(r))return Math.ceil(r);if(c(r))return new i(Math.ceil(r.re),Math.ceil(r.im));if(r instanceof n)return r.ceil();if(u(r))return o.deepMap(r,f);if(s(r)||null===r)return Math.ceil(r);throw new e.error.UnsupportedTypeError("ceil",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;e.cube=function f(r){if(1!=arguments.length)throw new e.error.ArgumentsError("cube",arguments.length,1);if(a(r))return r*r*r;if(u(r))return e.multiply(e.multiply(r,r),r);if(r instanceof n)return r.times(r).times(r);if(c(r))return o.deepMap(r,f);if(s(r)||null===r)return f(+r);throw new e.error.UnsupportedTypeError("cube",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){function r(e,r){var t=r.re*r.re+r.im*r.im;return 0!=t?new o((e.re*r.re+e.im*r.im)/t,(e.im*r.re-e.re*r.im)/t):new o(0!=e.re?e.re/0:0,0!=e.im?e.im/0:0)}var n=t(171),i=e.type.BigNumber,o=t(7),a=(t(10),t(11)),s=n.number.isNumber,u=n["boolean"].isBoolean,c=o.isComplex,f=a.isUnit;e._divide=function l(t,n){if(s(t)){if(s(n))return t/n;if(c(n))return r(new o(t,0),n)}if(c(t)){if(c(n))return r(t,n);if(s(n))return r(t,new o(n,0))}if(t instanceof i)return s(n)?n=i.convert(n):(u(n)||null===n)&&(n=new i(n?1:0)),n instanceof i?t.div(n):l(t.toNumber(),n);if(n instanceof i)return s(t)?t=i.convert(t):(u(t)||null===t)&&(t=new i(t?1:0)),t instanceof i?t.div(n):l(t,n.toNumber());if(f(t)&&s(n)){var a=t.clone();return a.value=(null===a.value?a._normalize(1):a.value)/n,a}if(u(t)||null===t)return l(+t,n);if(u(n)||null===n)return l(t,+n);throw new e.error.UnsupportedTypeError("divide",e["typeof"](t),e["typeof"](n))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(14),n=r.isCollection;e.divide=function(t,i){if(2!=arguments.length)throw new e.error.ArgumentsError("divide",arguments.length,2);return n(t)?n(i)?e.multiply(t,e.inv(i)):r.deepMap2(t,i,e._divide):n(i)?e.multiply(t,e.inv(i)):e._divide(t,i)}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(14);e.dotDivide=function(t,n){if(2!=arguments.length)throw new e.error.ArgumentsError("dotDivide",arguments.length,2);return r.deepMap2(t,n,e.divide)},e.edivide=function(){throw new Error("Function edivide is renamed to dotDivide")}}},function(e,r,t){"use strict";e.exports=function(e){var r=(t(171),t(14));e.dotMultiply=function(t,n){if(2!=arguments.length)throw new e.error.ArgumentsError("dotMultiply",arguments.length,2);return r.deepMap2(t,n,e.multiply)},e.emultiply=function(){throw new Error("Function emultiply is renamed to dotMultiply")}}},function(e,r,t){"use strict";e.exports=function(e){var r=(t(171),t(14));e.dotPow=function(t,n){if(2!=arguments.length)throw new e.error.ArgumentsError("dotPow",arguments.length,2);return r.deepMap2(t,n,e.pow)},e.epow=function(){throw new Error("Function epow is renamed to dotPow")}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=(t(10),t(14)),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;e.exp=function f(r){if(1!=arguments.length)throw new e.error.ArgumentsError("exp",arguments.length,1);if(a(r))return Math.exp(r);if(u(r)){var t=Math.exp(r.re);return new i(t*Math.cos(r.im),t*Math.sin(r.im))}if(r instanceof n)return r.exp();if(c(r))return o.deepMap(r,f);if(s(r)||null===r)return Math.exp(r);throw new e.error.UnsupportedTypeError("exp",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;e.fix=function f(r){if(1!=arguments.length)throw new e.error.ArgumentsError("fix",arguments.length,1);if(a(r))return r>0?Math.floor(r):Math.ceil(r);if(u(r))return new i(r.re>0?Math.floor(r.re):Math.ceil(r.re),r.im>0?Math.floor(r.im):Math.ceil(r.im));if(r instanceof n)return r.isNegative()?r.ceil():r.floor();if(c(r))return o.deepMap(r,f);if(s(r)||null===r)return f(+r);throw new e.error.UnsupportedTypeError("fix",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;e.floor=function f(r){if(1!=arguments.length)throw new e.error.ArgumentsError("floor",arguments.length,1);if(a(r))return Math.floor(r);if(u(r))return new i(Math.floor(r.re),Math.floor(r.im));if(r instanceof n)return r.floor();if(c(r))return o.deepMap(r,f);if(s(r)||null===r)return f(+r);throw new e.error.UnsupportedTypeError("floor",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){function r(e,r){if(!e.isInt()||!r.isInt())throw new Error("Parameters in function gcd must be integer numbers");for(var t=new i(0);!r.isZero();){var n=e.mod(r);e=r,r=n}return e.lt(t)?e.neg():e}var n=t(171),i=e.type.BigNumber,o=t(14),a=n.number.isNumber,s=n["boolean"].isBoolean,u=n.number.isInteger,c=o.isCollection;e.gcd=function f(){var t,n=arguments[0],l=arguments[1];if(2==arguments.length){if(a(n)&&a(l)){if(!u(n)||!u(l))throw new Error("Parameters in function gcd must be integer numbers");for(;0!=l;)t=n%l,n=l,l=t;return 0>n?-n:n}if(c(n)||c(l))return o.deepMap2(n,l,f);if(n instanceof i)return a(l)?l=i.convert(l):(s(l)||null===l)&&(l=new i(l?1:0)),l instanceof i?r(n,l):f(n.toNumber(),l);if(l instanceof i)return a(n)?n=i.convert(n):(s(n)||null===n)&&(n=new i(n?1:0)),n instanceof i?r(n,l):f(n.toNumber(),l);if(s(n)||null===n)return f(+n,l);if(s(l)||null===l)return f(n,+l);throw new e.error.UnsupportedTypeError("gcd",e["typeof"](n),e["typeof"](l))}if(arguments.length>2){for(var p=1;p<arguments.length;p++)n=f(n,arguments[p]);return n}throw new SyntaxError("Function gcd expects two or more arguments")}}},function(e,r,t){"use strict";e.exports=function(e){function r(e,r){if(!e.isInt()||!r.isInt())throw new Error("Parameters in function lcm must be integer numbers");if(e.isZero()||r.isZero())return new i(0);for(var t=e.times(r);!r.isZero();){var n=r;r=e.mod(n),e=n}return t.div(e).abs()}var n=t(171),i=e.type.BigNumber,o=t(14),a=n.number.isNumber,s=n["boolean"].isBoolean,u=n.number.isInteger,c=o.isCollection;e.lcm=function f(){var t,n=arguments[0],l=arguments[1];if(2==arguments.length){if(a(n)&&a(l)){if(!u(n)||!u(l))throw new Error("Parameters in function lcm must be integer numbers");if(0==n||0==l)return 0;for(var p=n*l;0!=l;)t=l,l=n%t,n=t;return Math.abs(p/n)}if(c(n)||c(l))return o.deepMap2(n,l,f);if(n instanceof i)return a(l)?l=i.convert(l):(s(l)||null===l)&&(l=new i(l?1:0)),l instanceof i?r(n,l):f(n.toNumber(),l);if(l instanceof i)return a(n)?n=i.convert(n):(s(n)||null===n)&&(n=new i(n?1:0)),n instanceof i?r(n,l):f(n.toNumber(),l);if(s(n)||null===n)return f(+n,l);if(s(l)||null===l)return f(n,+l);throw new e.error.UnsupportedTypeError("lcm",e["typeof"](n),e["typeof"](l))}if(arguments.length>2){for(var m=1;m<arguments.length;m++)n=f(n,arguments[m]);return n}throw new SyntaxError("Function lcm expects two or more arguments")}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;e.log=function f(r,t){if(1==arguments.length){if(a(r))return r>=0?Math.log(r):f(new i(r,0));if(u(r))return new i(Math.log(Math.sqrt(r.re*r.re+r.im*r.im)),Math.atan2(r.im,r.re));if(r instanceof n)return r.isNegative()?f(r.toNumber()):r.ln();if(c(r))return o.deepMap(r,f);if(s(r)||null===r)return f(+r);throw new e.error.UnsupportedTypeError("log",e["typeof"](r))}if(2==arguments.length)return e.divide(f(r),f(t));throw new e.error.ArgumentsError("log",arguments.length,1,2)}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;e.log10=function f(r){if(1!=arguments.length)throw new e.error.ArgumentsError("log10",arguments.length,1);if(a(r))return r>=0?Math.log(r)/Math.LN10:f(new i(r,0));if(r instanceof n)return r.isNegative()?f(r.toNumber()):r.log();if(u(r))return new i(Math.log(Math.sqrt(r.re*r.re+r.im*r.im))/Math.LN10,Math.atan2(r.im,r.re)/Math.LN10);if(c(r))return o.deepMap(r,f);if(s(r)||null===r)return f(+r);throw new e.error.UnsupportedTypeError("log10",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){function r(e,r){if(r>0)return e-r*Math.floor(e/r);if(0==r)return e;throw new Error("Cannot calculate mod for a negative divisor")}var n=t(171),i=e.type.BigNumber,o=t(14),a=n.number.isNumber,s=n["boolean"].isBoolean,u=o.isCollection;e.mod=function c(t,n){if(2!=arguments.length)throw new e.error.ArgumentsError("mod",arguments.length,2);if(a(t)&&a(n))return r(t,n);if(t instanceof i)return a(n)?n=i.convert(n):(s(n)||null===n)&&(n=new i(n?1:0)),n instanceof i?n.isZero()?t:t.mod(n):c(t.toNumber(),n);if(n instanceof i)return a(t)?t=i.convert(t):(s(t)||null===t)&&(t=new i(t?1:0)),t instanceof i?n.isZero()?t:t.mod(n):c(t,n.toNumber());if(u(t)||u(n))return o.deepMap2(t,n,c);if(s(t)||null===t)return c(+t,n);if(s(n)||null===n)return c(t,+n);throw new e.error.UnsupportedTypeError("mod",e["typeof"](t),e["typeof"](n))}}},function(e,r,t){"use strict";e.exports=function(e){function r(r,t){for(var n=[],i=r.length,o=t[0].length,a=r[0].length,s=0;i>s;s++){n[s]=[];for(var u=0;o>u;u++){for(var c=null,f=0;a>f;f++){var l=e.multiply(r[s][f],t[f][u]);c=null===c?l:e.add(c,l)}n[s][u]=c}}var p=1===i&&1===o;return p?n[0][0]:n}function n(r,t){for(var n=[],i=t.length,o=t[0].length,a=0;o>a;a++){for(var s=null,u=0;i>u;u++){var c=e.multiply(r[u],t[u][a]);s=0===u?c:e.add(s,c)}n[a]=s}return 1===n.length?n[0]:n}function i(r,t){for(var n=[],i=r.length,o=r[0].length,a=0;i>a;a++){for(var s=null,u=0;o>u;u++){var c=e.multiply(r[a][u],t[u]);
s=0===u?c:e.add(s,c)}n[a]=s}return 1===n.length?n[0]:n}function o(r,t){var n=r.length;if(!n)throw new Error("Cannot multiply two empty vectors");for(var i=0,o=0;n>o;o++)i=e.add(i,e.multiply(r[o],t[o]));return i}function a(e,r){return 0==e.im?0==r.im?new c(e.re*r.re,0):0==r.re?new c(0,e.re*r.im):new c(e.re*r.re,e.re*r.im):0==e.re?0==r.im?new c(0,e.im*r.re):0==r.re?new c(-e.im*r.im,0):new c(-e.im*r.im,e.im*r.re):0==r.im?new c(e.re*r.re,e.im*r.re):0==r.re?new c(-e.im*r.im,e.re*r.im):new c(e.re*r.re-e.im*r.im,e.re*r.im+e.im*r.re)}var s=t(171),u=e.type.BigNumber,c=t(7),f=t(10),l=t(11),p=t(14),m=s.array,h=s.number.isNumber,g=s["boolean"].isBoolean,d=c.isComplex,w=Array.isArray,x=l.isUnit;e.multiply=function v(t,s){var l;if(2!=arguments.length)throw new e.error.ArgumentsError("multiply",arguments.length,2);if(h(t)){if(h(s))return t*s;if(d(s))return a(new c(t,0),s);if(x(s))return l=s.clone(),l.value=null===l.value?l._normalize(t):l.value*t,l}if(d(t)){if(h(s))return a(t,new c(s,0));if(d(s))return a(t,s)}if(t instanceof u)return h(s)?s=u.convert(s):(g(s)||null===s)&&(s=new u(s?1:0)),s instanceof u?t.times(s):v(t.toNumber(),s);if(s instanceof u)return h(t)?t=u.convert(t):(g(t)||null===t)&&(t=new u(t?1:0)),t instanceof u?t.times(s):v(t,s.toNumber());if(x(t)&&h(s))return l=t.clone(),l.value=null===l.value?l._normalize(s):l.value*s,l;if(w(t)){if(w(s)){var y=m.size(t),b=m.size(s);if(1==y.length){if(1==b.length){if(y[0]!=b[0])throw new RangeError("Dimension mismatch in multiplication. Length of A must match length of B (A is "+y[0]+", B is "+b[0]+", "+y[0]+" != "+b[0]+")");return o(t,s)}if(2==b.length){if(y[0]!=b[0])throw new RangeError("Dimension mismatch in multiplication. Length of A must match rows of B (A is "+y[0]+", B is "+b[0]+"x"+b[1]+", "+y[0]+" != "+b[0]+")");return n(t,s)}throw new Error("Can only multiply a 1 or 2 dimensional matrix (B has "+b.length+" dimensions)")}if(2==y.length){if(1==b.length){if(y[1]!=b[0])throw new RangeError("Dimension mismatch in multiplication. Columns of A must match length of B (A is "+y[0]+"x"+y[0]+", B is "+b[0]+", "+y[1]+" != "+b[0]+")");return i(t,s)}if(2==b.length){if(y[1]!=b[0])throw new RangeError("Dimension mismatch in multiplication. Columns of A must match rows of B (A is "+y[0]+"x"+y[1]+", B is "+b[0]+"x"+b[1]+", "+y[1]+" != "+b[0]+")");return r(t,s)}throw new Error("Can only multiply a 1 or 2 dimensional matrix (B has "+b.length+" dimensions)")}throw new Error("Can only multiply a 1 or 2 dimensional matrix (A has "+y.length+" dimensions)")}return s instanceof f?(l=v(t,s.valueOf()),w(l)?new f(l):l):p.deepMap2(t,s,v)}if(t instanceof f)return s instanceof f?(l=v(t.valueOf(),s.valueOf()),w(l)?new f(l):l):(l=v(t.valueOf(),s),w(l)?new f(l):l);if(w(s))return p.deepMap2(t,s,v);if(s instanceof f)return new f(p.deepMap2(t,s.valueOf(),v));if(g(t)||null===t)return v(+t,s);if(g(s)||null===s)return v(t,+s);throw new e.error.UnsupportedTypeError("multiply",e["typeof"](t),e["typeof"](s))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=t(165),i=e.type.BigNumber,o=t(7),a=t(10),s=(t(14),r.number.isNumber),u=r["boolean"].isBoolean,c=o.isComplex,f=Array.isArray;e.norm=function l(r,t){if(arguments.length<1||arguments.length>2)throw new e.error.ArgumentsError("abs",arguments.length,1,2);if(s(r))return Math.abs(r);if(c(r)){var o=Math.abs(r.re),p=Math.abs(r.im);if(o>=p){var r=p/o;return o*Math.sqrt(1+r*r)}var m=o/p;return p*Math.sqrt(1+m*m)}if(r instanceof i)return r.abs();if(u(r)||null===r)return Math.abs(r);if(f(r)){var h=n.size(r);if(null==t&&(t=2),1==h.length){if(t===Number.POSITIVE_INFINITY||"inf"===t){var g;return e.forEach(r,function(r){var t=e.abs(r);(!g||e.larger(t,g))&&(g=t)}),g}if(t===Number.NEGATIVE_INFINITY||"-inf"===t){var g;return e.forEach(r,function(r){var t=e.abs(r);(!g||e.smaller(t,g))&&(g=t)}),g}if("fro"===t)return l(r);if(s(t)&&!isNaN(t)){if(!e.equal(t,0)){var g=0;return e.forEach(r,function(r){g=e.add(e.pow(e.abs(r),t),g)}),e.pow(g,1/t)}return Number.POSITIVE_INFINITY}throw new Error("Unsupported parameter value")}if(2==h.length){if(1==t){for(var d=[],w=0;w<r.length;w++)for(var x=r[w],v=0;v<x.length;v++)d[v]=e.add(d[v]||0,e.abs(x[v]));return e.max(d)}if(t==Number.POSITIVE_INFINITY||"inf"===t){for(var g=0,w=0;w<r.length;w++){for(var y=0,x=r[w],v=0;v<x.length;v++)y=e.add(y,e.abs(x[v]));e.larger(y,g)&&(g=y)}return g}if("fro"===t){var b=e.diag(e.multiply(e.transpose(r),r)),E=0;return e.forEach(b,function(r){E=e.add(r,E)}),e.sqrt(E)}if(2==t)throw new Error("Unsupported parameter value, missing implementation of matrix singular value decomposition");throw new Error("Unsupported parameter value")}}if(r instanceof a)return l(r.valueOf(),t);throw new e.error.UnsupportedTypeError("norm",r)}}},function(e,r,t){"use strict";e.exports=function(e){function r(e,r){var t=void 0!=r?r:2,n=0>t;if(n&&(t=-t),0==t)throw new Error("Root must be non-zero");if(0>e&&Math.abs(t)%2!=1)throw new Error("Root must be odd when a is negative.");if(0==e)return 0;if(!Number.isFinite(e))return n?0:e;var i=1e-16,o=1,a=0,s=100;do{var u=(e/Math.pow(o,t-1)-o)/t;o+=u,a++}while(Math.abs(u)>i&&s>a);return n?1/o:o}function i(e,r){var t=void 0!=r?r:new a(2),n=new a(0),i=new a(1),o=t.isNegative();if(o&&(t=t.negated()),t.isZero())throw new Error("Root must be non-zero");if(e.isNegative()&&!t.abs().mod(2).equals(1))throw new Error("Root must be odd when a is negative.");if(e.isZero())return n;if(!e.isFinite())return o?n:e;var s=i,u=0,c=100;do{var f=s,l=e.div(s.pow(t.minus(1))).minus(s).div(t);s=s.plus(l),u++}while(!s.equals(f)&&c>u);return o?i.div(s):s}var o=t(171),a=e.type.BigNumber,s=t(14),u=o.number.isNumber,c=o["boolean"].isBoolean,f=s.isCollection;e.nthRoot=function l(t,o){if(1!=arguments.length&&2!=arguments.length)throw new e.error.ArgumentsError("nthRoot",arguments.length,1,2);switch(arguments.length){case 1:if(u(t))return r(t);if(t instanceof a)return i(t);if(f(t))return s.deepMap(x,l);if(c(t)||null===t)return l(+t);break;case 2:if(u(t)){if(u(o))return r(t,o);if(o instanceof a)return t=a.convert(t),t instanceof a?i(t,o):r(t,o.toNumber())}else{if(t instanceof a)return u(o)&&(o=a.convert(o)),o instanceof a?i(t,o):r(t.toNumber(),o);if(f(t)&&!f(o))return s.deepMap2(t,o,l)}if(c(t)||null===t)return l(+t,o);if(c(o)||null===o)return l(t,+o);break;default:throw new e.error.ArgumentsError("nthRoot",arguments.length,1,2)}if(c(x)||null===x)return 2==arguments.length?l(+x,n):l(+x);throw new e.error.UnsupportedTypeError("nthRoot",e["typeof"](t),e["typeof"](o))}}},function(e,r,t){"use strict";e.exports=function(e){function r(r,t){var n=e.log(r),i=e.multiply(n,t);return e.exp(i)}var n=t(171),i=e.type.BigNumber,o=t(7),a=t(10),s=(t(14),n.array),u=n.number.isNumber,c=n["boolean"].isBoolean,f=Array.isArray,l=n.number.isInteger,p=o.isComplex;e.pow=function m(t,n){if(2!=arguments.length)throw new e.error.ArgumentsError("pow",arguments.length,2);if(u(t)){if(u(n))return l(n)||t>=0?Math.pow(t,n):r(new o(t,0),new o(n,0));if(p(n))return r(new o(t,0),n)}if(p(t)){if(u(n))return r(t,new o(n,0));if(p(n))return r(t,n)}if(t instanceof i)return u(n)?n=i.convert(n):(c(n)||null===n)&&(n=new i(n?1:0)),n instanceof i?n.isInteger()||!t.isNegative()?t.pow(n):m(t.toNumber(),n.toNumber()):m(t.toNumber(),n);if(n instanceof i)return u(t)?t=i.convert(t):(c(t)||null===t)&&(t=new i(t?1:0)),t instanceof i?n.isInteger()&&!t.isNegative()?t.pow(n):m(t.toNumber(),n.toNumber()):m(t,n.toNumber());if(f(t)){if(!u(n)||!l(n)||0>n)throw new TypeError("For A^b, b must be a positive integer (value is "+n+")");var h=s.size(t);if(2!=h.length)throw new Error("For A^b, A must be 2 dimensional (A has "+h.length+" dimensions)");if(h[0]!=h[1])throw new Error("For A^b, A must be square (size is "+h[0]+"x"+h[1]+")");for(var g=e.eye(h[0]).valueOf(),d=t;n>=1;)1==(1&n)&&(g=e.multiply(d,g)),n>>=1,d=e.multiply(d,d);return g}if(t instanceof a)return new a(m(t.valueOf(),n));if(c(t)||null===t)return m(+t,n);if(c(n)||null===n)return m(t,+n);throw new e.error.UnsupportedTypeError("pow",e["typeof"](t),e["typeof"](n))}}},function(e,r,t){"use strict";e.exports=function(e){function r(e,r){var t=Math.pow(10,r);return Math.round(e*t)/t}var n=t(171),i=e.type.BigNumber,o=t(7),a=t(14),s=n.number.isNumber,u=n.number.isInteger,c=n["boolean"].isBoolean,f=o.isComplex,l=a.isCollection;e.round=function p(t,n){if(1!=arguments.length&&2!=arguments.length)throw new e.error.ArgumentsError("round",arguments.length,1,2);if(void 0==n){if(s(t))return Math.round(t);if(f(t))return new o(Math.round(t.re),Math.round(t.im));if(t instanceof i)return t.toDecimalPlaces(0);if(l(t))return a.deepMap(t,p);if(c(t)||null===t)return Math.round(t);throw new e.error.UnsupportedTypeError("round",e["typeof"](t))}if(!s(n)||!u(n)){if(!(n instanceof i)){if(c(n)||null===t)return p(t,+n);throw new TypeError("Number of decimals in function round must be an integer")}n=parseFloat(n.valueOf())}if(0>n||n>15)throw new Error("Number of decimals in function round must be in te range of 0-15");if(s(t))return r(t,n);if(f(t))return new o(r(t.re,n),r(t.im,n));if(t instanceof i)return t.toDecimalPlaces(n);if(l(t)||l(n))return a.deepMap2(t,n,p);if(c(t)||null===t)return p(+t,n);throw new e.error.UnsupportedTypeError("round",e["typeof"](t),e["typeof"](n))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number,s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=o.isCollection;e.sign=function l(r){if(1!=arguments.length)throw new e.error.ArgumentsError("sign",arguments.length,1);if(s(r))return a.sign(r);if(c(r)){var t=Math.sqrt(r.re*r.re+r.im*r.im);return new i(r.re/t,r.im/t)}if(r instanceof n)return new n(r.cmp(0));if(f(r))return o.deepMap(r,l);if(u(r)||null===r)return a.sign(r);throw new e.error.UnsupportedTypeError("sign",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;e.sqrt=function f(r){if(1!=arguments.length)throw new e.error.ArgumentsError("sqrt",arguments.length,1);if(a(r))return r>=0?Math.sqrt(r):f(new i(r,0));if(u(r)){var t,l,p=Math.sqrt(r.re*r.re+r.im*r.im);return t=r.re>=0?.5*Math.sqrt(2*(p+r.re)):Math.abs(r.im)/Math.sqrt(2*(p-r.re)),l=r.re<=0?.5*Math.sqrt(2*(p-r.re)):Math.abs(r.im)/Math.sqrt(2*(p+r.re)),r.im>=0?new i(t,l):new i(t,-l)}if(r instanceof n)return r.isNegative()?f(r.toNumber()):r.sqrt();if(c(r))return o.deepMap(r,f);if(s(r)||null===r)return f(+r);throw new e.error.UnsupportedTypeError("sqrt",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,c=o.isCollection;e.square=function f(r){if(1!=arguments.length)throw new e.error.ArgumentsError("square",arguments.length,1);if(a(r))return r*r;if(u(r))return e.multiply(r,r);if(r instanceof n)return r.times(r);if(c(r))return o.deepMap(r,f);if(s(r)||null===r)return r*r;throw new e.error.UnsupportedTypeError("square",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=(t(10),t(11)),a=t(14),s=r["boolean"].isBoolean,u=r.number.isNumber,c=i.isComplex,f=o.isUnit,l=a.isCollection;e.subtract=function p(r,t){if(2!=arguments.length)throw new e.error.ArgumentsError("subtract",arguments.length,2);if(u(r)){if(u(t))return r-t;if(c(t))return new i(r-t.re,-t.im)}else if(c(r)){if(u(t))return new i(r.re-t,r.im);if(c(t))return new i(r.re-t.re,r.im-t.im)}if(r instanceof n)return u(t)?t=n.convert(t):(s(t)||null===t)&&(t=new n(t?1:0)),t instanceof n?r.minus(t):p(r.toNumber(),t);if(t instanceof n)return u(r)?r=n.convert(r):(s(r)||null===r)&&(r=new n(r?1:0)),r instanceof n?r.minus(t):p(r,t.toNumber());if(f(r)&&f(t)){if(null==r.value)throw new Error("Parameter x contains a unit with undefined value");if(null==t.value)throw new Error("Parameter y contains a unit with undefined value");if(!r.equalBase(t))throw new Error("Units do not match");var o=r.clone();return o.value-=t.value,o.fixPrefix=!1,o}if(l(r)||l(t))return a.deepMap2(r,t,p);if(s(r)||null===r)return p(+r,t);if(s(t)||null===t)return p(r,+t);throw new e.error.UnsupportedTypeError("subtract",e["typeof"](r),e["typeof"](t))}}},function(e,r,t){"use strict";e.exports=function(e,r){var n=t(171),i=e.type.BigNumber,o=t(7),a=t(11),s=t(14),u=n.number.isNumber,c=n["boolean"].isBoolean,f=n.string.isString,l=o.isComplex,p=a.isUnit,m=s.isCollection;e.unaryMinus=function h(t){if(1!=arguments.length)throw new e.error.ArgumentsError("unaryMinus",arguments.length,1);if(u(t))return-t;if(l(t))return new o(-t.re,-t.im);if(t instanceof i)return t.neg();if(p(t)){var n=t.clone();return n.value=-t.value,n}if(m(t))return s.deepMap(t,h);if(c(t)||f(t)||null===t)return"bignumber"==r.number?new i(-t):-t;throw new e.error.UnsupportedTypeError("unaryMinus",e["typeof"](t))},e.unary=function(){throw new Error("Function unary is deprecated. Use unaryMinus instead.")}}},function(e,r,t){"use strict";e.exports=function(e,r){var n=t(171),i=e.type.BigNumber,o=t(7),a=t(11),s=t(14),u=n.number.isNumber,c=n["boolean"].isBoolean,f=n.string.isString,l=o.isComplex,p=a.isUnit,m=s.isCollection;e.unaryPlus=function h(t){if(1!=arguments.length)throw new e.error.ArgumentsError("unaryPlus",arguments.length,1);if(u(t))return t;if(l(t))return t.clone();if(t instanceof i)return t;if(p(t))return t.clone();if(m(t))return s.deepMap(t,h);if(c(t)||f(t)||null===t)return"bignumber"==r.number?new i(+t):+t;throw new e.error.UnsupportedTypeError("unaryPlus",e["typeof"](t))}}},function(e,r,t){"use strict";e.exports=function(e,r){function n(e,t){for(var n,i,o,s=0,u=1,c=1,f=0;t;)i=Math.floor(e/t),o=e%t,n=s,s=u-i*s,u=n,n=c,c=f-i*c,f=n,e=t,t=o;var l;return l=0>e?[-e,-u,-f]:[e,e?u:0,f],"array"===r.matrix?l:new a(l)}function i(e,t){for(var n,i,o,u=new s(0),c=new s(0),f=new s(1),l=new s(1),p=new s(0);!t.isZero();)i=e.div(t).floor(),o=e.mod(t),n=c,c=f.minus(i.times(c)),f=n,n=l,l=p.minus(i.times(l)),p=n,e=t,t=o;var m;return m=e.lt(u)?[e.neg(),f.neg(),p.neg()]:[e,e.isZero()?0:f,p],"array"===r.matrix?m:new a(m)}var o=t(171),a=t(10),s=e.type.BigNumber,u=o.number.isNumber,c=o["boolean"].isBoolean,f=o.number.isInteger;e.xgcd=function l(r,t){if(2==arguments.length){if(u(r)&&u(t)){if(!f(r)||!f(t))throw new Error("Parameters in function xgcd must be integer numbers");return n(r,t)}if(r instanceof s)return u(t)?t=s.convert(t):(c(t)||null===t)&&(t=new s(t?1:0)),t instanceof s?i(r,t):l(r.toNumber(),t);if(t instanceof s)return u(r)?r=s.convert(r):(c(r)||null===r)&&(r=new s(r?1:0)),r instanceof s?i(r,t):l(r.toNumber(),t);if(c(r)||null===r)return l(+r,t);if(c(t)||null===t)return l(r,+t);throw new e.error.UnsupportedTypeError("xgcd",e["typeof"](r),e["typeof"](t))}throw new SyntaxError("Function xgcd expects two arguments")}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=(t(10),t(11),t(14)),o=r["boolean"].isBoolean,a=r.number.isInteger,s=r.number.isNumber,u=i.isCollection,c=r.bignumber.and;e.bitAnd=function f(r,t){if(2!=arguments.length)throw new e.error.ArgumentsError("bitAnd",arguments.length,2);if(s(r)&&s(t)){if(!a(r)||!a(t))throw new Error("Parameters in function bitAnd must be integer numbers");return r&t}if(u(r)||u(t))return i.deepMap2(r,t,f);if(o(r)||null===r)return f(+r,t);if(o(t)||null===t)return f(r,+t);if(r instanceof n)return s(t)&&(t=n.convert(t)),t instanceof n?c(r,t):f(r.toNumber(),t);if(t instanceof n)return s(r)&&(r=n.convert(r)),r instanceof n?c(r,t):f(r,t.toNumber());throw new e.error.UnsupportedTypeError("bitAnd",e["typeof"](r),e["typeof"](t))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=(t(10),t(11),t(14)),o=r["boolean"].isBoolean,a=r.number.isInteger,s=r.number.isNumber,u=i.isCollection,c=r.bignumber.not;e.bitNot=function f(r){if(1!=arguments.length)throw new e.error.ArgumentsError("bitNot",arguments.length,1);if(s(r)){if(!a(r))throw new Error("Parameter in function bitNot must be integer numbers");return~r}if(r instanceof n)return c(r);if(u(r))return i.deepMap(r,f);if(o(r)||null===r)return f(+r);throw new e.error.UnsupportedTypeError("bitNot",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=(t(10),t(11),t(14)),o=r["boolean"].isBoolean,a=r.number.isInteger,s=r.number.isNumber,u=i.isCollection,c=r.bignumber.or;e.bitOr=function f(r,t){if(2!=arguments.length)throw new e.error.ArgumentsError("bitOr",arguments.length,2);if(s(r)&&s(t)){if(!a(r)||!a(t))throw new Error("Parameters in function bitOr must be integer numbers");return r|t}if(u(r)||u(t))return i.deepMap2(r,t,f);if(o(r)||null===r)return f(+r,t);if(o(t)||null===t)return f(r,+t);if(r instanceof n)return s(t)&&(t=n.convert(t)),t instanceof n?c(r,t):f(r.toNumber(),t);if(t instanceof n)return s(r)&&(r=n.convert(r)),r instanceof n?c(r,t):f(r,t.toNumber());throw new e.error.UnsupportedTypeError("bitOr",e["typeof"](r),e["typeof"](t))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=(t(10),t(11),t(14)),o=r["boolean"].isBoolean,a=r.number.isInteger,s=r.number.isNumber,u=i.isCollection,c=r.bignumber.xor;e.bitXor=function f(r,t){if(2!=arguments.length)throw new e.error.ArgumentsError("bitXor",arguments.length,2);if(s(r)&&s(t)){if(!a(r)||!a(t))throw new Error("Parameters in function bitXor must be integer numbers");return r^t}if(u(r)||u(t))return i.deepMap2(r,t,f);if(o(r)||null===r)return f(+r,t);if(o(t)||null===t)return f(r,+t);if(r instanceof n)return s(t)&&(t=n.convert(t)),t instanceof n?c(r,t):f(r.toNumber(),t);if(t instanceof n)return s(r)&&(r=n.convert(r)),r instanceof n?c(r,t):f(r,t.toNumber());throw new e.error.UnsupportedTypeError("bitXor",e["typeof"](r),e["typeof"](t))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=(t(10),t(11),t(14)),o=r["boolean"].isBoolean,a=r.number.isInteger,s=r.number.isNumber,u=i.isCollection,c=r.bignumber.leftShift;e.leftShift=function f(r,t){if(2!=arguments.length)throw new e.error.ArgumentsError("leftShift",arguments.length,2);if(s(r)){if(s(t)){if(!a(r)||!a(t))throw new Error("Parameters in function leftShift must be integer numbers");return r<<t}if(t instanceof n)return c(n.convert(r),t)}if(s(t)){if(isFinite(t)&&!a(t))throw new Error("Parameters in function leftShift must be integer numbers");if(r instanceof n){if(r.isFinite()&&!r.isInteger())throw new Error("Parameters in function leftShift must be integer numbers");return r.isNaN()||isNaN(t)||0>t?new n(0/0):0==t||r.isZero()?r:1/0!=t||r.isFinite()?55>t?r.times(Math.pow(2,t)+""):(t=n.convert(t),c(r,t)):new n(0/0)}}if(u(r)&&s(t))return i.deepMap2(r,t,f);if(o(r)||null===r)return f(+r,t);if(o(t)||null===t)return f(r,+t);if(r instanceof n)return t instanceof n?c(r,t):f(r.toNumber(),t);if(t instanceof n)return f(r,t.toNumber());throw new e.error.UnsupportedTypeError("leftShift",e["typeof"](r),e["typeof"](t))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=(t(10),t(11),t(14)),o=r["boolean"].isBoolean,a=r.number.isInteger,s=r.number.isNumber,u=i.isCollection,c=r.bignumber.rightShift;e.rightArithShift=function f(r,t){if(2!=arguments.length)throw new e.error.ArgumentsError("rightArithShift",arguments.length,2);if(s(r)){if(s(t)){if(!a(r)||!a(t))throw new Error("Parameters in function rightArithShift must be integer numbers");return r>>t}if(t instanceof n)return c(n.convert(r),t)}if(s(t)){if(isFinite(t)&&!a(t))throw new Error("Parameters in function rightArithShift must be integer numbers");if(r instanceof n){if(r.isFinite()&&!r.isInteger())throw new Error("Parameters in function rightArithShift must be integer numbers");return r.isNaN()||isNaN(t)||0>t?new n(0/0):1/0==t?new n(r.isNegative()?-1:r.isFinite()?0:0/0):55>t?r.div(Math.pow(2,t)+"").floor():(t=n.convert(t),c(r,t))}}if(u(r)&&s(t))return i.deepMap2(r,t,f);if(o(r)||null===r)return f(+r,t);if(o(t)||null===t)return f(r,+t);if(r instanceof n)return t instanceof n?c(r,t):f(r.toNumber(),t);if(t instanceof n)return f(r,t.toNumber());throw new e.error.UnsupportedTypeError("rightArithShift",e["typeof"](r),e["typeof"](t))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=(t(10),t(11),t(14)),i=r["boolean"].isBoolean,o=r.number.isInteger,a=r.number.isNumber,s=n.isCollection;e.rightLogShift=function u(r,t){if(2!=arguments.length)throw new e.error.ArgumentsError("rightLogShift",arguments.length,2);if(a(r)&&a(t)){if(!o(r)||!o(t))throw new Error("Parameters in function rightLogShift must be integer numbers");return r>>>t}if(s(r)&&a(t))return n.deepMap2(r,t,u);if(i(r)||null===r)return u(+r,t);if(i(t)||null===t)return u(r,+t);throw new e.error.UnsupportedTypeError("rightLogShift",e["typeof"](r),e["typeof"](t))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=o.isCollection,c=i.isComplex;e.arg=function f(r){if(1!=arguments.length)throw new e.error.ArgumentsError("arg",arguments.length,1);if(a(r))return Math.atan2(0,r);if(c(r))return Math.atan2(r.im,r.re);if(u(r))return o.deepMap(r,f);if(s(r)||null===r)return f(+r);if(r instanceof n)return f(r.toNumber());throw new e.error.UnsupportedTypeError("arg",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.object,s=r.number.isNumber,u=r["boolean"].isBoolean,c=o.isCollection,f=i.isComplex;e.conj=function l(r){if(1!=arguments.length)throw new e.error.ArgumentsError("conj",arguments.length,1);return s(r)?r:r instanceof n?new n(r):f(r)?new i(r.re,-r.im):c(r)?o.deepMap(r,l):u(r)||null===r?+r:a.clone(r)}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.object,s=r.number.isNumber,u=r["boolean"].isBoolean,c=o.isCollection,f=i.isComplex;e.re=function l(r){if(1!=arguments.length)throw new e.error.ArgumentsError("re",arguments.length,1);return s(r)?r:r instanceof n?new n(r):f(r)?r.re:c(r)?o.deepMap(r,l):u(r)||null===r?+r:a.clone(r)}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=o.isCollection,c=i.isComplex;e.im=function f(r){if(1!=arguments.length)throw new e.error.ArgumentsError("im",arguments.length,1);return a(r)?0:r instanceof n?new n(0):c(r)?r.im:u(r)?o.deepMap(r,f):(s(r)||null===r,0)}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(14),o=i.isCollection,a=r.number.isNumber,s=r.string.isString,u=r["boolean"].isBoolean;e.bignumber=function c(r){if(arguments.length>1)throw new e.error.ArgumentsError("bignumber",arguments.length,0,1);if(r instanceof n||a(r)||s(r))return new n(r);if(u(r)||null===r)return new n(+r);if(o(r))return i.deepMap(r,c);if(0==arguments.length)return new n(0);throw new e.error.UnsupportedTypeError("bignumber",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(14),o=i.isCollection,a=r.number.isNumber,s=r.string.isString;e["boolean"]=function u(r){if(1!=arguments.length)throw new e.error.ArgumentsError("boolean",arguments.length,0,1);if("true"===r||r===!0)return!0;if("false"===r||r===!1||null===r)return!1;if(r instanceof Boolean)return 1==r;if(a(r))return 0!==r;if(r instanceof n)return!r.isZero();if(s(r)){var t=r.toLowerCase();if("true"===t)return!0;if("false"===t)return!1;var c=Number(r);if(""!=r&&!isNaN(c))return 0!==c}if(o(r))return i.deepMap(r,u);throw new SyntaxError(r.toString()+" is no valid boolean")}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=o.isCollection,s=r.number.isNumber,u=r.string.isString,c=i.isComplex;e.complex=function f(){switch(arguments.length){case 0:return new i(0,0);case 1:var r=arguments[0];if(s(r))return new i(r,0);if(r instanceof n)return new i(r.toNumber(),0);if(c(r))return r.clone();if(u(r)){var t=i.parse(r);if(t)return t;throw new SyntaxError('String "'+r+'" is no valid complex number')}if(a(r))return o.deepMap(r,f);if("object"==typeof r){if("re"in r&&"im"in r)return new i(r.re,r.im);if("r"in r&&"phi"in r)return i.fromPolar(r.r,r.phi)}throw new TypeError("Two numbers, single string or an fitting object expected in function complex");case 2:var l=arguments[0],p=arguments[1];if(l instanceof n&&(l=l.toNumber()),p instanceof n&&(p=p.toNumber()),s(l)&&s(p))return new i(l,p);throw new TypeError("Two numbers or a single string expected in function complex");default:throw new e.error.ArgumentsError("complex",arguments.length,0,2)}}}},function(e,r,t){"use strict";e.exports=function(e){var r=(t(171),e.type.BigNumber),n=t(9);e.index=function(){var e=Array.prototype.slice.apply(arguments).map(function(e){return e instanceof r?e.toNumber():Array.isArray(e)?e.map(function(e){return e instanceof r?e.toNumber():e}):e}),t=new n;return n.apply(t,e),t}}},function(e,r,t){"use strict";e.exports=function(e){var r=(t(171),t(10));e.matrix=function(t){if(arguments.length>1)throw new e.error.ArgumentsError("matrix",arguments.length,0,1);return new r(t)}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=e.type.Unit,o=t(14),a=o.isCollection,s=r.number.isNumber,u=r["boolean"].isBoolean,c=r.string.isString;e.number=function f(r,t){switch(arguments.length){case 0:return 0;case 1:if(a(r))return o.deepMap(r,f);if(r instanceof n)return r.toNumber();if(c(r)){var l=Number(r);if(isNaN(l)&&(l=Number(r.valueOf())),isNaN(l))throw new SyntaxError(r.toString()+" is no valid number");return l}if(u(r)||null===r)return+r;if(s(r))return r;if(r instanceof i)throw new Error("Second argument with valueless unit expected");throw new e.error.UnsupportedTypeError("number",e["typeof"](r));case 2:if(r instanceof i&&c(t)||t instanceof i)return r.toNumber(t);throw new e.error.UnsupportedTypeError("number",e["typeof"](r),e["typeof"](t));default:throw new e.error.ArgumentsError("number",arguments.length,0,1)}}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(17);e.parser=function(){return new r(e)}}},function(e){"use strict";e.exports=function(e){e.chain=function(r){return new e.chaining.Chain(r)},e.select=function(r){return console&&"function"==typeof console.log&&console.log('WARNING: Function "select" is renamed to "chain". It will be deprecated in v2.0.'),e.select=e.chain,e.chaining.Chain.prototype.select=e.select,e.chain(r)}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=t(14),i=r.number,o=r.number.isNumber,a=n.isCollection;e.string=function s(r){switch(arguments.length){case 0:return"";case 1:return o(r)?i.format(r):a(r)?n.deepMap(r,s):null===r?"null":r.toString();default:throw new e.error.ArgumentsError("string",arguments.length,0,1)}}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(11),o=t(14),a=o.isCollection,s=r.string.isString;e.unit=function u(r){switch(arguments.length){case 1:var t=arguments[0];if(t instanceof i)return t.clone();if(s(t)){if(i.isValuelessUnit(t))return new i(null,t);var c=i.parse(t);if(c)return c;throw new SyntaxError('String "'+t+'" is no valid unit')}if(a(r))return o.deepMap(r,u);throw new TypeError("A string or a number and string expected in function unit");case 2:return arguments[0]instanceof n?new i(arguments[0].toNumber(),arguments[1]):new i(arguments[0],arguments[1]);default:throw new e.error.ArgumentsError("unit",arguments.length,1,2)}}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection;e.and=function p(r,t){if(2!=arguments.length)throw new e.error.ArgumentsError("and",arguments.length,2);if((s(r)||u(r)||null===r)&&(s(t)||u(t)||null===t))return!(!r||!t);if(c(r))return 0==r.re&&0==r.im?!1:p(!0,t);if(c(t))return 0==t.re&&0==t.im?!1:p(r,!0);if(r instanceof n)return r.isZero()||r.isNaN()?!1:p(!0,t);if(t instanceof n)return t.isZero()||t.isNaN()?!1:p(r,!0);if(f(r))return null===r.value||0==r.value?!1:p(!0,t);if(f(t))return null===t.value||0==t.value?!1:p(r,!0);if(l(r)||l(t))return a.deepMap2(r,t,p);throw new e.error.UnsupportedTypeError("and",e["typeof"](r),e["typeof"](t))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection;e.not=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("not",arguments.length,1);if(s(r)||u(r)||null===r)return!r;if(c(r))return 0==r.re&&0==r.im;if(r instanceof n)return r.isZero()||r.isNaN();if(f(r))return null===r.value||0==r.value;if(l(r))return a.deepMap(r,p);throw new e.error.UnsupportedTypeError("not",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection;e.or=function p(r,t){if(2!=arguments.length)throw new e.error.ArgumentsError("or",arguments.length,2);if((s(r)||u(r)||null===r)&&(s(t)||u(t)||null===t))return!(!r&&!t);if(c(r))return 0==r.re&&0==r.im?p(!1,t):!0;if(c(t))return 0==t.re&&0==t.im?p(r,!1):!0;if(r instanceof n)return r.isZero()||r.isNaN()?p(!1,t):!0;if(t instanceof n)return t.isZero()||t.isNaN()?p(r,!1):!0;if(f(r))return null===r.value||0==r.value?p(!1,t):!0;if(f(t))return null===t.value||0==t.value?p(r,!1):!0;if(l(r)||l(t))return a.deepMap2(r,t,p);throw new e.error.UnsupportedTypeError("or",e["typeof"](r),e["typeof"](t))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection;e.xor=function p(r,t){if(2!=arguments.length)throw new e.error.ArgumentsError("xor",arguments.length,2);if((s(r)||u(r)||null===r)&&(s(t)||u(t)||null===t))return!!(!!r^!!t);if(c(r))return p(!(0==r.re&&0==r.im),t);if(c(t))return p(r,!(0==t.re&&0==t.im));if(r instanceof n)return p(!(r.isZero()||r.isNaN()),t);if(t instanceof n)return p(r,!(t.isZero()||t.isNaN()));if(f(r))return p(!(null===r.value||0==r.value),t);if(f(t))return p(r,!(null===t.value||0==t.value));if(l(r)||l(t))return a.deepMap2(r,t,p);throw new e.error.UnsupportedTypeError("xor",e["typeof"](r),e["typeof"](t))}}},function(e,r,t){"use strict";e.exports=function(e){function r(t,n,i,o){if(i>o){if(t.length!=n.length)throw new e.error.DimensionError(t.length,n.length);for(var a=[],s=0;s<t.length;s++)a[s]=r(t[s],n[s],i,o+1);return a}return t.concat(n)}var n=t(171),i=t(5),o=t(10),a=t(14),s=n.object,u=n.array,c=n.number.isNumber,f=n.number.isInteger,l=a.isCollection;e.concat=function(){var t,n,a=arguments.length,p=-1,m=!1,h=[];for(t=0;a>t;t++){var g=arguments[t];if(g instanceof o&&(m=!0),t==a-1&&(c(g)||g instanceof i)){if(n=p,p=g.valueOf(),!f(p))throw new TypeError("Integer number expected for dimension");if(0>p)throw new e.error.IndexError(p);if(t>0&&p>n)throw new e.error.IndexError(p,n+1)}else{if(!l(g))throw new e.error.UnsupportedTypeError("concat",e["typeof"](g));var d=s.clone(g).valueOf(),w=u.size(g.valueOf());if(h[t]=d,n=p,p=w.length-1,t>0&&p!=n)throw new e.error.DimensionError(n+1,p+1)}}if(0==h.length)throw new SyntaxError("At least one matrix expected");for(var x=h.shift();h.length;)x=r(x,h.shift(),p,0);return m?new o(x):x}}},function(e,r,t){"use strict";e.exports=function(e){function r(r,t){var i=n.size(r),o=n.size(t);if(1!=i.length||1!=o.length||3!=i[0]||3!=o[0])throw new RangeError("Vectors with length 3 expected (Size A = ["+i.join(", ")+"], B = ["+o.join(", ")+"])");return[e.subtract(e.multiply(r[1],t[2]),e.multiply(r[2],t[1])),e.subtract(e.multiply(r[2],t[0]),e.multiply(r[0],t[2])),e.subtract(e.multiply(r[0],t[1]),e.multiply(r[1],t[0]))]}var n=t(165),i=t(10);e.cross=function(t,n){if(t instanceof i){if(n instanceof i)return new i(r(t.toArray(),n.toArray()));if(Array.isArray(n))return new i(r(t.toArray(),n))}else if(Array.isArray(t)){if(n instanceof i)return new i(r(t,n.toArray()));
if(Array.isArray(n))return r(t,n)}throw new e.error.UnsupportedTypeError("cross",e["typeof"](t),e["typeof"](n))}}},function(e,r,t){"use strict";e.exports=function(e){function r(r,t){if(1==t)return o.clone(r[0][0]);if(2==t)return e.subtract(e.multiply(r[0][0],r[1][1]),e.multiply(r[1][0],r[0][1]));for(var n=function(r){var t,n,i=new Array(r.length),o=0;for(t=1;t<r.length;t++)o=e.add(o,r[t][t]);for(t=0;t<r.length;t++){for(i[t]=new Array(r.length),i[t][t]=e.unaryMinus(o),n=0;t>n;n++)i[t][n]=0;for(n=t+1;n<r.length;n++)i[t][n]=r[t][n];t+1<r.length&&(o=e.subtract(o,r[t+1][t+1]))}return i},i=r,a=0;t-1>a;a++)i=e.multiply(n(i),r);return t%2==0?e.unaryMinus(i[0][0]):i[0][0]}var n=t(171),i=t(10),o=n.object,a=n.string;e.det=function(t){if(1!=arguments.length)throw new e.error.ArgumentsError("det",arguments.length,1);var n;switch(t instanceof i?n=t.size():t instanceof Array?(t=new i(t),n=t.size()):n=[],n.length){case 0:return o.clone(t);case 1:if(1==n[0])return o.clone(t.valueOf()[0]);throw new RangeError("Matrix must be square (size: "+a.format(n)+")");case 2:var s=n[0],u=n[1];if(s==u)return r(t.clone().valueOf(),s,u);throw new RangeError("Matrix must be square (size: "+a.format(n)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+a.format(n)+")")}}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(10),o=r.object,a=r.array.isArray,s=r.number.isNumber,u=r.number.isInteger;e.diag=function(r,t){var c,f,l,p;if(1!=arguments.length&&2!=arguments.length)throw new e.error.ArgumentsError("diag",arguments.length,1,2);if(t){if(t instanceof n&&(t=t.toNumber()),!s(t)||!u(t))throw new TypeError("Second parameter in function diag must be an integer")}else t=0;var m,h=t>0?t:0,g=0>t?-t:0;if(r instanceof i)m=!1;else{if(!a(r))throw new TypeError("First parameter in function diag must be a Matrix or Array");r=new i(r),m=!0}var d=r.size();switch(d.length){case 1:f=r.valueOf();var w=new i,x=f[0]instanceof n?new n(0):0;for(w.resize([f.length+g,f.length+h],x),c=w.valueOf(),p=f.length,l=0;p>l;l++)c[l+g][l+h]=o.clone(f[l]);return m?w.valueOf():w;case 2:for(f=[],c=r.valueOf(),p=Math.min(d[0]-g,d[1]-h),l=0;p>l;l++)f[l]=o.clone(c[l+g][l+h]);return m?f:new i(f);default:throw new RangeError("Matrix for function diag must be 2 dimensional")}}}},function(e,r,t){"use strict";e.exports=function(e){function r(r,t){var i=n.size(r),o=n.size(t),a=i[0];if(1!==i.length||1!==o.length)throw new RangeError("Vector expected");if(i[0]!=o[0])throw new RangeError("Vectors must have equal length ("+i[0]+" != "+o[0]+")");if(0==a)throw new RangeError("Cannot calculate the dot product of empty vectors");for(var s=0,u=0;a>u;u++)s=e.add(s,e.multiply(r[u],t[u]));return s}var n=t(165),i=t(10);e.dot=function(t,n){if(t instanceof i){if(n instanceof i)return r(t.toArray(),n.toArray());if(Array.isArray(n))return r(t.toArray(),n)}else if(Array.isArray(t)){if(n instanceof i)return r(t,n.toArray());if(Array.isArray(n))return r(t,n)}throw new e.error.UnsupportedTypeError("dot",e["typeof"](t),e["typeof"](n))}}},function(e,r,t){"use strict";e.exports=function(e,r){var n=t(171),i=e.type.BigNumber,o=t(10),a=t(14),s=n.number.isNumber,u=n.number.isInteger,c=Array.isArray;e.eye=function(t){var n=a.argsToArray(arguments),f=t instanceof o?!0:c(t)?!1:"matrix"===r.matrix;if(0==n.length)return f?new o:[];if(1==n.length)n[1]=n[0];else if(n.length>2)throw new e.error.ArgumentsError("eye",n.length,0,2);var l=n[0],p=n[1];if(l instanceof i&&(l=l.toNumber()),p instanceof i&&(p=p.toNumber()),!s(l)||!u(l)||1>l)throw new Error("Parameters in function eye must be positive integers");if(!s(p)||!u(p)||1>p)throw new Error("Parameters in function eye must be positive integers");var m=!1;n=n.map(function(e){return e instanceof i?(m=!0,e.toNumber()):e});var h=new o,g=m?new i(1):1,d=m?new i(0):0;h.resize(n,d);for(var w=e.min(n),x=h.valueOf(),v=0;w>v;v++)x[v][v]=g;return f?h:h.valueOf()}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=t(10),i=r.object,o=r.array,a=Array.isArray;e.flatten=function(r){if(1!==arguments.length)throw new e.error.ArgumentsError("flatten",arguments.length,1);if(r instanceof n){var t=i.clone(r.toArray()),s=o.flatten(t);return new n(s)}if(a(r))return o.flatten(i.clone(r));throw new e.error.UnsupportedTypeError("flatten",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){function r(r,t,n){var i,o,a,s,u;if(1==t){if(s=r[0][0],0==s)throw Error("Cannot calculate inverse, determinant is zero");return[[e._divide(1,s)]]}if(2==t){var c=e.det(r);if(0==c)throw Error("Cannot calculate inverse, determinant is zero");return[[e._divide(r[1][1],c),e._divide(e.unaryMinus(r[0][1]),c)],[e._divide(e.unaryMinus(r[1][0]),c),e._divide(r[0][0],c)]]}var f=r.concat();for(i=0;t>i;i++)f[i]=f[i].concat();for(var l=e.eye(t).valueOf(),p=0;n>p;p++){for(i=p;t>i&&0==f[i][p];)i++;if(i==t||0==f[i][p])throw Error("Cannot calculate inverse, determinant is zero");i!=p&&(u=f[p],f[p]=f[i],f[i]=u,u=l[p],l[p]=l[i],l[i]=u);var m=f[p],h=l[p];for(i=0;t>i;i++){var g=f[i],d=l[i];if(i!=p){if(0!=g[p]){for(a=e._divide(e.unaryMinus(g[p]),m[p]),o=p;n>o;o++)g[o]=e.add(g[o],e.multiply(a,m[o]));for(o=0;n>o;o++)d[o]=e.add(d[o],e.multiply(a,h[o]))}}else{for(a=m[p],o=p;n>o;o++)g[o]=e._divide(g[o],a);for(o=0;n>o;o++)d[o]=e._divide(d[o],a)}}}return l}var n=t(171),i=t(10);e.inv=function(t){if(1!=arguments.length)throw new e.error.ArgumentsError("inv",arguments.length,1);var o=e.size(t).valueOf();switch(o.length){case 0:return e._divide(1,t);case 1:if(1==o[0])return t instanceof i?new i([e._divide(1,t.valueOf()[0])]):[e._divide(1,t[0])];throw new RangeError("Matrix must be square (size: "+n.string.format(o)+")");case 2:var a=o[0],s=o[1];if(a==s)return t instanceof i?new i(r(t.valueOf(),a,s)):r(t,a,s);throw new RangeError("Matrix must be square (size: "+n.string.format(o)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+n.string.format(o)+")")}}}},function(e,r,t){"use strict";e.exports=function(e,r){var n=t(171),i=e.type.BigNumber,o=t(10),a=t(14),s=n.array,u=Array.isArray;e.ones=function(e){var t=a.argsToArray(arguments),n=e instanceof o?!0:u(e)?!1:"matrix"===r.matrix;if(0==t.length)return n?new o:[];var c=!1;t=t.map(function(e){return e instanceof i?(c=!0,e.toNumber()):e});var f=[],l=c?new i(1):1;return f=s.resize(f,t,l),n?new o(f):f}}},function(e,r,t){"use strict";e.exports=function(e,r){function n(e,r,t){var n=[],i=e;if(t>0)for(;r>i;)n.push(i),i+=t;else if(0>t)for(;i>r;)n.push(i),i+=t;return n}function i(e,r,t){var n=[],i=e;if(t>0)for(;r>=i;)n.push(i),i+=t;else if(0>t)for(;i>=r;)n.push(i),i+=t;return n}function o(e,r,t){var n=[],i=e.clone(),o=new c(0);if(t.gt(o))for(;i.lt(r);)n.push(i),i=i.plus(t);else if(t.lt(o))for(;i.gt(r);)n.push(i),i=i.plus(t);return n}function a(e,r,t){var n=[],i=e.clone(),o=new c(0);if(t.gt(o))for(;i.lte(r);)n.push(i),i=i.plus(t);else if(t.lt(o))for(;i.gte(r);)n.push(i),i=i.plus(t);return n}function s(e){var t=e.split(":"),n=null;if("bignumber"===r.number)try{n=t.map(function(e){return new c(e)})}catch(i){return null}else{n=t.map(function(e){return Number(e)});var o=n.some(function(e){return isNaN(e)});if(o)return null}switch(n.length){case 2:return{start:n[0],end:n[1],step:1};case 3:return{start:n[0],end:n[2],step:n[1]};default:return null}}var u=t(171),c=e.type.BigNumber,f=t(10),l=(t(14),u["boolean"].isBoolean),p=u.string.isString,m=u.number.isNumber;e.range=function(){var t,u,h,g=Array.prototype.slice.call(arguments),d=!1;switch(l(g[g.length-1])&&(d=g.pop()?!0:!1),g.length){case 1:if(!p(g[0]))throw new TypeError("Two or three numbers or a single string expected in function range");var w=s(g[0]);if(!w)throw new SyntaxError('String "'+g[0]+'" is no valid range');t=w.start,u=w.end,h=w.step;break;case 2:t=g[0],u=g[1],h=1;break;case 3:t=g[0],u=g[1],h=g[2];break;case 4:throw new TypeError("Parameter includeEnd must be a boolean");default:throw new e.error.ArgumentsError("range",arguments.length,2,4)}if(!(m(t)||t instanceof c))throw new TypeError("Parameter start must be a number");if(!(m(u)||u instanceof c))throw new TypeError("Parameter end must be a number");if(!(m(h)||h instanceof c))throw new TypeError("Parameter step must be a number");if(t instanceof c||u instanceof c||h instanceof c){var x=!0;t instanceof c||(t=c.convert(t)),u instanceof c||(u=c.convert(u)),h instanceof c||(h=c.convert(h)),t instanceof c&&u instanceof c&&h instanceof c||(x=!1,t instanceof c&&(t=t.toNumber()),u instanceof c&&(u=u.toNumber()),h instanceof c&&(h=h.toNumber()))}var v=x?d?a:o:d?i:n,y=v(t,u,h);return"array"===r.matrix?y:new f(y)}}},function(e,r,t){"use strict";e.exports=function(e,r){function n(r,t,n){if(void 0!==n){if(!f(n)||1!==n.length)throw new TypeError("Single character expected as defaultValue")}else n=" ";if(1!==t.length)throw new e.error.DimensionError(t.length,1);var i=t[0];if(!l(i)||!p(i))throw new TypeError("Invalid size, must contain positive integers (size: "+c.format(t)+")");if(r.length>i)return r.substring(0,i);if(r.length<i){for(var o=r,a=0,s=i-r.length;s>a;a++)o+=n;return o}return r}var i=t(171),o=e.type.BigNumber,a=t(10),s=i.array,u=i.object.clone,c=i.string,f=i.string.isString,l=i.number.isNumber,p=i.number.isInteger,m=s.isArray;e.resize=function(t,i,c){if(2!=arguments.length&&3!=arguments.length)throw new e.error.ArgumentsError("resize",arguments.length,2,3);var l=t instanceof a?!0:m(t)?!1:"array"!==r.matrix;if(t instanceof a&&(t=t.valueOf()),i instanceof a&&(i=i.valueOf()),i.length&&i[0]instanceof o&&(i=i.map(function(e){return e instanceof o?e.toNumber():e})),f(t))return n(t,i,c);if(0==i.length){for(;m(t);)t=t[0];return u(t)}m(t)||(t=[t]),t=u(t);var p=s.resize(t,i,c);return l?new a(p):p}}},function(e,r,t){"use strict";e.exports=function(e,r){var n=t(171),i=e.type.BigNumber,o=t(7),a=t(11),s=t(10),u=n.array,c=n.number.isNumber,f=n["boolean"].isBoolean,l=n.string.isString,p=o.isComplex,m=a.isUnit;e.size=function(t){if(1!=arguments.length)throw new e.error.ArgumentsError("size",arguments.length,1);var n="array"===r.matrix;if(c(t)||p(t)||m(t)||f(t)||null==t||t instanceof i)return n?[]:new s([]);if(l(t))return n?[t.length]:new s([t.length]);if(Array.isArray(t))return u.size(t);if(t instanceof s)return new s(t.size());throw new e.error.UnsupportedTypeError("size",e["typeof"](t))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=t(10),i=r.object,o=r.array,a=Array.isArray;e.squeeze=function(r){if(1!=arguments.length)throw new e.error.ArgumentsError("squeeze",arguments.length,1);if(a(r))return o.squeeze(i.clone(r));if(r instanceof n){var t=o.squeeze(r.toArray());return a(t)?new n(t):t}return i.clone(r)}}},function(e,r,t){"use strict";e.exports=function(e){function r(r,t){var i,o;if(l(r))return i=new s(r),o=i.subset(t),o&&o.valueOf();if(r instanceof s)return r.subset(t);if(f(r))return n(r,t);throw new e.error.UnsupportedTypeError("subset",e["typeof"](r))}function n(r,t){if(!(t instanceof u))throw new TypeError("Index expected");if(1!=t.size().length)throw new e.error.DimensionError(t.size().length,1);var n=r.length;c.validateIndex(t.min()[0],n),c.validateIndex(t.max()[0],n);var i=t.range(0),o="";return i.forEach(function(e){o+=r.charAt(e)}),o}function i(r,t,n,i){var a;if(l(r))return a=new s(e.clone(r)),a.subset(t,n,i),a.valueOf();if(r instanceof s)return r.clone().subset(t,n,i);if(f(r))return o(r,t,n,i);throw new e.error.UnsupportedTypeError("subset",e["typeof"](r))}function o(r,t,n,i){if(!(t instanceof u))throw new TypeError("Index expected");if(1!=t.size().length)throw new e.error.DimensionError(t.size().length,1);if(void 0!==i){if(!f(i)||1!==i.length)throw new TypeError("Single character expected as defaultValue")}else i=" ";var o=t.range(0),a=o.size()[0];if(a!=n.length)throw new e.error.DimensionError(o.size()[0],n.length);var s=r.length;c.validateIndex(t.min()[0]),c.validateIndex(t.max()[0]);for(var l=[],p=0;s>p;p++)l[p]=r.charAt(p);if(o.forEach(function(e,r){l[e]=n.charAt(r)}),l.length>s)for(p=s-1,a=l.length;a>p;p++)l[p]||(l[p]=i);return l.join("")}var a=t(171),s=t(10),u=t(9),c=a.array,f=a.string.isString,l=Array.isArray;e.subset=function(){switch(arguments.length){case 2:return r(arguments[0],arguments[1]);case 3:case 4:return i(arguments[0],arguments[1],arguments[2],arguments[3]);default:throw new e.error.ArgumentsError("subset",arguments.length,2,4)}}}},function(e,r,t){"use strict";e.exports=function(e){function r(r){for(var t=0,n=0;n<r.length;n++)t=e.add(t,r[n][n]);return t}var n=t(171),i=t(10),o=n.object,a=n.string;e.trace=function(t){if(1!=arguments.length)throw new e.error.ArgumentsError("trace",arguments.length,1);var n;switch(t instanceof i?n=t.size():t instanceof Array?(t=new i(t),n=t.size()):n=[],n.length){case 0:return o.clone(t);case 1:if(1==n[0])return o.clone(t.valueOf()[0]);throw new RangeError("Matrix must be square (size: "+a.format(n)+")");case 2:var s=n[0],u=n[1];if(s==u)return r(t.clone().valueOf());throw new RangeError("Matrix must be square (size: "+a.format(n)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+a.format(n)+")")}}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=t(10),i=r.object,o=r.string;e.transpose=function(r){if(1!=arguments.length)throw new e.error.ArgumentsError("transpose",arguments.length,1);var t=e.size(r).valueOf();switch(t.length){case 0:return i.clone(r);case 1:return i.clone(r);case 2:var a,s=t[1],u=t[0],c=r instanceof n,f=r.valueOf(),l=[],p=i.clone;if(0===s)throw new RangeError("Cannot transpose a 2D matrix with no rows(size: "+o.format(t)+")");for(var m=0;s>m;m++){a=l[m]=[];for(var h=0;u>h;h++)a[h]=p(f[h][m])}return c?new n(l):l;default:throw new RangeError("Matrix must be two dimensional (size: "+o.format(t)+")")}}}},function(e,r,t){"use strict";e.exports=function(e,r){var n=t(171),i=e.type.BigNumber,o=t(10),a=t(14),s=n.array,u=Array.isArray;e.zeros=function(e){var t=a.argsToArray(arguments),n=e instanceof o?!0:u(e)?!1:"matrix"===r.matrix;if(0==t.length)return n?new o:[];var c=!1;t=t.map(function(e){return e instanceof i?(c=!0,e.toNumber()):e});var f=[],l=c?new i(0):0;return f=s.resize(f,t,l),n?new o(f):f}}},function(e,r,t){"use strict";e.exports=function(e,r){var n=t(171),i=e.type.BigNumber,o=t(14),a=n.number.isNumber,s=n["boolean"].isBoolean,u=(n.number.isInteger,o.isCollection);e.factorial=function p(t){var m,h,g;if(1!=arguments.length)throw new e.error.ArgumentsError("factorial",arguments.length,1);if(a(t))return t!==Number.POSITIVE_INFINITY?e.gamma(t+1):Math.sqrt(2*Math.PI);if(t instanceof i){if(!c(t))return t.isNegative()||t.isFinite()?e.gamma(t.plus(1)):n.bignumber.tau(r.precision).sqrt();if(t=t.toNumber(),t<l.length)return i.convert(l[t]).toSD(r.precision);var d=r.precision+(0|Math.log(t)),w=i.constructor({precision:d});if(t-=l.length,g=f[d]){if(g[t])return new i(g[t].toPrecision(r.precision));h=g[g.length-1]}else g=f[d]=[],h=new w(l[l.length-1]).toSD(d);var x=new w(1);m=new w(g.length+l.length);for(var v=g.length;t>v;++v)g[v]=h=h.times(m),m=m.plus(x);return g[t]=h.times(m),new i(g[t].toPrecision(r.precision))}if(s(t)||null===t)return 1;if(u(t))return o.deepMap(t,p);throw new e.error.UnsupportedTypeError("factorial",e["typeof"](t))};var c=function(e){return e.isInteger()&&(!e.isNegative()||e.isZero())},f=[],l=[1,1,2,6,24,120,720,5040,40320,362880,3628800,39916800,479001600,6227020800,87178291200,1307674368e3,20922789888e3,355687428096e3,6402373705728e3,0x1b02b9306890000,243290200817664e4]}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r["boolean"].isBoolean,s=i.isComplex,u=r.number.isNumber,c=r.number.isInteger,f=o.isCollection;e.gamma=function p(r){var t,m,h=4.7421875;if(1!=arguments.length)throw new e.error.ArgumentsError("gamma",arguments.length,1);if(u(r)){if(c(r)){if(0>=r)return isFinite(r)?1/0:0/0;if(r>171)return 1/0;for(var g=r-2,d=r-1;g>1;)d*=g,g--;return 0==d&&(d=1),d}if(.5>r)return Math.PI/(Math.sin(Math.PI*r)*p(1-r));if(r>=171.35)return 1/0;if(r>85){var w=r*r,x=w*r,v=x*r,y=v*r;return Math.sqrt(2*Math.PI/r)*Math.pow(r/Math.E,r)*(1+1/(12*r)+1/(288*w)-139/(51840*x)-571/(2488320*v)+163879/(209018880*y)+5246819/(75246796800*y*r))}--r,m=l[0];for(var b=1;b<l.length;++b)m+=l[b]/(r+b);return t=r+h+.5,Math.sqrt(2*Math.PI)*Math.pow(t,r+.5)*Math.exp(-t)*m}if(s(r)){if(0==r.im)return p(r.re);r=new i(r.re-1,r.im),m=new i(l[0],0);for(var b=1;b<l.length;++b){var E=r.re+b,N=E*E+r.im*r.im;0!=N?(m.re+=l[b]*E/N,m.im+=-(l[b]*r.im)/N):m.re=l[b]<0?-1/0:1/0}t=new i(r.re+h+.5,r.im);var M=Math.sqrt(2*Math.PI);r.re+=.5;var A=e.pow(t,r);0==A.im?A.re*=M:0==A.re?A.im*=M:(A.re*=M,A.im*=M);var T=Math.exp(-t.re);return t.re=T*Math.cos(-t.im),t.im=T*Math.sin(-t.im),e.multiply(e.multiply(A,t),m)}if(r instanceof n){if(r.isInteger())return r.isNegative()||r.isZero()?new n(1/0):e.factorial(r.minus(1));if(!r.isFinite())return new n(r.isNegative()?0/0:1/0)}if(a(r)||null===r)return r?1:1/0;if(f(r))return o.deepMap(r,p);throw new e.error.UnsupportedTypeError("gamma",e["typeof"](r))};var l=[.9999999999999971,57.15623566586292,-59.59796035547549,14.136097974741746,-.4919138160976202,3399464998481189e-20,4652362892704858e-20,-9837447530487956e-20,.0001580887032249125,-.00021026444172410488,.00021743961811521265,-.0001643181065367639,8441822398385275e-20,-26190838401581408e-21,36899182659531625e-22]}},function(e,r,t){"use strict";e.exports=function(e){var r=t(333)(e);e.random=r("uniform").random}},function(e,r,t){"use strict";e.exports=function(e){var r=t(333)(e);e.randomInt=r("uniform").randomInt}},function(e,r,t){"use strict";e.exports=function(e){var r=t(333)(e);e.pickRandom=r("uniform").pickRandom}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=r.number.isNumber,o=r.number.isInteger;e.permutations=function(r,t){var s,u,c=arguments.length;if(c>2)throw new e.error.ArgumentsError("permutations",arguments.length,2);if(i(r)){if(!o(r)||0>r)throw new TypeError("Positive integer value expected in function permutations");if(1==c)return e.factorial(r);if(2==c&&i(t)){if(!o(t)||0>t)throw new TypeError("Positive integer value expected in function permutations");if(t>r)throw new TypeError("second argument k must be less than or equal to first argument n");for(s=1,u=r-t+1;r>=u;u++)s*=u;return s}}if(r instanceof n){if(void 0===t&&a(r))return e.factorial(r);if(t=n.convert(t),!(t instanceof n&&a(r)&&a(t)))throw new TypeError("Positive integer value expected in function permutations");if(t.gt(r))throw new TypeError("second argument k must be less than or equal to first argument n");for(s=new n(1),u=r.minus(t).plus(1);u.lte(r);u=u.plus(1))s=s.times(u);return s}throw new e.error.UnsupportedTypeError("permutations",e["typeof"](r))};var a=function(e){return e.isInteger()&&e.gte(0)}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=(t(14),r.number.isNumber),o=r.number.isInteger;e.combinations=function(r,t){var s,u,c,f,l=arguments.length;if(2!=l)throw new e.error.ArgumentsError("combinations",arguments.length,2);if(i(r)){if(!o(r)||0>r)throw new TypeError("Positive integer value enpected in function combinations");if(t>r)throw new TypeError("k must be less than or equal to n");for(s=Math.max(t,r-t),u=1,c=1;r-s>=c;c++)u=u*(s+c)/c;return u}if(r instanceof n){if(t=n.convert(t),!(t instanceof n&&a(r)&&a(t)))throw new TypeError("Positive integer value expected in function combinations");if(t.gt(r))throw new TypeError("k must be less than n in function combinations");for(s=r.minus(t),t.lt(s)&&(s=t),u=new n(1),c=new n(1),f=r.minus(s);c.lte(f);c=c.plus(1))u=u.times(s.plus(c)).dividedBy(c);return u}throw new e.error.UnsupportedTypeError("combinations",e["typeof"](r))};var a=function(e){return e.isInteger()&&e.gte(0)}}},function(e,r,t){"use strict";e.exports=function(e,r){var n=t(171),i=e.type.BigNumber,o=t(7),a=t(11),s=t(14),u=n.number.isNumber,c=n.number.nearlyEqual,f=n["boolean"].isBoolean,l=n.string.isString,p=o.isComplex,m=a.isUnit,h=s.isCollection;e.compare=function g(t,n){if(2!=arguments.length)throw new e.error.ArgumentsError("compare",arguments.length,2);if(u(t)&&u(n))return c(t,n,r.epsilon)?0:t>n?1:-1;if(t instanceof i)return u(n)?n=i.convert(n):(f(n)||null===n)&&(n=new i(n?1:0)),n instanceof i?new i(t.cmp(n)):g(t.toNumber(),n);if(n instanceof i)return u(t)?t=i.convert(t):(f(t)||null===t)&&(t=new i(t?1:0)),t instanceof i?new i(t.cmp(n)):g(t,n.toNumber());if(m(t)&&m(n)){if(!t.equalBase(n))throw new Error("Cannot compare units with different base");return t.value>n.value?1:t.value<n.value?-1:0}if(h(t)||h(n))return s.deepMap2(t,n,g);if(l(t)||l(n))return t>n?1:n>t?-1:0;if(f(t)||null===t)return g(+t,n);if(f(n)||null===n)return g(t,+n);if(p(t)||p(n))throw new TypeError("No ordering relation is defined for complex numbers");throw new e.error.UnsupportedTypeError("compare",e["typeof"](t),e["typeof"](n))}}},function(e,r,t){"use strict";e.exports=function(e){function r(t,n){if(o(t)){if(o(n)){var i=t.length;if(i!==n.length)return!1;for(var a=0;i>a;a++)if(!r(t[a],n[a]))return!1;return!0}return!1}return o(n)?!1:e.equal(t,n)}var n=t(14),i=n.isCollection,o=Array.isArray;e.deepEqual=function(t,n){if(2!=arguments.length)throw new e.error.ArgumentsError("deepEqual",arguments.length,2);return i(t)||i(n)?r(t.valueOf(),n.valueOf()):e.equal(t,n)}}},function(e,r,t){"use strict";e.exports=function(e,r){var n=t(171),i=e.type.BigNumber,o=t(7),a=t(11),s=t(14),u=n.number.isNumber,c=n.number.nearlyEqual,f=n["boolean"].isBoolean,l=n.string.isString,p=o.isComplex,m=a.isUnit,h=s.isCollection;e.equal=function g(t,n){if(2!=arguments.length)throw new e.error.ArgumentsError("equal",arguments.length,2);if(u(t)){if(u(n))return c(t,n,r.epsilon);if(p(n))return c(t,n.re,r.epsilon)&&c(n.im,0,r.epsilon)}if(p(t)){if(u(n))return c(t.re,n,r.epsilon)&&c(t.im,0,r.epsilon);if(p(n))return c(t.re,n.re,r.epsilon)&&c(t.im,n.im,r.epsilon)}if(t instanceof i)return u(n)?n=i.convert(n):f(n)&&(n=new i(n?1:0)),n instanceof i?t.eq(n):g(t.toNumber(),n);if(n instanceof i)return u(t)?t=i.convert(t):f(t)&&(t=new i(t?1:0)),t instanceof i?t.eq(n):g(t,n.toNumber());if(m(t)&&m(n)){if(!t.equalBase(n))throw new Error("Cannot compare units with different base");return t.value==n.value}if(h(t)||h(n))return s.deepMap2(t,n,g);if(l(t)||l(n))return t==n;if(f(t))return g(+t,n);if(f(n))return g(t,+n);if(null===t)return null===n;if(null===n)return null===t;if(void 0===t)return void 0===n;if(void 0===n)return void 0===t;throw new e.error.UnsupportedTypeError("equal",e["typeof"](t),e["typeof"](n))}}},function(e,r,t){"use strict";e.exports=function(e,r){var n=t(171),i=e.type.BigNumber,o=t(7),a=t(11),s=t(14),u=n.number.isNumber,c=n.number.nearlyEqual,f=n["boolean"].isBoolean,l=n.string.isString,p=o.isComplex,m=a.isUnit,h=s.isCollection;e.larger=function g(t,n){if(2!=arguments.length)throw new e.error.ArgumentsError("larger",arguments.length,2);if(u(t)&&u(n))return!c(t,n,r.epsilon)&&t>n;if(t instanceof i)return u(n)?n=i.convert(n):(f(n)||null===n)&&(n=new i(n?1:0)),n instanceof i?t.gt(n):g(t.toNumber(),n);if(n instanceof i)return u(t)?t=i.convert(t):(f(t)||null===t)&&(t=new i(t?1:0)),t instanceof i?t.gt(n):g(t,n.toNumber());if(m(t)&&m(n)){if(!t.equalBase(n))throw new Error("Cannot compare units with different base");return t.value>n.value}if(h(t)||h(n))return s.deepMap2(t,n,g);if(l(t)||l(n))return t>n;if(f(t)||null===t)return g(+t,n);if(f(n)||null===n)return g(t,+n);if(p(t)||p(n))throw new TypeError("No ordering relation is defined for complex numbers");throw new e.error.UnsupportedTypeError("larger",e["typeof"](t),e["typeof"](n))}}},function(e,r,t){"use strict";e.exports=function(e,r){var n=t(171),i=e.type.BigNumber,o=t(7),a=t(11),s=t(14),u=n.number.isNumber,c=n.number.nearlyEqual,f=n["boolean"].isBoolean,l=n.string.isString,p=o.isComplex,m=a.isUnit,h=s.isCollection;e.largerEq=function g(t,n){if(2!=arguments.length)throw new e.error.ArgumentsError("largerEq",arguments.length,2);if(u(t)&&u(n))return c(t,n,r.epsilon)||t>n;if(t instanceof i)return u(n)?n=i.convert(n):(f(n)||null===n)&&(n=new i(n?1:0)),n instanceof i?t.gte(n):g(t.toNumber(),n);if(n instanceof i)return u(t)?t=i.convert(t):(f(t)||null===t)&&(t=new i(t?1:0)),t instanceof i?t.gte(n):g(t,n.toNumber());if(m(t)&&m(n)){if(!t.equalBase(n))throw new Error("Cannot compare units with different base");return t.value>=n.value}if(h(t)||h(n))return s.deepMap2(t,n,g);if(l(t)||l(n))return t>=n;if(f(t)||null===t)return g(+t,n);if(f(n)||null===n)return g(t,+n);if(p(t)||p(n))throw new TypeError("No ordering relation is defined for complex numbers");throw new e.error.UnsupportedTypeError("largerEq",e["typeof"](t),e["typeof"](n))},e.largereq=function(){throw new Error("Function largereq is renamed to largerEq")}}},function(e,r,t){"use strict";e.exports=function(e,r){var n=t(171),i=e.type.BigNumber,o=t(7),a=t(11),s=t(14),u=n.number.isNumber,c=n.number.nearlyEqual,f=n["boolean"].isBoolean,l=n.string.isString,p=o.isComplex,m=a.isUnit,h=s.isCollection;e.smaller=function g(t,n){if(2!=arguments.length)throw new e.error.ArgumentsError("smaller",arguments.length,2);if(u(t)&&u(n))return!c(t,n,r.epsilon)&&n>t;if(t instanceof i)return u(n)?n=i.convert(n):(f(n)||null===n)&&(n=new i(n?1:0)),n instanceof i?t.lt(n):g(t.toNumber(),n);if(n instanceof i)return u(t)?t=i.convert(t):(f(t)||null===t)&&(t=new i(t?1:0)),t instanceof i?t.lt(n):g(t,n.toNumber());if(m(t)&&m(n)){if(!t.equalBase(n))throw new Error("Cannot compare units with different base");return t.value<n.value}if(h(t)||h(n))return s.deepMap2(t,n,g);if(l(t)||l(n))return n>t;if(f(t)||null===t)return g(+t,n);if(f(n)||null===n)return g(t,+n);if(p(t)||p(n))throw new TypeError("No ordering relation is defined for complex numbers");throw new e.error.UnsupportedTypeError("smaller",e["typeof"](t),e["typeof"](n))}}},function(e,r,t){"use strict";e.exports=function(e,r){var n=t(171),i=e.type.BigNumber,o=t(7),a=t(11),s=t(14),u=n.number.isNumber,c=n.number.nearlyEqual,f=n["boolean"].isBoolean,l=n.string.isString,p=o.isComplex,m=a.isUnit,h=s.isCollection;e.smallerEq=function g(t,n){if(2!=arguments.length)throw new e.error.ArgumentsError("smallerEq",arguments.length,2);if(u(t)&&u(n))return c(t,n,r.epsilon)||n>t;if(t instanceof i)return u(n)?n=i.convert(n):(f(n)||null===n)&&(n=new i(n?1:0)),n instanceof i?t.lte(n):g(t.toNumber(),n);if(n instanceof i)return u(t)?t=i.convert(t):(f(t)||null===t)&&(t=new i(t?1:0)),t instanceof i?t.lte(n):g(t,n.toNumber());if(m(t)&&m(n)){if(!t.equalBase(n))throw new Error("Cannot compare units with different base");return t.value<=n.value}if(h(t)||h(n))return s.deepMap2(t,n,g);if(l(t)||l(n))return n>=t;if(f(t)||null===t)return g(+t,n);if(f(n)||null===n)return g(t,+n);if(p(t)||p(n))throw new TypeError("No ordering relation is defined for complex numbers");throw new e.error.UnsupportedTypeError("smallerEq",e["typeof"](t),e["typeof"](n))},e.smallereq=function(){throw new Error("Function smallereq is renamed to smallerEq")}}},function(e,r,t){"use strict";e.exports=function(e,r){var n=t(171),i=e.type.BigNumber,o=t(7),a=t(11),s=t(14),u=n.number.isNumber,c=n.number.nearlyEqual,f=n["boolean"].isBoolean,l=n.string.isString,p=o.isComplex,m=a.isUnit,h=s.isCollection;e.unequal=function g(t,n){if(2!=arguments.length)throw new e.error.ArgumentsError("unequal",arguments.length,2);if(u(t)){if(u(n))return!c(t,n,r.epsilon);if(p(n))return!c(t,n.re,r.epsilon)||!c(n.im,0,r.epsilon)}if(p(t)){if(u(n))return!c(t.re,n,r.epsilon)||!c(t.im,0,r.epsilon);if(p(n))return!c(t.re,n.re,r.epsilon)||!c(t.im,n.im,r.epsilon)}if(t instanceof i)return u(n)?n=i.convert(n):f(n)&&(n=new i(n?1:0)),n instanceof i?!t.eq(n):g(t.toNumber(),n);if(n instanceof i)return u(t)?t=i.convert(t):f(t)&&(t=new i(t?1:0)),t instanceof i?!t.eq(n):g(t,n.toNumber());if(m(t)&&m(n)){if(!t.equalBase(n))throw new Error("Cannot compare units with different base");return t.value!=n.value}if(h(t)||h(n))return s.deepMap2(t,n,g);if(l(t)||l(n))return t!=n;if(f(t))return g(+t,n);if(f(n))return g(t,+n);if(null===t)return null!==n;if(null===n)return null!==t;if(void 0===t)return void 0!==n;if(void 0===n)return void 0!==t;throw new e.error.UnsupportedTypeError("unequal",e["typeof"](t),e["typeof"](n))}}},function(e,r,t){"use strict";e.exports=function(e){function r(r,t){return e.smaller(r,t)?r:t}function n(r){var t=void 0;if(i.deepForEach(r,function(r){(void 0===t||e.smaller(r,t))&&(t=r)}),void 0===t)throw new Error("Cannot calculate min of an empty array");return t}var i=(t(10),t(14)),o=i.isCollection;e.min=function(e){if(0==arguments.length)throw new SyntaxError("Function min requires one or more parameters (0 provided)");if(o(e)){if(1==arguments.length)return n(e);if(2==arguments.length)return i.reduce(arguments[0],arguments[1],r);throw new SyntaxError("Wrong number of parameters")}return n(arguments)}}},function(e,r,t){"use strict";e.exports=function(e){function r(r,t){return e.larger(r,t)?r:t}function n(r){var t=void 0;if(i.deepForEach(r,function(r){(void 0===t||e.larger(r,t))&&(t=r)}),void 0===t)throw new Error("Cannot calculate max of an empty array");return t}var i=(t(10),t(14)),o=i.isCollection;e.max=function(e){if(0==arguments.length)throw new SyntaxError("Function max requires one or more parameters (0 provided)");if(o(e)){if(1==arguments.length)return n(e);if(2==arguments.length)return i.reduce(arguments[0],arguments[1],r);throw new SyntaxError("Wrong number of parameters")}return n(arguments)}}},function(e,r,t){"use strict";e.exports=function(e){function r(r,t){var n=i.reduce(r,t,e.add),o=s(r)?a(r):r.size();return e.divide(n,o[t])}function n(r){var t=0,n=0;if(i.deepForEach(r,function(r){t=e.add(t,r),n++}),0===n)throw new Error("Cannot calculate mean of an empty array");return e.divide(t,n)}var i=(t(10),t(14)),o=i.isCollection,a=t(165).size,s=Array.isArray;e.mean=function(e){if(0==arguments.length)throw new SyntaxError("Function mean requires one or more parameters (0 provided)");if(o(e)){if(1==arguments.length)return n(e);if(2==arguments.length)return r(arguments[0],arguments[1]);throw new SyntaxError("Wrong number of parameters")}return n(arguments)}}},function(e,r,t){"use strict";e.exports=function(e){function r(r){var t=u(r);t.sort(e.compare);var o=t.length;if(0==o)throw new Error("Cannot calculate median of an empty array");if(o%2==0){var s=t[o/2-1],c=t[o/2];if(!(a(s)||s instanceof i||s instanceof n))throw new e.error.UnsupportedTypeError("median",e["typeof"](s));if(!(a(c)||c instanceof i||c instanceof n))throw new e.error.UnsupportedTypeError("median",e["typeof"](c));return e.divide(e.add(s,c),2)}var f=t[(o-1)/2];if(!(a(f)||f instanceof i||f instanceof n))throw new e.error.UnsupportedTypeError("median",e["typeof"](f));return f}var n=(t(10),t(11)),i=e.type.BigNumber,o=t(14),a=t(3).isNumber,s=o.isCollection,u=t(165).flatten;e.median=function(e){if(0==arguments.length)throw new SyntaxError("Function median requires one or more parameters (0 provided)");if(s(e)){if(1==arguments.length)return r(e.valueOf());throw 2==arguments.length?new Error("median(A, dim) is not yet supported"):new SyntaxError("Wrong number of parameters")}return r(Array.prototype.slice.call(arguments))}}},function(e,r,t){"use strict";e.exports=function(e){function r(r){var t=void 0;if(n.deepForEach(r,function(r){t=void 0===t?r:e.multiply(t,r)}),void 0===t)throw new Error("Cannot calculate prod of an empty array");return t}var n=(t(10),t(14)),i=n.isCollection;e.prod=function(e){if(0==arguments.length)throw new SyntaxError("Function prod requires one or more parameters (0 provided)");if(i(e)){if(1==arguments.length)return r(e);throw 2==arguments.length?new Error("prod(A, dim) is not yet supported"):new SyntaxError("Wrong number of parameters")}return r(arguments)}}},function(e){"use strict";e.exports=function(e){e.std=function(){if(0==arguments.length)throw new SyntaxError("Function std requires one or more parameters (0 provided)");var r=e["var"].apply(null,arguments);return e.sqrt(r)}}},function(e,r,t){"use strict";e.exports=function(e){function r(r){var t=void 0;if(n.deepForEach(r,function(r){t=void 0===t?r:e.add(t,r)}),void 0===t)throw new Error("Cannot calculate sum of an empty array");
return t}var n=(t(10),t(14)),i=n.isCollection;e.sum=function(e){if(0==arguments.length)throw new SyntaxError("Function sum requires one or more parameters (0 provided)");if(i(e)){if(1==arguments.length)return r(e);throw 2==arguments.length?new Error("sum(A, dim) is not yet supported"):new SyntaxError("Wrong number of parameters")}return r(arguments)}}},function(e,r,t){"use strict";e.exports=function(e){function r(r,t){var o=0,a=0;if(i.deepForEach(r,function(r){o=e.add(o,r),a++}),0===a)throw new Error("Cannot calculate var of an empty array");var s=e.divide(o,a);switch(o=0,i.deepForEach(r,function(r){var t=e.subtract(r,s);o=e.add(o,e.multiply(t,t))}),t){case"uncorrected":return e.divide(o,a);case"biased":return e.divide(o,a+1);case"unbiased":var u=o instanceof n?new n(0):0;return 1==a?u:e.divide(o,a-1);default:throw new Error('Unknown normalization "'+t+'". Choose "unbiased" (default), "uncorrected", or "biased".')}}var n=(t(10),e.type.BigNumber),i=t(14),o=i.isCollection,a=t(205).isString,s="unbiased";e["var"]=function(e,t){if(0==arguments.length)throw new SyntaxError("Function var requires one or more parameters (0 provided)");if(o(e)){if(1==arguments.length)return r(e,s);if(2==arguments.length){if(!a(t))throw new Error("String expected for parameter normalization");return r(e,t)}throw new SyntaxError("Wrong number of parameters")}return r(arguments,s)}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,c=o.isCollection,f=r.bignumber.arccos_arcsec;e.acos=function l(r){if(1!=arguments.length)throw new e.error.ArgumentsError("acos",arguments.length,1);if(a(r))return r>=-1&&1>=r?Math.acos(r):l(new i(r,0));if(u(r)){var t=new i(r.im*r.im-r.re*r.re+1,-2*r.re*r.im),p=e.sqrt(t),m=new i(p.re-r.im,p.im+r.re),h=e.log(m);return new i(1.5707963267948966-h.im,h.re)}if(c(r))return o.deepMap(r,l);if(s(r)||null===r)return Math.acos(r);if(r instanceof n)return f(r,n,!1);throw new e.error.UnsupportedTypeError("acos",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=(o.isUnit,a.isCollection),l=r.bignumber.acosh_asinh_asech_acsch;e.acosh=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("acosh",arguments.length,1);if(s(r))return r>=1?Math.log(Math.sqrt(r*r-1)+r):-1>=r?new i(Math.log(Math.sqrt(r*r-1)-r),Math.PI):p(new i(r,0));if(c(r)){var t,o=e.acos(r);return o.im<=0?(t=o.re,o.re=-o.im,o.im=t):(t=o.im,o.im=-o.re,o.re=t),o}if(f(r))return a.deepMap(r,p);if(u(r)||null===r)return r?0:new i(0,1.5707963267948966);if(r instanceof n)return l(r,n,!1,!1);throw new e.error.UnsupportedTypeError("acosh",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,c=o.isCollection,f=r.bignumber.arctan_arccot;e.acot=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("acot",arguments.length,1);if(a(r))return r?Math.atan(1/r):l;if(u(r)){if(0==r.im)return new i(r.re?Math.atan(1/r.re):l,0);var t=r.re*r.re+r.im*r.im;return r=0!=t?new i(r.re=r.re/t,r.im=-r.im/t):new i(0!=r.re?r.re/0:0,0!=r.im?-(r.im/0):0),e.atan(r)}if(c(r))return o.deepMap(r,p);if(s(r)||null===r)return r?.7853981633974483:l;if(r instanceof n)return f(r,n,!0);throw new e.error.UnsupportedTypeError("acot",e["typeof"](r))};var l=1.5707963267948966}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=(o.isUnit,a.isCollection),l=r.bignumber.atanh_acoth;e.acoth=function m(r){if(1!=arguments.length)throw new e.error.ArgumentsError("acoth",arguments.length,1);if(s(r))return r>=1||-1>=r?isFinite(r)?(Math.log((r+1)/r)+Math.log(r/(r-1)))/2:0:r?m(new i(r,0)):new i(0,p);if(c(r)){if(0==r.re&&0==r.im)return new i(0,p);var t=r.re*r.re+r.im*r.im;return r=0!=t?new i(r.re/t,-r.im/t):new i(0!=r.re?r.re/0:0,0!=r.im?-(r.im/0):0),e.atanh(r)}if(f(r))return a.deepMap(r,m);if(u(r)||null===r)return r?1/0:new i(0,p);if(r instanceof n)return l(r,n,!0);throw new e.error.UnsupportedTypeError("acoth",e["typeof"](r))};var p=1.5707963267948966}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,c=o.isCollection,f=r.bignumber.arcsin_arccsc;e.acsc=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("acsc",arguments.length,1);if(a(r))return-1>=r||r>=1?Math.asin(1/r):p(new i(r,0));if(u(r)){if(0==r.re&&0==r.im)return new i(l,1/0);var t=r.re*r.re+r.im*r.im;return r=0!=t?new i(r.re=r.re/t,r.im=-r.im/t):new i(0!=r.re?r.re/0:0,0!=r.im?-(r.im/0):0),e.asin(r)}if(c(r))return o.deepMap(r,p);if(s(r)||null===r)return r?l:new i(l,1/0);if(r instanceof n)return f(r,n,!0);throw new e.error.UnsupportedTypeError("acsc",e["typeof"](r))};var l=1.5707963267948966}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=(o.isUnit,a.isCollection),l=r.bignumber.acosh_asinh_asech_acsch;e.acsch=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("acsch",arguments.length,1);if(s(r))return r=1/r,Math.log(r+Math.sqrt(r*r+1));if(c(r)){if(0==r.im)return r=0!=r.re?Math.log(r.re+Math.sqrt(r.re*r.re+1)):1/0,new i(r,0);var t=r.re*r.re+r.im*r.im;return r=0!=t?new i(r.re/t,-r.im/t):new i(0!=r.re?r.re/0:0,0!=r.im?-(r.im/0):0),e.asinh(r)}if(f(r))return a.deepMap(r,p);if(u(r)||null===r)return r?.881373587019543:1/0;if(r instanceof n)return l(r,n,!0,!0);throw new e.error.UnsupportedTypeError("acsch",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,c=o.isCollection,f=r.bignumber.arccos_arcsec;e.asec=function l(r){if(1!=arguments.length)throw new e.error.ArgumentsError("asec",arguments.length,1);if(a(r))return-1>=r||r>=1?Math.acos(1/r):l(new i(r,0));if(u(r)){if(0==r.re&&0==r.im)return new i(0,1/0);var t=r.re*r.re+r.im*r.im;return r=0!=t?new i(r.re=r.re/t,r.im=-r.im/t):new i(0!=r.re?r.re/0:0,0!=r.im?-(r.im/0):0),e.acos(r)}if(c(r))return o.deepMap(r,l);if(s(r)||null===r)return r?0:new i(0,1/0);if(r instanceof n)return f(r,n,!0);throw new e.error.UnsupportedTypeError("asec",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=(o.isUnit,a.isCollection),l=r.bignumber.acosh_asinh_asech_acsch;e.asech=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("asech",arguments.length,1);if(s(r)){if(1>=r&&r>=-1){r=1/r;var t=Math.sqrt(r*r-1);return r>0?Math.log(t+r):new i(Math.log(t-r),Math.PI)}return p(new i(r,0))}if(c(r)){if(0==r.re&&0==r.im)return new i(1/0,0);var o=r.re*r.re+r.im*r.im;return r=0!=o?new i(r.re/o,-r.im/o):new i(0!=r.re?r.re/0:0,0!=r.im?-(r.im/0):0),e.acosh(r)}if(f(r))return a.deepMap(r,p);if(u(r)||null===r)return r?0:1/0;if(r instanceof n)return l(r,n,!1,!0);throw new e.error.UnsupportedTypeError("asech",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,c=o.isCollection,f=r.bignumber.arcsin_arccsc;e.asin=function l(r){if(1!=arguments.length)throw new e.error.ArgumentsError("asin",arguments.length,1);if(a(r))return r>=-1&&1>=r?Math.asin(r):l(new i(r,0));if(u(r)){var t=r.re,p=r.im,m=new i(p*p-t*t+1,-2*t*p),h=e.sqrt(m),g=new i(h.re-p,h.im+t),d=e.log(g);return new i(d.im,-d.re)}if(c(r))return o.deepMap(r,l);if(s(r)||null===r)return Math.asin(r);if(r instanceof n)return f(r,n,!1);throw new e.error.UnsupportedTypeError("asin",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=(o.isUnit,a.isCollection),l=r.bignumber.acosh_asinh_asech_acsch;e.asinh=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("asinh",arguments.length,1);if(s(r))return Math.log(Math.sqrt(r*r+1)+r);if(c(r)){var t=r.im;r.im=-r.re,r.re=t;var i=e.asin(r);return r.re=-r.im,r.im=t,t=i.re,i.re=-i.im,i.im=t,i}if(f(r))return a.deepMap(r,p);if(u(r)||null===r)return r?.881373587019543:0;if(r instanceof n)return l(r,n,!0,!1);throw new e.error.UnsupportedTypeError("asinh",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=i.isComplex,c=o.isCollection,f=r.bignumber.arctan_arccot;e.atan=function l(r){if(1!=arguments.length)throw new e.error.ArgumentsError("atan",arguments.length,1);if(a(r))return Math.atan(r);if(u(r)){if(0==r.re){if(1==r.im)return new i(0,1/0);if(-1==r.im)return new i(0,-1/0)}var t=r.re,p=r.im,m=t*t+(1-p)*(1-p),h=new i((1-p*p-t*t)/m,-2*t/m),g=e.log(h);return new i(-.5*g.im,.5*g.re)}if(c(r))return o.deepMap(r,l);if(s(r)||null===r)return Math.atan(r);if(r instanceof n)return f(r,n,!1);throw new e.error.UnsupportedTypeError("atan",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(14),a=r.number.isNumber,s=r["boolean"].isBoolean,u=(i.isComplex,o.isCollection);e.atan2=function c(r,t){if(2!=arguments.length)throw new e.error.ArgumentsError("atan2",arguments.length,2);if(a(r)&&a(t))return Math.atan2(r,t);if(u(r)||u(t))return o.deepMap2(r,t,c);if(s(r)||null===r)return c(+r,t);if(s(t)||null===t)return c(r,+t);if(r instanceof n)return c(r.toNumber(),t);if(t instanceof n)return c(r,t.toNumber());throw new e.error.UnsupportedTypeError("atan2",e["typeof"](r),e["typeof"](t))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=(o.isUnit,a.isCollection),l=r.bignumber.atanh_acoth;e.atanh=function p(r){if(1!=arguments.length)throw new e.error.ArgumentsError("atanh",arguments.length,1);if(s(r))return 1>=r&&r>=-1?Math.log((1+r)/(1-r))/2:p(new i(r,0));if(c(r)){var t=r.re>1&&0==r.im,o=1-r.re,m=1+r.re,h=o*o+r.im*r.im;r=0!=h?new i((m*o-r.im*r.im)/h,(r.im*o+m*r.im)/h):new i(-1!=r.re?r.re/0:0,0!=r.im?r.im/0:0);var g=r.re;return r.re=Math.log(Math.sqrt(r.re*r.re+r.im*r.im))/2,r.im=Math.atan2(r.im,g)/2,t&&(r.im=-r.im),r}if(f(r))return a.deepMap(r,p);if(u(r)||null===r)return r?1/0:0;if(r instanceof n)return l(r,n,!1);throw new e.error.UnsupportedTypeError("atanh",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection,p=r.bignumber.cos_sin_sec_csc;e.cos=function m(r){if(1!=arguments.length)throw new e.error.ArgumentsError("cos",arguments.length,1);if(s(r))return Math.cos(r);if(c(r))return new i(Math.cos(r.re)*e.cosh(-r.im),Math.sin(r.re)*e.sinh(-r.im));if(f(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cos is no angle");return Math.cos(r.value)}if(l(r))return a.deepMap(r,m);if(u(r)||null===r)return Math.cos(r);if(r instanceof n)return p(r,n,0,!1);throw new e.error.UnsupportedTypeError("cos",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection,p=r.bignumber.cosh_sinh_csch_sech;e.cosh=function m(r){if(1!=arguments.length)throw new e.error.ArgumentsError("cosh",arguments.length,1);if(s(r))return(Math.exp(r)+Math.exp(-r))/2;if(c(r)){var t=Math.exp(r.re),h=Math.exp(-r.re);return new i(Math.cos(r.im)*(t+h)/2,Math.sin(r.im)*(t-h)/2)}if(f(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cosh is no angle");return m(r.value)}if(l(r))return a.deepMap(r,m);if(u(r)||null===r)return m(r?1:0);if(r instanceof n)return p(r,n,!1,!1);throw new e.error.UnsupportedTypeError("cosh",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection,p=r.bignumber.tan_cot;e.cot=function m(r){if(1!=arguments.length)throw new e.error.ArgumentsError("cot",arguments.length,1);if(s(r))return 1/Math.tan(r);if(c(r)){var t=Math.exp(-4*r.im)-2*Math.exp(-2*r.im)*Math.cos(2*r.re)+1;return new i(2*Math.exp(-2*r.im)*Math.sin(2*r.re)/t,(Math.exp(-4*r.im)-1)/t)}if(f(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cot is no angle");return 1/Math.tan(r.value)}if(l(r))return a.deepMap(r,m);if(u(r)||null===r)return m(+r);if(r instanceof n)return p(r,n,!0);throw new e.error.UnsupportedTypeError("cot",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection,p=r.bignumber.tanh_coth;e.coth=function m(r){if(1!=arguments.length)throw new e.error.ArgumentsError("coth",arguments.length,1);if(s(r)){var t=Math.exp(2*r);return(t+1)/(t-1)}if(c(r)){var h=Math.exp(2*r.re),g=h*Math.cos(2*r.im),d=h*Math.sin(2*r.im),w=(g-1)*(g-1)+d*d;return new i(((g+1)*(g-1)+d*d)/w,-2*d/w)}if(f(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function coth is no angle");return m(r.value)}if(l(r))return a.deepMap(r,m);if(u(r)||null===r)return m(r?1:0);if(r instanceof n)return p(r,n,!0);throw new e.error.UnsupportedTypeError("coth",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection,p=r.bignumber.cos_sin_sec_csc;e.csc=function m(r){if(1!=arguments.length)throw new e.error.ArgumentsError("csc",arguments.length,1);if(s(r))return 1/Math.sin(r);if(c(r)){var t=.25*(Math.exp(-2*r.im)+Math.exp(2*r.im))-.5*Math.cos(2*r.re);return new i(.5*Math.sin(r.re)*(Math.exp(-r.im)+Math.exp(r.im))/t,.5*Math.cos(r.re)*(Math.exp(-r.im)-Math.exp(r.im))/t)}if(f(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function csc is no angle");return 1/Math.sin(r.value)}if(l(r))return a.deepMap(r,m);if(u(r)||null===r)return m(+r);if(r instanceof n)return p(r,n,1,!0);throw new e.error.UnsupportedTypeError("csc",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number,u=r.number.isNumber,c=r["boolean"].isBoolean,f=i.isComplex,l=o.isUnit,p=a.isCollection,m=r.bignumber.cosh_sinh_csch_sech;e.csch=function h(r){if(1!=arguments.length)throw new e.error.ArgumentsError("csch",arguments.length,1);if(u(r))return 0==r?Number.POSITIVE_INFINITY:Math.abs(2/(Math.exp(r)-Math.exp(-r)))*s.sign(r);if(f(r)){var t=Math.exp(r.re),g=Math.exp(-r.re),d=Math.cos(r.im)*(t-g),w=Math.sin(r.im)*(t+g),x=d*d+w*w;return new i(2*d/x,-2*w/x)}if(l(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function csch is no angle");return h(r.value)}if(p(r))return a.deepMap(r,h);if(c(r)||null===r)return h(r?1:0);if(r instanceof n)return m(r,n,!0,!0);throw new e.error.UnsupportedTypeError("csch",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection,p=r.bignumber.cos_sin_sec_csc;e.sec=function m(r){if(1!=arguments.length)throw new e.error.ArgumentsError("sec",arguments.length,1);if(s(r))return 1/Math.cos(r);if(c(r)){var t=.25*(Math.exp(-2*r.im)+Math.exp(2*r.im))+.5*Math.cos(2*r.re);return new i(.5*Math.cos(r.re)*(Math.exp(-r.im)+Math.exp(r.im))/t,.5*Math.sin(r.re)*(Math.exp(r.im)-Math.exp(-r.im))/t)}if(f(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sec is no angle");return 1/Math.cos(r.value)}if(l(r))return a.deepMap(r,m);if(u(r)||null===r)return m(+r);if(r instanceof n)return p(r,n,0,!0);throw new e.error.UnsupportedTypeError("sec",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection,p=r.bignumber.cosh_sinh_csch_sech;e.sech=function m(r){if(1!=arguments.length)throw new e.error.ArgumentsError("sech",arguments.length,1);if(s(r))return 2/(Math.exp(r)+Math.exp(-r));if(c(r)){var t=Math.exp(r.re),h=Math.exp(-r.re),g=Math.cos(r.im)*(t+h),d=Math.sin(r.im)*(t-h),w=g*g+d*d;return new i(2*g/w,-2*d/w)}if(f(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sech is no angle");return m(r.value)}if(l(r))return a.deepMap(r,m);if(u(r)||null===r)return m(r?1:0);if(r instanceof n)return p(r,n,!1,!0);throw new e.error.UnsupportedTypeError("sech",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection,p=r.bignumber.cos_sin_sec_csc;e.sin=function m(r){if(1!=arguments.length)throw new e.error.ArgumentsError("sin",arguments.length,1);if(s(r))return Math.sin(r);if(c(r))return new i(Math.sin(r.re)*e.cosh(-r.im),Math.cos(r.re)*e.sinh(r.im));if(f(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sin is no angle");return Math.sin(r.value)}if(l(r))return a.deepMap(r,m);if(u(r)||null===r)return Math.sin(r);if(r instanceof n)return p(r,n,1,!1);throw new e.error.UnsupportedTypeError("sin",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection,p=r.bignumber.cosh_sinh_csch_sech;e.sinh=function m(r){if(1!=arguments.length)throw new e.error.ArgumentsError("sinh",arguments.length,1);if(s(r))return Math.abs(r)<1?r+r*r*r/6+r*r*r*r*r/120:(Math.exp(r)-Math.exp(-r))/2;if(c(r)){var t=Math.cos(r.im),h=Math.sin(r.im),g=Math.exp(r.re),d=Math.exp(-r.re);return new i(t*(g-d)/2,h*(g+d)/2)}if(f(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sinh is no angle");return m(r.value)}if(l(r))return a.deepMap(r,m);if(u(r)||null===r)return m(r?1:0);if(r instanceof n)return p(r,n,!0,!1);throw new e.error.UnsupportedTypeError("sinh",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection,p=r.bignumber.tan_cot;e.tan=function m(r){if(1!=arguments.length)throw new e.error.ArgumentsError("tan",arguments.length,1);if(s(r))return Math.tan(r);if(c(r)){var t=Math.exp(-4*r.im)+2*Math.exp(-2*r.im)*Math.cos(2*r.re)+1;return new i(2*Math.exp(-2*r.im)*Math.sin(2*r.re)/t,(1-Math.exp(-4*r.im))/t)}if(f(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function tan is no angle");return Math.tan(r.value)}if(l(r))return a.deepMap(r,m);if(u(r)||null===r)return Math.tan(r);if(r instanceof n)return p(r,n,!1);throw new e.error.UnsupportedTypeError("tan",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=e.type.BigNumber,i=t(7),o=t(11),a=t(14),s=r.number.isNumber,u=r["boolean"].isBoolean,c=i.isComplex,f=o.isUnit,l=a.isCollection,p=r.bignumber.tanh_coth;e.tanh=function m(r){if(1!=arguments.length)throw new e.error.ArgumentsError("tanh",arguments.length,1);if(s(r)){var t=Math.exp(2*r);return(t-1)/(t+1)}if(c(r)){var h=Math.exp(2*r.re),g=h*Math.cos(2*r.im),d=h*Math.sin(2*r.im),w=(g+1)*(g+1)+d*d;return new i(((g-1)*(g+1)+d*d)/w,2*d/w)}if(f(r)){if(!r.hasBase(o.BASE_UNITS.ANGLE))throw new TypeError("Unit in function tanh is no angle");return m(r.value)}if(l(r))return a.deepMap(r,m);if(u(r)||null===r)return m(r?1:0);if(r instanceof n)return p(r,n,!1);throw new e.error.UnsupportedTypeError("tanh",e["typeof"](r))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=t(11),i=t(14),o=r.string.isString,a=n.isUnit,s=i.isCollection;e.to=function u(r,t){if(2!=arguments.length)throw new e.error.ArgumentsError("to",arguments.length,2);if(a(r)&&(a(t)||o(t)))return r.to(t);if(s(r)||s(t))return i.deepMap2(r,t,u);throw new e.error.UnsupportedTypeError("to",e["typeof"](r),e["typeof"](t))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=r.object;e.clone=function(r){if(1!=arguments.length)throw new e.error.ArgumentsError("clone",arguments.length,1);return n.clone(r)}}},function(e,r,t){"use strict";e.exports=function(e){function r(e,r){if("function"==typeof r)return e.filter(function(e){return r(e)});if(r instanceof RegExp)return e.filter(function(e){return r.test(e)});throw new TypeError("Function or RegExp expected")}var n=t(10);e.filter=function(t,i){if(2!==arguments.length)throw new e.error.ArgumentsError("filter",arguments.length,2);if(t instanceof n){var o=t.size();if(o.length>1)throw new Error("Only one dimensional matrices supported");return new n(r(t.toArray(),i))}if(Array.isArray(t))return r(t,i);throw new e.error.UnsupportedTypeError("filter",e["typeof"](t),e["typeof"](compare))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=r.string;e.format=function(r,t){var i=arguments.length;if(1!==i&&2!==i)throw new e.error.ArgumentsError("format",i,1,2);return n.format(r,t)}}},function(e,r,t){"use strict";e.exports=function(e){function r(r,t,n){(n.override||void 0===e[r])&&(n.wrap&&"function"==typeof t?(e[r]=function(){for(var r=[],n=0,i=arguments.length;i>n;n++){var o=arguments[n];r[n]=o&&o.valueOf()}return t.apply(e,r)},t&&t.transform&&(e[r].transform=t.transform)):e[r]=t,t&&t.transform&&(e.expression.transform[r]=t.transform),e.chaining.Chain.createProxy(r,t))}function n(e){return"function"==typeof e||s(e)||u(e)||c(e)||f(e)}var i=t(171),o=t(7),a=t(11),s=i.number.isNumber,u=i.string.isString,c=o.isComplex,f=a.isUnit;e["import"]=function l(i,o){var a=arguments.length;if(1!=a&&2!=a)throw new e.error.ArgumentsError("import",a,1,2);var s,c={override:o&&o.override||!1,wrap:o&&o.wrap||!1};if(u(i)){var f=t(202)(i);l(f,o)}else{if("object"!=typeof i)throw new TypeError("Object or module name expected");for(s in i)if(i.hasOwnProperty(s)){var p=i[s];n(p)?r(s,p,c):l(p,o)}}}}},function(e,r,t){"use strict";e.exports=function(e){function r(e,r){var t=function(n,i){return Array.isArray(n)?n.map(function(e,r){return t(e,i.concat(r))}):r(n,i,e)};return t(e,[])}var n=t(10);e.map=function(t,i){if(2!=arguments.length)throw new e.error.ArgumentsError("map",arguments.length,2);if(Array.isArray(t))return r(t,i);if(t instanceof n)return t.map(i);throw new e.error.UnsupportedTypeError("map",e["typeof"](t))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(171),n=r.string.isString;e.print=function(r,t,i){var o=arguments.length;if(2!=o&&3!=o)throw new e.error.ArgumentsError("print",o,2,3);if(!n(r))throw new TypeError("String expected as first parameter in function format");if(!(t instanceof Object))throw new TypeError("Object expected as second parameter in function format");return r.replace(/\$([\w\.]+)/g,function(r,o){for(var a=o.split("."),s=t[a.shift()];a.length&&void 0!==s;){var u=a.shift();s=u?s[u]:s+"."}return void 0!==s?n(s)?s:e.format(s,i):r})}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(10);e.sort=function(t,n){var i=null;if(1===arguments.length)i=e.compare;else{if(2!==arguments.length)throw new e.error.ArgumentsError("sort",arguments.length,1,2);if("function"==typeof n)i=n;else if("asc"===n)i=e.compare;else{if("desc"!==n)throw new e.error.UnsupportedTypeError("sort",e["typeof"](t),e["typeof"](n));i=function(r,t){return-e.compare(r,t)}}}if(t instanceof r){var o=t.size();if(o.length>1)throw new Error("Only one dimensional matrices supported");return new r(t.toArray().sort(i))}if(Array.isArray(t))return t.sort(i);throw new e.error.UnsupportedTypeError("sort",e["typeof"](t),e["typeof"](n))}}},function(e,r,t){"use strict";e.exports=function(e){var r=t(334),n=t(7),i=t(10),o=t(11),a=t(9),s=t(8),u=t(12);e["typeof"]=function(t){if(1!=arguments.length)throw new e.error.ArgumentsError("typeof",arguments.length,1);var c=r.type(t);if("object"===c){if(t instanceof n)return"complex";if(t instanceof i)return"matrix";if(t instanceof o)return"unit";if(t instanceof a)return"index";if(t instanceof s)return"range";if(t instanceof u)return"help";if(t instanceof e.type.BigNumber)return"bignumber";if(t instanceof e.chaining.Chain)return"chain"}return c}}},function(e,r,t){"use strict";e.exports=function(e){function r(e,r){var t=function(n,i){Array.isArray(n)?n.forEach(function(e,r){t(e,i.concat(r))}):r(n,i,e)};t(e,[])}var n=t(10);e.forEach=function(t,i){if(2!=arguments.length)throw new e.error.ArgumentsError("forEach",arguments.length,2);if(Array.isArray(t))return r(t,i);if(t instanceof n)return t.forEach(i);throw new e.error.UnsupportedTypeError("forEach",e["typeof"](t))}}},function(e,r,t){"use strict";function n(e,t,n){var o,a,s=e.constructor,u=+(e.s<0),c=+(t.s<0);if(u){o=i(r.not(e));for(var f=0;f<o.length;++f)o[f]^=1}else o=i(e);if(c){a=i(r.not(t));for(var f=0;f<a.length;++f)a[f]^=1}else a=i(t);var l,p,m;o.length<=a.length?(l=o,p=a,m=u):(l=a,p=o,m=c);var h=l.length,g=p.length,d=1^n(u,c),w=new s(1^d),x=s.ONE,v=new s(2),y=s.precision;for(s.config({precision:1e9});h>0;)n(l[--h],p[--g])==d&&(w=w.plus(x)),x=x.times(v);for(;g>0;)n(m,p[--g])==d&&(w=w.plus(x)),x=x.times(v);return s.config({precision:y}),0==d&&(w.s=-w.s),w}function i(e){for(var r=e.c,t=r[0]+"",n=1;n<r.length;++n){for(var i=r[n]+"",o=7-i.length;o--;)i="0"+i;t+=i}var a;for(a=t.length-1;"0"==t.charAt(a);--a);var s=e.e,u=t.slice(0,a+1||1),c=u.length;if(s>0)if(++s>c)for(s-=c;s--;u+="0");else c>s&&(u=u.slice(0,s)+"."+u.slice(s));for(var f=[0],n=0;n<u.length;){for(var l=f.length;l--;f[l]*=10);f[0]+=u.charAt(n++)<<0;for(var a=0;a<f.length;++a)f[a]>1&&(null==f[a+1]&&(f[a+1]=0),f[a+1]+=f[a]>>1,f[a]&=1)}return f.reverse()}function o(e,t){var n=t.precision,i=-(n+4),o=n+8-e.e,a=25-e.e,s=Math.max(1.442695*Math.log(n+2)|5,5);t.config({precision:a});var u=0,c=new t(Math.asin(e.toNumber())+"");do{var l=r.cos_sin_sec_csc(c,t,1,!1),p=f(l);l.isZero()||(l.s=c.s);var m=l.minus(e).div(p);c=c.minus(m),a=Math.min(2*a,o),t.config({precision:a})}while(2*m.e>=i&&!m.isZero()&&++u<=s);if(u==s)throw new Error("asin() failed to converge to the requested accuracy.Try with a higher precision.");return t.config({precision:n}),c.toDP(n-1)}function a(e,r){var t=e.constructor;t.config({precision:r+Math.log(r)|4});for(var n=new t(1),i=e,o=0/0,a=e.times(e),s=e,u=new t(n),c=new t(n),f=new t(n),l=3;!i.equals(o);l+=2)s=s.times(a),u=u.times(f),c=c.times(f.plus(n)),o=i,f=new t(l),i=i.plus(s.times(u).div(f.times(c)));return t.config({precision:r}),i.toDP(r-1)}function s(e){for(var r=e,t=0/0,n=e.times(e),i=e,o=!0,a=3;!r.equals(t);a+=2)i=i.times(n),t=r,o=!o,r=o?r.plus(i.div(a)):r.minus(i.div(a));return r}function u(e,r){for(var t=e.constructor.ONE,n=e,i=0/0,o=e.times(e),a=r?n:n=t,s=t,u=!0,c=r;!n.equals(i);c+=2)a=a.times(o),s=s.times(c+1).times(c+2),i=n,u=!u,n=u?n.plus(a.div(s)):n.minus(a.div(s));return n}function c(e,t,n){var i=r.pi(t+2),o=r.tau(t);if(e.abs().lte(i.toDP(e.dp())))return[e,!1];var a=e.constructor;if(e.div(i.toDP(e.dp())).toNumber()%2==0)return[new a(1^n),!0];var s=e.mod(o);return s.toDP(e.dp(),1).isZero()?[new a(1^n),!0]:(s.gt(i)&&(n?(s=s.minus(i),s.s=-s.s):s=o.minus(s)),s.constructor=a,[s,!1])}function f(e){var r=e.constructor,t=r.precision;r.config({precision:t+2});var n=r.ONE.minus(e.times(e)).sqrt();return r.config({precision:t}),n.toDP(t-1)}var l=t(5),p=t(3).isNumber,m=(t(3).digits,t(335).memoize);r.isBigNumber=function(e){return e instanceof l},r.e=m(function(e){var r=l.constructor({precision:e});return new r(1).exp()}),r.phi=m(function(e){var r=l.constructor({precision:e});return new r(1).plus(new r(5).sqrt()).div(2)}),r.pi=m(function(e){var r=l.constructor({precision:e+4}),t=new r(4).times(s(new r(1).div(5))).minus(s(new r(1).div(239)));return r.config({precision:e}),new r(4).times(t)}),r.tau=m(function(e){var t=r.pi(e+2),n=l.constructor({precision:e});return new n(2).times(t)}),r.and=function(e,r){if(e.isFinite()&&!e.isInteger()||r.isFinite()&&!r.isInteger())throw new Error("Parameters in function bitAnd must be integer numbers");var t=e.constructor;if(e.isNaN()||r.isNaN())return new t(0/0);if(e.isZero()||r.eq(-1)||e.eq(r))return e;if(r.isZero()||e.eq(-1))return r;if(!e.isFinite()||!r.isFinite()){if(!e.isFinite()&&!r.isFinite())return e.isNegative()==r.isNegtive()?e:new t(0);if(!e.isFinite())return r.isNegative()?e:e.isNegative()?new t(0):r;if(!r.isFinite())return e.isNegative()?r:r.isNegative()?new t(0):e}return n(e,r,function(e,r){return e&r})},r.leftShift=function(e,r){if(e.isFinite()&&!e.isInteger()||r.isFinite()&&!r.isInteger())throw new Error("Parameters in function leftShift must be integer numbers");var t=e.constructor;return e.isNaN()||r.isNaN()||r.isNegative()&&!r.isZero()?new t(0/0):e.isZero()||r.isZero()?e:e.isFinite()||r.isFinite()?e.times(r.lt(55)?Math.pow(2,r.toNumber())+"":new t(2).pow(r)):new t(0/0)},r.not=function(e){if(e.isFinite()&&!e.isInteger())throw new Error("Parameter in function bitNot must be integer numbers");var r=e.constructor,t=r.precision;r.config({precision:1e9});var e=e.plus(r.ONE);return e.s=-e.s||null,r.config({precision:t}),e},r.or=function(e,r){if(e.isFinite()&&!e.isInteger()||r.isFinite()&&!r.isInteger())throw new Error("Parameters in function bitOr must be integer numbers");var t=e.constructor;if(e.isNaN()||r.isNaN())return new t(0/0);var i=new t(-1);return e.isZero()||r.eq(i)||e.eq(r)?r:r.isZero()||e.eq(i)?e:e.isFinite()&&r.isFinite()?n(e,r,function(e,r){return e|r}):!e.isFinite()&&!e.isNegative()&&r.isNegative()||e.isNegative()&&!r.isNegative()&&!r.isFinite()?i:e.isNegative()&&r.isNegative()?e.isFinite()?e:r:e.isFinite()?r:e},r.rightShift=function(e,r){if(e.isFinite()&&!e.isInteger()||r.isFinite()&&!r.isInteger())throw new Error("Parameters in function rightArithShift must be integer numbers");var t=e.constructor;return e.isNaN()||r.isNaN()||r.isNegative()&&!r.isZero()?new t(0/0):e.isZero()||r.isZero()?e:r.isFinite()?r.lt(55)?e.div(Math.pow(2,r.toNumber())+"").floor():e.div(new t(2).pow(r)).floor():new t(e.isNegative()?-1:e.isFinite()?0:0/0)},r.xor=function(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Parameters in function bitXor must be integer numbers");var i=e.constructor;if(e.isNaN()||t.isNaN())return new i(0/0);if(e.isZero())return t;if(t.isZero())return e;if(e.eq(t))return new i(0);var o=new i(-1);return e.eq(o)?r.not(t):t.eq(o)?r.not(e):e.isFinite()&&t.isFinite()?n(e,t,function(e,r){return e^r}):e.isFinite()||t.isFinite()?new i(e.isNegative()==t.isNegative()?1/0:-1/0):o},r.arccos_arcsec=function(e,t,n){var i=t.precision;if(n){if(e.abs().lt(t.ONE))throw new Error("asec() only has non-complex values for |x| >= 1.")}else if(e.abs().gt(t.ONE))throw new Error("acos() only has non-complex values for |x| <= 1.");if(e.eq(-1))return r.pi(i);t.config({precision:i+4}),n&&(e=t.ONE.div(e));var o=r.arctan_arccot(t.ONE.minus(e.times(e)).sqrt().div(e.plus(t.ONE)),t).times(2);return t.config({precision:i}),o.toDP(i-1)},r.arcsin_arccsc=function(e,t,n){if(e.isNaN())return new t(0/0);var i=t.precision,s=e.abs();if(n){if(s.lt(t.ONE))throw new Error("acsc() only has non-complex values for |x| >= 1.");t.config({precision:i+2}),e=t.ONE.div(e),t.config({precision:i}),s=e.abs()}else if(s.gt(t.ONE))throw new Error("asin() only has non-complex values for |x| <= 1.");if(s.gt(.8)){t.config({precision:i+4});var u=e.s,c=r.pi(i+4).div(2);return e=c.minus(r.arcsin_arccsc(t.ONE.minus(e.times(e)).sqrt(),t)),e.s=u,e.constructor=t,t.config({precision:i}),e.toDP(i-1)
}var f=s.gt(.58);f&&(t.config({precision:i+8}),e=e.div(new t(2).sqrt().times(t.ONE.minus(e.times(e)).sqrt().plus(t.ONE).sqrt())),t.config({precision:i}));var l=60>=i||e.dp()<=Math.log(i)&&e.lt(.05)?a(e,i):o(e,t);return f?l.times(2):l},r.arctan_arccot=function(e,t,n){if(e.isNaN())return new t(0/0);if(!n&&e.isZero()||n&&!e.isFinite())return new t(0);var i=t.precision;if(!n&&!e.isFinite()||n&&e.isZero()){var o=r.pi(i+2).div(2).toDP(i-1);return o.s=e.s,o}t.config({precision:i+4}),n&&(e=t.ONE.div(e));var a=e.abs();if(a.lte(.875)){var u=s(e);return u.constructor=t,t.config({precision:i}),u.toDP(t.precision-1)}if(a.gte(1.143)){var o=r.pi(i+4).div(2),u=o.minus(s(t.ONE.div(a)));return u.s=e.s,u.constructor=t,t.config({precision:i}),u.toDP(t.precision-1)}return e=e.div(e.times(e).plus(1).sqrt()),t.config({precision:i}),r.arcsin_arccsc(e,t)},r.acosh_asinh_asech_acsch=function(e,r,t,n){if(e.isNaN())return new r(0/0);if(n&&e.isZero())return new r(1/0);if(!t)if(n){if(e.isNegative()||e.gt(r.ONE))throw new Error("asech() only has non-complex values for 0 <= x <= 1.")}else if(e.lt(r.ONE))throw new Error("acosh() only has non-complex values for x >= 1.");var i=r.precision;r.config({precision:i+4});var o=new r(e);o.constructor=r,n&&(o=r.ONE.div(o));var a=t?o.times(o).plus(r.ONE):o.times(o).minus(r.ONE),s=o.plus(a.sqrt()).ln();return r.config({precision:i}),new r(s.toPrecision(i))},r.atanh_acoth=function(e,r,t){if(e.isNaN())return new r(0/0);var n=e.abs();if(n.eq(r.ONE))return new r(e.isNegative()?-1/0:1/0);if(n.gt(r.ONE)){if(!t)throw new Error("atanh() only has non-complex values for |x| <= 1.")}else if(t)throw new Error("acoth() has complex values for |x| < 1.");if(e.isZero())return new r(0);var i=r.precision;r.config({precision:i+4});var o=new r(e);o.constructor=r,t&&(o=r.ONE.div(o));var a=r.ONE.plus(o).div(r.ONE.minus(o)).ln().div(2);return r.config({precision:i}),new r(a.toPrecision(i))},r.cos_sin_sec_csc=function(e,r,t,n){if(e.isNaN()||!e.isFinite())return new r(0/0);var i=r.precision,o=new r(e),a=o.isNegative();a&&(o.s=-o.s);var s=i+(0|Math.log(i))+3;if(r.config({precision:s}),o=c(o,s,t),o[0].constructor=r,o[1])return o=o[0],n&&o.isZero()&&(o=new r(1/0)),r.config({precision:i}),o;var f;if(o=o[0],t){f=u(o.div(3125),t),r.config({precision:Math.min(s,i+15)});for(var l=new r(5),p=new r(16),m=new r(20),h=0;5>h;++h){var g=f.times(f),d=g.times(f),w=d.times(g);f=p.times(w).minus(m.times(d)).plus(l.times(f))}a&&(f.s=-f.s)}else{var x,v;o.abs().lt(r.ONE)?(x=64,v=3):(x=256,v=4),f=u(o.div(x),t),r.config({precision:Math.min(s,i+8)});for(var y=new r(8);v>0;--v){var g=f.times(f),b=g.times(g);f=y.times(b.minus(g)).plus(r.ONE)}}return n&&(f=f.e<=-i?new r(1/0):r.ONE.div(f)),r.config({precision:i}),f.toDP(i-1)},r.tan_cot=function(e,t,n){if(e.isNaN())return new t(0/0);var i=t.precision,o=r.pi(i+2),a=o.div(2).toDP(i-1);o=o.toDP(i-1);var s=c(e,i,1)[0];if(s.abs().eq(o))return new t(1/0);t.config({precision:i+2});var u=r.cos_sin_sec_csc(s,t,1,!1),l=f(u);u=u.toDP(i),l=l.toDP(i),s.eq(e)?s.gt(a)&&(l.s=-l.s):o.minus(s.abs()).gt(a)&&(l.s=-l.s);var p=n?l.div(u):u.div(l);return t.config({precision:i}),new t(p.toPrecision(i))},r.cosh_sinh_csch_sech=function(e,r,t,n){if(e.isNaN())return new r(0/0);if(!e.isFinite())return new r(n?0:t?e:1/0);var i=r.precision;r.config({precision:i+4});var o=new r(e);return o.constructor=r,o=o.exp(),o=t?o.minus(r.ONE.div(o)):o.plus(r.ONE.div(o)),o=n?new r(2).div(o):o.div(2),r.config({precision:i}),new r(o.toPrecision(i))},r.tanh_coth=function(e,r,t){if(e.isNaN())return new r(0/0);if(!e.isFinite())return new r(e.s);var n=r.precision;r.config({precision:n+4});var i=new r(e);i.constructor=r;var o=i.exp(),a=r.ONE.div(o),s=o.minus(a);return s=t?o.plus(a).div(s):s.div(o.plus(a)),r.config({precision:n}),s.toDP(n-1)},r.format=function(e,t){if("function"==typeof t)return t(e);if(!e.isFinite())return e.isNaN()?"NaN":e.gt(0)?"Infinity":"-Infinity";var n="auto",i=void 0;switch(void 0!==t&&(t.notation&&(n=t.notation),p(t)?i=t:t.precision&&(i=t.precision)),n){case"fixed":return r.toFixed(e,i);case"exponential":return r.toExponential(e,i);case"auto":var o=.001,a=1e5;t&&t.exponential&&(void 0!==t.exponential.lower&&(o=t.exponential.lower),void 0!==t.exponential.upper&&(a=t.exponential.upper));{({toExpNeg:e.constructor.toExpNeg,toExpPos:e.constructor.toExpPos})}if(e.constructor.config({toExpNeg:Math.round(Math.log(o)/Math.LN10),toExpPos:Math.round(Math.log(a)/Math.LN10)}),e.isZero())return"0";var s,u=e.abs();return s=u.gte(o)&&u.lt(a)?e.toSignificantDigits(i).toFixed():r.toExponential(e,i),s.replace(/((\.\d*?)(0+))($|e)/,function(){var e=arguments[2],r=arguments[4];return"."!==e?e+r:r});default:throw new Error('Unknown notation "'+n+'". Choose "auto", "exponential", or "fixed".')}},r.toExponential=function(e,r){return void 0!==r?e.toExponential(r-1):e.toExponential()},r.toFixed=function(e,r){return e.toFixed(r||0)}},function(e,r,t){"use strict";function n(e){for(var r=[];m(e);)r.push(e.length),e=e[0];return r}function i(e,r,t){var n,o=e.length;if(o!=r[t])throw new l(o,r[t]);if(t<r.length-1){var a=t+1;for(n=0;o>n;n++){var s=e[n];if(!m(s))throw new l(r.length-1,r.length,"<");i(e[n],r,a)}}else for(n=0;o>n;n++)if(m(e[n]))throw new l(r.length+1,r.length,">")}function o(e,t,n,i){var a,s,u=e.length,c=t[n],l=Math.min(u,c);if(e.length=c,n<t.length-1){var p=n+1;for(a=0;l>a;a++)s=e[a],m(s)||(s=[s],e[a]=s),o(s,t,p,i);for(a=l;c>a;a++)s=[],e[a]=s,o(s,t,p,i)}else{for(a=0;l>a;a++)for(;m(e[a]);)e[a]=e[a][0];if(i!==r.UNINITIALIZED)for(a=l;c>a;a++)e[a]=f.clone(i)}}function a(e,r,t){var n,i;if(r>t){var o=t+1;for(n=0,i=e.length;i>n;n++)e[n]=a(e[n],r,o)}else for(;m(e);)e=e[0];return e}function s(e,r,t){var n,i;if(m(e)){var o=t+1;for(n=0,i=e.length;i>n;n++)e[n]=s(e[n],r,o)}else for(var a=t;r>a;a++)e=[e];return e}var u=t(3),c=t(205),f=t(2),l=(t(334),t(168)),p=t(169),m=Array.isArray;r.size=function(e){var t=n(e);return r.validate(e,t),t},r.validate=function(e,r){var t=0==r.length;if(t){if(m(e))throw new l(e.length,0)}else i(e,r,0)},r.validateIndex=function(e,r){if(!u.isNumber(e)||!u.isInteger(e))throw new TypeError("Index must be an integer (value: "+e+")");if(0>e)throw new p(e);if(void 0!==r&&e>=r)throw new p(e,r)},r.UNINITIALIZED={},r.resize=function(e,r,t){if(!m(e)||!m(r))throw new TypeError("Array expected");if(0===r.length)throw new Error("Resizing to scalar is not supported");r.forEach(function(e){if(!u.isNumber(e)||!u.isInteger(e)||0>e)throw new TypeError("Invalid size, must contain positive integers (size: "+c.format(r)+")")});var n=void 0!==t?t:0;return o(e,r,0,n),e},r.squeeze=function(e,t){for(var n=t||r.size(e);m(e)&&1===e.length;)e=e[0],n.shift();for(var i=n.length;1===n[i-1];)i--;return i<n.length&&(e=a(e,i,0),n.length=i),e},r.unsqueeze=function(e,t,n,i){var o=i||r.size(e);if(n)for(var a=0;n>a;a++)e=[e],o.unshift(1);for(e=s(e,t,0);o.length<t;)o.push(1);return e},r.flatten=function(e){for(var r=e,t=Array.isArray;t(r[0]);){for(var n=[],i=0,o=r.length;o>i;i++)n=n.concat.apply(n,r[i]);r=n}return r},r.argsToArray=function(e){for(var r=[],t=0,n=e.length;n>t;t++)r[t]=e[t];return r},r.isArray=m},function(e){e.exports="1.4.0"},function(e){"use strict";function r(e,t,n,i){if(!(this instanceof r))throw new SyntaxError("Constructor must be called with the new operator");this.fn=e,this.count=t,this.min=n,this.max=i,this.message="Wrong number of arguments in function "+e+" ("+t+" provided, "+n+(void 0!=i?"-"+i:"")+" expected)",this.stack=(new Error).stack}r.prototype=new Error,r.prototype.constructor=Error,r.prototype.name="ArgumentsError",e.exports=r},function(e){"use strict";function r(e,t,n){if(!(this instanceof r))throw new SyntaxError("Constructor must be called with the new operator");this.actual=e,this.expected=t,this.relation=n,this.message="Dimension mismatch ("+(Array.isArray(e)?"["+e.join(", ")+"]":e)+" "+(this.relation||"!=")+" "+(Array.isArray(t)?"["+t.join(", ")+"]":t)+")",this.stack=(new Error).stack}r.prototype=new RangeError,r.prototype.constructor=RangeError,r.prototype.name="DimensionError",e.exports=r},function(e){"use strict";function r(e,t,n){if(!(this instanceof r))throw new SyntaxError("Constructor must be called with the new operator");this.index=e,arguments.length<3?(this.min=0,this.max=t):(this.min=t,this.max=n),this.message=void 0!==this.min&&this.index<this.min?"Index out of range ("+this.index+" < "+this.min+")":void 0!==this.max&&this.index>=this.max?"Index out of range ("+this.index+" > "+(this.max-1)+")":"Index out of range ("+this.index+")",this.stack=(new Error).stack}r.prototype=new RangeError,r.prototype.constructor=RangeError,r.prototype.name="IndexError",e.exports=r},function(e){"use strict";function r(e){if(!(this instanceof r))throw new SyntaxError("Constructor must be called with the new operator");this.fn=e,this.types=Array.prototype.splice.call(arguments,1),this.message=e?0==this.types.length?"Unsupported type of argument in function "+e:"Function "+e+"("+this.types.join(", ")+") not supported":"Unsupported type of argument",this.stack=(new Error).stack}r.prototype=new TypeError,r.prototype.constructor=TypeError,r.prototype.name="UnsupportedTypeError",e.exports=r},function(e,r,t){"use strict";r.array=t(165),r["boolean"]=t(204),r.number=t(3),r.bignumber=t(164),r.object=t(2),r.string=t(205),r.types=t(334)},function(e,r,t){"use strict";function n(e){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(this.nodes=e||[],!a(this.nodes)||!this.nodes.every(s))throw new TypeError("Array containing Nodes expected")}var i=t(180),o=(t(2),t(205)),a=(t(14),t(171),Array.isArray),s=i.isNode;n.prototype=new i,n.prototype.type="ArrayNode",n.prototype._compile=function(e){var r="array"!==e.math.config().matrix,t=this.nodes.map(function(r){return r._compile(e)});return(r?"math.matrix([":"[")+t.join(",")+(r?"])":"]")},n.prototype.forEach=function(e){for(var r=0;r<this.nodes.length;r++){var t=this.nodes[r];e(t,"nodes["+r+"]",this)}},n.prototype.map=function(e){for(var r=[],t=0;t<this.nodes.length;t++)r[t]=this._ifNode(e(this.nodes[t],"nodes["+t+"]",this));return new n(r)},n.prototype.clone=function(){return new n(this.nodes.slice(0))},n.prototype.toString=function(){return o.format(this.nodes)},n.prototype.toTex=function(e){e=e||"bmatrix";var r="\\begin{"+e+"}";return this.nodes.forEach(function(e){r+=e.nodes?e.nodes.map(function(e){return e.toTex()}).join("&"):e.toTex(),r+="\\\\"}),r+="\\end{"+e+"}"},e.exports=n},function(e,r,t){"use strict";function n(e,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(!u(e))throw new TypeError('String expected for parameter "name"');if(!(r instanceof i))throw new TypeError('Node expected for parameter "expr"');if(e in a)throw new Error('Illegal symbol name, "'+e+'" is a reserved keyword');this.name=e,this.expr=r}var i=t(180),o=t(172),a=t(337),s=t(338),u=t(205).isString;n.prototype=new i,n.prototype.type="AssignmentNode",n.prototype._compile=function(e){return'scope["'+this.name+'"] = '+this.expr._compile(e)},n.prototype.forEach=function(e){e(this.expr,"expr",this)},n.prototype.map=function(e){return new n(this.name,this._ifNode(e(this.expr,"expr",this)))},n.prototype.clone=function(){return new n(this.name,this.expr)},n.prototype.toString=function(){return this.name+" = "+this.expr.toString()},n.prototype.toTex=function(){var e;return this.expr instanceof o&&(e=["\\mathbf{","}"]),s.addBraces(s.toSymbol(this.name),e)+"="+s.addBraces(this.expr.toTex())},e.exports=n},function(e,r,t){"use strict";function n(e){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(!Array.isArray(e))throw new Error("Array expected");this.blocks=e.map(function(e){var r=e&&e.node,t=e&&void 0!==e.visible?e.visible:!0;if(!(r instanceof i))throw new TypeError('Property "node" must be a Node');if(!a(t))throw new TypeError('Property "visible" must be a boolean');return{node:r,visible:t}})}var i=t(180),o=t(13),a=t(204).isBoolean;n.prototype=new i,n.prototype.type="BlockNode",n.prototype._compile=function(e){e.ResultSet=o;var r=this.blocks.map(function(r){var t=r.node._compile(e);return r.visible?"results.push("+t+");":t+";"});return"(function () {var results = [];"+r.join("")+"return new ResultSet(results);})()"},n.prototype.forEach=function(e){for(var r=0;r<this.blocks.length;r++)e(this.blocks[r].node,"blocks["+r+"].node",this)},n.prototype.map=function(e){for(var r=[],t=0;t<this.blocks.length;t++){var i=this.blocks[t],o=this._ifNode(e(i.node,"blocks["+t+"].node",this));r[t]={node:o,visible:i.visible}}return new n(r)},n.prototype.clone=function(){var e=this.blocks.map(function(e){return{node:e.node,visible:e.visible}});return new n(e)},n.prototype.toString=function(){return this.blocks.map(function(e){return e.node.toString()+(e.visible?"":";")}).join("\n")},n.prototype.toTex=function(){return this.blocks.map(function(e){return e.node.toTex()+(e.visible?"":";")}).join("\n")},e.exports=n},function(e,r,t){"use strict";function n(e,r,t){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(!(e instanceof i))throw new TypeError("Parameter condition must be a Node");if(!(r instanceof i))throw new TypeError("Parameter trueExpr must be a Node");if(!(t instanceof i))throw new TypeError("Parameter falseExpr must be a Node");this.condition=e,this.trueExpr=r,this.falseExpr=t}var i=t(180),o=t(338),a=t(5),s=t(7),u=t(11),c=t(171),f=c.string.isString,l=c.number.isNumber,p=c["boolean"].isBoolean;n.prototype=new i,n.prototype.type="ConditionalNode",n.prototype._compile=function(e){return e.testCondition=function(r){if(l(r)||p(r)||f(r))return r?!0:!1;if(r instanceof a)return r.isZero()?!1:!0;if(r instanceof s)return r.re||r.im?!0:!1;if(r instanceof u)return r.value?!0:!1;if(null===r||void 0===r)return!1;throw new TypeError('Unsupported type of condition "'+e.math["typeof"](r)+'"')},"testCondition("+this.condition._compile(e)+") ? ( "+this.trueExpr._compile(e)+") : ( "+this.falseExpr._compile(e)+")"},n.prototype.forEach=function(e){e(this.condition,"condition",this),e(this.trueExpr,"trueExpr",this),e(this.falseExpr,"falseExpr",this)},n.prototype.map=function(e){return new n(this._ifNode(e(this.condition,"condition",this)),this._ifNode(e(this.trueExpr,"trueExpr",this)),this._ifNode(e(this.falseExpr,"falseExpr",this)))},n.prototype.clone=function(){return new n(this.condition,this.trueExpr,this.falseExpr)},n.prototype.toString=function(){return"("+this.condition.toString()+") ? ("+this.trueExpr.toString()+") : ("+this.falseExpr.toString()+")"},n.prototype.toTex=function(){var e=o.addBraces(this.trueExpr.toTex())+", &\\quad"+o.addBraces("\\text{if}\\;"+this.condition.toTex())+"\\\\"+(o.addBraces(this.falseExpr.toTex())+", &\\quad"+o.addBraces("\\text{otherwise}"));return o.addBraces(e,["\\left\\{\\begin{array}{l l}","\\end{array}\\right."])},e.exports=n},function(e,r,t){"use strict";function n(e,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(r){if(!a(r))throw new TypeError('String expected for parameter "valueType"');if(!a(e))throw new TypeError('String expected for parameter "value"');this.value=e,this.valueType=r}else this.value=e+"",this.valueType=o(e);if(!s[this.valueType])throw new TypeError('Unsupported type of value "'+this.valueType+'"')}var i=t(180),o=(t(5),t(334).type),a=t(205).isString,s={number:!0,string:!0,"boolean":!0,undefined:!0,"null":!0};n.prototype=new i,n.prototype.type="ConstantNode",n.prototype._compile=function(e){switch(this.valueType){case"number":return"bignumber"===e.math.config().number?'math.bignumber("'+this.value+'")':this.value.replace(/^(0*)[0-9]/,function(e,r){return e.substring(r.length)});case"string":return'"'+this.value+'"';case"boolean":return this.value;case"undefined":return this.value;case"null":return this.value;default:throw new TypeError('Unsupported type of constant "'+this.valueType+'"')}},n.prototype.forEach=function(){},n.prototype.map=function(){return this.clone()},n.prototype.clone=function(){return new n(this.value,this.valueType)},n.prototype.toString=function(){switch(this.valueType){case"string":return'"'+this.value+'"';default:return this.value}},n.prototype.toTex=function(){var e,r=this.value;switch(this.valueType){case"string":return"\\text{"+r+"}";case"number":return e=r.toLowerCase().indexOf("e"),-1!==e?r.substring(0,e)+" \\cdot 10^{"+r.substring(e+1)+"}":r;default:return r}},e.exports=n},function(e,r,t){"use strict";function n(e,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(!(e instanceof i))throw new TypeError('Node expected for parameter "object"');if(!f(r)||!r.every(c))throw new TypeError('Array containing Nodes expected for parameter "ranges"');this.object=e,this.ranges=r}var i=t(180),o=t(182),a=t(183),s=t(5),u=t(8),c=i.isNode,f=Array.isArray;n.prototype=new i,n.prototype.type="IndexNode",n.prototype._compile=function(e){return this.compileSubset(e)},n.prototype.compileSubset=function(e,r){function t(e){return e instanceof a&&"end"==e.name}var n=!1,i=this.ranges.map(function(e){var r=e.filter(t).length>0;return n=r?r:n,r});e.range=function(e,r,t){return new u(e instanceof s?e.toNumber():e,r instanceof s?r.toNumber():r,t instanceof s?t.toNumber():t)};var c=this.ranges.map(function(r,t){var n=i[t];return r instanceof o?n?'(function (scope) {  scope = Object.create(scope);   scope["end"] = size['+t+"];  return range(    "+r.start._compile(e)+",     "+r.end._compile(e)+",     "+(r.step?r.step._compile(e):"1")+"  );})(scope)":"range("+r.start._compile(e)+", "+r.end._compile(e)+", "+(r.step?r.step._compile(e):"1")+")":n?'(function (scope) {  scope = Object.create(scope);   scope["end"] = size['+t+"];  return "+r._compile(e)+";})(scope)":r._compile(e)});return n?"(function () {  var obj = "+this.object._compile(e)+";  var size = math.size(obj).valueOf();  return math.subset(    obj,     math.index("+c.join(", ")+")    "+(r?", "+r:"")+"  );})()":"math.subset("+this.object._compile(e)+",math.index("+c.join(", ")+")"+(r?", "+r:"")+")"},n.prototype.forEach=function(e){e(this.object,"object",this);for(var r=0;r<this.ranges.length;r++)e(this.ranges[r],"ranges["+r+"]",this)},n.prototype.map=function(e){for(var r=this._ifNode(e(this.object,"object",this)),t=[],i=0;i<this.ranges.length;i++)t[i]=this._ifNode(e(this.ranges[i],"ranges["+i+"]",this));return new n(r,t)},n.prototype.objectName=function(){return this.object.name},n.prototype.clone=function(){return new n(this.object,this.ranges.slice(0))},n.prototype.toString=function(){return this.object.toString()+"["+this.ranges.join(", ")+"]"},n.prototype.toTex=function(){return this.object.toTex()+"["+this.ranges.join(", ")+"]"},e.exports=n},function(e,r,t){"use strict";function n(e,r,t){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(!s(e))throw new TypeError('String expected for parameter "name"');if(!u(r)||!r.every(s))throw new TypeError('Array containing strings expected for parameter "params"');if(!(t instanceof i))throw new TypeError('Node expected for parameter "expr"');if(e in o)throw new Error('Illegal function name, "'+e+'" is a reserved keyword');this.name=e,this.params=r,this.expr=t}var i=t(180),o=t(337),a=t(338),s=t(205).isString,u=Array.isArray;n.prototype=new i,n.prototype.type="FunctionAssignmentNode",n.prototype._compile=function(e){return'scope["'+this.name+'"] =   (function (scope) {    scope = Object.create(scope);     var fn = function '+this.name+"("+this.params.join(",")+") {      if (arguments.length != "+this.params.length+') {        throw new SyntaxError("Wrong number of arguments in function '+this.name+' (" + arguments.length + " provided, '+this.params.length+' expected)");      }'+this.params.map(function(e,r){return'scope["'+e+'"] = arguments['+r+"];"}).join("")+"      return "+this.expr._compile(e)+'    };    fn.syntax = "'+this.name+"("+this.params.join(", ")+')";    return fn;  })(scope);'},n.prototype.forEach=function(e){e(this.expr,"expr",this)},n.prototype.map=function(e){var r=this._ifNode(e(this.expr,"expr",this));return new n(this.name,this.params.slice(0),r)},n.prototype.clone=function(){return new n(this.name,this.params.slice(0),this.expr)},n.prototype.toString=function(){return"function "+this.name+"("+this.params.join(", ")+") = "+this.expr.toString()},n.prototype.toTex=function(){return this.name+a.addBraces(this.params.map(a.toSymbol).join(", "),!0)+"="+a.addBraces(this.expr.toTex())},e.exports=n},function(e,r,t){"use strict";function n(e,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if("string"!=typeof e)throw new TypeError('string expected for parameter "name"');if(!u(r)||!r.every(s))throw new TypeError('Array containing Nodes expected for parameter "args"');this.name=e,this.args=r||[]}var i=t(180),o=t(183),a=t(338),s=i.isNode,u=Array.isArray;n.prototype=new i,n.prototype.type="FunctionNode",n.prototype._compile=function(e){var r=e.math[this.name],t="function"==typeof r&&1==r.rawArgs,n=this.args.map(function(r){return r._compile(e)});if(t){var i;do i="p"+Math.round(1e4*Math.random());while(i in e);return e[i]=this.args,'("'+this.name+'" in scope ? scope["'+this.name+'"]('+n.join(", ")+') : math["'+this.name+'"]('+i+", math, scope))"}var a=new o(this.name);return a._compile(e)+"("+n.join(", ")+")"},n.prototype.forEach=function(e){for(var r=0;r<this.args.length;r++)e(this.args[r],"args["+r+"]",this)},n.prototype.map=function(e){for(var r=[],t=0;t<this.args.length;t++)r[t]=this._ifNode(e(this.args[t],"args["+t+"]",this));return new n(this.name,r)},n.prototype.clone=function(){return new n(this.name,this.args.slice(0))},n.prototype.toString=function(){return this.name+"("+this.args.join(", ")+")"},n.prototype.toTex=function(){return a.toArgs(this)},e.exports=n},function(e,r,t){"use strict";function n(){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator")}function i(e){for(var r in e)if(e.hasOwnProperty(r)&&r in a)throw new Error('Scope contains an illegal symbol, "'+r+'" is a reserved keyword')}function o(e){var r=Object.create(e);if(e.expression&&e.expression.transform)for(var t in e.expression.transform)e.expression.transform.hasOwnProperty(t)&&(r[t]=e.expression.transform[t]);return r}var a=t(337);n.prototype.eval=function(){throw new Error("Node.eval is deprecated. Use Node.compile(math).eval([scope]) instead.")},n.prototype.type="Node",n.prototype.compile=function(e){if(!(e instanceof Object))throw new TypeError("Object expected for parameter math");var r={math:o(e),_validateScope:i},t=this._compile(r),n=Object.keys(r).map(function(e){return"    var "+e+' = defs["'+e+'"];'}),a=n.join(" ")+'return {  "eval": function (scope) {    if (scope) _validateScope(scope);    scope = scope || {};    return '+t+";  }};",s=new Function("defs",a);return s(r)},n.prototype._compile=function(){throw new Error("Cannot compile a Node interface")},n.prototype.forEach=function(){throw new Error("Cannot run forEach on a Node interface")},n.prototype.map=function(){throw new Error("Cannot run map on a Node interface")},n.prototype._ifNode=function(e){if(!(e instanceof n))throw new TypeError("Callback function must return a Node");return e},n.prototype.traverse=function(e){function r(e,t){e.forEach(function(e,n,i){t(e,n,i),r(e,t)})}e(this,null,null),r(this,e)},n.prototype.transform=function(e){function r(e,t){return e.map(function(e,n,i){var o=t(e,n,i);return o!==e?o:r(e,t)})}var t=e(this,null,null);return t!==this?t:r(this,e)},n.prototype.filter=function(e){var r=[];return this.traverse(function(t,n,i){e(t,n,i)&&r.push(t)}),r},n.prototype.find=function(){throw new Error("Function Node.find is deprecated. Use Node.filter instead.")},n.prototype.match=function(){throw new Error("Function Node.match is deprecated. See functions Node.filter, Node.transform, Node.traverse.")},n.prototype.clone=function(){throw new Error("Cannot clone a Node interface")},n.prototype.toString=function(){return""},n.prototype.toTex=function(){return""},n.isNode=function(e){return e instanceof n},e.exports=n},function(e,r,t){"use strict";function n(e,r,t){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");this.op=e,this.fn=r,this.args=t||[]}var i=t(180),o=t(176),a=t(183),s=t(179),u=t(338);n.prototype=new i,n.prototype.type="OperatorNode",n.prototype._compile=function(e){if(!(this.fn in e.math))throw new Error("Function "+this.fn+' missing in provided namespace "math"');var r=this.args.map(function(r){return r._compile(e)});return"math."+this.fn+"("+r.join(", ")+")"},n.prototype.forEach=function(e){for(var r=0;r<this.args.length;r++)e(this.args[r],"args["+r+"]",this)},n.prototype.map=function(e){for(var r=[],t=0;t<this.args.length;t++)r[t]=this._ifNode(e(this.args[t],"args["+t+"]",this));return new n(this.op,this.fn,r)},n.prototype.clone=function(){return new n(this.op,this.fn,this.args.slice(0))},n.prototype.toString=function(){var e=this.args;switch(e.length){case 1:return"-"==this.op?"-"+e[0].toString():e[0].toString()+this.op;case 2:var r=e[0].toString();e[0]instanceof n&&(r="("+r+")");var t=e[1].toString();return e[1]instanceof n&&(t="("+t+")"),r+" "+this.op+" "+t;default:return this.op+"("+this.args.join(", ")+")"}},n.prototype.toTex=function(){var e=this.args,r=u.toOperator(this.op),t=e[0],i=e[1];switch(e.length){case 1:var c=t.toTex();switch(this.op){case"-":if(t instanceof n&&("-"===t.op||"+"===t.op))return this.op+u.addBraces(c,!0);case"+":return this.op+c;default:return t instanceof n?u.addBraces(c,!0)+this.op:c+this.op}case 2:var f=t.toTex(),l=!1,p=i.toTex(),m=!1,h="",g="";switch(this.op){case"/":h=r,r="";break;case"*":t instanceof n&&("+"===t.op||"-"===t.op)&&(l=!0),i instanceof n&&("+"===i.op||"-"===i.op||"*"===i.op)&&(m=!0),r=(t instanceof o||t instanceof n)&&(i instanceof o||i instanceof n)?" \\cdot ":" \\, ";break;case"-":i instanceof n&&"+"===i.op|"-"===i.op&&(m=!0);break;case"^":t instanceof n||t instanceof s?l=!0:t instanceof a&&(l=null);break;case"to":p=u.toUnit(p,!0)}return f=u.addBraces(f,l),p=u.addBraces(p,m),h+f+r+p+g;default:return r+"("+this.args.map(u.toSymbol).join(", ")+")"}},e.exports=n},function(e,r,t){"use strict";function n(e,r,t){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(!o(e))throw new TypeError("Node expected");if(!o(r))throw new TypeError("Node expected");if(t&&!o(t))throw new TypeError("Node expected");if(arguments.length>3)throw new Error("Too many arguments");this.start=e,this.end=r,this.step=t||null}var i=t(180),o=i.isNode;n.prototype=new i,n.prototype.type="RangeNode",n.prototype._compile=function(e){return"math.range("+this.start._compile(e)+", "+this.end._compile(e)+(this.step?", "+this.step._compile(e):"")+")"},n.prototype.forEach=function(e){e(this.start,"start",this),e(this.end,"end",this),this.step&&e(this.step,"step",this)},n.prototype.map=function(e){return new n(this._ifNode(e(this.start,"start",this)),this._ifNode(e(this.end,"end",this)),this.step&&this._ifNode(e(this.step,"step",this)))},n.prototype.clone=function(){return new n(this.start,this.end,this.step&&this.step)},n.prototype.toString=function(){var e=this.start.toString();return this.step&&(e+=":"+this.step.toString()),e+=":"+this.end.toString()},n.prototype.toTex=function(){var e=this.start.toTex();return this.step&&(e+=":"+this.step.toTex()),e+=":"+this.end.toTex()},e.exports=n},function(e,r,t){"use strict";function n(e){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(!u(e))throw new TypeError('String expected for parameter "name"');this.name=e}function i(e){throw new Error("Undefined symbol "+e)}var o=t(180),a=t(11),s=t(338),u=t(205).isString;n.prototype=new o,n.prototype.type="SymbolNode",n.prototype._compile=function(e){return e.undef=i,e.Unit=a,this.name in e.math?'("'+this.name+'" in scope ? scope["'+this.name+'"] : math["'+this.name+'"])':'("'+this.name+'" in scope ? scope["'+this.name+'"] : '+(a.isValuelessUnit(this.name)?'new Unit(null, "'+this.name+'")':'undef("'+this.name+'")')+")"},n.prototype.forEach=function(){},n.prototype.map=function(){return this.clone()},n.prototype.clone=function(){return new n(this.name)},n.prototype.toString=function(){return this.name},n.prototype.toTex=function(){return s.toSymbol(this.name)},e.exports=n},function(e,r,t){"use strict";function n(e,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");if(!(e instanceof o))throw new TypeError('Expected IndexNode for parameter "index"');if(!(r instanceof i))throw new TypeError('Expected Node for parameter "expr"');this.index=e,this.expr=r}var i=t(180),o=t(177);n.prototype=new i,n.prototype.type="UpdateNode",n.prototype._compile=function(e){return'scope["'+this.index.objectName()+'"] = '+this.index.compileSubset(e,this.expr._compile(e))},n.prototype.forEach=function(e){e(this.index,"index",this),e(this.expr,"expr",this)},n.prototype.map=function(e){return new n(this._ifNode(e(this.index,"index",this)),this._ifNode(e(this.expr,"expr",this)))},n.prototype.clone=function(){return new n(this.index,this.expr)},n.prototype.toString=function(){return this.index.toString()+" = "+this.expr.toString()},n.prototype.toTex=function(){return this.index.toTex()+" = "+this.expr.toTex()},e.exports=n},function(e){e.exports={name:"e",category:"Constants",syntax:["e"],description:"Euler's number, the base of the natural logarithm. Approximately equal to 2.71828",examples:["e","e ^ 2","exp(2)","log(e)"],seealso:["exp"]}},function(e){e.exports={name:"false",category:"Constants",syntax:["false"],description:"Boolean value false",examples:["false"],seealso:["true"]}},function(e){e.exports={name:"i",category:"Constants",syntax:["i"],description:"Imaginary unit, defined as i*i=-1. A complex number is described as a + b*i, where a is the real part, and b is the imaginary part.",examples:["i","i * i","sqrt(-1)"],seealso:[]}},function(e){e.exports={name:"Infinity",category:"Constants",syntax:["Infinity"],description:"Infinity, a number which is larger than the maximum number that can be handled by a floating point number.",examples:["Infinity","1 / 0"],seealso:[]}},function(e){e.exports={name:"LN2",category:"Constants",syntax:["LN2"],description:"Returns the natural logarithm of 2, approximately equal to 0.693",examples:["LN2","log(2)"],seealso:[]}},function(e){e.exports={name:"LN10",category:"Constants",syntax:["LN10"],description:"Returns the natural logarithm of 10, approximately equal to 2.302",examples:["LN10","log(10)"],seealso:[]}},function(e){e.exports={name:"LOG2E",category:"Constants",syntax:["LOG2E"],description:"Returns the base-2 logarithm of E, approximately equal to 1.442",examples:["LOG2E","log(e, 2)"],seealso:[]}},function(e){e.exports={name:"LOG10E",category:"Constants",syntax:["LOG10E"],description:"Returns the base-10 logarithm of E, approximately equal to 0.434",examples:["LOG10E","log(e, 10)"],seealso:[]}},function(e){e.exports={name:"NaN",category:"Constants",syntax:["NaN"],description:"Not a number",examples:["NaN","0 / 0"],seealso:[]}},function(e){e.exports={name:"null",category:"Constants",syntax:["null"],description:"Value null",examples:["null"],seealso:["true","false"]}},function(e){e.exports={name:"pi",category:"Constants",syntax:["pi"],description:"The number pi is a mathematical constant that is the ratio of a circle's circumference to its diameter, and is approximately equal to 3.14159",examples:["pi","sin(pi/2)"],seealso:["tau"]}},function(e){e.exports={name:"phi",category:"Constants",syntax:["phi"],description:"Phi is the golden ratio. Two quantities are in the golden ratio if their ratio is the same as the ratio of their sum to the larger of the two quantities. Phi is defined as `(1 + sqrt(5)) / 2` and is approximately 1.618034...",examples:["tau"],seealso:[]}},function(e){e.exports={name:"SQRT1_2",category:"Constants",syntax:["SQRT1_2"],description:"Returns the square root of 1/2, approximately equal to 0.707",examples:["SQRT1_2","sqrt(1/2)"],seealso:[]}
},function(e){e.exports={name:"SQRT2",category:"Constants",syntax:["SQRT2"],description:"Returns the square root of 2, approximately equal to 1.414",examples:["SQRT2","sqrt(2)"],seealso:[]}},function(e){e.exports={name:"tau",category:"Constants",syntax:["tau"],description:"Tau is the ratio constant of a circle's circumference to radius, equal to 2 * pi, approximately 6.2832.",examples:["tau","2 * pi"],seealso:["pi"]}},function(e){e.exports={name:"true",category:"Constants",syntax:["true"],description:"Boolean value true",examples:["true"],seealso:["false"]}},function(e){e.exports={name:"version",category:"Constants",syntax:["version"],description:"A string with the version number of math.js",examples:["version"],seealso:[]}},function(e,r,t){function n(e){return t(i(e))}function i(e){return o[e]||function(){throw new Error("Cannot find module '"+e+"'.")}()}var o={"./clone":155,"./clone.js":155,"./filter":156,"./filter.js":156,"./forEach":163,"./forEach.js":163,"./format":157,"./format.js":157,"./import":158,"./import.js":158,"./map":159,"./map.js":159,"./print":160,"./print.js":160,"./sort":161,"./sort.js":161,"./typeof":162,"./typeof.js":162};n.keys=function(){return Object.keys(o)},n.resolve=i,e.exports=n,n.id=202},function(e,r,t){var n=(t(168),t(169));r.transform=function(e){return e instanceof n?new n(e.index+1,e.min+1,e.max+1):e}},function(e,r){"use strict";r.isBoolean=function(e){return e instanceof Boolean||"boolean"==typeof e}},function(e,r,t){"use strict";function n(e,t){if(Array.isArray(e)){for(var i="[",o=e.length,a=0;o>a;a++)0!=a&&(i+=", "),i+=n(e[a],t);return i+="]"}return r.format(e,t)}var i=t(3),o=t(164),a=t(5);r.isString=function(e){return e instanceof String||"string"==typeof e},r.endsWith=function(e,r){var t=e.length-r.length,n=e.length;return e.substring(t,n)===r},r.format=function(e,t){return i.isNumber(e)?i.format(e,t):e instanceof a?o.format(e,t):Array.isArray(e)?n(e,t):r.isString(e)?'"'+e+'"':"function"==typeof e?e.syntax?e.syntax+"":"function":e instanceof Object?"function"==typeof e.format?e.format(t):e.toString():String(e)}},function(e){e.exports={name:"abs",category:"Arithmetic",syntax:["abs(x)"],description:"Compute the absolute value.",examples:["abs(3.5)","abs(-4.2)"],seealso:["sign"]}},function(e){e.exports={name:"add",category:"Operators",syntax:["x + y","add(x, y)"],description:"Add two values.",examples:["a = 2.1 + 3.6","a - 3.6","3 + 2i",'"hello" + " world"',"3 cm + 2 inch"],seealso:["subtract"]}},function(e){e.exports={name:"ceil",category:"Arithmetic",syntax:["ceil(x)"],description:"Round a value towards plus infinity. If x is complex, both real and imaginary part are rounded towards plus infinity.",examples:["ceil(3.2)","ceil(3.8)","ceil(-4.2)"],seealso:["floor","fix","round"]}},function(e){e.exports={name:"cube",category:"Arithmetic",syntax:["cube(x)"],description:"Compute the cube of a value. The cube of x is x * x * x.",examples:["cube(2)","2^3","2 * 2 * 2"],seealso:["multiply","square","pow"]}},function(e){e.exports={name:"divide",category:"Operators",syntax:["x / y","divide(x, y)"],description:"Divide two values.",examples:["a = 2 / 3","a * 3","4.5 / 2","3 + 4 / 2","(3 + 4) / 2","18 km / 4.5"],seealso:["multiply"]}},function(e){e.exports={name:"dotDivide",category:"Operators",syntax:["x ./ y","dotDivide(x, y)"],description:"Divide two values element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","b = [2, 1, 1; 3, 2, 5]","a ./ b"],seealso:["multiply","dotMultiply","divide"]}},function(e){e.exports={name:"dotMultiply",category:"Operators",syntax:["x .* y","dotMultiply(x, y)"],description:"Multiply two values element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","b = [2, 1, 1; 3, 2, 5]","a .* b"],seealso:["multiply","divide","dotDivide"]}},function(e){e.exports={name:"dotpow",category:"Operators",syntax:["x .^ y","dotpow(x, y)"],description:"Calculates the power of x to y element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","a .^ 2"],seealso:["pow"]}},function(e){e.exports={name:"exp",category:"Arithmetic",syntax:["exp(x)"],description:"Calculate the exponent of a value.",examples:["exp(1.3)","e ^ 1.3","log(exp(1.3))","x = 2.4","(exp(i*x) == cos(x) + i*sin(x))   # Euler's formula"],seealso:["pow","log"]}},function(e){e.exports={name:"fix",category:"Arithmetic",syntax:["fix(x)"],description:"Round a value towards zero. If x is complex, both real and imaginary part are rounded towards zero.",examples:["fix(3.2)","fix(3.8)","fix(-4.2)","fix(-4.8)"],seealso:["ceil","floor","round"]}},function(e){e.exports={name:"floor",category:"Arithmetic",syntax:["floor(x)"],description:"Round a value towards minus infinity.If x is complex, both real and imaginary part are rounded towards minus infinity.",examples:["floor(3.2)","floor(3.8)","floor(-4.2)"],seealso:["ceil","fix","round"]}},function(e){e.exports={name:"gcd",category:"Arithmetic",syntax:["gcd(a, b)","gcd(a, b, c, ...)"],description:"Compute the greatest common divisor.",examples:["gcd(8, 12)","gcd(-4, 6)","gcd(25, 15, -10)"],seealso:["lcm","xgcd"]}},function(e){e.exports={name:"lcm",category:"Arithmetic",syntax:["lcm(x, y)"],description:"Compute the least common multiple.",examples:["lcm(4, 6)","lcm(6, 21)","lcm(6, 21, 5)"],seealso:["gcd"]}},function(e){e.exports={name:"log",category:"Arithmetic",syntax:["log(x)","log(x, base)"],description:"Compute the logarithm of a value. If no base is provided, the natural logarithm of x is calculated. If base if provided, the logarithm is calculated for the specified base. log(x, base) is defined as log(x) / log(base).",examples:["log(3.5)","a = log(2.4)","exp(a)","10 ^ 4","log(10000, 10)","log(10000) / log(10)","b = log(1024, 2)","2 ^ b"],seealso:["exp","log10"]}},function(e){e.exports={name:"log10",category:"Arithmetic",syntax:["log10(x)"],description:"Compute the 10-base logarithm of a value.",examples:["log10(0.00001)","log10(10000)","10 ^ 4","log(10000) / log(10)","log(10000, 10)"],seealso:["exp","log"]}},function(e){e.exports={name:"mod",category:"Operators",syntax:["x % y","x mod y","mod(x, y)"],description:"Calculates the modulus, the remainder of an integer division.",examples:["7 % 3","11 % 2","10 mod 4","function isOdd(x) = x % 2","isOdd(2)","isOdd(3)"],seealso:["divide"]}},function(e){e.exports={name:"multiply",category:"Operators",syntax:["x * y","multiply(x, y)"],description:"multiply two values.",examples:["a = 2.1 * 3.4","a / 3.4","2 * 3 + 4","2 * (3 + 4)","3 * 2.1 km"],seealso:["divide"]}},function(e){e.exports={name:"norm",category:"Arithmetic",syntax:["norm(x)","norm(x, p)"],description:"Calculate the norm of a number, vector or matrix.",examples:["abs(-3.5)","norm(-3.5)","norm(3 - 4i))","norm([1, 2, -3], Infinity)","norm([1, 2, -3], -Infinity)","norm([3, 4], 2)","norm([[1, 2], [3, 4]], 1)","norm([[1, 2], [3, 4]], 'inf')","norm([[1, 2], [3, 4]], 'fro')"]}},function(e){e.exports={name:"nthRoot",category:"Arithmetic",syntax:["nthRoot(a)","nthRoot(a, root)"],description:'Calculate the nth root of a value. The principal nth root of a positive real number A, is the positive real solution of the equation "x^root = A".',examples:["4 ^ 3","nthRoot(64, 3)","nthRoot(9, 2)","sqrt(9)"],seealso:["sqrt","pow"]}},function(e){e.exports={name:"pow",category:"Operators",syntax:["x ^ y","pow(x, y)"],description:"Calculates the power of x to y, x^y.",examples:["2^3 = 8","2*2*2","1 + e ^ (pi * i)"],seealso:["multiply"]}},function(e){e.exports={name:"round",category:"Arithmetic",syntax:["round(x)","round(x, n)"],description:"round a value towards the nearest integer.If x is complex, both real and imaginary part are rounded towards the nearest integer. When n is specified, the value is rounded to n decimals.",examples:["round(3.2)","round(3.8)","round(-4.2)","round(-4.8)","round(pi, 3)","round(123.45678, 2)"],seealso:["ceil","floor","fix"]}},function(e){e.exports={name:"sign",category:"Arithmetic",syntax:["sign(x)"],description:"Compute the sign of a value. The sign of a value x is 1 when x>1, -1 when x<0, and 0 when x=0.",examples:["sign(3.5)","sign(-4.2)","sign(0)"],seealso:["abs"]}},function(e){e.exports={name:"sqrt",category:"Arithmetic",syntax:["sqrt(x)"],description:"Compute the square root value. If x = y * y, then y is the square root of x.",examples:["sqrt(25)","5 * 5","sqrt(-1)"],seealso:["square","multiply"]}},function(e){e.exports={name:"square",category:"Arithmetic",syntax:["square(x)"],description:"Compute the square of a value. The square of x is x * x.",examples:["square(3)","sqrt(9)","3^2","3 * 3"],seealso:["multiply","pow","sqrt","cube"]}},function(e){e.exports={name:"subtract",category:"Operators",syntax:["x - y","subtract(x, y)"],description:"subtract two values.",examples:["a = 5.3 - 2","a + 2","2/3 - 1/6","2 * 3 - 3","2.1 km - 500m"],seealso:["add"]}},function(e){e.exports={name:"unaryMinus",category:"Operators",syntax:["-x","unaryMinus(x)"],description:"Inverse the sign of a value. Converts booleans and strings to numbers.",examples:["-4.5","-(-5.6)",'-"22"'],seealso:["add","subtract","unaryPlus"]}},function(e){e.exports={name:"unaryPlus",category:"Operators",syntax:["+x","unaryPlus(x)"],description:"Converts booleans and strings to numbers.",examples:["+true",'+"2"'],seealso:["add","subtract","unaryMinus"]}},function(e){e.exports={name:"xgcd",category:"Arithmetic",syntax:["xgcd(a, b)"],description:"Calculate the extended greatest common divisor for two values",examples:["xgcd(8, 12)","gcd(8, 12)","xgcd(36163, 21199)"],seealso:["gcd","lcm"]}},function(e){e.exports={name:"bitAnd",category:"Bitwise",syntax:["x & y","bitAnd(x, y)"],description:"Bitwise AND operation. Performs the logical AND operation on each pair of the corresponding bits of the two given values by multiplying them. If both bits in the compared position are 1, the bit in the resulting binary representation is 1, otherwise, the result is 0",examples:["5 & 3","bitAnd(53, 131)","[1, 12, 31] & 42"],seealso:["bitNot","bitOr","bitXor","leftShift","rightArithShift","rightLogShift"]}},function(e){e.exports={name:"bitNot",category:"Bitwise",syntax:["~x","bitNot(x)"],description:"Bitwise NOT operation. Performs a logical negation on each bit of the given value. Bits that are 0 become 1, and those that are 1 become 0.",examples:["~1","~2","bitNot([2, -3, 4])"],seealso:["bitAnd","bitOr","bitXor","leftShift","rightArithShift","rightLogShift"]}},function(e){e.exports={name:"bitOr",category:"Bitwise",syntax:["x | y","bitOr(x, y)"],description:"Bitwise OR operation. Performs the logical inclusive OR operation on each pair of corresponding bits of the two given values. The result in each position is 1 if the first bit is 1 or the second bit is 1 or both bits are 1, otherwise, the result is 0.",examples:["5 | 3","bitOr([1, 2, 3], 4)"],seealso:["bitAnd","bitNot","bitXor","leftShift","rightArithShift","rightLogShift"]}},function(e){e.exports={name:"bitXor",category:"Bitwise",syntax:["bitXor(x, y)"],description:"Bitwise XOR operation, exclusive OR. Performs the logical exclusive OR operation on each pair of corresponding bits of the two given values. The result in each position is 1 if only the first bit is 1 or only the second bit is 1, but will be 0 if both are 0 or both are 1.",examples:["bitOr(1, 2)","bitXor([2, 3, 4], 4)"],seealso:["bitAnd","bitNot","bitOr","leftShift","rightArithShift","rightLogShift"]}},function(e){e.exports={name:"leftShift",category:"Bitwise",syntax:["x << y","leftShift(x, y)"],description:"Bitwise left logical shift of a value x by y number of bits.",examples:["4 << 1","8 >> 1"],seealso:["bitAnd","bitNot","bitOr","bitXor","rightArithShift","rightLogShift"]}},function(e){e.exports={name:"rightArithShift",category:"Bitwise",syntax:["x >> y","leftShift(x, y)"],description:"Bitwise right arithmetic shift of a value x by y number of bits.",examples:["8 >> 1","4 << 1","-12 >> 2"],seealso:["bitAnd","bitNot","bitOr","bitXor","leftShift","rightLogShift"]}},function(e){e.exports={name:"rightLogShift",category:"Bitwise",syntax:["x >> y","leftShift(x, y)"],description:"Bitwise right logical shift of a value x by y number of bits.",examples:["8 >>> 1","4 << 1","-12 >>> 2"],seealso:["bitAnd","bitNot","bitOr","bitXor","leftShift","rightArithShift"]}},function(e){e.exports={name:"arg",category:"Complex",syntax:["arg(x)"],description:"Compute the argument of a complex value. If x = a+bi, the argument is computed as atan2(b, a).",examples:["arg(2 + 2i)","atan2(3, 2)","arg(2 + 3i)"],seealso:["re","im","conj","abs"]}},function(e){e.exports={name:"conj",category:"Complex",syntax:["conj(x)"],description:"Compute the complex conjugate of a complex value. If x = a+bi, the complex conjugate is a-bi.",examples:["conj(2 + 3i)","conj(2 - 3i)","conj(-5.2i)"],seealso:["re","im","abs","arg"]}},function(e){e.exports={name:"re",category:"Complex",syntax:["re(x)"],description:"Get the real part of a complex number.",examples:["re(2 + 3i)","im(2 + 3i)","re(-5.2i)","re(2.4)"],seealso:["im","conj","abs","arg"]}},function(e){e.exports={name:"im",category:"Complex",syntax:["im(x)"],description:"Get the imaginary part of a complex number.",examples:["im(2 + 3i)","re(2 + 3i)","im(-5.2i)","im(2.4)"],seealso:["re","conj","abs","arg"]}},function(e){e.exports={name:"bignumber",category:"Type",syntax:["bignumber(x)"],description:"Create a big number from a number or string.",examples:["0.1 + 0.2","bignumber(0.1) + bignumber(0.2)",'bignumber("7.2")','bignumber("7.2e500")',"bignumber([0.1, 0.2, 0.3])"],seealso:["boolean","complex","index","matrix","string","unit"]}},function(e){e.exports={name:"boolean",category:"Type",syntax:["x","boolean(x)"],description:"Convert a string or number into a boolean.",examples:["boolean(0)","boolean(1)","boolean(3)",'boolean("true")','boolean("false")',"boolean([1, 0, 1, 1])"],seealso:["bignumber","complex","index","matrix","number","string","unit"]}},function(e){e.exports={name:"complex",category:"Type",syntax:["complex()","complex(re, im)","complex(string)"],description:"Create a complex number.",examples:["complex()","complex(2, 3)",'complex("7 - 2i")'],seealso:["bignumber","boolean","index","matrix","number","string","unit"]}},function(e){e.exports={name:"index",category:"Type",syntax:["[start]","[start:end]","[start:step:end]","[start1, start 2, ...]","[start1:end1, start2:end2, ...]","[start1:step1:end1, start2:step2:end2, ...]"],description:"Create an index to get or replace a subset of a matrix",examples:["[]","[1, 2, 3]","A = [1, 2, 3; 4, 5, 6]","A[1, :]","A[1, 2] = 50","A[0:2, 0:2] = ones(2, 2)"],seealso:["bignumber","boolean","complex","matrix,","number","range","string","unit"]}},function(e){e.exports={name:"matrix",category:"Type",syntax:["[]","[a1, b1, ...; a2, b2, ...]","matrix()","matrix([...])"],description:"Create a matrix.",examples:["[]","[1, 2, 3]","[1, 2, 3; 4, 5, 6]","matrix()","matrix([3, 4])"],seealso:["bignumber","boolean","complex","index","number","string","unit"]}},function(e){e.exports={name:"number",category:"Type",syntax:["x","number(x)"],description:"Create a number or convert a string or boolean into a number.",examples:["2","2e3","4.05","number(2)",'number("7.2")',"number(true)","number([true, false, true, true])",'number("52cm", "m")'],seealso:["bignumber","boolean","complex","index","matrix","string","unit"]}},function(e){e.exports={name:"string",category:"Type",syntax:['"text"',"string(x)"],description:"Create a string or convert a value to a string",examples:['"Hello World!"',"string(4.2)","string(3 + 2i)"],seealso:["bignumber","boolean","complex","index","matrix","number","unit"]}},function(e){e.exports={name:"unit",category:"Type",syntax:["value unit","unit(value, unit)","unit(string)"],description:"Create a unit.",examples:["5.5 mm","3 inch",'unit(7.1, "kilogram")','unit("23 deg")'],seealso:["bignumber","boolean","complex","index","matrix","number","string"]}},function(e){e.exports={name:"eval",category:"Expression",syntax:["eval(expression)","eval([expr1, expr2, expr3, ...])"],description:"Evaluate an expression or an array with expressions.",examples:['eval("2 + 3")','eval("sqrt(" + 4 + ")")'],seealso:[]}},function(e){e.exports={name:"help",category:"Expression",syntax:["help(object)","help(string)"],description:"Display documentation on a function or data type.",examples:["help(sqrt)",'help("complex")'],seealso:[]}},function(e){e.exports={name:"and",category:"Logical",syntax:["x and y","and(x, y)"],description:"Logical and. Test whether two values are both defined with a nonzero/nonempty value.",examples:["true and false","true and true","2 and 4"],seealso:["not","or","xor"]}},function(e){e.exports={name:"not",category:"Logical",syntax:["!x","not x","not(x)"],description:"Logical not. Flips the boolean value of given argument.",examples:["!true","not false","!2","!0"],seealso:["and","or","xor"]}},function(e){e.exports={name:"or",category:"Logical",syntax:["x or y","or(x, y)"],description:"Logical or. Test if at least one value is defined with a nonzero/nonempty value.",examples:["true or false","false or false","0 or 4"],seealso:["not","and","xor"]}},function(e){e.exports={name:"xor",category:"Logical",syntax:["x or y","or(x, y)"],description:"Logical exclusive or, xor. Test whether one and only one value is defined with a nonzero/nonempty value.",examples:["true xor false","false xor false","true xor true","0 or 4"],seealso:["not","and","or"]}},function(e){e.exports={name:"concat",category:"Matrix",syntax:["concat(A, B, C, ...)","concat(A, B, C, ..., dim)"],description:"Concatenate matrices. By default, the matrices are concatenated by the last dimension. The dimension on which to concatenate can be provided as last argument.",examples:["A = [1, 2; 5, 6]","B = [3, 4; 7, 8]","concat(A, B)","concat(A, B, 1)","concat(A, B, 2)"],seealso:["det","diag","eye","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e){e.exports={name:"cross",category:"Matrix",syntax:["cross(A, B)"],description:"Calculate the cross product for two vectors in three dimensional space.",examples:["cross([1, 1, 0],  [0, 1, 1])","cross([3, -3, 1], [4, 9, 2])","cross([2, 3, 4],  [5, 6, 7])"],seealso:["multiply","dot"]}},function(e){e.exports={name:"det",category:"Matrix",syntax:["det(x)"],description:"Calculate the determinant of a matrix",examples:["det([1, 2; 3, 4])","det([-2, 2, 3; -1, 1, 3; 2, 0, -1])"],seealso:["concat","diag","eye","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e){e.exports={name:"diag",category:"Matrix",syntax:["diag(x)","diag(x, k)"],description:"Create a diagonal matrix or retrieve the diagonal of a matrix. When x is a vector, a matrix with the vector values on the diagonal will be returned. When x is a matrix, a vector with the diagonal values of the matrix is returned. When k is provided, the k-th diagonal will be filled in or retrieved, if k is positive, the values are placed on the super diagonal. When k is negative, the values are placed on the sub diagonal.",examples:["diag(1:3)","diag(1:3, 1)","a = [1, 2, 3; 4, 5, 6; 7, 8, 9]","diag(a)"],seealso:["concat","det","eye","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e){e.exports={name:"dot",category:"Matrix",syntax:["dot(A, B)"],description:"Calculate the dot product of two vectors. The dot product of A = [a1, a2, a3, ..., an] and B = [b1, b2, b3, ..., bn] is defined as dot(A, B) = a1 * b1 + a2 * b2 + a3 * b3 + ... + an * bn",examples:["dot([2, 4, 1], [2, 2, 3])","[2, 4, 1] * [2, 2, 3]"],seealso:["multiply","cross"]}},function(e){e.exports={name:"eye",category:"Matrix",syntax:["eye(n)","eye(m, n)","eye([m, n])","eye"],description:"Returns the identity matrix with size m-by-n. The matrix has ones on the diagonal and zeros elsewhere.",examples:["eye(3)","eye(3, 5)","a = [1, 2, 3; 4, 5, 6]","eye(size(a))"],seealso:["concat","det","diag","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e){e.exports={name:"flatten",category:"Matrix",syntax:["flatten(x)"],description:"Flatten a multi dimensional matrix into a single dimensional matrix.",examples:["a = [1, 2, 3; 4, 5, 6]","size(a)","b = flatten(a)","size(b)"],seealso:["concat","resize","size","squeeze"]}},function(e){e.exports={name:"inv",category:"Matrix",syntax:["inv(x)"],description:"Calculate the inverse of a matrix",examples:["inv([1, 2; 3, 4])","inv(4)","1 / 4"],seealso:["concat","det","diag","eye","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e){e.exports={name:"ones",category:"Matrix",syntax:["ones(m)","ones(m, n)","ones(m, n, p, ...)","ones([m])","ones([m, n])","ones([m, n, p, ...])","ones"],description:"Create a matrix containing ones.",examples:["ones(3)","ones(3, 5)","ones([2,3]) * 4.5","a = [1, 2, 3; 4, 5, 6]","ones(size(a))"],seealso:["concat","det","diag","eye","inv","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e){e.exports={name:"range",category:"Type",syntax:["start:end","start:step:end","range(start, end)","range(start, end, step)","range(string)"],description:"Create a range. Lower bound of the range is included, upper bound is excluded.",examples:["1:5","3:-1:-3","range(3, 7)","range(0, 12, 2)",'range("4:10")',"a = [1, 2, 3, 4; 5, 6, 7, 8]","a[1:2, 1:2]"],seealso:["concat","det","diag","eye","inv","ones","size","squeeze","subset","trace","transpose","zeros"]}},function(e){e.exports={name:"resize",category:"Matrix",syntax:["resize(x, size)","resize(x, size, defaultValue)"],description:"Resize a matrix.",examples:["resize([1,2,3,4,5], [3])","resize([1,2,3], [5])","resize([1,2,3], [5], -1)","resize(2, [2, 3])",'resize("hello", [8], "!")'],seealso:["size","subset","squeeze"]}},function(e){e.exports={name:"size",category:"Matrix",syntax:["size(x)"],description:"Calculate the size of a matrix.",examples:["size(2.3)",'size("hello world")',"a = [1, 2; 3, 4; 5, 6]","size(a)","size(1:6)"],seealso:["concat","det","diag","eye","inv","ones","range","squeeze","subset","trace","transpose","zeros"]}},function(e){e.exports={name:"squeeze",category:"Matrix",syntax:["squeeze(x)"],description:"Remove inner and outer singleton dimensions from a matrix.",examples:["a = zeros(3,2,1)","size(squeeze(a))","b = zeros(1,1,3)","size(squeeze(b))"],seealso:["concat","det","diag","eye","inv","ones","range","size","subset","trace","transpose","zeros"]}},function(e){e.exports={name:"subset",category:"Matrix",syntax:["value(index)","value(index) = replacement","subset(value, [index])","subset(value, [index], replacement)"],description:"Get or set a subset of a matrix or string. Indexes are one-based. Both the ranges lower-bound and upper-bound are included.",examples:["d = [1, 2; 3, 4]","e = []","e[1, 1:2] = [5, 6]","e[2, :] = [7, 8]","f = d * e","f[2, 1]","f[:, 1]"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","trace","transpose","zeros"]}},function(e){e.exports={name:"trace",category:"Matrix",syntax:["trace(A)"],description:"Calculate the trace of a matrix: the sum of the elements on the main diagonal of a square matrix.",examples:["A = [1, 2, 3; -1, 2, 3; 2, 0, 3]","trace(A)"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","transpose","zeros"]}},function(e){e.exports={name:"transpose",category:"Matrix",syntax:["x'","transpose(x)"],description:"Transpose a matrix",examples:["a = [1, 2, 3; 4, 5, 6]","a'","transpose(a)"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","trace","zeros"]}},function(e){e.exports={name:"zeros",category:"Matrix",syntax:["zeros(m)","zeros(m, n)","zeros(m, n, p, ...)","zeros([m])","zeros([m, n])","zeros([m, n, p, ...])","zeros"],description:"Create a matrix containing zeros.",examples:["zeros(3)","zeros(3, 5)","a = [1, 2, 3; 4, 5, 6]","zeros(size(a))"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","trace","transpose"]}},function(e){e.exports={name:"combinations",category:"Probability",syntax:["combinations(n, k)"],description:"Compute the number of combinations of n items taken k at a time",examples:["combinations(7, 5)"],seealso:["permutations","factorial"]}},function(e){e.exports={name:"factorial",category:"Probability",syntax:["n!","factorial(n)"],description:"Compute the factorial of a value",examples:["5!","5 * 4 * 3 * 2 * 1","3!"],seealso:["combinations","permutations","gamma"]}},function(e){e.exports={name:"gamma",category:"Probability",syntax:["gamma(n)"],description:"Compute the gamma function. For small values, the Lanczos approximation is used, and for large values the extended Stirling approximation.",examples:["gamma(4)","3!","gamma(1/2)","sqrt(pi)"],seealso:["factorial"]}},function(e){e.exports={name:"permutations",category:"Probability",syntax:["permutations(n)","permutations(n, k)"],description:"Compute the number of permutations of n items taken k at a time",examples:["permutations(5)","permutations(5, 3)"],seealso:["combinations","factorial"]}},function(e){e.exports={name:"pickRandom",category:"Probability",syntax:["pickRandom(array)"],description:"Pick a random entry from a given array.",examples:["pickRandom(0:10)","pickRandom([1, 3, 1, 6])"],seealso:["random","randomInt"]}},function(e){e.exports={name:"random",category:"Probability",syntax:["random()","random(max)","random(min, max)","random(size)","random(size, max)","random(size, min, max)"],description:"Return a random number.",examples:["random()","random(10, 20)","random([2, 3])"],seealso:["pickRandom","randomInt"]}},function(e){e.exports={name:"randInt",category:"Probability",syntax:["randInt()","randInt(max)","randInt(min, max)","randInt(size)","randInt(size, max)","randInt(size, min, max)"],description:"Return a random integer number",examples:["randInt()","randInt(10, 20)","randInt([2, 3], 10)"],seealso:["pickRandom","random"]}},function(e){e.exports={name:"compare",category:"Relational",syntax:["compare(x, y)"],description:"Compare two values. Returns 1 if x is larger than y, -1 if x is smaller than y, and 0 if x and y are equal.",examples:["compare(2, 3)","compare(3, 2)","compare(2, 2)","compare(5cm, 40mm)","compare(2, [1, 2, 3])"],seealso:["equal","unequal","smaller","smallerEq","largerEq"]}},function(e){e.exports={name:"deepEqual",category:"Relational",syntax:["deepEqual(x, y)"],description:"Check equality of two matrices element wise. Returns true if the size of both matrices is equal and when and each of the elements are equal.",examples:["[1,3,4] == [1,3,4]","[1,3,4] == [1,3]"],seealso:["equal","unequal","smaller","larger","smallerEq","largerEq","compare"]}},function(e){e.exports={name:"equal",category:"Relational",syntax:["x == y","equal(x, y)"],description:"Check equality of two values. Returns true if the values are equal, and false if not.",examples:["2+2 == 3","2+2 == 4","a = 3.2","b = 6-2.8","a == b","50cm == 0.5m"],seealso:["unequal","smaller","larger","smallerEq","largerEq","compare","deepEqual"]}},function(e){e.exports={name:"larger",category:"Relational",syntax:["x > y","larger(x, y)"],description:"Check if value x is larger than y. Returns true if x is larger than y, and false if not.",examples:["2 > 3","5 > 2*2","a = 3.3","b = 6-2.8","(a > b)","(b < a)","5 cm > 2 inch"],seealso:["equal","unequal","smaller","smallerEq","largerEq","compare"]}},function(e){e.exports={name:"largerEq",category:"Relational",syntax:["x >= y","largerEq(x, y)"],description:"Check if value x is larger or equal to y. Returns true if x is larger or equal to y, and false if not.",examples:["2 > 1+1","2 >= 1+1","a = 3.2","b = 6-2.8","(a > b)"],seealso:["equal","unequal","smallerEq","smaller","largerEq","compare"]}},function(e){e.exports={name:"smaller",category:"Relational",syntax:["x < y","smaller(x, y)"],description:"Check if value x is smaller than value y. Returns true if x is smaller than y, and false if not.",examples:["2 < 3","5 < 2*2","a = 3.3","b = 6-2.8","(a < b)","5 cm < 2 inch"],seealso:["equal","unequal","larger","smallerEq","largerEq","compare"]}},function(e){e.exports={name:"smallerEq",category:"Relational",syntax:["x <= y","smallerEq(x, y)"],description:"Check if value x is smaller or equal to value y. Returns true if x is smaller than y, and false if not.",examples:["2 < 1+1","2 <= 1+1","a = 3.2","b = 6-2.8","(a < b)"],seealso:["equal","unequal","larger","smaller","largerEq","compare"]}},function(e){e.exports={name:"unequal",category:"Relational",syntax:["x != y","unequal(x, y)"],description:"Check unequality of two values. Returns true if the values are unequal, and false if they are equal.",examples:["2+2 != 3","2+2 != 4","a = 3.2","b = 6-2.8","a != b","50cm != 0.5m","5 cm != 2 inch"],seealso:["equal","smaller","larger","smallerEq","largerEq","compare","deepEqual"]}},function(e){e.exports={name:"max",category:"Statistics",syntax:["max(a, b, c, ...)","max(A)","max(A, dim)"],description:"Compute the maximum value of a list of values.",examples:["max(2, 3, 4, 1)","max([2, 3, 4, 1])","max([2, 5; 4, 3])","max([2, 5; 4, 3], 1)","max([2, 5; 4, 3], 2)","max(2.7, 7.1, -4.5, 2.0, 4.1)","min(2.7, 7.1, -4.5, 2.0, 4.1)"],seealso:["mean","median","min","prod","std","sum","var"]}},function(e){e.exports={name:"mean",category:"Statistics",syntax:["mean(a, b, c, ...)","mean(A)","mean(A, dim)"],description:"Compute the arithmetic mean of a list of values.",examples:["mean(2, 3, 4, 1)","mean([2, 3, 4, 1])","mean([2, 5; 4, 3])","mean([2, 5; 4, 3], 1)","mean([2, 5; 4, 3], 2)","mean([1.0, 2.7, 3.2, 4.0])"],seealso:["max","median","min","prod","std","sum","var"]}},function(e){e.exports={name:"median",category:"Statistics",syntax:["median(a, b, c, ...)","median(A)"],description:"Compute the median of all values. The values are sorted and the middle value is returned. In case of an even number of values, the average of the two middle values is returned.",examples:["median(5, 2, 7)","median([3, -1, 5, 7])"],seealso:["max","mean","min","prod","std","sum","var"]}},function(e){e.exports={name:"min",category:"Statistics",syntax:["min(a, b, c, ...)","min(A)","min(A, dim)"],description:"Compute the minimum value of a list of values.",examples:["min(2, 3, 4, 1)","min([2, 3, 4, 1])","min([2, 5; 4, 3])","min([2, 5; 4, 3], 1)","min([2, 5; 4, 3], 2)","min(2.7, 7.1, -4.5, 2.0, 4.1)","max(2.7, 7.1, -4.5, 2.0, 4.1)"],seealso:["max","mean","median","prod","std","sum","var"]}},function(e){e.exports={name:"prod",category:"Statistics",syntax:["prod(a, b, c, ...)","prod(A)"],description:"Compute the product of all values.",examples:["prod(2, 3, 4)","prod([2, 3, 4])","prod([2, 5; 4, 3])"],seealso:["max","mean","min","median","min","std","sum","var"]}},function(e){e.exports={name:"std",category:"Statistics",syntax:["std(a, b, c, ...)","std(A)","std(A, normalization)"],description:'Compute the standard deviation of all values, defined as std(A) = sqrt(var(A)). Optional parameter normalization can be "unbiased" (default), "uncorrected", or "biased".',examples:["std(2, 4, 6)","std([2, 4, 6, 8])",'std([2, 4, 6, 8], "uncorrected")','std([2, 4, 6, 8], "biased")',"std([1, 2, 3; 4, 5, 6])"],seealso:["max","mean","min","median","min","prod","sum","var"]}},function(e){e.exports={name:"sum",category:"Statistics",syntax:["sum(a, b, c, ...)","sum(A)"],description:"Compute the sum of all values.",examples:["sum(2, 3, 4, 1)","sum([2, 3, 4, 1])","sum([2, 5; 4, 3])"],seealso:["max","mean","median","min","prod","std","sum","var"]}},function(e){e.exports={name:"var",category:"Statistics",syntax:["var(a, b, c, ...)","var(A)","var(A, normalization)"],description:'Compute the variance of all values. Optional parameter normalization can be "unbiased" (default), "uncorrected", or "biased".',examples:["var(2, 4, 6)","var([2, 4, 6, 8])",'var([2, 4, 6, 8], "uncorrected")','var([2, 4, 6, 8], "biased")',"var([1, 2, 3; 4, 5, 6])"],seealso:["max","mean","min","median","min","prod","std","sum"]}},function(e){e.exports={name:"acos",category:"Trigonometry",syntax:["acos(x)"],description:"Compute the inverse cosine of a value in radians.",examples:["acos(0.5)","acos(cos(2.3))"],seealso:["cos","atan","asin"]}
},function(e){e.exports={name:"acosh",category:"Trigonometry",syntax:["acosh(x)"],description:"Calculate the hyperbolic arccos of a value, defined as `acosh(x) = ln(sqrt(x^2 - 1) + x)`.",examples:["acosh(1.5)"],seealso:["cosh","asinh","atanh"]}},function(e){e.exports={name:"acot",category:"Trigonometry",syntax:["acot(x)"],description:"Calculate the inverse cotangent of a value.",examples:["acot(0.5)","acot(cot(0.5))","acot(2)"],seealso:["cot","atan"]}},function(e){e.exports={name:"acoth",category:"Trigonometry",syntax:["acoth(x)"],description:"Calculate the hyperbolic arccotangent of a value, defined as `acoth(x) = (ln((x+1)/x) + ln(x/(x-1))) / 2`.",examples:["acoth(0.5)"],seealso:["acsch","asech"]}},function(e){e.exports={name:"acsc",category:"Trigonometry",syntax:["acsc(x)"],description:"Calculate the inverse cotangent of a value.",examples:["acsc(0.5)","acsc(csc(0.5))","acsc(2)"],seealso:["csc","asin","asec"]}},function(e){e.exports={name:"acsch",category:"Trigonometry",syntax:["acsch(x)"],description:"Calculate the hyperbolic arccosecant of a value, defined as `acsch(x) = ln(1/x + sqrt(1/x^2 + 1))`.",examples:["acsch(0.5)"],seealso:["asech","acoth"]}},function(e){e.exports={name:"asec",category:"Trigonometry",syntax:["asec(x)"],description:"Calculate the inverse secant of a value.",examples:["asec(0.5)","asec(sec(0.5))","asec(2)"],seealso:["acos","acot","acsc"]}},function(e){e.exports={name:"asech",category:"Trigonometry",syntax:["asech(x)"],description:"Calculate the inverse secant of a value.",examples:["asech(0.5)"],seealso:["acsch","acoth"]}},function(e){e.exports={name:"asin",category:"Trigonometry",syntax:["asin(x)"],description:"Compute the inverse sine of a value in radians.",examples:["asin(0.5)","asin(sin(2.3))"],seealso:["sin","acos","atan"]}},function(e){e.exports={name:"asinh",category:"Trigonometry",syntax:["asinh(x)"],description:"Calculate the hyperbolic arcsine of a value, defined as `asinh(x) = ln(x + sqrt(x^2 + 1))`.",examples:["asinh(0.5)"],seealso:["acosh","atanh"]}},function(e){e.exports={name:"atan",category:"Trigonometry",syntax:["atan(x)"],description:"Compute the inverse tangent of a value in radians.",examples:["atan(0.5)","atan(tan(2.3))"],seealso:["tan","acos","asin"]}},function(e){e.exports={name:"atanh",category:"Trigonometry",syntax:["atanh(x)"],description:"Calculate the hyperbolic arctangent of a value, defined as `atanh(x) = ln((1 + x)/(1 - x)) / 2`.",examples:["atanh(0.5)"],seealso:["acosh","asinh"]}},function(e){e.exports={name:"atan2",category:"Trigonometry",syntax:["atan2(y, x)"],description:"Computes the principal value of the arc tangent of y/x in radians.",examples:["atan2(2, 2) / pi","angle = 60 deg in rad","x = cos(angle)","y = sin(angle)","atan2(y, x)"],seealso:["sin","cos","tan"]}},function(e){e.exports={name:"cos",category:"Trigonometry",syntax:["cos(x)"],description:"Compute the cosine of x in radians.",examples:["cos(2)","cos(pi / 4) ^ 2","cos(180 deg)","cos(60 deg)","sin(0.2)^2 + cos(0.2)^2"],seealso:["acos","sin","tan"]}},function(e){e.exports={name:"cosh",category:"Trigonometry",syntax:["cosh(x)"],description:"Compute the hyperbolic cosine of x in radians.",examples:["cosh(0.5)"],seealso:["sinh","tanh","coth"]}},function(e){e.exports={name:"cot",category:"Trigonometry",syntax:["cot(x)"],description:"Compute the cotangent of x in radians. Defined as 1/tan(x)",examples:["cot(2)","1 / tan(2)"],seealso:["sec","csc","tan"]}},function(e){e.exports={name:"coth",category:"Trigonometry",syntax:["coth(x)"],description:"Compute the hyperbolic cotangent of x in radians.",examples:["coth(2)","1 / tanh(2)"],seealso:["sech","csch","tanh"]}},function(e){e.exports={name:"csc",category:"Trigonometry",syntax:["csc(x)"],description:"Compute the cosecant of x in radians. Defined as 1/sin(x)",examples:["csc(2)","1 / sin(2)"],seealso:["sec","cot","sin"]}},function(e){e.exports={name:"csch",category:"Trigonometry",syntax:["csch(x)"],description:"Compute the hyperbolic cosecant of x in radians. Defined as 1/sinh(x)",examples:["csch(2)","1 / sinh(2)"],seealso:["sech","coth","sinh"]}},function(e){e.exports={name:"sec",category:"Trigonometry",syntax:["sec(x)"],description:"Compute the secant of x in radians. Defined as 1/cos(x)",examples:["sec(2)","1 / cos(2)"],seealso:["cot","csc","cos"]}},function(e){e.exports={name:"sech",category:"Trigonometry",syntax:["sech(x)"],description:"Compute the hyperbolic secant of x in radians. Defined as 1/cosh(x)",examples:["sech(2)","1 / cosh(2)"],seealso:["coth","csch","cosh"]}},function(e){e.exports={name:"sin",category:"Trigonometry",syntax:["sin(x)"],description:"Compute the sine of x in radians.",examples:["sin(2)","sin(pi / 4) ^ 2","sin(90 deg)","sin(30 deg)","sin(0.2)^2 + cos(0.2)^2"],seealso:["asin","cos","tan"]}},function(e){e.exports={name:"sinh",category:"Trigonometry",syntax:["sinh(x)"],description:"Compute the hyperbolic sine of x in radians.",examples:["sinh(0.5)"],seealso:["cosh","tanh"]}},function(e){e.exports={name:"tan",category:"Trigonometry",syntax:["tan(x)"],description:"Compute the tangent of x in radians.",examples:["tan(0.5)","sin(0.5) / cos(0.5)","tan(pi / 4)","tan(45 deg)"],seealso:["atan","sin","cos"]}},function(e){e.exports={name:"tanh",category:"Trigonometry",syntax:["tanh(x)"],description:"Compute the hyperbolic tangent of x in radians.",examples:["tanh(0.5)","sinh(0.5) / cosh(0.5)"],seealso:["sinh","cosh"]}},function(e){e.exports={name:"to",category:"Units",syntax:["x to unit","to(x, unit)"],description:"Change the unit of a value.",examples:["5 inch to cm","3.2kg to g","16 bytes in bits"],seealso:[]}},function(e){e.exports={name:"clone",category:"Utils",syntax:["clone(x)"],description:"Clone a variable. Creates a copy of primitive variables,and a deep copy of matrices",examples:["clone(3.5)","clone(2 - 4i)","clone(45 deg)","clone([1, 2; 3, 4])",'clone("hello world")'],seealso:[]}},function(e){e.exports={name:"map",category:"Utils",syntax:["map(x, callback)"],description:"Create a new matrix or array with the results of the callback function executed on each entry of the matrix/array.",examples:["map([1, 2, 3], function(val) { return value * value })"],seealso:["filter","forEach"]}},function(e){e.exports={name:"filter",category:"Utils",syntax:["filter(x, test)"],description:"Filter items in a matrix.",examples:["isPositive(x) = x > 0","filter([6, -2, -1, 4, 3], isPositive)","filter([6, -2, 0, 1, 0], x != 0)"],seealso:["sort","map","forEach"]}},function(e){e.exports={name:"forEach",category:"Utils",syntax:["forEach(x, callback)"],description:"Iterates over all elements of a matrix/array, and executes the given callback function.",examples:["forEach([1, 2, 3], function(val) { console.log(val) })"],seealso:["map","sort","filter"]}},function(e){e.exports={name:"format",category:"Utils",syntax:["format(value)","format(value, precision)"],description:"Format a value of any type as string.",examples:["format(2.3)","format(3 - 4i)","format([])","format(pi, 3)"],seealso:["print"]}},function(e){e.exports={name:"import",category:"Utils",syntax:["import(string)"],description:"Import functions from a file.",examples:['import("numbers")','import("./mylib.js")'],seealso:[]}},function(e){e.exports={name:"sort",category:"Utils",syntax:["sort(x)","sort(x, compare)"],description:'Sort the items in a matrix. Compare can be a string "asc" or "desc", or a custom sort function.',examples:["sort([5, 10, 1])",'sort(["C", "B", "A", "D"])',"sortByLength(a, b) = size(a)[1] - size(b)[1]",'sort(["Langdon", "Tom", "Sara"], sortByLength)'],seealso:["map","filter","forEach"]}},function(e){e.exports={name:"typeof",category:"Utils",syntax:["typeof(x)"],description:"Get the type of a variable.",examples:["typeof(3.5)","typeof(2 - 4i)","typeof(45 deg)",'typeof("hello world")'],seealso:[]}},function(e,r,t){"use strict";e.exports=function(e){function r(r){if(!s.hasOwnProperty(r))throw new Error("Unknown distribution "+r);var t=Array.prototype.slice.call(arguments,1),o=s[r].apply(this,t);return function(r){var t={random:function(r,t,i){var s,c,f;if(arguments.length>3)throw new e.error.ArgumentsError("random",arguments.length,0,3);if(1===arguments.length?a(r)?s=r:f=r:2===arguments.length?a(r)?(s=r,f=t):(c=r,f=t):(s=r,c=t,f=i),void 0===f&&(f=1),void 0===c&&(c=0),void 0!==s){var l=u(s.valueOf(),c,f,o);return s instanceof n?new n(l):l}return o(c,f)},randomInt:function(r,t,i){var o,c,f;if(arguments.length>3||arguments.length<1)throw new e.error.ArgumentsError("randomInt",arguments.length,1,3);if(1===arguments.length?a(r)?o=r:f=r:2===arguments.length?a(r)?(o=r,f=t):(c=r,f=t):(o=r,c=t,f=i),void 0===c&&(c=0),void 0!==o){var l=u(o.valueOf(),c,f,s);return o instanceof n?new n(l):l}return s(c,f)},pickRandom:function(r){if(1!==arguments.length)throw new e.error.ArgumentsError("pickRandom",arguments.length,1);if(r instanceof n)r=r.valueOf();else if(!Array.isArray(r))throw new e.error.UnsupportedTypeError("pickRandom",e["typeof"](r));if(i.size(r).length>1)throw new Error("Only one dimensional vectors supported");return r[Math.floor(Math.random()*r.length)]}},o=function(e,t){return e+r()*(t-e)},s=function(e,t){return Math.floor(e+r()*(t-e))},u=function(e,r,t,n){var i,o,a=[];if(e=e.slice(0),e.length>1)for(o=0,i=e.shift();i>o;o++)a.push(u(e,r,t,n));else for(o=0,i=e.shift();i>o;o++)a.push(n(r,t));return a};return t}(o)}var n=t(10),i=t(165),o=t(14),a=o.isCollection,s={uniform:function(){return Math.random},normal:function(){return function(){for(var e,r,t=-1;0>t||t>1;)e=Math.random(),r=Math.random(),t=1/6*Math.pow(-2*Math.log(e),.5)*Math.cos(2*Math.PI*r)+.5;return t}}};return r}},function(e,r){"use strict";r.type=function(e){var r=typeof e;if("object"===r){if(null===e)return"null";if(e instanceof Boolean)return"boolean";if(e instanceof Number)return"number";if(e instanceof String)return"string";if(Array.isArray(e))return"array";if(e instanceof Date)return"date";if(e instanceof Function)return"function";if(e instanceof RegExp)return"regexp"}return r}},function(e,r){r.memoize=function(e){return function r(){"object"!=typeof r.cache&&(r.cache={});var t=JSON.stringify(arguments);return t in r.cache?r.cache[t]:r.cache[t]=e.apply(e,arguments)}}},function(e,r,t){var n;!function(i){"use strict";function o(e){for(var r,t,n=1,i=e.length,o=e[0]+"";i>n;n++){for(r=e[n]+"",t=T-r.length;t--;)r="0"+r;o+=r}for(i=o.length;48===o.charCodeAt(--i););return o.slice(0,i+1||1)}function a(e,r,t,n){var i,o,a,s,u;for(o=1,a=e[0];a>=10;a/=10,o++);return a=r-o,0>a?(a+=T,i=0):(i=Math.ceil((a+1)/T),a%=T),o=N(10,T-a),u=e[i]%o|0,null==n?3>a?(0==a?u=u/100|0:1==a&&(u=u/10|0),s=4>t&&99999==u||t>3&&49999==u||5e4==u||0==u):s=(4>t&&u+1==o||t>3&&u+1==o/2)&&(e[i+1]/o/100|0)==N(10,a-2)-1||(u==o/2||0==u)&&0==(e[i+1]/o/100|0):4>a?(0==a?u=u/1e3|0:1==a?u=u/100|0:2==a&&(u=u/10|0),s=(n||4>t)&&9999==u||!n&&t>3&&4999==u):s=((n||4>t)&&u+1==o||!n&&t>3&&u+1==o/2)&&(e[i+1]/o/1e3|0)==N(10,a-3)-1,s}function s(e,r,t){var n=e.constructor;return null==r||((x=0>r||r>8)||0!==r&&(n.errors?parseInt:parseFloat)(r)!=r)&&!p(n,"rounding mode",r,t,0)?n.rounding:0|r}function u(e,r,t,n){var i=e.constructor;return!(x=(n||0)>r||r>=B+1)&&(0===r||(i.errors?parseInt:parseFloat)(r)==r)||p(i,"argument",r,t,0)}function c(e,r){var t,n,i,s,u,c,f,l=0,p=0,m=0,h=e.constructor,d=h.ONE,w=h.rounding,x=h.precision;if(!e.c||!e.c[0]||e.e>17)return new h(e.c?e.c[0]?e.s<0?0:1/0:d:e.s?e.s<0?0:e:0/0);for(null==r?(y=!1,u=x):u=r,f=new h(.03125);e.e>-2;)e=e.times(f),m+=5;for(n=Math.log(N(2,m))/Math.LN10*2+5|0,u+=n,t=s=c=new h(d),h.precision=u;;){if(s=g(s.times(e),u,1),t=t.times(++p),f=c.plus(_(s,t,u,1)),o(f.c).slice(0,u)===o(c.c).slice(0,u)){for(i=m;i--;)c=g(c.times(c),u,1);if(null!=r)return h.precision=x,c;if(!(3>l&&a(c.c,u-n,w,l)))return g(c,h.precision=x,w,y=!0);h.precision=u+=10,t=s=f=new h(d),p=0,l++}c=f}}function f(e,r,t,n){var i,a,s=e.constructor,u=(e=new s(e)).e;if(null==r?t=0:(g(e,++r,t),t=n?r:r+e.e-u),u=e.e,i=o(e.c),1==n||2==n&&(u>=r||u<=s.toExpNeg)){for(;i.length<t;i+="0");i.length>1&&(i=i.charAt(0)+"."+i.slice(1)),i+=(0>u?"e":"e+")+u}else{if(n=i.length,0>u){for(a=t-n;++u;i="0"+i);i="0."+i}else if(++u>n){for(a=t-u,u-=n;u--;i+="0");a>0&&(i+=".")}else a=t-n,n>u?i=i.slice(0,u)+"."+i.slice(u):a>0&&(i+=".");if(a>0)for(;a--;i+="0");}return e.s<0&&e.c[0]?"-"+i:i}function l(e){var r=e.length-1,t=r*T+1;if(r=e[r]){for(;r%10==0;r/=10,t--);for(r=e[0];r>=10;r/=10,t++);}return t}function p(e,r,t,n,i){if(e.errors){var o=new Error((n||["new Decimal","cmp","div","eq","gt","gte","lt","lte","minus","mod","plus","times","toFraction","pow","random","log","sqrt","toNearest","divToInt"][b?0>b?-b:b:0>1/b?1:0])+"() "+(["number type has more than 15 significant digits","LN10 out of digits"][r]||r+([x?" out of range":" not an integer"," not a boolean or binary digit"][i]||""))+": "+t);throw o.name="Decimal Error",x=b=0,o}}function m(e,r,t){var n=new e(e.ONE);for(y=!1;1&t&&(n=n.times(r)),t>>=1,t;)r=r.times(r);return y=!0,n}function h(e,r){var t,n,i,s,u,c,f,l,m,d,w,x=1,v=10,b=e,E=b.c,N=b.constructor,M=N.ONE,A=N.rounding,T=N.precision;if(b.s<0||!E||!E[0]||!b.e&&1==E[0]&&1==E.length)return new N(E&&!E[0]?-1/0:1!=b.s?0/0:E?0:b);if(null==r?(y=!1,f=T):f=r,N.precision=f+=v,t=o(E),n=t.charAt(0),!(Math.abs(s=b.e)<15e14))return b=new N(n+"."+t.slice(1)),f+2>q.length&&p(N,1,f+2,"ln"),b=h(b,f-v).plus(new N(q.slice(0,f+2)).times(s+"")),N.precision=T,null==r?g(b,T,A,y=!0):b;for(;7>n&&1!=n||1==n&&t.charAt(1)>3;)b=b.times(e),t=o(b.c),n=t.charAt(0),x++;for(s=b.e,n>1?(b=new N("0."+t),s++):b=new N(n+"."+t.slice(1)),d=b,l=u=b=_(b.minus(M),b.plus(M),f,1),w=g(b.times(b),f,1),i=3;;){if(u=g(u.times(w),f,1),m=l.plus(_(u,new N(i),f,1)),o(m.c).slice(0,f)===o(l.c).slice(0,f)){if(l=l.times(2),0!==s&&(f+2>q.length&&p(N,1,f+2,"ln"),l=l.plus(new N(q.slice(0,f+2)).times(s+""))),l=_(l,new N(x),f,1),null!=r)return N.precision=T,l;if(!a(l.c,f-v,A,c))return g(l,N.precision=T,A,y=!0);N.precision=f+=v,m=u=b=_(d.minus(M),d.plus(M),f,1),w=g(b.times(b),f,1),i=c=1}l=m,i+=2}}function g(e,r,t,n){var i,o,a,s,u,c,f,l,p=e.constructor;e:if(null!=r){if(!(f=e.c))return e;for(i=1,s=f[0];s>=10;s/=10,i++);if(o=r-i,0>o)o+=T,a=r,u=f[l=0],c=u/N(10,i-a-1)%10|0;else if(l=Math.ceil((o+1)/T),l>=f.length){if(!n)break e;for(;f.length<=l;f.push(0));u=c=0,i=1,o%=T,a=o-T+1}else{for(u=s=f[l],i=1;s>=10;s/=10,i++);o%=T,a=o-T+i,c=0>a?0:E(u/N(10,i-a-1)%10)}if(n=n||0>r||null!=f[l+1]||(0>a?u:u%N(10,i-a-1)),n=4>t?(c||n)&&(0==t||t==(e.s<0?3:2)):c>5||5==c&&(4==t||n||6==t&&(o>0?a>0?u/N(10,i-a):0:f[l-1])%10&1||t==(e.s<0?8:7)),1>r||!f[0])return f.length=0,n?(r-=e.e+1,f[0]=N(10,r%T),e.e=-r||0):f[0]=e.e=0,e;if(0==o?(f.length=l,s=1,l--):(f.length=l+1,s=N(10,T-o),f[l]=a>0?(u/N(10,i-a)%N(10,a)|0)*s:0),n)for(;;){if(0==l){for(o=1,a=f[0];a>=10;a/=10,o++);for(a=f[0]+=s,s=1;a>=10;a/=10,s++);o!=s&&(e.e++,f[0]==A&&(f[0]=1));break}if(f[l]+=s,f[l]!=A)break;f[l--]=0,s=1}for(o=f.length;0===f[--o];f.pop());}return y&&(e.e>p.maxE?e.c=e.e=null:e.e<p.minE&&(e.c=[e.e=0])),e}var d,w,x,v=i.crypto,y=!0,b=0,E=Math.floor,N=Math.pow,M=Object.prototype.toString,A=1e7,T=7,S="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$_",O={},C=9e15,B=1e9,U=3e3,q="2.3025850929940456840179914546843642076011014886287729760333279009675726096773524802359972050895982983419677840422862486334095254650828067566662873690987816894829072083255546808437998948262331985283935053089653777326288461633662222876982198867465436674744042432743651550489343149393914796194044002221051017141748003688084012647080685567743216228355220114804663715659121373450747856947683463616792101806445070648000277502684916746550586856935673420670581136429224554405758925724208241314695689016758940256776311356919292033376587141660230105703089634572075440370847469940168269282808481184289314848524948644871927809676271275775397027668605952496716674183485704422507197965004714951050492214776567636938662976979522110718264549734772662425709429322582798502585509785265383207606726317164309505995087807523710333101197857547331541421808427543863591778117054309827482385045648019095610299291824318237525357709750539565187697510374970888692180205189339507238539205144634197265287286965110862571492198849978748873771345686209167058";O.absoluteValue=O.abs=function(){var e=new this.constructor(this);return e.s<0&&(e.s=1),g(e)},O.ceil=function(){return g(new this.constructor(this),this.e+1,2)},O.comparedTo=O.cmp=function(e,r){var t,n=this,i=n.c,o=(b=-b,e=new n.constructor(e,r),e.c),a=n.s,s=e.s,u=n.e,c=e.e;if(!a||!s)return null;if(t=i&&!i[0],r=o&&!o[0],t||r)return t?r?0:-s:a;if(a!=s)return a;if(t=0>a,!i||!o)return u==c?0:!i^t?1:-1;if(u!=c)return u>c^t?1:-1;for(a=-1,s=(u=i.length)<(c=o.length)?u:c;++a<s;)if(i[a]!=o[a])return i[a]>o[a]^t?1:-1;return u==c?0:u>c^t?1:-1},O.decimalPlaces=O.dp=function(){var e,r,t=null;if(e=this.c){if(t=((r=e.length-1)-E(this.e/T))*T,r=e[r])for(;r%10==0;r/=10,t--);0>t&&(t=0)}return t},O.dividedBy=O.div=function(e,r){return b=2,_(this,new this.constructor(e,r))},O.dividedToIntegerBy=O.divToInt=function(e,r){var t=this,n=t.constructor;return b=18,g(_(t,new n(e,r),0,1,1),n.precision,n.rounding)},O.equals=O.eq=function(e,r){return b=3,0===this.cmp(e,r)},O.exponential=O.exp=function(){return c(this)},O.floor=function(){return g(new this.constructor(this),this.e+1,3)},O.greaterThan=O.gt=function(e,r){return b=4,this.cmp(e,r)>0},O.greaterThanOrEqualTo=O.gte=function(e,r){return b=5,r=this.cmp(e,r),1==r||0===r},O.isFinite=function(){return!!this.c},O.isInteger=O.isInt=function(){return!!this.c&&E(this.e/T)>this.c.length-2},O.isNaN=function(){return!this.s},O.isNegative=O.isNeg=function(){return this.s<0},O.isZero=function(){return!!this.c&&0==this.c[0]},O.lessThan=O.lt=function(e,r){return b=6,this.cmp(e,r)<0},O.lessThanOrEqualTo=O.lte=function(e,r){return b=7,r=this.cmp(e,r),-1==r||0===r},O.logarithm=O.log=function(e,r){var t,n,i,s,u,c,f,l,m,d=this,w=d.constructor,x=w.precision,v=w.rounding,E=5;if(null==e)e=new w(10),t=!0;else{if(b=15,e=new w(e,r),n=e.c,e.s<0||!n||!n[0]||!e.e&&1==n[0]&&1==n.length)return new w(0/0);t=e.eq(10)}if(n=d.c,d.s<0||!n||!n[0]||!d.e&&1==n[0]&&1==n.length)return new w(n&&!n[0]?-1/0:1!=d.s?0/0:n?0:1/0);if(u=t&&(s=n[0],n.length>1||1!=s&&10!=s&&100!=s&&1e3!=s&&1e4!=s&&1e5!=s&&1e6!=s),y=!1,f=x+E,l=f+10,c=h(d,f),t?(l>q.length&&p(w,1,l,"log"),i=new w(q.slice(0,l))):i=h(e,f),m=_(c,i,f,1),a(m.c,s=x,v))do if(f+=10,c=h(d,f),t?(l=f+10,l>q.length&&p(w,1,l,"log"),i=new w(q.slice(0,l))):i=h(e,f),m=_(c,i,f,1),!u){+o(m.c).slice(s+1,s+15)+1==1e14&&(m=g(m,x+1,0));break}while(a(m.c,s+=10,v));return y=!0,g(m,x,v)},O.minus=function(e,r){var t,n,i,o,a=this,s=a.constructor,u=a.s;if(b=8,e=new s(e,r),r=e.s,!u||!r)return new s(0/0);if(u!=r)return e.s=-r,a.plus(e);var c=a.c,f=e.c,l=E(e.e/T),p=E(a.e/T),m=s.precision,h=s.rounding;if(!p||!l){if(!c||!f)return c?(e.s=-r,e):new s(f?a:0/0);if(!c[0]||!f[0])return a=f[0]?(e.s=-r,e):new s(c[0]?a:3==h?-0:0),y?g(a,m,h):a}if(c=c.slice(),n=c.length,u=p-l){for((o=0>u)?(u=-u,t=c,n=f.length):(l=p,t=f),(p=Math.ceil(m/T))>n&&(n=p),u>(n+=2)&&(u=n,t.length=1),t.reverse(),r=u;r--;t.push(0));t.reverse()}else for((o=n<(i=f.length))&&(i=n),u=r=0;i>r;r++)if(c[r]!=f[r]){o=c[r]<f[r];break}if(o&&(t=c,c=f,f=t,e.s=-e.s),(r=-((i=c.length)-f.length))>0)for(;r--;c[i++]=0);for(p=A-1,r=f.length;r>u;){if(c[--r]<f[r]){for(n=r;n&&!c[--n];c[n]=p);--c[n],c[r]+=A}c[r]-=f[r]}for(;0==c[--i];c.pop());for(;0==c[0];c.shift(),--l);for(c[0]||(c=[l=0],e.s=3==h?-1:1),e.c=c,u=1,r=c[0];r>=10;r/=10,u++);return e.e=u+l*T-1,y?g(e,m,h):e},O.modulo=O.mod=function(e,r){var t,n,i=this,o=i.constructor,a=o.modulo;return b=9,e=new o(e,r),r=e.s,t=!i.c||!r||e.c&&!e.c[0],t||!e.c||i.c&&!i.c[0]?t?new o(0/0):g(new o(i),o.precision,o.rounding):(y=!1,9==a?(e.s=1,n=_(i,e,0,3,1),e.s=r,n.s*=r):n=_(i,e,0,a,1),n=n.times(e),y=!0,i.minus(n))},O.naturalLogarithm=O.ln=function(){return h(this)},O.negated=O.neg=function(){var e=new this.constructor(this);return e.s=-e.s||null,g(e)},O.plus=function(e,r){var t,n=this,i=n.constructor,o=n.s;if(b=10,e=new i(e,r),r=e.s,!o||!r)return new i(0/0);if(o!=r)return e.s=-r,n.minus(e);var a=n.c,s=e.c,u=E(e.e/T),c=E(n.e/T),f=i.precision,l=i.rounding;if(!c||!u){if(!a||!s)return new i(o/0);if(!a[0]||!s[0])return n=s[0]?e:new i(a[0]?n:0*o),y?g(n,f,l):n}if(a=a.slice(),o=c-u){for(0>o?(o=-o,t=a,r=s.length):(u=c,t=s,r=a.length),(c=Math.ceil(f/T))>r&&(r=c),o>++r&&(o=r,t.length=1),t.reverse();o--;t.push(0));t.reverse()}for(a.length-s.length<0&&(t=s,s=a,a=t),o=s.length,r=0,c=A;o;a[o]%=c)r=(a[--o]=a[o]+s[o]+r)/c|0;for(r&&(a.unshift(r),++u),o=a.length;0==a[--o];a.pop());for(e.c=a,o=1,r=a[0];r>=10;r/=10,o++);return e.e=o+u*T-1,y?g(e,f,l):e},O.precision=O.sd=function(e){var r=null,t=this;return e!=r&&e!==!!e&&1!==e&&0!==e&&p(t.constructor,"argument",e,"precision",1),t.c&&(r=l(t.c),e&&t.e+1>r&&(r=t.e+1)),r},O.round=function(){var e=this,r=e.constructor;return g(new r(e),e.e+1,r.rounding)},O.squareRoot=O.sqrt=function(){var e,r,t,n,i,a,s=this,u=s.c,c=s.s,f=s.e,l=s.constructor,p=new l(.5);if(1!==c||!u||!u[0])return new l(!c||0>c&&(!u||u[0])?0/0:u?s:1/0);for(y=!1,c=Math.sqrt(+s),0==c||c==1/0?(r=o(u),(r.length+f)%2==0&&(r+="0"),c=Math.sqrt(r),f=E((f+1)/2)-(0>f||f%2),c==1/0?r="1e"+f:(r=c.toExponential(),r=r.slice(0,r.indexOf("e")+1)+f),n=new l(r)):n=new l(c.toString()),t=(f=l.precision)+3;;)if(a=n,n=p.times(a.plus(_(s,a,t+2,1))),o(a.c).slice(0,t)===(r=o(n.c)).slice(0,t)){if(r=r.slice(t-3,t+1),"9999"!=r&&(i||"4999"!=r)){(!+r||!+r.slice(1)&&"5"==r.charAt(0))&&(g(n,f+1,1),e=!n.times(n).eq(s));break}if(!i&&(g(a,f+1,0),a.times(a).eq(s))){n=a;break}t+=4,i=1}return y=!0,g(n,f,l.rounding,e)},O.times=function(e,r){var t,n,i=this,o=i.constructor,a=i.c,s=(b=11,e=new o(e,r),e.c),u=E(i.e/T),c=E(e.e/T),f=i.s;if(r=e.s,e.s=f==r?1:-1,!((u||a&&a[0])&&(c||s&&s[0])))return new o(!f||!r||a&&!a[0]&&!s||s&&!s[0]&&!a?0/0:a&&s?0*e.s:e.s/0);for(n=u+c,f=a.length,r=s.length,r>f&&(t=a,a=s,s=t,c=f,f=r,r=c),c=f+r,t=[];c--;t.push(0));for(u=r-1;u>-1;u--){for(r=0,c=f+u;c>u;)r=t[c]+s[u]*a[c-u-1]+r,t[c--]=r%A|0,r=r/A|0;t[c]=(t[c]+r)%A|0}for(r?++n:t[0]||t.shift(),c=t.length;!t[--c];t.pop());for(e.c=t,f=1,r=t[0];r>=10;r/=10,f++);return e.e=f+n*T-1,y?g(e,o.precision,o.rounding):e},O.toDecimalPlaces=O.toDP=function(e,r){var t=this;return t=new t.constructor(t),null!=e&&u(t,e,"toDP")?g(t,(0|e)+t.e+1,s(t,r,"toDP")):t},O.toExponential=function(e,r){var t=this;return t.c?f(t,null!=e&&u(t,e,"toExponential")?0|e:null,null!=e&&s(t,r,"toExponential"),1):t.toString()},O.toFixed=function(e,r){var t,n=this,i=n.constructor,o=i.toExpNeg,a=i.toExpPos;return null!=e&&(e=u(n,e,t="toFixed")?n.e+(0|e):null,r=s(n,r,t)),i.toExpNeg=-(i.toExpPos=1/0),null!=e&&n.c?(t=f(n,e,r),n.s<0&&n.c&&(n.c[0]?t.indexOf("-")<0&&(t="-"+t):t=t.replace("-",""))):t=n.toString(),i.toExpNeg=o,i.toExpPos=a,t},O.toFormat=function(e,r){var t=this;if(!t.c)return t.toString();var n,i=t.s<0,o=t.constructor.format,a=o.groupSeparator,s=+o.groupSize,u=+o.secondaryGroupSize,c=t.toFixed(e,r).split("."),f=c[0],l=c[1],p=i?f.slice(1):f,m=p.length;if(u&&(n=s,s=u,m-=u=n),s>0&&m>0){for(n=m%s||s,f=p.substr(0,n);m>n;n+=s)f+=a+p.substr(n,s);u>0&&(f+=a+p.slice(n)),i&&(f="-"+f)}return l?f+o.decimalSeparator+((u=+o.fractionGroupSize)?l.replace(new RegExp("\\d{"+u+"}\\B","g"),"$&"+o.fractionGroupSeparator):l):f},O.toFraction=function(e){var r,t,n,i,a,s,u,c,f=this,m=f.constructor,h=r=new m(m.ONE),g=s=new m(0),d=f.c,w=new m(g);if(!d)return f.toString();for(n=w.e=l(d)-f.e-1,w.c[0]=N(10,(u=n%T)<0?T+u:u),(null==e||(!(b=12,a=new m(e)).s||(x=a.cmp(h)<0||!a.c)||m.errors&&E(a.e/T)<a.c.length-1)&&!p(m,"max denominator",e,"toFraction",0)||(e=a).cmp(w)>0)&&(e=n>0?w:h),y=!1,a=new m(o(d)),u=m.precision,m.precision=n=d.length*T*2;c=_(a,w,0,1,1),t=r.plus(c.times(g)),1!=t.cmp(e);)r=g,g=t,h=s.plus(c.times(t=h)),s=t,w=a.minus(c.times(t=w)),a=t;return t=_(e.minus(r),g,0,1,1),s=s.plus(t.times(h)),r=r.plus(t.times(g)),s.s=h.s=f.s,i=_(h,g,n,1).minus(f).abs().cmp(_(s,r,n,1).minus(f).abs())<1?[h+"",g+""]:[s+"",r+""],y=!0,m.precision=u,i},O.toNearest=function(e,r){var t=this,n=t.constructor;return t=new n(t),null==e?(e=new n(n.ONE),r=n.rounding):(b=17,e=new n(e),r=s(t,r,"toNearest")),e.c?t.c&&(e.c[0]?(y=!1,t=_(t,e,0,4>r?[4,5,7,8][r]:r,1).times(e),y=!0,g(t)):t.c=[t.e=0]):t.s&&(e.s&&(e.s=t.s),t=e),t},O.toNumber=function(){var e=this;return+e||(e.s?0*e.s:0/0)},O.toPower=O.pow=function(e,r){var t,n,i,s,u=this,f=u.constructor,l=u.s,p=(b=13,+(e=new f(e,r))),d=0>p?-p:p,w=f.precision,x=f.rounding;if(!u.c||!e.c||(i=!u.c[0])||!e.c[0])return new f(N(i?0*l:+u,p));if(u=new f(u),t=u.c.length,!u.e&&u.c[0]==u.s&&1==t)return u;if(r=e.c.length-1,e.e||e.c[0]!=e.s||r)if(n=E(e.e/T),i=n>=r,!i&&0>l)s=new f(0/0);else{if(i&&U>t*T*d){if(s=m(f,u,d),e.s<0)return f.ONE.div(s)}else{if(l=0>l&&1&e.c[Math.max(n,r)]?-1:1,r=N(+u,p),n=0!=r&&isFinite(r)?new f(r+"").e:E(p*(Math.log("0."+o(u.c))/Math.LN10+u.e+1)),n>f.maxE+1||n<f.minE-1)return new f(n>0?l/0:0);y=!1,f.rounding=u.s=1,d=Math.min(12,(n+"").length),s=c(e.times(h(u,w+d)),w),s=g(s,w+5,1),a(s.c,w,x)&&(n=w+10,s=g(c(e.times(h(u,n+d)),n),n+5,1),+o(s.c).slice(w+1,w+15)+1==1e14&&(s=g(s,w+1,0))),s.s=l,y=!0,f.rounding=x}s=g(s,w,x)}else s=g(u,w,x);return s},O.toPrecision=function(e,r){var t=this;return null!=e&&u(t,e,"toPrecision",1)&&t.c?f(t,0|--e,s(t,r,"toPrecision"),2):t.toString()},O.toSignificantDigits=O.toSD=function(e,r){var t=this,n=t.constructor;return t=new n(t),null!=e&&u(t,e,"toSD",1)?g(t,0|e,s(t,r,"toSD")):g(t,n.precision,n.rounding)},O.toString=function(e){var r,t,n,i=this,a=i.constructor,s=i.e;if(null===s)t=i.s?"Infinity":"NaN";else{if(e===r&&(s<=a.toExpNeg||s>=a.toExpPos))return f(i,null,a.rounding,1);if(t=o(i.c),0>s){for(;++s;t="0"+t);t="0."+t}else if(n=t.length,s>0)if(++s>n)for(s-=n;s--;t+="0");else n>s&&(t=t.slice(0,s)+"."+t.slice(s));else if(r=t.charAt(0),n>1)t=r+"."+t.slice(1);else if("0"==r)return r;if(null!=e)if((x=!(e>=2&&65>e))||e!=(0|e)&&a.errors)p(a,"base",e,"toString",0);else if(t=d(a,t,0|e,10,i.s),"0"==t)return t}return i.s<0?"-"+t:t},O.truncated=O.trunc=function(){return g(new this.constructor(this),this.e+1,1)},O.valueOf=O.toJSON=function(){return this.toString()},d=function(){function e(e,r,t){for(var n,i,o=[0],a=0,s=e.length;s>a;){for(i=o.length;i--;o[i]*=r);for(o[n=0]+=S.indexOf(e.charAt(a++));n<o.length;n++)o[n]>t-1&&(null==o[n+1]&&(o[n+1]=0),o[n+1]+=o[n]/t|0,o[n]%=t)}return o.reverse()}return function(r,t,n,i,o){var a,s,u,c,f,l,p=t.indexOf("."),h=r.precision,g=r.rounding;for(37>i&&(t=t.toLowerCase()),p>=0&&(t=t.replace(".",""),l=new r(i),c=m(r,l,t.length-p),l.c=e(c.toFixed(),10,n),l.e=l.c.length),f=e(t,i,n),a=s=f.length;0==f[--s];f.pop());if(!f[0])return"0";if(0>p?a--:(c.c=f,c.e=a,c.s=o,c=_(c,l,h,g,0,n),f=c.c,u=c.r,a=c.e),p=f[h],s=n/2,u=u||null!=f[h+1],4>g?(null!=p||u)&&(0==g||g==(c.s<0?3:2)):p>s||p==s&&(4==g||u||6==g&&1&f[h-1]||g==(c.s<0?8:7)))for(f.length=h,--n;++f[--h]>n;)f[h]=0,h||(++a,f.unshift(1));else f.length=h;for(s=f.length;!f[--s];);for(p=0,t="";s>=p;t+=S.charAt(f[p++]));if(0>a){for(;++a;t="0"+t);t="0."+t}else if(p=t.length,++a>p)for(a-=p;a--;t+="0");else p>a&&(t=t.slice(0,a)+"."+t.slice(a));return t}}();var _=function(){function e(e,r,t){var n,i=0,o=e.length;for(e=e.slice();o--;)n=e[o]*r+i,e[o]=n%t|0,i=n/t|0;return i&&e.unshift(i),e}function r(e,r,t,n){var i,o;if(t!=n)o=t>n?1:-1;else for(i=o=0;t>i;i++)if(e[i]!=r[i]){o=e[i]>r[i]?1:-1;break}return o}function t(e,r,t,n){for(var i=0;t--;)e[t]-=i,i=e[t]<r[t]?1:0,e[t]=i*n+e[t]-r[t];for(;!e[0]&&e.length>1;e.shift());}return function(n,i,o,a,s,u){var c,f,l,p,m,h,d,w,x,v,y,b,N,M,S,O,C,B,U,q=n.constructor,_=n.s==i.s?1:-1,z=n.c,I=i.c;if(!(z&&z[0]&&I&&I[0]))return new q(n.s&&i.s&&(z?!I||z[0]!=I[0]:I)?z&&0==z[0]||!I?0*_:_/0:0/0);for(u?(p=1,f=n.e-i.e):(u=A,p=T,f=E(n.e/p)-E(i.e/p)),B=I.length,O=z.length,x=new q(_),v=x.c=[],l=0;I[l]==(z[l]||0);l++);if(I[l]>(z[l]||0)&&f--,null==o?(_=o=q.precision,a=q.rounding):_=s?o+(n.e-i.e)+1:o,0>_)v.push(1),m=!0;else{if(_=_/p+2|0,l=0,1==B){for(h=0,I=I[0],_++;(O>l||h)&&_--;l++)M=h*u+(z[l]||0),v[l]=M/I|0,h=M%I|0;m=h||O>l}else{for(h=u/(I[0]+1)|0,h>1&&(I=e(I,h,u),z=e(z,h,u),B=I.length,O=z.length),S=B,y=z.slice(0,B),b=y.length;B>b;y[b++]=0);U=I.slice(),U.unshift(0),C=I[0],I[1]>=u/2&&C++;do h=0,c=r(I,y,B,b),0>c?(N=y[0],B!=b&&(N=N*u+(y[1]||0)),h=N/C|0,h>1?(h>=u&&(h=u-1),d=e(I,h,u),w=d.length,b=y.length,c=r(d,y,w,b),1==c&&(h--,t(d,w>B?U:I,w,u))):(0==h&&(c=h=1),d=I.slice()),w=d.length,b>w&&d.unshift(0),t(y,d,b,u),-1==c&&(b=y.length,c=r(I,y,B,b),1>c&&(h++,t(y,b>B?U:I,b,u))),b=y.length):0===c&&(h++,y=[0]),v[l++]=h,c&&y[0]?y[b++]=z[S]||0:(y=[z[S]],b=1);while((S++<O||null!=y[0])&&_--);m=null!=y[0]}v[0]||v.shift()}if(1==p)x.e=f,x.r=+m;else{for(l=1,_=v[0];_>=10;_/=10,l++);x.e=l+f*p-1,g(x,s?o+x.e+1:o,a,m)}return x}}();w=function(){function e(e){var r,t,n,i=this,o="config",a=i.errors?parseInt:parseFloat;return e==t||"object"!=typeof e&&!p(i,"object expected",e,o)?i:((n=e[r="precision"])!=t&&((x=1>n||n>B)||a(n)!=n?p(i,r,n,o,0):i[r]=0|n),(n=e[r="rounding"])!=t&&((x=0>n||n>8)||a(n)!=n?p(i,r,n,o,0):i[r]=0|n),(n=e[r="toExpNeg"])!=t&&((x=-C>n||n>0)||a(n)!=n?p(i,r,n,o,0):i[r]=E(n)),(n=e[r="toExpPos"])!=t&&((x=0>n||n>C)||a(n)!=n?p(i,r,n,o,0):i[r]=E(n)),(n=e[r="minE"])!=t&&((x=-C>n||n>0)||a(n)!=n?p(i,r,n,o,0):i[r]=E(n)),(n=e[r="maxE"])!=t&&((x=0>n||n>C)||a(n)!=n?p(i,r,n,o,0):i[r]=E(n)),(n=e[r="errors"])!=t&&(n===!!n||1===n||0===n?(x=b=0,i[r]=!!n):p(i,r,n,o,1)),(n=e[r="crypto"])!=t&&(n===!!n||1===n||0===n?i[r]=!(!n||!v||"object"!=typeof v):p(i,r,n,o,1)),(n=e[r="modulo"])!=t&&((x=0>n||n>9)||a(n)!=n?p(i,r,n,o,0):i[r]=0|n),(e=e[r="format"])!=t&&("object"==typeof e?i[r]=e:p(i,"format object expected",e,o)),i)}function r(e){return new this(e).exp()}function t(e){return new this(e).ln()}function n(e,r){return new this(e).log(r)}function i(e,r,t){var n,i,o=0;for("[object Array]"==M.call(r[0])&&(r=r[0]),n=new e(r[0]);++o<r.length;){if(i=new e(r[o]),!i.s){n=i;break}n[t](i)&&(n=i)}return n}function o(){return i(this,arguments,"lt")}function a(){return i(this,arguments,"gt")}function s(e,r){return new this(e).pow(r)}function c(e){var r,t,n,i=0,o=[],a=this,s=new a(a.ONE);if(null!=e&&u(s,e,"random")?e|=0:e=a.precision,t=Math.ceil(e/T),a.crypto)if(v&&v.getRandomValues)for(r=v.getRandomValues(new Uint32Array(t));t>i;)n=r[i],n>=429e7?r[i]=v.getRandomValues(new Uint32Array(1))[0]:o[i++]=n%1e7;else if(v&&v.randomBytes){for(r=v.randomBytes(t*=4);t>i;)n=r[i]+(r[i+1]<<8)+(r[i+2]<<16)+((127&r[i+3])<<24),n>=214e7?v.randomBytes(4).copy(r,i):(o.push(n%1e7),i+=4);i=t/4}else p(a,"crypto unavailable",v,"random");if(!i)for(;t>i;)o[i++]=1e7*Math.random()|0;for(t=o[--i],e%=T,t&&e&&(n=N(10,T-e),o[i]=(t/n|0)*n);0===o[i];i--)o.pop();if(0>i)o=[t=0];else{for(t=-1;0===o[0];)o.shift(),t-=T;for(i=1,n=o[0];n>=10;)n/=10,i++;T>i&&(t-=T-i)}return s.e=t,s.c=o,s}function f(e){return new this(e).sqrt()}function l(i){function u(e,r){var t=this;if(!(t instanceof u))return p(u,"Decimal called without new",e),new u(e,r);if(t.constructor=u,e instanceof u){if(null==r)return b=0,t.s=e.s,t.e=e.e,t.c=(e=e.c)?e.slice():e,t;if(10==r)return g(new u(e),u.precision,u.rounding);e+=""}return m(u,t,e,r)}return u.precision=20,u.rounding=4,u.modulo=1,u.toExpNeg=-7,u.toExpPos=21,u.minE=-C,u.maxE=C,u.errors=!0,u.crypto=!1,u.format={decimalSeparator:".",groupSeparator:",",groupSize:3,secondaryGroupSize:0,fractionGroupSeparator:" ",fractionGroupSize:0},u.prototype=O,u.ONE=new u(1),u.ROUND_UP=0,u.ROUND_DOWN=1,u.ROUND_CEIL=2,u.ROUND_FLOOR=3,u.ROUND_HALF_UP=4,u.ROUND_HALF_DOWN=5,u.ROUND_HALF_EVEN=6,u.ROUND_HALF_CEIL=7,u.ROUND_HALF_FLOOR=8,u.EUCLID=9,u.config=e,u.constructor=l,u.exp=r,u.ln=t,u.log=n,u.max=o,u.min=a,u.pow=s,u.sqrt=f,u.random=c,null!=i&&u.config(i),u}var m=function(){var e=/^-?(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i,r=String.prototype.trim||function(){return this.replace(/^\s+|\s+$/g,"")};return function(t,n,i,o){var a,s,u,c,f,l;if("string"!=typeof i&&(i=(c="number"==typeof i||"[object Number]"==M.call(i))&&0===i&&0>1/i?"-0":i+""),f=i,null==o&&e.test(i))n.s=45===i.charCodeAt(0)?(i=i.slice(1),-1):1;else{if(10==o)return g(new t(i),t.precision,t.rounding);if(i=r.call(i).replace(/^\+(?!-)/,""),n.s=45===i.charCodeAt(0)?(i=i.replace(/^-(?!-)/,""),-1):1,null!=o?o!=(0|o)&&t.errors||(x=!(o>=2&&65>o))?(p(t,"base",o,0,0),l=e.test(i)):(a="["+S.slice(0,o=0|o)+"]+",i=i.replace(/\.$/,"").replace(/^\./,"0."),(l=new RegExp("^"+a+"(?:\\."+a+")?$",37>o?"i":"").test(i))?(c&&(i.replace(/^0\.0*|\./,"").length>15&&p(t,0,f),c=!c),i=d(t,i,10,o,n.s)):"Infinity"!=i&&"NaN"!=i&&(p(t,"not a base "+o+" number",f),i="NaN")):l=e.test(i),!l)return n.c=n.e=null,"Infinity"!=i&&("NaN"!=i&&p(t,"not a number",f),n.s=null),b=0,n
}for((s=i.indexOf("."))>-1&&(i=i.replace(".","")),(u=i.search(/e/i))>0?(0>s&&(s=u),s+=+i.slice(u+1),i=i.substring(0,u)):0>s&&(s=i.length),u=0;48===i.charCodeAt(u);u++);for(o=i.length;48===i.charCodeAt(--o););if(i=i.slice(u,o+1)){if(o=i.length,c&&o>15&&p(t,0,f),n.e=s=s-u-1,n.c=[],u=(s+1)%T,0>s&&(u+=T),o>u){for(u&&n.c.push(+i.slice(0,u)),o-=T;o>u;)n.c.push(+i.slice(u,u+=T));i=i.slice(u),u=T-i.length}else u-=o;for(;u--;i+="0");n.c.push(+i),y&&(n.e>t.maxE?n.c=n.e=null:n.e<t.minE&&(n.c=[n.e=0]))}else n.c=[n.e=0];return b=0,n}}();return l()}(),n=function(){return w}.call(r,t,r,e),!(void 0!==n&&(e.exports=n))}(this)},function(e){"use strict";e.exports={end:!0}},function(e,r,t){"use strict";function n(){for(var e,r=Array.prototype.slice.call(arguments),t=0,n=r.length;n>t;t++){e=r[t];for(var i in e)e.hasOwnProperty(i)&&(v[i]=e[i])}}function i(e,r){return"undefined"!=typeof e[r]}function o(e){return function(r){return i(e,r)}}function a(e){return function(t){if("boolean"==typeof e[t])t=e[t]===!0?"\\"+t:"\\mathrm{"+t+"}";else if("string"==typeof e[t])t=e[t];else if("string"==typeof t){var n=t.indexOf("_");-1!==n&&(t=r.toSymbol(t.substring(0,n))+"_{"+r.toSymbol(t.substring(n+1))+"}")}return t}}var s=t(172),u=t(181),c=t(183),f=t(176),l={Alpha:"A",alpha:!0,Beta:"B",beta:!0,Gamma:!0,gamma:!0,Delta:!0,delta:!0,Epsilon:"E",epsilon:!0,varepsilon:!0,Zeta:"Z",zeta:!0,Eta:"H",eta:!0,Theta:!0,theta:!0,vartheta:!0,Iota:"I",iota:!0,Kappa:"K",kappa:!0,varkappa:!0,Lambda:!0,lambda:!0,Mu:"M",mu:!0,Nu:"N",nu:!0,Xi:!0,xi:!0,Omicron:"O",omicron:!0,Pi:!0,pi:!0,varpi:!0,Rho:"P",rho:!0,varrho:!0,Sigma:!0,sigma:!0,varsigma:!0,Tau:"T",tau:!0,Upsilon:!0,upsilon:!0,Phi:!0,phi:!0,varphi:!0,Chi:"X",chi:!0,Psi:!0,psi:!0,Omega:!0,omega:!0},p={dots:!0,ldots:!0,cdots:!0,vdots:!0,ddots:!0,idots:!0},m={"true":"\\mathrm{True}","false":"\\mathrm{False}"},h={inf:"\\infty",Inf:"\\infty",infinity:"\\infty",Infinity:"\\infty",oo:"\\infty",lim:!0,undefined:"\\mathbf{?}"},g={acos:"\\cos^{-1}",arccos:"\\cos^{-1}",cos:!0,csc:!0,csch:!1,exp:!0,ker:!0,limsup:!0,min:!0,sinh:!0,asin:"\\sin^{-1}",arcsin:"\\sin^{-1}",cosh:!0,deg:!0,gcd:!0,lg:!0,ln:!0,Pr:!0,sup:!0,atan:"\\tan^{-1}",atan2:"\\tan2^{-1}",arctan:"\\tan^{-1}",cot:!0,det:!0,hom:!0,log:!0,log10:"\\log_{10}",sec:!0,sech:!1,tan:!0,arg:!0,coth:!0,dim:!0,inf:!0,max:!0,sin:!0,tanh:!0,fix:!1,lcm:!1,sign:!1,xgcd:!1,unaryMinus:!1,unaryPlus:!1,complex:!1,conj:!1,im:!1,re:!1,diag:!1,resize:!1,size:!1,squeeze:!1,subset:!1,index:!1,ones:!1,zeros:!1,range:!1,random:!1,mean:"\\mu",median:!1,prod:!1,std:"\\sigma","var":"\\sigma^2"},d={sqrt:!0,inv:!0,"int":"\\int",Int:"\\int",integrate:"\\int",eigenvalues:"\\lambda",liminf:!0,lim:!0,exp:"e^",sum:!0,eye:"\\mathbf{I}"},w={"<=":"\\leq",">=":"\\geq","!=":"\\neq","in":!0,"*":"\\cdot","/":"\\frac",mod:"\\bmod",to:"\\rightarrow"},x={deg:"^{\\circ}"},v={};n(g,d,l,p,m,h),r.isSymbol=o(v),r.toSymbol=a(v),r.isFunction=o(g),r.toFunction=a(g),r.isCurlyFunction=o(d),r.toCurlyFunction=a(d),r.isOperator=o(w),r.toOperator=a(w),r.isUnit=o(x),r.toUnit=function(){var e=a(x);return function(t,n){return r.isUnit(t)?e(t):(n?"":"\\,")+"\\mathrm{"+t+"}"}}(),r.addBraces=function(e,r,t){if(null===r)return e;var n=["",""];switch(t=t||"normal","undefined"==typeof r||r===!1?n=["{","}"]:r===!0?(n=["(",")"],t="lr"):n=Array.isArray(r)&&2===r.length?r:[r,r],t){case"normal":case!1:return n[0]+e+n[1];case"lr":return"\\left"+n[0]+"{"+e+"}\\right"+n[1];case"be":return"\\begin{"+n[0]+"}"+e+"\\end{"+n[1]+"}"}return n[0]+e+n[1]},r.toArgs=function(e){var t=e.name,n=e.args,i=r.toSymbol(e.name),o=null,a=null,l=!1,p=!1,m="",h="",g=null;switch(t){case"add":g="+";break;case"subtract":g="-";break;case"larger":g=">";break;case"largerEq":g=">=";break;case"smaller":g="<";break;case"smallerEq":g="<=";break;case"unequal":g="!=";break;case"equal":g="=";break;case"mod":g="mod";break;case"multiply":g="*";break;case"pow":g="^";break;case"concat":g="||";break;case"factorial":g="!";break;case"permutations":if(1!==n.length){var d=n[0].toTex(),w=n[1].toTex();return"\\frac{"+d+"!}{\\left("+d+" - "+w+"\\right)!}"}if(!(n[0]instanceof c||n[0]instanceof f))return"{\\left("+n[0].toTex()+"\\right)!}";g="!";break;case"combinations":g="\\choose";break;case"abs":a="|",l="lr";break;case"norm":if(a="\\|",l="lr",2===n.length){var x=n[1].toTex();"\\text{inf}"===x?x="\\infty":"\\text{-inf}"===x?x="{- \\infty}":"\\text{fro}"===x&&(x="F"),h="_{"+x+"}",n=[n[0]]}break;case"ceil":a=["\\lceil","\\rceil"],l="lr";break;case"floor":a=["\\lfloor","\\rfloor"],l="lr";break;case"round":a=["\\lfloor","\\rceil"],l="lr",2===n.length&&(h="_"+r.addBraces(n[1].toTex()),n=[n[0]]);break;case"inv":h="^{-1}";break;case"transpose":h="^{T}",a=!1;break;case"log":var v="e";2===n.length&&(v=n[1].toTex(),i="\\log_{"+v+"}",n=[n[0]]),"e"===v&&(i="\\ln"),p=!0;break;case"square":h="^{2}";break;case"cube":h="^{3}";break;case"eye":p=!0,a=!1,i+="_";break;case"det":if(e.args[0]instanceof s)return e.args[0].toTex("vmatrix");a="vmatrix",l="be";break;default:p=!0}return null!==g?(a="+"===g||"-"===g,o=new u(g,t,n).toTex()):g=", ",null!==a||r.isCurlyFunction(t)||(a=!0),o=o||n.map(function(e){return"{"+e.toTex()+"}"}).join(g),m+(p?i:"")+r.addBraces(o,a,l)+h}}])});
//# sourceMappingURL=math.map