/*
 *	StylosCSV2XPS(CSVStream,stageOffset)

 *		stylos CSVファイルをXPS互換テキストにコンバートする
 *		引き数は、CSVデータのテキストストリーム,
 *		stageOffsetは原画シートを転記するか動画シートを転記するかのフラグ 0:原画シート/1:動画シート
 */

function StylosCSV2XPS(CSVStream,stageOffset)
{
//データ冒頭のみチェックして明確に違うストリームの場合はエラーを返す
if (! CSVStream.match(/^\"Frame\",/)){ return false;};

//CSVデータをオブジェクト化する
	myStylosCSV=new Object();
//ラインで分割して配列に取り込み
	myStylosCSV.SrcData=new Array();
	if(CSVStream.match(/\r/)){CSVStream=CSVStream.replace(/\r\n?/g,("\n"));};
	myStylosCSV.SrcData=CSVStream.split("\n");
//各ラインを更にテキストの配列に分解(ココでchompしてdurationとったほうが良いかも)
	for(var idx=0;idx<myStylosCSV.SrcData.length;idx++){myStylosCSV.SrcData[idx]=myStylosCSV.SrcData[idx].split(",");}

	if(!stageOffset){myStylosCSV.stageOffset=0;}else{myStylosCSV.stageOffset=stageOffset;};
	myStylosCSV.frameDuration	=myStylosCSV.SrcData.length-3;
					//フレーム継続数 全ライン数-(ヘッダ行,ラベル行)
	myStylosCSV.layerCount	=(myStylosCSV.SrcData[0].length-2)/2;
					//レイヤ数((レコード長-(フレームカウント,ダイアログライン))/2)
	myStylosCSV.body=function(layerID,frameID,layerOffset)
	{
		if(! layerOffset){layerOffset=this.stageOffset;};//0:原画シート/1:動画シート　
		return (eval(this.SrcData[frameID+2][layerID+(layerOffset*this.layerCount)+1]));
	}
//ラベル取得
	myStylosCSV.layerLabel	=new Array(myStylosCSV.layerCount);//ラベル配列
	for(var idx=0;idx<myStylosCSV.layerCount;idx++){myStylosCSV.layerLabel[idx]=eval(myStylosCSV.SrcData[1][idx+1]);};//原画シートからラベル取得


//XPS互換ストリームに変換
myStylosCSV.toSrcString = function()
{
//	var myLineFeed=nas.GUI.LineFeed;
	var myLineFeed="\n";
	var resultStream="nasTIME-SHEET 0.4";
	resultStream	+=myLineFeed;
	resultStream	+="#RETAS!StylosCSV";
	resultStream	+=myLineFeed;
	resultStream	+="##TIME="+nas.Frm2FCT(this.frameDuration,3,0);
	resultStream	+=myLineFeed;
	resultStream	+="##TRIN=0+00.,\x22\x22";
	resultStream	+=myLineFeed;
	resultStream	+="##TROUT=0+00.,\x22\x22";
	resultStream	+=myLineFeed;
//	ラベル配置
	resultStream	+="[CELL\tN\t";
	for(idx=0;idx<this.layerCount;idx++)
	{	resultStream	+=this.layerLabel[idx]+"\t";};
	resultStream	+="]";
	resultStream	+=myLineFeed;
	
	for(frm=0;frm<this.frameDuration;frm++)
	{
		resultStream	+="\t";
		//ダイアログデータを転記
		resultStream	+=eval(this.SrcData[frm+2][this.layerCount+1]);
		resultStream	+="\t";
		for(idx=0;idx<this.layerCount;idx++)
		{
			if(frm==0)
			{
				var currentValue=this.body(idx,frm);
			}else{
				var currentValue=(this.body(idx,frm)==this.body(idx,(frm-1)))?"":this.body(idx,frm);
			}
			resultStream	+=(currentValue===0)?"X\t":currentValue+"\t";
		}
		resultStream	+=myLineFeed;
	}
	resultStream	+="[END]";
	resultStream	+=myLineFeed;
	resultStream	+="Convert from RETAS!StylosCSV"
	return resultStream;
}
//alert( myStylosCSV.toSrcString());
return myStylosCSV.toSrcString();
}

/*
	書式　XPS2StylosCSV(myXPS,myReferenceXPS)
	引数はオブジェクトでも、ストリームでも受け付ける。
	コンバートするXPSと必要な場合は参照用XPSを加えてスタイロスの書きだすCSVと同じ形式で書き出すことができる。
	文字コードのコンバートは特にしていないので、必要なら何か別のコンバート手段を利用してShift-JISに変換されたし。
	このデータはスタイロスに書き戻せないので、りまぴんでの編集後に書き出す意味はあまりない。
	互換データが欲しい場合のみ有効
*/
function XPS2StylosCSV(myXPS,myReferenceXPS){
//引数がソースであっても処理する。XPSでない場合はfalse
	if(myXPS instanceof Xps){
		var sourceXPS=myXPS;
	}else{
		if((myXPS instanceof String)&&(myXPS.match(/^nasTIME-SHEET/))){
			var sourceXPS=new Xps();
			if(! sourceXPS.readIN(myXPS)){return false;};
		}else{
			return false;
		}
	}
//リファレンスXPSがない場合は、カラで親サイズのカラオブジェクトを作る（親XPSのコピーのほうが良いか？）
	if(myReferenceXPS instanceof Xps){
		var referenceXPS=myReferenceXPS;
	}else{
		if((myReferenceXPS instanceof String)&&(myReferenceXPS.match(/^nasTIME-SHEET/))){
			var referenceXPS=new Xps();
			if(! referenceXPS.readIN(myReferenceXPS)){return false;};
		}else{
			var referenceXPS=myXPS;//複製
			var referenceXPS=new Xps(myXPS.layers.length,myXPS.duration());//カラオブジェクト
		}
	}
//リファレンスXPSのサイズが本体シートに満たない場合はサイズを拡張する
	if((myReferenceXPS.layers.length < myXPS.layers.length)||
	   (myReferenceXPS.duration() < myXPS.duration())){
		myReferenceXPS.reInitBody(myXPS.xpsBody.length,myXPS.duration());
	};
//コンバートする
var myStylosCSV=new Array();
	myStylosCSV.recordCunt=myXPS.layers.length*2+2;//(レイヤ数×２＋フレームカウント＋セリフ)
//第一レコードを作る
	var currentRecord=new Array();
		currentRecord.push('"Frame"');
		currentRecord.push('"原画"');
		for(var LC=0;LC<myXPS.layers.length-1;LC++){currentRecord.push('""');}
		currentRecord.push('"台詞"');
		currentRecord.push('"動画"');
		for(var LC=0;LC<myXPS.layers.length-1;LC++){currentRecord.push('""');}
	myStylosCSV.push(currentRecord.join(","));
//第二レコードを作る
	currentRecord=new Array();
		currentRecord.push('""');
		for(var LC=0;LC<myXPS.layers.length;LC++){
			if(LC<referenceXPS.layers.length){
				currentRecord.push('"'+referenceXPS.layers[LC].name+'"');
			}else{
				currentRecord.push('""');
			}
		}
		currentRecord.push('""');
		for(var LC=0;LC<myXPS.layers.length;LC++){
			currentRecord.push('"'+sourceXPS.layers[LC].name+'"');
		}
	myStylosCSV.push(currentRecord.join(","));

//ボディデータを流し込む
	for (var myFrame=0;myFrame<myXPS.duration();myFrame++){
		currentRecord=new Array();
		 currentRecord.push((myFrame+1).toString(10));//フレームカウント
		for(var LC=0;LC<myXPS.layers.length;LC++){
				currentRecord.push('"'+referenceXPS.xpsBody[LC+1][myFrame]+'"');//ダイアログフレームをとばす
		}
		for(var LC=0;LC<=myXPS.layers.length;LC++){
				currentRecord.push('"'+sourceXPS.xpsBody[LC][myFrame]+'"');//メモ情報はコンバートできない。
		}
		myStylosCSV.push(currentRecord.join(","));
	}
	
return myStylosCSV.join("\n");
}
/*
	暫定的にXPSストリーム（ソース）で返しているが、オブジェクトのままのほうが良いかもしれない。一考の余地あり？
	この形式で各フォーマットのコンバータを作って一元化したいが、どうよ？
	逆変換も欲しいね。
*/
//end converter

