﻿/*(絵コンテをHTMLに)
	ねこら絵コンテエディタから納品可能なHTMLに変換するスクリプト
	このスクリプトは、ブラウザのjavascriptです

	ブラウザ用に改修 3/23
外部ライブラリが必要です

sbdConvert.html　からコールします。
ライブラリはホストのHTML側でロード
	機能追加修正判 20080403


*/
var queueBox=false;//プレイヤで使用するキュー
//プレイヤモジュールをロードすると改めて初期化される。未ロード状態の判定用変数

//nekora絵コンテクラス
/*
	nekoraSB兼用
 */
function StoryBoard(){

	this.title	="noTitle";//
	this.auther	="";//
	this.frameRate	=24;//FPS
	this.docid	="";//ドキュメントID参照画像
	this.size	="middle";
	this.wide	="wide";
	this.cur_x	="";
	this.cur_y	="";
	this.linelock	="";
	this.linesparpage=5;//ページあたりの絵コンテの段数初期値5で

// ねこらエディタとは互換の無いコレクション
	this.duration	=0;//絵コンテの総尺を保存する為のプロパティ

	this.cuts	=new Array();//カットコレクション配列 要素はCut
	this.getCutByTime=function(myFrames){
		//フレームを指定してカットを取得
		if(myFrames>this.duration){return null;}
		var myResult=null;
		for(var idx=this.cuts.length;idx>0;idx--){
			if(this.cuts[idx-1].inPoint<=myFrames){myResult=this.cuts[idx-1];break;}
		}
		return myResult;
	}
	this.casts	=new Array();//キャストオブジェクトトレーラ
	this.cameraworks =new Array();//カメラワークオブジェクト
	this.effects	=new Array();//エフェクトオブジェクト
	this.dialogs	=new Array();//セリフオブジェクトトレーラ
	this.msks	=new Array();//音楽オブジェクトトレーラ
	this.sefs	=new Array();//効果音オブジェクトトレーラ

// ねこらエディタ互換コレクション
	this.table	=new Array();//カラムコレクション配列として初期化 要素はColumnNkrオブジェクト
	this.bookmarks	=new Array();//ブックマークコレクション配列 要素はBookmarkNkrオブジェクト

		this.bookmarks.toString=function(Mode){
				var myResult="";
			if(this.length){
switch(Mode){
case "sbd":			myResult +='<bookmarks>';
				for(var idx=0;idx<this.length;idx++){
					myResult+=this[idx].toString("sbd");
				}
				myResult+="</bookmarks>";
break;
case "html":				myResult +='<hr/>bookmark<br/><hr/><select style="width:64px;" onChange="keyJump(this.value)">';
				for(var idx=0;idx<this.length;idx++){
					myResult+=this[idx].toString("html")
				}
				myResult+="</select>";
break;
case	"csv":
default:
				for(var idx=0;idx<this.length;idx++){
					myResult+=this[idx].toString("csv")
				}
}
				return myResult;
			}else{	return "";
			}
		}
//以下はコンバート用オブジェクト
//	this.frameAspect =(this.wide=="wide")? 16/9 : 4/3 ;//(ヨコ/タテ)仮初期化 あとでスタイルシート値で置き替え

	this.convert=function(){};//コンバータ用オブジェクト(ポイント計算)

		this.convert.isLocal=(document.location.toString().match(/^file:\/\/.+/))?true:false;
/*	この設定は現在保留中
		this.convert.pageWidth=(156*72/25.4);	//"156mm";//画像最大幅(幅モノ全加算)
		this.convert.pageHeight=(250*72/25.4);	//"250mm";//画像最大高さ カラム高×5
		this.convert.columnHeight=(50*72/25.4);	//"50mm";//カラム高さ
		this.convert.columnWidth=(88*72/25.4);	//"88mm";//カラム幅(本体幅)
		this.convert.contentsWidth=(33*72/25.4);//"33mm";//ト書き幅(本体幅＋マージン)
		this.convert.dialogWidth=(35*72/25.4);	//"35mm";//セリフ幅(本体幅＋マージン)
*/
/*
	スタイルシートのセレクタの内容を読んで変数を設定するのでスタイルシートでサイズ設定してください
	設定単位は mm px pt の3種のみ

*/
//カラム高さ
		this.convert.columnHeight =	nas.decodeUnit(nas.getCssRule(".columnLabel","height",2),"pt");
//カラム幅
		this.convert.columnWidth =	nas.decodeUnit(nas.getCssRule(".pictureArea","width",2),"pt");
//ト書き幅
		this.convert.contentsWidth =	nas.decodeUnit(nas.getCssRule(".contentText","width",2),"pt")+
						nas.decodeUnit(nas.getCssRule(".contentText","padding-left",2),"pt")+
						nas.decodeUnit(nas.getCssRule(".contentText","padding-right",2),"pt");
//セリフ幅
		this.convert.dialogWidth	= nas.decodeUnit(nas.getCssRule(".dialogText","width",2),"pt")+
						nas.decodeUnit(nas.getCssRule(".dialogText","padding-left",2),"pt")+
						nas.decodeUnit(nas.getCssRule(".dialogText","padding-right",2),"pt");
//ページ描画幅(カット番号幅とタイムテクスト幅は除外した数値)
		this.convert.pageWidth=this.convert.columnWidth+this.convert.contentsWidth+this.convert.dialogWidth;	//画像最大幅(幅モノ全加算)
//取得した値からフレームアスペクトを出す
		this.convert.frameAspect=this.convert.columnWidth/this.convert.columnHeight;

/*	スタイルシートから取得した値をもとに絵コンテの設定でパラメータを変更する	*/

//画像高さから指定のページに何段入るかを計算する。>スタイルシートで指定
//画像最大高さ カラム高×カラム段数
		this.convert.pageHeight=(this.convert.columnHeight*Math.floor(nas.decodeUnit(nas.getCssRule("table","height",2),"pt")/this.convert.columnHeight));
/*
	絵コンテ画面のアスペクトが変更された場合は、現在のページ段(ねこらエディタのライン=行)を保持して画像の横幅を調整
	カット番号欄 および 秒数欄の幅を維持して残った描画幅を現在の ト書き幅:セリフ幅で割りつける。
	別メソッドにする
*/
	this.changeAspect=function(myAspect){
		var newPicWidth=myAspect*this.convert.columnHeight;
		var newContentWidth=(this.convert.pageWidth-newPicWidth)*(this.convert.contentsWidth/(this.convert.contentsWidth+this.convert.dialogWidth));
			this.convert.frameAspect	=myAspect;
			this.convert.columnWidth	=newPicWidth;
			this.convert.contentWidth	=newContentWidth;
			this.convert.dialogWidth	=this.convert.pageWidth-newPicWidth-newContentWidth;
//css更新
			nas.addCssRule(".pictureArea","width:"+(25.4*newPicWidth/72)+"mm;",2);
			nas.addCssRule(".contentText","width:"+(25.4*this.convert.contentWidth/72)+"mm;",2);
			nas.addCssRule(".dialogText","width:"+(25.4*this.convert.dialogWidth/72)+"mm;",2);
//プレイヤが存在する場合はプレイヤのクリッピング範囲を調整
		if(queueBox){
			$("clipFrame").style.height=Math.floor(nas.decodeUnit($("clipFrame").style.width,"px")/myAspect)+"px";
		}
	}


		this.convert.drawWidthPx=baseDrawingWidth;//描画基準幅 これを絵コンテの枠幅に合わせる
		this.convert.pictureMargin=baseDrawingMargin;//占有率 罫線付き用紙に印刷しないなら100%でもOK
//		this.convert.dummyResolution=Math.floor(72*640/(this.convert.columnWidth*0.95));//強制的にこの解像度で画像を処理 640pxを描画フレームの95%で処理
//		this.convert.maxColumns= Math.floor(this.convert.pageHeight/this.convert.columnHeight);
		this.convert.maxColumns= this.linesparpage;
		this.convert.currentPage=0;//処理中のページ番号
		this.convert.currentPgDuration=0;//処理中のページのサブトータル
		this.convert.currentSubTotal=0;//処理中のページの通算尺
//		this.convert.currentColumn=0;//処理中のカラムID(通し番号 0 orig)
		this.convert.currentSCID=0;//処理中のサブカラムID
		this.convert.hasSwitch= true;//出力HTMLにスイッチを付加するか否か
		this.convert.imageFolderName="images";
		this.convert.imageCount=0;//画像カウント　テーブル内の画像の総数（要キャッシュ総数）

		this.convert.isFileSave=false;//toString()メソッドの動作スイッチ


		this.convert.cssFileA='./sbdConvert/sbe_nas.css';
		this.convert.cssFileB='./sbdConvert/sbe_prt_nas.css';
		this.convert.cssFileC='./sbdConvert/paperDesign.css';
		this.convert.libFileA='./sbdConvert/nas_common.js';
		this.convert.libFileB='./sbdConvert/nas_common_HTML.js';
		this.convert.jsFile='./sbdConvert/viewUtil.js';

/*
//この下は一応不要だけど宣言文は残しておく
	this.frameWidth	=8*72;//(pt)

	this.subTitle	="";//

	this.pages	=new PageCollection();//ページコレクション
	this.cuts	=new CutCollection();//カットコレクション
*/
};
/*
	ブラウザ用画像キャッシュ取得待ちメソッド
画像サイズ計算を行う為に画像がすべてメモリにキャッシュされている必要がある。
このメソッドの取得待ちが終わってからコンバート可能

StoryBoard.prototype.viewCashStatus = function(){
    var count = 0;
    var msg   = "";

    for(var idx = 0; idx < this.table.length; idx++){
//      if(( this.table[idx].img.image instanceof HtmlImage )&&(this.table[idx].img.image.complete)) {count++;};
      if((this.table[idx].img.image)&&(this.table[idx].img.image.complete)) {count++;};
    }
    msg += this.convert.imageCount + "件中" + count + "件完了";
   if(count == this.convert.imageCount){
    msg += ":画像キャッシュがすべて完了しました。コンバート可能です。";
    }
    showMsg(msg);
    if(count < this.convert.imageCount){
     setTimeout(viewCashStatus, 1000);
    }

};
*/
/*
	SBDコンバータ用取り込みメソッド
	nekora SBD専用
	StoryBoardクラスのメソッドとして実行する
引数 ファイルから取り込んだXML本文テキスト パースは自前

戻り値 処理したカラム数・ コンバート中止時は false

ブラウザに環境移行したので汎用XMLパーサをつかえば良さそうな物だが…Adobeスクリプトの流用なのでこのまま
*/

StoryBoard.prototype.parseSBD=function(bodyText){
//与えられたデータを一時配列に展開
//事前データチェック
/*
	/<[^<>]+>/g のマッチ数と /</g />/g 単独のマッチ数を比較してすべて同数だった場合は"<>"の対比整合がとれていると見なす?
*/
var tagCount=bodyText.match(/<[^<>]+>/g);
var openCount=bodyText.match(/</g);
var closeCount=bodyText.match(/>/g);
if((tagCount.length!=openCount.length)||(openCount.length!=closeCount.length)){
	//タグが合ってない
	alert("NoNo :"+tagCount.length + ":" + openCount.length +" : "+ closeCount.length);
	return false;
}else{
//カウンタリセット
this.convert.imageCount=0;
//一時配列に分解
	var mySBDB=bodyText.replace(/<\//g,"><\/").split(">");
for(var idx=0;idx<mySBDB.length;idx++){mySBDB[idx]=mySBDB[idx].replace(/^\s*/,"");};

//alert(mySBDB.toString());alert(mySBDB.length);

//ループしてオブジェクト読み込み
var columnCount=0;//カラムカウント変数セット
var bookmarkCount=0;//しおりカウント変数セット
var myStage="";//初期ステージ
var targetProp="";//現在処理中のプロパティ名

	for(idx=0;idx<mySBDB.length-1;idx++){


		if(mySBDB[idx].match(/^<\//)){
//		閉じタグなので処理をスキップ
//alert("skip CloseTag "+mySBDB[idx]);
			continue;
		}else{
			if (mySBDB[idx].match(/^<.*[^\/]$/))  {
//alert("get openTag : "+idx+" : " +mySBDB[idx]);
//		開きタグなのでオブジェクトを判定して取り込みモードをセット
// 特に取り込むアトリビュートは今のところ無い 汎用パーサなら許されないが別に構わない

		myNodeAttrib=mySBDB[idx].replace(/(^<\s*|\s*$)/g,"").split(" ");//前後のスペースとタグを払って分解
//alert("myNodeAttrib :"+myNodeAttrib.toString());
				var nodeName=myNodeAttrib[0];//必ず一個はエレメントがある　なかったら嫌だ
//alert(nodeName + "+++++++++++++++");
				switch(nodeName){
case	"storyboard":	;//肝心の識別タグだターゲットと違っていたら処理中止
	if(myNodeAttrib[1] !='xmlns="http://www.mapletown.net/~nekora/sbedit"'){return false;}
break;
case	"table":	;//カラムテーブルモード移行
case	"bookmarks":	;//ブックマークモードに移行
	myStage=nodeName;
//	alert("switch Stage to "+nodeName);
break	;
case	"tr"	:	;//カラムオブジェクトを作成して、カラムを進める
	this.table[columnCount]=new ColumnNkr(this,columnCount);//(親ストーリーボード,ID)で初期化
	columnCount ++;
break;
case	"mark":	;//しおりを作成してカウントする
	this.bookmarks[bookmarkCount]=new BookmarkNkr(this,bookmarkCount);//(親ストーリーボード,ID)で初期化
	bookmarkCount ++;
break;
case	"?xml":	;//xml宣言だ捨てておこう 何もしない
break;
default	:	;//それ以外はノード名に対応したプロパティの取り込みなのでターゲットをセット
	targetProp=nodeName;

				}
/*
alert("targetNode: \n"+ targetNode.join("."));
alert("nodeName :"+nodeName);
alert(":カラファンクションを期待::" + eval(targetNode.join(".")+".toString()"))
 */
			}else{
				if (mySBDB[idx].match(/\/$/)){
					//alert("skip CloseTag "+mySBDB[idx]);
					 continue;
//		末尾が/ならば開いて閉じるタグなので値がないので次へ
				}
//alert(myStage+" : "+mySBDB[idx]);
//				通常のコンテンツデータなので、現在のステージに沿って値を取り込む
if (targetProp){
	switch(myStage){
case	"table":	;
	if(targetProp=="img"){
if(mySBDB[idx]!=""){
//エントリに値があれば
		this.table[columnCount-1][targetProp]=new Picture(this.table[columnCount-1],mySBDB[idx].replace(/\\/g,"/"));
		this.convert.imageCount++;
}else{
		this.table[columnCount-1][targetProp]="";//ヌルでフラグにする？
}

	}else{
		this.table[columnCount-1][targetProp]=mySBDB[idx];
	}
break;
case	"bookmarks":	;//しおり登録中
	switch(targetProp){
	case	"name":;
		this.bookmarks[bookmarkCount-1].name=mySBDB[idx];
	break	;
	case	"point":;
		this.bookmarks[bookmarkCount-1].key=mySBDB[idx];
	break	;
	}
break;
default	:
	this[targetProp]=mySBDB[idx];
	}
	targetProp="";
}
			}
		}

	}
}
/*
	すべて取り込み終えたので、解析してカットテーブルを作る
	独立処理
*/
	var cutCount=0;//処理済みのカットカウンタ
	var previewCut=new blankCut();//直前に処理したカラムのカット(未所属カラムはnull)初期化用dummyオブジェクト

for(var idx=0;idx<this.table.length;idx++){
	if((! this.table[idx].cut)&&(previewCut.index==null)){continue;};//このカラムはカットに未所属なのでスキップ
	if(this.table[idx].cut){	;//カット番号あり
		if((previewCut.index)&&(this.table[idx].cut==previewCut.name)){
			previewCut.addColumn(this.table[idx]);//先行カットと番号が一致した場合は、同カットに編入
			continue;
		}else{
			this.duration+=previewCut.length;
			this.cuts.push(new Cut(cutCount,this,this.table[idx],previewCut.inPoint+previewCut.length));
			previewCut=this.cuts[cutCount];
			cutCount++;
			continue;
		}
		
	}else{
		//カット番号なし
		//カラムのコンテントがすべてカラなら当該カラムはスキップ
		if(	(! this.table[idx].img)&&
			(! this.table[idx].desc)&&
			(! this.table[idx].words)&&
			(! this.table[idx].sec)
		){	continue;	};
		//まだ実装していないが、キーワード処理でカラムをカットからはずすことも可能にする

		previewCut.addColumn(this.table[idx]);//先行カットに追加
		continue;
	}
}
			this.duration+=previewCut.length;//最後のカットの尺を追加して終了
//パース終了したので 取り込んだパラメータとCSSのデータの突き合わせを行う
//スタイルシートの指定と絵コンテの記録が異なっていたら絵コンテ指定に高さを変更
		if(this.convert.maxColumns!=this.linesparpage){
			this.convert.maxColumns=this.linesparpage;
		};//最大カラムをコンテのデータで置き替え
		if(this.convert.pageHeight!=(this.convert.columnHeight*this.linesparpage)){
			this.convert.columnHeight=this.convert.pageHeight/this.linesparpage;
			this.changeAspect(this.convert.frameAspect);
			//this.convert.maxColumns=this.linesparpage;
			//css変更
			nas.addCssRule(".columnLabel","height:"+Math.round(this.convert.columnHeight)+"pt;","2");
		};

//比率が絵コンテデータとスタイルシートで異なっていたら以下の判断で変更
/*
	this.wideの値がnormalならば 3:4 が期待されているのでそのように変更
	それ以外は、スタイルシートの指定による値を優先
*/
// alert("aspect /"+this.convert.frameAspect+"::"+((4/3)/this.convert.frameAspect))
		if((this.wide=="nomal")&&(Math.round(100*this.convert.frameAspect/(4/3))!=100))
		{
			this.changeAspect(4/3);
		}

//	alert(cutCount);
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //
	return columnCount;
}

/*
	ストーリーボード全体をテキストで返す
	引数はモード
	//"sbd"/"html"/"csv" デフォルトは csv
	
 */

StoryBoard.prototype.toString=function(outputMode){
	var myResult="";
	switch(outputMode){
case	"sbd":	;//sbd(書き戻し用)
	myResult+='<?xml version="1.0" encoding="UTF-8" standalone="no"?>';
	myResult+='<storyboard xmlns="http://www.mapletown.net/~nekora/sbedit">';
	var prop=["title","docid","auther","framerate","size","wide","cur_x","cur_y","linelock","linesparpage"];
	for(var idx=0;idx<prop.length;idx++){
		myResult+='<'+prop[idx]+'>'+this[prop[idx]]+'</'+prop[idx]+'>';
	};
	myResult+='<table>';

	for (var idx=0;idx<this.table.length;idx++){
		myResult+=this.table[idx].toString("sbd");
	}


	myResult+='</table><bookmarks>';
if(this.bookmarks.length){
	for (var idx=0;idx<this.bookmarks.length;idx++){
		myResult+=this.bookmarks[idx].toString("sbd");
	}
}
	myResult+='</bookmarks></storyboard>';
break;
case	"html":	;//HTMLモード ブラウザに使用する場合はヘッダ回りは不要　
/*
	スイッチを付けて保存用のHTMLを書き出す時には添付する
*/
if(this.convert.isFileSave){
	myResult+='<html><head><META http-equiv="Content-Type" content="text/html; charset=UTF-8">\n';
	myResult+='<title>'+this.title+'</title>\n';
	myResult+='<link rel="stylesheet" type="text/css" href="'+this.convert.cssFileA+'" media="screen,tv">\n';
	myResult+='<link rel="stylesheet" type="text/css" href="'+this.convert.cssFileB+'" media="print">\n';
	myResult+='<link rel="stylesheet" type="text/css" href="'+this.convert.cssFileC+'" media="all">\n';
	myResult+='<style type="text/css">\n * {\n margin: 0; padding: 0;\n }\n #fixed {\n position: fixed;\n }\n #sheet_view {\n margin:0;\n }\n</style> \n<!--[if lt IE 7]> \n<style type="text/css">\n html {\n overflow: hidden;\n }\n body {\n height: 100%;\n overflow: auto;\n }\n #fixed {\n position: absolute;\n margin:0px 0px 0px -72px;\n }\n</style>\n<![endif]-->';
	if(this.convert.hasSwitch){
		myResult+='<script src="'+this.convert.libFileA+'"></script>\n';
		myResult+='<script src="'+this.convert.libFileB+'"></script>\n';
		myResult+='<script src="'+this.convert.jsFile+'"></script>\n';
	}
	myResult+='</head><body>';

	myResult+='<div class="indexBar" id=fixed><input type="text" style="width:48px;" value="000" align="center" id="pgCounter" onChange="pageJump(this.value,7);" ></input><br/><a href="javascript:pageJump(0,0)" title="最初のページへ" >[start]</a><br/><a href="javascript:pageJump(0,1)" title="-10ページ">[ -10 ]</a><br/><a href="javascript:pageJump(0,2)" title="前へ">[ △ ]</a><br/><a href="javascript:pageJump(0,4)" title="次へ">[ ▽ ]</a><br/><a href="javascript:pageJump(0,5)" title="10ページ">[ +10 ]</a><br/><a href="javascript:pageJump(0,6)" title="最後のページへ">[ end ]</a><br/><div class=bookmarks id=bookmarks>';
myResult+=this.bookmarks.toString("html");
myResult+='</div></div>';

};
//ヘッダ回りは、ファイル保存スイッチが入っている時のみ処理

/*	
カラムIDで順次処理
カラムにサブカラムIDを与えてゆきページ内のカラムを消費したら次のページへ移る
強制改行があれば、サブカラムIDをリセットして、空カラムを出力して次のページを開始
*/
//ドキュメントヘッダ出力
	{



		myResult+='<div class="titleHeader"><h1>'+this.title+'</h1><hr></div>\n\n';
	};
	this.convert.currentPage	=0;
	this.convert.currentPgDuration	=0;
	this.convert.currentSubTotal	=0;
	this.convert.currentSCID	=0;
	var isBreak=false;
	for (var idx=0;idx<this.table.length;idx++){
/*カラムID順にカラムの toString()を実行
toString()は、最後に処理したサブカラムIDを this.convert.currentSCIDにインクリメントセットする(親コンバータのポインタが更新される)ので、
必要にしたがってページヘッダを出力する。ループの最後に次の処理ポインタをセットすること。
 */
		if(this.convert.currentSCID==0){
//前周回処理の際にブレイクフラグが立っていたら、それは二重改ページになるのでここで削除
			if(isBreak){isBreak=false;}

//ページヘッダ出力

if(this.convert.hasSwitch){
	var myPageID=nas.Zf(this.convert.currentPage,3);
		myResult+='<a id="'+myPageID+'" name="'+myPageID+'"></a><div class="titleHeader">';
		myResult+='<a href="javascript:pageJump(\''+myPageID+'\',0)" title="最初のページへ" >[start]</a> ';
		myResult+='<a href="javascript:pageJump(\''+myPageID+'\',1)" title="-10ページ">[ -10 ]</a> ';
		myResult+='<a href="javascript:pageJump(\''+myPageID+'\',2)" title="前へ">[ prev]</a> ';
		myResult+='<a href="javascript:pageJump(\''+myPageID+'\',3)" title="このページ">[ === ]</a> ';
		myResult+='<a href="javascript:pageJump(\''+myPageID+'\',4)" title="次へ">[ next]</a> ';
		myResult+='<a href="javascript:pageJump(\''+myPageID+'\',5)" title="10ページ">[ +10 ]</a> ';
		myResult+='<a href="javascript:pageJump(\''+myPageID+'\',6)" title="最後のページへ">[ end ]</a> ';
		myResult+='</div>';
}
		myResult+='\n<table>\n\t<tr class="pageHeader"><th class="cutNumber">cut</th><th class="pictureArea">picture</th><th class="contentText">contents</th><th class="dialogText">dialog</th><th class="timeText">time</th></tr>\n';//ページヘッダーライン
		}
//コンテント(ト書き)内に改ページ命令があればそのカラム終了でページの残りを空のカラムで埋めて改ページ
//		フラグたてる
		if(this.table[idx].desc.match(/&lt;break&gt;/)){
			isBreak=true;
		};
		myResult+=this.table[idx].toString("html");//ColumnNkr.toString()で取得
//ブレイクフラグがある かつ 残りカラムあり または 全エントリ処理終了で残カラムあり
		if(((isBreak)||((this.table.length-1)==idx))&&(this.convert.currentSCID<this.convert.maxColumns)){
			for(var scidx=this.convert.currentSCID;scidx<this.convert.maxColumns;scidx++){
				myResult+='\n\t<tr><td class="columnLabel"><br/></td><td class="pictureArea"><br/></td><td class="contents"><br/></td><td class="dialog"><br/></td><td class="timeText"><br/></td></tr>\n';
			}
			this.convert.currentSCID=this.convert.maxColumns;//空のカラムを追加してサブカラムIDを更新
			isBreak=false;
		};
/*
このねこらエディタを使用する場合、規定外の位置のカラムは認められないので
1ページ内のカラムはかならず規定数内に納まる。
*/
//myResult+='<!-- '+this.convert.currentPage+"//"+this.convert.currentSCID+"/"+this.convert.maxColumns+'>\n\n'
		if(this.convert.currentSCID >= this.convert.maxColumns){
			//ページフッタ出力してリセット
			this.convert.currentSubTotal+=(this.convert.currentPgDuration)*1;
		myResult +='</table>\n\t<div class="pageFooter">';
		myResult +='p'+nas.Zf(this.convert.currentPage,3);
		myResult +=' / '+nas.Frm2FCT(this.convert.currentSubTotal,2);
		myResult +=' ( '+nas.Frm2FCT((this.convert.currentPgDuration)*1,3);
		myResult +=')</div>\n<div class="pageDivider"></div>';
			this.convert.currentPage++;
			this.convert.currentPgDuration=0;
			this.convert.currentSCID=0;
		}else{
			//インクリメントはしない
			//this.convert.currentSCID++;
		}
	}
if(this.convert.hasSwitch){
	myResult+='<div class="titleHeader">'
	myResult+='<span id="pageCount">'+this.convert.currentPage+'</span>//';
	myResult+='<span id="columnCount">'+this.table.length+'</span>';
	myResult+='</div>'
};
	
if(this.convert.isFileSave){
	myResult+='</body></html>';
};//ファイル保存時のみ処理

break;
case	"csv":	;//
default:	;//
		myResult+='';
		for (var idx=0;idx<this.table.length;idx++){
			myResult+=this.table[idx].toString("csv");
		}
	}
	return myResult;//
};

//カットオブジェクト
function blankCut(){
//blankCut は、カット初期化用のダミーオブジェクト。
	this.parent	=null;//ストーリーボード
	this.index	=null;//コレクション内でのIndex 重複不可セッション中は固定
	this.name	=null;//カット番号編集OK 重複可能
	this.length	=0;//カット尺フレーム数
	this.duration	=0;//継続時間(トランジション時間を加えたもの)
	this.inPoint	=0;//
	this.columns	=[];//カラムコレクション配列
}

function Cut(myIndex,myParent,initColumn,myInPoint){
//Cut は、カラムのトレーラーであり、映画のカッティング単位です。
//イニシャルカラムで初期化するのはどうか？

	this.parent	=myParent;//ストーリーボード
	this.index	=myIndex;//コレクション内でのIndex 重複不可セッション中は固定
	this.name	=initColumn.cut;//カット番号編集OK 重複可能
	this.length	=(initColumn.sec2Fr())?initColumn.sec2Fr():0;//カット尺フレーム数
	this.duration	=0;//継続時間(トランジション時間を加えたもの)
	this.inPoint	=myInPoint;//
	this.columns	=new Array();//カラムコレクション配列
		initColumn.parentCut=this;
		this.columns.push(initColumn);
}
/*	カットオブジェクトのメソッド	*/
Cut.prototype.column=function(columnID){
	return this.columns[columnID];
	//カラム取得
}

Cut.prototype.addColumn=function(myColumn){
//他のカットに付属しているカラムを受け入れる時の処理を決めないと危ないので注意
	this.columns.push(myColumn);
	myColumn.parentCut=this;
	this.length+=(myColumn.sec2Fr())?myColumn.sec2Fr():0;
	//カラム追加メソッド
}
//このあたりのオブジェクトは不要　とか思っていたが復活

/*
function PageCollection(){
	this.width	=;//用紙バウンディングボックス横(pt)
	this.height	=;//用紙バウンディングボックス縦(pt)
};

function Page(){
//Pageは、カラムのトレーラーです
	this.index	=;//コレクション内でのIndex重複不可
	this.name	=;//ノンブルにつける番号編集OK 重複可能
	this.columns	=new ColumnsCollection();//カラムコレクション
	this.column=function(columnID){
		return this.columns[columnID];
	}
}

function Column(idx){
	this.index	=idx;//カラムID (通しID重複不可)
	this.subColumnId	=;//サブカラムID(ページ内ID ページ内重複不可)
	this.name	=;//カット番号(編集可 重複可能)
	this.parentPage	=;//親ページID オブジェクトの参照の方がよい?
	this.parent	=;//親カットID
	this.position	=[left,top];//カラムのページ内配置

	this.picture	=new Picture();//画像
	this.picture.path	=;//画像文字列
	this.picture.scale	=1;//xy固定スケール
	this.picture.size	=[width,height];//画像サイズ
	this.dialogText	="";//
	this.contentText	="";//
	this.timeText	="";//
//カラムは継続時間を持たない
//カットが、メンバーカラム内のタイムテキストを集計して時間をもつ
}


*/

//絵コンテコンバート用ピクチャークラス
/*
このクラスはFileクラスオブジェクトをHTML用にImageクラスで置き替え

*/
Picture = function(myParent,myPath){
//Windowsローカルパスだったら補正(ブラウザで読む為の第一補正)
//Unixタイプのパスは無視してそのまま保持
	if(myPath.match(/^[a-z]\:/i)){myPath="file:///"+myPath;};

//ドキュメントロケーションが "file:"でない場合は、
//"file:"または"//server/"で、ローカル画像を読みに行ってしまうのを防ぐ為に標準的なパスの場合(/.*\/img\/[^\.]\.png/i)のみ
//想定される相対パスに変換 (imgの前を "./"で置換) それ以外は、ブランクイメージと置き替え
	if((! mySB.convert.isLocal)&&(myPath.match(/^(file:\/\/.+|^\/\/.+)/))){
		if(myPath.match(/^[^\.].+(\/img\/[^\.]+\.(png|jpg|gif))$/i)){
			myPath="."+RegExp.$1;
		}else{
			myPath="./img/blank.gif";
		}
	}

//画像パスを与えて初期化する。なかったらカラobjectを返す。

//	this.file=new File(myPath);//アドビスクリプトファイルクラスで画像ファイルをセットする。空でもセット可能
//一般のブラウザ用にトレーラを作る
	this.file=myPath;//ブラウザ用に文字列で記録
	this.parent=myParent;//カラムオブジェクト
//ピクチャクラスにイメージオブジェクトをプロパティで付ける
	this.image=new Image();
	this.image.src=myPath;
};
//ねこらSBクラス しおりオブジェクト 単純に
function BookmarkNkr(myParent,idx)
{
	this.parent	=myParent;//ストーリーボードオブジェクトを設定
	this.index	=idx;//ID (通しID重複不可)
	this.name	="";//しおりの名前(編集可 重複可能)
	this.key	="";//キー値
	
}
BookmarkNkr.prototype.parentColumn=function(){
	for(var idx=0;idx<this.parent.table.length;idx++){
		if(this.key==this.parent.table[idx].key){return this.parent.table[idx];}
;//キーをサーチして相当するカラムオブジェクトを返す
	}
	return null;//検索不成功
}
//ブックマーク書き出しメソッド
BookmarkNkr.prototype.toString =function(Mode)
{
	var myResult="";
	switch(Mode){
case	"sbd":;
	myResult	+="<mark>";
	myResult	+="<name>"+this.name+"</name>";
	myResult	+="<point>"+this.key+"</point>";
	myResult	+="</mark>";
break;
case	"html":;
		myResult+='<option value="'+this.key+'"';
		myResult+='>'+this.name+'</a><br/>';
break;
case	"csv":;
		myResult+='"'+this.name+'","'+this.key+'"'+"\n";
default	:
	}
	return myResult;
}

//カラムを束ねてカットを記述するクラス
/*すでにあるコンストラクタを書き直すこと*/
//ねこらSBクラスのカラムオブジェクト
/*
	必要以上のプロパティは持たない
*/

function ColumnNkr(myParent,idx){
	this.parentCut	=[];//空カットで初期化(所属カットが無い)
	this.parent	=myParent;//.paretn;//ストーリーボードオブジェクトを設定
	this.index	=idx;//カラムID (通しID重複不可)
	this.cut	="";//カット番号(編集可 重複可能)
	this.img	=new Image();//new Picture();//画像オブジェクト
		this.img.parent=[];
	this.desc	="";//
	this.words	="";//
	this.sec	="";
	this.total	="";//いらない? …とりあえず
	this.key	="";//キー値

//この下は変換用の一時プロパティとして…いらないかも

	this.subColumnId	=0;//サブカラムID(ページ内ID ページ内重複不可)
//	this.position	=[left,top];//カラムのページ内配置
/*
	this.contentText	=this.desc;//互換があるので放置しても良さそう。
	this.dialogText	=this.words;//
	this.timeText	=this.sec;//
*/
}

//
/*
	ねこらSBの秒記述をnas互換のTCまたはフレームで出力するメソッド
	sec2Tc(テキスト)	TC(3番固定)に変換
	sec2Fr(テキスト)	フレーム数で返す
*/
ColumnNkr.prototype.sec2Tc=function(){
	if(this.sec.match(/^([0-9]+)?(\.([0-9]+))?(\+([0-9]+)?)?$/))
	{
		var myFrames=(RegExp.$1*this.parent.frameRate)+(RegExp.$3*1)+(RegExp.$5*1)
		return (myFrames)? Math.floor(myFrames/this.parent.framerate)+"+"+myFrames%this.parent.framerate:"";
	}else{	return "";}
}
ColumnNkr.prototype.sec2Fr=function (body){
	if(this.sec.match(/^([0-9]+)?(\.([0-9]+))?(\+([0-9]+)?)?$/))
	{
		var myFrames=(RegExp.$1*this.parent.frameRate)+(RegExp.$3*1)+(RegExp.$5*1)
		return Math.floor(myFrames);
	}else{	return 0;}
}
//	カラムを各種形式で書き出すメソッド
ColumnNkr.prototype.toString=function(outputMode)
{
	var myResult="";
	switch(outputMode){
case	"sbd":	;//nekoraSBDモード 要するに書き戻し時につかう 値が無い場合を処理シナハレ
myResult +="<tr>";
myResult +="<cut>"+this.cut+"</cut>";
myResult +="<img>"+this.img.file+"</img>";
myResult +="<desc>"+this.desc+"</desc>";
myResult +="<words>"+this.words+"</words>";
myResult +="<sec>"+this.sec+"</sec>";
myResult +="<total/>";
myResult +="<key>"+this.key+"</key>";
myResult +="</tr>";
break;

case	"html":	;//HTMLモード 納品用HTML
/*
	このモードがHTMLコンバータなのであとで成形する
	AEでフッテージとして読み込んだ画像ファイルのサイズを取得して
	画像の表示サイズを決定して必要に応じて複数のテーブルレコードを出力する。
	現在のカラム消費をオリジナルのオブジェクトに記録するか?
	それとも制限値を引数にして書き出しをかけるか?

	とりあえず一時プロパティに開始カラムをセットして表示をかけることにする
	contentsプロパティ内部に擬似コマンド(改ページタグ=<break>)を埋め込んで強制改ページ可能にする。


	標準サイズ外の画像の場合は、以下の表示規則で表示
	テキストと画像は画像優先で、テキストにヨコナガ画像がかぶったら、テキストを押し出して表示するのではなく
	テキストをけす。(隠れそうならユーザが次のカラムにテキストを移す。)
	カラムが縦に拡張された場合は、カラムのサイズを整数倍で拡張して画像を表示(次のカラムに影響しない)。
	画像の脇のテキストは通常のテキストよりも表示範囲が増える。(横罫線は、用紙に印字した以外はなくなる。)
	テーブルrowは消費(カット番号とタイム欄は切る) SBカラムは消費。
 */
//画像は 1レコード内におさまるか? 単位はすべてポイント(dtp-point)
	var hasContents	=(this.contents!="")?	true:false;
	var hasDialog	=(this.dialog!="")?	true:false;
	var maxWidth	= this.parent.convert.pageWidth;
	var maxHeight	=(this.parent.convert.maxColumns-this.parent.convert.currentSCID)*this.parent.convert.columnHeight;//現在使用可能な最大高さdtp-point
	var unitWidth	=this.parent.convert.columnWidth;//単位幅はテキストの有無で変化
	var dummyResolution	= Math.floor(72*this.parent.convert.drawWidthPx/(this.parent.convert.columnWidth*this.parent.convert.pictureMargin));

		if(! hasContents){
			unitWidth+=this.parent.convert.contentsWidth;
			if(! hasDialog){ unitWidth+=this.parent.convert.dialogWidth;};
		};//テキストがなかったら使用幅を増やす
	var unitHeight	=this.parent.convert.columnHeight;

//imgオブジェクトがカラの場合は固定処理で空テーブルデータを挿入

//if(! (this.img.image instanceof Image))
if(! (this.img.image))
	{
	var myWidth = this.parent.convert.columnWidth ; var myHeight = this.parent.convert.columnHeight;
	var myImgColspan=1;
	var myImgRowspan=1;
	var myImgPath="";

	}else{
if(((this.img.image.width*72/dummyResolution) <= unitWidth) && ((this.img.image.height*72/dummyResolution) <= unitHeight)){
//ヒトコマモノなので問題ない
	var myWidth = this.img.image.width*72/dummyResolution ; var myHeight = this.img.image.height*72/dummyResolution;
	if(myWidth<=0) {myWidth  = this.parent.convert.columnWidth };//サイズを0にしない
	if(myHeight<=0){myHeight = this.parent.convert.columnHeight};
}else{

//コマまたぎなのでちょっと占有率を計算
//	var isWide	=(this.img.image.width/this.img.image.height >= this.parent.frameAspect)?true:false;//正比率はワイドに組み入れ
	var isResize	=(((this.img.image.width*72/dummyResolution)>maxWidth)||((this.img.image.height*72/dummyResolution)>maxHeight))? true:false;//規定解像度で納まるか?

//規定解像度以上の場合は最大幅に納まるように縮小する
//ここで表示用の width heightプロパティを決定

	if(isResize){
		var myScaleW=(((this.img.image.width*72/dummyResolution)/maxWidth)>1)? maxWidth/(this.img.image.width*72/dummyResolution):1;	//横オーバー時のスケール
		var myScaleH=(((this.img.image.height*72/dummyResolution)/maxHeight)>1)?maxHeight/(this.img.image.height*72/dummyResolution):1;	//縦オーバー時のスケール
		var myScale=(myScaleH < myScaleW)?myScaleH:myScaleW;	//採用スケール

		var myWidth =myScale*this.img.image.width *72/dummyResolution;var myHeight=myScale*this.img.image.height*72/dummyResolution;
	}else{
		var myWidth=this.img.image.width*72/dummyResolution;var myHeight=this.img.image.height*72/dummyResolution;//リサイズなしなら標準値
	};
}

//画像の消費面積を消費 colspan/rowspan に換算
	var myImgColspan=1;
		if(myWidth>this.parent.convert.columnWidth){myImgColspan=(myWidth<=this.parent.convert.columnWidth+this.parent.convert.contentsWidth)?2:3};
	var myImgRowspan=Math.ceil(myHeight/unitHeight);//最少1 最大 5

if(this.img.file){
	var myImgPath=this.img.file;
}else{
	var myImgPath=this.img.file;
}

//alert("SCID"+this.parent.convert.currentSCID)

	}
//メモ コメント抑制中
//myResult +='\n\n<!-- '+this.parent.convert.currentSCID+" :: "+myWidth +"/ "+this.parent.convert.columnWidth+' :colspan: '+myImgColspan+'>\n';

/*
	画像を表示するアルゴリズム

	画像の解像度は標準か?否か
		縦 または 横のサイズが標準解像度の10%(+-5%)誤差以下ならば標準解像度と見なす。
		その場合は、単純に横長・縦長を判定して標準解像度から計算した width および height プロパティを
		つけた img タグでおくり出す。
	標準解像度外の画像は、大サイズは大判扱い 少サイズは拡大表示(標準) で処理
		大判、縦長、横長の画像は、現在の表示位置から計算した最大表示範囲にたいして
		標準解像度で納まるサイズか否かがまず評価される。
		表示可能なかぎり標準解像度で表示して、 納まらない場合は表示範囲内にリサイズされる。

	画像は縦長か?横長か? ( this.width/this.height< this.parent.frameAspect )? タテナガ : ヨコナガ
	(この式はピクセルアスペクトが考慮されてないので正方ピクセルのみで適用)

	暫定的に画像を192dpiとして扱う(2008/02/24)今回の印刷用
*/

//rowspan 分だけtable行を出力

for(var outputR=0;outputR<myImgRowspan;outputR++){
	myResult +='\n\t<tr>';
//最初の1ループのみ画像を出力
	if(outputR==0){
myResult +='\t\t<td class="columnLabel"';
myResult +=' id="'+nas.Zf(this.parent.convert.currentPage,3)+'_'+this.parent.convert.currentSCID.toString();
myResult +='" key="'+ this.key;
	
	var myTc=this.sec2Tc();
	var myFrames=this.sec2Fr()//

myResult +='" frames="'+ myFrames +'" ';
		if(this.cut==""){
//			myResult +='\t\t<td class="columnLabel">/<br/></td>';
			myResult +='>/<br/></td>';
		}else{
//			myResult +='\t\t<td class="columnLabel" id="ci'+this.index+'"><span class="cutNm">'+this.cut+'</span><br/></td>';
			myResult +='><span class="cutNm">'+this.cut+'</span><br/></td>';
		}
		var RSPN =(myImgRowspan>1)?'rowspan="'+myImgRowspan+'" ':'';

		myResult +='\n\t\t<td class="pictureArea" '

		if(this.img.file){
			myResult += RSPN+'><a href="'+myImgPath+'" target="sbd_picture"><img border="0" width="'+Math.round(myWidth*96/72);
			myResult += '" height="'+Math.round(myHeight*96/72)+'" src="'+myImgPath+'" /></a></td>';
		}else{
			myResult += RSPN+'><br/></td>';
		}

//表示可能ならcontents/dialogを表示//あとで成形サブルーチンを通しても良いかも？
		myResult +='\n\t\t<td class="contents"'+RSPN+'>'+replaceStr(this.desc).replace(/&lt;break&gt;/g,"")+'<br/></td>';
		myResult +='\n\t\t<td class="dialog"  '+RSPN+'>'+replaceStr(this.words)+'<br/></td>';
		myResult +='\n\t\t<td class="timeText" '+RSPN+'><br/>'+myTc+'</td>';
		this.parent.convert.currentPgDuration+=myFrames;//カット尺表示時にサブトータル加算
	}else{
myResult +='\t\t<td class="columnLabel" id="'+nas.Zf(this.parent.convert.currentPage,3)+'_'+(this.parent.convert.currentSCID+outputR).toString()+'" key="">/<br/></td>'
//		myResult +='\n\t\t<td class="columnLabel">/<br/></td>';		
	}
	myResult +='\n</tr>';
}
//	消費したカラムを更新
	this.parent.convert.currentSCID+=myImgRowspan;
break;

case	"csv":	;//csvモード
default	:	;//デフォルトはcsvモードで(htmlかも…)
myResult += this.cut+',"'
if(this.img.file) myResult += this.img.file;
myResult +='","'+encodeURI(this.desc)+'","'+encodeURI(this.words)+'","'+this.sec2Fr()+'",,"'+this.key+'"\n';
	}
	return myResult;
}
/*
	引数文字列内の特定記法の文字列を置換
[[wikiタイプか]] または
	
*/
function replaceStr(myString){
	var myResult=myString;
//後で調整の余地あり 縦書き欲しいかも?
	myResult=myResult.replace(/\[\[((http|ftp|mailto):[^\[\]\ ]+)\]\]/g,"<a href=\"$1\">$1</a>");
	myResult=myResult.replace(/\&amp\;link\(([^\,]+),((http|ftp|mailto):.+)\)/g,"<a href=\"$2\">$1</a>");
	myResult=myResult.replace(/\&amp\;font\(([^\,]+),([1-7])\)/g,"<font size=\"$2\">$1</font>");
	myResult=myResult.replace(/\&amp\;strong\((.+)\)/g,"<strong>$1</strong>");
//これは最後に
	myResult=myResult.replace(/\n/g,"<br/>");//改行を<br/>に
	return myResult;
}
/*
	主な機能
*/

function loadData(){
	return new Ajax.Request(
		url, 
	{
		method: 'get', 
		onComplete: parseData
	});

}
function parseData(request){
	if(!request){request=myAjax};
	var myContent= request.transport.responseText;
	mySB=new StoryBoard();
	var columnCount = mySB.parseSBD(myContent);
document.title=mySB.title;
//	mySB.viewCashStatus();
	viewCashStatus(mySB);
	return true;
	}
/*
	ブラウザ用画像キャッシュ取得待ちメソッド
画像サイズ計算を行う為に画像がすべてメモリにキャッシュされている必要がある。
このメソッドの取得待ちが終わってからコンバート可能
*/

//function viewCashStatus(){mySB.viewCashStatus()};

function viewCashStatus(myStoryBoard){
    var count = 0;
    var msg   = "";

    for(var idx = 0; idx < myStoryBoard.table.length; idx++){
//      if(( myStoryBoard.table[idx].img.image instanceof HtmlImage )&&(myStoryBoard.table[idx].img.image.complete)) {count++;};
      if((myStoryBoard.table[idx].img.image)&&(myStoryBoard.table[idx].img.image.complete)) {count++;};
    }
    msg += myStoryBoard.convert.imageCount + "件中" + count + "件完了";
   if(count == myStoryBoard.convert.imageCount){
    msg += ":画像キャッシュがすべて完了しました。コンバート可能です。";
    }
    showMsg(msg);
    if(count < myStoryBoard.convert.imageCount){
     setTimeout(viewCashStatus, 1000);
    }
}

function convertData(){
	if(!$("sbdBody")){return}
	$("sbdBody").innerHTML=mySB.toString("html");
	if(! mySB.convert.isFileSave){
		$("bookmarks").innerHTML=mySB.bookmarks.toString("html");
	};//ファイルモードの時は実行しない
}
function startupQueue(){
		//プレイヤオブジェクトがあれば キューを構成する
	if(queueBox){
		queueBox=makeQueue(mySB);
		timeSlider.init();
		if(mySB.convert.frameAspect!=(nas.decodeUnit($("clipFrame").style.width,"px")/nas.decodeUnit($("clipFrame").style.height,"px"))){
			$("clipFrame").style.height=Math.floor(nas.decodeUnit($("clipFrame").style.width,"px")/mySB.convert.frameAspect)+"px";
		}
		nas_Action_Startup();
	}
}
function reloadCurrent(){

		myAjax =new Ajax.Request(
			url, 
		{
			method: 'get', 
			onComplete: updateSB
		});
}

function updateSB(){convertData(parseData(myAjax));}

function printBorder(stat){
if(!stat){stat="visible"};
	switch (stat){
case	"hide":;
	nas.addCssRule("table","border-style:none;border-width:0pt","print");//テーブルの罫線を消す
	nas.addCssRule("tr","border-style:none","print");//tr
	nas.addCssRule("th","border-style:none","print");//th
	nas.addCssRule("td","border-style:none","print");//td
	nas.addCssRule("tr.pageHeader","display:none","print");//ページヘッダ
	nas.addCssRule(".cutNm","display:none","print");//カット番号
//	nas.addCssRule();//
break;
default	:;
	nas.addCssRule("table","border-width:3pt;border-style:solid","print");//テーブルの罫線を消す
	nas.addCssRule("tr","border-style:solid","print");//tr
	nas.addCssRule("th","border-style:solid","print");//th
	nas.addCssRule("td","border-style:solid","print");//td
	nas.addCssRule("tr.pageHeader","display:inline","print");//ページヘッダ
	nas.addCssRule(".cutNm","display:block","print");//カット番号

	}
}
/*	暫定版データエコーCGI 呼び出し
	簡易CGIをコールしてファイルを保存
	拡張子をキーに与えてそれでデータ種別を切り換えている
 */

function callEcho(myExt)
{
	if(! ServiceUrl){ServiceUrl="http://hpcgi2.nifty.com/Nekomata/remaping/rmpEcho.cgi?";}
	if(! myExt){myExt="txt";};
	document.saveXps.action=ServiceUrl+'COMMAND=save&';
	mySB.convert.isFileSave=true;//関連するのはhtml時のみ
	document.saveXps.XPSBody.value=encodeURI(mySB.toString(myExt));
	mySB.convert.isFileSave=false;//関連するのはhtml時のみ
	document.saveXps.XPSFilename.value=encodeURI(mySB.title.toString())+'\.'+myExt;
	document.saveXps.submit();
}

/*	main()	*/
//　URLを設定ファイルから取り込んで画面に表示 
	var urls = (targetURL instanceof Array)? targetURL:[targetURL];
		urls.isHold=function(myTarget){
			var myResult=false;
			for(var idx=0;idx<this.length;idx++){if(this[idx]==myTarget){myResult=true;break;};};
			return myResult;//配列内に指定値があればtrue
		}
	var url  = urls[0];//第一要素を初期値に
	var mySB=new StoryBoard();
	var myAjax=new Object();
if(autoSwitch){
	myAjax = new Ajax.Request(
		url, 
	{
		method: 'get', 
		onComplete: parseData
	});
}


