/*
 *	nas 簡易GUIライブラリ
 *
 *	$Id: nas_GUIlib.js,v 1.38.4.25 2009/10/08 12:21:56 nori Exp $
 *	AE等のAdobe Script 環境で比較的平易なGUI記述をサポートします。
 *	nas.GUI.Grid(left,top,width,height)::returns [bounds-Array]
 *	パネル動作に対応開始 2007/08/09
 *	パレットに最小化機能作成 2007/08/21
 */
 myFilename=("$RCSfile: nas_GUIlib.js,v $").split(":")[1].split(",")[0];
 myFilerevision=("$Revision: 1.38.4.25 $").split(":")[1].split("$")[0];

// 
/*
try {
	nas.Version["GUI-lib"]="GUI-lib:"+myFilename+" :"+myFilerevision;
}catch(err){
	alert("nasツールの読み込みに失敗しました。");
}
*/

	nas.Version["GUI-lib"]="GUI-lib:"+myFilename+" :"+myFilerevision;

// GUI Setup
	nas["GUI"] = new Object();
// セッティング取り込み
	if(app.settings.haveSetting("nas","winOffset"))
	{
	nas.GUI.winOffset=eval(app.settings.getSetting("nas","winOffset"));
	}else{
	nas.GUI.winOffset=new Object();
	}
	if(app.settings.haveSetting("nas","currentFolder"))
	{
	nas.GUI.currentFolder=new Folder(app.settings.getSetting("nas","currentFolder"));
	}else{
	nas.GUI.currentFolder=Folder.current;
	}
/*
チョト考慮中まだsetteigsには入れない 01/26
そもそもsettingsに記録するならpath_Stringにしておかないとまずそう。
	if(app.settings.haveSetting("nas","workBases"))
	{
	nas.GUI.workBases=eval(app.settings.getSetting("nas","workBases"));
	}else{
	nas.GUI.workBases=new Object();
	}
 */
//シャットダウン処理
nas.GUI.shutdown=function()
	{
		app.settings.saveSetting("nas","winOffset",nas.GUI.winOffset.toSource());
		app.settings.saveSetting("nas","currentFolder",nas.GUI.currentFolder.fsName);
	};
//簡易GUIライブラリ 基礎プロパティ
	nas.GUI.leftMargin=4;
	nas.GUI.rightMargin=4;
	nas.GUI.topMargin=2;
	nas.GUI.bottomMargin=10;

	nas.GUI.leftPadding=8;
	nas.GUI.rightPadding=8;
	nas.GUI.topPadding=2;
	nas.GUI.bottomPadding=2;

	nas.GUI.colUnit=60;
	nas.GUI.lineUnit=26;

	nas.GUI.defaultWinsize=[8,6];//指定なしの場合のウィンドウサイズ(unit)
	nas.GUI.dafaultOffset=[240,40];//指定なしの場合のウインドウ初期位置(px)
	nas.GUI.defaultName="No Name";//ウインドウタイトルデフォルト

//GUI要記録設定
//	nas.GUI.currentFolder=Folder.current;//最終アクセスフォルダ
	nas.GUI.prevCurrentFolder=Folder.current;//AEサイド最終アクセスフォルダ退避用オブジェクト
//作業ベースヒストリ保存オブジェクト パスを文字列(fsName)で格納 プラットフォーム依存
//設定移行不能 読み込み時に無効フォルダを捨てる処理検討
	nas.GUI.workBase=new Array();//
//		ヒストリ保存数はここで設定 ?
		nas.GUI.workBase[0]=Folder(nas.GUI.currentFolder.path).fsName;//ひとつ上

		nas.GUI.workBase.maxLength=4;//最大値
		nas.GUI.workBase.selected=0;//現在のフォルダ
		nas.GUI.workBase.current= function()
		{
			return this[this.selected];//カレントを返す
		};
		nas.GUI.workBase.insert= function(newFolder)
		{
	//既存のエントリに同じフォルダがあればそれをアクティブにして終了
	//引数はオブジェクトと文字列両方を受け入れ
			if (newFolder instanceof Folder)
			{
				newFolder=newFolder.fsName;
			};
			for(id=0;id<this.length;id++)
			{
				if(newFolder == this[id])
				{
					this.selected=id;return this[id];
				};
			};
	//ループ抜けたら新規フォルダなのでエントリを追加
			this[(this.selected+1)%this.maxLength]=newFolder;
			this.selected=(this.selected+1)%this.length;
			return this[this.selected];//挿入
		};
		nas.GUI.workBase.change= function()
		{
			this.selected=(this.length+this.selected-1)%this.length;
			return this[this.selected];//ひとつズラす
		};

//	nas.GUI.winOffset=new Object();//ウィンドウオフセット記録オブジェクト

var isWindows=(system.osName.match(/Windows/))? true : false;

if(isWindows){
	nas.GUI.LineFeed="\x0d\x0a";
}else{
	nas.GUI.LineFeed="\x0d";
};
	nas.GUI.quartsOffset=(isWindows)? 0:3;//Macの場合4pxボタン等の高さを減ずる

/*
	edittextに初期状態で256バイトでペーストや手入力が打ち止めになる現象がある。
	スクリプトでのデータ追加を行うと動的にメモリが確保されているようなので、
	これは、edittextに無理やり空白を追加してフラッシュするメソッド。
	このバグが解消したら不要。	引数はループ回数。1回アタリ1kb
*/
nas.GUI.addBuf_ = function (KB)
{
	var xStr="";
	for(m=0;m<KB;m++){for(n=0;n<1024;n++) xStr+=" "};
	this.text +=xStr;
	this.text ="";
	return this.text;
};

//エレメントのスクリーン座標を返す関数

nas.GUI.screenLocation=function(baseObject){
	var myX=0;
	var myY=0;
	targetObject=baseObject;
	while (targetObject){
		myX+=targetObject.bounds.x;
		myY+=targetObject.bounds.y;
		targetObject=targetObject.parent;
	}
	return [myX,myY];
}

//グリッド位置計算メソッド(bounds配列を返す)
nas.GUI.Grid = function (col,line,width,height,parent){
var M=(parent.type=="panel")?0:1;
	left	= (col * this.colUnit) + this.leftMargin*M + this.leftPadding;
	top	= (line * this.lineUnit) + this.topMargin*M + this.topPadding;
	right	= left*1 + width*this.colUnit - this.rightPadding -this.leftPadding;
	bottom	= (height <= this.lineUnit) ?
top*1 + height*this.lineUnit - this.bottomPadding - this.topPadding - this.quartsOffset : top*1 + height*this.lineUnit - this.bottomPadding - this.topPadding;

//	alert( [left,top,right,bottom]);
	return [left,top,right,bottom];
};

//ウインドウ作成メソッド(AE専用?ダイアログとパレットしかできません)
nas.GUI.newWindow = function (Type,Name,width,height,offsetX,offsetY) {
// alert(this.parent.toString())
	Type=(Type=="dialog")? "dialog":"palette";
	if(! Name){Name=nas.GUI.defaultName;};
	if(! width){width=nas.GUI.defaultWinsize[0];};
	if(! height){height=nas.GUI.defaultWinsize[1];};
	if(! offsetX){offsetX=nas.GUI.dafaultOffset[0];};
	if(! offsetY){offsetY=nas.GUI.dafaultOffset[1];};

	var resultWin=new Window(Type,Name,[offsetX,offsetY,offsetX+width*this.colUnit+this.leftMargin+this.rightMargin,offsetY+height*this.lineUnit+this.topMargin+this.bottomMargin]);
	if(Type=='palette'){
//パレットの場合だけウィンドウタイトルをラベルで表示する。
if(app.version.split(".")[0]>=6){
	resultWin.titleLabel=resultWin.add
		(
		"button"
		,[	this.leftMargin+this.leftPadding,
			this.topMargin+this.topPadding,
			width*this.colUnit-(this.leftPadding+this.rightPadding),
			this.lineUnit-(this.topPadding+this.bottomPadding)
		],
		Name
		);
	resultWin.titleLabel.minimize=false;
//ボタンに最小化機能をつける
	resultWin.titleLabel.onClick=function(){
var bods=this.parent.bounds;
//writeLn(bods);

this.backupBaoundsLeft=this.parent.bounds.left;
this.backupBaoundsTop=this.parent.bounds.top;

//writeLn([this.parent.bounds.left,this.parent.bounds.top].toString());

		if(this.minimize){

			myBounds=[
				this.backupBaoundsLeft,
				this.backupBaoundsTop,
				this.backupBaoundsLeft+this.backupBaoundsWidth,
				this.backupBaoundsTop+this.backupBaoundsHeight
			];

//this.parent.bounds.width	=this.backupBaoundsWidth;
//this.parent.bounds.height	=this.backupBaoundsHeight;
			this.minimize=false;
		}else{
			this.backupBaoundsWidth=this.parent.bounds.width;
			this.backupBaoundsHeight=this.parent.bounds.height;

			myBounds=[
				this.backupBaoundsLeft,
				this.backupBaoundsTop,
				this.backupBaoundsLeft+(this.bounds.width+this.bounds.left*2),
				this.backupBaoundsTop+(this.bounds.height+this.bounds.top*2)
			];

//this.parent.bounds.width	=(this.bounds.width+this.bounds.left*2);
//this.parent.bounds.height	=(this.bounds.height+this.bounds.top*2);

			this.minimize=true;
		}
//this.parent.bounds.left	=this.backupBaoundsLeft;
//this.parent.bounds.top	=this.backupBaoundsTop;
//	writeLn(bods.toString()+" : "+this.parent.bounds.toString());

	this.parent.bounds=myBounds;
if(bods[0]!=this.parent.bounds[0])
{
	this.parent.bounds=myBounds;
	writeLn("エラー検知/調整しました")
};//AE8のバグ回避 値の再入力で何とかなる?
	};//最少化関数オワリ

	}else{
	resultWin.titleLabel=resultWin.add
		(
		"statictext"
		,[	this.leftMargin+this.leftPadding,
			this.topMargin+this.topPadding,
			width*this.colUnit-(this.leftPadding+this.rightPadding),
			this.lineUnit-(this.topPadding+this.bottomPadding)
		],
		Name
		);
}
	resultWin.titleLabel.justify='right';
		}
	return resultWin;
}
//ボタン作成メソッド
nas.GUI.addButton = function (Parent,Label,left,top,width,height){
return Parent.add("button",this.Grid(left,top,width,height,Parent),Label);
};

//チェックボックス作成メソッド
nas.GUI.addCheckBox = function (Parent,Label,left,top,width,height){
return Parent.add("checkbox",this.Grid(left,top,width,height,Parent),Label);
};
//ラジオボタン作成メソッド
nas.GUI.addRadioButton = function (Parent,Label,left,top,width,height){
return Parent.add("radiobutton",this.Grid(left,top,width,height,Parent),Label);
};

//staticText作成メソッド
nas.GUI.addStaticText = function (Parent,Text,left,top,width,height){
if(height>1){
return Parent.add("statictext",this.Grid(left,top,width,height,Parent),Text,{multiline:true});
}else{
return Parent.add("statictext",this.Grid(left,top,width,height,Parent),Text);
}
};
//EditText作成メソッド
nas.GUI.addEditText = function (Parent,Text,left,top,width,height){
	if(height>1){
return Parent.add("edittext",this.Grid(left,top,width,height,Parent),Text,{multiline:true});
	}else{
return Parent.add("edittext",this.Grid(left,top,width,height,Parent),Text,{multiline:false});
	}
};
//ScrollBar作成メソッド
nas.GUI.addScrollBar = function (Parent,Value,minValue,maxValue,left,top,height,align){
if(!align){align="right";};
switch(align){
case	"center"	:
	var alignOffset=(this.colUnit-this.lineUnit*.7)/2 -this.leftPadding;break;
case	"left"	:
	var alignOffset=0;break;
case	"right"	:;
default :
	var alignOffset=this.colUnit-(this.lineUnit*.7)- this.leftPadding;
//	 -this.leftPadding;
}
var barBaunds=this.Grid(left+alignOffset/this.colUnit,top,this.lineUnit/this.colUnit,height,Parent);

return Parent.add("scrollbar",[barBaunds[0],barBaunds[1],barBaunds[0]+Math.round(this.lineUnit*.5),barBaunds[3]],Value,minValue,maxValue);
};
//Slider作成メソッド
nas.GUI.addSlider = function (Parent,Value,minValue,maxValue,left,top,width,align){
if(!align){align="middle";};
switch(align){
case	"top"	:var alignOffset=0;
case	"bottom"	:var alignOffset=1;
case	"middle"	:;
default:var alignOffset=0.5;
}
return Parent.add("slider",this.Grid(left,top+alignOffset,width,0.7,Parent),Value,minValue,maxValue);
};

//Panel作成メソッド
nas.GUI.addPanel = function (Parent,Label,left,top,width,height){
return Parent.add("panel",[left*this.colUnit+this.leftMargin,top*this.lineUnit+(this.lineUnit/2),(width+left)*this.colUnit+this.leftMargin,(top+height)*this.lineUnit+this.topMargin],Label);
}

//複合コントロール SelectButton
nas.GUI.addSelectButton = function (Parent,Label,Select,left,top,width,height)
{
	var mySB = Parent.add("button",this.Grid(left,top,width,height,Parent),"");//ボタン初期化(文字なし)
	if(Label instanceof Array){
		mySB.options= Label;
	}else{
		mySB.options= new Array();mySB.options[0]=Label;
	}
	mySB.selected = (Select>=mySB.options.length || Select<0 || isNaN(Select))?
	0	:	Math.floor(Select)	;
	mySB.value=mySB.options[mySB.selected];
	mySB.text=mySB.value;//ボタン表示

	mySB.select=function(aRg){
	if(! aRg && aRg != 0) aRg=this.selected;
if(isNaN(aRg)){
	switch (aRg){
case	"enable":
	this.enabled=true;break;
case	"disable":
	this.enabled=false;break;
case	"prev":
	this.selected=Math.abs(this.selected-1)%this.options.length;
	this.text=this.options[this.selected];break;
	this.value=this.options[this.selected];
case	"next":
default	:
	this.selected=(this.selected+1)%this.options.length;
	this.text=this.options[this.selected];
	this.value=this.options[this.selected];
	}
}else{
	this.selected=Math.abs(Math.floor(aRg) % this.options.length);
	this.text=this.options[this.selected];
	this.value=this.options[this.selected];
}
	this.onChange();
	};
//mySB.onClick= function(){this.select("next");};
mySB.onClick= function(){
	var myLocation=nas.GUI.screenLocation(this);
	this.select(nas.GUI.selectOptions(
		this.options,
		this.selected,
		this
	));
};
//mySB.onClick= function(){nas.GUI.selectOptions(this.options,this.selected,this.bounds[0],this.bounds[1],(this.bounds[2]-this.bounds[0])/nas.GUI.colUnit,this.);};
mySB.onChange=function(){return;};
return mySB;
}
/* AE8以降のネイティブDropDownList
 *
 * addDropDownList = function (親,オプション,選択ID,X,Y,幅,高さ,動作オプション)
 *	親 : 
 *	オプション : 
 *	選択状態 :
 *	X,Y :
 *	幅,高さ :**高さはリスト表示段数
 *	動作オプション : 
 *  オリジナルのドロップダウンリストを設定する。ネイティブ動作する
 *	元のnasセレクトボタンは別オブジェクトとして維持する
 */
nas.GUI.addDropDownList = function (Parent,Options,Select,left,top,width,height,props)
{
		if(!(Options instanceof Array)) {
		Options=[Options];
	}
		if(!(Select)){
	var multiSelect=true;
		}else{
	var multiSelect=false;	Selected=[Selected];
		}
		if(! props){
	var myDDL = Parent.add("dropdownlist",this.Grid(left,top,width,height,Parent),Options);	
		}else{
	var myDDL = Parent.add("dropdownlist",this.Grid(left,top,width,height,Parent),Options,props);	
		}
		if(! isNaN(Select)){
			myDDL.items[Select].selected=true;
		}
	return myDDL;
}
/* AE8以降のネイティブListBox
 *
 * addListBoxO = function (親,オプション,選択状態,X,Y,幅,高さ,動作オプション)
 *	親 : 
 *	オプション : 
 *	選択状態 :
 *	X,Y :
 *	幅,高さ :**高さはリスト表示段数
 *	動作オプション : 
 *  オリジナルのリストボックスを設定する。こちらはネイティブ動作する
 *	元のnasリストボックスはAE8以降ではラッパとして動作する
 */
nas.GUI.addListBoxO = function (Parent,Options,Selected,left,top,width,height,props)
{
		if(!(Options instanceof Array)) {
			Options=[Options];
		}
		if(Selected instanceof Array){
			var multiSelect=true;
		}else{
			var multiSelect=false;	Selected=[Selected];
		}
		if(! props){
	var myLB = Parent.add("listbox",this.Grid(left,top,width,height,Parent),Options);	
		}else{
	var myLB = Parent.add("listbox",this.Grid(left,top,width,height,Parent),Options,props);	
		}
		if(Selected.length>0){
	for(var slIdx=(Selected.length-1);slIdx>=0;slIdx--){
		for(itmIdx=0;itmIdx<myLB.items.length;itmIdx++){
		if(myLB.items[itmIdx].index==Selected.slIdx){myLB.items[itmIdx].selected=true;}
		}
	};
		}
	return myLB;
}
/*	複合コントロール ListBox
 *
 * addListBox = function (親,オプション,選択状態,X,Y,幅,高さ,動作オプション)
 *	親 : 
 *	オプション : 
 *	選択状態 :
 *	X,Y :
 *	幅,高さ :**高さはリスト表示段数
 *	動作オプション : 
 */
nas.GUI.addListBox = function (Parent,Options,Selected,left,top,width,height,option)
{
// AE7以前は元のコード　以降は本来のリストボックスを使用
	var newUI=false;
	if((app.version.toString().split(".")[0]*1)>=9){newUI=true;}

//リストボックスの配列数は自由・表示エレメント数は height
	if(!(Options instanceof Array)) {
		Options=[Options];
	}
	if(Selected instanceof Array) 
	{
		//selected引数の入力形式 [index,index,in...] / index / null を
		//内部形式(ブーリアンの配列)に揃える
			new_selected=new Array(Options.length);
		for(idx=0;idx<Options.length;idx++)
		{
			new_selected[idx]=false;
		}
		for(idx=0;idx<Selected.length;idx++)
		{
			if((! isNaN(Selected[idx])) && Selected[idx]<new_selected.length && Selected[idx]>=0 )
			{
				new_selected[Math.floor(Selected[idx])]=true;
			}
		}
		Selected=new_selected;
	}else {
		if(isNaN(Selected) || Selected==null ||Selected >= Options.length || Selected < 0)
		{
			Selected=new Array(Options.length);
			for(idx=0;idx<Selected.length;idx++)
			{
				Selected[idx]=false;
			}
		}else{
			var new_selected=new Array(Options.length);
			for(idx=0;idx<new_selected.length;idx++)
			{
				new_selected[idx]=(idx==Selected)?true:false;
			}
			Selected=new_selected;
		}
	}
//親パネル設定(新旧どちらのUIでもパネルは使用する)
	var myLB =nas.GUI.addPanel(Parent,"",left,top,width,height+.5);
//プロパティ
		// myLB.value ;//
		// myLB.selected ;// ここでは初期化しないがリストしておく
		myLB.multiSelect =(option=="multiselect")?true:false;//マルチセレクトフラグ
		myLB.editable =(option=="editable")?true:false;//?
		myLB.DisplayHeight =height;//表示最大高さ
//ラベルテキスト(編集可能な場合のみ作成)コンボボックス用
		if(myLB.editable){
			myLB.bounds=[left*this.colUnit+this.leftMargin,top*this.lineUnit+(this.lineUnit/2),(width+left)*this.colUnit+this.leftMargin,(top+height+1.5)*this.lineUnit+this.topMargin];
//			myLB.bounds=nas.GUI.Grid(left,top,width,height,myLB);
			myLB.labelText =nas.GUI.addEditText(myLB,"",0,.1,width-0.3,1);
		}
/*	旧UI用	*/
if(! newUI){
//リスト用チェックボックス作成
		myLB.display= new Array(myLB.DisplayHeight);
		var boxOffset=(myLB.editable)?1:0;
		for(n=0;n<myLB.DisplayHeight;n++)
		{//チェックボックス作成
			myLB.display[n]=nas.GUI.addCheckBox(myLB,"",0,n+(boxOffset*1.1),width-0.7,1);
			myLB.display[n].value=false;
			myLB.display[n].id=n;
			myLB.display[n].onClick=function(){this.parent.check(this.id);};
//			myLB.display[n].hide();
		};

//表示範囲移動スクロールバー
		myLB.ChgRange=nas.GUI.addScrollBar(myLB,0,0,0,width-1,boxOffset*.9,myLB.DisplayHeight,"right");
//		myLB.ChgRange.viewOffset=0;//スクロールバーのvalueを使用

//初期化兼用 オプション(再)設定
	myLB.setOptions = function (newOptions,newSelected)
	{
		this.options= new Array(newOptions.length);
		this.checks= new Array(newOptions.length);
		for(n=0;n<newOptions.length;n++){
			this.options[n]=newOptions[n];
			this.checks[n]=(newSelected[n])?true:false;
		};

		this.DisplayLines=(this.DisplayHeight<newOptions.length)?this.DisplayHeight:newOptions.length;
		for(n=0;n<this.DisplayHeight;n++)
		{//チェックボックス表示
	if(n < this.DisplayLines)
	{
//		this.display[n].text="\[ "+n+" \] "+this.options[n].toString();
		this.display[n].text=this.options[n].toString();
		this.display[n].value=(this.checks[n])? true:false;
		this.display[n].show();
	}else{
		this.display[n].text="";
		this.display[n].value=false;
		this.display[n].hide();
	}
		}
//value初期値設定
		if(this.multiSelect)
		{
			this.value=new Array();
			this.selected=new Array();
			for(id=0;id<this.checks.length;id++)
			{	if(this.checks[id])
				{
					this.value.push(this.options[id]);
					this.selected.push(id);
				}
			}
			if(myLB.editable){
//選択テキスト表示
				if(this.value.length==0)
				{
					this.labelText.text="<no-selected>";
				}else{
					if(this.value.length==1){this.labelText.text=this.value[0];
					}else{
						this.labelText.text="<<multi-selected>>";
					}
				}
			}
		}else{
			for(id=0;id<this.checks.length;id++)
				{if(this.checks[id]){break;}}
			this.value=(id<this.checks.length)?this.options[id]:null;
			this.selected=(this.value)?id:null;
			if(myLB.editable){
//選択テキスト表示
				this.labelText.text=(this.value)?this.value:"<no-selected>";
			}
		}
//表示範囲移動スクロールバー初期化
		if(this.options.length<this.DisplayLines)
		{
			this.ChgRange.hide();
		}else{
			this.ChgRange.maxvalue=this.options.length-this.DisplayLines;
			this.ChgRange.value=0;//スタートに戻す
			this.ChgRange.show();
		}
	};
}else{
/*	新UI	*/
//設定サイズでリストボックス作成
	//マルチセレクトオプションで分岐//
	if(myLB.multiSelect){
	myLB.listBox=nas.GUI.addListBoxO(myLB,Options,Selected,left,top.height,{'multiselect':true});
	}else{
	myLB.listBox=nas.GUI.addListBoxO(myLB,Options,Selected,left,top.height);
	}
//旧UIと等価のプロパティとメソッドつくる
	myLB.display=myLB.listBox.items;//マッピングしておく?(危険かも)

//新UI用初期化メソッド
	myLB.setOptions	=function(myOptions,mySelected){
		this.listBox=nas.GUI.addListBoxO(this,myOptions,mySelected);
	};
}
//初期化実行
	myLB.setOptions(Options,Selected);
if(! newUI){
//表示範囲移動スクロールバーメソッド
	myLB.ChgRange.onChange=function()
	{
		for(var idx=0;idx<this.parent.DisplayLines;idx++){
		var id=idx+Math.round(this.value);
//		this.parent.display[idx].text="\[ "+id.toString()+" \] "+this.parent.options[id];
		this.parent.display[idx].text=this.parent.options[id];
		this.parent.display[idx].value=this.parent.checks[id];
		}
	}

//チェック動作メソッド
	myLB.check=function(id)
	{
		if(this.multiSelect)
		{//マルチセレクト
			this.checks[id+this.ChgRange.value]=this.display[id].value;//値を更新
			this.value=new Array();
			this.selected=new Array();
			for(idx=0;idx<this.options.length;idx++)
			{
				if(this.checks[idx])
				{
					this.value.push(this.options[idx].toString());
					this.selected.push(idx);
				}
			}
		}else{//シングルセレクト
			var optId = Math.floor(id+this.ChgRange.value);//オプションID
			this.checks[optId]=(this.checks[optId])?false:true;//値更新
//	オプションスキャン
			for(idx=0;idx<this.options.length;idx++)
			{//対象外を更新
				if(idx!=optId){this.checks[idx]=false};
			}
			for(idx=0;idx<this.DisplayLines;idx++)
			{//表示更新
				this.display[idx].value=this.checks[Math.floor(idx+this.ChgRange.value)];
//				this.display[idx].text="\[ "+Math.floor(idx+this.ChgRange.value).toString()+" \] "+this.options[Math.floor(idx+this.ChgRange.value)];
				this.display[idx].text=this.options[Math.floor(idx+this.ChgRange.value)];
			}
			this.value=(this.checks[optId])?this.options[optId].toString():null;//プロパティ更新
			//プロパティ更新
	if(this.checks[optId]){this.selected=optId;}else{this.selected=null;}
		}
		if(myLB.editable){
//	選択テキスト更新
			if(this.multiSelect)
			{
				if(this.value.length==0)
				{
					this.labelText.text="<no-selected>";
				}else{
					if(this.value.length==1){this.labelText.text=this.value[0];
					}else{
						this.labelText.text="<<multi-selected>>";
					}
				}
			}else{
				this.labelText.text=this.value;
			}
		}
//	this.onChange();
	};

	if(myLB.editable){
//エディットボックス変更
		myLB.labelText.onChange=function()
		{
			this.parent.value=this.text;
			for(idx=0;idx<this.parent.checks.length;idx++)
			{	this.parent.checks[idx]=false;	}
			this.parent.selected=null;
			for(idx=0;idx<this.parent.display.length;idx++)
			{	this.parent.display[idx].value=false;	}
			this.onChange();
		}
	}
}else{
/*新UI用*/
//リストボックス変更
	myLB.listBox.onChange=function()
	{
		if(this.multiSelect)
		{//マルチセレクト
			//this.checks[id+this.ChgRange.value]=this.display[id].value;//値を更新
			this.parent.value=new Array();
			this.parent.selected=new Array();
			for(var idx=0;idx<this.selection.length;idx++)
			{
					this.parent.value.push(this.selection[idx].text);
					this.parent.selected.push(this.selection[idx].index);
			}
		}else{//シングルセレクト
			var optId = this.selection[0].index;//オプションID
			this.parent.checks[optId]=(this.parent.checks[optId])?false:true;//値更新
//	オプションスキャン
			for(var idx=0;idx<this.parent.options.length;idx++)
			{//対象外を更新
				if(idx!=optId){this.parent.checks[idx]=false};
			}


			this.value=(this.parent.checks[optId])?this.parent.options[optId].toString():null;//プロパティ更新
			//プロパティ更新
	if(this.parent.checks[optId]){this.parent.selected=optId;}else{this.parent.selected=null;}
		}
		if(myLB.editable){
//	選択テキスト更新
			if(this.multiSelect)
			{
				if(this.value.length==0)
				{
					this.labelText.text="<no-selected>";
				}else{
					if(this.value.length==1){this.labelText.text=this.value[0];
					}else{
						this.labelText.text="<<multi-selected>>";
					}
				}
			}else{
				this.labelText.text=this.value;
			}
		}
	this.onChange();
	};

	if(myLB.editable){

//エディットボックス変更
		myLB.labelText.onChange=function()
		{
			this.parent.value=this.text;
			for(var idx=0;idx<this.parent.checks.length;idx++)
			{	this.parent.checks[idx]=false;	}
			for(var idx=0;idx<this.parent.listBox.items.length;idx++)
			{	this.parent.listBox.items[idx].checked=false;	}
			this.parent.selected=null;
			this.onChange();
		}
	}
}
//リストボックスにonChangeを作成(何もしない。ユーザ側でオーバライドする)
	myLB.onChange=function(){return;};

//設定したリストボックスを返す
return myLB;
}

//複合コントロール TabPanel
//暫定版、現在ウインドウに付き1組のタブ限定です。
//与えられた親エレメントに直接タブを埋めます。
//	戻り値は 選択されているタブID (不要かも？)
//タブ自身を指すオブジェクト（エレメント）がありません。
//タブパネルにアクセスする際は
//	Parent["tabPanel"][id].<property or method> こんな感じで　
//id　は、0からの配列idです。
nas.GUI.setTabPanel = function (Parent,TabNames,left,top,width,height)
{
	if(! TabNames instanceof Array){TabNames=[TabNames];};
//切り換えボタン作成
	Parent.tabSelector=new Array();
	var btw=2;//ボタン幅
		
	for (n=0 ; n < TabNames.length ; n++){

		Parent.tabSelector[n]=nas.GUI.addButton(Parent,TabNames[n],left+(btw*n),top,btw,1);
//		Parent.tabSelector[n]=nas.GUI.addButton(Parent,TabNames[n],1+left+(btw*n),top,btw,1);
		Parent.tabSelector[n].id=n;
		Parent.tabSelector[n].onClick=function(){
	this.parent.selectTab(this.id);
		}
	}

	Parent.tabSelector[0].enabled=false;//セレクト状態？

//タブ用パネル作成
	Parent.tabPanel=new Array();
	for (n=0 ; n < TabNames.length ; n++){
		Parent.tabPanel[n] =
		nas.GUI.addPanel(Parent,"",left,top,width,height);
//		nas.GUI.addPanel(Parent,TabNames[n],left,top,width,height);
//		Parent.tabPanel[n].hide()
	};
//切り換えメソッド設定　0<=id<=this.length 数値のみ
	Parent.selectedTab=0;//タブ選択変数
Parent.selectTab = function(id)
{
	if(isNaN(id)){return false;}
	this.selectedTab=Math.round(Math.abs(id)) % this.tabPanel.length
	for (n=0 ; n < this.tabPanel.length ; n++){
		if(n==id){
		this.tabSelector[n].enabled=false;
		this.tabPanel[n].show();
		}else{
		this.tabSelector[n].enabled=true;
		this.tabPanel[n].hide();
		}
	}
}

Parent.selectTab(0);
//	戻す
return Parent.selectedTab;
}


//配列2つをたばねて操作するオブジェクト セレクトボタン等で結構使うけど…
//	なんかもっと良い方法が有りそうな気もする。が、とりあえず。コンストラクタにしておく
function nTable()
{
//	this.names =new Array();
	this.bodys =new Array();
	this.length =0;//
	this.selected =0;//index
	this.selectedName = "";//第一フィールド
	this.selectedRecord =null;
}

	nTable.prototype.select= function(idx)
	{
		if(!isNaN(idx)){
			this.selected =Math.floor((idx+this.bodys.length)% this.bodys.length);
		}else{
switch(idx){
case "next":	this.selected ++;this.selected = this.selected % this.bodys.length ; break;
case "prev":	this.selected --;this.selected = (this.selected + this.bodys.length) % this.bodys.length ; break;
default :	this.selected=this.selected % this.bodys.length;
}
		}
		this.selectedRecord=this.bodys[this.selected];
		this.selectedName=this.bodys[this.selected][0];
		return this.bodys[this.selected];
	};

	nTable.prototype.names=function(id)
	{
		if(! id)id=0;
		myNames=new Array();
		if(isNaN(id))
		{
			for (ix=0;ix<this.bodys.length;ix++){myNames.push(this.bodys[ix].join("/"));};
		}else{
			for (ix=0;ix<this.bodys.length;ix++){myNames.push(this.bodys[ix][id]);};
		}
		return myNames;
	}

	nTable.prototype.push= function(nAme,bOdy)
	{
		if(!(bOdy instanceof Array)) bOdy=[bOdy];
		this.bodys.push([nAme].concat(bOdy))
		this.length=this.bodys.length;
		this.select(-1);
	}
	nTable.prototype.pop= function()
	{
		this.bodys.pop();
		this.length=this.bodys.length;
//		this.select(this.selected % this.length);
	}
	nTable.prototype.del= function(idx)
	{
		if(this.bodys.length<=1) return false;
		if(idx!=(this.length-1)){
			for(ix=idx;ix<(this.bodys.length-1);ix++)
			{
				this.bodys[ix]=this.bodys[ix+1];
			}
		}
		this.bodys.pop();
		this.length=this.bodys.length;
		this.select();
	}

	nTable.prototype.change= function(nAme,bOdy,idx)
	{
		if(!(bOdy instanceof Array)) bOdy=[bOdy];
		idx=idx % this.length;
		this.bodys[idx]=[nAme].concat(bOdy);
		this.select(idx);
	}

/*
 *	リストボックス形式でオプションを選択する
 *		汎用的に利用　ウソ代用リストボックスおよびコンボボックスから呼び出し。
 * 		さらに一般呼出も可能
 * nas.GUI.selectOptions(オプションリスト,[選択ID[,ダイアログ位置左,上[,ダイアログ幅,ダイアログ行数]]])
 * nas.GUI.selectOptions(オプションリスト,[選択ID[,ボタンオブジェクト[,ダイアログ行数]])
 *		第二形式の場合は、ボタンオブジェクトの幅と位置を継承します。
 *
 * 	戻り値は選択されたオプションID オプションリストは、要素数2以上の配列
 *
 */
if(true){

nas.GUI.selectOptions = function(options,selectedId,left,top,width,lines)
{
//第一引数が配列でない、または配列であっても要素数が1の場合はfalseを返して終了
	if(!(options instanceof Array) || (options.length<2)){return false;};
//引数の事前処理
//	第三引数がButtonオブジェクトだった場合は、GUIオブジェクトから位置と幅を取得
//	その場合、第四引数が表示行数
	if(left instanceof Button){
		var myButton=left;
		var myLocation=nas.GUI.screenLocation(myButton);//スクリーン位置取得
		lines	=top;//入れ替え
		width	=myButton.bounds.width/nas.GUI.colUnit;//幅を列数で取得
		top	=myLocation[1];
		left	=myLocation[0];
	}

	left	=(left)? left:-1;
	top	=(top)? top:-1;

	if (isNaN(selectedId)||(selectedId>=options.length)||(selectedId<0)) {selectedId=null;};

//ダイアログ作成 以前のダイアログがあった場合は無条件で削除

if(nas.GUI.optionSelector){
	if(nas.GUI.optionSelector.visible){nas.GUI.optionSelector.close();}
	delete nas.GUI.optionSelector;
};
	var winName=options[selectedId];
	nas.GUI.optionSelector	=new Window("dialog",winName,[0,0,100,100]);//仮のバウンズで初期化

	nas.GUI.optionSelector.options	=options;
	nas.GUI.optionSelector.selected	=selectedId;
	nas.GUI.optionSelector.maxLines	=(lines)?lines:7;//セレクタ高さ
	nas.GUI.optionSelector.Width	=(width)?width:2;//セレクトボタン幅
//	nas.GUI.optionSelector.selector=new Array();//セレクトボタン格納配列(後で初期化する)
	nas.GUI.optionSelector.init=function()
	{
		//	セレクタのサイズはオプション数がmaxLines以下ならオプション数
		//	それ以上の場合はmaxLinseでスクロールバーを追加(オプション数1以下は論外)
		this.displayLines=(this.options.length<this.maxLines)?this.options.length:this.maxLines;
		this.selector=new Array();
//プラットフォーム別にボタンつくる
		for (var idx=0;idx<this.displayLines;idx++)
		{
			if(isWindows){
var appleOffset=0;
				this.selector[idx]=this.add("button",[0,idx*nas.GUI.lineUnit,this.Width*nas.GUI.colUnit,(idx+1)*nas.GUI.lineUnit],this.options[idx]);
			}else{
var appleOffset=12;//どうすれ、ばいんだー
				this.selector[idx]=this.add("button",nas.GUI.Grid(0,idx+appleOffset/nas.GUI.lineUnit,this.Width,1,this),
					this.options[idx]);
			}
//
			this.selector[idx].id=idx;
			if(idx==this.selected){
				this.selector[idx].text ="* "+this.selector[idx].text +" *";
				//this.selector[idx].justify="left";
			};
			this.selector[idx].onClick=function(){this.parent.selected=this.id;this.parent.close();};
		}
//	ウィンドウのサイズをボタンサイズにフィット
		this.bounds.width	=this.Width*nas.GUI.colUnit;
		this.bounds.height	=(this.displayLines*nas.GUI.lineUnit)+appleOffset;
//	選択アイテムが表示行数を超過した場合のみセレクタにスクロールバーを設置
		if(this.displayLines<this.options.length)
		{
//	スクロールバーバウンズ
		barBounds=[
			this.bounds.width+appleOffset,
			0,
			this.bounds.width+(nas.GUI.lineUnit/2)+appleOffset,
			this.bounds.height,
		];
//	バウンズを拡張
		this.bounds.width+=(nas.GUI.lineUnit/2)+appleOffset;
//	スクロールバー設置
		this.chgRange=this.add(
			"scrollbar",
			barBounds,
			0,
			0,
			this.options.length-this.displayLines
		);
//	変更メソッド
			this.chgRange.onChange=function()
			{
//alert(this.parent.selected+" / "+this.parent.options[this.parent.selected])
				for(idx=0;idx<this.parent.displayLines;idx++){

				var myIdx=idx+Math.round(this.value);//id設定ループインデックス+スクロール量
//	if (this.parent.selector[idx].id==this.parent.selected){this.parent.selector[idx].justify="center";};
if(myIdx == this.parent.selected){
	this.parent.selector[idx].text="* "+this.parent.options[myIdx]+" *";
}else{
	this.parent.selector[idx].text=this.parent.options[myIdx];
}
//if (this.parent.selector[idx].id==this.parent.selected){this.parent.selector[idx].text="* "+this.parent.selector[idx].text+" *";};
				this.parent.selector[idx].id=myIdx;
//	if (this.parent.selector[idx].id==this.parent.selected){this.parent.selector[idx].justify="left";};
				}
				this.value=Math.round(this.value);//this.value=Math.floor(this.value);
			}
		}
	}
//	ダイアログを表示
	nas.GUI.optionSelector.bounds.left	= left;
	nas.GUI.optionSelector.bounds.top	= top+22;

	nas.GUI.optionSelector.init();
//	if(nas.GUI.optionSelector.chgRange)nas.GUI.optionSelector.chgRange.onChange();
//	nas.GUI.optionSelector.text=nas.GUI.optionSelector.options[nas.GUI.optionSelector.selected].toString();
	nas.GUI.optionSelector.onShow=function(){this.selector[0].active=true;};
if(left<0 || top<0)nas.GUI.optionSelector.center(); //
	nas.GUI.optionSelector.show();
	return nas.GUI.optionSelector.selected;

};
}
