/*コンポからXPSを生成する手順

１
CompItem.getRootXPS()を実行してストア内のXPSを取得する

2
なかった場合は、レイヤを全チェック
TimeRemap不能　＞放置
TimeRemap可能
	＞すでにタイムリマップデータがある(有効)
		タイムラインを組んでXPSにエントリ
	＞ない(無効)
		意図的に無効になっているケースが多いはずなので、エントリしないで放置か
		ここで有効化することを期待されるケースもあるはずなので有効にしてエントリするか…　考えどころ
		アプリケーションの動作オプションにする。
		デフォルトはユーザに問い合わせConfirmでよさげ

モーダルダイアログにするか　はたまたパレットにするか？
パレットで編集しながらプレビューしたいはずなのでパレット

ただしフォーカスが外れると問題あるので
パレットにする場合はターゲットコンポの確認が必須

セレクタ必要？
セレクタ操作ごとに初期化が入るのでフールトラップも必要
面倒くさい

書き起こしメソッド
AVLayer.getTimeLine()
AVLayer.toString("timeline")
どっちが良いか思案しろ

*/
//タイムリマップの値からタイムラインを作る際に、リマップのキーを参照してはいけない
//キー値を参照するとキーの保持方式の判定とカラセルの保持方式が問題になるのでそこは見ないで処置すること
/*
コンポを時間軸方向に走査して値からタイムラインを再生すること
取得時のエクスプレッションは有効であること
再適用時は元の構造は保障されない
Ｐｒｏｐｅｒｔｙオブジェクトのメソッドとして実装すると親のAVレイヤが参照しづらいのでレイヤのプロパティとして実装する
タイミング・ジオメトリなどの指定が必要
結構巨大なメソッドになりそう　やだなあ
*/
AVLayer.prototype.getTL=function(myPrp){
//とりあえずタイミングで実装試験
var myTimeLine=new TimeLine();
var previewValue=-1;//負数およびフッテージ長以上の値をカラとする。コンポ内のカラはCS3以降の変更に合わせてフッテージ長に
for(var frId=0;frId<Math.floor(this.containingComp.duration/this.containingComp.frameDuration);frId++){
	var myValue=Math.floor(this.timeRemap.valueAtTime(frId*this.source.frameDuration,false)/this.source.frameDuration);//時間値をフレームに変換する
//	var myValue=this.property("timeRemap").valueAtTime();
	//実質上単純な切捨てだと低頻度ではあるが、フレームズレを起す　ここの判定は要見直し実用性はある　一応
	if((myValue>=Math.floor(this.source.duration/this.source.frameDuration))||(myValue<0)){myValue="blank"}else{myValue=myValue+1}
	if(myValue!=previewValue){
		myTimeLine.setKeyFrame(new KeyFrame(frId,myValue));
//		myTimeLine.push(new KeyFrame(frId,myValue));
		previewValue=myValue;}
nas.otome.writeConsole(">>>>>>"+frId+":"+myValue)
}
return myTimeLine;
}

/*	CompItem.stractXps(myOption)
引数	オプション文字列　"all","seq"　または省略
戻値	Xps or false
コンポからXPSオブジェクトを構築して返すメソッド
引数で動作が変化する
"all"	を指定するとタイムリマップ不能なレイヤをプリコンポーズして全てのレイヤをリマップ有効な状態にしたうえで相当分のXPSを戻す
"seq"	は全てのタイムリマップ可能なレイヤを有効にして相当分のXPSを返す
省略時は現在タイムリマップが有効になっているレイヤのみのXPSを返す

シート変換可能なレイヤがない場合はfalse
ただし、判定に先立ってgetRootXps()を実行して、該当するシートが存在した場合はそのシートヲを使用するように推奨される。
*/
CompItem.prototype.structXps=function(myOption)
{
//オプションがあればコンポ内のタイムリマップ不能なレイヤをプリコンポする
	if(myOptions=="all"){
		for(var lIdx=1;lIdx<=this.layers.length;lIdx++)
		{
			if(!(this.layers[lIdx].canSetTimeRemapEnabled))
			{
				var orgName=this.layers[lIdx].name;
				this.layers.precompose([lIdx],nas.biteClip("preComp_"+orgName),true);
				if(this.layers[lIdx].name!=orgName){this.layers[lIdx].name=orgName};//レイヤ名のみ元の名前に戻す
			}
		}
	}
//オプションがあればタイムリマップが適用可能でかつ有効になっていないレイヤのタイムリマップを有効にする
	if((myOptions=="seql")||(myOptions=="all")){
		for(var lIdx=1;lIdx<=this.layers.length;lIdx++)
		{
			if((this.layers[lIdx].canSetTimeRemapEnabled)&&(!(this.layers[lIdx].timeRemapEnabled)))
			{
				this.layers[lIdx].timeRemapEnabled=true;
				//ついでに固定エクスプレッションを打ち込んでキーをスタート分の１個にキーの値は「カラ」で初期化する
				if(this.layers[lIdx].timeRemap.numKeys==2)
				{
					this.layers[lIdx].timeRemap.setValueAtKey(1,this.layers[lIdx].source.duration);
					this.layers[lIdx].timeRemap.removeKey(2);
				}
				if(this.layers[lIdx].timeRemap.expression=="")
				{
					this.layers[lIdx].timeRemap.expression="if(numKeys){if(nearestKey(time).time<=time){ix=nearestKey(time).index;}else{ix=(nearestKey(time).index==1)?1:nearestKey(time).index-1;};key(ix).value;}else{timeRemap}"
				}
				if(!(this.layers[lIdx].timeRemap.expressionEnabled)){
					this.layers[lIdx].timeRemap.expressionEnabled=true;
				}
			}
		}
	}
//ここまで下準備　タイムリマップが適用可能でかつ有効なレイヤからタイムラインを取得してＸＰＳに仕立てて返す
	var myConvertCount=new Array();
//必要情報収集（可能性としてシートが生成できないことがある=変換レイヤがない）
	for(var lIdx=1;lIdx<=this.layers.length;lIdx++)
	{
		if((this.layers[lIdx].canSetTimeRemapEnabled)&&(this.layers[lIdx].timeRemapEnabled))
		{
			myConvertCount.push(lIdx);
		}
	}
//
	if(myConvertCount.length)
	{
		var myXPS=new Xps(myConvertCount.length,Math.floor(this.duration/this.frameDuartion));
		//XPSに情報を設定
		myXPS.mapfile	=	"";
		myXPS.opus	=	"";
		myXPS.title	=	nas.workTitles.selectedRecord[0];
		myXPS.subtitle	=	"";
		myXPS.scene	=	"";
		myXPS.cut	=	this.name.replace(/\s/g,"_");//レイヤ名
		
		myXPS.trin	=	[0,"trin"];
		myXPS.trout	=	[0,"trout"];
		myXPS.framerate	=	this.frameRate;
			var Now= new Date();
		myXPS.create_time	=	Now.toNASString();
		myXPS.create_user	=	myName;
		myXPS.update_time	=	"";
		myXPS.update_user	=	myName;
		myXPS.memo="convert from AE Composition"
//レイヤ設定
		for(var id=0;id<myConvertCount.length;id++)
		{
//下から順にコンバートするので逆順のID取得
			var myLayerId=myConvertCount[myConvertCount.length-id-1];

			var name	="ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(id);

			myXPS["layers"][id]["name"]	=this.layers[myLayerId].name;
			myXPS["layers"][id]["sizeX"]	=this.layers[myLayerId].width;
			myXPS["layers"][id]["sizeY"]	=this.layers[myLayerId].height;
			myXPS["layers"][id]["aspect"]	=this.layers[myLayerId].pixelAspect;
			myXPS["layers"][id]["lot"]	="auto";
			myXPS["layers"][id]["blmtd"]	="file"	;
			myXPS["layers"][id]["blpos"]	="end"	;
			myXPS["layers"][id]["option"]	="timing"	;
			myXPS["layers"][id]["link"]	="."	;
//本体シートテーブル記入
			var previewValue=-1;//負数およびフッテージ長以上の値をカラとする。コンポ内のカラはCS3以降の変更に合わせてフッテージ長に
			for(var frm=0;frm<myXPS.duration();frm++)
			{
				var myValue=Math.floor(this.layers[myLayerId].timeRemap.valueAtTime(frm*this.frameDuration,false)/this.layers[myLayerId].source.frameDuration);//時間値をフレームに変換する
	//実質上単純な切捨てだと低頻度ではあるが、フレームズレを起す　ここの判定は要見直し実用性はある　要注意
				if((myValue>=Math.floor(this.layers[myLayerId].source.duration/this.layers[myLayerId].source.frameDuration))||(myValue<0))
				{
					myValue="X";//カラ
				}else{
					myValue=myValue+1;//カラ以外は１加えて動画番号生成
				}
				if(myValue!=previewValue)
				{
					myXPS.xpsBody[id+1][frm]=myValue;
					previewValue=myValue;
				}
					nas.otome.writeConsole(">>>>>>"+this.layers[myLayerId].name+" - "+frm+":"+myXPS.xpsBody[id+1][frm])
			}
		}
		return myXPS;
	}else{
		return false;//シート変換するべきレイヤがないのでfalseを返す
	}
}



